package org.jboss.as.clustering.infinispan.cs.factory;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

/**
 * Internal promise implementation using FutureTask's internal mechanism (set method).
 * @param <V> Type.
 */
class Promise<V> extends FutureTask<V> {

    private static class EndlessCallable<V> implements Callable<V> {

        @Override
        public V call() throws Exception {
            throw new UnsupportedOperationException("Executing this method is prohibited");
        }
    }

    Promise() {
        super(new EndlessCallable<V>());
    }

    public void complete(V completeValue) {
        set(completeValue);
    }
}
