using System;

namespace Infinispan.HotRod.SWIG
{
    internal interface ConfigurationBuilder
    {
        Configuration Create();
        ServerConfigurationBuilder AddServer();
        ClusterConfigurationBuilder AddCluster(string clusterName);
        ConnectionPoolConfigurationBuilder ConnectionPool();
        SslConfigurationBuilder Ssl();
        NearCacheConfigurationBuilder NearCache();

        void validate();
        ConfigurationBuilder AddServers(string serverList);
        ConfigurationBuilder ConnectionTimeout(int connectionTimeout);
        ConfigurationBuilder ForceReturnValues(bool forceReturnValues);
        ConfigurationBuilder KeySizeEstimate(int keySizeEstimate);
        ConfigurationBuilder ProtocolVersion(string protocolVersion);
        ConfigurationBuilder SocketTimeout(int socketTimeout);
        ConfigurationBuilder TcpNoDelay(bool tcpNoDelay);
        ConfigurationBuilder ValueSizeEstimate(int valueSizeEstimate);
        ConfigurationBuilder MaxRetries(int maxRetries);
    }
}
