package org.infinispan.persistence.jpa.entity;

import javax.persistence.Entity;
import javax.persistence.Id;

import org.infinispan.protostream.annotations.ProtoField;

/**
 *
 * @author <a href="mailto:rtsang@redhat.com">Ray Tsang</a>
 *
 */
@Entity
public class Document {

   @Id
   private String name;
   private String title;
   private String article;

   @ProtoField(1)
   public String getName() {
      return name;
   }

   public void setName(String name) {
      this.name = name;
   }

   @ProtoField(2)
   public String getTitle() {
      return title;
   }

   public void setTitle(String title) {
      this.title = title;
   }

   @ProtoField(3)
   public String getArticle() {
      return article;
   }

   public void setArticle(String article) {
      this.article = article;
   }

   @Override
   public int hashCode() {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((article == null) ? 0 : article.hashCode());
      result = prime * result + ((name == null) ? 0 : name.hashCode());
      result = prime * result + ((title == null) ? 0 : title.hashCode());
      return result;
   }

   @Override
   public boolean equals(Object obj) {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      Document other = (Document) obj;
      if (article == null) {
         if (other.article != null)
            return false;
      } else if (!article.equals(other.article))
         return false;
      if (name == null) {
         if (other.name != null)
            return false;
      } else if (!name.equals(other.name))
         return false;
      if (title == null) {
         if (other.title != null)
            return false;
      } else if (!title.equals(other.title))
         return false;
      return true;
   }

   @Override
   public String toString() {
      return "Document [name=" + name + ", title=" + title + ", article="
            + article + "]";
   }
}
