import logging
import os
from logging import handlers
DEFAULT_LOG_FILE="C:\\Program Files\\RedHat\\RHEV\\Drivers\\Agent\\log\\RHEV-Agent.log"


def initLogging(file_name=DEFAULT_LOG_FILE):
    if not os.path.isdir(os.path.dirname(file_name)):
        os.makedirs(os.path.dirname(file_name))
    level = logging.INFO
    if os.environ.has_key('QAGENT_DEBUG'):
        level = logging.DEBUG
    hdlr = handlers.RotatingFileHandler(filename = file_name,
                                        mode='a',
                                        maxBytes=10*1024*1024,
                                        backupCount=3)
    fmts='%(asctime)s %(name)-12s %(levelname)-8s %(message)s'
    dfmt='%Y-%m-%d %H:%M:%S'
    fmt = logging.Formatter(fmts, dfmt)
    hdlr.setFormatter(fmt)
    logging.root.addHandler(hdlr)
    logging.root.setLevel(level)
    logInit = True





