// USBFilterEditorDlg.h : header file
//

#pragma once

// CUSBFilterEditorDlg dialog

class CUSBFilterEditorDlg : public CDialog
{
public:

    enum { IDD = IDD_USBFILTEREDITOR_DIALOG };

	CUSBFilterEditorDlg(CWnd* pParent = NULL);

protected:

    DECLARE_MESSAGE_MAP()
	
    afx_msg void OnClose();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
    afx_msg void OnHelpAbout();
    afx_msg void OnFileExit();
    afx_msg void OnFileSave();
    afx_msg void OnBnClickedButtonAdd();
    afx_msg void OnBnClickedButtonExport();
    afx_msg void OnBnClickedButtonImport();
    afx_msg void OnBnClickedButtonUp();
    afx_msg void OnBnClickedButtonDown();
    afx_msg void OnBnClickedButtonEdit();
    afx_msg void OnBnClickedButtonRemove();
    afx_msg void OnBnClickedButtonSearch();
    afx_msg void OnItemActivateListCriterias(NMHDR *pNMHDR, LRESULT *pResult);
    afx_msg void OnNMRclickListCriterias(NMHDR *pNMHDR, LRESULT *pResult);

    virtual void DoDataExchange(CDataExchange *pDX);	// DDX/DDV support
    virtual BOOL PreTranslateMessage(MSG* pMsg);
    virtual BOOL DestroyWindow();
    virtual BOOL OnInitDialog();

private:

    void ExportCriterias(const CString& sFileName);
    void ImportCriterias(const CString& sFileName);
    void LoadCriterias();
    void StoreCriterias();
    void DeleteCriteria(int nItem);
    void DeleteAllCriterias();
    void InsertCriteria(int nItem, LPCSTR szCriteria);
    void InsertCriteria(int nItem, int nClass, int nVendor, int nProduct, int nRevision, int nAction);
    void InsertCriteria(int nItem,
        int nClass, int nVendor, int nProduct, int nRevision, int nAction,
        LPCTSTR szClass, LPCTSTR szVendor, LPCTSTR szProduct);
    void MoveCriteria(int nItem, int nStep);
    void UpdateButtons(int nItem);

private:

    HICON m_hIcon;
    HACCEL m_hAccelTable;

    bool m_bModified;
};
