// USBFilterEditor.cpp : Defines the class behaviors for the application.
//

#include "StdAfx.h"

#include "sqlite3.h"

#include "USBFilterEditor.h"
#include "USBFilterEditorDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// The one and only CUSBFilterEditorApp object
CUSBFilterEditorApp theApp;

// CUSBFilterEditorApp

BEGIN_MESSAGE_MAP(CUSBFilterEditorApp, CWinApp)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
    ON_COMMAND(ID_FILE_NEW, &CUSBFilterEditorApp::OnFileNew)
    ON_COMMAND(ID_FILE_OPEN, &CUSBFilterEditorApp::OnFileOpen)
    ON_COMMAND(ID_FILE_CLOSE, &CUSBFilterEditorApp::OnFileClose)
END_MESSAGE_MAP()

// CUSBFilterEditorApp construction

CUSBFilterEditorApp::CUSBFilterEditorApp() :
    m_pEditorDb(NULL)
{

}

CUSBFilterEditorApp::~CUSBFilterEditorApp()
{

}

// CUSBFilterEditorApp initialization

BOOL CUSBFilterEditorApp::InitInstance()
{
	// InitCommonControlsEx() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Set this to include all the common control classes you want to use
	// in your application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp::InitInstance();

	AfxEnableControlContainer();

    if (sqlite3_open_v2("UsbFilterEditor.db", &m_pEditorDb, SQLITE_OPEN_READWRITE, NULL) != SQLITE_OK)
    {
        MessageBox(HWND_DESKTOP,
            _T("Unable to open internal database file.\nReinstalling application might solve this problem."),
            _T("Usb Filter Editor"),
            MB_OK | MB_ICONHAND);
        
        return FALSE;
    }

    ASSERT(m_pEditorDb != NULL);

	CUSBFilterEditorDlg dlg;
	m_pMainWnd = &dlg;

	INT_PTR nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

int CUSBFilterEditorApp::ExitInstance()
{
    CloseDataBase();

    return 0;
}

void CUSBFilterEditorApp::OnFileNew()
{
    OnFileOpen();
}

void CUSBFilterEditorApp::OnFileOpen()
{
    CFileDialog dlg(TRUE, _T(".db"), NULL,
        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT | OFN_EXPLORER,
        _T("SQLite 3 Database (*.db)|*.db||"));

    if (dlg.DoModal() == IDOK)
    {
        OpenDatabase(dlg.GetFileName());
    }
}

void CUSBFilterEditorApp::OpenDatabase(const CString& sFileName)
{

}

void CUSBFilterEditorApp::CloseDataBase()
{
    if (m_pEditorDb != NULL)
    {
        sqlite3_close(m_pEditorDb);
        m_pEditorDb = NULL;
    }
}

void CUSBFilterEditorApp::OnFileClose()
{
    CloseDataBase();
}
