
#include "StdAfx.h"

#include <cstdio>
#include <iostream>

#include "DevRule.h"

int main(int argc, char* argv[])
{
    int result = 2; // An error.

    if (argc > 1)
    {
        const char* cmd = argv[1];
        const char* dev = (argc > 2) ? argv[2] : NULL;

        if (lstrcmp(cmd, "disable") == 0)
        {
            result = DisableDevice(dev);
        }
        else if (lstrcmp(cmd, "enable") == 0)
        {
            result = EnableDevice(dev);
        }
        else if (lstrcmp(cmd, "exist") == 0)
        {
            result = IsDeviceExist(dev);
        }
        else if (lstrcmp(cmd, "rescan") == 0)
        {
            result = RescanDevices();
        }
        else
        {
            std::cerr << "Unknown command " << cmd << std::endl;
        }
    }
    else
    {
        std::cout << "RunDevRule.exe disable|enable|exist|rescan pci" << std::endl;
    }

    return result;
}
