#ifndef _USB_SERVER_API_
#define _USB_SERVER_API_

#include <semaphore.h>
#include "nettypes.h"
#include "srverr.h"

#define CONNECTION_MODE_MASK	0x01
#define NORMAL_MODE		0x00
#define AUTO_MODE		0x01

#define	UsbDevice				0x00
#define UsbDeviceUnknown		0x01
#define	UsbDeviceInit			0x02
#define	UsbDeviceAvailable		0x03
#define UsbDeviceBusy			0x04
#define	UsbDeviceNotPlugged		0x05
#define UsbDeviceConnected		0x06
#define UsbDeviceDisconnected	0x07
#define UsbDeviceNotAvailable	0x08
#define UsbDeviceInactive		0x09

#define AutoPlugDevice			0x01
#define ExcludeDevice			0x02
#define UseInactiveTimeout		0x04
#define SharedDevice			0x08
#define SerialNumberPresent		0x10
#define NickNamePresent			0x20

#define ServerConnected			0x00
#define ServerDisconnected		0x01
#define ServerInBlackList		0x02
#define ServerPlatformConflict		0x03
#define	ServerVersionConflict		0x04
#define ServerPoolFull			0x05

#define windows_2k			0x50
#define windows_xp			0x51
#define windows_2k3			0x52
#define windows_vista			0x53
#define windows_2k8			0x54
#define windows_7			0x55
#define windows_2k8_r2		0x56

#define windows_xp_64			0x70
#define windows_2k3_64			0x71
#define windows_vista_64		0x72
#define windows_2k8_64			0x73
#define windows_7_64		0x74
#define windows_2k8_r2_64	0x75

#define linux32				0x90
#define linux_be		0x91

typedef struct _taghardwareid {
	uint16 VendorId;
	uint16 ProductId;
	uint16 Revision;
} __attribute__((packed)) HARDWAREID, *PHARDWAREID;

typedef struct _tagusbdevinterface {
	uint8 DeviceClass;
	uint8 DeviceSubClass;
	uint8 DeviceProtocol;
} __attribute__((packed)) USBDEVINTERFACE, *PUSBDEVINTERFACE;

typedef struct _tagserverdescriptor {

	uint32 hServer;
	uint32 ulStatus;
	uint32 ulProperties;
	uint32 ulPlatform;
	uint16	tcpport;
	uint32 ulIpInterface;
	char cHostName[256];
	
} __attribute__((packed)) SERVER_DESCRIPTOR, *PSERVER_DESCRIPTOR;

typedef struct _tagusbdevdescriptor {
	uint32 hDevice;
	uint32 hServer;
	uint32 ulDeviceStatus;
	uint32 ulDeviceProperties;
	uint32 ulIpClient;
	uint32 ulInactiveTimeout;
	HARDWAREID hwid;
	USBDEVINTERFACE zero_iface;
	char cLocationInformation[256];
	char cDeviceDescription[256];
	char cInstanceId[256];
	char cNickName[256];
} __attribute__((packed)) DEVICE_DESCRIPTOR, *PDEVICE_DESCRIPTOR;

unsigned long
InitUsbRedirectorApi(void);

unsigned long
DeInitUsbRedirectorApi(void);

unsigned long
GetUSBRedirectorLastError(unsigned long *lpulArg1);

unsigned long
SetNotificationEvent(sem_t *sem);

unsigned long
GetUSBServerDescriptor(uint32 hServer, SERVER_DESCRIPTOR *lpDescriptor);

unsigned long
EnumConnectedClients(SERVER_DESCRIPTOR *lpDescriptor, uint32 *lpulSize);

unsigned long
EnumLocalUSBDevices(DEVICE_DESCRIPTOR *lpDescriptor, uint32 *lpulSize);

unsigned long
ShareUSBDevice(uint32 hDevice);

unsigned long
StopSharingUSBDevice(uint32 hDevice);

unsigned long
ConnectUSBDeviceToClient(uint32 hDevice, uint32 hClient);

unsigned long
DisconnectUSBDeviceFromClient(uint32 hDevice);

unsigned long
GetUSBDeviceDescriptor(uint32 hDevice, DEVICE_DESCRIPTOR *lpDeviceDescriptor);

unsigned long
ChangeNetworkProperties(uint16 tcpport);

unsigned long
CreateCallBackConnectionToUsbClient(const char *lpHostName, uint16 uTcpPort, uint32 *lpCallBackHandle);

unsigned long
CloseCallBackConnectionToUsbClient(uint32 hCallBackHandle);

unsigned long
EnumCallBackConnectionsToUsbClients(SERVER_DESCRIPTOR *lpDescriptor, uint32 *lpulSize);

unsigned long
AddUSBDeviceToExclusionList(uint32 hServer, uint32 hDevice);

unsigned long
RemoveUSBDeviceFromExclusionList(uint32 hServer, uint32 hDevice);

unsigned long
ChangeUSBServerProperties(uint32 hServer, uint32 ulProperties);

#endif // #ifndef _USB_SERVER_API_
