#ifndef _USB_REDIRECTOR_APIDEF_H_
#define _USB_REDIRECTOR_APIDEF_H_

#include "nettypes.h"

#ifdef USBRDRAPI_EXPORTS
#define USBRDR_API __declspec(dllexport)
#else
#define USBRDR_API __declspec(dllimport)
#endif

/*
	Server properties

	bit0 - device connection mode (normal or auto)
	bit1 - callback enabled
	bit2 - ip filters enabled
	bit3 - ip filters mode (only deny/only allow)
*/
#define CONNECTION_MODE_MASK	0x01
#define NORMAL_MODE				0x00
#define AUTO_MODE				0x01

#define CALLBACK_MODE			CALLBACK_ENABLED
#define CALLBACK_ENABLED		0x02

#define IPFILTER_DISABLED		0x04

#define IPFILTER_MODE_MASK		0x08
#define IPFILTER_ONLY_DENY		0x00
#define IPFILTER_ONLY_ALLOW		0x08
#define RDP_CLIENT			0x10

/*
	Device properties
*/
#define AutoPlugDevice			0x01
#define ExcludeDevice			0x02
#define UseInactiveTimeout		0x04
#define SharedDevice			0x08
#define SerialNumberPresent		0x10
#define NickNamePresent			0x20

#define ServerConnected			0x00
#define ServerDisconnected		0x01
#define ServerInBlackList		0x02
#define ServerPlatformConflict	0x03
#define	ServerVersionConflict	0x04
#define ServerPoolFull			0x05

#define windows_2k				0x50
#define windows_xp				0x51
#define windows_2k3				0x52
#define windows_vista			0x53

#define windows_xp_64			0x70
#define windows_2k3_64			0x71
#define windows_vista_64		0x72

#define linux					0x90

#define	UsbDevice				0x00
#define UsbDeviceUnknown		0x01
#define	UsbDeviceInit			0x02
#define	UsbDeviceAvailable		0x03
#define UsbDeviceBusy			0x04
#define	UsbDeviceNotPlugged		0x05
#define UsbDeviceConnected		0x06
#define UsbDeviceDisconnected	0x07
#define UsbDeviceNotAvailable	0x08
#define UsbDeviceInactive		0x09

#define MaxUSBServersValue		0x40

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

typedef struct _HARDWAREID {

	uint16 VendorId;
	uint16 ProductId;
	uint16 Revision;

} HARDWAREID, *PHARDWAREID;

typedef struct _USBDEVINTERFACE {
	
	uint8 DeviceClass;
	uint8 DeviceSubClass;
	uint8 DeviceProtocol;

} USBDEVINTERFACE, *PUSBDEVINTERFACE;

typedef struct _SERVER_DESCRIPTOR {

	uint32	hServer;
	uint32	ulStatus;
	uint32	ulProperties;
	uint32	ulPlatform;
	uint16	tcpport;
	uint32   ulIpInterface;
	char	cHostName[256];
	
} SERVER_DESCRIPTOR, *PSERVER_DESCRIPTOR;

typedef struct _DEVICE_DESCRIPTOR {

	uint32		hDevice;
	uint32		hServer;
	uint32		ulDeviceStatus;
	uint32		ulDeviceProperties;
	uint32		ulIpClient;
	uint32		ulInactiveTimeout;
	HARDWAREID	hwid;
	USBDEVINTERFACE zero_iface;
	char		cLocationInformation[256];
	char		cDeviceDescription[256];
	char		cInstanceId[200];
	char		cNickName[256];

} DEVICE_DESCRIPTOR, *PDEVICE_DESCRIPTOR;

#ifdef __cplusplus
}
#endif // __cplusplus

#endif //_USB_REDIRECTOR_APIDEF_H_