@ECHO OFF

REM
REM Build SpiceX.cab file script.
REM 
REM %1 = $(OutDir)
REM %2 = $(ConfigurationName)
REM %3 = $(PlatformName)
REM

if not defined REDC_BUILD_DIR set REDC_BUILD_DIR=..\red\windows

if "%3" == "Win32" (
set LIB=lib
set CAB=SpiceX_x86.cab
) else if "%3" == "x64" (
set LIB=lib64
set CAB=SpiceX_x64.cab
)

echo LIB=%LIB%
echo CAB=%CAB%

if "%2" == "Release" (
set CELTDLL=%SPICE_LIBS%\%LIB%\libcelt_0_5_1.dll
) else if "%2" == "Debug" (
set CELTDLL=%SPICE_LIBS%\%LIB%\libcelt_0_5_1D.dll
)
echo %CELTDLL%

del %1\%CAB%
SignTool sign /s MY /n "Red Hat, Inc." /t http://timestamp.verisign.com/scripts/timstamp.dll %1\SpiceX.dll
MakeCab /F SpiceX.ddf /D DiskDirectory1=%1 /D CabinetName1=%CAB% ^
  /D file1=%1\SpiceX.dll /D file2=%CELTDLL% /D file3=%REDC_BUILD_DIR%\%1\spicec.exe /D file4=SpiceX.inf
SignTool sign /s MY /n "Red Hat, Inc." /t http://timestamp.verisign.com/scripts/timstamp.dll %1\%CAB%
