// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/common/ad_type_infos.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v0/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A text ad.
type TextAdInfo struct {
	// The headline of the ad.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2         *wrappers.StringValue `protobuf:"bytes,3,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TextAdInfo) Reset()         { *m = TextAdInfo{} }
func (m *TextAdInfo) String() string { return proto.CompactTextString(m) }
func (*TextAdInfo) ProtoMessage()    {}
func (*TextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{0}
}
func (m *TextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAdInfo.Unmarshal(m, b)
}
func (m *TextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAdInfo.Marshal(b, m, deterministic)
}
func (dst *TextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAdInfo.Merge(dst, src)
}
func (m *TextAdInfo) XXX_Size() int {
	return xxx_messageInfo_TextAdInfo.Size(m)
}
func (m *TextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TextAdInfo proto.InternalMessageInfo

func (m *TextAdInfo) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *TextAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *TextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// An expanded text ad.
type ExpandedTextAdInfo struct {
	// The first part of the ad's headline.
	HeadlinePart1 *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline_part1,json=headlinePart1,proto3" json:"headline_part1,omitempty"`
	// The second part of the ad's headline.
	HeadlinePart2 *wrappers.StringValue `protobuf:"bytes,2,opt,name=headline_part2,json=headlinePart2,proto3" json:"headline_part2,omitempty"`
	// The third part of the ad's headline.
	HeadlinePart3 *wrappers.StringValue `protobuf:"bytes,6,opt,name=headline_part3,json=headlinePart3,proto3" json:"headline_part3,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The second description of the ad.
	Description2 *wrappers.StringValue `protobuf:"bytes,7,opt,name=description2,proto3" json:"description2,omitempty"`
	// The text that can appear alongside the ad's displayed URL.
	Path1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=path1,proto3" json:"path1,omitempty"`
	// Additional text that can appear alongside the ad's displayed URL.
	Path2                *wrappers.StringValue `protobuf:"bytes,5,opt,name=path2,proto3" json:"path2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedTextAdInfo) Reset()         { *m = ExpandedTextAdInfo{} }
func (m *ExpandedTextAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedTextAdInfo) ProtoMessage()    {}
func (*ExpandedTextAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{1}
}
func (m *ExpandedTextAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedTextAdInfo.Unmarshal(m, b)
}
func (m *ExpandedTextAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedTextAdInfo.Marshal(b, m, deterministic)
}
func (dst *ExpandedTextAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedTextAdInfo.Merge(dst, src)
}
func (m *ExpandedTextAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedTextAdInfo.Size(m)
}
func (m *ExpandedTextAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedTextAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedTextAdInfo proto.InternalMessageInfo

func (m *ExpandedTextAdInfo) GetHeadlinePart1() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart2() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetHeadlinePart3() *wrappers.StringValue {
	if m != nil {
		return m.HeadlinePart3
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath1() *wrappers.StringValue {
	if m != nil {
		return m.Path1
	}
	return nil
}

func (m *ExpandedTextAdInfo) GetPath2() *wrappers.StringValue {
	if m != nil {
		return m.Path2
	}
	return nil
}

// A dynamic search ad.
type DynamicSearchAdInfo struct {
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,1,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2         *wrappers.StringValue `protobuf:"bytes,2,opt,name=description2,proto3" json:"description2,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DynamicSearchAdInfo) Reset()         { *m = DynamicSearchAdInfo{} }
func (m *DynamicSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*DynamicSearchAdInfo) ProtoMessage()    {}
func (*DynamicSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{2}
}
func (m *DynamicSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DynamicSearchAdInfo.Unmarshal(m, b)
}
func (m *DynamicSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DynamicSearchAdInfo.Marshal(b, m, deterministic)
}
func (dst *DynamicSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DynamicSearchAdInfo.Merge(dst, src)
}
func (m *DynamicSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_DynamicSearchAdInfo.Size(m)
}
func (m *DynamicSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DynamicSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DynamicSearchAdInfo proto.InternalMessageInfo

func (m *DynamicSearchAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *DynamicSearchAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

// A responsive display ad.
type ResponsiveDisplayAdInfo struct {
	// The short version of the ad's headline.
	ShortHeadline *wrappers.StringValue `protobuf:"bytes,1,opt,name=short_headline,json=shortHeadline,proto3" json:"short_headline,omitempty"`
	// The long version of the ad's headline.
	LongHeadline *wrappers.StringValue `protobuf:"bytes,2,opt,name=long_headline,json=longHeadline,proto3" json:"long_headline,omitempty"`
	// The description of the ad.
	Description *wrappers.StringValue `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,4,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Advertiser's consent to allow flexible color. When true, the ad may be
	// served with different color if necessary. When false, the ad will be served
	// with the specified colors or a neutral color.
	// The default value is true.
	// Must be true if main_color and accent_color are not set.
	AllowFlexibleColor *wrappers.BoolValue `protobuf:"bytes,5,opt,name=allow_flexible_color,json=allowFlexibleColor,proto3" json:"allow_flexible_color,omitempty"`
	// The accent color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	AccentColor *wrappers.StringValue `protobuf:"bytes,6,opt,name=accent_color,json=accentColor,proto3" json:"accent_color,omitempty"`
	// The main color of the ad in hexadecimal, e.g. #ffffff for white.
	// If one of main_color and accent_color is set, the other is required as
	// well.
	MainColor *wrappers.StringValue `protobuf:"bytes,7,opt,name=main_color,json=mainColor,proto3" json:"main_color,omitempty"`
	// The call-to-action text for the ad.
	CallToActionText *wrappers.StringValue `protobuf:"bytes,8,opt,name=call_to_action_text,json=callToActionText,proto3" json:"call_to_action_text,omitempty"`
	// The MediaFile resource name of the logo image used in the ad.
	LogoImage *wrappers.StringValue `protobuf:"bytes,9,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	// The MediaFile resource name of the square logo image used in the ad.
	SquareLogoImage *wrappers.StringValue `protobuf:"bytes,10,opt,name=square_logo_image,json=squareLogoImage,proto3" json:"square_logo_image,omitempty"`
	// The MediaFile resource name of the marketing image used in the ad.
	MarketingImage *wrappers.StringValue `protobuf:"bytes,11,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// The MediaFile resource name of the square marketing image used in the ad.
	SquareMarketingImage *wrappers.StringValue `protobuf:"bytes,12,opt,name=square_marketing_image,json=squareMarketingImage,proto3" json:"square_marketing_image,omitempty"`
	// Specifies which format the ad will be served in. Default is ALL_FORMATS.
	FormatSetting enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting `protobuf:"varint,13,opt,name=format_setting,json=formatSetting,proto3,enum=google.ads.googleads.v0.enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting" json:"format_setting,omitempty"`
	// Prefix before price. E.g. 'as low as'.
	PricePrefix *wrappers.StringValue `protobuf:"bytes,14,opt,name=price_prefix,json=pricePrefix,proto3" json:"price_prefix,omitempty"`
	// Promotion text used for dyanmic formats of responsive ads. For example
	// 'Free two-day shipping'.
	PromoText            *wrappers.StringValue `protobuf:"bytes,15,opt,name=promo_text,json=promoText,proto3" json:"promo_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ResponsiveDisplayAdInfo) Reset()         { *m = ResponsiveDisplayAdInfo{} }
func (m *ResponsiveDisplayAdInfo) String() string { return proto.CompactTextString(m) }
func (*ResponsiveDisplayAdInfo) ProtoMessage()    {}
func (*ResponsiveDisplayAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{3}
}
func (m *ResponsiveDisplayAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Unmarshal(m, b)
}
func (m *ResponsiveDisplayAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Marshal(b, m, deterministic)
}
func (dst *ResponsiveDisplayAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponsiveDisplayAdInfo.Merge(dst, src)
}
func (m *ResponsiveDisplayAdInfo) XXX_Size() int {
	return xxx_messageInfo_ResponsiveDisplayAdInfo.Size(m)
}
func (m *ResponsiveDisplayAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponsiveDisplayAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ResponsiveDisplayAdInfo proto.InternalMessageInfo

func (m *ResponsiveDisplayAdInfo) GetShortHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ShortHeadline
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetLongHeadline() *wrappers.StringValue {
	if m != nil {
		return m.LongHeadline
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetAllowFlexibleColor() *wrappers.BoolValue {
	if m != nil {
		return m.AllowFlexibleColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetAccentColor() *wrappers.StringValue {
	if m != nil {
		return m.AccentColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetMainColor() *wrappers.StringValue {
	if m != nil {
		return m.MainColor
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetCallToActionText() *wrappers.StringValue {
	if m != nil {
		return m.CallToActionText
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetSquareLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareLogoImage
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetSquareMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.SquareMarketingImage
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetFormatSetting() enums.DisplayAdFormatSettingEnum_DisplayAdFormatSetting {
	if m != nil {
		return m.FormatSetting
	}
	return enums.DisplayAdFormatSettingEnum_UNSPECIFIED
}

func (m *ResponsiveDisplayAdInfo) GetPricePrefix() *wrappers.StringValue {
	if m != nil {
		return m.PricePrefix
	}
	return nil
}

func (m *ResponsiveDisplayAdInfo) GetPromoText() *wrappers.StringValue {
	if m != nil {
		return m.PromoText
	}
	return nil
}

// A call-only ad.
type CallOnlyAdInfo struct {
	// The country code in the ad.
	CountryCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The phone number in the ad.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,2,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// The business name in the ad.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The first line of the ad's description.
	Description1 *wrappers.StringValue `protobuf:"bytes,4,opt,name=description1,proto3" json:"description1,omitempty"`
	// The second line of the ad's description.
	Description2 *wrappers.StringValue `protobuf:"bytes,5,opt,name=description2,proto3" json:"description2,omitempty"`
	// Whether to enable call tracking for the creative. Enabling call
	// tracking also enables call conversions.
	CallTracked *wrappers.BoolValue `protobuf:"bytes,6,opt,name=call_tracked,json=callTracked,proto3" json:"call_tracked,omitempty"`
	// Whether to disable call conversion for the creative.
	// If set to `true`, disables call conversions even when `call_tracked` is
	// `true`.
	// If `call_tracked` is `false`, this field is ignored.
	DisableCallConversion *wrappers.BoolValue `protobuf:"bytes,7,opt,name=disable_call_conversion,json=disableCallConversion,proto3" json:"disable_call_conversion,omitempty"`
	// The URL to be used for phone number verification.
	PhoneNumberVerificationUrl *wrappers.StringValue `protobuf:"bytes,8,opt,name=phone_number_verification_url,json=phoneNumberVerificationUrl,proto3" json:"phone_number_verification_url,omitempty"`
	// The conversion action to attribute a call conversion to. If not set a
	// default conversion action is used. This field only has effect if
	// call_tracked is set to true. Otherwise this field is ignored.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,9,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The call conversion behavior of this call only ad. It can use its own call
	// conversion setting, inherit the account level setting, or be disabled.
	ConversionReportingState enums.CallConversionReportingStateEnum_CallConversionReportingState `protobuf:"varint,10,opt,name=conversion_reporting_state,json=conversionReportingState,proto3,enum=google.ads.googleads.v0.enums.CallConversionReportingStateEnum_CallConversionReportingState" json:"conversion_reporting_state,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                                                            `json:"-"`
	XXX_unrecognized         []byte                                                              `json:"-"`
	XXX_sizecache            int32                                                               `json:"-"`
}

func (m *CallOnlyAdInfo) Reset()         { *m = CallOnlyAdInfo{} }
func (m *CallOnlyAdInfo) String() string { return proto.CompactTextString(m) }
func (*CallOnlyAdInfo) ProtoMessage()    {}
func (*CallOnlyAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{4}
}
func (m *CallOnlyAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallOnlyAdInfo.Unmarshal(m, b)
}
func (m *CallOnlyAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallOnlyAdInfo.Marshal(b, m, deterministic)
}
func (dst *CallOnlyAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallOnlyAdInfo.Merge(dst, src)
}
func (m *CallOnlyAdInfo) XXX_Size() int {
	return xxx_messageInfo_CallOnlyAdInfo.Size(m)
}
func (m *CallOnlyAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CallOnlyAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CallOnlyAdInfo proto.InternalMessageInfo

func (m *CallOnlyAdInfo) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *CallOnlyAdInfo) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription1() *wrappers.StringValue {
	if m != nil {
		return m.Description1
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDescription2() *wrappers.StringValue {
	if m != nil {
		return m.Description2
	}
	return nil
}

func (m *CallOnlyAdInfo) GetCallTracked() *wrappers.BoolValue {
	if m != nil {
		return m.CallTracked
	}
	return nil
}

func (m *CallOnlyAdInfo) GetDisableCallConversion() *wrappers.BoolValue {
	if m != nil {
		return m.DisableCallConversion
	}
	return nil
}

func (m *CallOnlyAdInfo) GetPhoneNumberVerificationUrl() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumberVerificationUrl
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *CallOnlyAdInfo) GetConversionReportingState() enums.CallConversionReportingStateEnum_CallConversionReportingState {
	if m != nil {
		return m.ConversionReportingState
	}
	return enums.CallConversionReportingStateEnum_UNSPECIFIED
}

// An expanded dynamic search ad.
type ExpandedDynamicSearchAdInfo struct {
	// The description of the ad.
	Description          *wrappers.StringValue `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExpandedDynamicSearchAdInfo) Reset()         { *m = ExpandedDynamicSearchAdInfo{} }
func (m *ExpandedDynamicSearchAdInfo) String() string { return proto.CompactTextString(m) }
func (*ExpandedDynamicSearchAdInfo) ProtoMessage()    {}
func (*ExpandedDynamicSearchAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{5}
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Unmarshal(m, b)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Marshal(b, m, deterministic)
}
func (dst *ExpandedDynamicSearchAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.Merge(dst, src)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_Size() int {
	return xxx_messageInfo_ExpandedDynamicSearchAdInfo.Size(m)
}
func (m *ExpandedDynamicSearchAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExpandedDynamicSearchAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExpandedDynamicSearchAdInfo proto.InternalMessageInfo

func (m *ExpandedDynamicSearchAdInfo) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

// A hotel ad.
type HotelAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HotelAdInfo) Reset()         { *m = HotelAdInfo{} }
func (m *HotelAdInfo) String() string { return proto.CompactTextString(m) }
func (*HotelAdInfo) ProtoMessage()    {}
func (*HotelAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{6}
}
func (m *HotelAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HotelAdInfo.Unmarshal(m, b)
}
func (m *HotelAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HotelAdInfo.Marshal(b, m, deterministic)
}
func (dst *HotelAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HotelAdInfo.Merge(dst, src)
}
func (m *HotelAdInfo) XXX_Size() int {
	return xxx_messageInfo_HotelAdInfo.Size(m)
}
func (m *HotelAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HotelAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HotelAdInfo proto.InternalMessageInfo

// A Smart Shopping ad.
type ShoppingSmartAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingSmartAdInfo) Reset()         { *m = ShoppingSmartAdInfo{} }
func (m *ShoppingSmartAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingSmartAdInfo) ProtoMessage()    {}
func (*ShoppingSmartAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{7}
}
func (m *ShoppingSmartAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingSmartAdInfo.Unmarshal(m, b)
}
func (m *ShoppingSmartAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingSmartAdInfo.Marshal(b, m, deterministic)
}
func (dst *ShoppingSmartAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingSmartAdInfo.Merge(dst, src)
}
func (m *ShoppingSmartAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingSmartAdInfo.Size(m)
}
func (m *ShoppingSmartAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingSmartAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingSmartAdInfo proto.InternalMessageInfo

// A standard Shopping ad.
type ShoppingProductAdInfo struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShoppingProductAdInfo) Reset()         { *m = ShoppingProductAdInfo{} }
func (m *ShoppingProductAdInfo) String() string { return proto.CompactTextString(m) }
func (*ShoppingProductAdInfo) ProtoMessage()    {}
func (*ShoppingProductAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{8}
}
func (m *ShoppingProductAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShoppingProductAdInfo.Unmarshal(m, b)
}
func (m *ShoppingProductAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShoppingProductAdInfo.Marshal(b, m, deterministic)
}
func (dst *ShoppingProductAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShoppingProductAdInfo.Merge(dst, src)
}
func (m *ShoppingProductAdInfo) XXX_Size() int {
	return xxx_messageInfo_ShoppingProductAdInfo.Size(m)
}
func (m *ShoppingProductAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ShoppingProductAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ShoppingProductAdInfo proto.InternalMessageInfo

// A Gmail ad.
type GmailAdInfo struct {
	// The Gmail teaser.
	Teaser *GmailTeaser `protobuf:"bytes,1,opt,name=teaser,proto3" json:"teaser,omitempty"`
	// The MediaFile resource name of the header image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 300x100 pixels and the aspect ratio must
	// be between 3:1 and 5:1 (+-1%).
	HeaderImage *wrappers.StringValue `protobuf:"bytes,2,opt,name=header_image,json=headerImage,proto3" json:"header_image,omitempty"`
	// The MediaFile resource name of the marketing image. Valid image types are
	// GIF, JPEG and PNG. The image must either be landscape with a minimum size
	// of 600x314 pixels and aspect ratio of 600:314 (+-1%) or square with a
	// minimum size of 300x300 pixels and aspect ratio of 1:1 (+-1%)
	MarketingImage *wrappers.StringValue `protobuf:"bytes,3,opt,name=marketing_image,json=marketingImage,proto3" json:"marketing_image,omitempty"`
	// Headline of the marketing image.
	MarketingImageHeadline *wrappers.StringValue `protobuf:"bytes,4,opt,name=marketing_image_headline,json=marketingImageHeadline,proto3" json:"marketing_image_headline,omitempty"`
	// Description of the marketing image.
	MarketingImageDescription *wrappers.StringValue `protobuf:"bytes,5,opt,name=marketing_image_description,json=marketingImageDescription,proto3" json:"marketing_image_description,omitempty"`
	// Display-call-to-action of the marketing image.
	MarketingImageDisplayCallToAction *DisplayCallToAction `protobuf:"bytes,6,opt,name=marketing_image_display_call_to_action,json=marketingImageDisplayCallToAction,proto3" json:"marketing_image_display_call_to_action,omitempty"`
	XXX_NoUnkeyedLiteral              struct{}             `json:"-"`
	XXX_unrecognized                  []byte               `json:"-"`
	XXX_sizecache                     int32                `json:"-"`
}

func (m *GmailAdInfo) Reset()         { *m = GmailAdInfo{} }
func (m *GmailAdInfo) String() string { return proto.CompactTextString(m) }
func (*GmailAdInfo) ProtoMessage()    {}
func (*GmailAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{9}
}
func (m *GmailAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailAdInfo.Unmarshal(m, b)
}
func (m *GmailAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailAdInfo.Marshal(b, m, deterministic)
}
func (dst *GmailAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailAdInfo.Merge(dst, src)
}
func (m *GmailAdInfo) XXX_Size() int {
	return xxx_messageInfo_GmailAdInfo.Size(m)
}
func (m *GmailAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_GmailAdInfo proto.InternalMessageInfo

func (m *GmailAdInfo) GetTeaser() *GmailTeaser {
	if m != nil {
		return m.Teaser
	}
	return nil
}

func (m *GmailAdInfo) GetHeaderImage() *wrappers.StringValue {
	if m != nil {
		return m.HeaderImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImage() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImage
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageHeadline() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageHeadline
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDescription() *wrappers.StringValue {
	if m != nil {
		return m.MarketingImageDescription
	}
	return nil
}

func (m *GmailAdInfo) GetMarketingImageDisplayCallToAction() *DisplayCallToAction {
	if m != nil {
		return m.MarketingImageDisplayCallToAction
	}
	return nil
}

// Gmail teaser data. The teaser is a small header that acts as an invitation
// to view the rest of the ad (the body).
type GmailTeaser struct {
	// Headline of the teaser.
	Headline *wrappers.StringValue `protobuf:"bytes,1,opt,name=headline,proto3" json:"headline,omitempty"`
	// Description of the teaser.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Business name of the advertiser.
	BusinessName *wrappers.StringValue `protobuf:"bytes,3,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// The MediaFile resource name of the logo image. Valid image types are GIF,
	// JPEG and PNG. The minimum size is 144x144 pixels and the aspect ratio must
	// be 1:1 (+-1%).
	LogoImage            *wrappers.StringValue `protobuf:"bytes,4,opt,name=logo_image,json=logoImage,proto3" json:"logo_image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GmailTeaser) Reset()         { *m = GmailTeaser{} }
func (m *GmailTeaser) String() string { return proto.CompactTextString(m) }
func (*GmailTeaser) ProtoMessage()    {}
func (*GmailTeaser) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{10}
}
func (m *GmailTeaser) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GmailTeaser.Unmarshal(m, b)
}
func (m *GmailTeaser) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GmailTeaser.Marshal(b, m, deterministic)
}
func (dst *GmailTeaser) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GmailTeaser.Merge(dst, src)
}
func (m *GmailTeaser) XXX_Size() int {
	return xxx_messageInfo_GmailTeaser.Size(m)
}
func (m *GmailTeaser) XXX_DiscardUnknown() {
	xxx_messageInfo_GmailTeaser.DiscardUnknown(m)
}

var xxx_messageInfo_GmailTeaser proto.InternalMessageInfo

func (m *GmailTeaser) GetHeadline() *wrappers.StringValue {
	if m != nil {
		return m.Headline
	}
	return nil
}

func (m *GmailTeaser) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *GmailTeaser) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *GmailTeaser) GetLogoImage() *wrappers.StringValue {
	if m != nil {
		return m.LogoImage
	}
	return nil
}

// Data for display call to action. The call to action is a piece of the ad
// that prompts the user to do something. Like clicking a link or making a phone
// call.
type DisplayCallToAction struct {
	// Text for the display-call-to-action.
	Text *wrappers.StringValue `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Text color for the display-call-to-action in hexadecimal, e.g. #ffffff for
	// white.
	TextColor            *wrappers.StringValue `protobuf:"bytes,2,opt,name=text_color,json=textColor,proto3" json:"text_color,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DisplayCallToAction) Reset()         { *m = DisplayCallToAction{} }
func (m *DisplayCallToAction) String() string { return proto.CompactTextString(m) }
func (*DisplayCallToAction) ProtoMessage()    {}
func (*DisplayCallToAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{11}
}
func (m *DisplayCallToAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayCallToAction.Unmarshal(m, b)
}
func (m *DisplayCallToAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayCallToAction.Marshal(b, m, deterministic)
}
func (dst *DisplayCallToAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayCallToAction.Merge(dst, src)
}
func (m *DisplayCallToAction) XXX_Size() int {
	return xxx_messageInfo_DisplayCallToAction.Size(m)
}
func (m *DisplayCallToAction) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayCallToAction.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayCallToAction proto.InternalMessageInfo

func (m *DisplayCallToAction) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *DisplayCallToAction) GetTextColor() *wrappers.StringValue {
	if m != nil {
		return m.TextColor
	}
	return nil
}

// An image ad.
type ImageAdInfo struct {
	// Width in pixels of the full size image.
	PixelWidth *wrappers.Int64Value `protobuf:"bytes,4,opt,name=pixel_width,json=pixelWidth,proto3" json:"pixel_width,omitempty"`
	// Height in pixels of the full size image.
	PixelHeight *wrappers.Int64Value `protobuf:"bytes,5,opt,name=pixel_height,json=pixelHeight,proto3" json:"pixel_height,omitempty"`
	// URL of the full size image.
	ImageUrl *wrappers.StringValue `protobuf:"bytes,6,opt,name=image_url,json=imageUrl,proto3" json:"image_url,omitempty"`
	// Width in pixels of the preview size image.
	PreviewPixelWidth *wrappers.Int64Value `protobuf:"bytes,7,opt,name=preview_pixel_width,json=previewPixelWidth,proto3" json:"preview_pixel_width,omitempty"`
	// Height in pixels of the preview size image.
	PreviewPixelHeight *wrappers.Int64Value `protobuf:"bytes,8,opt,name=preview_pixel_height,json=previewPixelHeight,proto3" json:"preview_pixel_height,omitempty"`
	// URL of the preview size image.
	PreviewImageUrl *wrappers.StringValue `protobuf:"bytes,9,opt,name=preview_image_url,json=previewImageUrl,proto3" json:"preview_image_url,omitempty"`
	// The mime type of the image.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,10,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v0.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// The name of the image. If the image was created from a MediaFile, this is
	// the MediaFile's name. If the image was created from bytes, this is empty.
	Name *wrappers.StringValue `protobuf:"bytes,11,opt,name=name,proto3" json:"name,omitempty"`
	// The image to create the ImageAd from. This can be specified in one of
	// two ways.
	// 1. An existing MediaFile resource.
	// 2. The raw image data as bytes.
	//
	// Types that are valid to be assigned to Image:
	//	*ImageAdInfo_MediaFile
	//	*ImageAdInfo_Data
	Image                isImageAdInfo_Image `protobuf_oneof:"image"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ImageAdInfo) Reset()         { *m = ImageAdInfo{} }
func (m *ImageAdInfo) String() string { return proto.CompactTextString(m) }
func (*ImageAdInfo) ProtoMessage()    {}
func (*ImageAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{12}
}
func (m *ImageAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImageAdInfo.Unmarshal(m, b)
}
func (m *ImageAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImageAdInfo.Marshal(b, m, deterministic)
}
func (dst *ImageAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImageAdInfo.Merge(dst, src)
}
func (m *ImageAdInfo) XXX_Size() int {
	return xxx_messageInfo_ImageAdInfo.Size(m)
}
func (m *ImageAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ImageAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ImageAdInfo proto.InternalMessageInfo

func (m *ImageAdInfo) GetPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.ImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelWidth() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelWidth
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewPixelHeight() *wrappers.Int64Value {
	if m != nil {
		return m.PreviewPixelHeight
	}
	return nil
}

func (m *ImageAdInfo) GetPreviewImageUrl() *wrappers.StringValue {
	if m != nil {
		return m.PreviewImageUrl
	}
	return nil
}

func (m *ImageAdInfo) GetMimeType() enums.MimeTypeEnum_MimeType {
	if m != nil {
		return m.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (m *ImageAdInfo) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

type isImageAdInfo_Image interface {
	isImageAdInfo_Image()
}

type ImageAdInfo_MediaFile struct {
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3,oneof"`
}

type ImageAdInfo_Data struct {
	Data *wrappers.BytesValue `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

func (*ImageAdInfo_MediaFile) isImageAdInfo_Image() {}

func (*ImageAdInfo_Data) isImageAdInfo_Image() {}

func (m *ImageAdInfo) GetImage() isImageAdInfo_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *ImageAdInfo) GetMediaFile() *wrappers.StringValue {
	if x, ok := m.GetImage().(*ImageAdInfo_MediaFile); ok {
		return x.MediaFile
	}
	return nil
}

func (m *ImageAdInfo) GetData() *wrappers.BytesValue {
	if x, ok := m.GetImage().(*ImageAdInfo_Data); ok {
		return x.Data
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ImageAdInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ImageAdInfo_OneofMarshaler, _ImageAdInfo_OneofUnmarshaler, _ImageAdInfo_OneofSizer, []interface{}{
		(*ImageAdInfo_MediaFile)(nil),
		(*ImageAdInfo_Data)(nil),
	}
}

func _ImageAdInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ImageAdInfo)
	// image
	switch x := m.Image.(type) {
	case *ImageAdInfo_MediaFile:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MediaFile); err != nil {
			return err
		}
	case *ImageAdInfo_Data:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Data); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ImageAdInfo.Image has unexpected type %T", x)
	}
	return nil
}

func _ImageAdInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ImageAdInfo)
	switch tag {
	case 1: // image.media_file
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.Image = &ImageAdInfo_MediaFile{msg}
		return true, err
	case 2: // image.data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.BytesValue)
		err := b.DecodeMessage(msg)
		m.Image = &ImageAdInfo_Data{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ImageAdInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ImageAdInfo)
	// image
	switch x := m.Image.(type) {
	case *ImageAdInfo_MediaFile:
		s := proto.Size(x.MediaFile)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ImageAdInfo_Data:
		s := proto.Size(x.Data)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Representation of video TrueView in-stream ad format (ad shown during video
// playback, often at beginning, which displays a skip button a few seconds into
// the video).
type VideoTrueViewInStreamAdInfo struct {
	// Label on the CTA (call-to-action) button taking the user to the video ad's
	// final URL.
	// Required for TrueView for action campaigns, optional otherwise.
	ActionButtonLabel *wrappers.StringValue `protobuf:"bytes,1,opt,name=action_button_label,json=actionButtonLabel,proto3" json:"action_button_label,omitempty"`
	// Additional text displayed with the CTA (call-to-action) button to give
	// context and encourage clicking on the button.
	ActionHeadline       *wrappers.StringValue `protobuf:"bytes,2,opt,name=action_headline,json=actionHeadline,proto3" json:"action_headline,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *VideoTrueViewInStreamAdInfo) Reset()         { *m = VideoTrueViewInStreamAdInfo{} }
func (m *VideoTrueViewInStreamAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoTrueViewInStreamAdInfo) ProtoMessage()    {}
func (*VideoTrueViewInStreamAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{13}
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Unmarshal(m, b)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoTrueViewInStreamAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.Merge(dst, src)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoTrueViewInStreamAdInfo.Size(m)
}
func (m *VideoTrueViewInStreamAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoTrueViewInStreamAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoTrueViewInStreamAdInfo proto.InternalMessageInfo

func (m *VideoTrueViewInStreamAdInfo) GetActionButtonLabel() *wrappers.StringValue {
	if m != nil {
		return m.ActionButtonLabel
	}
	return nil
}

func (m *VideoTrueViewInStreamAdInfo) GetActionHeadline() *wrappers.StringValue {
	if m != nil {
		return m.ActionHeadline
	}
	return nil
}

// A video ad.
type VideoAdInfo struct {
	// The MediaFile resource to use for the video.
	MediaFile *wrappers.StringValue `protobuf:"bytes,1,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// Format-specific schema for the different video formats.
	//
	// Types that are valid to be assigned to Format:
	//	*VideoAdInfo_InStream
	Format               isVideoAdInfo_Format `protobuf_oneof:"format"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAdInfo) Reset()         { *m = VideoAdInfo{} }
func (m *VideoAdInfo) String() string { return proto.CompactTextString(m) }
func (*VideoAdInfo) ProtoMessage()    {}
func (*VideoAdInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_type_infos_128b09aa9cda8bcd, []int{14}
}
func (m *VideoAdInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAdInfo.Unmarshal(m, b)
}
func (m *VideoAdInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAdInfo.Marshal(b, m, deterministic)
}
func (dst *VideoAdInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAdInfo.Merge(dst, src)
}
func (m *VideoAdInfo) XXX_Size() int {
	return xxx_messageInfo_VideoAdInfo.Size(m)
}
func (m *VideoAdInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAdInfo.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAdInfo proto.InternalMessageInfo

func (m *VideoAdInfo) GetMediaFile() *wrappers.StringValue {
	if m != nil {
		return m.MediaFile
	}
	return nil
}

type isVideoAdInfo_Format interface {
	isVideoAdInfo_Format()
}

type VideoAdInfo_InStream struct {
	InStream *VideoTrueViewInStreamAdInfo `protobuf:"bytes,2,opt,name=in_stream,json=inStream,proto3,oneof"`
}

func (*VideoAdInfo_InStream) isVideoAdInfo_Format() {}

func (m *VideoAdInfo) GetFormat() isVideoAdInfo_Format {
	if m != nil {
		return m.Format
	}
	return nil
}

func (m *VideoAdInfo) GetInStream() *VideoTrueViewInStreamAdInfo {
	if x, ok := m.GetFormat().(*VideoAdInfo_InStream); ok {
		return x.InStream
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*VideoAdInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _VideoAdInfo_OneofMarshaler, _VideoAdInfo_OneofUnmarshaler, _VideoAdInfo_OneofSizer, []interface{}{
		(*VideoAdInfo_InStream)(nil),
	}
}

func _VideoAdInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*VideoAdInfo)
	// format
	switch x := m.Format.(type) {
	case *VideoAdInfo_InStream:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.InStream); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("VideoAdInfo.Format has unexpected type %T", x)
	}
	return nil
}

func _VideoAdInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*VideoAdInfo)
	switch tag {
	case 2: // format.in_stream
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoTrueViewInStreamAdInfo)
		err := b.DecodeMessage(msg)
		m.Format = &VideoAdInfo_InStream{msg}
		return true, err
	default:
		return false, nil
	}
}

func _VideoAdInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*VideoAdInfo)
	// format
	switch x := m.Format.(type) {
	case *VideoAdInfo_InStream:
		s := proto.Size(x.InStream)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*TextAdInfo)(nil), "google.ads.googleads.v0.common.TextAdInfo")
	proto.RegisterType((*ExpandedTextAdInfo)(nil), "google.ads.googleads.v0.common.ExpandedTextAdInfo")
	proto.RegisterType((*DynamicSearchAdInfo)(nil), "google.ads.googleads.v0.common.DynamicSearchAdInfo")
	proto.RegisterType((*ResponsiveDisplayAdInfo)(nil), "google.ads.googleads.v0.common.ResponsiveDisplayAdInfo")
	proto.RegisterType((*CallOnlyAdInfo)(nil), "google.ads.googleads.v0.common.CallOnlyAdInfo")
	proto.RegisterType((*ExpandedDynamicSearchAdInfo)(nil), "google.ads.googleads.v0.common.ExpandedDynamicSearchAdInfo")
	proto.RegisterType((*HotelAdInfo)(nil), "google.ads.googleads.v0.common.HotelAdInfo")
	proto.RegisterType((*ShoppingSmartAdInfo)(nil), "google.ads.googleads.v0.common.ShoppingSmartAdInfo")
	proto.RegisterType((*ShoppingProductAdInfo)(nil), "google.ads.googleads.v0.common.ShoppingProductAdInfo")
	proto.RegisterType((*GmailAdInfo)(nil), "google.ads.googleads.v0.common.GmailAdInfo")
	proto.RegisterType((*GmailTeaser)(nil), "google.ads.googleads.v0.common.GmailTeaser")
	proto.RegisterType((*DisplayCallToAction)(nil), "google.ads.googleads.v0.common.DisplayCallToAction")
	proto.RegisterType((*ImageAdInfo)(nil), "google.ads.googleads.v0.common.ImageAdInfo")
	proto.RegisterType((*VideoTrueViewInStreamAdInfo)(nil), "google.ads.googleads.v0.common.VideoTrueViewInStreamAdInfo")
	proto.RegisterType((*VideoAdInfo)(nil), "google.ads.googleads.v0.common.VideoAdInfo")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/common/ad_type_infos.proto", fileDescriptor_ad_type_infos_128b09aa9cda8bcd)
}

var fileDescriptor_ad_type_infos_128b09aa9cda8bcd = []byte{
	// 1519 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xdd, 0x6e, 0xdb, 0xc6,
	0x12, 0x8e, 0xfc, 0x17, 0x79, 0x64, 0xcb, 0x31, 0x9d, 0x1f, 0x1d, 0xfb, 0x9c, 0x20, 0x87, 0x17,
	0x07, 0x01, 0x0e, 0x4a, 0xd9, 0x72, 0x50, 0xb4, 0x72, 0x93, 0x54, 0x96, 0x93, 0xd8, 0x88, 0x93,
	0xba, 0xb2, 0xab, 0x02, 0x81, 0x0b, 0x62, 0x4d, 0xae, 0xa4, 0x45, 0xc8, 0x5d, 0x76, 0x49, 0xf9,
	0xe7, 0xbe, 0x68, 0x9f, 0x21, 0xbd, 0xec, 0x65, 0xd1, 0x8b, 0xa2, 0x40, 0x5f, 0x22, 0x40, 0x6f,
	0xfb, 0x10, 0xed, 0x4b, 0x14, 0xfb, 0x43, 0x99, 0x92, 0x6a, 0x69, 0x55, 0x5f, 0x89, 0x92, 0xe6,
	0xfb, 0x38, 0x33, 0x3b, 0xf3, 0xcd, 0x90, 0x50, 0x69, 0x33, 0xd6, 0x0e, 0x70, 0x19, 0xf9, 0x71,
	0x59, 0x5d, 0x8a, 0xab, 0xd3, 0xf5, 0xb2, 0xc7, 0xc2, 0x90, 0xd1, 0x32, 0xf2, 0xdd, 0xe4, 0x22,
	0xc2, 0x2e, 0xa1, 0x2d, 0x16, 0x3b, 0x11, 0x67, 0x09, 0xb3, 0xee, 0x2b, 0x43, 0x07, 0xf9, 0xb1,
	0xd3, 0xc3, 0x38, 0xa7, 0xeb, 0x8e, 0xc2, 0xac, 0xd6, 0xaf, 0xe2, 0xc4, 0xb4, 0x1b, 0xc6, 0x65,
	0x0f, 0x05, 0x81, 0xeb, 0x31, 0x7a, 0x8a, 0x79, 0x4c, 0x18, 0x75, 0x39, 0x8e, 0x18, 0x4f, 0x08,
	0x6d, 0xbb, 0x71, 0x82, 0x12, 0xac, 0x6e, 0xb2, 0xfa, 0x78, 0x34, 0x89, 0x4f, 0xe2, 0x28, 0x40,
	0x17, 0x2e, 0xf2, 0xdd, 0x16, 0xe3, 0x21, 0x4a, 0xdc, 0x18, 0x27, 0x82, 0x44, 0xc3, 0x3f, 0x18,
	0x0d, 0x0f, 0x49, 0x88, 0x65, 0x60, 0xda, 0x5c, 0x87, 0x54, 0x96, 0xdf, 0x4e, 0xba, 0xad, 0xf2,
	0x19, 0x47, 0x51, 0x84, 0xb9, 0x0e, 0xd9, 0x7e, 0x9f, 0x03, 0x38, 0xc2, 0xe7, 0x49, 0xcd, 0xdf,
	0xa3, 0x2d, 0x66, 0x7d, 0x04, 0xf9, 0x0e, 0x46, 0x7e, 0x40, 0x28, 0x2e, 0xe5, 0x1e, 0xe4, 0x1e,
	0x16, 0x2a, 0xff, 0xd6, 0x99, 0x70, 0x52, 0x06, 0xe7, 0x30, 0xe1, 0x84, 0xb6, 0x9b, 0x28, 0xe8,
	0xe2, 0x46, 0xcf, 0xda, 0xfa, 0x14, 0x16, 0x7c, 0x1c, 0x7b, 0x9c, 0x44, 0x09, 0x61, 0x74, 0xa3,
	0x34, 0x65, 0x80, 0xee, 0x43, 0x0c, 0x30, 0x54, 0x4a, 0xd3, 0x13, 0x32, 0x54, 0xec, 0xdf, 0xa6,
	0xc1, 0x7a, 0x76, 0x1e, 0x21, 0xea, 0x63, 0x3f, 0x13, 0x54, 0x1d, 0x8a, 0xa9, 0x9b, 0x6e, 0x84,
	0x78, 0xb2, 0x61, 0x14, 0xda, 0x62, 0x8a, 0x39, 0x10, 0x90, 0x21, 0x92, 0x8a, 0x51, 0x84, 0x7d,
	0x24, 0x95, 0x21, 0x92, 0xcd, 0xd2, 0xdc, 0xa4, 0x24, 0x9b, 0xd6, 0x13, 0x28, 0x64, 0xa2, 0x36,
	0x4a, 0x53, 0x16, 0x30, 0x94, 0xe7, 0x9b, 0x93, 0xe6, 0xd9, 0xaa, 0xc0, 0x6c, 0x84, 0x92, 0xce,
	0x46, 0x69, 0xc6, 0x00, 0xaa, 0x4c, 0x53, 0x4c, 0xa5, 0x34, 0x6b, 0x8a, 0xa9, 0xd8, 0xef, 0x72,
	0xb0, 0xb2, 0x73, 0x41, 0x51, 0x48, 0xbc, 0x43, 0x8c, 0xb8, 0xd7, 0xd1, 0x07, 0x3a, 0x58, 0x6b,
	0xb9, 0x6b, 0xd7, 0xda, 0xd4, 0xc4, 0xb5, 0xf6, 0x7b, 0x1e, 0xee, 0x35, 0x70, 0x1c, 0x31, 0x1a,
	0x93, 0x53, 0xbc, 0xa3, 0xba, 0xf6, 0xb2, 0xe0, 0xe2, 0x0e, 0xe3, 0x89, 0x3b, 0x51, 0x2f, 0x2d,
	0x4a, 0xcc, 0x6e, 0xda, 0x50, 0x35, 0x58, 0x0c, 0x18, 0x6d, 0x5f, 0x72, 0x18, 0xf9, 0x28, 0x20,
	0x3d, 0x8a, 0xeb, 0x56, 0x4a, 0x0d, 0x16, 0x4f, 0xba, 0x31, 0xa1, 0x38, 0x8e, 0x5d, 0x8a, 0x42,
	0x6c, 0x74, 0xde, 0x0b, 0x29, 0xe4, 0x35, 0x0a, 0xb1, 0xb5, 0x0f, 0xb7, 0x51, 0x10, 0xb0, 0x33,
	0xb7, 0x15, 0xe0, 0x73, 0x72, 0x12, 0x60, 0xd7, 0x63, 0x01, 0xe3, 0xba, 0x0a, 0x56, 0x87, 0x98,
	0xb6, 0x19, 0x0b, 0x14, 0x8f, 0x25, 0x71, 0xcf, 0x35, 0xac, 0x2e, 0x50, 0xd6, 0x53, 0x58, 0x40,
	0x9e, 0x87, 0x69, 0xa2, 0x59, 0x4c, 0xba, 0xa7, 0xa0, 0x10, 0x8a, 0x60, 0x0b, 0x20, 0x44, 0x84,
	0x6a, 0xb8, 0x49, 0xe5, 0xcf, 0x0b, 0x7b, 0x05, 0x7e, 0x09, 0x2b, 0x52, 0xe2, 0x13, 0xe6, 0x22,
	0x4f, 0x24, 0xc8, 0x4d, 0xf0, 0x79, 0x52, 0xca, 0x1b, 0xb0, 0xdc, 0x12, 0xc0, 0x23, 0x56, 0x93,
	0x30, 0x21, 0x4d, 0xc2, 0x93, 0x80, 0xb5, 0x99, 0x4b, 0x42, 0xd4, 0xc6, 0xa5, 0x79, 0x13, 0x4f,
	0x84, 0xfd, 0x9e, 0x30, 0xb7, 0x76, 0x61, 0x39, 0xfe, 0xba, 0x8b, 0x38, 0x76, 0x33, 0x1c, 0x60,
	0xc0, 0xb1, 0xa4, 0x60, 0xfb, 0x3d, 0xa6, 0x67, 0xb0, 0x14, 0x22, 0xfe, 0x16, 0xcb, 0x31, 0xa5,
	0x78, 0x0a, 0x06, 0x3c, 0xc5, 0x1e, 0x48, 0xd1, 0x34, 0xe0, 0xae, 0x76, 0x68, 0x90, 0x6d, 0xc1,
	0x80, 0xed, 0xb6, 0xc2, 0xbe, 0xea, 0xe7, 0x3c, 0x83, 0x62, 0xff, 0x04, 0x2c, 0x2d, 0x3e, 0xc8,
	0x3d, 0x2c, 0x56, 0x0e, 0x9c, 0xab, 0xc6, 0xb4, 0x1c, 0x81, 0x4e, 0xaf, 0x17, 0x9f, 0x4b, 0xf4,
	0xa1, 0x02, 0x3f, 0xa3, 0xdd, 0xf0, 0x8a, 0xbf, 0x1a, 0x8b, 0xad, 0xec, 0x57, 0x51, 0x65, 0x11,
	0x27, 0x1e, 0x76, 0x23, 0x8e, 0x5b, 0xe4, 0xbc, 0x54, 0x34, 0xa9, 0x32, 0x89, 0x38, 0x90, 0x00,
	0x71, 0xb6, 0x11, 0x67, 0x21, 0x53, 0xf5, 0xb1, 0x64, 0x72, 0xb6, 0xd2, 0x5e, 0x14, 0x86, 0xfd,
	0xeb, 0x1c, 0x14, 0xeb, 0x28, 0x08, 0x3e, 0xa3, 0x41, 0xaa, 0x27, 0x4f, 0x61, 0xc1, 0x63, 0x5d,
	0x9a, 0xf0, 0x0b, 0xd7, 0x63, 0xbe, 0x99, 0x9a, 0x14, 0x34, 0xa2, 0xce, 0x7c, 0x2c, 0x23, 0xea,
	0x30, 0x8a, 0x5d, 0xda, 0x0d, 0x4f, 0x30, 0x37, 0x92, 0x92, 0x82, 0x44, 0xbc, 0x96, 0x80, 0x61,
	0x25, 0x98, 0x9e, 0x58, 0x09, 0x06, 0x45, 0x7b, 0xe6, 0xda, 0xa2, 0x3d, 0x3b, 0xf1, 0xe0, 0x7a,
	0x0c, 0x0b, 0xaa, 0x83, 0x39, 0xf2, 0xde, 0x62, 0x5f, 0xeb, 0xc7, 0x28, 0x15, 0x2a, 0xc8, 0xc6,
	0x55, 0xe6, 0x56, 0x03, 0xee, 0xf9, 0x24, 0x46, 0x52, 0xc5, 0xfa, 0x77, 0x3d, 0x2d, 0x25, 0xa3,
	0x98, 0xee, 0x68, 0xa8, 0x38, 0xdb, 0x7a, 0x0f, 0x68, 0xb9, 0xf0, 0x9f, 0xec, 0xd1, 0xb8, 0xa7,
	0x98, 0x93, 0x16, 0xf1, 0x90, 0xd4, 0x97, 0x2e, 0x0f, 0x8c, 0xe4, 0x65, 0x35, 0x73, 0x56, 0xcd,
	0x0c, 0xc1, 0x17, 0x3c, 0xb0, 0xf6, 0x60, 0x39, 0xb3, 0x93, 0x2a, 0xe1, 0x32, 0xd2, 0x9b, 0x5b,
	0x97, 0x30, 0xa5, 0x5b, 0xd6, 0xf7, 0x39, 0x58, 0xbd, 0x7a, 0xbf, 0x95, 0x02, 0x54, 0xac, 0x1c,
	0x8f, 0x69, 0xcf, 0xfe, 0xf8, 0x1b, 0x29, 0xc7, 0xa1, 0xa0, 0x90, 0x4d, 0x3a, 0xca, 0xa0, 0x51,
	0xf2, 0xae, 0xf8, 0xc7, 0xfe, 0x0a, 0xd6, 0xd2, 0xdd, 0xef, 0xef, 0x76, 0x86, 0x81, 0x59, 0x98,
	0x9b, 0x70, 0x16, 0xda, 0x8b, 0x50, 0xd8, 0x65, 0x09, 0x0e, 0x14, 0x9d, 0x7d, 0x07, 0x56, 0x0e,
	0x3b, 0x2c, 0x8a, 0xc4, 0xed, 0x43, 0xc4, 0xf5, 0xaa, 0x69, 0xdf, 0x83, 0x3b, 0xe9, 0xcf, 0x07,
	0x9c, 0xf9, 0x5d, 0x2f, 0xfd, 0xe3, 0xdd, 0x0c, 0x14, 0x5e, 0x84, 0x88, 0x04, 0xbd, 0x15, 0x61,
	0x2e, 0xc1, 0x28, 0xc6, 0x5c, 0x7b, 0xf2, 0x7f, 0x67, 0xf4, 0xb3, 0x87, 0x23, 0xc1, 0x47, 0x12,
	0xd2, 0xd0, 0x50, 0xd1, 0xd6, 0x62, 0x3b, 0xc0, 0x5c, 0x6b, 0xad, 0x51, 0x5b, 0x2b, 0xc4, 0x95,
	0xea, 0x3f, 0xfd, 0x0f, 0xd4, 0xbf, 0x09, 0xa5, 0x01, 0x9a, 0xcb, 0xad, 0xc5, 0xa4, 0xcd, 0xef,
	0xf6, 0xf3, 0xf5, 0xf6, 0x97, 0x63, 0x58, 0x1b, 0xe4, 0xcd, 0x9e, 0xa1, 0x49, 0xff, 0xff, 0xab,
	0x9f, 0x7a, 0x27, 0xb3, 0xdd, 0x7c, 0x9b, 0x83, 0xff, 0x0d, 0xd1, 0xeb, 0xa7, 0xaf, 0xfe, 0x39,
	0xaf, 0x75, 0x62, 0x73, 0xdc, 0x19, 0xe9, 0xf1, 0x52, 0xcf, 0xcc, 0xfa, 0xc6, 0x7f, 0x07, 0x1c,
	0x18, 0x36, 0xb1, 0xbf, 0x9b, 0xd2, 0xb5, 0xa1, 0x8e, 0xf7, 0x1a, 0x0f, 0x61, 0x03, 0x45, 0x3e,
	0x75, 0xed, 0x85, 0x6f, 0x72, 0x99, 0xef, 0xdf, 0x6b, 0x66, 0x26, 0xda, 0x6b, 0xec, 0x6f, 0xc4,
	0xc2, 0x3f, 0x9c, 0x21, 0x6b, 0x1d, 0x66, 0xe4, 0x28, 0x35, 0xc9, 0x86, 0xb4, 0x14, 0x6e, 0x88,
	0x4f, 0xbd, 0xe8, 0x99, 0x24, 0x62, 0x5e, 0xd8, 0xcb, 0x45, 0xcf, 0xfe, 0x69, 0x16, 0x0a, 0xd2,
	0x21, 0xdd, 0xac, 0x9f, 0x40, 0x21, 0x22, 0xe7, 0x38, 0x70, 0xcf, 0x88, 0x9f, 0x74, 0x74, 0x50,
	0x6b, 0x43, 0x6c, 0x7b, 0x34, 0xf9, 0xf0, 0x91, 0x22, 0x03, 0x69, 0xff, 0xa5, 0x30, 0xb7, 0x9e,
	0xc0, 0x82, 0x42, 0x77, 0x30, 0x69, 0x77, 0x12, 0x5d, 0xb6, 0x23, 0xe1, 0xea, 0x76, 0xbb, 0xd2,
	0xde, 0xfa, 0x18, 0xe6, 0x55, 0x71, 0x8a, 0x69, 0x60, 0xb2, 0xf1, 0xe6, 0xa5, 0xb9, 0xd0, 0xfe,
	0x97, 0xb0, 0x12, 0x71, 0x7c, 0x4a, 0xf0, 0x99, 0x9b, 0x0d, 0xe0, 0xe6, 0x78, 0x0f, 0x96, 0x35,
	0xee, 0xe0, 0x32, 0x8e, 0x57, 0x70, 0xbb, 0x9f, 0x4c, 0xc7, 0x93, 0x1f, 0xcf, 0x66, 0x65, 0xd9,
	0x74, 0x58, 0xbb, 0x90, 0xde, 0xc3, 0xbd, 0x0c, 0xcf, 0x64, 0x2e, 0x2d, 0x69, 0xd8, 0x5e, 0x1a,
	0xe5, 0xe7, 0x30, 0xdf, 0x7b, 0xed, 0xa1, 0x87, 0xd0, 0xa3, 0x31, 0x43, 0xe8, 0x15, 0x09, 0xf1,
	0xd1, 0x45, 0xa4, 0x06, 0x4e, 0xfa, 0xa5, 0x91, 0x0f, 0xf5, 0x95, 0x28, 0x38, 0x59, 0xff, 0x26,
	0xbb, 0xb0, 0xb4, 0xb4, 0x1e, 0x03, 0x84, 0xd8, 0x27, 0xc8, 0x6d, 0x91, 0xc0, 0xa8, 0x6d, 0x77,
	0x6f, 0x34, 0xe6, 0x25, 0xe2, 0x39, 0x09, 0xb0, 0xb5, 0x01, 0x33, 0x3e, 0x4a, 0x90, 0xae, 0xd4,
	0xe1, 0x64, 0x6e, 0x5f, 0x24, 0x38, 0x4e, 0x71, 0xd2, 0x74, 0xfb, 0x26, 0xcc, 0xca, 0xc4, 0xd9,
	0xbf, 0xe4, 0x60, 0xad, 0x49, 0x7c, 0xcc, 0x8e, 0x78, 0x17, 0x37, 0x45, 0x66, 0xe8, 0x61, 0xc2,
	0x31, 0x0a, 0x75, 0xf9, 0xee, 0xc3, 0x8a, 0x7e, 0x5e, 0x39, 0xe9, 0x26, 0x09, 0xa3, 0x6e, 0x80,
	0x4e, 0x70, 0x60, 0xd4, 0x4c, 0xcb, 0x0a, 0xb8, 0x2d, 0x71, 0xfb, 0x02, 0x26, 0x66, 0x86, 0x66,
	0x9b, 0xe8, 0xc9, 0xb4, 0xa8, 0x40, 0xa9, 0xb6, 0xdb, 0x3f, 0xe7, 0xa0, 0x20, 0x9d, 0xd6, 0x4e,
	0x6e, 0x4d, 0x9a, 0xbf, 0x6c, 0xf6, 0xde, 0xc0, 0x3c, 0xa1, 0x6e, 0x2c, 0x83, 0xd6, 0xde, 0x6c,
	0x8d, 0x13, 0xeb, 0x11, 0x19, 0xdb, 0xbd, 0xd1, 0xc8, 0x13, 0xfd, 0xcb, 0x76, 0x1e, 0xe6, 0xd4,
	0xe3, 0xc1, 0xf6, 0x9f, 0x39, 0xb0, 0x3d, 0x16, 0x8e, 0x21, 0xde, 0xbe, 0x55, 0xf3, 0x45, 0x0d,
	0x09, 0xa2, 0xf8, 0x40, 0x38, 0x7e, 0x90, 0x7b, 0xb3, 0xa3, 0x31, 0x6d, 0x16, 0x20, 0xda, 0x76,
	0x18, 0x6f, 0x97, 0xdb, 0x98, 0xca, 0xb0, 0xd2, 0xb7, 0x78, 0x11, 0x89, 0xaf, 0x7a, 0x59, 0xb9,
	0xa5, 0x3e, 0x7e, 0x98, 0x9a, 0x7e, 0x51, 0xab, 0xfd, 0x38, 0x75, 0xff, 0x85, 0x22, 0xab, 0xf9,
	0xb1, 0xa3, 0x2e, 0xc5, 0x55, 0x73, 0xdd, 0xa9, 0x4b, 0xb3, 0xf7, 0xa9, 0xc1, 0x71, 0xcd, 0x8f,
	0x8f, 0x7b, 0x06, 0xc7, 0xcd, 0xf5, 0x63, 0x65, 0xf0, 0xc7, 0x94, 0xad, 0x7e, 0xad, 0x56, 0x6b,
	0x7e, 0x5c, 0xad, 0xf6, 0x4c, 0xaa, 0xd5, 0xe6, 0x7a, 0xb5, 0xaa, 0x8c, 0x4e, 0xe6, 0xa4, 0x77,
	0x9b, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x59, 0x12, 0xc2, 0x79, 0x49, 0x15, 0x00, 0x00,
}
