// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/common/metrics.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v0/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Metrics data.
type Metrics struct {
	// The percent of your ad impressions that are shown as the very first ad
	// above the organic search results.
	AbsoluteTopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,95,opt,name=absolute_top_impression_percentage,json=absoluteTopImpressionPercentage,proto3" json:"absolute_top_impression_percentage,omitempty"`
	// Average cost of viewable impressions (`active_view_impressions`).
	ActiveViewCpm *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=active_view_cpm,json=activeViewCpm,proto3" json:"active_view_cpm,omitempty"`
	// Active view measurable clicks divided by active view viewable impressions.
	// This metric is reported only for display network.
	ActiveViewCtr *wrappers.DoubleValue `protobuf:"bytes,79,opt,name=active_view_ctr,json=activeViewCtr,proto3" json:"active_view_ctr,omitempty"`
	// A measurement of how often your ad has become viewable on a Display
	// Network site.
	ActiveViewImpressions *wrappers.Int64Value `protobuf:"bytes,2,opt,name=active_view_impressions,json=activeViewImpressions,proto3" json:"active_view_impressions,omitempty"`
	// The ratio of impressions that could be measured by Active View over the
	// number of served impressions.
	ActiveViewMeasurability *wrappers.DoubleValue `protobuf:"bytes,96,opt,name=active_view_measurability,json=activeViewMeasurability,proto3" json:"active_view_measurability,omitempty"`
	// The cost of the impressions you received that were measurable by Active
	// View.
	ActiveViewMeasurableCostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=active_view_measurable_cost_micros,json=activeViewMeasurableCostMicros,proto3" json:"active_view_measurable_cost_micros,omitempty"`
	// The number of times your ads are appearing on placements in positions
	// where they can be seen.
	ActiveViewMeasurableImpressions *wrappers.Int64Value `protobuf:"bytes,4,opt,name=active_view_measurable_impressions,json=activeViewMeasurableImpressions,proto3" json:"active_view_measurable_impressions,omitempty"`
	// The percentage of time when your ad appeared on an Active View enabled site
	// (measurable impressions) and was viewable (viewable impressions).
	ActiveViewViewability *wrappers.DoubleValue `protobuf:"bytes,97,opt,name=active_view_viewability,json=activeViewViewability,proto3" json:"active_view_viewability,omitempty"`
	// All conversions from interactions (as oppose to view through conversions)
	// divided by the number of ad interactions.
	AllConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,65,opt,name=all_conversions_from_interactions_rate,json=allConversionsFromInteractionsRate,proto3" json:"all_conversions_from_interactions_rate,omitempty"`
	// The total value of all conversions.
	AllConversionsValue *wrappers.DoubleValue `protobuf:"bytes,66,opt,name=all_conversions_value,json=allConversionsValue,proto3" json:"all_conversions_value,omitempty"`
	// The total number of conversions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	AllConversions *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=all_conversions,json=allConversions,proto3" json:"all_conversions,omitempty"`
	// The value of all conversions divided by the total cost of ad interactions
	// (such as clicks for text ads or views for video ads).
	AllConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,62,opt,name=all_conversions_value_per_cost,json=allConversionsValuePerCost,proto3" json:"all_conversions_value_per_cost,omitempty"`
	// The value of all conversions from interactions divided by the total number
	// of interactions.
	AllConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,67,opt,name=all_conversions_from_interactions_value_per_interaction,json=allConversionsFromInteractionsValuePerInteraction,proto3" json:"all_conversions_from_interactions_value_per_interaction,omitempty"`
	// The average amount you pay per interaction. This amount is the total cost
	// of your ads divided by the total number of interactions.
	AverageCost *wrappers.DoubleValue `protobuf:"bytes,8,opt,name=average_cost,json=averageCost,proto3" json:"average_cost,omitempty"`
	// The total cost of all clicks divided by the total number of clicks
	// received.
	AverageCpc *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// The average amount that you've been charged for an ad engagement. This
	// amount is the total cost of all ad engagements divided by the total number
	// of ad engagements.
	AverageCpe *wrappers.DoubleValue `protobuf:"bytes,98,opt,name=average_cpe,json=averageCpe,proto3" json:"average_cpe,omitempty"`
	// Average cost-per-thousand impressions (CPM).
	AverageCpm *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=average_cpm,json=averageCpm,proto3" json:"average_cpm,omitempty"`
	// The average amount you pay each time someone views your ad.
	// The average CPV is defined by the total cost of all ad views divided by
	// the number of views.
	AverageCpv *wrappers.DoubleValue `protobuf:"bytes,11,opt,name=average_cpv,json=averageCpv,proto3" json:"average_cpv,omitempty"`
	// Average number of times a unique cookie was exposed to your ad
	// over a given time period. Imported from Google Analytics.
	AverageFrequency *wrappers.DoubleValue `protobuf:"bytes,12,opt,name=average_frequency,json=averageFrequency,proto3" json:"average_frequency,omitempty"`
	// Average number of pages viewed per session.
	AveragePageViews *wrappers.DoubleValue `protobuf:"bytes,99,opt,name=average_page_views,json=averagePageViews,proto3" json:"average_page_views,omitempty"`
	// Your ad's position relative to those of other advertisers.
	AveragePosition *wrappers.DoubleValue `protobuf:"bytes,13,opt,name=average_position,json=averagePosition,proto3" json:"average_position,omitempty"`
	// Total duration of all sessions (in seconds) / number of sessions. Imported
	// from Google Analytics.
	AverageTimeOnSite *wrappers.DoubleValue `protobuf:"bytes,84,opt,name=average_time_on_site,json=averageTimeOnSite,proto3" json:"average_time_on_site,omitempty"`
	// An indication of how other advertisers are bidding on similar products.
	BenchmarkAverageMaxCpc *wrappers.DoubleValue `protobuf:"bytes,14,opt,name=benchmark_average_max_cpc,json=benchmarkAverageMaxCpc,proto3" json:"benchmark_average_max_cpc,omitempty"`
	// An indication on how other advertisers' Shopping ads for similar products
	// are performing based on how often people who see their ad click on it.
	BenchmarkCtr *wrappers.DoubleValue `protobuf:"bytes,77,opt,name=benchmark_ctr,json=benchmarkCtr,proto3" json:"benchmark_ctr,omitempty"`
	// Percentage of clicks where the user only visited a single page on your
	// site. Imported from Google Analytics.
	BounceRate *wrappers.DoubleValue `protobuf:"bytes,15,opt,name=bounce_rate,json=bounceRate,proto3" json:"bounce_rate,omitempty"`
	// The number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,19,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// The estimated percent of times that your ad was eligible to show
	// on the Display Network but didn't because your budget was too low.
	// Note: Content budget lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,20,opt,name=content_budget_lost_impression_share,json=contentBudgetLostImpressionShare,proto3" json:"content_budget_lost_impression_share,omitempty"`
	// The impressions you've received on the Display Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Content impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	ContentImpressionShare *wrappers.DoubleValue `protobuf:"bytes,21,opt,name=content_impression_share,json=contentImpressionShare,proto3" json:"content_impression_share,omitempty"`
	// The last date/time a conversion tag for this conversion action successfully
	// fired and was seen by Google Ads. This firing event may not have been the
	// result of an attributable conversion (e.g. because the tag was fired from a
	// browser that did not previously click an ad from an appropriate
	// advertiser). The date/time is in the customer's time zone.
	ConversionLastReceivedRequestDateTime *wrappers.StringValue `protobuf:"bytes,73,opt,name=conversion_last_received_request_date_time,json=conversionLastReceivedRequestDateTime,proto3" json:"conversion_last_received_request_date_time,omitempty"`
	// The date of the most recent conversion for this conversion action. The date
	// is in the customer's time zone.
	ConversionLastConversionDate *wrappers.StringValue `protobuf:"bytes,74,opt,name=conversion_last_conversion_date,json=conversionLastConversionDate,proto3" json:"conversion_last_conversion_date,omitempty"`
	// The estimated percentage of impressions on the Display Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Content rank lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,22,opt,name=content_rank_lost_impression_share,json=contentRankLostImpressionShare,proto3" json:"content_rank_lost_impression_share,omitempty"`
	// Conversions from interactions divided by the number of ad interactions
	// (such as clicks for text ads or views for video ads). This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	ConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,69,opt,name=conversions_from_interactions_rate,json=conversionsFromInteractionsRate,proto3" json:"conversions_from_interactions_rate,omitempty"`
	// The total value of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsValue *wrappers.DoubleValue `protobuf:"bytes,70,opt,name=conversions_value,json=conversionsValue,proto3" json:"conversions_value,omitempty"`
	// The value of conversions divided by the cost of ad interactions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,71,opt,name=conversions_value_per_cost,json=conversionsValuePerCost,proto3" json:"conversions_value_per_cost,omitempty"`
	// The value of conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,72,opt,name=conversions_from_interactions_value_per_interaction,json=conversionsFromInteractionsValuePerInteraction,proto3" json:"conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,25,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// The sum of your cost-per-click (CPC) and cost-per-thousand impressions
	// (CPM) costs during this period.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// The cost of ad interactions divided by all conversions.
	CostPerAllConversions *wrappers.DoubleValue `protobuf:"bytes,68,opt,name=cost_per_all_conversions,json=costPerAllConversions,proto3" json:"cost_per_all_conversions,omitempty"`
	// The cost of ad interactions divided by conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CostPerConversion *wrappers.DoubleValue `protobuf:"bytes,28,opt,name=cost_per_conversion,json=costPerConversion,proto3" json:"cost_per_conversion,omitempty"`
	// The cost of ad interactions divided by current model attributed
	// conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CostPerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,106,opt,name=cost_per_current_model_attributed_conversion,json=costPerCurrentModelAttributedConversion,proto3" json:"cost_per_current_model_attributed_conversion,omitempty"`
	// Conversions from when a customer clicks on a Google Ads ad on one device,
	// then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions *wrappers.DoubleValue `protobuf:"bytes,29,opt,name=cross_device_conversions,json=crossDeviceConversions,proto3" json:"cross_device_conversions,omitempty"`
	// The number of clicks your ad receives (Clicks) divided by the number
	// of times your ad is shown (Impressions).
	Ctr *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// Shows how your historic conversions data would look under the attribution
	// model you've currently selected. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversions *wrappers.DoubleValue `protobuf:"bytes,101,opt,name=current_model_attributed_conversions,json=currentModelAttributedConversions,proto3" json:"current_model_attributed_conversions,omitempty"`
	// Current model attributed conversions from interactions divided by the
	// number of ad interactions (such as clicks for text ads or views for video
	// ads). This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,102,opt,name=current_model_attributed_conversions_from_interactions_rate,json=currentModelAttributedConversionsFromInteractionsRate,proto3" json:"current_model_attributed_conversions_from_interactions_rate,omitempty"`
	// The value of current model attributed conversions from interactions divided
	// by the number of ad interactions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,103,opt,name=current_model_attributed_conversions_from_interactions_value_per_interaction,json=currentModelAttributedConversionsFromInteractionsValuePerInteraction,proto3" json:"current_model_attributed_conversions_from_interactions_value_per_interaction,omitempty"`
	// The total value of current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CurrentModelAttributedConversionsValue *wrappers.DoubleValue `protobuf:"bytes,104,opt,name=current_model_attributed_conversions_value,json=currentModelAttributedConversionsValue,proto3" json:"current_model_attributed_conversions_value,omitempty"`
	// The value of current model attributed conversions divided by the cost of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,105,opt,name=current_model_attributed_conversions_value_per_cost,json=currentModelAttributedConversionsValuePerCost,proto3" json:"current_model_attributed_conversions_value_per_cost,omitempty"`
	// How often people engage with your ad after it's shown to them. This is the
	// number of ad expansions divided by the number of times your ad is shown.
	EngagementRate *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=engagement_rate,json=engagementRate,proto3" json:"engagement_rate,omitempty"`
	// The number of engagements.
	// An engagement occurs when a viewer expands your Lightbox ad. Also, in the
	// future, other ad types may support engagement metrics.
	Engagements *wrappers.Int64Value `protobuf:"bytes,32,opt,name=engagements,proto3" json:"engagements,omitempty"`
	// Average lead value of hotel.
	HotelAverageLeadValueMicros *wrappers.DoubleValue `protobuf:"bytes,75,opt,name=hotel_average_lead_value_micros,json=hotelAverageLeadValueMicros,proto3" json:"hotel_average_lead_value_micros,omitempty"`
	// The creative historical quality score.
	HistoricalCreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,80,opt,name=historical_creative_quality_score,json=historicalCreativeQualityScore,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_creative_quality_score,omitempty"`
	// The quality of historical landing page experience.
	HistoricalLandingPageQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,81,opt,name=historical_landing_page_quality_score,json=historicalLandingPageQualityScore,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_landing_page_quality_score,omitempty"`
	// The historical quality score.
	HistoricalQualityScore *wrappers.Int64Value `protobuf:"bytes,82,opt,name=historical_quality_score,json=historicalQualityScore,proto3" json:"historical_quality_score,omitempty"`
	// The historical search predicted click through rate (CTR).
	HistoricalSearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,83,opt,name=historical_search_predicted_ctr,json=historicalSearchPredictedCtr,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_search_predicted_ctr,omitempty"`
	// The number of times the ad was forwarded to someone else as a message.
	GmailForwards *wrappers.Int64Value `protobuf:"bytes,85,opt,name=gmail_forwards,json=gmailForwards,proto3" json:"gmail_forwards,omitempty"`
	// The number of times someone has saved your Gmail ad to their inbox as a
	// message.
	GmailSaves *wrappers.Int64Value `protobuf:"bytes,86,opt,name=gmail_saves,json=gmailSaves,proto3" json:"gmail_saves,omitempty"`
	// The number of clicks to the landing page on the expanded state of Gmail
	// ads.
	GmailSecondaryClicks *wrappers.Int64Value `protobuf:"bytes,87,opt,name=gmail_secondary_clicks,json=gmailSecondaryClicks,proto3" json:"gmail_secondary_clicks,omitempty"`
	// Number of unique cookies that were exposed to your ad over a given time
	// period.
	ImpressionReach *wrappers.Int64Value `protobuf:"bytes,36,opt,name=impression_reach,json=impressionReach,proto3" json:"impression_reach,omitempty"`
	// Count of how often your ad has appeared on a search results page or
	// website on the Google Network.
	Impressions *wrappers.Int64Value `protobuf:"bytes,37,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// How often people interact with your ad after it is shown to them.
	// This is the number of interactions divided by the number of times your ad
	// is shown.
	InteractionRate *wrappers.DoubleValue `protobuf:"bytes,38,opt,name=interaction_rate,json=interactionRate,proto3" json:"interaction_rate,omitempty"`
	// The number of interactions.
	// An interaction is the main user action associated with an ad format-clicks
	// for text and shopping ads, views for video ads, and so on.
	Interactions *wrappers.Int64Value `protobuf:"bytes,39,opt,name=interactions,proto3" json:"interactions,omitempty"`
	// The types of payable and free interactions.
	InteractionEventTypes []enums.InteractionEventTypeEnum_InteractionEventType `protobuf:"varint,100,rep,packed,name=interaction_event_types,json=interactionEventTypes,proto3,enum=google.ads.googleads.v0.enums.InteractionEventTypeEnum_InteractionEventType" json:"interaction_event_types,omitempty"`
	// The percentage of clicks filtered out of your total number of clicks
	// (filtered + non-filtered clicks) during the reporting period.
	InvalidClickRate *wrappers.DoubleValue `protobuf:"bytes,40,opt,name=invalid_click_rate,json=invalidClickRate,proto3" json:"invalid_click_rate,omitempty"`
	// Number of clicks Google considers illegitimate and doesn't charge you for.
	InvalidClicks *wrappers.Int64Value `protobuf:"bytes,41,opt,name=invalid_clicks,json=invalidClicks,proto3" json:"invalid_clicks,omitempty"`
	// Percentage of first-time sessions (from people who had never visited your
	// site before). Imported from Google Analytics.
	PercentNewVisitors *wrappers.DoubleValue `protobuf:"bytes,42,opt,name=percent_new_visitors,json=percentNewVisitors,proto3" json:"percent_new_visitors,omitempty"`
	// Number of offline phone calls.
	PhoneCalls *wrappers.Int64Value `protobuf:"bytes,43,opt,name=phone_calls,json=phoneCalls,proto3" json:"phone_calls,omitempty"`
	// Number of offline phone impressions.
	PhoneImpressions *wrappers.Int64Value `protobuf:"bytes,44,opt,name=phone_impressions,json=phoneImpressions,proto3" json:"phone_impressions,omitempty"`
	// Number of phone calls received (phone_calls) divided by the number of
	// times your phone number is shown (phone_impressions).
	PhoneThroughRate *wrappers.DoubleValue `protobuf:"bytes,45,opt,name=phone_through_rate,json=phoneThroughRate,proto3" json:"phone_through_rate,omitempty"`
	// Your clickthrough rate (Ctr) divided by the average clickthrough rate of
	// all advertisers on the websites that show your ads. Measures how your ads
	// perform on Display Network sites compared to other ads on the same sites.
	RelativeCtr *wrappers.DoubleValue `protobuf:"bytes,46,opt,name=relative_ctr,json=relativeCtr,proto3" json:"relative_ctr,omitempty"`
	// The percentage of the customer's Shopping or Search ad impressions that are
	// shown in the most prominent Shopping position. See
	// <a href="https://support.google.com/adwords/answer/7501826">this Merchant
	// Center article</a> for details. Any value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,78,opt,name=search_absolute_top_impression_share,json=searchAbsoluteTopImpressionShare,proto3" json:"search_absolute_top_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to a low budget. Note: Search
	// budget lost absolute top impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,88,opt,name=search_budget_lost_absolute_top_impression_share,json=searchBudgetLostAbsoluteTopImpressionShare,proto3" json:"search_budget_lost_absolute_top_impression_share,omitempty"`
	// The estimated percent of times that your ad was eligible to show on the
	// Search Network but didn't because your budget was too low. Note: Search
	// budget lost impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,47,opt,name=search_budget_lost_impression_share,json=searchBudgetLostImpressionShare,proto3" json:"search_budget_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to a low budget. Note: Search
	// budget lost top impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,89,opt,name=search_budget_lost_top_impression_share,json=searchBudgetLostTopImpressionShare,proto3" json:"search_budget_lost_top_impression_share,omitempty"`
	// The number of clicks you've received on the Search Network
	// divided by the estimated number of clicks you were eligible to receive.
	// Note: Search click share is reported in the range of 0.1 to 1. Any value
	// below 0.1 is reported as 0.0999.
	SearchClickShare *wrappers.DoubleValue `protobuf:"bytes,48,opt,name=search_click_share,json=searchClickShare,proto3" json:"search_click_share,omitempty"`
	// The impressions you've received divided by the estimated number of
	// impressions you were eligible to receive on the Search Network for search
	// terms that matched your keywords exactly (or were close variants of your
	// keyword), regardless of your keyword match types. Note: Search exact match
	// impression share is reported in the range of 0.1 to 1. Any value below 0.1
	// is reported as 0.0999.
	SearchExactMatchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,49,opt,name=search_exact_match_impression_share,json=searchExactMatchImpressionShare,proto3" json:"search_exact_match_impression_share,omitempty"`
	// The impressions you've received on the Search Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Search impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,50,opt,name=search_impression_share,json=searchImpressionShare,proto3" json:"search_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost absolute top impression share is reported in the
	// range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,90,opt,name=search_rank_lost_absolute_top_impression_share,json=searchRankLostAbsoluteTopImpressionShare,proto3" json:"search_rank_lost_absolute_top_impression_share,omitempty"`
	// The estimated percentage of impressions on the Search Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Search rank lost impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,51,opt,name=search_rank_lost_impression_share,json=searchRankLostImpressionShare,proto3" json:"search_rank_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost top impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,91,opt,name=search_rank_lost_top_impression_share,json=searchRankLostTopImpressionShare,proto3" json:"search_rank_lost_top_impression_share,omitempty"`
	// The impressions you've received in the top location (anywhere above the
	// organic search results) compared to the estimated number of impressions you
	// were eligible to receive in the top location.
	// Note: Search top impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,92,opt,name=search_top_impression_share,json=searchTopImpressionShare,proto3" json:"search_top_impression_share,omitempty"`
	// The percent of your ad impressions that are shown anywhere above the
	// organic search results.
	TopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,93,opt,name=top_impression_percentage,json=topImpressionPercentage,proto3" json:"top_impression_percentage,omitempty"`
	// The value of all conversions divided by the number of all conversions.
	ValuePerAllConversions *wrappers.DoubleValue `protobuf:"bytes,52,opt,name=value_per_all_conversions,json=valuePerAllConversions,proto3" json:"value_per_all_conversions,omitempty"`
	// The value of conversions divided by the number of conversions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ValuePerConversion *wrappers.DoubleValue `protobuf:"bytes,53,opt,name=value_per_conversion,json=valuePerConversion,proto3" json:"value_per_conversion,omitempty"`
	// The value of current model attributed conversions divided by the number of
	// the conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ValuePerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,94,opt,name=value_per_current_model_attributed_conversion,json=valuePerCurrentModelAttributedConversion,proto3" json:"value_per_current_model_attributed_conversion,omitempty"`
	// Percentage of impressions where the viewer watched all of your video.
	VideoQuartile_100Rate *wrappers.DoubleValue `protobuf:"bytes,54,opt,name=video_quartile_100_rate,json=videoQuartile100Rate,proto3" json:"video_quartile_100_rate,omitempty"`
	// Percentage of impressions where the viewer watched 25% of your video.
	VideoQuartile_25Rate *wrappers.DoubleValue `protobuf:"bytes,55,opt,name=video_quartile_25_rate,json=videoQuartile25Rate,proto3" json:"video_quartile_25_rate,omitempty"`
	// Percentage of impressions where the viewer watched 50% of your video.
	VideoQuartile_50Rate *wrappers.DoubleValue `protobuf:"bytes,56,opt,name=video_quartile_50_rate,json=videoQuartile50Rate,proto3" json:"video_quartile_50_rate,omitempty"`
	// Percentage of impressions where the viewer watched 75% of your video.
	VideoQuartile_75Rate *wrappers.DoubleValue `protobuf:"bytes,57,opt,name=video_quartile_75_rate,json=videoQuartile75Rate,proto3" json:"video_quartile_75_rate,omitempty"`
	// The number of views your TrueView video ad receives divided by its number
	// of impressions, including thumbnail impressions for TrueView in-display
	// ads.
	VideoViewRate *wrappers.DoubleValue `protobuf:"bytes,58,opt,name=video_view_rate,json=videoViewRate,proto3" json:"video_view_rate,omitempty"`
	// The number of times your video ads were viewed.
	VideoViews *wrappers.Int64Value `protobuf:"bytes,59,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	// The total number of view-through conversions.
	// These happen when a customer sees an image or rich media ad, then later
	// completes a conversion on your site without interacting with (e.g.,
	// clicking on) another ad.
	ViewThroughConversions *wrappers.Int64Value `protobuf:"bytes,60,opt,name=view_through_conversions,json=viewThroughConversions,proto3" json:"view_through_conversions,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_metrics_95a397a18c95a545, []int{0}
}
func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (dst *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(dst, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetAbsoluteTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.AbsoluteTopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetActiveViewCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCpm
	}
	return nil
}

func (m *Metrics) GetActiveViewCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCtr
	}
	return nil
}

func (m *Metrics) GetActiveViewImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewMeasurability
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableCostMicros
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewViewability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewViewability
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetAllConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValue
	}
	return nil
}

func (m *Metrics) GetAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversions
	}
	return nil
}

func (m *Metrics) GetAllConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetAverageCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCost
	}
	return nil
}

func (m *Metrics) GetAverageCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpc
	}
	return nil
}

func (m *Metrics) GetAverageCpe() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpe
	}
	return nil
}

func (m *Metrics) GetAverageCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpm
	}
	return nil
}

func (m *Metrics) GetAverageCpv() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpv
	}
	return nil
}

func (m *Metrics) GetAverageFrequency() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageFrequency
	}
	return nil
}

func (m *Metrics) GetAveragePageViews() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePageViews
	}
	return nil
}

func (m *Metrics) GetAveragePosition() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePosition
	}
	return nil
}

func (m *Metrics) GetAverageTimeOnSite() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageTimeOnSite
	}
	return nil
}

func (m *Metrics) GetBenchmarkAverageMaxCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkAverageMaxCpc
	}
	return nil
}

func (m *Metrics) GetBenchmarkCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkCtr
	}
	return nil
}

func (m *Metrics) GetBounceRate() *wrappers.DoubleValue {
	if m != nil {
		return m.BounceRate
	}
	return nil
}

func (m *Metrics) GetClicks() *wrappers.Int64Value {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Metrics) GetContentBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetContentImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionLastReceivedRequestDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastReceivedRequestDateTime
	}
	return nil
}

func (m *Metrics) GetConversionLastConversionDate() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastConversionDate
	}
	return nil
}

func (m *Metrics) GetContentRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValue
	}
	return nil
}

func (m *Metrics) GetConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Metrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Metrics) GetCostPerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerAllConversions
	}
	return nil
}

func (m *Metrics) GetCostPerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerConversion
	}
	return nil
}

func (m *Metrics) GetCostPerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetCrossDeviceConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CrossDeviceConversions
	}
	return nil
}

func (m *Metrics) GetCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.Ctr
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversions
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValue
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetEngagementRate() *wrappers.DoubleValue {
	if m != nil {
		return m.EngagementRate
	}
	return nil
}

func (m *Metrics) GetEngagements() *wrappers.Int64Value {
	if m != nil {
		return m.Engagements
	}
	return nil
}

func (m *Metrics) GetHotelAverageLeadValueMicros() *wrappers.DoubleValue {
	if m != nil {
		return m.HotelAverageLeadValueMicros
	}
	return nil
}

func (m *Metrics) GetHistoricalCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalCreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalLandingPageQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalLandingPageQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalQualityScore() *wrappers.Int64Value {
	if m != nil {
		return m.HistoricalQualityScore
	}
	return nil
}

func (m *Metrics) GetHistoricalSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalSearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetGmailForwards() *wrappers.Int64Value {
	if m != nil {
		return m.GmailForwards
	}
	return nil
}

func (m *Metrics) GetGmailSaves() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSaves
	}
	return nil
}

func (m *Metrics) GetGmailSecondaryClicks() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSecondaryClicks
	}
	return nil
}

func (m *Metrics) GetImpressionReach() *wrappers.Int64Value {
	if m != nil {
		return m.ImpressionReach
	}
	return nil
}

func (m *Metrics) GetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Metrics) GetInteractionRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InteractionRate
	}
	return nil
}

func (m *Metrics) GetInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.Interactions
	}
	return nil
}

func (m *Metrics) GetInteractionEventTypes() []enums.InteractionEventTypeEnum_InteractionEventType {
	if m != nil {
		return m.InteractionEventTypes
	}
	return nil
}

func (m *Metrics) GetInvalidClickRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InvalidClickRate
	}
	return nil
}

func (m *Metrics) GetInvalidClicks() *wrappers.Int64Value {
	if m != nil {
		return m.InvalidClicks
	}
	return nil
}

func (m *Metrics) GetPercentNewVisitors() *wrappers.DoubleValue {
	if m != nil {
		return m.PercentNewVisitors
	}
	return nil
}

func (m *Metrics) GetPhoneCalls() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneCalls
	}
	return nil
}

func (m *Metrics) GetPhoneImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneImpressions
	}
	return nil
}

func (m *Metrics) GetPhoneThroughRate() *wrappers.DoubleValue {
	if m != nil {
		return m.PhoneThroughRate
	}
	return nil
}

func (m *Metrics) GetRelativeCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.RelativeCtr
	}
	return nil
}

func (m *Metrics) GetSearchAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchClickShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchClickShare
	}
	return nil
}

func (m *Metrics) GetSearchExactMatchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchExactMatchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.TopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetValuePerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerAllConversions
	}
	return nil
}

func (m *Metrics) GetValuePerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerConversion
	}
	return nil
}

func (m *Metrics) GetValuePerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_100Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_100Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_25Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_25Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_50Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_50Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_75Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_75Rate
	}
	return nil
}

func (m *Metrics) GetVideoViewRate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViewRate
	}
	return nil
}

func (m *Metrics) GetVideoViews() *wrappers.Int64Value {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

func (m *Metrics) GetViewThroughConversions() *wrappers.Int64Value {
	if m != nil {
		return m.ViewThroughConversions
	}
	return nil
}

func init() {
	proto.RegisterType((*Metrics)(nil), "google.ads.googleads.v0.common.Metrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/common/metrics.proto", fileDescriptor_metrics_95a397a18c95a545)
}

var fileDescriptor_metrics_95a397a18c95a545 = []byte{
	// 2153 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x9a, 0xdb, 0x72, 0x1b, 0xb7,
	0x19, 0xc7, 0x87, 0x76, 0x27, 0x69, 0x3f, 0xd9, 0x92, 0xb3, 0x96, 0x2d, 0x48, 0x76, 0x24, 0x59,
	0xf5, 0x41, 0x75, 0x6d, 0x8a, 0x96, 0xa3, 0x38, 0xa5, 0xed, 0x64, 0xa8, 0x93, 0x2d, 0x55, 0x72,
	0x74, 0x32, 0xed, 0x24, 0x6a, 0x37, 0xe0, 0x2e, 0x44, 0x6e, 0xb4, 0x07, 0x1a, 0x00, 0x29, 0x6b,
	0x3a, 0xed, 0x45, 0xa7, 0x17, 0xed, 0x55, 0x3b, 0xd3, 0x9b, 0x4c, 0x2f, 0x7b, 0xd9, 0x27, 0xe8,
	0x33, 0xf4, 0x45, 0x3a, 0xd3, 0xa7, 0xe8, 0xe0, 0xb0, 0x5c, 0x90, 0x5c, 0x8a, 0x50, 0x26, 0x37,
	0x0e, 0xb5, 0xc1, 0xff, 0xf7, 0xff, 0x80, 0x05, 0x3e, 0x00, 0x1f, 0x09, 0x0f, 0xea, 0x49, 0x52,
	0x0f, 0xc9, 0x02, 0xf6, 0xd9, 0x82, 0xfa, 0x28, 0x3e, 0xb5, 0x4b, 0x0b, 0x5e, 0x12, 0x45, 0x49,
	0xbc, 0x10, 0x11, 0x4e, 0x03, 0x8f, 0x15, 0x9b, 0x34, 0xe1, 0x89, 0x33, 0xad, 0x9a, 0x14, 0xb1,
	0xcf, 0x8a, 0x9d, 0xd6, 0xc5, 0x76, 0xa9, 0xa8, 0x5a, 0x4f, 0x95, 0x07, 0xd1, 0x48, 0xdc, 0x8a,
	0xd8, 0x42, 0x10, 0x73, 0x42, 0xb1, 0xc7, 0x83, 0x24, 0x76, 0x49, 0x9b, 0xc4, 0xdc, 0xe5, 0xa7,
	0x4d, 0xa2, 0xd8, 0x53, 0x9f, 0x9d, 0xad, 0x7d, 0xd7, 0xc2, 0x61, 0xc0, 0x4f, 0x5d, 0xe6, 0x25,
	0x94, 0xb8, 0xb5, 0x96, 0x77, 0x4c, 0xb8, 0x56, 0xea, 0xa8, 0x16, 0xe4, 0x5f, 0xb5, 0xd6, 0xd1,
	0xc2, 0x09, 0xc5, 0xcd, 0x26, 0xa1, 0x3a, 0xea, 0xb9, 0xef, 0x2b, 0xf0, 0xe1, 0xb6, 0xea, 0x87,
	0x13, 0xc0, 0x1c, 0xae, 0xb1, 0x24, 0x6c, 0x71, 0xe2, 0xf2, 0xa4, 0xe9, 0x06, 0x51, 0x93, 0x12,
	0xc6, 0x44, 0x44, 0x4d, 0x42, 0x3d, 0x12, 0x73, 0x5c, 0x27, 0xc8, 0x9d, 0x2d, 0xcc, 0x8f, 0x2c,
	0xde, 0xd4, 0x7d, 0x2c, 0xa6, 0xe0, 0xe2, 0x6a, 0xd2, 0xaa, 0x85, 0xa4, 0x8a, 0xc3, 0x16, 0xd9,
	0x9b, 0x49, 0x39, 0x07, 0x49, 0x73, 0xa3, 0x43, 0xd9, 0xe9, 0x40, 0x9c, 0x55, 0x18, 0x13, 0x7d,
	0x6d, 0x13, 0xb7, 0x1d, 0x90, 0x13, 0xd7, 0x6b, 0x46, 0xa8, 0x60, 0xc1, 0xbd, 0xac, 0x44, 0xd5,
	0x80, 0x9c, 0xac, 0x34, 0xa3, 0x3e, 0x0a, 0xa7, 0xe8, 0xcb, 0x73, 0x52, 0x38, 0x75, 0xf6, 0x61,
	0xc2, 0xa4, 0x64, 0xbd, 0x66, 0xe8, 0x82, 0xa4, 0xdd, 0xe8, 0xa3, 0x6d, 0xc4, 0xfc, 0xd3, 0x4f,
	0x14, 0xec, 0x5a, 0x06, 0xcb, 0x7a, 0xca, 0x9c, 0xb7, 0x30, 0x69, 0x42, 0x23, 0x82, 0x59, 0x8b,
	0xe2, 0x5a, 0x20, 0xde, 0x13, 0xfa, 0xd6, 0x22, 0xc8, 0x89, 0x8c, 0xbb, 0x6d, 0x8a, 0x9d, 0x3a,
	0xcc, 0xe5, 0x91, 0x43, 0xe2, 0x7a, 0x09, 0xe3, 0x6e, 0x14, 0x78, 0x34, 0x61, 0xe8, 0xe2, 0xf0,
	0xc8, 0xa7, 0xfb, 0x1d, 0x42, 0xb2, 0x92, 0x30, 0xbe, 0x2d, 0x11, 0x4e, 0x63, 0xa0, 0x91, 0x39,
	0x44, 0x3f, 0x19, 0x6e, 0x34, 0x93, 0x67, 0x64, 0x0e, 0xd6, 0x41, 0xf7, 0x1b, 0x10, 0xff, 0xa4,
	0x43, 0x85, 0x2d, 0x86, 0xca, 0x78, 0x05, 0xd5, 0x4c, 0xea, 0x34, 0xe1, 0x2e, 0x0e, 0x43, 0xd7,
	0x4b, 0xe2, 0x36, 0xa1, 0xd2, 0xc8, 0x3d, 0xa2, 0x49, 0xe4, 0x1a, 0x2b, 0x8d, 0xb9, 0x14, 0x73,
	0x82, 0x2a, 0x16, 0x26, 0x73, 0x38, 0x0c, 0x57, 0x32, 0xd4, 0x3a, 0x4d, 0xa2, 0x0d, 0x03, 0xb4,
	0x87, 0x39, 0x71, 0x76, 0xe0, 0x5a, 0xaf, 0x63, 0x5b, 0x88, 0xd1, 0xb2, 0x85, 0xc1, 0xd5, 0x6e,
	0x03, 0xf9, 0xd0, 0x59, 0x83, 0xb1, 0x1e, 0x22, 0xfa, 0xd0, 0x82, 0x35, 0xda, 0xcd, 0x72, 0xbe,
	0x85, 0xe9, 0xdc, 0xc0, 0xc4, 0xba, 0x96, 0xd3, 0x06, 0x7d, 0x6e, 0x41, 0x9d, 0xca, 0x89, 0x70,
	0x87, 0x50, 0x31, 0x65, 0x9c, 0xbf, 0x15, 0xe0, 0xc9, 0xf0, 0xd1, 0xce, 0x4c, 0x8d, 0xc7, 0x68,
	0xc5, 0xc2, 0xfb, 0xd1, 0xd9, 0xc3, 0x9f, 0xc6, 0x62, 0x3c, 0x73, 0xbe, 0x80, 0x4b, 0xb8, 0x4d,
	0x28, 0xae, 0xab, 0x95, 0x81, 0x7e, 0x6a, 0x61, 0x33, 0xa2, 0x15, 0xb2, 0x4f, 0xcf, 0x61, 0xa4,
	0x03, 0x68, 0x7a, 0xe8, 0x67, 0x16, 0x7a, 0x48, 0xf5, 0x4d, 0xaf, 0x5b, 0x4e, 0x50, 0xed, 0x5c,
	0x72, 0xd2, 0x2d, 0x8f, 0x10, 0x9c, 0x4b, 0x1e, 0x75, 0xcb, 0xdb, 0x68, 0xe4, 0x5c, 0xf2, 0xb6,
	0xb3, 0x01, 0x1f, 0xa5, 0xf2, 0x23, 0x4a, 0xde, 0xb5, 0x48, 0xec, 0x9d, 0xa2, 0x4b, 0x16, 0x90,
	0x2b, 0x5a, 0xb6, 0x9e, 0xaa, 0x9c, 0x4d, 0x70, 0x52, 0x54, 0x53, 0xfc, 0x23, 0x96, 0x37, 0x43,
	0xde, 0x39, 0x58, 0x3b, 0xb8, 0x2e, 0x57, 0x37, 0x73, 0x5e, 0xc0, 0x95, 0x0e, 0x2b, 0x61, 0x81,
	0x9c, 0x3e, 0x97, 0x2d, 0x48, 0x63, 0x29, 0x49, 0x8b, 0x9c, 0x6d, 0x18, 0x4f, 0x41, 0x3c, 0x88,
	0x88, 0x9b, 0xc4, 0x2e, 0x0b, 0x38, 0x41, 0x07, 0x16, 0xb0, 0x74, 0x64, 0x0e, 0x82, 0x88, 0x7c,
	0x19, 0xef, 0x07, 0x9c, 0x38, 0x6f, 0x60, 0xb2, 0x46, 0x62, 0xaf, 0x11, 0x61, 0x7a, 0xec, 0xa6,
	0xe0, 0x08, 0xbf, 0x97, 0x13, 0x67, 0xd4, 0x82, 0x79, 0xbd, 0x23, 0xaf, 0x28, 0xf5, 0x36, 0x7e,
	0x2f, 0x26, 0x51, 0x05, 0x2e, 0x67, 0x60, 0xb1, 0xc1, 0x6d, 0x5b, 0xc0, 0x2e, 0x75, 0x24, 0x62,
	0x7f, 0x7b, 0x0e, 0x23, 0xb5, 0xa4, 0x15, 0x7b, 0x44, 0x25, 0xbb, 0x31, 0x9b, 0x99, 0xa0, 0x04,
	0x32, 0xa9, 0x3d, 0x86, 0x0f, 0xbc, 0x30, 0xf0, 0x8e, 0x19, 0xba, 0x3a, 0x3c, 0xd5, 0xeb, 0xa6,
	0x4e, 0x08, 0xb7, 0xbd, 0x24, 0xe6, 0xe2, 0x18, 0x53, 0x6b, 0xf9, 0x75, 0xc2, 0xdd, 0x50, 0x6c,
	0x4e, 0xc6, 0x89, 0x82, 0x35, 0x30, 0x25, 0x68, 0xdc, 0x22, 0x98, 0x59, 0x4d, 0x5a, 0x96, 0xa0,
	0xad, 0x84, 0xf1, 0x6c, 0xef, 0xd8, 0x17, 0x14, 0xa7, 0x0a, 0x28, 0x75, 0xeb, 0x73, 0xb8, 0x66,
	0x33, 0xf8, 0x5a, 0xdd, 0xcb, 0x3d, 0x81, 0xfb, 0x59, 0x3e, 0x73, 0x43, 0xcc, 0xb8, 0x4b, 0x89,
	0x47, 0x82, 0x36, 0xf1, 0x5d, 0x39, 0xbd, 0x19, 0x77, 0x7d, 0xcc, 0xd5, 0x14, 0x42, 0x1b, 0x03,
	0x9c, 0xf6, 0x39, 0x0d, 0xe2, 0xba, 0x72, 0xba, 0x93, 0xf1, 0xb6, 0x30, 0xe3, 0x7b, 0x9a, 0xb6,
	0xa7, 0x60, 0xab, 0x98, 0xcb, 0x49, 0xe5, 0x78, 0x30, 0xd3, 0x6b, 0x6c, 0xfc, 0x2d, 0x2c, 0xd1,
	0xa6, 0x85, 0xdb, 0xcd, 0x6e, 0xb7, 0x2c, 0x7f, 0x0a, 0x23, 0xb1, 0xbf, 0xa7, 0xa3, 0x46, 0x71,
	0x7c, 0x3c, 0xe0, 0x0d, 0x5d, 0xb7, 0x18, 0xbf, 0x69, 0xcd, 0xd9, 0xc3, 0xf1, 0x71, 0xde, 0xfb,
	0x09, 0xa4, 0xd3, 0xb0, 0x5d, 0x78, 0xcd, 0xe6, 0x60, 0xe9, 0x0d, 0xd9, 0x82, 0x37, 0xe0, 0xa3,
	0xfe, 0xed, 0x77, 0xdd, 0x26, 0xd7, 0x78, 0xbd, 0x7b, 0xef, 0x57, 0x30, 0x75, 0xc6, 0x86, 0xf9,
	0xc2, 0xe6, 0x0c, 0xe7, 0x0d, 0xd8, 0x2d, 0xff, 0x52, 0x80, 0xc7, 0x3f, 0x64, 0xa7, 0x7c, 0x69,
	0x61, 0x5a, 0xf4, 0xce, 0xb7, 0x4d, 0x7e, 0x0e, 0x23, 0xe6, 0xf1, 0x62, 0xd2, 0x66, 0x97, 0x34,
	0x04, 0xce, 0x33, 0xa1, 0xcf, 0x0e, 0x9e, 0x53, 0xc3, 0x93, 0x04, 0x78, 0xd9, 0x21, 0xf3, 0xb5,
	0x58, 0xba, 0x8c, 0xcb, 0x9e, 0xf6, 0x9e, 0x74, 0x56, 0x6d, 0xce, 0x7e, 0x42, 0xbd, 0x43, 0x68,
	0xa5, 0xfb, 0xc0, 0xb3, 0x05, 0x57, 0x3b, 0xd8, 0x0c, 0x89, 0x6e, 0xda, 0x64, 0x77, 0x4d, 0xcc,
	0x70, 0xce, 0xef, 0xe0, 0x41, 0x46, 0x6b, 0x51, 0x2a, 0x96, 0x4c, 0x94, 0xf8, 0x24, 0x74, 0x31,
	0xe7, 0x34, 0xa8, 0xb5, 0x38, 0xf1, 0x4d, 0x9b, 0xef, 0x2c, 0x6c, 0xee, 0xa5, 0x36, 0x8a, 0xb7,
	0x2d, 0x70, 0x95, 0x0e, 0xcd, 0x30, 0x17, 0xc9, 0x8d, 0x26, 0x8c, 0xb9, 0x3e, 0x69, 0x07, 0x1e,
	0xe9, 0x1a, 0xa1, 0x8f, 0xad, 0x92, 0x9b, 0x50, 0xaf, 0x4a, 0xb1, 0x39, 0x44, 0x45, 0xb8, 0x28,
	0xf6, 0x93, 0x69, 0x0b, 0x84, 0x68, 0xe8, 0x44, 0x70, 0xdb, 0xa2, 0xef, 0x0c, 0x11, 0x0b, 0xe0,
	0x2d, 0x6f, 0x48, 0xaf, 0x99, 0xf3, 0x7d, 0x01, 0x9e, 0xda, 0xf8, 0x0d, 0xca, 0x26, 0x47, 0x16,
	0x61, 0x2c, 0x0d, 0x0d, 0x23, 0x37, 0xc7, 0xfc, 0xbb, 0x00, 0x5b, 0x3f, 0x30, 0xb4, 0xfc, 0x65,
	0x5d, 0xb7, 0x88, 0x75, 0xf5, 0xdc, 0xb1, 0xe6, 0x2d, 0xf6, 0xf7, 0x70, 0xdf, 0x2a, 0x72, 0x95,
	0x37, 0x1b, 0x16, 0x71, 0xdd, 0x1d, 0x1a, 0x97, 0xca, 0xa6, 0x7f, 0x16, 0x29, 0xcf, 0xda, 0x3a,
	0xcb, 0xb3, 0x81, 0x45, 0x0c, 0x0f, 0xed, 0x62, 0x48, 0xb3, 0xef, 0x1a, 0x8c, 0x91, 0xb8, 0x8e,
	0xeb, 0x24, 0x52, 0x7b, 0x1f, 0x27, 0x68, 0xc6, 0xe6, 0x52, 0x95, 0x89, 0xe4, 0x34, 0x78, 0x0e,
	0x23, 0xd9, 0x13, 0x86, 0x66, 0x87, 0x27, 0x3e, 0xb3, 0xbd, 0x53, 0x83, 0x99, 0x46, 0xc2, 0xc5,
	0x38, 0xe8, 0xe3, 0x62, 0x48, 0xb0, 0xaf, 0x7b, 0xaf, 0x73, 0xe9, 0xaf, 0x2d, 0xa2, 0xba, 0x21,
	0x21, 0xfa, 0xd0, 0xb8, 0x45, 0xb0, 0x2f, 0x1f, 0xeb, 0xec, 0xfa, 0xf7, 0x02, 0xdc, 0x6a, 0x04,
	0x8c, 0x27, 0x34, 0xf0, 0x70, 0xe8, 0x7a, 0x94, 0x60, 0x79, 0xcd, 0xee, 0x2a, 0x18, 0xa1, 0x9d,
	0xd9, 0xc2, 0xfc, 0xe8, 0xe2, 0xcb, 0xe2, 0xa0, 0x02, 0x96, 0x2c, 0x32, 0x15, 0x77, 0x95, 0x66,
	0x5f, 0x48, 0x96, 0x65, 0x89, 0x69, 0x2d, 0x6e, 0x45, 0x39, 0x8f, 0xf7, 0xa6, 0x33, 0xcb, 0x15,
	0xed, 0x68, 0xb6, 0x72, 0xfe, 0x51, 0x80, 0x3b, 0x46, 0x54, 0x21, 0x8e, 0xfd, 0x20, 0xae, 0xab,
	0xcb, 0x41, 0x77, 0x64, 0xbb, 0x3f, 0x72, 0x64, 0xc6, 0x60, 0x6c, 0x29, 0x57, 0x71, 0xb5, 0xe8,
	0x0a, 0xee, 0x35, 0x20, 0x23, 0xb6, 0xee, 0x70, 0xf6, 0x86, 0xbf, 0xe2, 0xeb, 0x99, 0xb8, 0x0b,
	0xfb, 0xd7, 0x02, 0xcc, 0x18, 0x5c, 0x46, 0x30, 0xf5, 0x1a, 0x6e, 0x93, 0x12, 0x3f, 0xf0, 0xe4,
	0x0a, 0xe0, 0x14, 0xed, 0xff, 0xc8, 0xbd, 0xbd, 0x99, 0x19, 0xee, 0x4b, 0xbf, 0x9d, 0xd4, 0x4e,
	0x5c, 0x0b, 0x96, 0x61, 0xb4, 0x1e, 0xe1, 0x20, 0x74, 0x8f, 0x12, 0x7a, 0x82, 0xa9, 0xcf, 0xd0,
	0xeb, 0xe1, 0xdd, 0xbb, 0x2c, 0x25, 0xeb, 0x5a, 0x21, 0xf6, 0x7e, 0xc5, 0x60, 0xb8, 0x4d, 0x18,
	0xaa, 0x5a, 0xec, 0xfd, 0xb2, 0xfd, 0xbe, 0x68, 0xee, 0xec, 0xc2, 0x75, 0xad, 0x26, 0x5e, 0x12,
	0xfb, 0x98, 0x9e, 0xba, 0xfa, 0xa6, 0xf1, 0x66, 0x38, 0x68, 0x5c, 0x81, 0x52, 0xe5, 0x8a, 0xba,
	0x77, 0xac, 0xc3, 0x15, 0xe3, 0x04, 0x4b, 0x09, 0xf6, 0x1a, 0xe8, 0xf6, 0x70, 0xd8, 0x58, 0x26,
	0xda, 0x13, 0x1a, 0xb1, 0xb6, 0xcd, 0x22, 0xd7, 0x1d, 0x8b, 0xb5, 0x6d, 0xb4, 0x17, 0xd7, 0x54,
	0xb3, 0x9e, 0x2b, 0x53, 0xcc, 0x5d, 0x9b, 0x6b, 0xaa, 0xa1, 0x92, 0x39, 0xe6, 0x0b, 0xb8, 0x64,
	0xee, 0x1f, 0xe8, 0xde, 0xf0, 0x40, 0xba, 0x04, 0xce, 0x9f, 0x0a, 0x30, 0x91, 0x5f, 0x5a, 0x66,
	0xc8, 0x9f, 0xbd, 0x38, 0x3f, 0xba, 0xb8, 0x35, 0x64, 0xbe, 0x19, 0xdb, 0xc7, 0x9a, 0x10, 0x1f,
	0x9c, 0x36, 0x89, 0x9c, 0x71, 0x79, 0xff, 0x63, 0xef, 0x5a, 0x90, 0xf3, 0x94, 0x39, 0x9b, 0xe0,
	0x04, 0x71, 0x1b, 0x87, 0x81, 0xaf, 0x5e, 0xb1, 0x1a, 0x92, 0x79, 0x9b, 0x73, 0xb9, 0xd6, 0xc9,
	0x17, 0x2c, 0xc7, 0x64, 0x19, 0x46, 0xbb, 0x58, 0x0c, 0xfd, 0xc2, 0x62, 0xe2, 0x9a, 0x18, 0xe6,
	0xbc, 0x82, 0x71, 0x5d, 0xd2, 0x76, 0x63, 0x59, 0x71, 0x64, 0x01, 0x4f, 0x28, 0x43, 0xf7, 0x2d,
	0x22, 0x72, 0xb4, 0xf2, 0x15, 0x39, 0xa9, 0x6a, 0x9d, 0x58, 0x08, 0xcd, 0x46, 0x12, 0x13, 0xd7,
	0xc3, 0x61, 0xc8, 0xd0, 0x2f, 0x2d, 0x16, 0x82, 0x6c, 0xbf, 0x22, 0x9a, 0x3b, 0x2f, 0xe1, 0x23,
	0xa5, 0x36, 0xe7, 0xdc, 0x83, 0xe1, 0x8c, 0x2b, 0x52, 0x65, 0x56, 0x52, 0x37, 0xc1, 0x51, 0x24,
	0xde, 0xa0, 0x49, 0xab, 0xde, 0x50, 0xe3, 0xfc, 0xd0, 0x66, 0x9c, 0xa5, 0xee, 0x40, 0xc9, 0xd2,
	0xb9, 0x47, 0x49, 0xa8, 0x36, 0x0c, 0x91, 0x9e, 0x8a, 0x36, 0x37, 0x83, 0x54, 0x21, 0x32, 0x4c,
	0x08, 0xb7, 0x75, 0x9e, 0x1b, 0xf4, 0xb5, 0x82, 0xba, 0x62, 0xbe, 0xb2, 0x29, 0x02, 0x28, 0x52,
	0x25, 0xef, 0x7b, 0x05, 0x75, 0xc9, 0xfc, 0x63, 0x01, 0x4a, 0xda, 0xce, 0x2c, 0x39, 0x9c, 0x6d,
	0xfd, 0xd6, 0xc2, 0xfa, 0xbe, 0xa2, 0x66, 0xe5, 0x87, 0x33, 0x82, 0xf8, 0x0e, 0x7e, 0x9e, 0x13,
	0x43, 0x9f, 0xed, 0x82, 0xcd, 0x55, 0xb7, 0xd7, 0xb6, 0xd7, 0xeb, 0x1d, 0xdc, 0xcb, 0xf1, 0xca,
	0xed, 0xe6, 0x57, 0x36, 0x05, 0xee, 0x5e, 0xbf, 0x9c, 0xee, 0x6d, 0x82, 0xa3, 0x2d, 0xd5, 0x2a,
	0x56, 0xf4, 0x92, 0xcd, 0xf4, 0x52, 0x3a, 0xb9, 0xfc, 0x7a, 0x87, 0x8a, 0xbc, 0xc7, 0x1e, 0x77,
	0x23, 0xcc, 0xbd, 0x46, 0x7f, 0xe8, 0x8f, 0xec, 0x87, 0x6a, 0x4d, 0x70, 0xb6, 0x05, 0xa6, 0x37,
	0xee, 0x03, 0x98, 0xd0, 0x5e, 0x7d, 0xfc, 0x45, 0x9b, 0x4b, 0xa6, 0x12, 0xf7, 0x52, 0xff, 0x00,
	0x45, 0x4d, 0xcd, 0xea, 0x27, 0x67, 0x4f, 0xb7, 0xaf, 0x2d, 0xcc, 0xe6, 0x15, 0x33, 0xad, 0xa5,
	0x9c, 0x31, 0xd9, 0x8e, 0xe0, 0x56, 0x9f, 0x7f, 0x9f, 0xe5, 0x63, 0x0b, 0xcb, 0x8f, 0xbb, 0x2d,
	0x7b, 0x7d, 0x22, 0xb8, 0xd3, 0xe7, 0x93, 0xdb, 0xbd, 0x6f, 0xec, 0x17, 0x72, 0xea, 0x95, 0xd3,
	0xad, 0x6f, 0xe0, 0x86, 0xb6, 0xcb, 0x35, 0x39, 0xb4, 0x30, 0x41, 0x0a, 0x90, 0x03, 0x7f, 0x0b,
	0x93, 0x83, 0xbf, 0xda, 0xfc, 0x8d, 0x4d, 0x4d, 0x87, 0x0f, 0xf8, 0x4a, 0xf3, 0x0d, 0x4c, 0x66,
	0x57, 0x97, 0xde, 0x52, 0xc6, 0x27, 0x36, 0x17, 0xf5, 0xb6, 0xbe, 0xa4, 0xf4, 0xd4, 0x32, 0x5e,
	0xc1, 0xb8, 0x79, 0x27, 0xea, 0x54, 0x19, 0x96, 0x6c, 0xf6, 0xaa, 0x76, 0xe7, 0xe2, 0xd3, 0x29,
	0x28, 0xfc, 0x1e, 0x1e, 0x1a, 0x3c, 0x8b, 0x72, 0xc6, 0x6f, 0x6d, 0x66, 0x6d, 0xc7, 0x68, 0x58,
	0x3d, 0x63, 0x1f, 0x26, 0xda, 0x81, 0x4f, 0x12, 0x71, 0xb6, 0xa6, 0x3c, 0x08, 0x89, 0xfb, 0xa8,
	0x54, 0x52, 0xfb, 0xd4, 0xa7, 0x16, 0x46, 0xe3, 0x52, 0xbc, 0xab, 0xb5, 0x8f, 0x4a, 0x25, 0xb9,
	0x57, 0xed, 0xc2, 0xf5, 0x1e, 0xe8, 0xe2, 0x92, 0x62, 0x3e, 0xb1, 0xf9, 0xea, 0xad, 0x8b, 0xb9,
	0xb8, 0x34, 0x00, 0xb9, 0xa4, 0xc3, 0xfc, 0xec, 0xdc, 0xc8, 0xa5, 0x41, 0x51, 0x3e, 0xd1, 0x51,
	0xfe, 0xea, 0xdc, 0xc8, 0x27, 0x2a, 0xca, 0x55, 0x18, 0x53, 0x48, 0xf9, 0xcd, 0xa9, 0x64, 0x95,
	0x6d, 0xbe, 0x02, 0x97, 0xa2, 0x6a, 0x40, 0x4e, 0x24, 0xe5, 0x19, 0x8c, 0x64, 0x14, 0x86, 0x9e,
	0x5a, 0x1c, 0x5f, 0x3a, 0x00, 0x59, 0xc3, 0x93, 0xee, 0xe9, 0x99, 0xc3, 0x9c, 0xf8, 0xcf, 0x2c,
	0xae, 0x4c, 0x42, 0xac, 0x0f, 0x1e, 0xc6, 0xbc, 0x5f, 0xfe, 0x6f, 0x01, 0xe6, 0xbc, 0x24, 0x2a,
	0x9e, 0xfd, 0xbb, 0x8a, 0xe5, 0x4b, 0xfa, 0xe7, 0x0b, 0x3b, 0x02, 0xbd, 0x53, 0xf8, 0x7a, 0x55,
	0xb7, 0xaf, 0x27, 0x21, 0x8e, 0xeb, 0xc5, 0x84, 0xd6, 0x17, 0xea, 0x24, 0x96, 0xc6, 0xe9, 0x6f,
	0x27, 0x9a, 0x01, 0x1b, 0xf4, 0xa3, 0x8e, 0xa7, 0xea, 0x3f, 0xff, 0xbc, 0x70, 0xf1, 0x45, 0xa5,
	0xf2, 0xaf, 0x0b, 0xd3, 0x2f, 0x14, 0xac, 0xe2, 0xb3, 0xa2, 0xfa, 0x28, 0x3e, 0x55, 0x4b, 0xc5,
	0x15, 0xd9, 0xec, 0x3f, 0x69, 0x83, 0xc3, 0x8a, 0xcf, 0x0e, 0x3b, 0x0d, 0x0e, 0xab, 0xa5, 0x43,
	0xd5, 0xe0, 0x7f, 0x17, 0xe6, 0xd4, 0xd3, 0x72, 0xb9, 0xe2, 0xb3, 0x72, 0xb9, 0xd3, 0xa4, 0x5c,
	0xae, 0x96, 0xca, 0x65, 0xd5, 0xa8, 0xf6, 0x81, 0x8c, 0xee, 0xf1, 0xff, 0x03, 0x00, 0x00, 0xff,
	0xff, 0xe1, 0x34, 0x90, 0x09, 0x71, 0x22, 0x00, 0x00,
}
