// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/common/policy.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v0/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Key of the violation. The key is used for referring to a violation
// when filing an exemption request.
type PolicyViolationKey struct {
	// Unique ID of the violated policy.
	PolicyName *wrappers.StringValue `protobuf:"bytes,1,opt,name=policy_name,json=policyName,proto3" json:"policy_name,omitempty"`
	// The text that violates the policy if specified.
	// Otherwise, refers to the policy in general
	// (e.g., when requesting to be exempt from the whole policy).
	// If not specified for criterion exemptions, the whole policy is implied.
	// Must be specified for ad exemptions.
	ViolatingText        *wrappers.StringValue `protobuf:"bytes,2,opt,name=violating_text,json=violatingText,proto3" json:"violating_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyViolationKey) Reset()         { *m = PolicyViolationKey{} }
func (m *PolicyViolationKey) String() string { return proto.CompactTextString(m) }
func (*PolicyViolationKey) ProtoMessage()    {}
func (*PolicyViolationKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{0}
}
func (m *PolicyViolationKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyViolationKey.Unmarshal(m, b)
}
func (m *PolicyViolationKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyViolationKey.Marshal(b, m, deterministic)
}
func (dst *PolicyViolationKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyViolationKey.Merge(dst, src)
}
func (m *PolicyViolationKey) XXX_Size() int {
	return xxx_messageInfo_PolicyViolationKey.Size(m)
}
func (m *PolicyViolationKey) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyViolationKey.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyViolationKey proto.InternalMessageInfo

func (m *PolicyViolationKey) GetPolicyName() *wrappers.StringValue {
	if m != nil {
		return m.PolicyName
	}
	return nil
}

func (m *PolicyViolationKey) GetViolatingText() *wrappers.StringValue {
	if m != nil {
		return m.ViolatingText
	}
	return nil
}

// Parameter for controlling how policy checking is done.
type PolicyValidationParameter struct {
	// The list of policy topics that should not cause a PolicyFindingError to
	// be reported. This field is currently only compatible with Enhanced Text Ad.
	// It corresponds to the PolicyTopicEntry.topic field.
	//
	// Resources violating these policies will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	IgnorablePolicyTopics []*wrappers.StringValue `protobuf:"bytes,1,rep,name=ignorable_policy_topics,json=ignorablePolicyTopics,proto3" json:"ignorable_policy_topics,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                `json:"-"`
	XXX_unrecognized      []byte                  `json:"-"`
	XXX_sizecache         int32                   `json:"-"`
}

func (m *PolicyValidationParameter) Reset()         { *m = PolicyValidationParameter{} }
func (m *PolicyValidationParameter) String() string { return proto.CompactTextString(m) }
func (*PolicyValidationParameter) ProtoMessage()    {}
func (*PolicyValidationParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{1}
}
func (m *PolicyValidationParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyValidationParameter.Unmarshal(m, b)
}
func (m *PolicyValidationParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyValidationParameter.Marshal(b, m, deterministic)
}
func (dst *PolicyValidationParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyValidationParameter.Merge(dst, src)
}
func (m *PolicyValidationParameter) XXX_Size() int {
	return xxx_messageInfo_PolicyValidationParameter.Size(m)
}
func (m *PolicyValidationParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyValidationParameter.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyValidationParameter proto.InternalMessageInfo

func (m *PolicyValidationParameter) GetIgnorablePolicyTopics() []*wrappers.StringValue {
	if m != nil {
		return m.IgnorablePolicyTopics
	}
	return nil
}

// Policy finding attached to a resource (e.g. alcohol policy associated with
// a site that sells alcohol).
//
// Each PolicyTopicEntry has a topic that indicates the specific ads policy
// the entry is about and a type to indicate the effect that the entry will have
// on serving. It may optionally have one or more evidences that indicate the
// reason for the finding. It may also optionally have one or more constraints
// that provide details about how serving may be restricted.
//
// Next tag: 5
type PolicyTopicEntry struct {
	// Policy topic this finding refers to. For example, "ALCOHOL",
	// "TRADEMARKS_IN_AD_TEXT", or "DESTINATION_NOT_WORKING". The set of possible
	// policy topics is not fixed for a particular API version and may change
	// at any time.
	Topic *wrappers.StringValue `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Describes the negative or positive effect this policy will have on serving.
	Type enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType" json:"type,omitempty"`
	// Additional information that explains policy finding
	// (e.g. the brand name for a trademark finding).
	Evidences []*PolicyTopicEvidence `protobuf:"bytes,3,rep,name=evidences,proto3" json:"evidences,omitempty"`
	// Indicates how serving of this resource may be affected (e.g. not serving
	// in a country).
	Constraints          []*PolicyTopicConstraint `protobuf:"bytes,4,rep,name=constraints,proto3" json:"constraints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PolicyTopicEntry) Reset()         { *m = PolicyTopicEntry{} }
func (m *PolicyTopicEntry) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEntry) ProtoMessage()    {}
func (*PolicyTopicEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{2}
}
func (m *PolicyTopicEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEntry.Unmarshal(m, b)
}
func (m *PolicyTopicEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEntry.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEntry.Merge(dst, src)
}
func (m *PolicyTopicEntry) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEntry.Size(m)
}
func (m *PolicyTopicEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEntry.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEntry proto.InternalMessageInfo

func (m *PolicyTopicEntry) GetTopic() *wrappers.StringValue {
	if m != nil {
		return m.Topic
	}
	return nil
}

func (m *PolicyTopicEntry) GetType() enums.PolicyTopicEntryTypeEnum_PolicyTopicEntryType {
	if m != nil {
		return m.Type
	}
	return enums.PolicyTopicEntryTypeEnum_UNSPECIFIED
}

func (m *PolicyTopicEntry) GetEvidences() []*PolicyTopicEvidence {
	if m != nil {
		return m.Evidences
	}
	return nil
}

func (m *PolicyTopicEntry) GetConstraints() []*PolicyTopicConstraint {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// Additional information that explains a policy finding.
//
// Next Id: 8
type PolicyTopicEvidence struct {
	// Specific evidence information depending on the evidence type.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicEvidence_HttpCode
	//	*PolicyTopicEvidence_WebsiteList_
	//	*PolicyTopicEvidence_TextList_
	//	*PolicyTopicEvidence_LanguageCode
	//	*PolicyTopicEvidence_DestinationTextList_
	//	*PolicyTopicEvidence_DestinationMismatch_
	Value                isPolicyTopicEvidence_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *PolicyTopicEvidence) Reset()         { *m = PolicyTopicEvidence{} }
func (m *PolicyTopicEvidence) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence) ProtoMessage()    {}
func (*PolicyTopicEvidence) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{3}
}
func (m *PolicyTopicEvidence) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEvidence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence.Merge(dst, src)
}
func (m *PolicyTopicEvidence) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence.Size(m)
}
func (m *PolicyTopicEvidence) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence proto.InternalMessageInfo

type isPolicyTopicEvidence_Value interface {
	isPolicyTopicEvidence_Value()
}

type PolicyTopicEvidence_HttpCode struct {
	HttpCode *wrappers.Int32Value `protobuf:"bytes,2,opt,name=http_code,json=httpCode,proto3,oneof"`
}

type PolicyTopicEvidence_WebsiteList_ struct {
	WebsiteList *PolicyTopicEvidence_WebsiteList `protobuf:"bytes,3,opt,name=website_list,json=websiteList,proto3,oneof"`
}

type PolicyTopicEvidence_TextList_ struct {
	TextList *PolicyTopicEvidence_TextList `protobuf:"bytes,4,opt,name=text_list,json=textList,proto3,oneof"`
}

type PolicyTopicEvidence_LanguageCode struct {
	LanguageCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=language_code,json=languageCode,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationTextList_ struct {
	DestinationTextList *PolicyTopicEvidence_DestinationTextList `protobuf:"bytes,6,opt,name=destination_text_list,json=destinationTextList,proto3,oneof"`
}

type PolicyTopicEvidence_DestinationMismatch_ struct {
	DestinationMismatch *PolicyTopicEvidence_DestinationMismatch `protobuf:"bytes,7,opt,name=destination_mismatch,json=destinationMismatch,proto3,oneof"`
}

func (*PolicyTopicEvidence_HttpCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_WebsiteList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_TextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_LanguageCode) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationTextList_) isPolicyTopicEvidence_Value() {}

func (*PolicyTopicEvidence_DestinationMismatch_) isPolicyTopicEvidence_Value() {}

func (m *PolicyTopicEvidence) GetValue() isPolicyTopicEvidence_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicEvidence) GetHttpCode() *wrappers.Int32Value {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_HttpCode); ok {
		return x.HttpCode
	}
	return nil
}

func (m *PolicyTopicEvidence) GetWebsiteList() *PolicyTopicEvidence_WebsiteList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_WebsiteList_); ok {
		return x.WebsiteList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetTextList() *PolicyTopicEvidence_TextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_TextList_); ok {
		return x.TextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetLanguageCode() *wrappers.StringValue {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_LanguageCode); ok {
		return x.LanguageCode
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationTextList() *PolicyTopicEvidence_DestinationTextList {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationTextList_); ok {
		return x.DestinationTextList
	}
	return nil
}

func (m *PolicyTopicEvidence) GetDestinationMismatch() *PolicyTopicEvidence_DestinationMismatch {
	if x, ok := m.GetValue().(*PolicyTopicEvidence_DestinationMismatch_); ok {
		return x.DestinationMismatch
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PolicyTopicEvidence) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PolicyTopicEvidence_OneofMarshaler, _PolicyTopicEvidence_OneofUnmarshaler, _PolicyTopicEvidence_OneofSizer, []interface{}{
		(*PolicyTopicEvidence_HttpCode)(nil),
		(*PolicyTopicEvidence_WebsiteList_)(nil),
		(*PolicyTopicEvidence_TextList_)(nil),
		(*PolicyTopicEvidence_LanguageCode)(nil),
		(*PolicyTopicEvidence_DestinationTextList_)(nil),
		(*PolicyTopicEvidence_DestinationMismatch_)(nil),
	}
}

func _PolicyTopicEvidence_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PolicyTopicEvidence)
	// value
	switch x := m.Value.(type) {
	case *PolicyTopicEvidence_HttpCode:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HttpCode); err != nil {
			return err
		}
	case *PolicyTopicEvidence_WebsiteList_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WebsiteList); err != nil {
			return err
		}
	case *PolicyTopicEvidence_TextList_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextList); err != nil {
			return err
		}
	case *PolicyTopicEvidence_LanguageCode:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LanguageCode); err != nil {
			return err
		}
	case *PolicyTopicEvidence_DestinationTextList_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DestinationTextList); err != nil {
			return err
		}
	case *PolicyTopicEvidence_DestinationMismatch_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DestinationMismatch); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PolicyTopicEvidence.Value has unexpected type %T", x)
	}
	return nil
}

func _PolicyTopicEvidence_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PolicyTopicEvidence)
	switch tag {
	case 2: // value.http_code
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.Int32Value)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_HttpCode{msg}
		return true, err
	case 3: // value.website_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicEvidence_WebsiteList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_WebsiteList_{msg}
		return true, err
	case 4: // value.text_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicEvidence_TextList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_TextList_{msg}
		return true, err
	case 5: // value.language_code
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_LanguageCode{msg}
		return true, err
	case 6: // value.destination_text_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicEvidence_DestinationTextList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_DestinationTextList_{msg}
		return true, err
	case 7: // value.destination_mismatch
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicEvidence_DestinationMismatch)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicEvidence_DestinationMismatch_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PolicyTopicEvidence_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PolicyTopicEvidence)
	// value
	switch x := m.Value.(type) {
	case *PolicyTopicEvidence_HttpCode:
		s := proto.Size(x.HttpCode)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicEvidence_WebsiteList_:
		s := proto.Size(x.WebsiteList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicEvidence_TextList_:
		s := proto.Size(x.TextList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicEvidence_LanguageCode:
		s := proto.Size(x.LanguageCode)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicEvidence_DestinationTextList_:
		s := proto.Size(x.DestinationTextList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicEvidence_DestinationMismatch_:
		s := proto.Size(x.DestinationMismatch)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A list of fragments of text that violated a policy.
//
// Next Id: 2
type PolicyTopicEvidence_TextList struct {
	// The fragments of text from the resource that caused the policy finding.
	Texts                []*wrappers.StringValue `protobuf:"bytes,1,rep,name=texts,proto3" json:"texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_TextList) Reset()         { *m = PolicyTopicEvidence_TextList{} }
func (m *PolicyTopicEvidence_TextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_TextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_TextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{3, 0}
}
func (m *PolicyTopicEvidence_TextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_TextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEvidence_TextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_TextList.Merge(dst, src)
}
func (m *PolicyTopicEvidence_TextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_TextList.Size(m)
}
func (m *PolicyTopicEvidence_TextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_TextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_TextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_TextList) GetTexts() []*wrappers.StringValue {
	if m != nil {
		return m.Texts
	}
	return nil
}

// A list of websites that caused a policy finding. Used for
// ONE_WEBSITE_PER_AD_GROUP policy topic, for example. In case there are more
// than five websites, only the top five (those that appear in resources the
// most) will be listed here.
//
// Next Id: 2
type PolicyTopicEvidence_WebsiteList struct {
	// Websites that caused the policy finding.
	Websites             []*wrappers.StringValue `protobuf:"bytes,1,rep,name=websites,proto3" json:"websites,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_WebsiteList) Reset()         { *m = PolicyTopicEvidence_WebsiteList{} }
func (m *PolicyTopicEvidence_WebsiteList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_WebsiteList) ProtoMessage()    {}
func (*PolicyTopicEvidence_WebsiteList) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{3, 1}
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEvidence_WebsiteList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Merge(dst, src)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_WebsiteList.Size(m)
}
func (m *PolicyTopicEvidence_WebsiteList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_WebsiteList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_WebsiteList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_WebsiteList) GetWebsites() []*wrappers.StringValue {
	if m != nil {
		return m.Websites
	}
	return nil
}

// A list of strings found in a destination page that caused a policy
// finding.
//
// Next Id: 2
type PolicyTopicEvidence_DestinationTextList struct {
	// List of text found in the resource's destination page.
	DestinationTexts     []*wrappers.StringValue `protobuf:"bytes,1,rep,name=destination_texts,json=destinationTexts,proto3" json:"destination_texts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationTextList) Reset() {
	*m = PolicyTopicEvidence_DestinationTextList{}
}
func (m *PolicyTopicEvidence_DestinationTextList) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationTextList) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationTextList) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{3, 2}
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEvidence_DestinationTextList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Merge(dst, src)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.Size(m)
}
func (m *PolicyTopicEvidence_DestinationTextList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationTextList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationTextList proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationTextList) GetDestinationTexts() []*wrappers.StringValue {
	if m != nil {
		return m.DestinationTexts
	}
	return nil
}

// Evidence of mismatches between the URLs of a resource.
//
// Next Id: 2
type PolicyTopicEvidence_DestinationMismatch struct {
	// The set of URLs that did not match each other.
	UrlTypes             []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType `protobuf:"varint,1,rep,packed,name=url_types,json=urlTypes,proto3,enum=google.ads.googleads.v0.enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType" json:"url_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                                                `json:"-"`
	XXX_unrecognized     []byte                                                                                                  `json:"-"`
	XXX_sizecache        int32                                                                                                   `json:"-"`
}

func (m *PolicyTopicEvidence_DestinationMismatch) Reset() {
	*m = PolicyTopicEvidence_DestinationMismatch{}
}
func (m *PolicyTopicEvidence_DestinationMismatch) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicEvidence_DestinationMismatch) ProtoMessage()    {}
func (*PolicyTopicEvidence_DestinationMismatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{3, 3}
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Unmarshal(m, b)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicEvidence_DestinationMismatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Merge(dst, src)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.Size(m)
}
func (m *PolicyTopicEvidence_DestinationMismatch) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicEvidence_DestinationMismatch proto.InternalMessageInfo

func (m *PolicyTopicEvidence_DestinationMismatch) GetUrlTypes() []enums.PolicyTopicEvidenceDestinationMismatchUrlTypeEnum_PolicyTopicEvidenceDestinationMismatchUrlType {
	if m != nil {
		return m.UrlTypes
	}
	return nil
}

// Describes the effect on serving that a policy topic entry will have.
//
// Next Id: 5
type PolicyTopicConstraint struct {
	// Specific information about the constraint.
	//
	// Types that are valid to be assigned to Value:
	//	*PolicyTopicConstraint_CountryConstraintList_
	//	*PolicyTopicConstraint_ResellerConstraint_
	//	*PolicyTopicConstraint_CertificateMissingInCountryList
	//	*PolicyTopicConstraint_CertificateDomainMismatchInCountryList
	Value                isPolicyTopicConstraint_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PolicyTopicConstraint) Reset()         { *m = PolicyTopicConstraint{} }
func (m *PolicyTopicConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{4}
}
func (m *PolicyTopicConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint.Merge(dst, src)
}
func (m *PolicyTopicConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint.Size(m)
}
func (m *PolicyTopicConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint proto.InternalMessageInfo

type isPolicyTopicConstraint_Value interface {
	isPolicyTopicConstraint_Value()
}

type PolicyTopicConstraint_CountryConstraintList_ struct {
	CountryConstraintList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,1,opt,name=country_constraint_list,json=countryConstraintList,proto3,oneof"`
}

type PolicyTopicConstraint_ResellerConstraint_ struct {
	ResellerConstraint *PolicyTopicConstraint_ResellerConstraint `protobuf:"bytes,2,opt,name=reseller_constraint,json=resellerConstraint,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateMissingInCountryList struct {
	CertificateMissingInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,3,opt,name=certificate_missing_in_country_list,json=certificateMissingInCountryList,proto3,oneof"`
}

type PolicyTopicConstraint_CertificateDomainMismatchInCountryList struct {
	CertificateDomainMismatchInCountryList *PolicyTopicConstraint_CountryConstraintList `protobuf:"bytes,4,opt,name=certificate_domain_mismatch_in_country_list,json=certificateDomainMismatchInCountryList,proto3,oneof"`
}

func (*PolicyTopicConstraint_CountryConstraintList_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_ResellerConstraint_) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateMissingInCountryList) isPolicyTopicConstraint_Value() {}

func (*PolicyTopicConstraint_CertificateDomainMismatchInCountryList) isPolicyTopicConstraint_Value() {}

func (m *PolicyTopicConstraint) GetValue() isPolicyTopicConstraint_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCountryConstraintList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CountryConstraintList_); ok {
		return x.CountryConstraintList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetResellerConstraint() *PolicyTopicConstraint_ResellerConstraint {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_ResellerConstraint_); ok {
		return x.ResellerConstraint
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateMissingInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateMissingInCountryList); ok {
		return x.CertificateMissingInCountryList
	}
	return nil
}

func (m *PolicyTopicConstraint) GetCertificateDomainMismatchInCountryList() *PolicyTopicConstraint_CountryConstraintList {
	if x, ok := m.GetValue().(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList); ok {
		return x.CertificateDomainMismatchInCountryList
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PolicyTopicConstraint) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PolicyTopicConstraint_OneofMarshaler, _PolicyTopicConstraint_OneofUnmarshaler, _PolicyTopicConstraint_OneofSizer, []interface{}{
		(*PolicyTopicConstraint_CountryConstraintList_)(nil),
		(*PolicyTopicConstraint_ResellerConstraint_)(nil),
		(*PolicyTopicConstraint_CertificateMissingInCountryList)(nil),
		(*PolicyTopicConstraint_CertificateDomainMismatchInCountryList)(nil),
	}
}

func _PolicyTopicConstraint_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PolicyTopicConstraint)
	// value
	switch x := m.Value.(type) {
	case *PolicyTopicConstraint_CountryConstraintList_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CountryConstraintList); err != nil {
			return err
		}
	case *PolicyTopicConstraint_ResellerConstraint_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ResellerConstraint); err != nil {
			return err
		}
	case *PolicyTopicConstraint_CertificateMissingInCountryList:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CertificateMissingInCountryList); err != nil {
			return err
		}
	case *PolicyTopicConstraint_CertificateDomainMismatchInCountryList:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CertificateDomainMismatchInCountryList); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PolicyTopicConstraint.Value has unexpected type %T", x)
	}
	return nil
}

func _PolicyTopicConstraint_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PolicyTopicConstraint)
	switch tag {
	case 1: // value.country_constraint_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicConstraint_CountryConstraintList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicConstraint_CountryConstraintList_{msg}
		return true, err
	case 2: // value.reseller_constraint
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicConstraint_ResellerConstraint)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicConstraint_ResellerConstraint_{msg}
		return true, err
	case 3: // value.certificate_missing_in_country_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicConstraint_CountryConstraintList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicConstraint_CertificateMissingInCountryList{msg}
		return true, err
	case 4: // value.certificate_domain_mismatch_in_country_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PolicyTopicConstraint_CountryConstraintList)
		err := b.DecodeMessage(msg)
		m.Value = &PolicyTopicConstraint_CertificateDomainMismatchInCountryList{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PolicyTopicConstraint_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PolicyTopicConstraint)
	// value
	switch x := m.Value.(type) {
	case *PolicyTopicConstraint_CountryConstraintList_:
		s := proto.Size(x.CountryConstraintList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicConstraint_ResellerConstraint_:
		s := proto.Size(x.ResellerConstraint)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicConstraint_CertificateMissingInCountryList:
		s := proto.Size(x.CertificateMissingInCountryList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PolicyTopicConstraint_CertificateDomainMismatchInCountryList:
		s := proto.Size(x.CertificateDomainMismatchInCountryList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A list of countries where a resource's serving is constrained.
//
// Next Id: 3
type PolicyTopicConstraint_CountryConstraintList struct {
	// Total number of countries targeted by the resource.
	TotalTargetedCountries *wrappers.Int32Value `protobuf:"bytes,1,opt,name=total_targeted_countries,json=totalTargetedCountries,proto3" json:"total_targeted_countries,omitempty"`
	// Countries in which serving is restricted.
	Countries            []*PolicyTopicConstraint_CountryConstraint `protobuf:"bytes,2,rep,name=countries,proto3" json:"countries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraintList) Reset() {
	*m = PolicyTopicConstraint_CountryConstraintList{}
}
func (m *PolicyTopicConstraint_CountryConstraintList) String() string {
	return proto.CompactTextString(m)
}
func (*PolicyTopicConstraint_CountryConstraintList) ProtoMessage() {}
func (*PolicyTopicConstraint_CountryConstraintList) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{4, 0}
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicConstraint_CountryConstraintList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Merge(dst, src)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraintList) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraintList proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraintList) GetTotalTargetedCountries() *wrappers.Int32Value {
	if m != nil {
		return m.TotalTargetedCountries
	}
	return nil
}

func (m *PolicyTopicConstraint_CountryConstraintList) GetCountries() []*PolicyTopicConstraint_CountryConstraint {
	if m != nil {
		return m.Countries
	}
	return nil
}

// Indicates that a policy topic was constrained due to disapproval of the
// website for reseller purposes.
//
// Next Id: 1
type PolicyTopicConstraint_ResellerConstraint struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PolicyTopicConstraint_ResellerConstraint) Reset() {
	*m = PolicyTopicConstraint_ResellerConstraint{}
}
func (m *PolicyTopicConstraint_ResellerConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_ResellerConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_ResellerConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{4, 1}
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicConstraint_ResellerConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Merge(dst, src)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.Size(m)
}
func (m *PolicyTopicConstraint_ResellerConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_ResellerConstraint proto.InternalMessageInfo

// Indicates that a resource's ability to serve in a particular country is
// constrained.
//
// Next Id: 2
type PolicyTopicConstraint_CountryConstraint struct {
	// Geo target constant resource name of the country in which serving is
	// constrained.
	CountryCriterion     *wrappers.StringValue `protobuf:"bytes,1,opt,name=country_criterion,json=countryCriterion,proto3" json:"country_criterion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PolicyTopicConstraint_CountryConstraint) Reset() {
	*m = PolicyTopicConstraint_CountryConstraint{}
}
func (m *PolicyTopicConstraint_CountryConstraint) String() string { return proto.CompactTextString(m) }
func (*PolicyTopicConstraint_CountryConstraint) ProtoMessage()    {}
func (*PolicyTopicConstraint_CountryConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptor_policy_5856dd6188baa721, []int{4, 2}
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Unmarshal(m, b)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Marshal(b, m, deterministic)
}
func (dst *PolicyTopicConstraint_CountryConstraint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Merge(dst, src)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_Size() int {
	return xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.Size(m)
}
func (m *PolicyTopicConstraint_CountryConstraint) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyTopicConstraint_CountryConstraint.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyTopicConstraint_CountryConstraint proto.InternalMessageInfo

func (m *PolicyTopicConstraint_CountryConstraint) GetCountryCriterion() *wrappers.StringValue {
	if m != nil {
		return m.CountryCriterion
	}
	return nil
}

func init() {
	proto.RegisterType((*PolicyViolationKey)(nil), "google.ads.googleads.v0.common.PolicyViolationKey")
	proto.RegisterType((*PolicyValidationParameter)(nil), "google.ads.googleads.v0.common.PolicyValidationParameter")
	proto.RegisterType((*PolicyTopicEntry)(nil), "google.ads.googleads.v0.common.PolicyTopicEntry")
	proto.RegisterType((*PolicyTopicEvidence)(nil), "google.ads.googleads.v0.common.PolicyTopicEvidence")
	proto.RegisterType((*PolicyTopicEvidence_TextList)(nil), "google.ads.googleads.v0.common.PolicyTopicEvidence.TextList")
	proto.RegisterType((*PolicyTopicEvidence_WebsiteList)(nil), "google.ads.googleads.v0.common.PolicyTopicEvidence.WebsiteList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationTextList)(nil), "google.ads.googleads.v0.common.PolicyTopicEvidence.DestinationTextList")
	proto.RegisterType((*PolicyTopicEvidence_DestinationMismatch)(nil), "google.ads.googleads.v0.common.PolicyTopicEvidence.DestinationMismatch")
	proto.RegisterType((*PolicyTopicConstraint)(nil), "google.ads.googleads.v0.common.PolicyTopicConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraintList)(nil), "google.ads.googleads.v0.common.PolicyTopicConstraint.CountryConstraintList")
	proto.RegisterType((*PolicyTopicConstraint_ResellerConstraint)(nil), "google.ads.googleads.v0.common.PolicyTopicConstraint.ResellerConstraint")
	proto.RegisterType((*PolicyTopicConstraint_CountryConstraint)(nil), "google.ads.googleads.v0.common.PolicyTopicConstraint.CountryConstraint")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/common/policy.proto", fileDescriptor_policy_5856dd6188baa721)
}

var fileDescriptor_policy_5856dd6188baa721 = []byte{
	// 987 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x96, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xc7, 0xb3, 0x4e, 0xd2, 0xd8, 0xe3, 0x36, 0x4a, 0x27, 0x35, 0x35, 0x06, 0x95, 0xca, 0x48,
	0x08, 0xa9, 0xd2, 0xda, 0x72, 0x84, 0x84, 0x5c, 0x3e, 0xe4, 0x38, 0x95, 0x1d, 0xb5, 0x45, 0x61,
	0x71, 0x1d, 0x09, 0x22, 0xb6, 0x93, 0xdd, 0xe9, 0x76, 0xa4, 0xdd, 0x19, 0x33, 0x33, 0x76, 0x62,
	0xf1, 0x21, 0x6e, 0x78, 0x07, 0x24, 0xee, 0xb8, 0xcc, 0x2d, 0xf7, 0x3c, 0x00, 0xd7, 0xf0, 0x0a,
	0x5c, 0xf0, 0x14, 0x68, 0x67, 0x66, 0xd7, 0x1b, 0xdb, 0xc1, 0x8e, 0x15, 0xae, 0x3c, 0x9e, 0x3d,
	0xe7, 0x77, 0xfe, 0x73, 0xe6, 0x9c, 0xb3, 0x0b, 0x1e, 0x05, 0x8c, 0x05, 0x21, 0xae, 0x21, 0x5f,
	0xd4, 0xf4, 0x32, 0x5e, 0x8d, 0xea, 0x35, 0x8f, 0x45, 0x11, 0xa3, 0xb5, 0x01, 0x0b, 0x89, 0x37,
	0xb6, 0x07, 0x9c, 0x49, 0x06, 0x1f, 0x68, 0x0b, 0x1b, 0xf9, 0xc2, 0x4e, 0x8d, 0xed, 0x51, 0xdd,
	0xd6, 0xc6, 0x95, 0xc7, 0x57, 0xc1, 0x30, 0x1d, 0x46, 0xc2, 0xb0, 0x5c, 0xc9, 0x06, 0xc4, 0x73,
	0x31, 0x95, 0x7c, 0xec, 0xca, 0xf1, 0x00, 0x6b, 0x78, 0xe5, 0xf8, 0x3a, 0xce, 0x23, 0xe2, 0x63,
	0xea, 0x61, 0xd7, 0xc7, 0x42, 0x12, 0x8a, 0x24, 0x61, 0xd4, 0x8d, 0x88, 0x88, 0x90, 0xf4, 0x5e,
	0xbb, 0x43, 0x1e, 0x66, 0xc1, 0x46, 0x75, 0x4d, 0xfd, 0x3b, 0x1d, 0xbe, 0xaa, 0x9d, 0x71, 0x34,
	0x18, 0x60, 0x2e, 0xf4, 0xf3, 0xea, 0xcf, 0x16, 0x80, 0x47, 0x8a, 0xde, 0x27, 0x2c, 0x54, 0xac,
	0xa7, 0x78, 0x0c, 0x3f, 0x06, 0x45, 0x13, 0x93, 0xa2, 0x08, 0x97, 0xad, 0x87, 0xd6, 0xfb, 0xc5,
	0xc6, 0xdb, 0xe6, 0xdc, 0x76, 0x02, 0xb3, 0xbf, 0x90, 0x9c, 0xd0, 0xa0, 0x8f, 0xc2, 0x21, 0x76,
	0x80, 0x76, 0xf8, 0x0c, 0x45, 0x18, 0xb6, 0xc1, 0xf6, 0x48, 0xe3, 0x68, 0xe0, 0x4a, 0x7c, 0x2e,
	0xcb, 0xb9, 0x25, 0x08, 0x77, 0x52, 0x9f, 0x1e, 0x3e, 0x97, 0xd5, 0x6f, 0xc0, 0x9b, 0x46, 0x19,
	0x0a, 0x89, 0xaf, 0xa4, 0x1d, 0x21, 0x8e, 0x22, 0x2c, 0x31, 0x87, 0x3d, 0x70, 0x9f, 0x04, 0x94,
	0x71, 0x74, 0x1a, 0x62, 0x37, 0x9b, 0x1e, 0x51, 0xb6, 0x1e, 0xae, 0x2f, 0x0c, 0x55, 0x4a, 0x9d,
	0x75, 0x88, 0x9e, 0x72, 0xad, 0xfe, 0x99, 0x03, 0x3b, 0x99, 0x8d, 0x27, 0xf1, 0x35, 0xc1, 0x06,
	0xd8, 0x54, 0xe4, 0xa5, 0xb2, 0xa0, 0x4d, 0xe1, 0x4b, 0xb0, 0x11, 0x5f, 0x82, 0x3a, 0xf6, 0x76,
	0xe3, 0x99, 0x7d, 0x55, 0xed, 0xa8, 0xeb, 0xb5, 0xa7, 0x43, 0xf6, 0xc6, 0x03, 0xfc, 0x84, 0x0e,
	0xa3, 0xb9, 0x0f, 0x1c, 0x45, 0x86, 0x9f, 0x83, 0x42, 0x52, 0x08, 0xa2, 0xbc, 0xae, 0x8e, 0xbc,
	0x67, 0xff, 0x77, 0x89, 0x5e, 0xc2, 0x19, 0x5f, 0x67, 0x42, 0x81, 0xc7, 0xa0, 0xe8, 0x31, 0x2a,
	0x24, 0x47, 0x84, 0x4a, 0x51, 0xde, 0x50, 0xd0, 0x0f, 0xae, 0x01, 0x6d, 0xa7, 0xde, 0x4e, 0x96,
	0x54, 0xfd, 0x31, 0x0f, 0x76, 0xe7, 0xc4, 0x86, 0x4d, 0x50, 0x78, 0x2d, 0xe5, 0xc0, 0xf5, 0x98,
	0x8f, 0x4d, 0x85, 0xbc, 0x35, 0x93, 0xdd, 0x43, 0x2a, 0xf7, 0x1a, 0x2a, 0xb9, 0xdd, 0x35, 0x27,
	0x1f, 0xdb, 0xb7, 0x99, 0x8f, 0xa1, 0x0f, 0x6e, 0x9f, 0xe1, 0x53, 0x41, 0x24, 0x76, 0x43, 0x22,
	0x64, 0x79, 0x5d, 0xb9, 0x7f, 0xba, 0x42, 0x0a, 0xec, 0x63, 0xcd, 0x79, 0x46, 0x84, 0xec, 0xae,
	0x39, 0xc5, 0xb3, 0xc9, 0x5f, 0xf8, 0x15, 0x28, 0xc4, 0xe5, 0xab, 0x43, 0x6c, 0xa8, 0x10, 0x1f,
	0xad, 0x12, 0x22, 0x2e, 0x68, 0xc3, 0xcf, 0x4b, 0xb3, 0x86, 0x6d, 0x70, 0x27, 0x44, 0x34, 0x18,
	0xa2, 0x00, 0xeb, 0x14, 0x6c, 0x2e, 0x2e, 0xb0, 0xee, 0x9a, 0x73, 0x3b, 0x71, 0x52, 0x79, 0xf8,
	0x1e, 0x94, 0xb2, 0x73, 0x60, 0xa2, 0xf6, 0x96, 0x82, 0x75, 0x56, 0x51, 0x7b, 0x30, 0x01, 0x66,
	0x84, 0xef, 0xfa, 0xb3, 0xdb, 0xf0, 0x3b, 0x70, 0x6f, 0xde, 0x18, 0x2a, 0x6f, 0xdd, 0x48, 0xf4,
	0xe7, 0x06, 0x37, 0x15, 0x3d, 0xd9, 0xae, 0x7c, 0x02, 0xf2, 0xa9, 0x92, 0xb8, 0x4d, 0xf1, 0xb9,
	0x5c, 0xae, 0xff, 0xb5, 0x69, 0xa5, 0x03, 0x8a, 0x99, 0xcb, 0x87, 0x1f, 0x82, 0xbc, 0xb9, 0xfc,
	0xe5, 0x28, 0xa9, 0x75, 0xe5, 0x25, 0xd8, 0x9d, 0x93, 0x34, 0x78, 0x08, 0xee, 0x4e, 0x5f, 0xce,
	0x72, 0xe4, 0x9d, 0xa9, 0x5c, 0x8b, 0xca, 0x6f, 0xd6, 0xa5, 0x10, 0x49, 0x0a, 0xe0, 0x2f, 0x16,
	0x28, 0x24, 0x33, 0x5f, 0xb3, 0xb7, 0x1b, 0x3f, 0x5c, 0x63, 0xde, 0x98, 0xac, 0xcf, 0x41, 0xbf,
	0xe0, 0xe1, 0xdc, 0x41, 0xb4, 0xd0, 0xc3, 0xc9, 0x0f, 0xf5, 0x42, 0xec, 0x6f, 0x81, 0xcd, 0x51,
	0x7c, 0xa0, 0xea, 0xef, 0x5b, 0xa0, 0x34, 0x77, 0x52, 0xc0, 0x9f, 0x2c, 0x70, 0xdf, 0x63, 0x43,
	0xf5, 0x46, 0x9c, 0x0c, 0x0d, 0x5d, 0xc3, 0x7a, 0xe2, 0x3e, 0x5d, 0x69, 0x04, 0xd9, 0x6d, 0x0d,
	0x9d, 0xec, 0x98, 0x3a, 0x2e, 0x79, 0xf3, 0x1e, 0xc0, 0x6f, 0xc1, 0x2e, 0xc7, 0x02, 0x87, 0x21,
	0xe6, 0x19, 0x1d, 0x66, 0x2c, 0x75, 0x57, 0x93, 0xe0, 0x18, 0xe0, 0x64, 0xab, 0xbb, 0xe6, 0x40,
	0x3e, 0xb3, 0x1b, 0xdf, 0xe2, 0xbb, 0x1e, 0xe6, 0x92, 0xbc, 0x22, 0x1e, 0x92, 0x38, 0xee, 0x23,
	0x11, 0xbf, 0x3b, 0x09, 0x75, 0x93, 0xdc, 0x64, 0xa6, 0xdc, 0x0d, 0x27, 0xe4, 0x9d, 0x4c, 0xe4,
	0xe7, 0x3a, 0xf0, 0x21, 0x35, 0xc6, 0x2a, 0x35, 0x17, 0x16, 0x78, 0x94, 0x55, 0xe7, 0xb3, 0x08,
	0x91, 0xcc, 0x37, 0xc7, 0xb4, 0xca, 0x8d, 0xff, 0x43, 0xe5, 0x7b, 0x19, 0x05, 0x07, 0x4a, 0x40,
	0x52, 0x76, 0x97, 0xc4, 0x56, 0xfe, 0xb2, 0x40, 0x69, 0x2e, 0x03, 0xbe, 0x00, 0x65, 0xc9, 0x24,
	0x0a, 0x5d, 0x89, 0x78, 0x80, 0x25, 0xf6, 0x8d, 0x6a, 0xa2, 0x1a, 0x67, 0xd1, 0xdb, 0xc7, 0x79,
	0x43, 0x39, 0xf7, 0x8c, 0x6f, 0x3b, 0x71, 0x85, 0x18, 0x14, 0x26, 0x9c, 0x9c, 0x6a, 0xee, 0xce,
	0x0d, 0x1d, 0xdd, 0x99, 0x90, 0x2b, 0xf7, 0x00, 0x9c, 0x2d, 0xa7, 0xca, 0xd7, 0xe0, 0xee, 0x8c,
	0x57, 0x3c, 0x76, 0xd2, 0x8e, 0xe2, 0x44, 0x62, 0x4e, 0x18, 0x5d, 0xea, 0xeb, 0x65, 0x27, 0x69,
	0x8d, 0xc4, 0x2b, 0x6d, 0xe0, 0xfd, 0xbf, 0x2d, 0x50, 0xf5, 0x58, 0xb4, 0xe0, 0x60, 0xfb, 0x45,
	0x7d, 0xb2, 0xa3, 0x98, 0x7e, 0x64, 0x7d, 0x79, 0x60, 0xcc, 0x03, 0x16, 0xbf, 0xb4, 0x6c, 0xc6,
	0x83, 0x5a, 0x80, 0xa9, 0x8a, 0x9d, 0x7c, 0xe7, 0x0e, 0x88, 0xb8, 0xea, 0x03, 0xfc, 0xb1, 0xfe,
	0xf9, 0x35, 0xb7, 0xde, 0x69, 0xb5, 0x2e, 0x72, 0x0f, 0x3a, 0x1a, 0xd6, 0xf2, 0x85, 0xad, 0x97,
	0xf1, 0xaa, 0x5f, 0xb7, 0xdb, 0xca, 0xec, 0x8f, 0xc4, 0xe0, 0xa4, 0xe5, 0x8b, 0x93, 0xd4, 0xe0,
	0xa4, 0x5f, 0x3f, 0xd1, 0x06, 0xff, 0xe4, 0xaa, 0x7a, 0xb7, 0xd9, 0x6c, 0xf9, 0xa2, 0xd9, 0x4c,
	0x4d, 0x9a, 0xcd, 0x7e, 0xbd, 0xd9, 0xd4, 0x46, 0xa7, 0xb7, 0x94, 0xba, 0xbd, 0x7f, 0x03, 0x00,
	0x00, 0xff, 0xff, 0x8c, 0x6f, 0xa6, 0x38, 0x1d, 0x0c, 0x00, 0x00,
}
