// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/google_ads_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [GoogleAdsService.Search][google.ads.googleads.v0.services.GoogleAdsService.Search].
type SearchGoogleAdsRequest struct {
	// The ID of the customer being queried.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The query string.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Token of the page to retrieve. If not specified, the first
	// page of results will be returned. Use the value obtained from
	// `next_page_token` in the previous response in order to request
	// the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Number of elements to retrieve in a single page.
	// When too large a page is requested, the server may decide to
	// further limit the number of returned resources.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If true, the request is validated but not executed.
	ValidateOnly         bool     `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchGoogleAdsRequest) Reset()         { *m = SearchGoogleAdsRequest{} }
func (m *SearchGoogleAdsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsRequest) ProtoMessage()    {}
func (*SearchGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{0}
}
func (m *SearchGoogleAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsRequest.Unmarshal(m, b)
}
func (m *SearchGoogleAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsRequest.Marshal(b, m, deterministic)
}
func (dst *SearchGoogleAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsRequest.Merge(dst, src)
}
func (m *SearchGoogleAdsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsRequest.Size(m)
}
func (m *SearchGoogleAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsRequest proto.InternalMessageInfo

func (m *SearchGoogleAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchGoogleAdsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchGoogleAdsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for [GoogleAdsService.Search][google.ads.googleads.v0.services.GoogleAdsService.Search].
type SearchGoogleAdsResponse struct {
	// The list of rows that matched the query.
	Results []*GoogleAdsRow `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Pagination token used to retrieve the next page of results.
	// Pass the content of this string as the `page_token` attribute of
	// the next request. `next_page_token` is not returned for the last
	// page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total number of results that match the query ignoring the LIMIT
	// clause.
	TotalResultsCount int64 `protobuf:"varint,3,opt,name=total_results_count,json=totalResultsCount,proto3" json:"total_results_count,omitempty"`
	// FieldMask that represents what fields were requested by the user.
	FieldMask            *field_mask.FieldMask `protobuf:"bytes,5,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SearchGoogleAdsResponse) Reset()         { *m = SearchGoogleAdsResponse{} }
func (m *SearchGoogleAdsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchGoogleAdsResponse) ProtoMessage()    {}
func (*SearchGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{1}
}
func (m *SearchGoogleAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchGoogleAdsResponse.Unmarshal(m, b)
}
func (m *SearchGoogleAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchGoogleAdsResponse.Marshal(b, m, deterministic)
}
func (dst *SearchGoogleAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchGoogleAdsResponse.Merge(dst, src)
}
func (m *SearchGoogleAdsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchGoogleAdsResponse.Size(m)
}
func (m *SearchGoogleAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchGoogleAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchGoogleAdsResponse proto.InternalMessageInfo

func (m *SearchGoogleAdsResponse) GetResults() []*GoogleAdsRow {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchGoogleAdsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchGoogleAdsResponse) GetTotalResultsCount() int64 {
	if m != nil {
		return m.TotalResultsCount
	}
	return 0
}

func (m *SearchGoogleAdsResponse) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

// A returned row from the query.
type GoogleAdsRow struct {
	// The account budget in the query.
	AccountBudget *resources.AccountBudget `protobuf:"bytes,42,opt,name=account_budget,json=accountBudget,proto3" json:"account_budget,omitempty"`
	// The account budget proposal referenced in the query.
	AccountBudgetProposal *resources.AccountBudgetProposal `protobuf:"bytes,43,opt,name=account_budget_proposal,json=accountBudgetProposal,proto3" json:"account_budget_proposal,omitempty"`
	// The ad group referenced in the query.
	AdGroup *resources.AdGroup `protobuf:"bytes,3,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The ad referenced in the query.
	AdGroupAd *resources.AdGroupAd `protobuf:"bytes,16,opt,name=ad_group_ad,json=adGroupAd,proto3" json:"ad_group_ad,omitempty"`
	// The ad group audience view referenced in the query.
	AdGroupAudienceView *resources.AdGroupAudienceView `protobuf:"bytes,57,opt,name=ad_group_audience_view,json=adGroupAudienceView,proto3" json:"ad_group_audience_view,omitempty"`
	// The bid modifier referenced in the query.
	AdGroupBidModifier *resources.AdGroupBidModifier `protobuf:"bytes,24,opt,name=ad_group_bid_modifier,json=adGroupBidModifier,proto3" json:"ad_group_bid_modifier,omitempty"`
	// The criterion referenced in the query.
	AdGroupCriterion *resources.AdGroupCriterion `protobuf:"bytes,17,opt,name=ad_group_criterion,json=adGroupCriterion,proto3" json:"ad_group_criterion,omitempty"`
	// The ad group feed referenced in the query.
	AdGroupFeed *resources.AdGroupFeed `protobuf:"bytes,67,opt,name=ad_group_feed,json=adGroupFeed,proto3" json:"ad_group_feed,omitempty"`
	// The age range view referenced in the query.
	AgeRangeView *resources.AgeRangeView `protobuf:"bytes,48,opt,name=age_range_view,json=ageRangeView,proto3" json:"age_range_view,omitempty"`
	// The ad schedule view referenced in the query.
	AdScheduleView *resources.AdScheduleView `protobuf:"bytes,89,opt,name=ad_schedule_view,json=adScheduleView,proto3" json:"ad_schedule_view,omitempty"`
	// The bidding strategy referenced in the query.
	BiddingStrategy *resources.BiddingStrategy `protobuf:"bytes,18,opt,name=bidding_strategy,json=biddingStrategy,proto3" json:"bidding_strategy,omitempty"`
	// The billing setup referenced in the query.
	BillingSetup *resources.BillingSetup `protobuf:"bytes,41,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// The campaign budget referenced in the query.
	CampaignBudget *resources.CampaignBudget `protobuf:"bytes,19,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign referenced in the query.
	Campaign *resources.Campaign `protobuf:"bytes,2,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The campaign audience view referenced in the query.
	CampaignAudienceView *resources.CampaignAudienceView `protobuf:"bytes,69,opt,name=campaign_audience_view,json=campaignAudienceView,proto3" json:"campaign_audience_view,omitempty"`
	// The campaign bid modifier referenced in the query.
	CampaignBidModifier *resources.CampaignBidModifier `protobuf:"bytes,26,opt,name=campaign_bid_modifier,json=campaignBidModifier,proto3" json:"campaign_bid_modifier,omitempty"`
	// The campaign criterion referenced in the query.
	CampaignCriterion *resources.CampaignCriterion `protobuf:"bytes,20,opt,name=campaign_criterion,json=campaignCriterion,proto3" json:"campaign_criterion,omitempty"`
	// The campaign feed referenced in the query.
	CampaignFeed *resources.CampaignFeed `protobuf:"bytes,63,opt,name=campaign_feed,json=campaignFeed,proto3" json:"campaign_feed,omitempty"`
	// Campaign Shared Set referenced in AWQL query.
	CampaignSharedSet *resources.CampaignSharedSet `protobuf:"bytes,30,opt,name=campaign_shared_set,json=campaignSharedSet,proto3" json:"campaign_shared_set,omitempty"`
	// The carrier constant referenced in the query.
	CarrierConstant *resources.CarrierConstant `protobuf:"bytes,66,opt,name=carrier_constant,json=carrierConstant,proto3" json:"carrier_constant,omitempty"`
	// The ChangeStatus referenced in the query.
	ChangeStatus *resources.ChangeStatus `protobuf:"bytes,37,opt,name=change_status,json=changeStatus,proto3" json:"change_status,omitempty"`
	// The conversion action referenced in the query.
	ConversionAction *resources.ConversionAction `protobuf:"bytes,103,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// The customer referenced in the query.
	Customer *resources.Customer `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// The CustomerManagerLink referenced in the query.
	CustomerManagerLink *resources.CustomerManagerLink `protobuf:"bytes,61,opt,name=customer_manager_link,json=customerManagerLink,proto3" json:"customer_manager_link,omitempty"`
	// The CustomerClientLink referenced in the query.
	CustomerClientLink *resources.CustomerClientLink `protobuf:"bytes,62,opt,name=customer_client_link,json=customerClientLink,proto3" json:"customer_client_link,omitempty"`
	// The CustomerClient referenced in the query.
	CustomerClient *resources.CustomerClient `protobuf:"bytes,70,opt,name=customer_client,json=customerClient,proto3" json:"customer_client,omitempty"`
	// The customer feed referenced in the query.
	CustomerFeed *resources.CustomerFeed `protobuf:"bytes,64,opt,name=customer_feed,json=customerFeed,proto3" json:"customer_feed,omitempty"`
	// The display keyword view referenced in the query.
	DisplayKeywordView *resources.DisplayKeywordView `protobuf:"bytes,47,opt,name=display_keyword_view,json=displayKeywordView,proto3" json:"display_keyword_view,omitempty"`
	// The feed referenced in the query.
	Feed *resources.Feed `protobuf:"bytes,46,opt,name=feed,proto3" json:"feed,omitempty"`
	// The feed item referenced in the query.
	FeedItem *resources.FeedItem `protobuf:"bytes,50,opt,name=feed_item,json=feedItem,proto3" json:"feed_item,omitempty"`
	// The feed mapping referenced in the query.
	FeedMapping *resources.FeedMapping `protobuf:"bytes,58,opt,name=feed_mapping,json=feedMapping,proto3" json:"feed_mapping,omitempty"`
	// The gender view referenced in the query.
	GenderView *resources.GenderView `protobuf:"bytes,40,opt,name=gender_view,json=genderView,proto3" json:"gender_view,omitempty"`
	// The geo target constant referenced in the query.
	GeoTargetConstant *resources.GeoTargetConstant `protobuf:"bytes,23,opt,name=geo_target_constant,json=geoTargetConstant,proto3" json:"geo_target_constant,omitempty"`
	// The hotel group view referenced in the query.
	HotelGroupView *resources.HotelGroupView `protobuf:"bytes,51,opt,name=hotel_group_view,json=hotelGroupView,proto3" json:"hotel_group_view,omitempty"`
	// The hotel performance view referenced in the query.
	HotelPerformanceView *resources.HotelPerformanceView `protobuf:"bytes,71,opt,name=hotel_performance_view,json=hotelPerformanceView,proto3" json:"hotel_performance_view,omitempty"`
	// The keyword view referenced in the query.
	KeywordView *resources.KeywordView `protobuf:"bytes,21,opt,name=keyword_view,json=keywordView,proto3" json:"keyword_view,omitempty"`
	// The keyword plan referenced in the query.
	KeywordPlan *resources.KeywordPlan `protobuf:"bytes,32,opt,name=keyword_plan,json=keywordPlan,proto3" json:"keyword_plan,omitempty"`
	// The keyword plan campaign referenced in the query.
	KeywordPlanCampaign *resources.KeywordPlanCampaign `protobuf:"bytes,33,opt,name=keyword_plan_campaign,json=keywordPlanCampaign,proto3" json:"keyword_plan_campaign,omitempty"`
	// The keyword plan negative keyword referenced in the query.
	KeywordPlanNegativeKeyword *resources.KeywordPlanNegativeKeyword `protobuf:"bytes,34,opt,name=keyword_plan_negative_keyword,json=keywordPlanNegativeKeyword,proto3" json:"keyword_plan_negative_keyword,omitempty"`
	// The keyword plan ad group referenced in the query.
	KeywordPlanAdGroup *resources.KeywordPlanAdGroup `protobuf:"bytes,35,opt,name=keyword_plan_ad_group,json=keywordPlanAdGroup,proto3" json:"keyword_plan_ad_group,omitempty"`
	// The keyword plan keyword referenced in the query.
	KeywordPlanKeyword *resources.KeywordPlanKeyword `protobuf:"bytes,36,opt,name=keyword_plan_keyword,json=keywordPlanKeyword,proto3" json:"keyword_plan_keyword,omitempty"`
	// The language constant referenced in the query.
	LanguageConstant *resources.LanguageConstant `protobuf:"bytes,55,opt,name=language_constant,json=languageConstant,proto3" json:"language_constant,omitempty"`
	// The managed placement view referenced in the query.
	ManagedPlacementView *resources.ManagedPlacementView `protobuf:"bytes,53,opt,name=managed_placement_view,json=managedPlacementView,proto3" json:"managed_placement_view,omitempty"`
	// The media file referenced in the query.
	MediaFile *resources.MediaFile `protobuf:"bytes,90,opt,name=media_file,json=mediaFile,proto3" json:"media_file,omitempty"`
	// The mobile app category constant referenced in the query.
	MobileAppCategoryConstant *resources.MobileAppCategoryConstant `protobuf:"bytes,87,opt,name=mobile_app_category_constant,json=mobileAppCategoryConstant,proto3" json:"mobile_app_category_constant,omitempty"`
	// The mobile device constant referenced in the query.
	MobileDeviceConstant *resources.MobileDeviceConstant `protobuf:"bytes,98,opt,name=mobile_device_constant,json=mobileDeviceConstant,proto3" json:"mobile_device_constant,omitempty"`
	// The operating system version constant referenced in the query.
	OperatingSystemVersionConstant *resources.OperatingSystemVersionConstant `protobuf:"bytes,86,opt,name=operating_system_version_constant,json=operatingSystemVersionConstant,proto3" json:"operating_system_version_constant,omitempty"`
	// The parental status view referenced in the query.
	ParentalStatusView *resources.ParentalStatusView `protobuf:"bytes,45,opt,name=parental_status_view,json=parentalStatusView,proto3" json:"parental_status_view,omitempty"`
	// The product group view referenced in the query.
	ProductGroupView *resources.ProductGroupView `protobuf:"bytes,54,opt,name=product_group_view,json=productGroupView,proto3" json:"product_group_view,omitempty"`
	// The recommendation referenced in the query.
	Recommendation *resources.Recommendation `protobuf:"bytes,22,opt,name=recommendation,proto3" json:"recommendation,omitempty"`
	// The search term view referenced in the query.
	SearchTermView *resources.SearchTermView `protobuf:"bytes,68,opt,name=search_term_view,json=searchTermView,proto3" json:"search_term_view,omitempty"`
	// The shared set referenced in the query.
	SharedCriterion *resources.SharedCriterion `protobuf:"bytes,29,opt,name=shared_criterion,json=sharedCriterion,proto3" json:"shared_criterion,omitempty"`
	// The shared set referenced in the query.
	SharedSet *resources.SharedSet `protobuf:"bytes,27,opt,name=shared_set,json=sharedSet,proto3" json:"shared_set,omitempty"`
	// The topic view referenced in the query.
	TopicView *resources.TopicView `protobuf:"bytes,44,opt,name=topic_view,json=topicView,proto3" json:"topic_view,omitempty"`
	// The user interest referenced in the query.
	UserInterest *resources.UserInterest `protobuf:"bytes,59,opt,name=user_interest,json=userInterest,proto3" json:"user_interest,omitempty"`
	// The user list referenced in the query.
	UserList *resources.UserList `protobuf:"bytes,38,opt,name=user_list,json=userList,proto3" json:"user_list,omitempty"`
	// The remarketing action referenced in the query.
	RemarketingAction *resources.RemarketingAction `protobuf:"bytes,60,opt,name=remarketing_action,json=remarketingAction,proto3" json:"remarketing_action,omitempty"`
	// The topic constant referenced in the query.
	TopicConstant *resources.TopicConstant `protobuf:"bytes,31,opt,name=topic_constant,json=topicConstant,proto3" json:"topic_constant,omitempty"`
	// The video referenced in the query.
	Video *resources.Video `protobuf:"bytes,39,opt,name=video,proto3" json:"video,omitempty"`
	// The metrics.
	Metrics *common.Metrics `protobuf:"bytes,4,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// The segments.
	Segments             *common.Segments `protobuf:"bytes,102,opt,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *GoogleAdsRow) Reset()         { *m = GoogleAdsRow{} }
func (m *GoogleAdsRow) String() string { return proto.CompactTextString(m) }
func (*GoogleAdsRow) ProtoMessage()    {}
func (*GoogleAdsRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{2}
}
func (m *GoogleAdsRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GoogleAdsRow.Unmarshal(m, b)
}
func (m *GoogleAdsRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GoogleAdsRow.Marshal(b, m, deterministic)
}
func (dst *GoogleAdsRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GoogleAdsRow.Merge(dst, src)
}
func (m *GoogleAdsRow) XXX_Size() int {
	return xxx_messageInfo_GoogleAdsRow.Size(m)
}
func (m *GoogleAdsRow) XXX_DiscardUnknown() {
	xxx_messageInfo_GoogleAdsRow.DiscardUnknown(m)
}

var xxx_messageInfo_GoogleAdsRow proto.InternalMessageInfo

func (m *GoogleAdsRow) GetAccountBudget() *resources.AccountBudget {
	if m != nil {
		return m.AccountBudget
	}
	return nil
}

func (m *GoogleAdsRow) GetAccountBudgetProposal() *resources.AccountBudgetProposal {
	if m != nil {
		return m.AccountBudgetProposal
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroup() *resources.AdGroup {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAd() *resources.AdGroupAd {
	if m != nil {
		return m.AdGroupAd
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupAudienceView() *resources.AdGroupAudienceView {
	if m != nil {
		return m.AdGroupAudienceView
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupBidModifier() *resources.AdGroupBidModifier {
	if m != nil {
		return m.AdGroupBidModifier
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupCriterion() *resources.AdGroupCriterion {
	if m != nil {
		return m.AdGroupCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetAdGroupFeed() *resources.AdGroupFeed {
	if m != nil {
		return m.AdGroupFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetAgeRangeView() *resources.AgeRangeView {
	if m != nil {
		return m.AgeRangeView
	}
	return nil
}

func (m *GoogleAdsRow) GetAdScheduleView() *resources.AdScheduleView {
	if m != nil {
		return m.AdScheduleView
	}
	return nil
}

func (m *GoogleAdsRow) GetBiddingStrategy() *resources.BiddingStrategy {
	if m != nil {
		return m.BiddingStrategy
	}
	return nil
}

func (m *GoogleAdsRow) GetBillingSetup() *resources.BillingSetup {
	if m != nil {
		return m.BillingSetup
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignBudget() *resources.CampaignBudget {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaign() *resources.Campaign {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignAudienceView() *resources.CampaignAudienceView {
	if m != nil {
		return m.CampaignAudienceView
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignBidModifier() *resources.CampaignBidModifier {
	if m != nil {
		return m.CampaignBidModifier
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignCriterion() *resources.CampaignCriterion {
	if m != nil {
		return m.CampaignCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignFeed() *resources.CampaignFeed {
	if m != nil {
		return m.CampaignFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetCampaignSharedSet() *resources.CampaignSharedSet {
	if m != nil {
		return m.CampaignSharedSet
	}
	return nil
}

func (m *GoogleAdsRow) GetCarrierConstant() *resources.CarrierConstant {
	if m != nil {
		return m.CarrierConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetChangeStatus() *resources.ChangeStatus {
	if m != nil {
		return m.ChangeStatus
	}
	return nil
}

func (m *GoogleAdsRow) GetConversionAction() *resources.ConversionAction {
	if m != nil {
		return m.ConversionAction
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomer() *resources.Customer {
	if m != nil {
		return m.Customer
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerManagerLink() *resources.CustomerManagerLink {
	if m != nil {
		return m.CustomerManagerLink
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerClientLink() *resources.CustomerClientLink {
	if m != nil {
		return m.CustomerClientLink
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerClient() *resources.CustomerClient {
	if m != nil {
		return m.CustomerClient
	}
	return nil
}

func (m *GoogleAdsRow) GetCustomerFeed() *resources.CustomerFeed {
	if m != nil {
		return m.CustomerFeed
	}
	return nil
}

func (m *GoogleAdsRow) GetDisplayKeywordView() *resources.DisplayKeywordView {
	if m != nil {
		return m.DisplayKeywordView
	}
	return nil
}

func (m *GoogleAdsRow) GetFeed() *resources.Feed {
	if m != nil {
		return m.Feed
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedItem() *resources.FeedItem {
	if m != nil {
		return m.FeedItem
	}
	return nil
}

func (m *GoogleAdsRow) GetFeedMapping() *resources.FeedMapping {
	if m != nil {
		return m.FeedMapping
	}
	return nil
}

func (m *GoogleAdsRow) GetGenderView() *resources.GenderView {
	if m != nil {
		return m.GenderView
	}
	return nil
}

func (m *GoogleAdsRow) GetGeoTargetConstant() *resources.GeoTargetConstant {
	if m != nil {
		return m.GeoTargetConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetHotelGroupView() *resources.HotelGroupView {
	if m != nil {
		return m.HotelGroupView
	}
	return nil
}

func (m *GoogleAdsRow) GetHotelPerformanceView() *resources.HotelPerformanceView {
	if m != nil {
		return m.HotelPerformanceView
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordView() *resources.KeywordView {
	if m != nil {
		return m.KeywordView
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlan() *resources.KeywordPlan {
	if m != nil {
		return m.KeywordPlan
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanCampaign() *resources.KeywordPlanCampaign {
	if m != nil {
		return m.KeywordPlanCampaign
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanNegativeKeyword() *resources.KeywordPlanNegativeKeyword {
	if m != nil {
		return m.KeywordPlanNegativeKeyword
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanAdGroup() *resources.KeywordPlanAdGroup {
	if m != nil {
		return m.KeywordPlanAdGroup
	}
	return nil
}

func (m *GoogleAdsRow) GetKeywordPlanKeyword() *resources.KeywordPlanKeyword {
	if m != nil {
		return m.KeywordPlanKeyword
	}
	return nil
}

func (m *GoogleAdsRow) GetLanguageConstant() *resources.LanguageConstant {
	if m != nil {
		return m.LanguageConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetManagedPlacementView() *resources.ManagedPlacementView {
	if m != nil {
		return m.ManagedPlacementView
	}
	return nil
}

func (m *GoogleAdsRow) GetMediaFile() *resources.MediaFile {
	if m != nil {
		return m.MediaFile
	}
	return nil
}

func (m *GoogleAdsRow) GetMobileAppCategoryConstant() *resources.MobileAppCategoryConstant {
	if m != nil {
		return m.MobileAppCategoryConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetMobileDeviceConstant() *resources.MobileDeviceConstant {
	if m != nil {
		return m.MobileDeviceConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetOperatingSystemVersionConstant() *resources.OperatingSystemVersionConstant {
	if m != nil {
		return m.OperatingSystemVersionConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetParentalStatusView() *resources.ParentalStatusView {
	if m != nil {
		return m.ParentalStatusView
	}
	return nil
}

func (m *GoogleAdsRow) GetProductGroupView() *resources.ProductGroupView {
	if m != nil {
		return m.ProductGroupView
	}
	return nil
}

func (m *GoogleAdsRow) GetRecommendation() *resources.Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (m *GoogleAdsRow) GetSearchTermView() *resources.SearchTermView {
	if m != nil {
		return m.SearchTermView
	}
	return nil
}

func (m *GoogleAdsRow) GetSharedCriterion() *resources.SharedCriterion {
	if m != nil {
		return m.SharedCriterion
	}
	return nil
}

func (m *GoogleAdsRow) GetSharedSet() *resources.SharedSet {
	if m != nil {
		return m.SharedSet
	}
	return nil
}

func (m *GoogleAdsRow) GetTopicView() *resources.TopicView {
	if m != nil {
		return m.TopicView
	}
	return nil
}

func (m *GoogleAdsRow) GetUserInterest() *resources.UserInterest {
	if m != nil {
		return m.UserInterest
	}
	return nil
}

func (m *GoogleAdsRow) GetUserList() *resources.UserList {
	if m != nil {
		return m.UserList
	}
	return nil
}

func (m *GoogleAdsRow) GetRemarketingAction() *resources.RemarketingAction {
	if m != nil {
		return m.RemarketingAction
	}
	return nil
}

func (m *GoogleAdsRow) GetTopicConstant() *resources.TopicConstant {
	if m != nil {
		return m.TopicConstant
	}
	return nil
}

func (m *GoogleAdsRow) GetVideo() *resources.Video {
	if m != nil {
		return m.Video
	}
	return nil
}

func (m *GoogleAdsRow) GetMetrics() *common.Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *GoogleAdsRow) GetSegments() *common.Segments {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Request message for [GoogleAdsService.Mutate][google.ads.googleads.v0.services.GoogleAdsService.Mutate].
type MutateGoogleAdsRequest struct {
	// The ID of the customer whose resources are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual resources.
	MutateOperations []*MutateOperation `protobuf:"bytes,2,rep,name=mutate_operations,json=mutateOperations,proto3" json:"mutate_operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateGoogleAdsRequest) Reset()         { *m = MutateGoogleAdsRequest{} }
func (m *MutateGoogleAdsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateGoogleAdsRequest) ProtoMessage()    {}
func (*MutateGoogleAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{3}
}
func (m *MutateGoogleAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateGoogleAdsRequest.Unmarshal(m, b)
}
func (m *MutateGoogleAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateGoogleAdsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateGoogleAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateGoogleAdsRequest.Merge(dst, src)
}
func (m *MutateGoogleAdsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateGoogleAdsRequest.Size(m)
}
func (m *MutateGoogleAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateGoogleAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateGoogleAdsRequest proto.InternalMessageInfo

func (m *MutateGoogleAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateGoogleAdsRequest) GetMutateOperations() []*MutateOperation {
	if m != nil {
		return m.MutateOperations
	}
	return nil
}

func (m *MutateGoogleAdsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateGoogleAdsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// Response message for [GoogleAdsService.Mutate][google.ads.googleads.v0.services.GoogleAdsService.Mutate].
type MutateGoogleAdsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All responses for the mutate.
	MutateOperationResponses []*MutateOperationResponse `protobuf:"bytes,1,rep,name=mutate_operation_responses,json=mutateOperationResponses,proto3" json:"mutate_operation_responses,omitempty"`
	XXX_NoUnkeyedLiteral     struct{}                   `json:"-"`
	XXX_unrecognized         []byte                     `json:"-"`
	XXX_sizecache            int32                      `json:"-"`
}

func (m *MutateGoogleAdsResponse) Reset()         { *m = MutateGoogleAdsResponse{} }
func (m *MutateGoogleAdsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateGoogleAdsResponse) ProtoMessage()    {}
func (*MutateGoogleAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{4}
}
func (m *MutateGoogleAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateGoogleAdsResponse.Unmarshal(m, b)
}
func (m *MutateGoogleAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateGoogleAdsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateGoogleAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateGoogleAdsResponse.Merge(dst, src)
}
func (m *MutateGoogleAdsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateGoogleAdsResponse.Size(m)
}
func (m *MutateGoogleAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateGoogleAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateGoogleAdsResponse proto.InternalMessageInfo

func (m *MutateGoogleAdsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateGoogleAdsResponse) GetMutateOperationResponses() []*MutateOperationResponse {
	if m != nil {
		return m.MutateOperationResponses
	}
	return nil
}

// A single operation (create, update, remove) on a resource.
type MutateOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*MutateOperation_AdGroupAdOperation
	//	*MutateOperation_AdGroupBidModifierOperation
	//	*MutateOperation_AdGroupCriterionOperation
	//	*MutateOperation_AdGroupOperation
	//	*MutateOperation_BiddingStrategyOperation
	//	*MutateOperation_CampaignBidModifierOperation
	//	*MutateOperation_CampaignBudgetOperation
	//	*MutateOperation_CampaignOperation
	//	*MutateOperation_CampaignSharedSetOperation
	//	*MutateOperation_ConversionActionOperation
	//	*MutateOperation_CampaignCriterionOperation
	//	*MutateOperation_SharedCriterionOperation
	//	*MutateOperation_SharedSetOperation
	//	*MutateOperation_UserListOperation
	Operation            isMutateOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateOperation) Reset()         { *m = MutateOperation{} }
func (m *MutateOperation) String() string { return proto.CompactTextString(m) }
func (*MutateOperation) ProtoMessage()    {}
func (*MutateOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{5}
}
func (m *MutateOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateOperation.Unmarshal(m, b)
}
func (m *MutateOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateOperation.Marshal(b, m, deterministic)
}
func (dst *MutateOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateOperation.Merge(dst, src)
}
func (m *MutateOperation) XXX_Size() int {
	return xxx_messageInfo_MutateOperation.Size(m)
}
func (m *MutateOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateOperation.DiscardUnknown(m)
}

var xxx_messageInfo_MutateOperation proto.InternalMessageInfo

type isMutateOperation_Operation interface {
	isMutateOperation_Operation()
}

type MutateOperation_AdGroupAdOperation struct {
	AdGroupAdOperation *AdGroupAdOperation `protobuf:"bytes,1,opt,name=ad_group_ad_operation,json=adGroupAdOperation,proto3,oneof"`
}

type MutateOperation_AdGroupBidModifierOperation struct {
	AdGroupBidModifierOperation *AdGroupBidModifierOperation `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_operation,json=adGroupBidModifierOperation,proto3,oneof"`
}

type MutateOperation_AdGroupCriterionOperation struct {
	AdGroupCriterionOperation *AdGroupCriterionOperation `protobuf:"bytes,3,opt,name=ad_group_criterion_operation,json=adGroupCriterionOperation,proto3,oneof"`
}

type MutateOperation_AdGroupOperation struct {
	AdGroupOperation *AdGroupOperation `protobuf:"bytes,5,opt,name=ad_group_operation,json=adGroupOperation,proto3,oneof"`
}

type MutateOperation_BiddingStrategyOperation struct {
	BiddingStrategyOperation *BiddingStrategyOperation `protobuf:"bytes,6,opt,name=bidding_strategy_operation,json=biddingStrategyOperation,proto3,oneof"`
}

type MutateOperation_CampaignBidModifierOperation struct {
	CampaignBidModifierOperation *CampaignBidModifierOperation `protobuf:"bytes,7,opt,name=campaign_bid_modifier_operation,json=campaignBidModifierOperation,proto3,oneof"`
}

type MutateOperation_CampaignBudgetOperation struct {
	CampaignBudgetOperation *CampaignBudgetOperation `protobuf:"bytes,8,opt,name=campaign_budget_operation,json=campaignBudgetOperation,proto3,oneof"`
}

type MutateOperation_CampaignOperation struct {
	CampaignOperation *CampaignOperation `protobuf:"bytes,10,opt,name=campaign_operation,json=campaignOperation,proto3,oneof"`
}

type MutateOperation_CampaignSharedSetOperation struct {
	CampaignSharedSetOperation *CampaignSharedSetOperation `protobuf:"bytes,11,opt,name=campaign_shared_set_operation,json=campaignSharedSetOperation,proto3,oneof"`
}

type MutateOperation_ConversionActionOperation struct {
	ConversionActionOperation *ConversionActionOperation `protobuf:"bytes,12,opt,name=conversion_action_operation,json=conversionActionOperation,proto3,oneof"`
}

type MutateOperation_CampaignCriterionOperation struct {
	CampaignCriterionOperation *CampaignCriterionOperation `protobuf:"bytes,13,opt,name=campaign_criterion_operation,json=campaignCriterionOperation,proto3,oneof"`
}

type MutateOperation_SharedCriterionOperation struct {
	SharedCriterionOperation *SharedCriterionOperation `protobuf:"bytes,14,opt,name=shared_criterion_operation,json=sharedCriterionOperation,proto3,oneof"`
}

type MutateOperation_SharedSetOperation struct {
	SharedSetOperation *SharedSetOperation `protobuf:"bytes,15,opt,name=shared_set_operation,json=sharedSetOperation,proto3,oneof"`
}

type MutateOperation_UserListOperation struct {
	UserListOperation *UserListOperation `protobuf:"bytes,16,opt,name=user_list_operation,json=userListOperation,proto3,oneof"`
}

func (*MutateOperation_AdGroupAdOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_AdGroupOperation) isMutateOperation_Operation() {}

func (*MutateOperation_BiddingStrategyOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBidModifierOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignBudgetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignSharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_ConversionActionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_CampaignCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedCriterionOperation) isMutateOperation_Operation() {}

func (*MutateOperation_SharedSetOperation) isMutateOperation_Operation() {}

func (*MutateOperation_UserListOperation) isMutateOperation_Operation() {}

func (m *MutateOperation) GetOperation() isMutateOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupAdOperation() *AdGroupAdOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupAdOperation); ok {
		return x.AdGroupAdOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupBidModifierOperation() *AdGroupBidModifierOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupBidModifierOperation); ok {
		return x.AdGroupBidModifierOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupCriterionOperation() *AdGroupCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupCriterionOperation); ok {
		return x.AdGroupCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetAdGroupOperation() *AdGroupOperation {
	if x, ok := m.GetOperation().(*MutateOperation_AdGroupOperation); ok {
		return x.AdGroupOperation
	}
	return nil
}

func (m *MutateOperation) GetBiddingStrategyOperation() *BiddingStrategyOperation {
	if x, ok := m.GetOperation().(*MutateOperation_BiddingStrategyOperation); ok {
		return x.BiddingStrategyOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignBidModifierOperation() *CampaignBidModifierOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignBidModifierOperation); ok {
		return x.CampaignBidModifierOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignBudgetOperation() *CampaignBudgetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignBudgetOperation); ok {
		return x.CampaignBudgetOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignOperation() *CampaignOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignOperation); ok {
		return x.CampaignOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignSharedSetOperation() *CampaignSharedSetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignSharedSetOperation); ok {
		return x.CampaignSharedSetOperation
	}
	return nil
}

func (m *MutateOperation) GetConversionActionOperation() *ConversionActionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_ConversionActionOperation); ok {
		return x.ConversionActionOperation
	}
	return nil
}

func (m *MutateOperation) GetCampaignCriterionOperation() *CampaignCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_CampaignCriterionOperation); ok {
		return x.CampaignCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetSharedCriterionOperation() *SharedCriterionOperation {
	if x, ok := m.GetOperation().(*MutateOperation_SharedCriterionOperation); ok {
		return x.SharedCriterionOperation
	}
	return nil
}

func (m *MutateOperation) GetSharedSetOperation() *SharedSetOperation {
	if x, ok := m.GetOperation().(*MutateOperation_SharedSetOperation); ok {
		return x.SharedSetOperation
	}
	return nil
}

func (m *MutateOperation) GetUserListOperation() *UserListOperation {
	if x, ok := m.GetOperation().(*MutateOperation_UserListOperation); ok {
		return x.UserListOperation
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MutateOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MutateOperation_OneofMarshaler, _MutateOperation_OneofUnmarshaler, _MutateOperation_OneofSizer, []interface{}{
		(*MutateOperation_AdGroupAdOperation)(nil),
		(*MutateOperation_AdGroupBidModifierOperation)(nil),
		(*MutateOperation_AdGroupCriterionOperation)(nil),
		(*MutateOperation_AdGroupOperation)(nil),
		(*MutateOperation_BiddingStrategyOperation)(nil),
		(*MutateOperation_CampaignBidModifierOperation)(nil),
		(*MutateOperation_CampaignBudgetOperation)(nil),
		(*MutateOperation_CampaignOperation)(nil),
		(*MutateOperation_CampaignSharedSetOperation)(nil),
		(*MutateOperation_ConversionActionOperation)(nil),
		(*MutateOperation_CampaignCriterionOperation)(nil),
		(*MutateOperation_SharedCriterionOperation)(nil),
		(*MutateOperation_SharedSetOperation)(nil),
		(*MutateOperation_UserListOperation)(nil),
	}
}

func _MutateOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MutateOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MutateOperation_AdGroupAdOperation:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupAdOperation); err != nil {
			return err
		}
	case *MutateOperation_AdGroupBidModifierOperation:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupBidModifierOperation); err != nil {
			return err
		}
	case *MutateOperation_AdGroupCriterionOperation:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupCriterionOperation); err != nil {
			return err
		}
	case *MutateOperation_AdGroupOperation:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupOperation); err != nil {
			return err
		}
	case *MutateOperation_BiddingStrategyOperation:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BiddingStrategyOperation); err != nil {
			return err
		}
	case *MutateOperation_CampaignBidModifierOperation:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBidModifierOperation); err != nil {
			return err
		}
	case *MutateOperation_CampaignBudgetOperation:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBudgetOperation); err != nil {
			return err
		}
	case *MutateOperation_CampaignOperation:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignOperation); err != nil {
			return err
		}
	case *MutateOperation_CampaignSharedSetOperation:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignSharedSetOperation); err != nil {
			return err
		}
	case *MutateOperation_ConversionActionOperation:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConversionActionOperation); err != nil {
			return err
		}
	case *MutateOperation_CampaignCriterionOperation:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignCriterionOperation); err != nil {
			return err
		}
	case *MutateOperation_SharedCriterionOperation:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SharedCriterionOperation); err != nil {
			return err
		}
	case *MutateOperation_SharedSetOperation:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SharedSetOperation); err != nil {
			return err
		}
	case *MutateOperation_UserListOperation:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserListOperation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MutateOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _MutateOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MutateOperation)
	switch tag {
	case 1: // operation.ad_group_ad_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdGroupAdOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_AdGroupAdOperation{msg}
		return true, err
	case 2: // operation.ad_group_bid_modifier_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdGroupBidModifierOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_AdGroupBidModifierOperation{msg}
		return true, err
	case 3: // operation.ad_group_criterion_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdGroupCriterionOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_AdGroupCriterionOperation{msg}
		return true, err
	case 5: // operation.ad_group_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AdGroupOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_AdGroupOperation{msg}
		return true, err
	case 6: // operation.bidding_strategy_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BiddingStrategyOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_BiddingStrategyOperation{msg}
		return true, err
	case 7: // operation.campaign_bid_modifier_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CampaignBidModifierOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_CampaignBidModifierOperation{msg}
		return true, err
	case 8: // operation.campaign_budget_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CampaignBudgetOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_CampaignBudgetOperation{msg}
		return true, err
	case 10: // operation.campaign_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CampaignOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_CampaignOperation{msg}
		return true, err
	case 11: // operation.campaign_shared_set_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CampaignSharedSetOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_CampaignSharedSetOperation{msg}
		return true, err
	case 12: // operation.conversion_action_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConversionActionOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_ConversionActionOperation{msg}
		return true, err
	case 13: // operation.campaign_criterion_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CampaignCriterionOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_CampaignCriterionOperation{msg}
		return true, err
	case 14: // operation.shared_criterion_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SharedCriterionOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_SharedCriterionOperation{msg}
		return true, err
	case 15: // operation.shared_set_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SharedSetOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_SharedSetOperation{msg}
		return true, err
	case 16: // operation.user_list_operation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UserListOperation)
		err := b.DecodeMessage(msg)
		m.Operation = &MutateOperation_UserListOperation{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MutateOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MutateOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MutateOperation_AdGroupAdOperation:
		s := proto.Size(x.AdGroupAdOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_AdGroupBidModifierOperation:
		s := proto.Size(x.AdGroupBidModifierOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_AdGroupCriterionOperation:
		s := proto.Size(x.AdGroupCriterionOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_AdGroupOperation:
		s := proto.Size(x.AdGroupOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_BiddingStrategyOperation:
		s := proto.Size(x.BiddingStrategyOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_CampaignBidModifierOperation:
		s := proto.Size(x.CampaignBidModifierOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_CampaignBudgetOperation:
		s := proto.Size(x.CampaignBudgetOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_CampaignOperation:
		s := proto.Size(x.CampaignOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_CampaignSharedSetOperation:
		s := proto.Size(x.CampaignSharedSetOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_ConversionActionOperation:
		s := proto.Size(x.ConversionActionOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_CampaignCriterionOperation:
		s := proto.Size(x.CampaignCriterionOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_SharedCriterionOperation:
		s := proto.Size(x.SharedCriterionOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_SharedSetOperation:
		s := proto.Size(x.SharedSetOperation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperation_UserListOperation:
		s := proto.Size(x.UserListOperation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for the resource mutate.
type MutateOperationResponse struct {
	// The mutate response
	//
	// Types that are valid to be assigned to Response:
	//	*MutateOperationResponse_AdGroupAdResult
	//	*MutateOperationResponse_AdGroupBidModifierResult
	//	*MutateOperationResponse_AdGroupCriterionResult
	//	*MutateOperationResponse_AdGroupResult
	//	*MutateOperationResponse_BiddingStrategyResult
	//	*MutateOperationResponse_CampaignBidModifierResult
	//	*MutateOperationResponse_CampaignBudgetResult
	//	*MutateOperationResponse_CampaignResult
	//	*MutateOperationResponse_CampaignSharedSetResult
	//	*MutateOperationResponse_ConversionActionResult
	//	*MutateOperationResponse_CampaignCriterionResult
	//	*MutateOperationResponse_SharedCriterionResult
	//	*MutateOperationResponse_SharedSetResult
	//	*MutateOperationResponse_UserListResult
	Response             isMutateOperationResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *MutateOperationResponse) Reset()         { *m = MutateOperationResponse{} }
func (m *MutateOperationResponse) String() string { return proto.CompactTextString(m) }
func (*MutateOperationResponse) ProtoMessage()    {}
func (*MutateOperationResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_google_ads_service_3761253d210e4f2f, []int{6}
}
func (m *MutateOperationResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateOperationResponse.Unmarshal(m, b)
}
func (m *MutateOperationResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateOperationResponse.Marshal(b, m, deterministic)
}
func (dst *MutateOperationResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateOperationResponse.Merge(dst, src)
}
func (m *MutateOperationResponse) XXX_Size() int {
	return xxx_messageInfo_MutateOperationResponse.Size(m)
}
func (m *MutateOperationResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateOperationResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateOperationResponse proto.InternalMessageInfo

type isMutateOperationResponse_Response interface {
	isMutateOperationResponse_Response()
}

type MutateOperationResponse_AdGroupAdResult struct {
	AdGroupAdResult *MutateAdGroupAdResult `protobuf:"bytes,1,opt,name=ad_group_ad_result,json=adGroupAdResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupBidModifierResult struct {
	AdGroupBidModifierResult *MutateAdGroupBidModifierResult `protobuf:"bytes,2,opt,name=ad_group_bid_modifier_result,json=adGroupBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupCriterionResult struct {
	AdGroupCriterionResult *MutateAdGroupCriterionResult `protobuf:"bytes,3,opt,name=ad_group_criterion_result,json=adGroupCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_AdGroupResult struct {
	AdGroupResult *MutateAdGroupResult `protobuf:"bytes,5,opt,name=ad_group_result,json=adGroupResult,proto3,oneof"`
}

type MutateOperationResponse_BiddingStrategyResult struct {
	BiddingStrategyResult *MutateBiddingStrategyResult `protobuf:"bytes,6,opt,name=bidding_strategy_result,json=biddingStrategyResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBidModifierResult struct {
	CampaignBidModifierResult *MutateCampaignBidModifierResult `protobuf:"bytes,7,opt,name=campaign_bid_modifier_result,json=campaignBidModifierResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignBudgetResult struct {
	CampaignBudgetResult *MutateCampaignBudgetResult `protobuf:"bytes,8,opt,name=campaign_budget_result,json=campaignBudgetResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignResult struct {
	CampaignResult *MutateCampaignResult `protobuf:"bytes,10,opt,name=campaign_result,json=campaignResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignSharedSetResult struct {
	CampaignSharedSetResult *MutateCampaignSharedSetResult `protobuf:"bytes,11,opt,name=campaign_shared_set_result,json=campaignSharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_ConversionActionResult struct {
	ConversionActionResult *MutateConversionActionResult `protobuf:"bytes,12,opt,name=conversion_action_result,json=conversionActionResult,proto3,oneof"`
}

type MutateOperationResponse_CampaignCriterionResult struct {
	CampaignCriterionResult *MutateCampaignCriterionResult `protobuf:"bytes,13,opt,name=campaign_criterion_result,json=campaignCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedCriterionResult struct {
	SharedCriterionResult *MutateSharedCriterionResult `protobuf:"bytes,14,opt,name=shared_criterion_result,json=sharedCriterionResult,proto3,oneof"`
}

type MutateOperationResponse_SharedSetResult struct {
	SharedSetResult *MutateSharedSetResult `protobuf:"bytes,15,opt,name=shared_set_result,json=sharedSetResult,proto3,oneof"`
}

type MutateOperationResponse_UserListResult struct {
	UserListResult *MutateUserListResult `protobuf:"bytes,16,opt,name=user_list_result,json=userListResult,proto3,oneof"`
}

func (*MutateOperationResponse_AdGroupAdResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_AdGroupResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_BiddingStrategyResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBidModifierResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignBudgetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignSharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_ConversionActionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_CampaignCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedCriterionResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_SharedSetResult) isMutateOperationResponse_Response() {}

func (*MutateOperationResponse_UserListResult) isMutateOperationResponse_Response() {}

func (m *MutateOperationResponse) GetResponse() isMutateOperationResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupAdResult() *MutateAdGroupAdResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupAdResult); ok {
		return x.AdGroupAdResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupBidModifierResult() *MutateAdGroupBidModifierResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupBidModifierResult); ok {
		return x.AdGroupBidModifierResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupCriterionResult() *MutateAdGroupCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupCriterionResult); ok {
		return x.AdGroupCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetAdGroupResult() *MutateAdGroupResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_AdGroupResult); ok {
		return x.AdGroupResult
	}
	return nil
}

func (m *MutateOperationResponse) GetBiddingStrategyResult() *MutateBiddingStrategyResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_BiddingStrategyResult); ok {
		return x.BiddingStrategyResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignBidModifierResult() *MutateCampaignBidModifierResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignBidModifierResult); ok {
		return x.CampaignBidModifierResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignBudgetResult() *MutateCampaignBudgetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignBudgetResult); ok {
		return x.CampaignBudgetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignResult() *MutateCampaignResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignResult); ok {
		return x.CampaignResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignSharedSetResult() *MutateCampaignSharedSetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignSharedSetResult); ok {
		return x.CampaignSharedSetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetConversionActionResult() *MutateConversionActionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_ConversionActionResult); ok {
		return x.ConversionActionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetCampaignCriterionResult() *MutateCampaignCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_CampaignCriterionResult); ok {
		return x.CampaignCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetSharedCriterionResult() *MutateSharedCriterionResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_SharedCriterionResult); ok {
		return x.SharedCriterionResult
	}
	return nil
}

func (m *MutateOperationResponse) GetSharedSetResult() *MutateSharedSetResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_SharedSetResult); ok {
		return x.SharedSetResult
	}
	return nil
}

func (m *MutateOperationResponse) GetUserListResult() *MutateUserListResult {
	if x, ok := m.GetResponse().(*MutateOperationResponse_UserListResult); ok {
		return x.UserListResult
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MutateOperationResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MutateOperationResponse_OneofMarshaler, _MutateOperationResponse_OneofUnmarshaler, _MutateOperationResponse_OneofSizer, []interface{}{
		(*MutateOperationResponse_AdGroupAdResult)(nil),
		(*MutateOperationResponse_AdGroupBidModifierResult)(nil),
		(*MutateOperationResponse_AdGroupCriterionResult)(nil),
		(*MutateOperationResponse_AdGroupResult)(nil),
		(*MutateOperationResponse_BiddingStrategyResult)(nil),
		(*MutateOperationResponse_CampaignBidModifierResult)(nil),
		(*MutateOperationResponse_CampaignBudgetResult)(nil),
		(*MutateOperationResponse_CampaignResult)(nil),
		(*MutateOperationResponse_CampaignSharedSetResult)(nil),
		(*MutateOperationResponse_ConversionActionResult)(nil),
		(*MutateOperationResponse_CampaignCriterionResult)(nil),
		(*MutateOperationResponse_SharedCriterionResult)(nil),
		(*MutateOperationResponse_SharedSetResult)(nil),
		(*MutateOperationResponse_UserListResult)(nil),
	}
}

func _MutateOperationResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MutateOperationResponse)
	// response
	switch x := m.Response.(type) {
	case *MutateOperationResponse_AdGroupAdResult:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupAdResult); err != nil {
			return err
		}
	case *MutateOperationResponse_AdGroupBidModifierResult:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupBidModifierResult); err != nil {
			return err
		}
	case *MutateOperationResponse_AdGroupCriterionResult:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupCriterionResult); err != nil {
			return err
		}
	case *MutateOperationResponse_AdGroupResult:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AdGroupResult); err != nil {
			return err
		}
	case *MutateOperationResponse_BiddingStrategyResult:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BiddingStrategyResult); err != nil {
			return err
		}
	case *MutateOperationResponse_CampaignBidModifierResult:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBidModifierResult); err != nil {
			return err
		}
	case *MutateOperationResponse_CampaignBudgetResult:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBudgetResult); err != nil {
			return err
		}
	case *MutateOperationResponse_CampaignResult:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignResult); err != nil {
			return err
		}
	case *MutateOperationResponse_CampaignSharedSetResult:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignSharedSetResult); err != nil {
			return err
		}
	case *MutateOperationResponse_ConversionActionResult:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConversionActionResult); err != nil {
			return err
		}
	case *MutateOperationResponse_CampaignCriterionResult:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignCriterionResult); err != nil {
			return err
		}
	case *MutateOperationResponse_SharedCriterionResult:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SharedCriterionResult); err != nil {
			return err
		}
	case *MutateOperationResponse_SharedSetResult:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SharedSetResult); err != nil {
			return err
		}
	case *MutateOperationResponse_UserListResult:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserListResult); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MutateOperationResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _MutateOperationResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MutateOperationResponse)
	switch tag {
	case 1: // response.ad_group_ad_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateAdGroupAdResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_AdGroupAdResult{msg}
		return true, err
	case 2: // response.ad_group_bid_modifier_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateAdGroupBidModifierResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_AdGroupBidModifierResult{msg}
		return true, err
	case 3: // response.ad_group_criterion_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateAdGroupCriterionResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_AdGroupCriterionResult{msg}
		return true, err
	case 5: // response.ad_group_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateAdGroupResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_AdGroupResult{msg}
		return true, err
	case 6: // response.bidding_strategy_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateBiddingStrategyResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_BiddingStrategyResult{msg}
		return true, err
	case 7: // response.campaign_bid_modifier_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateCampaignBidModifierResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_CampaignBidModifierResult{msg}
		return true, err
	case 8: // response.campaign_budget_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateCampaignBudgetResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_CampaignBudgetResult{msg}
		return true, err
	case 10: // response.campaign_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateCampaignResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_CampaignResult{msg}
		return true, err
	case 11: // response.campaign_shared_set_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateCampaignSharedSetResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_CampaignSharedSetResult{msg}
		return true, err
	case 12: // response.conversion_action_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateConversionActionResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_ConversionActionResult{msg}
		return true, err
	case 13: // response.campaign_criterion_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateCampaignCriterionResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_CampaignCriterionResult{msg}
		return true, err
	case 14: // response.shared_criterion_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateSharedCriterionResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_SharedCriterionResult{msg}
		return true, err
	case 15: // response.shared_set_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateSharedSetResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_SharedSetResult{msg}
		return true, err
	case 16: // response.user_list_result
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutateUserListResult)
		err := b.DecodeMessage(msg)
		m.Response = &MutateOperationResponse_UserListResult{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MutateOperationResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MutateOperationResponse)
	// response
	switch x := m.Response.(type) {
	case *MutateOperationResponse_AdGroupAdResult:
		s := proto.Size(x.AdGroupAdResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_AdGroupBidModifierResult:
		s := proto.Size(x.AdGroupBidModifierResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_AdGroupCriterionResult:
		s := proto.Size(x.AdGroupCriterionResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_AdGroupResult:
		s := proto.Size(x.AdGroupResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_BiddingStrategyResult:
		s := proto.Size(x.BiddingStrategyResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_CampaignBidModifierResult:
		s := proto.Size(x.CampaignBidModifierResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_CampaignBudgetResult:
		s := proto.Size(x.CampaignBudgetResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_CampaignResult:
		s := proto.Size(x.CampaignResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_CampaignSharedSetResult:
		s := proto.Size(x.CampaignSharedSetResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_ConversionActionResult:
		s := proto.Size(x.ConversionActionResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_CampaignCriterionResult:
		s := proto.Size(x.CampaignCriterionResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_SharedCriterionResult:
		s := proto.Size(x.SharedCriterionResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_SharedSetResult:
		s := proto.Size(x.SharedSetResult)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MutateOperationResponse_UserListResult:
		s := proto.Size(x.UserListResult)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*SearchGoogleAdsRequest)(nil), "google.ads.googleads.v0.services.SearchGoogleAdsRequest")
	proto.RegisterType((*SearchGoogleAdsResponse)(nil), "google.ads.googleads.v0.services.SearchGoogleAdsResponse")
	proto.RegisterType((*GoogleAdsRow)(nil), "google.ads.googleads.v0.services.GoogleAdsRow")
	proto.RegisterType((*MutateGoogleAdsRequest)(nil), "google.ads.googleads.v0.services.MutateGoogleAdsRequest")
	proto.RegisterType((*MutateGoogleAdsResponse)(nil), "google.ads.googleads.v0.services.MutateGoogleAdsResponse")
	proto.RegisterType((*MutateOperation)(nil), "google.ads.googleads.v0.services.MutateOperation")
	proto.RegisterType((*MutateOperationResponse)(nil), "google.ads.googleads.v0.services.MutateOperationResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GoogleAdsServiceClient is the client API for GoogleAdsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GoogleAdsServiceClient interface {
	// Returns all rows that match the search query.
	Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error)
	// Creates, updates, or removes resources. Operation statuses are returned.
	Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error)
}

type googleAdsServiceClient struct {
	cc *grpc.ClientConn
}

func NewGoogleAdsServiceClient(cc *grpc.ClientConn) GoogleAdsServiceClient {
	return &googleAdsServiceClient{cc}
}

func (c *googleAdsServiceClient) Search(ctx context.Context, in *SearchGoogleAdsRequest, opts ...grpc.CallOption) (*SearchGoogleAdsResponse, error) {
	out := new(SearchGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.GoogleAdsService/Search", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *googleAdsServiceClient) Mutate(ctx context.Context, in *MutateGoogleAdsRequest, opts ...grpc.CallOption) (*MutateGoogleAdsResponse, error) {
	out := new(MutateGoogleAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.GoogleAdsService/Mutate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GoogleAdsServiceServer is the server API for GoogleAdsService service.
type GoogleAdsServiceServer interface {
	// Returns all rows that match the search query.
	Search(context.Context, *SearchGoogleAdsRequest) (*SearchGoogleAdsResponse, error)
	// Creates, updates, or removes resources. Operation statuses are returned.
	Mutate(context.Context, *MutateGoogleAdsRequest) (*MutateGoogleAdsResponse, error)
}

func RegisterGoogleAdsServiceServer(s *grpc.Server, srv GoogleAdsServiceServer) {
	s.RegisterService(&_GoogleAdsService_serviceDesc, srv)
}

func _GoogleAdsService_Search_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Search(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.GoogleAdsService/Search",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Search(ctx, req.(*SearchGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GoogleAdsService_Mutate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateGoogleAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.GoogleAdsService/Mutate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GoogleAdsServiceServer).Mutate(ctx, req.(*MutateGoogleAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _GoogleAdsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.GoogleAdsService",
	HandlerType: (*GoogleAdsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Search",
			Handler:    _GoogleAdsService_Search_Handler,
		},
		{
			MethodName: "Mutate",
			Handler:    _GoogleAdsService_Mutate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/google_ads_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/google_ads_service.proto", fileDescriptor_google_ads_service_3761253d210e4f2f)
}

var fileDescriptor_google_ads_service_3761253d210e4f2f = []byte{
	// 3224 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x5b, 0xcd, 0x73, 0xdc, 0xb6,
	0x15, 0xcf, 0xca, 0xb1, 0x2d, 0x41, 0xdf, 0x90, 0x64, 0xc1, 0xb2, 0x1d, 0x2b, 0x4a, 0x9a, 0xb8,
	0x8e, 0xbd, 0x52, 0xe4, 0x24, 0xb6, 0xd6, 0x5f, 0x59, 0xc9, 0xb6, 0xec, 0x89, 0x95, 0xa8, 0x94,
	0xa3, 0x4c, 0x52, 0xb7, 0x0c, 0x96, 0x84, 0x56, 0xac, 0xf8, 0x15, 0x92, 0x2b, 0x55, 0xce, 0x38,
	0xd3, 0x66, 0xda, 0x69, 0x0e, 0xbd, 0xf5, 0x3f, 0xe8, 0xb1, 0x33, 0x9d, 0xe9, 0xb1, 0x7f, 0x43,
	0xaf, 0x3d, 0xb5, 0xe7, 0xce, 0x74, 0xa6, 0x7f, 0x40, 0x4f, 0x3d, 0x74, 0x00, 0x02, 0x24, 0x08,
	0x72, 0xbd, 0xa0, 0x6e, 0xcb, 0x07, 0xfe, 0xde, 0xef, 0xe1, 0xe3, 0xe1, 0x3d, 0x3c, 0x70, 0xc1,
	0x5a, 0x37, 0x08, 0xba, 0x2e, 0x59, 0xc6, 0x76, 0xbc, 0x9c, 0xfe, 0xa4, 0xbf, 0x0e, 0x57, 0x96,
	0x63, 0x12, 0x1d, 0x3a, 0x16, 0x11, 0x52, 0x13, 0xdb, 0xb1, 0xc9, 0x65, 0xcd, 0x30, 0x0a, 0x92,
	0x00, 0x2e, 0xa6, 0x2d, 0x4d, 0x6c, 0xc7, 0xcd, 0x0c, 0xda, 0x3c, 0x5c, 0x69, 0x0a, 0xe8, 0xc2,
	0xb5, 0x7e, 0xca, 0xad, 0xc0, 0xf3, 0x02, 0x7f, 0xd9, 0x23, 0x49, 0xe4, 0x58, 0x71, 0xaa, 0x6f,
	0xe1, 0xfa, 0x80, 0xb7, 0x63, 0xd2, 0xf5, 0x88, 0x9f, 0x88, 0xd7, 0x3f, 0xea, 0xf7, 0x7a, 0x44,
	0xe2, 0xa0, 0x17, 0x51, 0xd3, 0xb1, 0x65, 0x05, 0x3d, 0x3f, 0x31, 0x3b, 0x3d, 0xbb, 0x4b, 0x12,
	0x8e, 0xbb, 0x5f, 0x17, 0x67, 0x86, 0x51, 0x10, 0x06, 0x31, 0x76, 0xb9, 0x82, 0x15, 0x0d, 0x05,
	0xb6, 0xd9, 0x8d, 0x82, 0x5e, 0xc8, 0x11, 0x37, 0xf4, 0x11, 0x26, 0xb6, 0x39, 0xe8, 0x5e, 0x1d,
	0x50, 0xcf, 0x76, 0x88, 0x6f, 0x11, 0xf3, 0xd0, 0x21, 0x47, 0x1c, 0x7f, 0xb7, 0x06, 0xbe, 0xe3,
	0xd8, 0xa6, 0x17, 0xd8, 0xce, 0x9e, 0x43, 0x22, 0x0e, 0x6f, 0xd5, 0x80, 0x5b, 0x91, 0x93, 0x90,
	0xc8, 0x09, 0x7c, 0x8e, 0xfd, 0xb0, 0x06, 0x76, 0x8f, 0x10, 0xd1, 0xe3, 0x5b, 0x5a, 0xb0, 0xd8,
	0xda, 0x27, 0x76, 0xcf, 0x2d, 0xf4, 0x55, 0x67, 0x2d, 0x74, 0x89, 0x19, 0x61, 0xbf, 0x5b, 0xc0,
	0x69, 0x30, 0x76, 0x1c, 0xdb, 0x76, 0xfc, 0xae, 0x19, 0x27, 0x11, 0x4e, 0x48, 0xf7, 0x58, 0xbf,
	0x8b, 0x1d, 0xc7, 0x75, 0x19, 0x92, 0x24, 0xd9, 0x4a, 0xd0, 0x58, 0x3b, 0x16, 0xf6, 0x42, 0xec,
	0x74, 0x7d, 0xfd, 0x65, 0x20, 0x10, 0x27, 0x5d, 0x06, 0x19, 0xbe, 0x62, 0x19, 0xdc, 0xac, 0x03,
	0x97, 0xdd, 0xac, 0x55, 0x03, 0x78, 0x82, 0xf5, 0x93, 0x61, 0xa5, 0xf5, 0x73, 0xbb, 0x06, 0x2c,
	0xde, 0xc7, 0x11, 0xb1, 0xe9, 0xdc, 0xe8, 0x2f, 0x05, 0x0b, 0x47, 0x91, 0x43, 0x22, 0xd3, 0x0a,
	0xfc, 0x38, 0xc1, 0x7e, 0x52, 0xc3, 0xda, 0x7d, 0xb6, 0xf2, 0xe2, 0x04, 0x27, 0x3d, 0xb1, 0x7f,
	0xad, 0x69, 0xc0, 0x02, 0xff, 0x90, 0x44, 0xb1, 0x13, 0xf8, 0x26, 0xb6, 0x92, 0x7c, 0x7c, 0x74,
	0x56, 0x51, 0x2f, 0x4e, 0x02, 0xaf, 0xd6, 0x34, 0x72, 0x84, 0x69, 0xb9, 0x0e, 0xc9, 0x3a, 0x77,
	0xa7, 0x36, 0xd0, 0x74, 0x1d, 0xff, 0xa0, 0xc6, 0xd0, 0x08, 0xb4, 0x34, 0x91, 0x77, 0x6b, 0xc0,
	0x3c, 0xec, 0xe3, 0x2e, 0x89, 0x64, 0x56, 0x0d, 0x9b, 0x6d, 0x27, 0x0e, 0x5d, 0x7c, 0x6c, 0x1e,
	0x90, 0xe3, 0xa3, 0x20, 0xb2, 0x65, 0x87, 0xb9, 0x36, 0x18, 0x2d, 0x99, 0xfa, 0xbe, 0xde, 0xdb,
	0xa6, 0x93, 0x10, 0x8f, 0x43, 0x3e, 0xd0, 0x84, 0x78, 0x38, 0x0c, 0x1d, 0xbf, 0xab, 0x1f, 0x43,
	0xba, 0xc4, 0xb7, 0x49, 0x24, 0xf7, 0xe5, 0xb6, 0x0e, 0x28, 0x30, 0x13, 0x1c, 0xd1, 0x38, 0xa7,
	0xac, 0x6b, 0x0d, 0x8f, 0xd8, 0x0f, 0x12, 0xe2, 0xf2, 0x8d, 0x5c, 0xa2, 0xbd, 0xa7, 0x8b, 0x0c,
	0x49, 0xb4, 0x17, 0x44, 0x1e, 0x56, 0xf6, 0x2c, 0x8d, 0x11, 0x12, 0x13, 0x17, 0xba, 0xd8, 0xd7,
	0x5f, 0x35, 0x32, 0xca, 0x54, 0x82, 0x74, 0x5d, 0xb8, 0xb2, 0x4f, 0xdf, 0xa9, 0x09, 0xe7, 0x0f,
	0x1c, 0xfd, 0xb0, 0x26, 0xda, 0x27, 0x5d, 0x9c, 0x38, 0x87, 0x44, 0x51, 0x53, 0x63, 0xe0, 0xa4,
	0xe1, 0xd6, 0xd8, 0x89, 0x5c, 0xec, 0x77, 0x7b, 0x34, 0x84, 0x2a, 0x6b, 0x44, 0x63, 0xa6, 0x53,
	0x07, 0x65, 0x76, 0x5b, 0x84, 0x26, 0x70, 0x32, 0xf5, 0xaa, 0x06, 0x9e, 0xd8, 0x0e, 0x36, 0xf7,
	0x1c, 0x97, 0xe7, 0x9d, 0x0b, 0x0f, 0x34, 0x30, 0x41, 0xc7, 0xa1, 0x39, 0x6b, 0x18, 0x9a, 0x16,
	0x8d, 0xda, 0x41, 0x74, 0x7c, 0x12, 0xcb, 0x53, 0x2d, 0x36, 0xa1, 0xd9, 0xac, 0x8a, 0x7f, 0x32,
	0x18, 0x1f, 0x84, 0x24, 0xc2, 0x09, 0x4b, 0x01, 0x8e, 0xe3, 0x84, 0x78, 0xa6, 0xd8, 0xcc, 0x15,
	0x55, 0x1a, 0x4b, 0x27, 0xc4, 0x11, 0xf1, 0x13, 0xec, 0xf2, 0x10, 0x22, 0x0f, 0xa1, 0x46, 0xa0,
	0x0d, 0xa3, 0xc0, 0xee, 0x59, 0x49, 0xd9, 0x51, 0x35, 0xf2, 0xa6, 0x88, 0xd0, 0xf4, 0x9b, 0xf8,
	0x36, 0x96, 0x02, 0x50, 0x4b, 0x07, 0xe7, 0xe1, 0xe8, 0x80, 0xb0, 0xee, 0x17, 0x82, 0x97, 0xc6,
	0xb6, 0x12, 0x13, 0x1c, 0x59, 0xfb, 0x66, 0x42, 0x22, 0xaf, 0x66, 0xb6, 0xc6, 0xc3, 0xba, 0x9a,
	0x50, 0xac, 0x6a, 0x23, 0xf3, 0x84, 0x40, 0x63, 0x6c, 0x92, 0x20, 0x74, 0x2c, 0x75, 0x36, 0x57,
	0x75, 0x71, 0x52, 0xcf, 0x34, 0xe2, 0x64, 0x2f, 0x26, 0x91, 0xe9, 0xf8, 0x09, 0x89, 0x48, 0x9c,
	0xe8, 0x07, 0x1f, 0x06, 0x73, 0x9d, 0x0c, 0x72, 0x7d, 0x30, 0xe4, 0xd0, 0xb1, 0x49, 0x30, 0x68,
	0xa2, 0xb3, 0xe3, 0xa1, 0x74, 0x70, 0x29, 0x9e, 0x0f, 0xfb, 0xfb, 0x69, 0x19, 0x2b, 0x27, 0x9e,
	0x8a, 0x96, 0xb6, 0xbe, 0x96, 0x6c, 0xd6, 0x15, 0x15, 0x37, 0xf5, 0x55, 0x14, 0x81, 0xf7, 0x07,
	0x02, 0xd5, 0xd3, 0x41, 0xed, 0x21, 0xa8, 0xcc, 0xbd, 0x15, 0x2d, 0xf7, 0x6a, 0x68, 0x49, 0x4f,
	0xac, 0x75, 0x87, 0xb0, 0x9c, 0x89, 0xd7, 0x1e, 0xc2, 0x3c, 0xb3, 0x2e, 0x00, 0xd7, 0x6b, 0x00,
	0x33, 0x0f, 0x54, 0x74, 0x7c, 0x3c, 0x58, 0x87, 0x9a, 0x28, 0xd7, 0x9e, 0x48, 0x75, 0xe3, 0x50,
	0x14, 0xac, 0xe9, 0x2a, 0x28, 0x5b, 0x7f, 0x6b, 0x20, 0x34, 0xf3, 0x51, 0x05, 0x79, 0x51, 0x20,
	0x43, 0x67, 0x19, 0xfb, 0x7e, 0x90, 0xb0, 0x2d, 0x58, 0x9c, 0x1f, 0x78, 0xf9, 0x65, 0x99, 0x3d,
	0x75, 0x7a, 0x7b, 0xcb, 0x7b, 0x0e, 0x71, 0x69, 0xd6, 0x18, 0x8b, 0x3c, 0x78, 0x9e, 0xbf, 0x11,
	0x85, 0xd6, 0xb2, 0x7c, 0xf4, 0x58, 0xfa, 0x4b, 0x03, 0x9c, 0xdb, 0x61, 0x7b, 0xec, 0x26, 0x7b,
	0xa3, 0x6d, 0xc7, 0x06, 0xf9, 0xa6, 0x47, 0xe2, 0x04, 0x5e, 0x06, 0xa3, 0x59, 0x6a, 0xed, 0xd8,
	0xa8, 0xb1, 0xd8, 0xb8, 0x32, 0x62, 0x00, 0x21, 0x7a, 0x62, 0xc3, 0x59, 0x70, 0xfa, 0x9b, 0x1e,
	0x89, 0x8e, 0xd1, 0x10, 0x6b, 0x4a, 0x1f, 0xe0, 0x25, 0x00, 0x42, 0x9a, 0x1e, 0x24, 0xc1, 0x01,
	0xf1, 0xd1, 0x29, 0xd6, 0x34, 0x42, 0x25, 0xcf, 0xa8, 0x00, 0x5e, 0x00, 0xec, 0xc1, 0x8c, 0x9d,
	0x17, 0x04, 0xbd, 0xbe, 0xd8, 0xb8, 0x72, 0xda, 0x18, 0xa6, 0x82, 0x1d, 0xe7, 0x05, 0x81, 0x6f,
	0x81, 0xf1, 0x43, 0xec, 0x3a, 0x36, 0x4e, 0x88, 0x19, 0xf8, 0xee, 0x31, 0x3a, 0xbd, 0xd8, 0xb8,
	0x32, 0x6c, 0x8c, 0x09, 0xe1, 0x67, 0xbe, 0x7b, 0xbc, 0xf4, 0xdf, 0x06, 0x98, 0x2f, 0x99, 0x1c,
	0x87, 0x81, 0x1f, 0x13, 0xf8, 0x18, 0x9c, 0x8d, 0x48, 0xdc, 0x73, 0x93, 0x18, 0x35, 0x16, 0x4f,
	0x5d, 0x19, 0x5d, 0x6d, 0x36, 0x07, 0x95, 0xa6, 0x9a, 0xb9, 0x96, 0xe0, 0xc8, 0x10, 0x70, 0xf8,
	0x0e, 0x98, 0xf4, 0xc9, 0x2f, 0x13, 0x53, 0xea, 0x4b, 0xda, 0xcd, 0x71, 0x2a, 0xde, 0xce, 0xfa,
	0xd3, 0x04, 0x33, 0x49, 0x40, 0xc3, 0x31, 0x07, 0x9a, 0xac, 0x5e, 0xc4, 0xfa, 0x7d, 0xca, 0x98,
	0x66, 0x4d, 0x46, 0xda, 0xb2, 0x41, 0x1b, 0xe0, 0x1a, 0x00, 0xf9, 0xec, 0xb0, 0xfe, 0x8d, 0xae,
	0x2e, 0x08, 0x23, 0xc5, 0x04, 0x36, 0x1f, 0xd1, 0x57, 0xb6, 0x70, 0x7c, 0x60, 0x8c, 0xec, 0x89,
	0x9f, 0x4b, 0xff, 0xb8, 0x06, 0xc6, 0x64, 0x63, 0xe1, 0x17, 0x60, 0xa2, 0x58, 0x9f, 0x42, 0x57,
	0x99, 0xbe, 0x95, 0xbe, 0x9d, 0xce, 0xb6, 0xf6, 0x66, 0x3b, 0x05, 0xae, 0x33, 0x9c, 0x31, 0x8e,
	0xe5, 0x47, 0x18, 0x82, 0xf9, 0x3e, 0x85, 0x2f, 0xf4, 0x1e, 0x63, 0xb8, 0x55, 0x97, 0x61, 0x9b,
	0xe3, 0x8d, 0x39, 0x5c, 0x25, 0x86, 0x0f, 0xc1, 0xb0, 0xd8, 0x79, 0xd9, 0xd8, 0x8d, 0xae, 0x5e,
	0xd5, 0xa1, 0xb0, 0x37, 0x29, 0xc2, 0x38, 0x8b, 0xd3, 0x1f, 0xf0, 0x29, 0x18, 0x95, 0xa2, 0x10,
	0x9a, 0x62, 0x9a, 0xae, 0xe9, 0x6b, 0x6a, 0xdb, 0xc6, 0x08, 0x16, 0x3f, 0xe1, 0x01, 0x38, 0x57,
	0x5d, 0x57, 0x43, 0x6b, 0x4c, 0xf1, 0x47, 0x35, 0x14, 0x73, 0xf8, 0xae, 0x43, 0x8e, 0x8c, 0x19,
	0x5c, 0x16, 0xc2, 0x7d, 0x30, 0x57, 0x19, 0x04, 0x11, 0x62, 0x5c, 0x1f, 0xea, 0x73, 0xad, 0x3b,
	0xf6, 0x16, 0x07, 0x1b, 0x10, 0x97, 0x64, 0x10, 0x03, 0x58, 0x0e, 0x94, 0x68, 0x9a, 0xd1, 0xdc,
	0xd0, 0xa7, 0xd9, 0x10, 0x50, 0x63, 0x0a, 0x2b, 0x12, 0x68, 0x80, 0xf1, 0x42, 0x59, 0x0f, 0x6d,
	0x30, 0xed, 0x4d, 0x7d, 0xed, 0x8f, 0x08, 0xb1, 0x8d, 0x51, 0x9c, 0x3f, 0xc0, 0xcf, 0xc1, 0x44,
	0xb1, 0x72, 0x87, 0x56, 0x98, 0xd2, 0x65, 0x1d, 0xa5, 0x5d, 0x62, 0x50, 0x1c, 0x1b, 0xfe, 0x31,
	0x2c, 0x3d, 0xc1, 0x9f, 0x82, 0x29, 0xb5, 0x94, 0x88, 0xbe, 0x64, 0x8a, 0xdf, 0xd7, 0xb2, 0x76,
	0x87, 0x23, 0x99, 0xea, 0x09, 0x5c, 0x78, 0x86, 0x3f, 0x03, 0x53, 0x6a, 0x5e, 0x80, 0x20, 0x53,
	0xbe, 0xaa, 0xa1, 0x7c, 0x3d, 0x85, 0xee, 0x70, 0xa4, 0x31, 0xd9, 0x29, 0x0a, 0xe0, 0x33, 0x30,
	0x5e, 0x28, 0x2d, 0xa2, 0x1f, 0x6b, 0x8f, 0xc8, 0x7a, 0x8a, 0xdb, 0xa1, 0x30, 0x63, 0xac, 0x23,
	0x3d, 0xc1, 0xaf, 0xc0, 0xa4, 0x92, 0x45, 0xa0, 0x19, 0xed, 0x01, 0xd9, 0xe0, 0x48, 0xbe, 0xb1,
	0x4c, 0x58, 0x85, 0x67, 0xb8, 0x09, 0x86, 0x85, 0x84, 0xed, 0xa7, 0xa3, 0xab, 0xef, 0xd5, 0x50,
	0x6a, 0x64, 0x60, 0xe8, 0x81, 0x73, 0xd5, 0xc5, 0x4e, 0xf4, 0x90, 0xa9, 0xbd, 0x59, 0x43, 0x6d,
	0xc1, 0x39, 0x67, 0xad, 0x0a, 0x29, 0xfc, 0x05, 0x98, 0xab, 0xcc, 0xcf, 0xd0, 0x82, 0xf6, 0x4e,
	0x90, 0x8d, 0x8c, 0xe4, 0x9e, 0x33, 0x56, 0x59, 0x08, 0x2d, 0x00, 0xcb, 0x59, 0x18, 0x9a, 0x65,
	0x44, 0x1f, 0xd4, 0x20, 0xca, 0x1d, 0x74, 0xda, 0x52, 0x45, 0x74, 0xe9, 0x14, 0x0a, 0xa7, 0xe8,
	0xbe, 0xf6, 0xd2, 0x11, 0xfa, 0x99, 0x8b, 0x8e, 0x59, 0xd2, 0x13, 0xb4, 0xc1, 0x4c, 0x45, 0x12,
	0x87, 0xde, 0xa8, 0x6d, 0xfb, 0x0e, 0x03, 0xef, 0x90, 0x24, 0xb7, 0x3d, 0x13, 0x51, 0xaf, 0x52,
	0x0b, 0xb0, 0x68, 0x5d, 0xdb, 0xab, 0x36, 0x52, 0xe8, 0x06, 0x47, 0x1a, 0x93, 0x56, 0x51, 0xc0,
	0x86, 0x46, 0xae, 0xd2, 0xa2, 0x1f, 0xe9, 0x0f, 0x0d, 0xc3, 0xed, 0x30, 0x98, 0x31, 0x66, 0x49,
	0x4f, 0xf0, 0x6b, 0x30, 0x5d, 0xca, 0x4d, 0x51, 0x57, 0x7b, 0xd3, 0xdd, 0xc8, 0xb0, 0x6d, 0x06,
	0x35, 0xa6, 0x2c, 0x45, 0xc2, 0x7c, 0x8b, 0x67, 0x67, 0x2c, 0x5b, 0xd3, 0xf4, 0x2d, 0x0e, 0x31,
	0x32, 0x30, 0x5b, 0xec, 0x55, 0x45, 0x55, 0x74, 0x57, 0x7f, 0xb1, 0x73, 0xfc, 0x56, 0x0a, 0x7f,
	0xea, 0xf8, 0x07, 0xc6, 0x8c, 0x55, 0x16, 0xc2, 0x2e, 0x98, 0xad, 0xaa, 0x1a, 0xa3, 0x7b, 0xda,
	0x51, 0x4f, 0x50, 0x6d, 0x30, 0x34, 0x63, 0x82, 0x56, 0x49, 0xc6, 0x76, 0xb5, 0x22, 0x11, 0x7a,
	0xa4, 0xbf, 0xab, 0x15, 0xf4, 0x19, 0x13, 0x45, 0xfd, 0x6c, 0xc5, 0xc8, 0xc5, 0x6b, 0xf4, 0xb1,
	0xfe, 0x8a, 0xe1, 0x38, 0xee, 0x4c, 0xd2, 0x13, 0x1d, 0x9a, 0xaa, 0xe2, 0x34, 0x5a, 0xd6, 0x1e,
	0x9a, 0x07, 0x29, 0xfc, 0x93, 0x14, 0xcd, 0xb6, 0x37, 0x68, 0x97, 0x64, 0xf0, 0x36, 0x78, 0x9d,
	0x59, 0xdd, 0x64, 0x8a, 0xdf, 0xd5, 0x50, 0xcc, 0xac, 0x65, 0x20, 0xf8, 0x18, 0x8c, 0x64, 0x65,
	0x6d, 0xb4, 0xaa, 0xbd, 0xec, 0xa8, 0x86, 0x27, 0x09, 0xf1, 0x8c, 0xe1, 0x3d, 0xfe, 0x0b, 0xfe,
	0x04, 0x8c, 0xc9, 0xd5, 0x6e, 0xd4, 0xd2, 0xce, 0x19, 0xa8, 0xb2, 0xad, 0x14, 0x65, 0x8c, 0xee,
	0xe5, 0x0f, 0xf0, 0x53, 0x30, 0x2a, 0x95, 0xc2, 0xd1, 0x15, 0xa6, 0xf1, 0xba, 0x86, 0xc6, 0x4d,
	0x86, 0x62, 0x23, 0x06, 0xba, 0xd9, 0x6f, 0xba, 0xbf, 0x55, 0x54, 0xc9, 0xd1, 0xbc, 0xf6, 0xfe,
	0xb6, 0x49, 0x82, 0x67, 0x0c, 0x9c, 0x6d, 0x3f, 0xd3, 0x5d, 0x55, 0x44, 0x53, 0x12, 0xb5, 0x9c,
	0x8e, 0x6e, 0x68, 0xaf, 0xd5, 0xc7, 0x14, 0xca, 0xd2, 0xa6, 0x34, 0x25, 0xd9, 0x2f, 0x3c, 0xd3,
	0xc0, 0x59, 0x5d, 0x71, 0x47, 0x9b, 0xda, 0x81, 0x93, 0x51, 0x6c, 0xe7, 0xf8, 0x34, 0x70, 0xee,
	0x57, 0x48, 0xe9, 0xa4, 0x16, 0x16, 0xef, 0x9c, 0xf6, 0xa4, 0xca, 0xab, 0x76, 0xf4, 0x40, 0x5a,
	0xae, 0x92, 0xca, 0xd0, 0xc5, 0x3e, 0x5a, 0xac, 0xab, 0x72, 0xdb, 0xc5, 0x7e, 0xa6, 0x92, 0x3e,
	0xd0, 0x1d, 0xaf, 0xb2, 0xa2, 0x8f, 0xde, 0xd4, 0xde, 0xf1, 0x24, 0xdd, 0x59, 0xba, 0x32, 0x73,
	0x50, 0x16, 0xc2, 0x5f, 0x35, 0xc0, 0xa5, 0x57, 0x56, 0xf0, 0xd1, 0x12, 0x23, 0xbd, 0x5b, 0x8f,
	0xf4, 0x53, 0xae, 0x85, 0x8b, 0x8c, 0x85, 0x83, 0xbe, 0x6d, 0xf4, 0xac, 0x51, 0x79, 0xff, 0x81,
	0xde, 0xd2, 0xde, 0x5a, 0x24, 0x66, 0x71, 0x0a, 0x83, 0x07, 0x25, 0x19, 0xdd, 0xc3, 0xaa, 0xee,
	0x3a, 0xd0, 0xdb, 0x27, 0x21, 0x12, 0x5d, 0x93, 0x89, 0x44, 0x97, 0xbe, 0x06, 0xd3, 0xa5, 0x9b,
	0x09, 0x74, 0x53, 0x3b, 0xbc, 0x3e, 0xe5, 0xd8, 0xcc, 0x2d, 0xa7, 0x5c, 0x45, 0x42, 0x1d, 0xa7,
	0xfa, 0x02, 0x03, 0x7d, 0xa8, 0xed, 0x38, 0x69, 0xe4, 0xa3, 0x86, 0xa7, 0xf8, 0xd4, 0x71, 0xbc,
	0x0a, 0x29, 0xfc, 0x04, 0x80, 0xfc, 0xbe, 0x03, 0x7d, 0xa5, 0x7d, 0x92, 0xdd, 0xa2, 0xa0, 0x47,
	0x8e, 0x4b, 0x8c, 0x11, 0x4f, 0xfc, 0x84, 0x2f, 0xc1, 0xc5, 0x57, 0x5d, 0x84, 0xa0, 0x2f, 0x98,
	0xfa, 0x3b, 0x3a, 0xea, 0x99, 0x9a, 0x76, 0x18, 0x6e, 0x70, 0x25, 0xd9, 0x88, 0x9d, 0xf7, 0xfa,
	0x35, 0xb1, 0xa1, 0xab, 0xbc, 0x41, 0x41, 0x1d, 0xfd, 0xa1, 0x63, 0x0a, 0x1e, 0x30, 0x7c, 0xc6,
	0x39, 0xeb, 0x55, 0x48, 0xe1, 0xef, 0x1b, 0xe0, 0xcd, 0x81, 0x37, 0x2e, 0x68, 0x97, 0x51, 0xb7,
	0x35, 0xa8, 0x3f, 0x13, 0xba, 0x76, 0x98, 0xaa, 0xdd, 0x54, 0x53, 0x66, 0xc4, 0x1b, 0xc1, 0x2b,
	0xdb, 0xa9, 0x0f, 0x54, 0x5d, 0xda, 0xa0, 0xeb, 0xda, 0x3e, 0xb0, 0xcd, 0xe1, 0x69, 0x2a, 0x99,
	0xc6, 0xf1, 0xb0, 0x24, 0xa3, 0x07, 0xfb, 0xf2, 0xfd, 0x0e, 0xfa, 0x48, 0xdb, 0x09, 0xb6, 0x53,
	0x70, 0x1e, 0x3b, 0xa6, 0x42, 0x45, 0x02, 0xbf, 0x04, 0x13, 0xc5, 0x6b, 0x20, 0x74, 0x4e, 0x3b,
	0x30, 0x19, 0x05, 0xa0, 0xa1, 0x28, 0xa2, 0x51, 0x4f, 0xbd, 0xed, 0x41, 0x0f, 0xb4, 0x95, 0xa7,
	0x15, 0xc1, 0x67, 0x24, 0xf2, 0xd2, 0xa8, 0x17, 0x17, 0x9e, 0xe9, 0x91, 0x41, 0xad, 0xeb, 0xa2,
	0x4b, 0xda, 0x47, 0x86, 0xf4, 0xe8, 0x91, 0x9f, 0xa7, 0x26, 0xe3, 0xa2, 0x80, 0x3a, 0xab, 0x74,
	0xdc, 0xb9, 0xa0, 0xed, 0xac, 0xf9, 0x31, 0x67, 0x24, 0xce, 0x8e, 0x37, 0x9f, 0x00, 0x90, 0x5f,
	0x0b, 0xa1, 0x6b, 0xda, 0xca, 0x9e, 0x51, 0x10, 0xeb, 0xfd, 0x48, 0x22, 0x7e, 0xd2, 0xd4, 0xb4,
	0x70, 0x5f, 0x84, 0x6e, 0x6b, 0xa7, 0xa6, 0x9f, 0xc7, 0x24, 0x7a, 0xc2, 0x61, 0xc6, 0x58, 0x4f,
	0x7a, 0xa2, 0x49, 0x5f, 0x56, 0xaa, 0x46, 0xef, 0x68, 0x27, 0x7d, 0x54, 0xe3, 0x53, 0x27, 0x4e,
	0x8c, 0xe1, 0x1e, 0xff, 0x45, 0x0f, 0xbb, 0xe5, 0xfb, 0x41, 0x74, 0x47, 0x3b, 0xa1, 0x32, 0x72,
	0x30, 0x3f, 0x18, 0x4d, 0x47, 0xaa, 0x08, 0x7e, 0x01, 0x26, 0x8a, 0x17, 0x74, 0xe8, 0xb2, 0x76,
	0xa1, 0x94, 0x8d, 0x6a, 0xe6, 0xeb, 0xe3, 0x89, 0xfc, 0x08, 0xef, 0x81, 0xd3, 0xec, 0x8e, 0x0c,
	0xbd, 0xcb, 0xf4, 0x5d, 0xd1, 0xd0, 0xb7, 0x4b, 0xdf, 0x37, 0x52, 0x18, 0x6c, 0x83, 0xb3, 0xfc,
	0xcb, 0x47, 0x56, 0x0b, 0x7f, 0x55, 0xf2, 0x9d, 0x7e, 0xfa, 0xd8, 0xdc, 0x4a, 0x5f, 0x37, 0x04,
	0x0e, 0x3e, 0x00, 0xc3, 0xe2, 0x73, 0x48, 0xb4, 0x37, 0xc0, 0x0a, 0xae, 0x63, 0x87, 0xbf, 0x6f,
	0x64, 0xc8, 0xa5, 0x7f, 0x37, 0xc0, 0xb9, 0xad, 0x5e, 0x82, 0x13, 0x52, 0xff, 0x1e, 0xe0, 0xe7,
	0x60, 0xda, 0x63, 0x50, 0x93, 0x6f, 0x84, 0x81, 0x1f, 0xa3, 0x21, 0x56, 0x7e, 0x7f, 0x7f, 0x70,
	0xf9, 0x3d, 0x65, 0xfd, 0x4c, 0x20, 0x8d, 0x29, 0xaf, 0x28, 0x88, 0xe1, 0xbb, 0x60, 0x32, 0xc4,
	0x51, 0xe2, 0x60, 0xd7, 0xdc, 0xc3, 0x8e, 0xdb, 0x8b, 0x08, 0x2b, 0x11, 0x0f, 0x1b, 0x13, 0x5c,
	0xfc, 0x28, 0x95, 0x96, 0xaf, 0x0f, 0x5e, 0xaf, 0xb8, 0x3e, 0xf8, 0x67, 0x03, 0xcc, 0x97, 0x7a,
	0xca, 0xaf, 0x0f, 0x1e, 0x81, 0x39, 0x85, 0xc9, 0x24, 0x51, 0x14, 0x44, 0xbc, 0x24, 0x0d, 0x45,
	0x6f, 0xa2, 0xd0, 0x6a, 0xf2, 0x43, 0xfe, 0x4c, 0xd1, 0x86, 0x87, 0xf4, 0x75, 0x78, 0x04, 0x16,
	0xd4, 0x11, 0x31, 0x23, 0x4e, 0x22, 0x6e, 0x26, 0xd6, 0xea, 0x0f, 0x0d, 0xd7, 0x60, 0x20, 0xaf,
	0xba, 0x21, 0x5e, 0xfa, 0xf3, 0x38, 0x98, 0x54, 0x50, 0xd0, 0x91, 0x0a, 0xcb, 0xd8, 0xce, 0x2d,
	0xe2, 0x35, 0x82, 0x0f, 0x06, 0xdb, 0x91, 0x15, 0xc7, 0x33, 0xa5, 0x8f, 0x5f, 0xcb, 0x2a, 0xcb,
	0x92, 0x14, 0xfe, 0xb6, 0x01, 0x2e, 0x57, 0xdf, 0xe4, 0xe6, 0xac, 0x43, 0x03, 0x92, 0x5b, 0x95,
	0x55, 0xaa, 0x8c, 0xc9, 0xf4, 0x17, 0x70, 0xff, 0x66, 0xf8, 0x1d, 0xb8, 0x58, 0x71, 0x15, 0x9c,
	0xdb, 0x90, 0x4e, 0xe7, 0x6d, 0x6d, 0x1b, 0xb2, 0x8d, 0x5e, 0xb6, 0xe0, 0x3c, 0xee, 0xd7, 0x08,
	0x3b, 0x52, 0x85, 0x3d, 0x67, 0x3d, 0x3d, 0x20, 0xde, 0xa8, 0xac, 0x32, 0x99, 0x28, 0xb1, 0xe7,
	0x1c, 0x2f, 0xc0, 0x42, 0xe9, 0xca, 0x39, 0xe7, 0x3a, 0xc3, 0xb8, 0x5a, 0x83, 0xb9, 0x94, 0x1a,
	0xb3, 0xcc, 0x89, 0x3a, 0x7d, 0xda, 0xe0, 0xef, 0x1a, 0xe0, 0x72, 0xf5, 0x75, 0x75, 0x6e, 0xc1,
	0x59, 0x66, 0xc1, 0xbd, 0xc1, 0x16, 0x54, 0xd4, 0x45, 0x65, 0x2b, 0x2e, 0x5a, 0xaf, 0x68, 0x87,
	0x47, 0xe0, 0xbc, 0x7a, 0xe3, 0x9d, 0x9b, 0x30, 0xcc, 0x4c, 0x58, 0xab, 0x61, 0x02, 0xd3, 0x20,
	0xb3, 0xcf, 0x5b, 0xd5, 0x4d, 0xd0, 0x96, 0x8a, 0xb4, 0x39, 0x23, 0x18, 0x90, 0x6b, 0x95, 0x18,
	0x65, 0xae, 0xac, 0xd2, 0x99, 0xb3, 0xfc, 0xba, 0x01, 0x2e, 0x55, 0xdd, 0x8a, 0xe7, 0x8c, 0xa3,
	0x03, 0x32, 0xf7, 0x12, 0x63, 0x96, 0x72, 0xc8, 0xd4, 0x0b, 0x56, 0xdf, 0x56, 0xf8, 0x12, 0x5c,
	0x28, 0x5f, 0xaa, 0xe7, 0x06, 0x8c, 0xe9, 0xfa, 0x92, 0x5a, 0xc1, 0x2c, 0xf8, 0x92, 0xd5, 0xaf,
	0x91, 0x1e, 0x97, 0x2f, 0x56, 0x7c, 0x94, 0x90, 0x1b, 0x30, 0x5e, 0x77, 0x04, 0x2a, 0xbd, 0x79,
	0xc1, 0xea, 0xdb, 0x4a, 0x5d, 0xad, 0xf4, 0x51, 0x40, 0xce, 0x3f, 0xa1, 0xeb, 0x6a, 0x4a, 0x16,
	0x59, 0x70, 0xb5, 0xb8, 0x4f, 0x1b, 0xdc, 0x07, 0xb3, 0x95, 0xf3, 0x3e, 0xa9, 0xbb, 0x79, 0x57,
	0xce, 0x37, 0x8c, 0xcb, 0xf3, 0x4c, 0xc0, 0x4c, 0xfe, 0xf9, 0x41, 0x4e, 0x34, 0xa5, 0xbb, 0xa4,
	0x45, 0x72, 0x57, 0x58, 0xd2, 0x3d, 0x55, 0xb8, 0x3e, 0x0a, 0x46, 0x32, 0xe5, 0x4b, 0x3f, 0x8c,
	0x8b, 0x60, 0x5c, 0x0a, 0x66, 0x70, 0x4f, 0xda, 0x44, 0xb1, 0xcd, 0xef, 0xd7, 0x79, 0xd0, 0xba,
	0xa9, 0x1b, 0x3c, 0xf3, 0x7b, 0x5d, 0x06, 0x7f, 0xfc, 0x9a, 0x31, 0x89, 0x8b, 0x22, 0xf8, 0x7d,
	0x43, 0x8a, 0x16, 0x85, 0xcd, 0x8c, 0x53, 0xa6, 0x11, 0xeb, 0xe3, 0x9a, 0x94, 0xf2, 0x35, 0x8f,
	0xe0, 0x46, 0xb8, 0x4f, 0x1b, 0xfc, 0x16, 0x9c, 0xaf, 0x88, 0x58, 0xdc, 0x80, 0x53, 0xba, 0x5b,
	0x69, 0xc1, 0x80, 0xfc, 0xb8, 0x22, 0xe8, 0xcf, 0xe1, 0xca, 0x16, 0x68, 0x82, 0xc9, 0x8c, 0x9c,
	0x53, 0x9e, 0x1e, 0x70, 0x36, 0xad, 0xa6, 0xcc, 0x98, 0xc6, 0xb1, 0x2c, 0x80, 0x47, 0x60, 0xbe,
	0x14, 0xab, 0x38, 0xd1, 0x19, 0xdd, 0x74, 0x20, 0x25, 0x52, 0xaf, 0x44, 0x05, 0xe1, 0x5c, 0xa7,
	0xaa, 0x01, 0xfe, 0x46, 0xde, 0x3c, 0xaa, 0xe6, 0xf6, 0xec, 0x80, 0x22, 0x80, 0x42, 0x5f, 0x75,
	0x87, 0x27, 0x4c, 0x38, 0x6f, 0xf5, 0x6b, 0x84, 0x89, 0x74, 0x59, 0xc9, 0xa3, 0x14, 0xe7, 0x1f,
	0xd6, 0xdd, 0xbc, 0x14, 0xfe, 0xf4, 0x76, 0x55, 0x50, 0xcf, 0x5a, 0x15, 0x72, 0x88, 0xa5, 0x7b,
	0x5c, 0x4e, 0x07, 0x06, 0x94, 0x33, 0xfb, 0xd0, 0x65, 0x44, 0xd9, 0x75, 0x2e, 0xa7, 0xf8, 0x0e,
	0x2c, 0x54, 0x85, 0x27, 0xce, 0x96, 0xc6, 0xa6, 0xfb, 0x75, 0xd9, 0xf2, 0x43, 0xb1, 0xa0, 0x9d,
	0xb7, 0xaa, 0x9b, 0xe0, 0x0b, 0x80, 0xca, 0xb1, 0x89, 0xb3, 0x8f, 0xd5, 0xf3, 0x9a, 0xd2, 0x05,
	0x5b, 0xe6, 0x35, 0x56, 0x65, 0x0b, 0x7c, 0x29, 0xa5, 0x1e, 0x25, 0x97, 0x1d, 0x3f, 0x59, 0xd7,
	0xcb, 0x3e, 0x3b, 0x6f, 0x55, 0x37, 0x51, 0x9f, 0x2a, 0x05, 0x25, 0x4e, 0x3e, 0x51, 0xcf, 0xa7,
	0xd4, 0xea, 0x46, 0xe6, 0x53, 0x71, 0x55, 0x03, 0x24, 0x60, 0xba, 0x3c, 0xd5, 0x93, 0xf5, 0xb6,
	0xe5, 0xf2, 0x14, 0x4f, 0xc6, 0xca, 0xd4, 0x76, 0xc0, 0x54, 0x1e, 0x8e, 0x38, 0xcb, 0x54, 0xbd,
	0xe5, 0x9b, 0x95, 0x1b, 0xb2, 0xe5, 0xdb, 0x2b, 0x48, 0xd6, 0x01, 0x18, 0x16, 0xc7, 0xb2, 0xd5,
	0x1f, 0x4e, 0x81, 0xa9, 0xec, 0x44, 0xb8, 0x93, 0x2a, 0x82, 0x7f, 0x6d, 0x80, 0x33, 0x69, 0x65,
	0x09, 0xde, 0xd2, 0x08, 0xb5, 0x95, 0x1f, 0xd2, 0x2d, 0xac, 0x9d, 0x00, 0x99, 0x1a, 0xb5, 0xb4,
	0xf6, 0xfd, 0xdf, 0xff, 0xf5, 0x87, 0xa1, 0x1b, 0x4b, 0x4d, 0xf6, 0xe7, 0x47, 0x7e, 0xe4, 0x8e,
	0x97, 0xbf, 0x95, 0x0e, 0xe4, 0x77, 0xaf, 0xbe, 0xe4, 0x1f, 0x13, 0xb6, 0xed, 0xb8, 0x95, 0x96,
	0xbd, 0x5a, 0x8d, 0xab, 0xcc, 0xf4, 0x74, 0x18, 0x74, 0x4c, 0xaf, 0x3e, 0xfb, 0x2f, 0xac, 0x9d,
	0x00, 0x79, 0x52, 0xd3, 0xd3, 0x43, 0x6d, 0xab, 0x71, 0x75, 0xfd, 0x7f, 0x0d, 0xf0, 0xb6, 0x15,
	0x78, 0x03, 0xb9, 0xd7, 0xe7, 0xd4, 0x09, 0xdb, 0x8e, 0x82, 0x24, 0xd8, 0x6e, 0x7c, 0xf5, 0x98,
	0x43, 0xbb, 0x81, 0x8b, 0xfd, 0x6e, 0x33, 0x88, 0xba, 0xcb, 0x5d, 0xe2, 0xb3, 0xcf, 0xeb, 0xc4,
	0x97, 0x97, 0xa1, 0x13, 0xf7, 0xff, 0x10, 0xf3, 0xb6, 0xf8, 0xf1, 0xc7, 0xa1, 0x53, 0x9b, 0xed,
	0xf6, 0x9f, 0x86, 0x16, 0x53, 0xa6, 0x66, 0xdb, 0x96, 0x3e, 0x18, 0x6c, 0xee, 0xae, 0x34, 0x39,
	0x71, 0xfc, 0x37, 0xf1, 0xca, 0xf3, 0xb6, 0x1d, 0x3f, 0xcf, 0x5e, 0x79, 0xbe, 0xbb, 0xf2, 0x5c,
	0xbc, 0xf2, 0x9f, 0xa1, 0xb7, 0x53, 0x79, 0xab, 0x45, 0xfb, 0xdb, 0xca, 0x5e, 0x6a, 0xb5, 0x76,
	0x57, 0x5a, 0x2d, 0xf1, 0x5a, 0xe7, 0x0c, 0xb3, 0xf3, 0xc6, 0xff, 0x03, 0x00, 0x00, 0xff, 0xff,
	0x11, 0x58, 0xa6, 0xb8, 0x91, 0x3b, 0x00, 0x00,
}
