// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/irm/v1alpha2/incidents.proto

package irm // import "google.golang.org/genproto/googleapis/cloud/irm/v1alpha2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import _ "google.golang.org/genproto/googleapis/monitoring/v3"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Describes whether the alerting condition is still firing.
type Signal_State int32

const (
	// Unspecified
	Signal_STATE_UNSPECIFIED Signal_State = 0
	// Firing
	Signal_STATE_OPEN Signal_State = 1
	// Non-firing
	Signal_STATE_CLOSED Signal_State = 2
)

var Signal_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STATE_OPEN",
	2: "STATE_CLOSED",
}
var Signal_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"STATE_OPEN":        1,
	"STATE_CLOSED":      2,
}

func (x Signal_State) String() string {
	return proto.EnumName(Signal_State_name, int32(x))
}
func (Signal_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{1, 0}
}

// Specifies the escalation level of this incident, within the IRM protocol
// for handling incidents.
type Incident_EscalationLevel int32

const (
	// The incident has not been escalated. This is the value used by all new
	// and legacy incidents.
	Incident_ESCALATION_LEVEL_UNSPECIFIED Incident_EscalationLevel = 0
	// The incident has been escalated to the organizational level.
	Incident_ESCALATION_LEVEL_ORGANIZATION Incident_EscalationLevel = 1
)

var Incident_EscalationLevel_name = map[int32]string{
	0: "ESCALATION_LEVEL_UNSPECIFIED",
	1: "ESCALATION_LEVEL_ORGANIZATION",
}
var Incident_EscalationLevel_value = map[string]int32{
	"ESCALATION_LEVEL_UNSPECIFIED":  0,
	"ESCALATION_LEVEL_ORGANIZATION": 1,
}

func (x Incident_EscalationLevel) String() string {
	return proto.EnumName(Incident_EscalationLevel_name, int32(x))
}
func (Incident_EscalationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{5, 0}
}

// Severity of an incident.
type Incident_Severity int32

const (
	// Severity is not specified.
	Incident_SEVERITY_UNSPECIFIED Incident_Severity = 0
	// Huge incident.
	Incident_SEVERITY_HUGE Incident_Severity = 1
	// Major incident.
	Incident_SEVERITY_MAJOR Incident_Severity = 2
	// Medium incident.
	Incident_SEVERITY_MEDIUM Incident_Severity = 3
	// Minor incident.
	Incident_SEVERITY_MINOR Incident_Severity = 4
	// Negligible incident.
	Incident_SEVERITY_NEGLIGIBLE Incident_Severity = 5
)

var Incident_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "SEVERITY_HUGE",
	2: "SEVERITY_MAJOR",
	3: "SEVERITY_MEDIUM",
	4: "SEVERITY_MINOR",
	5: "SEVERITY_NEGLIGIBLE",
}
var Incident_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"SEVERITY_HUGE":        1,
	"SEVERITY_MAJOR":       2,
	"SEVERITY_MEDIUM":      3,
	"SEVERITY_MINOR":       4,
	"SEVERITY_NEGLIGIBLE":  5,
}

func (x Incident_Severity) String() string {
	return proto.EnumName(Incident_Severity_name, int32(x))
}
func (Incident_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{5, 1}
}

// Stage of an incident.
type Incident_Stage int32

const (
	// This is the default value if no stage has been specified.
	// Note: The caller of the API should set the stage to DETECTED.
	Incident_STAGE_UNSPECIFIED Incident_Stage = 0
	// The incident has been detected. This is the initial stage of a new
	// incident.
	// Note: The caller still has to set the stage manually.
	Incident_STAGE_DETECTED Incident_Stage = 4
	// This incident has been formally characterized.
	Incident_STAGE_TRIAGED Incident_Stage = 1
	// This incident has been mitigated, i.e. does not affect the service level
	// anymore.
	Incident_STAGE_MITIGATED Incident_Stage = 2
	// This incident has been fully resolved, i.e. there are no immediate
	// follow-up tasks.
	Incident_STAGE_RESOLVED Incident_Stage = 3
	// Postmortem for the incident was written.
	Incident_STAGE_DOCUMENTED Incident_Stage = 5
)

var Incident_Stage_name = map[int32]string{
	0: "STAGE_UNSPECIFIED",
	4: "STAGE_DETECTED",
	1: "STAGE_TRIAGED",
	2: "STAGE_MITIGATED",
	3: "STAGE_RESOLVED",
	5: "STAGE_DOCUMENTED",
}
var Incident_Stage_value = map[string]int32{
	"STAGE_UNSPECIFIED": 0,
	"STAGE_DETECTED":    4,
	"STAGE_TRIAGED":     1,
	"STAGE_MITIGATED":   2,
	"STAGE_RESOLVED":    3,
	"STAGE_DOCUMENTED":  5,
}

func (x Incident_Stage) String() string {
	return proto.EnumName(Incident_Stage_name, int32(x))
}
func (Incident_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{5, 2}
}

// List of possible roles.
type IncidentRole_Type int32

const (
	// The role is unspecified.
	IncidentRole_TYPE_UNSPECIFIED IncidentRole_Type = 0
	// Incident Commander: Manages response plan, near-term and long-term
	// objectives, establishes priorities, and delegates tasks as needed.
	IncidentRole_TYPE_INCIDENT_COMMANDER IncidentRole_Type = 1
	// Communications Lead: Keeps everybody outside and within the response team
	// informed.
	IncidentRole_TYPE_COMMUNICATIONS_LEAD IncidentRole_Type = 2
	// Operations Lead: Figures out what to do, and gets it done.
	IncidentRole_TYPE_OPERATIONS_LEAD IncidentRole_Type = 3
	// External Customer Communications Lead: Responsible for communicating
	// incident details to customers/public.
	IncidentRole_TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD IncidentRole_Type = 4
	// Primary Oncall: Responds to the initial page and handles all
	// responsibilities for pre-escalated incidents.
	IncidentRole_TYPE_PRIMARY_ONCALL IncidentRole_Type = 5
	// Secondary Oncall: Helps the primary oncall if necessary; mostly useful
	// for pre-escalated incidents.
	IncidentRole_TYPE_SECONDARY_ONCALL IncidentRole_Type = 6
	// User-specified roles. One example is a Planning Lead, who keeps track of
	// the incident. Another is an assistant Incident Commander.
	IncidentRole_TYPE_OTHER IncidentRole_Type = 7
)

var IncidentRole_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_INCIDENT_COMMANDER",
	2: "TYPE_COMMUNICATIONS_LEAD",
	3: "TYPE_OPERATIONS_LEAD",
	4: "TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD",
	5: "TYPE_PRIMARY_ONCALL",
	6: "TYPE_SECONDARY_ONCALL",
	7: "TYPE_OTHER",
}
var IncidentRole_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":                           0,
	"TYPE_INCIDENT_COMMANDER":                    1,
	"TYPE_COMMUNICATIONS_LEAD":                   2,
	"TYPE_OPERATIONS_LEAD":                       3,
	"TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD": 4,
	"TYPE_PRIMARY_ONCALL":                        5,
	"TYPE_SECONDARY_ONCALL":                      6,
	"TYPE_OTHER":                                 7,
}

func (x IncidentRole_Type) String() string {
	return proto.EnumName(IncidentRole_Type_name, int32(x))
}
func (IncidentRole_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{6, 0}
}

// Possible types of an artifact.
type Artifact_Type int32

const (
	// External type is unspecified.
	Artifact_TYPE_UNSPECIFIED Artifact_Type = 0
	// URL.
	Artifact_TYPE_URL Artifact_Type = 1
	// An issue.
	Artifact_TYPE_ISSUE Artifact_Type = 2
	// A source control change.
	Artifact_TYPE_SOURCE_CONTROL_CHANGE Artifact_Type = 3
	// A JIRA issue.
	Artifact_TYPE_JIRA_ISSUE Artifact_Type = 4
)

var Artifact_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_URL",
	2: "TYPE_ISSUE",
	3: "TYPE_SOURCE_CONTROL_CHANGE",
	4: "TYPE_JIRA_ISSUE",
}
var Artifact_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":           0,
	"TYPE_URL":                   1,
	"TYPE_ISSUE":                 2,
	"TYPE_SOURCE_CONTROL_CHANGE": 3,
	"TYPE_JIRA_ISSUE":            4,
}

func (x Artifact_Type) String() string {
	return proto.EnumName(Artifact_Type_name, int32(x))
}
func (Artifact_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{8, 0}
}

// Types of changes that users can subscribe to in an incident.
type Subscription_EventType int32

const (
	// An event_type that's not specified is an error.
	Subscription_EVENT_TYPE_UNSPECIFIED Subscription_EventType = 0
	// The incident's title has changed.
	Subscription_EVENT_TYPE_TITLE_CHANGE Subscription_EventType = 1
	// The incident's synopsis has changed.
	Subscription_EVENT_TYPE_SYNOPSIS_CHANGE Subscription_EventType = 2
	// The incident's stage has changed.
	Subscription_EVENT_TYPE_STAGE_CHANGE Subscription_EventType = 3
	// The incident's severity has changed.
	Subscription_EVENT_TYPE_SEVERITY_CHANGE Subscription_EventType = 4
	// A new annotation has been added to the incident.
	Subscription_EVENT_TYPE_ANNOTATION_ADD Subscription_EventType = 5
	// An annotation has been modified.
	Subscription_EVENT_TYPE_ANNOTATION_CHANGE Subscription_EventType = 6
)

var Subscription_EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNSPECIFIED",
	1: "EVENT_TYPE_TITLE_CHANGE",
	2: "EVENT_TYPE_SYNOPSIS_CHANGE",
	3: "EVENT_TYPE_STAGE_CHANGE",
	4: "EVENT_TYPE_SEVERITY_CHANGE",
	5: "EVENT_TYPE_ANNOTATION_ADD",
	6: "EVENT_TYPE_ANNOTATION_CHANGE",
}
var Subscription_EventType_value = map[string]int32{
	"EVENT_TYPE_UNSPECIFIED":       0,
	"EVENT_TYPE_TITLE_CHANGE":      1,
	"EVENT_TYPE_SYNOPSIS_CHANGE":   2,
	"EVENT_TYPE_STAGE_CHANGE":      3,
	"EVENT_TYPE_SEVERITY_CHANGE":   4,
	"EVENT_TYPE_ANNOTATION_ADD":    5,
	"EVENT_TYPE_ANNOTATION_CHANGE": 6,
}

func (x Subscription_EventType) String() string {
	return proto.EnumName(Subscription_EventType_name, int32(x))
}
func (Subscription_EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{10, 0}
}

// A user of the IRM app.
type User struct {
	// One of several ways to uniquely identify a user.
	//
	// Types that are valid to be assigned to User:
	//	*User_UserId
	//	*User_Email
	User                 isUser_User `protobuf_oneof:"user"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{0}
}
func (m *User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_User.Unmarshal(m, b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_User.Marshal(b, m, deterministic)
}
func (dst *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(dst, src)
}
func (m *User) XXX_Size() int {
	return xxx_messageInfo_User.Size(m)
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

type isUser_User interface {
	isUser_User()
}

type User_UserId struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3,oneof"`
}

type User_Email struct {
	Email string `protobuf:"bytes,2,opt,name=email,proto3,oneof"`
}

func (*User_UserId) isUser_User() {}

func (*User_Email) isUser_User() {}

func (m *User) GetUser() isUser_User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *User) GetUserId() string {
	if x, ok := m.GetUser().(*User_UserId); ok {
		return x.UserId
	}
	return ""
}

func (m *User) GetEmail() string {
	if x, ok := m.GetUser().(*User_Email); ok {
		return x.Email
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*User) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _User_OneofMarshaler, _User_OneofUnmarshaler, _User_OneofSizer, []interface{}{
		(*User_UserId)(nil),
		(*User_Email)(nil),
	}
}

func _User_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*User)
	// user
	switch x := m.User.(type) {
	case *User_UserId:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.UserId)
	case *User_Email:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Email)
	case nil:
	default:
		return fmt.Errorf("User.User has unexpected type %T", x)
	}
	return nil
}

func _User_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*User)
	switch tag {
	case 1: // user.user_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.User = &User_UserId{x}
		return true, err
	case 2: // user.email
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.User = &User_Email{x}
		return true, err
	default:
		return false, nil
	}
}

func _User_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*User)
	// user
	switch x := m.User.(type) {
	case *User_UserId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.UserId)))
		n += len(x.UserId)
	case *User_Email:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Email)))
		n += len(x.Email)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A signal is a message calling attention to a (potential) incident. An example
// is a page based on a Stackdriver Alerting policy.
// go/irm-glossary#signal
type Signal struct {
	// Resource name of the signal, e.g.
	// "projects/{project_id}/signals/{signal_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Resource name of the incident this signal is currently assigned to.
	// May be empty if signal is unassigned.
	Incident string `protobuf:"bytes,3,opt,name=incident,proto3" json:"incident,omitempty"`
	// Output only. Time this signal was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The user that created this signal for manually created
	// signals. Empty if this signal was generated by a system (e.g. an
	// alerting system).
	Creator *User `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// One-line summary of the signal.
	// Immutable.
	Title string `protobuf:"bytes,6,opt,name=title,proto3" json:"title,omitempty"`
	// Content type string, e.g. 'text/plain' or'text/html'.
	ContentType string `protobuf:"bytes,7,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Full message of the signal.
	// Immutable.
	Content string `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
	// Output only. The state of this signal.
	SignalState          Signal_State `protobuf:"varint,9,opt,name=signal_state,json=signalState,proto3,enum=google.cloud.irm.v1alpha2.Signal_State" json:"signal_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Signal) Reset()         { *m = Signal{} }
func (m *Signal) String() string { return proto.CompactTextString(m) }
func (*Signal) ProtoMessage()    {}
func (*Signal) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{1}
}
func (m *Signal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signal.Unmarshal(m, b)
}
func (m *Signal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signal.Marshal(b, m, deterministic)
}
func (dst *Signal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signal.Merge(dst, src)
}
func (m *Signal) XXX_Size() int {
	return xxx_messageInfo_Signal.Size(m)
}
func (m *Signal) XXX_DiscardUnknown() {
	xxx_messageInfo_Signal.DiscardUnknown(m)
}

var xxx_messageInfo_Signal proto.InternalMessageInfo

func (m *Signal) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Signal) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Signal) GetIncident() string {
	if m != nil {
		return m.Incident
	}
	return ""
}

func (m *Signal) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Signal) GetCreator() *User {
	if m != nil {
		return m.Creator
	}
	return nil
}

func (m *Signal) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Signal) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Signal) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Signal) GetSignalState() Signal_State {
	if m != nil {
		return m.SignalState
	}
	return Signal_STATE_UNSPECIFIED
}

// A text annotation by a user.
type Annotation struct {
	// Resource name of the annotation, e.g.
	// "projects/{project_id}/incidents/{incident_id}/annotations/{annotation_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Author of the annotation.
	Author *User `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Output only. Time the annotation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Content of the annotation. Immutable.
	Content              string   `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Annotation) Reset()         { *m = Annotation{} }
func (m *Annotation) String() string { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()    {}
func (*Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{2}
}
func (m *Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Annotation.Unmarshal(m, b)
}
func (m *Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Annotation.Marshal(b, m, deterministic)
}
func (dst *Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Annotation.Merge(dst, src)
}
func (m *Annotation) XXX_Size() int {
	return xxx_messageInfo_Annotation.Size(m)
}
func (m *Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Annotation proto.InternalMessageInfo

func (m *Annotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Annotation) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

func (m *Annotation) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Annotation) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

// A tag by a user.
type Tag struct {
	// Resource name of a tag, e.g.,
	// "projects/{project_id}/incidents/{incident_id}/tags/{tag_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name of the resource (e.g., "cause:rollout"). Immutable.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. For some tags (e.g., "bug:123"), provide a link to the
	// underlying resource. Optional.
	Url                  string   `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{3}
}
func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (dst *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(dst, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tag) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Tag) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Synopsis is a summary of an incident and it contains a textual content,
// an author and a last updated timestamp.
type Synopsis struct {
	// Content type string, e.g. 'text/plain' or 'text/html'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Textual content of the synopsis. It can be plain text or markdown as
	// indicated by the content_type.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Last updated timestamp.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Author of the synopsis.
	Author               *User    `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Synopsis) Reset()         { *m = Synopsis{} }
func (m *Synopsis) String() string { return proto.CompactTextString(m) }
func (*Synopsis) ProtoMessage()    {}
func (*Synopsis) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{4}
}
func (m *Synopsis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Synopsis.Unmarshal(m, b)
}
func (m *Synopsis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Synopsis.Marshal(b, m, deterministic)
}
func (dst *Synopsis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Synopsis.Merge(dst, src)
}
func (m *Synopsis) XXX_Size() int {
	return xxx_messageInfo_Synopsis.Size(m)
}
func (m *Synopsis) XXX_DiscardUnknown() {
	xxx_messageInfo_Synopsis.DiscardUnknown(m)
}

var xxx_messageInfo_Synopsis proto.InternalMessageInfo

func (m *Synopsis) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Synopsis) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Synopsis) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Synopsis) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

// Representation of an incident.
type Incident struct {
	// Output only. Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One-line summary of the incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Escalation level of the incident.
	EscalationLevel Incident_EscalationLevel `protobuf:"varint,3,opt,name=escalation_level,json=escalationLevel,proto3,enum=google.cloud.irm.v1alpha2.Incident_EscalationLevel" json:"escalation_level,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Severity of the incident.
	Severity Incident_Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=google.cloud.irm.v1alpha2.Incident_Severity" json:"severity,omitempty"`
	// Stage of the incident.
	Stage Incident_Stage `protobuf:"varint,6,opt,name=stage,proto3,enum=google.cloud.irm.v1alpha2.Incident_Stage" json:"stage,omitempty"`
	// Output only. Time this incident started. Used to measure the 'elapsed
	// time'. Start time of an incident is the earliest creation time of any of
	// its Signals or the create time of the incident if no Signals are assigned.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Synopsis of this incident.
	Synopsis             *Synopsis `protobuf:"bytes,8,opt,name=synopsis,proto3" json:"synopsis,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Incident) Reset()         { *m = Incident{} }
func (m *Incident) String() string { return proto.CompactTextString(m) }
func (*Incident) ProtoMessage()    {}
func (*Incident) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{5}
}
func (m *Incident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Incident.Unmarshal(m, b)
}
func (m *Incident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Incident.Marshal(b, m, deterministic)
}
func (dst *Incident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Incident.Merge(dst, src)
}
func (m *Incident) XXX_Size() int {
	return xxx_messageInfo_Incident.Size(m)
}
func (m *Incident) XXX_DiscardUnknown() {
	xxx_messageInfo_Incident.DiscardUnknown(m)
}

var xxx_messageInfo_Incident proto.InternalMessageInfo

func (m *Incident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Incident) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Incident) GetEscalationLevel() Incident_EscalationLevel {
	if m != nil {
		return m.EscalationLevel
	}
	return Incident_ESCALATION_LEVEL_UNSPECIFIED
}

func (m *Incident) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Incident) GetSeverity() Incident_Severity {
	if m != nil {
		return m.Severity
	}
	return Incident_SEVERITY_UNSPECIFIED
}

func (m *Incident) GetStage() Incident_Stage {
	if m != nil {
		return m.Stage
	}
	return Incident_STAGE_UNSPECIFIED
}

func (m *Incident) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Incident) GetSynopsis() *Synopsis {
	if m != nil {
		return m.Synopsis
	}
	return nil
}

// Describes a role that can be assigned to an incident.
type IncidentRole struct {
	// The type of role. The role type is immutable in role assignments. Each role
	// type can only be used once per incident, except for TYPE_OTHER.
	Type IncidentRole_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.IncidentRole_Type" json:"type,omitempty"`
	// Output only unless TYPE_OTHER is used. Title of the role. For TYPE_OTHER,
	// must be unique within an incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only unless TYPE_OTHER is used. Description of the role.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRole) Reset()         { *m = IncidentRole{} }
func (m *IncidentRole) String() string { return proto.CompactTextString(m) }
func (*IncidentRole) ProtoMessage()    {}
func (*IncidentRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{6}
}
func (m *IncidentRole) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRole.Unmarshal(m, b)
}
func (m *IncidentRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRole.Marshal(b, m, deterministic)
}
func (dst *IncidentRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRole.Merge(dst, src)
}
func (m *IncidentRole) XXX_Size() int {
	return xxx_messageInfo_IncidentRole.Size(m)
}
func (m *IncidentRole) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRole.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRole proto.InternalMessageInfo

func (m *IncidentRole) GetType() IncidentRole_Type {
	if m != nil {
		return m.Type
	}
	return IncidentRole_TYPE_UNSPECIFIED
}

func (m *IncidentRole) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *IncidentRole) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Stores the assignee of a role as well as the proposed next assignee.
type IncidentRoleAssignment struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/role_assignments/{role_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The role that is or will be assigned.
	Role *IncidentRole `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	// The user this role is assigned to. This field can only be directly set
	// during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	Assignee *User `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// The recipient of a requested role handoff. This field can only be directly
	// set during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	//
	// `assignee` is always the current role-holder, and `proposed_assignee` is
	// used to track unfinished assignments and handoffs. Let's say Bob assigns
	// Alice to a role. Then the fields are:
	//   `assignee`: nil, `proposed_assignee`: Alice
	// If Alice accepts, then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If she cancels, then the RoleAssignment is deleted.
	// Let's say Alice has the role. Then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If Alice is hit by a bus and Bob requests Carol to take over, then the
	// fields are:
	//   `assignee`: Alice, `proposed_assignee`: Carol
	// After Carol accepts the handover, the fields are:
	//   `assignee`: Carol, `proposed_assignee`: nil
	// Or if Carol refuses the handover, the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	ProposedAssignee     *User    `protobuf:"bytes,5,opt,name=proposed_assignee,json=proposedAssignee,proto3" json:"proposed_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRoleAssignment) Reset()         { *m = IncidentRoleAssignment{} }
func (m *IncidentRoleAssignment) String() string { return proto.CompactTextString(m) }
func (*IncidentRoleAssignment) ProtoMessage()    {}
func (*IncidentRoleAssignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{7}
}
func (m *IncidentRoleAssignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRoleAssignment.Unmarshal(m, b)
}
func (m *IncidentRoleAssignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRoleAssignment.Marshal(b, m, deterministic)
}
func (dst *IncidentRoleAssignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRoleAssignment.Merge(dst, src)
}
func (m *IncidentRoleAssignment) XXX_Size() int {
	return xxx_messageInfo_IncidentRoleAssignment.Size(m)
}
func (m *IncidentRoleAssignment) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRoleAssignment.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRoleAssignment proto.InternalMessageInfo

func (m *IncidentRoleAssignment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IncidentRoleAssignment) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *IncidentRoleAssignment) GetRole() *IncidentRole {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *IncidentRoleAssignment) GetAssignee() *User {
	if m != nil {
		return m.Assignee
	}
	return nil
}

func (m *IncidentRoleAssignment) GetProposedAssignee() *User {
	if m != nil {
		return m.ProposedAssignee
	}
	return nil
}

// External artifact associated to an incident.
type Artifact struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/artifacts/{artifact_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided name of an artifact.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// URL to access the artifact.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// Type of this artifact.
	Type                 Artifact_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.Artifact_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Artifact) Reset()         { *m = Artifact{} }
func (m *Artifact) String() string { return proto.CompactTextString(m) }
func (*Artifact) ProtoMessage()    {}
func (*Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{8}
}
func (m *Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifact.Unmarshal(m, b)
}
func (m *Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifact.Marshal(b, m, deterministic)
}
func (dst *Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifact.Merge(dst, src)
}
func (m *Artifact) XXX_Size() int {
	return xxx_messageInfo_Artifact.Size(m)
}
func (m *Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_Artifact proto.InternalMessageInfo

func (m *Artifact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Artifact) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Artifact) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Artifact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Artifact) GetType() Artifact_Type {
	if m != nil {
		return m.Type
	}
	return Artifact_TYPE_UNSPECIFIED
}

// Communication Channels are mechanisms used to receive notifications
// about changes to incidents.
type CommunicationChannel struct {
	// An endpoint describes how messages will be delivered.
	//
	// Types that are valid to be assigned to Endpoint:
	//	*CommunicationChannel_Email_
	//	*CommunicationChannel_NotificationChannel_
	Endpoint             isCommunicationChannel_Endpoint `protobuf_oneof:"endpoint"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CommunicationChannel) Reset()         { *m = CommunicationChannel{} }
func (m *CommunicationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel) ProtoMessage()    {}
func (*CommunicationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{9}
}
func (m *CommunicationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel.Marshal(b, m, deterministic)
}
func (dst *CommunicationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel.Merge(dst, src)
}
func (m *CommunicationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel.Size(m)
}
func (m *CommunicationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel proto.InternalMessageInfo

type isCommunicationChannel_Endpoint interface {
	isCommunicationChannel_Endpoint()
}

type CommunicationChannel_Email_ struct {
	Email *CommunicationChannel_Email `protobuf:"bytes,1,opt,name=email,proto3,oneof"`
}

type CommunicationChannel_NotificationChannel_ struct {
	NotificationChannel *CommunicationChannel_NotificationChannel `protobuf:"bytes,2,opt,name=notification_channel,json=notificationChannel,proto3,oneof"`
}

func (*CommunicationChannel_Email_) isCommunicationChannel_Endpoint() {}

func (*CommunicationChannel_NotificationChannel_) isCommunicationChannel_Endpoint() {}

func (m *CommunicationChannel) GetEndpoint() isCommunicationChannel_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *CommunicationChannel) GetEmail() *CommunicationChannel_Email {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_Email_); ok {
		return x.Email
	}
	return nil
}

func (m *CommunicationChannel) GetNotificationChannel() *CommunicationChannel_NotificationChannel {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_NotificationChannel_); ok {
		return x.NotificationChannel
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommunicationChannel) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommunicationChannel_OneofMarshaler, _CommunicationChannel_OneofUnmarshaler, _CommunicationChannel_OneofSizer, []interface{}{
		(*CommunicationChannel_Email_)(nil),
		(*CommunicationChannel_NotificationChannel_)(nil),
	}
}

func _CommunicationChannel_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommunicationChannel)
	// endpoint
	switch x := m.Endpoint.(type) {
	case *CommunicationChannel_Email_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Email); err != nil {
			return err
		}
	case *CommunicationChannel_NotificationChannel_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.NotificationChannel); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommunicationChannel.Endpoint has unexpected type %T", x)
	}
	return nil
}

func _CommunicationChannel_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommunicationChannel)
	switch tag {
	case 1: // endpoint.email
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CommunicationChannel_Email)
		err := b.DecodeMessage(msg)
		m.Endpoint = &CommunicationChannel_Email_{msg}
		return true, err
	case 2: // endpoint.notification_channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CommunicationChannel_NotificationChannel)
		err := b.DecodeMessage(msg)
		m.Endpoint = &CommunicationChannel_NotificationChannel_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommunicationChannel_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommunicationChannel)
	// endpoint
	switch x := m.Endpoint.(type) {
	case *CommunicationChannel_Email_:
		s := proto.Size(x.Email)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CommunicationChannel_NotificationChannel_:
		s := proto.Size(x.NotificationChannel)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A communication channel that delivers messages to an email address.
type CommunicationChannel_Email struct {
	// The email address, e.g. "user@example.com".
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_Email) Reset()         { *m = CommunicationChannel_Email{} }
func (m *CommunicationChannel_Email) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_Email) ProtoMessage()    {}
func (*CommunicationChannel_Email) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{9, 0}
}
func (m *CommunicationChannel_Email) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_Email.Unmarshal(m, b)
}
func (m *CommunicationChannel_Email) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_Email.Marshal(b, m, deterministic)
}
func (dst *CommunicationChannel_Email) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_Email.Merge(dst, src)
}
func (m *CommunicationChannel_Email) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_Email.Size(m)
}
func (m *CommunicationChannel_Email) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_Email.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_Email proto.InternalMessageInfo

func (m *CommunicationChannel_Email) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// A communication channel that delivers messages to a Stackdriver
// notification channel.
type CommunicationChannel_NotificationChannel struct {
	// Stackdriver notification channel name.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_NotificationChannel) Reset() {
	*m = CommunicationChannel_NotificationChannel{}
}
func (m *CommunicationChannel_NotificationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_NotificationChannel) ProtoMessage()    {}
func (*CommunicationChannel_NotificationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{9, 1}
}
func (m *CommunicationChannel_NotificationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Marshal(b, m, deterministic)
}
func (dst *CommunicationChannel_NotificationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.Merge(dst, src)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Size(m)
}
func (m *CommunicationChannel_NotificationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_NotificationChannel proto.InternalMessageInfo

func (m *CommunicationChannel_NotificationChannel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A subscription allows users to get notifications about changes to
// an incident.
type Subscription struct {
	// Output only. Resource name such as
	// "projects/{project_id}/incidents/{incident_id}/subscriptions/{subscription_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// A communications channel to send subscription messages to.
	SubscriptionChannel *CommunicationChannel `protobuf:"bytes,3,opt,name=subscription_channel,json=subscriptionChannel,proto3" json:"subscription_channel,omitempty"`
	// Types of events this subscription receives notifications for.
	EventTypes           []Subscription_EventType `protobuf:"varint,4,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.cloud.irm.v1alpha2.Subscription_EventType" json:"event_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_8dae886aaab4ae40, []int{10}
}
func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (dst *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(dst, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Subscription) GetSubscriptionChannel() *CommunicationChannel {
	if m != nil {
		return m.SubscriptionChannel
	}
	return nil
}

func (m *Subscription) GetEventTypes() []Subscription_EventType {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

func init() {
	proto.RegisterType((*User)(nil), "google.cloud.irm.v1alpha2.User")
	proto.RegisterType((*Signal)(nil), "google.cloud.irm.v1alpha2.Signal")
	proto.RegisterType((*Annotation)(nil), "google.cloud.irm.v1alpha2.Annotation")
	proto.RegisterType((*Tag)(nil), "google.cloud.irm.v1alpha2.Tag")
	proto.RegisterType((*Synopsis)(nil), "google.cloud.irm.v1alpha2.Synopsis")
	proto.RegisterType((*Incident)(nil), "google.cloud.irm.v1alpha2.Incident")
	proto.RegisterType((*IncidentRole)(nil), "google.cloud.irm.v1alpha2.IncidentRole")
	proto.RegisterType((*IncidentRoleAssignment)(nil), "google.cloud.irm.v1alpha2.IncidentRoleAssignment")
	proto.RegisterType((*Artifact)(nil), "google.cloud.irm.v1alpha2.Artifact")
	proto.RegisterType((*CommunicationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel")
	proto.RegisterType((*CommunicationChannel_Email)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.Email")
	proto.RegisterType((*CommunicationChannel_NotificationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.NotificationChannel")
	proto.RegisterType((*Subscription)(nil), "google.cloud.irm.v1alpha2.Subscription")
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Signal_State", Signal_State_name, Signal_State_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_EscalationLevel", Incident_EscalationLevel_name, Incident_EscalationLevel_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Severity", Incident_Severity_name, Incident_Severity_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Stage", Incident_Stage_name, Incident_Stage_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.IncidentRole_Type", IncidentRole_Type_name, IncidentRole_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Artifact_Type", Artifact_Type_name, Artifact_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Subscription_EventType", Subscription_EventType_name, Subscription_EventType_value)
}

func init() {
	proto.RegisterFile("google/cloud/irm/v1alpha2/incidents.proto", fileDescriptor_incidents_8dae886aaab4ae40)
}

var fileDescriptor_incidents_8dae886aaab4ae40 = []byte{
	// 1463 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x57, 0xcf, 0x6f, 0xdb, 0x46,
	0x16, 0x0e, 0x25, 0x4a, 0x96, 0x9f, 0xbc, 0x0e, 0x33, 0x76, 0x12, 0x59, 0x9b, 0x6c, 0x6c, 0xe6,
	0x10, 0x67, 0xb1, 0xa0, 0x10, 0x05, 0x8b, 0x45, 0xe0, 0x00, 0x09, 0x4d, 0xcd, 0xca, 0x0c, 0x28,
	0xd2, 0x18, 0x52, 0x46, 0x9d, 0x43, 0x09, 0x5a, 0x9a, 0xc8, 0x04, 0x24, 0x92, 0x20, 0x29, 0xa3,
	0xbe, 0xf7, 0xd0, 0x4b, 0xaf, 0x3d, 0xf6, 0xd6, 0x7b, 0xaf, 0x3d, 0xf4, 0xaf, 0xe8, 0x7f, 0x50,
	0xa0, 0xf7, 0x1e, 0x7b, 0x2c, 0x38, 0xfc, 0x11, 0x5a, 0x51, 0x54, 0xb9, 0x37, 0xce, 0x7b, 0xdf,
	0xf7, 0x38, 0xfc, 0xde, 0x8f, 0x19, 0xc2, 0xf3, 0x89, 0xef, 0x4f, 0xa6, 0xb4, 0x33, 0x9a, 0xfa,
	0xf3, 0x71, 0xc7, 0x0d, 0x67, 0x9d, 0xab, 0x17, 0xce, 0x34, 0xb8, 0x74, 0xba, 0x1d, 0xd7, 0x1b,
	0xb9, 0x63, 0xea, 0xc5, 0x91, 0x14, 0x84, 0x7e, 0xec, 0xa3, 0xbd, 0x14, 0x2a, 0x31, 0xa8, 0xe4,
	0x86, 0x33, 0x29, 0x87, 0xb6, 0x1f, 0x65, 0x51, 0x9c, 0xc0, 0xed, 0x38, 0x9e, 0xe7, 0xc7, 0x4e,
	0xec, 0xfa, 0x5e, 0x46, 0x6c, 0xe7, 0xef, 0x98, 0xf9, 0x9e, 0x1b, 0xfb, 0xa1, 0xeb, 0x4d, 0x3a,
	0x57, 0x2f, 0x3b, 0x33, 0x1a, 0x87, 0xee, 0xc8, 0x8e, 0x68, 0x78, 0xe5, 0x8e, 0x68, 0x06, 0x7d,
	0x92, 0x41, 0xd9, 0xea, 0x62, 0xfe, 0xa1, 0x13, 0xbb, 0x33, 0x1a, 0xc5, 0xce, 0x2c, 0x48, 0x01,
	0xa2, 0x0c, 0xfc, 0x30, 0xa2, 0x21, 0xda, 0x83, 0x8d, 0x79, 0x44, 0x43, 0xdb, 0x1d, 0xb7, 0xb8,
	0x7d, 0xee, 0x70, 0xf3, 0xe4, 0x0e, 0xa9, 0x27, 0x06, 0x75, 0x8c, 0x1e, 0x40, 0x8d, 0xce, 0x1c,
	0x77, 0xda, 0xaa, 0x64, 0x8e, 0x74, 0x79, 0x5c, 0x07, 0x3e, 0x41, 0x88, 0x3f, 0x54, 0xa1, 0x6e,
	0xba, 0x13, 0xcf, 0x99, 0x22, 0x04, 0xbc, 0xe7, 0xcc, 0x68, 0x1a, 0x82, 0xb0, 0xe7, 0xc4, 0x46,
	0x63, 0x67, 0x92, 0xb2, 0x09, 0x7b, 0x46, 0x6d, 0x68, 0xe4, 0x6a, 0xb4, 0xaa, 0xcc, 0x5e, 0xac,
	0xd1, 0x11, 0x34, 0x47, 0x21, 0x75, 0x62, 0x6a, 0x27, 0x7b, 0x6d, 0xf1, 0xfb, 0xdc, 0x61, 0xb3,
	0xdb, 0x96, 0x32, 0xb1, 0xf2, 0x0f, 0x91, 0xac, 0xfc, 0x43, 0x08, 0xa4, 0xf0, 0xc4, 0x80, 0x5e,
	0xc1, 0x06, 0x5b, 0xf9, 0x61, 0xab, 0xc6, 0x88, 0x4f, 0xa4, 0xcf, 0xaa, 0x2c, 0x25, 0x1f, 0x4e,
	0x72, 0x3c, 0xda, 0x85, 0x5a, 0xec, 0xc6, 0x53, 0xda, 0xaa, 0xb3, 0x0d, 0xa5, 0x0b, 0x74, 0x00,
	0x5b, 0x23, 0xdf, 0x8b, 0xa9, 0x17, 0xdb, 0xf1, 0x75, 0x40, 0x5b, 0x1b, 0xcc, 0xd9, 0xcc, 0x6c,
	0xd6, 0x75, 0x40, 0x51, 0x0b, 0x36, 0xb2, 0x65, 0xab, 0xc1, 0xbc, 0xf9, 0x12, 0xbd, 0x83, 0xad,
	0x88, 0x09, 0x63, 0x47, 0xb1, 0x13, 0xd3, 0xd6, 0xe6, 0x3e, 0x77, 0xb8, 0xdd, 0x7d, 0xb6, 0x62,
	0x4b, 0xa9, 0x8e, 0x92, 0x99, 0xc0, 0x49, 0x33, 0x25, 0xb3, 0x85, 0xf8, 0x16, 0x6a, 0xec, 0x01,
	0xdd, 0x87, 0x7b, 0xa6, 0x25, 0x5b, 0xd8, 0x1e, 0xea, 0xe6, 0x29, 0x56, 0xd4, 0xff, 0xab, 0xb8,
	0x27, 0xdc, 0x41, 0xdb, 0x00, 0xa9, 0xd9, 0x38, 0xc5, 0xba, 0xc0, 0x21, 0x01, 0xb6, 0xd2, 0xb5,
	0xa2, 0x19, 0x26, 0xee, 0x09, 0x15, 0xf1, 0x47, 0x0e, 0x40, 0x2e, 0x8a, 0x69, 0x69, 0xae, 0xfe,
	0x07, 0x75, 0x67, 0x1e, 0x5f, 0xfa, 0x21, 0xcb, 0xd6, 0x1a, 0xea, 0x65, 0xf0, 0xc5, 0xa4, 0x55,
	0x6f, 0x95, 0xb4, 0x92, 0x80, 0xfc, 0x0d, 0x01, 0x45, 0x1d, 0xaa, 0x96, 0x33, 0x59, 0xba, 0xd5,
	0x03, 0xd8, 0x1a, 0xbb, 0x51, 0x30, 0x75, 0xae, 0x6d, 0xe6, 0x4b, 0xcb, 0xab, 0x99, 0xd9, 0xf4,
	0x04, 0x22, 0x40, 0x75, 0x1e, 0x4e, 0xb3, 0x02, 0x4b, 0x1e, 0xc5, 0x9f, 0x39, 0x68, 0x98, 0xd7,
	0x9e, 0x1f, 0x44, 0x6e, 0xf4, 0x49, 0x6a, 0xb9, 0x95, 0xa9, 0xad, 0xdc, 0x4c, 0xed, 0x11, 0x34,
	0xe7, 0xc1, 0xf8, 0x36, 0x1f, 0x9c, 0xc2, 0xd9, 0x07, 0x7f, 0x94, 0x99, 0xbf, 0x95, 0xcc, 0xe2,
	0xf7, 0x75, 0x68, 0xa8, 0x79, 0xa3, 0x2c, 0x53, 0xa5, 0x28, 0xe2, 0x4a, 0xb9, 0x88, 0xbf, 0x04,
	0x81, 0x46, 0x23, 0x67, 0xca, 0x12, 0x6f, 0x4f, 0xe9, 0x15, 0x4d, 0x55, 0xd9, 0xee, 0xbe, 0x5c,
	0xf1, 0xe6, 0xfc, 0x45, 0x12, 0x2e, 0xb8, 0x5a, 0x42, 0x25, 0x77, 0xe9, 0x4d, 0x43, 0xd1, 0xe2,
	0x7c, 0xa9, 0xc5, 0x4f, 0xa0, 0x11, 0xd1, 0x2b, 0x1a, 0xba, 0xf1, 0x35, 0x6b, 0xc5, 0xed, 0xee,
	0x7f, 0xd6, 0x79, 0x97, 0x99, 0x71, 0x48, 0xc1, 0x46, 0x6f, 0xa0, 0x16, 0xc5, 0xce, 0x24, 0x6d,
	0xcc, 0xed, 0xee, 0xf3, 0xb5, 0xc2, 0x24, 0x04, 0x92, 0xf2, 0xd0, 0x2b, 0x80, 0x28, 0x76, 0xc2,
	0x38, 0x4d, 0xd5, 0xc6, 0x5f, 0xa6, 0x6a, 0x93, 0xa1, 0x59, 0xa6, 0xde, 0x40, 0x23, 0xca, 0xea,
	0x85, 0x35, 0x77, 0xb3, 0xfb, 0x74, 0x55, 0xf7, 0x66, 0x50, 0x52, 0x90, 0xc4, 0x33, 0xb8, 0xbb,
	0x20, 0x1f, 0xda, 0x87, 0x47, 0xd8, 0x54, 0x64, 0x4d, 0xb6, 0x54, 0x43, 0xb7, 0x35, 0x7c, 0x86,
	0xb5, 0x85, 0x5e, 0x3e, 0x80, 0xc7, 0x9f, 0x20, 0x0c, 0xd2, 0x97, 0x75, 0xf5, 0x3d, 0x33, 0x09,
	0x9c, 0xf8, 0x6d, 0x52, 0xc9, 0xb9, 0x42, 0x2d, 0xd8, 0x35, 0xf1, 0x19, 0x26, 0xaa, 0x75, 0xbe,
	0x10, 0xe9, 0x1e, 0xfc, 0xa3, 0xf0, 0x9c, 0x0c, 0xfb, 0x58, 0xe0, 0x10, 0x82, 0xed, 0xc2, 0x34,
	0x90, 0xdf, 0x19, 0x44, 0xa8, 0xa0, 0x1d, 0xb8, 0xfb, 0xd1, 0x86, 0x7b, 0xea, 0x70, 0x20, 0x54,
	0x6f, 0x02, 0x55, 0xdd, 0x20, 0x02, 0x8f, 0x1e, 0xc2, 0x4e, 0x61, 0xd3, 0x71, 0x5f, 0x53, 0xfb,
	0xea, 0xb1, 0x86, 0x85, 0x9a, 0xf8, 0x35, 0xc7, 0xe6, 0xd3, 0x24, 0x9f, 0x4f, 0xfd, 0xc5, 0xf9,
	0x94, 0x44, 0x63, 0xe6, 0x1e, 0xb6, 0xb0, 0x62, 0xe1, 0x9e, 0xc0, 0xb3, 0xdd, 0x31, 0x9b, 0x45,
	0x54, 0xb9, 0x8f, 0x7b, 0x02, 0xc7, 0x76, 0xc2, 0x4c, 0x03, 0xd5, 0x52, 0xfb, 0x72, 0x82, 0xab,
	0x7c, 0xe4, 0x12, 0x6c, 0x1a, 0xda, 0x19, 0xee, 0x09, 0x55, 0xb4, 0x0b, 0x42, 0x16, 0xcf, 0x50,
	0x86, 0x03, 0xac, 0x27, 0xc8, 0x9a, 0xf8, 0x7b, 0x05, 0xb6, 0xf2, 0x22, 0x20, 0xfe, 0x94, 0xa2,
	0xb7, 0xc0, 0x17, 0xcd, 0xbd, 0x5e, 0x09, 0x26, 0x34, 0x29, 0xe9, 0x7e, 0xc2, 0x98, 0x9f, 0x69,
	0xa9, 0x7d, 0x68, 0x8e, 0x69, 0x34, 0x0a, 0xdd, 0x20, 0x49, 0x6c, 0x36, 0x63, 0xca, 0x26, 0xf1,
	0x37, 0x0e, 0x78, 0x2b, 0x0d, 0x20, 0x58, 0xe7, 0xa7, 0x8b, 0x7a, 0xfc, 0x13, 0x1e, 0x32, 0xab,
	0xaa, 0x2b, 0x6a, 0x0f, 0xeb, 0x96, 0xad, 0x18, 0x83, 0x81, 0xac, 0xf7, 0x30, 0x11, 0x38, 0xf4,
	0x08, 0x5a, 0xcc, 0x99, 0xd8, 0x86, 0xba, 0xaa, 0xb0, 0xac, 0x9b, 0xb6, 0x86, 0xe5, 0x44, 0x8e,
	0x16, 0xec, 0x32, 0xaf, 0x71, 0x8a, 0x49, 0xd9, 0x53, 0x45, 0x12, 0xfc, 0x9b, 0x79, 0xf0, 0x17,
	0x16, 0x26, 0xba, 0xac, 0xd9, 0xca, 0xd0, 0xb4, 0x8c, 0x01, 0x26, 0x4b, 0x23, 0xb1, 0x74, 0x32,
	0xfc, 0x29, 0x51, 0x07, 0x32, 0x39, 0xb7, 0x0d, 0x5d, 0x91, 0x35, 0x4d, 0xa8, 0xa1, 0x3d, 0xb8,
	0xcf, 0x1c, 0x26, 0x56, 0x0c, 0xbd, 0x57, 0x72, 0xd5, 0x93, 0x83, 0x26, 0x7d, 0xbb, 0x75, 0x82,
	0x89, 0xb0, 0x21, 0x7e, 0x53, 0x81, 0x07, 0x65, 0xed, 0xe4, 0x28, 0x39, 0xb6, 0x66, 0x9f, 0x9b,
	0x50, 0xcb, 0xae, 0x03, 0x47, 0xc0, 0x87, 0xfe, 0x34, 0x9f, 0xa2, 0xcf, 0xd6, 0x4c, 0x12, 0x61,
	0x24, 0x74, 0x04, 0x0d, 0x87, 0xbd, 0x92, 0xd2, 0x75, 0xc7, 0x69, 0x41, 0x40, 0x1a, 0xdc, 0x0b,
	0x42, 0x3f, 0xf0, 0x23, 0x3a, 0xb6, 0x8b, 0x28, 0x6b, 0xde, 0x1c, 0x84, 0x9c, 0x29, 0x67, 0x44,
	0xf1, 0xbb, 0x0a, 0x34, 0xe4, 0x30, 0x76, 0x3f, 0x38, 0xa3, 0xf8, 0xef, 0x1e, 0x5a, 0xb9, 0x3e,
	0xd5, 0x92, 0x3e, 0xd9, 0x41, 0xc6, 0x17, 0x07, 0x19, 0x7a, 0x9d, 0x95, 0x75, 0x3a, 0x59, 0x0f,
	0x57, 0x6c, 0x35, 0xdf, 0x4f, 0xa9, 0xa4, 0x45, 0x7f, 0x65, 0x65, 0x6e, 0x41, 0x23, 0xb5, 0x12,
	0x4d, 0xe0, 0x8a, 0x74, 0xab, 0xa6, 0x39, 0xc4, 0x42, 0x05, 0xfd, 0x0b, 0xda, 0x69, 0x65, 0x18,
	0x43, 0xa2, 0x24, 0x15, 0xaa, 0x5b, 0xc4, 0xd0, 0x6c, 0xe5, 0x44, 0xd6, 0xfb, 0x58, 0xa8, 0x26,
	0x0d, 0xcc, 0xfc, 0xef, 0x54, 0x22, 0x67, 0x24, 0x5e, 0xfc, 0xa9, 0x02, 0xbb, 0x8a, 0x3f, 0x9b,
	0xcd, 0x3d, 0x77, 0xc4, 0x26, 0xa1, 0x72, 0xe9, 0x78, 0x1e, 0x9d, 0xa2, 0x41, 0x7e, 0xb7, 0xe4,
	0x98, 0xe6, 0xff, 0x5d, 0xf1, 0x21, 0xcb, 0xf8, 0x12, 0x4e, 0xc8, 0xc5, 0x95, 0x14, 0x7d, 0x05,
	0xbb, 0x9e, 0x1f, 0xbb, 0x1f, 0x32, 0x94, 0x3d, 0x4a, 0x61, 0xd9, 0x6d, 0x46, 0xb9, 0x6d, 0x74,
	0xbd, 0x14, 0x2b, 0xb3, 0x9d, 0xdc, 0x21, 0x3b, 0xde, 0xa7, 0xe6, 0xf6, 0x01, 0xd4, 0xd8, 0x5e,
	0x92, 0x2b, 0x83, 0x33, 0x1e, 0x87, 0x34, 0x8a, 0xb2, 0xcc, 0xe7, 0xcb, 0xf6, 0x73, 0xd8, 0x59,
	0x12, 0x70, 0x59, 0x9d, 0x1c, 0x03, 0x34, 0xa8, 0x37, 0x0e, 0x7c, 0xd7, 0x8b, 0xc5, 0x5f, 0xaa,
	0xb0, 0x65, 0xce, 0x2f, 0x8a, 0xc1, 0xb2, 0x76, 0x57, 0x5d, 0xc0, 0x6e, 0x54, 0xe2, 0x15, 0x62,
	0xa4, 0x5d, 0xd6, 0xb9, 0xa5, 0x18, 0x64, 0xa7, 0x1c, 0x2c, 0xdf, 0x3c, 0x81, 0x26, 0xbd, 0xca,
	0x6f, 0x50, 0x51, 0x8b, 0xdf, 0xaf, 0x1e, 0x6e, 0x77, 0x5f, 0xac, 0x3a, 0x22, 0x4b, 0x41, 0x24,
	0x7c, 0x95, 0x5d, 0xb4, 0x08, 0xd0, 0xfc, 0x31, 0x12, 0x7f, 0xe5, 0x60, 0xb3, 0xf0, 0xa0, 0x36,
	0x3c, 0xc0, 0x67, 0xc9, 0x7c, 0x5c, 0x3e, 0x43, 0x4b, 0x3e, 0x4b, 0xb5, 0x34, 0x9c, 0x17, 0x22,
	0x97, 0x14, 0x6a, 0xc9, 0x69, 0x9e, 0xeb, 0xc6, 0xa9, 0xa9, 0x9a, 0xb9, 0xbf, 0xb2, 0x40, 0x4e,
	0xcf, 0x92, 0xa2, 0x8a, 0x17, 0xc8, 0xf9, 0x91, 0x97, 0xf9, 0x79, 0xf4, 0x18, 0xf6, 0x4a, 0x7e,
	0x59, 0xd7, 0x0d, 0x2b, 0x3d, 0xac, 0xe5, 0x5e, 0x4f, 0xa8, 0xb1, 0x23, 0x7e, 0xa9, 0x3b, 0x0b,
	0x50, 0x3f, 0xbe, 0x84, 0xa7, 0x23, 0x7f, 0x96, 0x0b, 0x95, 0x48, 0x94, 0xff, 0xb8, 0x15, 0x52,
	0x39, 0x81, 0x7b, 0xca, 0xbd, 0x7f, 0x9d, 0x41, 0x26, 0xfe, 0xd4, 0xf1, 0x26, 0x92, 0x1f, 0x4e,
	0x3a, 0x13, 0xea, 0xb1, 0x5b, 0x4b, 0x27, 0x75, 0x39, 0x81, 0x1b, 0x2d, 0xf9, 0xdf, 0x3c, 0x72,
	0xc3, 0xd9, 0x1f, 0x1c, 0x77, 0x51, 0x67, 0xd8, 0x97, 0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0x64,
	0x26, 0xa2, 0xbe, 0x9a, 0x0e, 0x00, 0x00,
}
