// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/irm/v1alpha2/incidents_service.proto

package irm // import "google.golang.org/genproto/googleapis/cloud/irm/v1alpha2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request for the CreateIncident method.
type CreateIncidentRequest struct {
	// The incident to create.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// The resource name of the hosting Stackdriver project which the incident
	// belongs to.
	// The name is of the form `projects/{project_id_or_number}`
	// .
	Parent               string   `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateIncidentRequest) Reset()         { *m = CreateIncidentRequest{} }
func (m *CreateIncidentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIncidentRequest) ProtoMessage()    {}
func (*CreateIncidentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{0}
}
func (m *CreateIncidentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIncidentRequest.Unmarshal(m, b)
}
func (m *CreateIncidentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIncidentRequest.Marshal(b, m, deterministic)
}
func (dst *CreateIncidentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIncidentRequest.Merge(dst, src)
}
func (m *CreateIncidentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIncidentRequest.Size(m)
}
func (m *CreateIncidentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIncidentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIncidentRequest proto.InternalMessageInfo

func (m *CreateIncidentRequest) GetIncident() *Incident {
	if m != nil {
		return m.Incident
	}
	return nil
}

func (m *CreateIncidentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Request for the GetIncident method.
type GetIncidentRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetIncidentRequest) Reset()         { *m = GetIncidentRequest{} }
func (m *GetIncidentRequest) String() string { return proto.CompactTextString(m) }
func (*GetIncidentRequest) ProtoMessage()    {}
func (*GetIncidentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{1}
}
func (m *GetIncidentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIncidentRequest.Unmarshal(m, b)
}
func (m *GetIncidentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIncidentRequest.Marshal(b, m, deterministic)
}
func (dst *GetIncidentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIncidentRequest.Merge(dst, src)
}
func (m *GetIncidentRequest) XXX_Size() int {
	return xxx_messageInfo_GetIncidentRequest.Size(m)
}
func (m *GetIncidentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIncidentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIncidentRequest proto.InternalMessageInfo

func (m *GetIncidentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the UpdateIncident method.
type UpdateIncidentRequest struct {
	// The incident to update with the new values.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// List of fields that should be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateIncidentRequest) Reset()         { *m = UpdateIncidentRequest{} }
func (m *UpdateIncidentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateIncidentRequest) ProtoMessage()    {}
func (*UpdateIncidentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{2}
}
func (m *UpdateIncidentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateIncidentRequest.Unmarshal(m, b)
}
func (m *UpdateIncidentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateIncidentRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateIncidentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateIncidentRequest.Merge(dst, src)
}
func (m *UpdateIncidentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateIncidentRequest.Size(m)
}
func (m *UpdateIncidentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateIncidentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateIncidentRequest proto.InternalMessageInfo

func (m *UpdateIncidentRequest) GetIncident() *Incident {
	if m != nil {
		return m.Incident
	}
	return nil
}

func (m *UpdateIncidentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the SearchSimilarIncidents method.
type SearchSimilarIncidentsRequest struct {
	// Resource name of the incident or signal, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Number of similar incidents to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in 'next_page_token'.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchSimilarIncidentsRequest) Reset()         { *m = SearchSimilarIncidentsRequest{} }
func (m *SearchSimilarIncidentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchSimilarIncidentsRequest) ProtoMessage()    {}
func (*SearchSimilarIncidentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{3}
}
func (m *SearchSimilarIncidentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchSimilarIncidentsRequest.Unmarshal(m, b)
}
func (m *SearchSimilarIncidentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchSimilarIncidentsRequest.Marshal(b, m, deterministic)
}
func (dst *SearchSimilarIncidentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchSimilarIncidentsRequest.Merge(dst, src)
}
func (m *SearchSimilarIncidentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchSimilarIncidentsRequest.Size(m)
}
func (m *SearchSimilarIncidentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchSimilarIncidentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchSimilarIncidentsRequest proto.InternalMessageInfo

func (m *SearchSimilarIncidentsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SearchSimilarIncidentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchSimilarIncidentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the SearchSimilarIncidents method.
type SearchSimilarIncidentsResponse struct {
	// The search results, ordered by descending relevance.
	Results []*SearchSimilarIncidentsResponse_Result `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Page token to fetch the next set of similar incidents.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchSimilarIncidentsResponse) Reset()         { *m = SearchSimilarIncidentsResponse{} }
func (m *SearchSimilarIncidentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchSimilarIncidentsResponse) ProtoMessage()    {}
func (*SearchSimilarIncidentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{4}
}
func (m *SearchSimilarIncidentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchSimilarIncidentsResponse.Unmarshal(m, b)
}
func (m *SearchSimilarIncidentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchSimilarIncidentsResponse.Marshal(b, m, deterministic)
}
func (dst *SearchSimilarIncidentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchSimilarIncidentsResponse.Merge(dst, src)
}
func (m *SearchSimilarIncidentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchSimilarIncidentsResponse.Size(m)
}
func (m *SearchSimilarIncidentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchSimilarIncidentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchSimilarIncidentsResponse proto.InternalMessageInfo

func (m *SearchSimilarIncidentsResponse) GetResults() []*SearchSimilarIncidentsResponse_Result {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *SearchSimilarIncidentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A single search result, i.e. an incident with (potentially) additional
// information.
type SearchSimilarIncidentsResponse_Result struct {
	// An incident that is "similar" to the incident or signal specified in the
	// request.
	Incident             *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *SearchSimilarIncidentsResponse_Result) Reset()         { *m = SearchSimilarIncidentsResponse_Result{} }
func (m *SearchSimilarIncidentsResponse_Result) String() string { return proto.CompactTextString(m) }
func (*SearchSimilarIncidentsResponse_Result) ProtoMessage()    {}
func (*SearchSimilarIncidentsResponse_Result) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{4, 0}
}
func (m *SearchSimilarIncidentsResponse_Result) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchSimilarIncidentsResponse_Result.Unmarshal(m, b)
}
func (m *SearchSimilarIncidentsResponse_Result) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchSimilarIncidentsResponse_Result.Marshal(b, m, deterministic)
}
func (dst *SearchSimilarIncidentsResponse_Result) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchSimilarIncidentsResponse_Result.Merge(dst, src)
}
func (m *SearchSimilarIncidentsResponse_Result) XXX_Size() int {
	return xxx_messageInfo_SearchSimilarIncidentsResponse_Result.Size(m)
}
func (m *SearchSimilarIncidentsResponse_Result) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchSimilarIncidentsResponse_Result.DiscardUnknown(m)
}

var xxx_messageInfo_SearchSimilarIncidentsResponse_Result proto.InternalMessageInfo

func (m *SearchSimilarIncidentsResponse_Result) GetIncident() *Incident {
	if m != nil {
		return m.Incident
	}
	return nil
}

// Request for the CreateAnnotation method.
type CreateAnnotationRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Only annotation.content is an input argument.
	Annotation           *Annotation `protobuf:"bytes,2,opt,name=annotation,proto3" json:"annotation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CreateAnnotationRequest) Reset()         { *m = CreateAnnotationRequest{} }
func (m *CreateAnnotationRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAnnotationRequest) ProtoMessage()    {}
func (*CreateAnnotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{5}
}
func (m *CreateAnnotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAnnotationRequest.Unmarshal(m, b)
}
func (m *CreateAnnotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAnnotationRequest.Marshal(b, m, deterministic)
}
func (dst *CreateAnnotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAnnotationRequest.Merge(dst, src)
}
func (m *CreateAnnotationRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAnnotationRequest.Size(m)
}
func (m *CreateAnnotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAnnotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAnnotationRequest proto.InternalMessageInfo

func (m *CreateAnnotationRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAnnotationRequest) GetAnnotation() *Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

// Request for the ListAnnotations method.
type ListAnnotationsRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of annotations to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationsRequest) Reset()         { *m = ListAnnotationsRequest{} }
func (m *ListAnnotationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationsRequest) ProtoMessage()    {}
func (*ListAnnotationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{6}
}
func (m *ListAnnotationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationsRequest.Unmarshal(m, b)
}
func (m *ListAnnotationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationsRequest.Marshal(b, m, deterministic)
}
func (dst *ListAnnotationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationsRequest.Merge(dst, src)
}
func (m *ListAnnotationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationsRequest.Size(m)
}
func (m *ListAnnotationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationsRequest proto.InternalMessageInfo

func (m *ListAnnotationsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAnnotationsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAnnotationsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListAnnotations method.
type ListAnnotationsResponse struct {
	// List of annotations.
	Annotations []*Annotation `protobuf:"bytes,1,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// Page token to fetch the next set of annotations.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAnnotationsResponse) Reset()         { *m = ListAnnotationsResponse{} }
func (m *ListAnnotationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAnnotationsResponse) ProtoMessage()    {}
func (*ListAnnotationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{7}
}
func (m *ListAnnotationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAnnotationsResponse.Unmarshal(m, b)
}
func (m *ListAnnotationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAnnotationsResponse.Marshal(b, m, deterministic)
}
func (dst *ListAnnotationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAnnotationsResponse.Merge(dst, src)
}
func (m *ListAnnotationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAnnotationsResponse.Size(m)
}
func (m *ListAnnotationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAnnotationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAnnotationsResponse proto.InternalMessageInfo

func (m *ListAnnotationsResponse) GetAnnotations() []*Annotation {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func (m *ListAnnotationsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the CreateTag method.
type CreateTagRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Tag to create. Only tag.display_name is an input argument.
	Tag                  *Tag     `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTagRequest) Reset()         { *m = CreateTagRequest{} }
func (m *CreateTagRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTagRequest) ProtoMessage()    {}
func (*CreateTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{8}
}
func (m *CreateTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTagRequest.Unmarshal(m, b)
}
func (m *CreateTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTagRequest.Marshal(b, m, deterministic)
}
func (dst *CreateTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTagRequest.Merge(dst, src)
}
func (m *CreateTagRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTagRequest.Size(m)
}
func (m *CreateTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTagRequest proto.InternalMessageInfo

func (m *CreateTagRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTagRequest) GetTag() *Tag {
	if m != nil {
		return m.Tag
	}
	return nil
}

// Request for the DeleteTag method.
type DeleteTagRequest struct {
	// Resource name of the tag.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTagRequest) Reset()         { *m = DeleteTagRequest{} }
func (m *DeleteTagRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTagRequest) ProtoMessage()    {}
func (*DeleteTagRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{9}
}
func (m *DeleteTagRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTagRequest.Unmarshal(m, b)
}
func (m *DeleteTagRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTagRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteTagRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTagRequest.Merge(dst, src)
}
func (m *DeleteTagRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTagRequest.Size(m)
}
func (m *DeleteTagRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTagRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTagRequest proto.InternalMessageInfo

func (m *DeleteTagRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the ListTagsForIncident method.
type ListTagsRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of tags to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsRequest) Reset()         { *m = ListTagsRequest{} }
func (m *ListTagsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTagsRequest) ProtoMessage()    {}
func (*ListTagsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{10}
}
func (m *ListTagsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsRequest.Unmarshal(m, b)
}
func (m *ListTagsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsRequest.Marshal(b, m, deterministic)
}
func (dst *ListTagsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsRequest.Merge(dst, src)
}
func (m *ListTagsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTagsRequest.Size(m)
}
func (m *ListTagsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsRequest proto.InternalMessageInfo

func (m *ListTagsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTagsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTagsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListTagsForIncident method.
type ListTagsResponse struct {
	// Tags.
	Tags []*Tag `protobuf:"bytes,1,rep,name=tags,proto3" json:"tags,omitempty"`
	// Page token to fetch the next set of tags.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTagsResponse) Reset()         { *m = ListTagsResponse{} }
func (m *ListTagsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTagsResponse) ProtoMessage()    {}
func (*ListTagsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{11}
}
func (m *ListTagsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTagsResponse.Unmarshal(m, b)
}
func (m *ListTagsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTagsResponse.Marshal(b, m, deterministic)
}
func (dst *ListTagsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTagsResponse.Merge(dst, src)
}
func (m *ListTagsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTagsResponse.Size(m)
}
func (m *ListTagsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTagsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTagsResponse proto.InternalMessageInfo

func (m *ListTagsResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *ListTagsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the UpdateAnnotation method.
type UpdateAnnotationRequest struct {
	// The annotation to update with the new values.
	Annotation *Annotation `protobuf:"bytes,1,opt,name=annotation,proto3" json:"annotation,omitempty"`
	// List of fields that should be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateAnnotationRequest) Reset()         { *m = UpdateAnnotationRequest{} }
func (m *UpdateAnnotationRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAnnotationRequest) ProtoMessage()    {}
func (*UpdateAnnotationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{12}
}
func (m *UpdateAnnotationRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAnnotationRequest.Unmarshal(m, b)
}
func (m *UpdateAnnotationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAnnotationRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateAnnotationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAnnotationRequest.Merge(dst, src)
}
func (m *UpdateAnnotationRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAnnotationRequest.Size(m)
}
func (m *UpdateAnnotationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAnnotationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAnnotationRequest proto.InternalMessageInfo

func (m *UpdateAnnotationRequest) GetAnnotation() *Annotation {
	if m != nil {
		return m.Annotation
	}
	return nil
}

func (m *UpdateAnnotationRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the CreateSignal method.
type CreateSignalRequest struct {
	// The resource name of the hosting Stackdriver project which requested
	// signal belongs to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The signal to create.
	Signal               *Signal  `protobuf:"bytes,2,opt,name=signal,proto3" json:"signal,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSignalRequest) Reset()         { *m = CreateSignalRequest{} }
func (m *CreateSignalRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSignalRequest) ProtoMessage()    {}
func (*CreateSignalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{13}
}
func (m *CreateSignalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSignalRequest.Unmarshal(m, b)
}
func (m *CreateSignalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSignalRequest.Marshal(b, m, deterministic)
}
func (dst *CreateSignalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSignalRequest.Merge(dst, src)
}
func (m *CreateSignalRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSignalRequest.Size(m)
}
func (m *CreateSignalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSignalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSignalRequest proto.InternalMessageInfo

func (m *CreateSignalRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSignalRequest) GetSignal() *Signal {
	if m != nil {
		return m.Signal
	}
	return nil
}

// Request for the ListSignals method.
type ListSignalsRequest struct {
	// The resource name of the hosting Stackdriver project which requested
	// incidents belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Filter to specify which signals should be returned.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Maximum number of `signals` to return in the response.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`. All
	// field values except for page_size and page_token should be the same as the
	// original query (may return an error or unexpected data otherwise).
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSignalsRequest) Reset()         { *m = ListSignalsRequest{} }
func (m *ListSignalsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSignalsRequest) ProtoMessage()    {}
func (*ListSignalsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{14}
}
func (m *ListSignalsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSignalsRequest.Unmarshal(m, b)
}
func (m *ListSignalsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSignalsRequest.Marshal(b, m, deterministic)
}
func (dst *ListSignalsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSignalsRequest.Merge(dst, src)
}
func (m *ListSignalsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSignalsRequest.Size(m)
}
func (m *ListSignalsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSignalsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSignalsRequest proto.InternalMessageInfo

func (m *ListSignalsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSignalsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListSignalsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSignalsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListSignals method.
type ListSignalsResponse struct {
	// List of signals that have not been moved into an incident yet.
	Signals []*Signal `protobuf:"bytes,1,rep,name=signals,proto3" json:"signals,omitempty"`
	// Page token to fetch the next set of signals.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSignalsResponse) Reset()         { *m = ListSignalsResponse{} }
func (m *ListSignalsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSignalsResponse) ProtoMessage()    {}
func (*ListSignalsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{15}
}
func (m *ListSignalsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSignalsResponse.Unmarshal(m, b)
}
func (m *ListSignalsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSignalsResponse.Marshal(b, m, deterministic)
}
func (dst *ListSignalsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSignalsResponse.Merge(dst, src)
}
func (m *ListSignalsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSignalsResponse.Size(m)
}
func (m *ListSignalsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSignalsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSignalsResponse proto.InternalMessageInfo

func (m *ListSignalsResponse) GetSignals() []*Signal {
	if m != nil {
		return m.Signals
	}
	return nil
}

func (m *ListSignalsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the GetSignal method.
type GetSignalRequest struct {
	// Resource name of the Signal resource, e.g.
	// "projects/{project_id}/signals/{signal_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSignalRequest) Reset()         { *m = GetSignalRequest{} }
func (m *GetSignalRequest) String() string { return proto.CompactTextString(m) }
func (*GetSignalRequest) ProtoMessage()    {}
func (*GetSignalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{16}
}
func (m *GetSignalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSignalRequest.Unmarshal(m, b)
}
func (m *GetSignalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSignalRequest.Marshal(b, m, deterministic)
}
func (dst *GetSignalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSignalRequest.Merge(dst, src)
}
func (m *GetSignalRequest) XXX_Size() int {
	return xxx_messageInfo_GetSignalRequest.Size(m)
}
func (m *GetSignalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSignalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSignalRequest proto.InternalMessageInfo

func (m *GetSignalRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for the UpdateSignal method.
type UpdateSignalRequest struct {
	// The signal to update with the new values.
	Signal *Signal `protobuf:"bytes,1,opt,name=signal,proto3" json:"signal,omitempty"`
	// List of fields that should be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSignalRequest) Reset()         { *m = UpdateSignalRequest{} }
func (m *UpdateSignalRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSignalRequest) ProtoMessage()    {}
func (*UpdateSignalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{17}
}
func (m *UpdateSignalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSignalRequest.Unmarshal(m, b)
}
func (m *UpdateSignalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSignalRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateSignalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSignalRequest.Merge(dst, src)
}
func (m *UpdateSignalRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSignalRequest.Size(m)
}
func (m *UpdateSignalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSignalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSignalRequest proto.InternalMessageInfo

func (m *UpdateSignalRequest) GetSignal() *Signal {
	if m != nil {
		return m.Signal
	}
	return nil
}

func (m *UpdateSignalRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for the AcknowledgeSignal method.
type AcknowledgeSignalRequest struct {
	// Resource name of the Signal resource, e.g.
	// "projects/{project_id}/signals/{signal_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcknowledgeSignalRequest) Reset()         { *m = AcknowledgeSignalRequest{} }
func (m *AcknowledgeSignalRequest) String() string { return proto.CompactTextString(m) }
func (*AcknowledgeSignalRequest) ProtoMessage()    {}
func (*AcknowledgeSignalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{18}
}
func (m *AcknowledgeSignalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcknowledgeSignalRequest.Unmarshal(m, b)
}
func (m *AcknowledgeSignalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcknowledgeSignalRequest.Marshal(b, m, deterministic)
}
func (dst *AcknowledgeSignalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcknowledgeSignalRequest.Merge(dst, src)
}
func (m *AcknowledgeSignalRequest) XXX_Size() int {
	return xxx_messageInfo_AcknowledgeSignalRequest.Size(m)
}
func (m *AcknowledgeSignalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AcknowledgeSignalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AcknowledgeSignalRequest proto.InternalMessageInfo

func (m *AcknowledgeSignalRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response of the AcknowledgeSignal method.
type AcknowledgeSignalResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AcknowledgeSignalResponse) Reset()         { *m = AcknowledgeSignalResponse{} }
func (m *AcknowledgeSignalResponse) String() string { return proto.CompactTextString(m) }
func (*AcknowledgeSignalResponse) ProtoMessage()    {}
func (*AcknowledgeSignalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{19}
}
func (m *AcknowledgeSignalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AcknowledgeSignalResponse.Unmarshal(m, b)
}
func (m *AcknowledgeSignalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AcknowledgeSignalResponse.Marshal(b, m, deterministic)
}
func (dst *AcknowledgeSignalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AcknowledgeSignalResponse.Merge(dst, src)
}
func (m *AcknowledgeSignalResponse) XXX_Size() int {
	return xxx_messageInfo_AcknowledgeSignalResponse.Size(m)
}
func (m *AcknowledgeSignalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AcknowledgeSignalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AcknowledgeSignalResponse proto.InternalMessageInfo

// Request for the SearchIncidents method.
type SearchIncidentsRequest struct {
	// The resource name of the hosting Stackdriver project which requested
	// incidents belong to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that defines which incidents to return.
	//
	// Search atoms can be used to match certain specific fields.  Otherwise,
	// plain text will match text fields in the incident.
	//
	// Search atoms:
	// * `start` - (timestamp) The time the incident started.
	// * `stage` - The stage of the incident, one of detected, triaged, mitigated,
	//   resolved, documented, or duplicate (which correspond to values in the
	//   Incident.Stage enum). These are ordered, so `stage<resolved` is
	//   equivalent to `stage:detected OR stage:triaged OR stage:mitigated`.
	// * `severity` - (Incident.Severity) The severity of the incident.
	//    + Supports matching on a specific severity (e.g., `severity:major`) or
	//      on a range (e.g., `severity>medium`, `severity<=minor`, etc.).
	//
	// Timestamp formats:
	// * yyyy-MM-dd - an absolute date, treated as a calendar-day-wide window.
	//   In other words, the "<" operator will match dates before that date, the
	//   ">" operator will match dates after that date, and the ":" or "="
	//   operators will match the entire day.
	// * Nd (e.g. 7d) - a relative number of days ago, treated as a moment in time
	//   (as opposed to a day-wide span) a multiple of 24 hours ago (as opposed to
	//   calendar days).  In the case of daylight savings time, it will apply the
	//   current timezone to both ends of the range.  Note that exact matching
	//   (e.g. `start:7d`) is unlikely to be useful because that would only match
	//   incidents created precisely at a particular instant in time.
	//
	// Examples:
	//
	// * `foo` - matches incidents containing the word "foo"
	// * `"foo bar"` - matches incidents containing the phrase "foo bar"
	// * `foo bar` or `foo AND bar` - matches incidents containing the words "foo"
	//   and "bar"
	// * `foo -bar` or `foo AND NOT bar` - matches incidents containing the word
	//   "foo" but not the word "bar"
	// * `foo OR bar` - matches incidents containing the word "foo" or the word
	//   "bar"
	// * `start>2018-11-28` - matches incidents which started after November 11,
	//   2018.
	// * `start<=2018-11-28` - matches incidents which started on or before
	//   November 11, 2018.
	// * `start:2018-11-28` - matches incidents which started on November 11,
	//   2018.
	// * `start>7d` - matches incidents which started after the point in time 7*24
	//   hours ago
	// * `start>180d` - similar to 7d, but likely to cross the daylight savings
	//   time boundary, so the end time will be 1 hour different from "now."
	// * `foo AND start>90d AND stage<resolved` - unresolved incidents from the
	//   past 90 days containing the word "foo"
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Number of incidents to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The time zone name. It should be an IANA TZ name, such as
	// "America/Los_Angeles". For more information,
	// see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
	// If no time zone is specified, the default is UTC.
	TimeZone             string   `protobuf:"bytes,5,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchIncidentsRequest) Reset()         { *m = SearchIncidentsRequest{} }
func (m *SearchIncidentsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchIncidentsRequest) ProtoMessage()    {}
func (*SearchIncidentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{20}
}
func (m *SearchIncidentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchIncidentsRequest.Unmarshal(m, b)
}
func (m *SearchIncidentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchIncidentsRequest.Marshal(b, m, deterministic)
}
func (dst *SearchIncidentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchIncidentsRequest.Merge(dst, src)
}
func (m *SearchIncidentsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchIncidentsRequest.Size(m)
}
func (m *SearchIncidentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchIncidentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchIncidentsRequest proto.InternalMessageInfo

func (m *SearchIncidentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchIncidentsRequest) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *SearchIncidentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchIncidentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchIncidentsRequest) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

// Response for the SearchIncidents method.
type SearchIncidentsResponse struct {
	// Incidents.
	Incidents []*Incident `protobuf:"bytes,1,rep,name=incidents,proto3" json:"incidents,omitempty"`
	// Page token to fetch the next set of incidents.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchIncidentsResponse) Reset()         { *m = SearchIncidentsResponse{} }
func (m *SearchIncidentsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchIncidentsResponse) ProtoMessage()    {}
func (*SearchIncidentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{21}
}
func (m *SearchIncidentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchIncidentsResponse.Unmarshal(m, b)
}
func (m *SearchIncidentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchIncidentsResponse.Marshal(b, m, deterministic)
}
func (dst *SearchIncidentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchIncidentsResponse.Merge(dst, src)
}
func (m *SearchIncidentsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchIncidentsResponse.Size(m)
}
func (m *SearchIncidentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchIncidentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchIncidentsResponse proto.InternalMessageInfo

func (m *SearchIncidentsResponse) GetIncidents() []*Incident {
	if m != nil {
		return m.Incidents
	}
	return nil
}

func (m *SearchIncidentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to escalate an incident.
type EscalateIncidentRequest struct {
	// The incident to escalate with the new values.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// List of fields that should be updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Subscriptions to add or update. Existing subscriptions with the same
	// channel and address as a subscription in the list will be updated.
	Subscriptions []*Subscription `protobuf:"bytes,3,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Tags to add. Tags identical to existing tags will be ignored.
	Tags []*Tag `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty"`
	// Roles to add or update. Existing roles with the same type (and title, for
	// TYPE_OTHER roles) will be updated.
	Roles []*IncidentRoleAssignment `protobuf:"bytes,5,rep,name=roles,proto3" json:"roles,omitempty"`
	// Artifacts to add. All artifacts are added without checking for duplicates.
	Artifacts            []*Artifact `protobuf:"bytes,6,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EscalateIncidentRequest) Reset()         { *m = EscalateIncidentRequest{} }
func (m *EscalateIncidentRequest) String() string { return proto.CompactTextString(m) }
func (*EscalateIncidentRequest) ProtoMessage()    {}
func (*EscalateIncidentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{22}
}
func (m *EscalateIncidentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EscalateIncidentRequest.Unmarshal(m, b)
}
func (m *EscalateIncidentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EscalateIncidentRequest.Marshal(b, m, deterministic)
}
func (dst *EscalateIncidentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EscalateIncidentRequest.Merge(dst, src)
}
func (m *EscalateIncidentRequest) XXX_Size() int {
	return xxx_messageInfo_EscalateIncidentRequest.Size(m)
}
func (m *EscalateIncidentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EscalateIncidentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EscalateIncidentRequest proto.InternalMessageInfo

func (m *EscalateIncidentRequest) GetIncident() *Incident {
	if m != nil {
		return m.Incident
	}
	return nil
}

func (m *EscalateIncidentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *EscalateIncidentRequest) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *EscalateIncidentRequest) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *EscalateIncidentRequest) GetRoles() []*IncidentRoleAssignment {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *EscalateIncidentRequest) GetArtifacts() []*Artifact {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

// Response for EscalateIncident.
type EscalateIncidentResponse struct {
	// The escalated incident.
	Incident *Incident `protobuf:"bytes,1,opt,name=incident,proto3" json:"incident,omitempty"`
	// New or modified subscriptions.
	Subscriptions []*Subscription `protobuf:"bytes,2,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// New or modified tags.
	Tags []*Tag `protobuf:"bytes,3,rep,name=tags,proto3" json:"tags,omitempty"`
	// New or modified roles.
	Roles []*IncidentRole `protobuf:"bytes,4,rep,name=roles,proto3" json:"roles,omitempty"`
	// New or modified artifacts.
	Artifacts            []*Artifact `protobuf:"bytes,5,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *EscalateIncidentResponse) Reset()         { *m = EscalateIncidentResponse{} }
func (m *EscalateIncidentResponse) String() string { return proto.CompactTextString(m) }
func (*EscalateIncidentResponse) ProtoMessage()    {}
func (*EscalateIncidentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{23}
}
func (m *EscalateIncidentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EscalateIncidentResponse.Unmarshal(m, b)
}
func (m *EscalateIncidentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EscalateIncidentResponse.Marshal(b, m, deterministic)
}
func (dst *EscalateIncidentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EscalateIncidentResponse.Merge(dst, src)
}
func (m *EscalateIncidentResponse) XXX_Size() int {
	return xxx_messageInfo_EscalateIncidentResponse.Size(m)
}
func (m *EscalateIncidentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_EscalateIncidentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_EscalateIncidentResponse proto.InternalMessageInfo

func (m *EscalateIncidentResponse) GetIncident() *Incident {
	if m != nil {
		return m.Incident
	}
	return nil
}

func (m *EscalateIncidentResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *EscalateIncidentResponse) GetTags() []*Tag {
	if m != nil {
		return m.Tags
	}
	return nil
}

func (m *EscalateIncidentResponse) GetRoles() []*IncidentRole {
	if m != nil {
		return m.Roles
	}
	return nil
}

func (m *EscalateIncidentResponse) GetArtifacts() []*Artifact {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

// Request for the CreateArtifact method.
type CreateArtifactRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The artifact to create.
	Artifact             *Artifact `protobuf:"bytes,2,opt,name=artifact,proto3" json:"artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *CreateArtifactRequest) Reset()         { *m = CreateArtifactRequest{} }
func (m *CreateArtifactRequest) String() string { return proto.CompactTextString(m) }
func (*CreateArtifactRequest) ProtoMessage()    {}
func (*CreateArtifactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{24}
}
func (m *CreateArtifactRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateArtifactRequest.Unmarshal(m, b)
}
func (m *CreateArtifactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateArtifactRequest.Marshal(b, m, deterministic)
}
func (dst *CreateArtifactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateArtifactRequest.Merge(dst, src)
}
func (m *CreateArtifactRequest) XXX_Size() int {
	return xxx_messageInfo_CreateArtifactRequest.Size(m)
}
func (m *CreateArtifactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateArtifactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateArtifactRequest proto.InternalMessageInfo

func (m *CreateArtifactRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateArtifactRequest) GetArtifact() *Artifact {
	if m != nil {
		return m.Artifact
	}
	return nil
}

// Request for the ListArtifacts method.
type ListArtifactsRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of artifacts to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListArtifactsRequest) Reset()         { *m = ListArtifactsRequest{} }
func (m *ListArtifactsRequest) String() string { return proto.CompactTextString(m) }
func (*ListArtifactsRequest) ProtoMessage()    {}
func (*ListArtifactsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{25}
}
func (m *ListArtifactsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListArtifactsRequest.Unmarshal(m, b)
}
func (m *ListArtifactsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListArtifactsRequest.Marshal(b, m, deterministic)
}
func (dst *ListArtifactsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListArtifactsRequest.Merge(dst, src)
}
func (m *ListArtifactsRequest) XXX_Size() int {
	return xxx_messageInfo_ListArtifactsRequest.Size(m)
}
func (m *ListArtifactsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListArtifactsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListArtifactsRequest proto.InternalMessageInfo

func (m *ListArtifactsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListArtifactsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListArtifactsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListArtifacts method.
type ListArtifactsResponse struct {
	// List of artifacts.
	Artifacts []*Artifact `protobuf:"bytes,1,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Page token to fetch the next set of artifacts.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListArtifactsResponse) Reset()         { *m = ListArtifactsResponse{} }
func (m *ListArtifactsResponse) String() string { return proto.CompactTextString(m) }
func (*ListArtifactsResponse) ProtoMessage()    {}
func (*ListArtifactsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{26}
}
func (m *ListArtifactsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListArtifactsResponse.Unmarshal(m, b)
}
func (m *ListArtifactsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListArtifactsResponse.Marshal(b, m, deterministic)
}
func (dst *ListArtifactsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListArtifactsResponse.Merge(dst, src)
}
func (m *ListArtifactsResponse) XXX_Size() int {
	return xxx_messageInfo_ListArtifactsResponse.Size(m)
}
func (m *ListArtifactsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListArtifactsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListArtifactsResponse proto.InternalMessageInfo

func (m *ListArtifactsResponse) GetArtifacts() []*Artifact {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *ListArtifactsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for the UpdateArtifact method.
type UpdateArtifactRequest struct {
	// The artifact to update with the new values.
	Artifact *Artifact `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// List of fields that should be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateArtifactRequest) Reset()         { *m = UpdateArtifactRequest{} }
func (m *UpdateArtifactRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateArtifactRequest) ProtoMessage()    {}
func (*UpdateArtifactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{27}
}
func (m *UpdateArtifactRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateArtifactRequest.Unmarshal(m, b)
}
func (m *UpdateArtifactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateArtifactRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateArtifactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateArtifactRequest.Merge(dst, src)
}
func (m *UpdateArtifactRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateArtifactRequest.Size(m)
}
func (m *UpdateArtifactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateArtifactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateArtifactRequest proto.InternalMessageInfo

func (m *UpdateArtifactRequest) GetArtifact() *Artifact {
	if m != nil {
		return m.Artifact
	}
	return nil
}

func (m *UpdateArtifactRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request for deleting an artifact.
type DeleteArtifactRequest struct {
	// Resource name of the artifact.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteArtifactRequest) Reset()         { *m = DeleteArtifactRequest{} }
func (m *DeleteArtifactRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteArtifactRequest) ProtoMessage()    {}
func (*DeleteArtifactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{28}
}
func (m *DeleteArtifactRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteArtifactRequest.Unmarshal(m, b)
}
func (m *DeleteArtifactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteArtifactRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteArtifactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteArtifactRequest.Merge(dst, src)
}
func (m *DeleteArtifactRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteArtifactRequest.Size(m)
}
func (m *DeleteArtifactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteArtifactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteArtifactRequest proto.InternalMessageInfo

func (m *DeleteArtifactRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// GetShiftHandoffPresets RPC request.
type GetShiftHandoffPresetsRequest struct {
	// Resource name of the Stackdriver project that the presets belong to. e.g.
	// `projects/{project_id}`
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetShiftHandoffPresetsRequest) Reset()         { *m = GetShiftHandoffPresetsRequest{} }
func (m *GetShiftHandoffPresetsRequest) String() string { return proto.CompactTextString(m) }
func (*GetShiftHandoffPresetsRequest) ProtoMessage()    {}
func (*GetShiftHandoffPresetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{29}
}
func (m *GetShiftHandoffPresetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetShiftHandoffPresetsRequest.Unmarshal(m, b)
}
func (m *GetShiftHandoffPresetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetShiftHandoffPresetsRequest.Marshal(b, m, deterministic)
}
func (dst *GetShiftHandoffPresetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetShiftHandoffPresetsRequest.Merge(dst, src)
}
func (m *GetShiftHandoffPresetsRequest) XXX_Size() int {
	return xxx_messageInfo_GetShiftHandoffPresetsRequest.Size(m)
}
func (m *GetShiftHandoffPresetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetShiftHandoffPresetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetShiftHandoffPresetsRequest proto.InternalMessageInfo

func (m *GetShiftHandoffPresetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// GetShiftHandoffPresets RPC response.
type ShiftHandoffPresets struct {
	// The recipients that the user might want to send the shift handoff to, in
	// the form of email addresses, e.g. "user@example.com". Can be empty.
	Recipients []string `protobuf:"bytes,1,rep,name=recipients,proto3" json:"recipients,omitempty"`
	// The recipients that the user might want to CC on the shift handoff, in the
	// form of email addresses, e.g. "user@example.com". Can be empty.
	Cc []string `protobuf:"bytes,2,rep,name=cc,proto3" json:"cc,omitempty"`
	// A suggested subject for the shift handoff email. Can be empty.
	Subject              string   `protobuf:"bytes,3,opt,name=subject,proto3" json:"subject,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShiftHandoffPresets) Reset()         { *m = ShiftHandoffPresets{} }
func (m *ShiftHandoffPresets) String() string { return proto.CompactTextString(m) }
func (*ShiftHandoffPresets) ProtoMessage()    {}
func (*ShiftHandoffPresets) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{30}
}
func (m *ShiftHandoffPresets) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShiftHandoffPresets.Unmarshal(m, b)
}
func (m *ShiftHandoffPresets) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShiftHandoffPresets.Marshal(b, m, deterministic)
}
func (dst *ShiftHandoffPresets) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShiftHandoffPresets.Merge(dst, src)
}
func (m *ShiftHandoffPresets) XXX_Size() int {
	return xxx_messageInfo_ShiftHandoffPresets.Size(m)
}
func (m *ShiftHandoffPresets) XXX_DiscardUnknown() {
	xxx_messageInfo_ShiftHandoffPresets.DiscardUnknown(m)
}

var xxx_messageInfo_ShiftHandoffPresets proto.InternalMessageInfo

func (m *ShiftHandoffPresets) GetRecipients() []string {
	if m != nil {
		return m.Recipients
	}
	return nil
}

func (m *ShiftHandoffPresets) GetCc() []string {
	if m != nil {
		return m.Cc
	}
	return nil
}

func (m *ShiftHandoffPresets) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

// SendShiftHandoff and PreviewShiftHandoff RPC request.
type SendShiftHandoffRequest struct {
	// The resource name of the Stackdriver project that the handoff is being sent
	// from. e.g. `projects/{project_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Email addresses of the recipients of the handoff, e.g. "user@example.com".
	// Must contain at least one entry.
	Recipients []string `protobuf:"bytes,2,rep,name=recipients,proto3" json:"recipients,omitempty"`
	// Email addresses that should be CC'd on the handoff. Optional.
	Cc []string `protobuf:"bytes,3,rep,name=cc,proto3" json:"cc,omitempty"`
	// The subject of the email. Required.
	Subject string `protobuf:"bytes,4,opt,name=subject,proto3" json:"subject,omitempty"`
	// Content type string, e.g. 'text/plain' or 'text/html'.
	NotesContentType string `protobuf:"bytes,5,opt,name=notes_content_type,json=notesContentType,proto3" json:"notes_content_type,omitempty"`
	// Additional notes to be included in the handoff. Optional.
	NotesContent string `protobuf:"bytes,6,opt,name=notes_content,json=notesContent,proto3" json:"notes_content,omitempty"`
	// The set of incidents that should be included in the handoff. Optional.
	Incidents []*SendShiftHandoffRequest_Incident `protobuf:"bytes,7,rep,name=incidents,proto3" json:"incidents,omitempty"`
	// If set to true a ShiftHandoffResponse will be returned but the handoff
	// will not actually be sent.
	PreviewOnly          bool     `protobuf:"varint,8,opt,name=preview_only,json=previewOnly,proto3" json:"preview_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendShiftHandoffRequest) Reset()         { *m = SendShiftHandoffRequest{} }
func (m *SendShiftHandoffRequest) String() string { return proto.CompactTextString(m) }
func (*SendShiftHandoffRequest) ProtoMessage()    {}
func (*SendShiftHandoffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{31}
}
func (m *SendShiftHandoffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendShiftHandoffRequest.Unmarshal(m, b)
}
func (m *SendShiftHandoffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendShiftHandoffRequest.Marshal(b, m, deterministic)
}
func (dst *SendShiftHandoffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendShiftHandoffRequest.Merge(dst, src)
}
func (m *SendShiftHandoffRequest) XXX_Size() int {
	return xxx_messageInfo_SendShiftHandoffRequest.Size(m)
}
func (m *SendShiftHandoffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SendShiftHandoffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SendShiftHandoffRequest proto.InternalMessageInfo

func (m *SendShiftHandoffRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SendShiftHandoffRequest) GetRecipients() []string {
	if m != nil {
		return m.Recipients
	}
	return nil
}

func (m *SendShiftHandoffRequest) GetCc() []string {
	if m != nil {
		return m.Cc
	}
	return nil
}

func (m *SendShiftHandoffRequest) GetSubject() string {
	if m != nil {
		return m.Subject
	}
	return ""
}

func (m *SendShiftHandoffRequest) GetNotesContentType() string {
	if m != nil {
		return m.NotesContentType
	}
	return ""
}

func (m *SendShiftHandoffRequest) GetNotesContent() string {
	if m != nil {
		return m.NotesContent
	}
	return ""
}

func (m *SendShiftHandoffRequest) GetIncidents() []*SendShiftHandoffRequest_Incident {
	if m != nil {
		return m.Incidents
	}
	return nil
}

func (m *SendShiftHandoffRequest) GetPreviewOnly() bool {
	if m != nil {
		return m.PreviewOnly
	}
	return false
}

// Describes an incident for inclusion in the handoff.
// This is wrapped in a message to provide flexibility for potentially
// attaching additional data to each incident in the future.
type SendShiftHandoffRequest_Incident struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendShiftHandoffRequest_Incident) Reset()         { *m = SendShiftHandoffRequest_Incident{} }
func (m *SendShiftHandoffRequest_Incident) String() string { return proto.CompactTextString(m) }
func (*SendShiftHandoffRequest_Incident) ProtoMessage()    {}
func (*SendShiftHandoffRequest_Incident) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{31, 0}
}
func (m *SendShiftHandoffRequest_Incident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendShiftHandoffRequest_Incident.Unmarshal(m, b)
}
func (m *SendShiftHandoffRequest_Incident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendShiftHandoffRequest_Incident.Marshal(b, m, deterministic)
}
func (dst *SendShiftHandoffRequest_Incident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendShiftHandoffRequest_Incident.Merge(dst, src)
}
func (m *SendShiftHandoffRequest_Incident) XXX_Size() int {
	return xxx_messageInfo_SendShiftHandoffRequest_Incident.Size(m)
}
func (m *SendShiftHandoffRequest_Incident) XXX_DiscardUnknown() {
	xxx_messageInfo_SendShiftHandoffRequest_Incident.DiscardUnknown(m)
}

var xxx_messageInfo_SendShiftHandoffRequest_Incident proto.InternalMessageInfo

func (m *SendShiftHandoffRequest_Incident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// SendShiftHandoff and PreviewShiftHandoff RPC response.
type SendShiftHandoffResponse struct {
	// Content type string, e.g. 'text/plain' or 'text/html'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// The contents of the handoff that was sent or would have been sent (if the
	// request was preview_only).
	// This will typically contain a full HTML document.
	Content              string   `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SendShiftHandoffResponse) Reset()         { *m = SendShiftHandoffResponse{} }
func (m *SendShiftHandoffResponse) String() string { return proto.CompactTextString(m) }
func (*SendShiftHandoffResponse) ProtoMessage()    {}
func (*SendShiftHandoffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{32}
}
func (m *SendShiftHandoffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SendShiftHandoffResponse.Unmarshal(m, b)
}
func (m *SendShiftHandoffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SendShiftHandoffResponse.Marshal(b, m, deterministic)
}
func (dst *SendShiftHandoffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SendShiftHandoffResponse.Merge(dst, src)
}
func (m *SendShiftHandoffResponse) XXX_Size() int {
	return xxx_messageInfo_SendShiftHandoffResponse.Size(m)
}
func (m *SendShiftHandoffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SendShiftHandoffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SendShiftHandoffResponse proto.InternalMessageInfo

func (m *SendShiftHandoffResponse) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *SendShiftHandoffResponse) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

// Request for the CreateSubscription method.
type CreateSubscriptionRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The subscription to create.
	Subscription         *Subscription `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CreateSubscriptionRequest) Reset()         { *m = CreateSubscriptionRequest{} }
func (m *CreateSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSubscriptionRequest) ProtoMessage()    {}
func (*CreateSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{33}
}
func (m *CreateSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSubscriptionRequest.Unmarshal(m, b)
}
func (m *CreateSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSubscriptionRequest.Marshal(b, m, deterministic)
}
func (dst *CreateSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSubscriptionRequest.Merge(dst, src)
}
func (m *CreateSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSubscriptionRequest.Size(m)
}
func (m *CreateSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSubscriptionRequest proto.InternalMessageInfo

func (m *CreateSubscriptionRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSubscriptionRequest) GetSubscription() *Subscription {
	if m != nil {
		return m.Subscription
	}
	return nil
}

// Request for the ListSubscriptions method.
type ListSubscriptionsRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsRequest) Reset()         { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()    {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{34}
}
func (m *ListSubscriptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsRequest.Unmarshal(m, b)
}
func (m *ListSubscriptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsRequest.Marshal(b, m, deterministic)
}
func (dst *ListSubscriptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsRequest.Merge(dst, src)
}
func (m *ListSubscriptionsRequest) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsRequest.Size(m)
}
func (m *ListSubscriptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsRequest proto.InternalMessageInfo

func (m *ListSubscriptionsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSubscriptionsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListSubscriptionsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListSubscriptions method.
type ListSubscriptionsResponse struct {
	// List of subscriptions.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Page token to fetch the next set of subscriptions.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSubscriptionsResponse) Reset()         { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()    {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{35}
}
func (m *ListSubscriptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSubscriptionsResponse.Unmarshal(m, b)
}
func (m *ListSubscriptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSubscriptionsResponse.Marshal(b, m, deterministic)
}
func (dst *ListSubscriptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSubscriptionsResponse.Merge(dst, src)
}
func (m *ListSubscriptionsResponse) XXX_Size() int {
	return xxx_messageInfo_ListSubscriptionsResponse.Size(m)
}
func (m *ListSubscriptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSubscriptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSubscriptionsResponse proto.InternalMessageInfo

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

func (m *ListSubscriptionsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request for deleting a subscription.
type DeleteSubscriptionRequest struct {
	// Resource name of the subscription.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteSubscriptionRequest) Reset()         { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()    {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{36}
}
func (m *DeleteSubscriptionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteSubscriptionRequest.Unmarshal(m, b)
}
func (m *DeleteSubscriptionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteSubscriptionRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteSubscriptionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteSubscriptionRequest.Merge(dst, src)
}
func (m *DeleteSubscriptionRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteSubscriptionRequest.Size(m)
}
func (m *DeleteSubscriptionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteSubscriptionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteSubscriptionRequest proto.InternalMessageInfo

func (m *DeleteSubscriptionRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request for creating a role assignment.
type CreateIncidentRoleAssignmentRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Role assignment to create.
	IncidentRoleAssignment *IncidentRoleAssignment `protobuf:"bytes,2,opt,name=incident_role_assignment,json=incidentRoleAssignment,proto3" json:"incident_role_assignment,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                `json:"-"`
	XXX_unrecognized       []byte                  `json:"-"`
	XXX_sizecache          int32                   `json:"-"`
}

func (m *CreateIncidentRoleAssignmentRequest) Reset()         { *m = CreateIncidentRoleAssignmentRequest{} }
func (m *CreateIncidentRoleAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIncidentRoleAssignmentRequest) ProtoMessage()    {}
func (*CreateIncidentRoleAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{37}
}
func (m *CreateIncidentRoleAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIncidentRoleAssignmentRequest.Unmarshal(m, b)
}
func (m *CreateIncidentRoleAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIncidentRoleAssignmentRequest.Marshal(b, m, deterministic)
}
func (dst *CreateIncidentRoleAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIncidentRoleAssignmentRequest.Merge(dst, src)
}
func (m *CreateIncidentRoleAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIncidentRoleAssignmentRequest.Size(m)
}
func (m *CreateIncidentRoleAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIncidentRoleAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIncidentRoleAssignmentRequest proto.InternalMessageInfo

func (m *CreateIncidentRoleAssignmentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIncidentRoleAssignmentRequest) GetIncidentRoleAssignment() *IncidentRoleAssignment {
	if m != nil {
		return m.IncidentRoleAssignment
	}
	return nil
}

// Request for deleting a role assignment.
type DeleteIncidentRoleAssignmentRequest struct {
	// Resource name of the role assignment.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteIncidentRoleAssignmentRequest) Reset()         { *m = DeleteIncidentRoleAssignmentRequest{} }
func (m *DeleteIncidentRoleAssignmentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteIncidentRoleAssignmentRequest) ProtoMessage()    {}
func (*DeleteIncidentRoleAssignmentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{38}
}
func (m *DeleteIncidentRoleAssignmentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteIncidentRoleAssignmentRequest.Unmarshal(m, b)
}
func (m *DeleteIncidentRoleAssignmentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteIncidentRoleAssignmentRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteIncidentRoleAssignmentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteIncidentRoleAssignmentRequest.Merge(dst, src)
}
func (m *DeleteIncidentRoleAssignmentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteIncidentRoleAssignmentRequest.Size(m)
}
func (m *DeleteIncidentRoleAssignmentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteIncidentRoleAssignmentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteIncidentRoleAssignmentRequest proto.InternalMessageInfo

func (m *DeleteIncidentRoleAssignmentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list role assignments of an incident.
type ListIncidentRoleAssignmentsRequest struct {
	// Resource name of the incident, e.g.
	// "projects/{project_id}/incidents/{incident_id}".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of assignments to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Page token from an earlier query, as returned in `next_page_token`.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIncidentRoleAssignmentsRequest) Reset()         { *m = ListIncidentRoleAssignmentsRequest{} }
func (m *ListIncidentRoleAssignmentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListIncidentRoleAssignmentsRequest) ProtoMessage()    {}
func (*ListIncidentRoleAssignmentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{39}
}
func (m *ListIncidentRoleAssignmentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIncidentRoleAssignmentsRequest.Unmarshal(m, b)
}
func (m *ListIncidentRoleAssignmentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIncidentRoleAssignmentsRequest.Marshal(b, m, deterministic)
}
func (dst *ListIncidentRoleAssignmentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIncidentRoleAssignmentsRequest.Merge(dst, src)
}
func (m *ListIncidentRoleAssignmentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListIncidentRoleAssignmentsRequest.Size(m)
}
func (m *ListIncidentRoleAssignmentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIncidentRoleAssignmentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIncidentRoleAssignmentsRequest proto.InternalMessageInfo

func (m *ListIncidentRoleAssignmentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIncidentRoleAssignmentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIncidentRoleAssignmentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response for the ListIncidentRoleAssignments method.
type ListIncidentRoleAssignmentsResponse struct {
	// List of assignments.
	IncidentRoleAssignments []*IncidentRoleAssignment `protobuf:"bytes,1,rep,name=incident_role_assignments,json=incidentRoleAssignments,proto3" json:"incident_role_assignments,omitempty"`
	// Page token to fetch the next set of assignments.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIncidentRoleAssignmentsResponse) Reset()         { *m = ListIncidentRoleAssignmentsResponse{} }
func (m *ListIncidentRoleAssignmentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListIncidentRoleAssignmentsResponse) ProtoMessage()    {}
func (*ListIncidentRoleAssignmentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{40}
}
func (m *ListIncidentRoleAssignmentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIncidentRoleAssignmentsResponse.Unmarshal(m, b)
}
func (m *ListIncidentRoleAssignmentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIncidentRoleAssignmentsResponse.Marshal(b, m, deterministic)
}
func (dst *ListIncidentRoleAssignmentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIncidentRoleAssignmentsResponse.Merge(dst, src)
}
func (m *ListIncidentRoleAssignmentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListIncidentRoleAssignmentsResponse.Size(m)
}
func (m *ListIncidentRoleAssignmentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIncidentRoleAssignmentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIncidentRoleAssignmentsResponse proto.InternalMessageInfo

func (m *ListIncidentRoleAssignmentsResponse) GetIncidentRoleAssignments() []*IncidentRoleAssignment {
	if m != nil {
		return m.IncidentRoleAssignments
	}
	return nil
}

func (m *ListIncidentRoleAssignmentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request to start a role handover.
type RequestIncidentRoleHandoverRequest struct {
	// Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The proposed assignee.
	NewAssignee          *User    `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RequestIncidentRoleHandoverRequest) Reset()         { *m = RequestIncidentRoleHandoverRequest{} }
func (m *RequestIncidentRoleHandoverRequest) String() string { return proto.CompactTextString(m) }
func (*RequestIncidentRoleHandoverRequest) ProtoMessage()    {}
func (*RequestIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{41}
}
func (m *RequestIncidentRoleHandoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestIncidentRoleHandoverRequest.Unmarshal(m, b)
}
func (m *RequestIncidentRoleHandoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestIncidentRoleHandoverRequest.Marshal(b, m, deterministic)
}
func (dst *RequestIncidentRoleHandoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestIncidentRoleHandoverRequest.Merge(dst, src)
}
func (m *RequestIncidentRoleHandoverRequest) XXX_Size() int {
	return xxx_messageInfo_RequestIncidentRoleHandoverRequest.Size(m)
}
func (m *RequestIncidentRoleHandoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestIncidentRoleHandoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RequestIncidentRoleHandoverRequest proto.InternalMessageInfo

func (m *RequestIncidentRoleHandoverRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RequestIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if m != nil {
		return m.NewAssignee
	}
	return nil
}

// Request to confirm a role handover.
type ConfirmIncidentRoleHandoverRequest struct {
	// Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The proposed assignee, who will now be the assignee. This should be the
	// current user; otherwise ForceRoleHandover should be called.
	NewAssignee          *User    `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfirmIncidentRoleHandoverRequest) Reset()         { *m = ConfirmIncidentRoleHandoverRequest{} }
func (m *ConfirmIncidentRoleHandoverRequest) String() string { return proto.CompactTextString(m) }
func (*ConfirmIncidentRoleHandoverRequest) ProtoMessage()    {}
func (*ConfirmIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{42}
}
func (m *ConfirmIncidentRoleHandoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfirmIncidentRoleHandoverRequest.Unmarshal(m, b)
}
func (m *ConfirmIncidentRoleHandoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfirmIncidentRoleHandoverRequest.Marshal(b, m, deterministic)
}
func (dst *ConfirmIncidentRoleHandoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfirmIncidentRoleHandoverRequest.Merge(dst, src)
}
func (m *ConfirmIncidentRoleHandoverRequest) XXX_Size() int {
	return xxx_messageInfo_ConfirmIncidentRoleHandoverRequest.Size(m)
}
func (m *ConfirmIncidentRoleHandoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfirmIncidentRoleHandoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConfirmIncidentRoleHandoverRequest proto.InternalMessageInfo

func (m *ConfirmIncidentRoleHandoverRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ConfirmIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if m != nil {
		return m.NewAssignee
	}
	return nil
}

// Request to force a role handover.
type ForceIncidentRoleHandoverRequest struct {
	// Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The proposed assignee, who will now be the assignee. This should not be
	// the current user; otherwise ConfirmRoleHandover should be called.
	NewAssignee          *User    `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ForceIncidentRoleHandoverRequest) Reset()         { *m = ForceIncidentRoleHandoverRequest{} }
func (m *ForceIncidentRoleHandoverRequest) String() string { return proto.CompactTextString(m) }
func (*ForceIncidentRoleHandoverRequest) ProtoMessage()    {}
func (*ForceIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{43}
}
func (m *ForceIncidentRoleHandoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ForceIncidentRoleHandoverRequest.Unmarshal(m, b)
}
func (m *ForceIncidentRoleHandoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ForceIncidentRoleHandoverRequest.Marshal(b, m, deterministic)
}
func (dst *ForceIncidentRoleHandoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ForceIncidentRoleHandoverRequest.Merge(dst, src)
}
func (m *ForceIncidentRoleHandoverRequest) XXX_Size() int {
	return xxx_messageInfo_ForceIncidentRoleHandoverRequest.Size(m)
}
func (m *ForceIncidentRoleHandoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ForceIncidentRoleHandoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ForceIncidentRoleHandoverRequest proto.InternalMessageInfo

func (m *ForceIncidentRoleHandoverRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ForceIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if m != nil {
		return m.NewAssignee
	}
	return nil
}

// Request to cancel a role handover.
type CancelIncidentRoleHandoverRequest struct {
	// Resource name of the role assignment.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Person who was proposed as the next assignee (i.e.
	// IncidentRoleAssignment.proposed_assignee) and whose proposal is being
	// cancelled.
	NewAssignee          *User    `protobuf:"bytes,2,opt,name=new_assignee,json=newAssignee,proto3" json:"new_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelIncidentRoleHandoverRequest) Reset()         { *m = CancelIncidentRoleHandoverRequest{} }
func (m *CancelIncidentRoleHandoverRequest) String() string { return proto.CompactTextString(m) }
func (*CancelIncidentRoleHandoverRequest) ProtoMessage()    {}
func (*CancelIncidentRoleHandoverRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_incidents_service_f1859dadab0f5205, []int{44}
}
func (m *CancelIncidentRoleHandoverRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelIncidentRoleHandoverRequest.Unmarshal(m, b)
}
func (m *CancelIncidentRoleHandoverRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelIncidentRoleHandoverRequest.Marshal(b, m, deterministic)
}
func (dst *CancelIncidentRoleHandoverRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelIncidentRoleHandoverRequest.Merge(dst, src)
}
func (m *CancelIncidentRoleHandoverRequest) XXX_Size() int {
	return xxx_messageInfo_CancelIncidentRoleHandoverRequest.Size(m)
}
func (m *CancelIncidentRoleHandoverRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelIncidentRoleHandoverRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelIncidentRoleHandoverRequest proto.InternalMessageInfo

func (m *CancelIncidentRoleHandoverRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CancelIncidentRoleHandoverRequest) GetNewAssignee() *User {
	if m != nil {
		return m.NewAssignee
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateIncidentRequest)(nil), "google.cloud.irm.v1alpha2.CreateIncidentRequest")
	proto.RegisterType((*GetIncidentRequest)(nil), "google.cloud.irm.v1alpha2.GetIncidentRequest")
	proto.RegisterType((*UpdateIncidentRequest)(nil), "google.cloud.irm.v1alpha2.UpdateIncidentRequest")
	proto.RegisterType((*SearchSimilarIncidentsRequest)(nil), "google.cloud.irm.v1alpha2.SearchSimilarIncidentsRequest")
	proto.RegisterType((*SearchSimilarIncidentsResponse)(nil), "google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse")
	proto.RegisterType((*SearchSimilarIncidentsResponse_Result)(nil), "google.cloud.irm.v1alpha2.SearchSimilarIncidentsResponse.Result")
	proto.RegisterType((*CreateAnnotationRequest)(nil), "google.cloud.irm.v1alpha2.CreateAnnotationRequest")
	proto.RegisterType((*ListAnnotationsRequest)(nil), "google.cloud.irm.v1alpha2.ListAnnotationsRequest")
	proto.RegisterType((*ListAnnotationsResponse)(nil), "google.cloud.irm.v1alpha2.ListAnnotationsResponse")
	proto.RegisterType((*CreateTagRequest)(nil), "google.cloud.irm.v1alpha2.CreateTagRequest")
	proto.RegisterType((*DeleteTagRequest)(nil), "google.cloud.irm.v1alpha2.DeleteTagRequest")
	proto.RegisterType((*ListTagsRequest)(nil), "google.cloud.irm.v1alpha2.ListTagsRequest")
	proto.RegisterType((*ListTagsResponse)(nil), "google.cloud.irm.v1alpha2.ListTagsResponse")
	proto.RegisterType((*UpdateAnnotationRequest)(nil), "google.cloud.irm.v1alpha2.UpdateAnnotationRequest")
	proto.RegisterType((*CreateSignalRequest)(nil), "google.cloud.irm.v1alpha2.CreateSignalRequest")
	proto.RegisterType((*ListSignalsRequest)(nil), "google.cloud.irm.v1alpha2.ListSignalsRequest")
	proto.RegisterType((*ListSignalsResponse)(nil), "google.cloud.irm.v1alpha2.ListSignalsResponse")
	proto.RegisterType((*GetSignalRequest)(nil), "google.cloud.irm.v1alpha2.GetSignalRequest")
	proto.RegisterType((*UpdateSignalRequest)(nil), "google.cloud.irm.v1alpha2.UpdateSignalRequest")
	proto.RegisterType((*AcknowledgeSignalRequest)(nil), "google.cloud.irm.v1alpha2.AcknowledgeSignalRequest")
	proto.RegisterType((*AcknowledgeSignalResponse)(nil), "google.cloud.irm.v1alpha2.AcknowledgeSignalResponse")
	proto.RegisterType((*SearchIncidentsRequest)(nil), "google.cloud.irm.v1alpha2.SearchIncidentsRequest")
	proto.RegisterType((*SearchIncidentsResponse)(nil), "google.cloud.irm.v1alpha2.SearchIncidentsResponse")
	proto.RegisterType((*EscalateIncidentRequest)(nil), "google.cloud.irm.v1alpha2.EscalateIncidentRequest")
	proto.RegisterType((*EscalateIncidentResponse)(nil), "google.cloud.irm.v1alpha2.EscalateIncidentResponse")
	proto.RegisterType((*CreateArtifactRequest)(nil), "google.cloud.irm.v1alpha2.CreateArtifactRequest")
	proto.RegisterType((*ListArtifactsRequest)(nil), "google.cloud.irm.v1alpha2.ListArtifactsRequest")
	proto.RegisterType((*ListArtifactsResponse)(nil), "google.cloud.irm.v1alpha2.ListArtifactsResponse")
	proto.RegisterType((*UpdateArtifactRequest)(nil), "google.cloud.irm.v1alpha2.UpdateArtifactRequest")
	proto.RegisterType((*DeleteArtifactRequest)(nil), "google.cloud.irm.v1alpha2.DeleteArtifactRequest")
	proto.RegisterType((*GetShiftHandoffPresetsRequest)(nil), "google.cloud.irm.v1alpha2.GetShiftHandoffPresetsRequest")
	proto.RegisterType((*ShiftHandoffPresets)(nil), "google.cloud.irm.v1alpha2.ShiftHandoffPresets")
	proto.RegisterType((*SendShiftHandoffRequest)(nil), "google.cloud.irm.v1alpha2.SendShiftHandoffRequest")
	proto.RegisterType((*SendShiftHandoffRequest_Incident)(nil), "google.cloud.irm.v1alpha2.SendShiftHandoffRequest.Incident")
	proto.RegisterType((*SendShiftHandoffResponse)(nil), "google.cloud.irm.v1alpha2.SendShiftHandoffResponse")
	proto.RegisterType((*CreateSubscriptionRequest)(nil), "google.cloud.irm.v1alpha2.CreateSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.cloud.irm.v1alpha2.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.cloud.irm.v1alpha2.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.cloud.irm.v1alpha2.DeleteSubscriptionRequest")
	proto.RegisterType((*CreateIncidentRoleAssignmentRequest)(nil), "google.cloud.irm.v1alpha2.CreateIncidentRoleAssignmentRequest")
	proto.RegisterType((*DeleteIncidentRoleAssignmentRequest)(nil), "google.cloud.irm.v1alpha2.DeleteIncidentRoleAssignmentRequest")
	proto.RegisterType((*ListIncidentRoleAssignmentsRequest)(nil), "google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsRequest")
	proto.RegisterType((*ListIncidentRoleAssignmentsResponse)(nil), "google.cloud.irm.v1alpha2.ListIncidentRoleAssignmentsResponse")
	proto.RegisterType((*RequestIncidentRoleHandoverRequest)(nil), "google.cloud.irm.v1alpha2.RequestIncidentRoleHandoverRequest")
	proto.RegisterType((*ConfirmIncidentRoleHandoverRequest)(nil), "google.cloud.irm.v1alpha2.ConfirmIncidentRoleHandoverRequest")
	proto.RegisterType((*ForceIncidentRoleHandoverRequest)(nil), "google.cloud.irm.v1alpha2.ForceIncidentRoleHandoverRequest")
	proto.RegisterType((*CancelIncidentRoleHandoverRequest)(nil), "google.cloud.irm.v1alpha2.CancelIncidentRoleHandoverRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IncidentServiceClient is the client API for IncidentService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IncidentServiceClient interface {
	// Creates a new incident.
	CreateIncident(ctx context.Context, in *CreateIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns an incident by name.
	GetIncident(ctx context.Context, in *GetIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns a list of incidents.
	// Incidents are ordered by start time, with the most recent incidents first.
	SearchIncidents(ctx context.Context, in *SearchIncidentsRequest, opts ...grpc.CallOption) (*SearchIncidentsResponse, error)
	// Updates an existing incident.
	UpdateIncident(ctx context.Context, in *UpdateIncidentRequest, opts ...grpc.CallOption) (*Incident, error)
	// Returns a list of incidents that are "similar" to the specified incident
	// or signal. This functionality is provided on a best-effort basis and the
	// definition of "similar" is subject to change.
	SearchSimilarIncidents(ctx context.Context, in *SearchSimilarIncidentsRequest, opts ...grpc.CallOption) (*SearchSimilarIncidentsResponse, error)
	// Creates an annotation on an existing incident. Only 'text/plain' and
	// 'text/markdown' annotations can be created via this method.
	CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Lists annotations that are part of an incident. No assumptions should be
	// made on the content-type of the annotation returned.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
	// Updates an annotation on an existing incident.
	UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error)
	// Creates a tag on an existing incident.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes an existing tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists tags that are part of an incident.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Creates a new signal.
	CreateSignal(ctx context.Context, in *CreateSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Lists signals that are part of an incident.
	// Signals are returned in reverse chronological order.
	ListSignals(ctx context.Context, in *ListSignalsRequest, opts ...grpc.CallOption) (*ListSignalsResponse, error)
	// Returns a signal by name.
	GetSignal(ctx context.Context, in *GetSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Updates an existing signal (e.g. to assign/unassign it to an
	// incident).
	UpdateSignal(ctx context.Context, in *UpdateSignalRequest, opts ...grpc.CallOption) (*Signal, error)
	// Acks a signal. This acknowledges the signal in the underlying system,
	// indicating that the caller takes responsibility for looking into this.
	AcknowledgeSignal(ctx context.Context, in *AcknowledgeSignalRequest, opts ...grpc.CallOption) (*AcknowledgeSignalResponse, error)
	// Escalates an incident.
	EscalateIncident(ctx context.Context, in *EscalateIncidentRequest, opts ...grpc.CallOption) (*EscalateIncidentResponse, error)
	// Creates a new artifact.
	CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Returns a list of artifacts for an incident.
	ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error)
	// Updates an existing artifact.
	UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error)
	// Deletes an existing artifact.
	DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns "presets" specific to shift handoff (see SendShiftHandoff), e.g.
	// default values for handoff message fields.
	GetShiftHandoffPresets(ctx context.Context, in *GetShiftHandoffPresetsRequest, opts ...grpc.CallOption) (*ShiftHandoffPresets, error)
	// Sends a summary of the shift for oncall handoff.
	SendShiftHandoff(ctx context.Context, in *SendShiftHandoffRequest, opts ...grpc.CallOption) (*SendShiftHandoffResponse, error)
	// Creates a new subscription.
	// This will fail if:
	//    a. there are too many (50) subscriptions in the incident already
	//    b. a subscription using the given channel already exists
	CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Returns a list of subscriptions for an incident.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a role assignment on an existing incident. Normally, the user field
	// will be set when assigning a role to oneself, and the next field will be
	// set when proposing another user as the assignee. Setting the next field
	// directly to a user other than oneself is equivalent to proposing and
	// force-assigning the role to the user.
	CreateIncidentRoleAssignment(ctx context.Context, in *CreateIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Deletes an existing role assignment.
	DeleteIncidentRoleAssignment(ctx context.Context, in *DeleteIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists role assignments that are part of an incident.
	ListIncidentRoleAssignments(ctx context.Context, in *ListIncidentRoleAssignmentsRequest, opts ...grpc.CallOption) (*ListIncidentRoleAssignmentsResponse, error)
	// Starts a role handover. The proposed assignee will receive an email
	// notifying them of the assignment. This will fail if a role handover is
	// already pending.
	RequestIncidentRoleHandover(ctx context.Context, in *RequestIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Confirms a role handover. This will fail if the 'proposed_assignee' field
	// of the IncidentRoleAssignment is not equal to the 'new_assignee' field of
	// the request. If the caller is not the new_assignee,
	// ForceIncidentRoleHandover should be used instead.
	ConfirmIncidentRoleHandover(ctx context.Context, in *ConfirmIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Forces a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request. If the caller is the new_assignee, ConfirmIncidentRoleHandover
	// should be used instead.
	ForceIncidentRoleHandover(ctx context.Context, in *ForceIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
	// Cancels a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request.
	CancelIncidentRoleHandover(ctx context.Context, in *CancelIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error)
}

type incidentServiceClient struct {
	cc *grpc.ClientConn
}

func NewIncidentServiceClient(cc *grpc.ClientConn) IncidentServiceClient {
	return &incidentServiceClient{cc}
}

func (c *incidentServiceClient) CreateIncident(ctx context.Context, in *CreateIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) GetIncident(ctx context.Context, in *GetIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/GetIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SearchIncidents(ctx context.Context, in *SearchIncidentsRequest, opts ...grpc.CallOption) (*SearchIncidentsResponse, error) {
	out := new(SearchIncidentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SearchIncidents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateIncident(ctx context.Context, in *UpdateIncidentRequest, opts ...grpc.CallOption) (*Incident, error) {
	out := new(Incident)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SearchSimilarIncidents(ctx context.Context, in *SearchSimilarIncidentsRequest, opts ...grpc.CallOption) (*SearchSimilarIncidentsResponse, error) {
	out := new(SearchSimilarIncidentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SearchSimilarIncidents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateAnnotation(ctx context.Context, in *CreateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListAnnotations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateAnnotation(ctx context.Context, in *UpdateAnnotationRequest, opts ...grpc.CallOption) (*Annotation, error) {
	out := new(Annotation)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateAnnotation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteTag", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListTags", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateSignal(ctx context.Context, in *CreateSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListSignals(ctx context.Context, in *ListSignalsRequest, opts ...grpc.CallOption) (*ListSignalsResponse, error) {
	out := new(ListSignalsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListSignals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) GetSignal(ctx context.Context, in *GetSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/GetSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateSignal(ctx context.Context, in *UpdateSignalRequest, opts ...grpc.CallOption) (*Signal, error) {
	out := new(Signal)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) AcknowledgeSignal(ctx context.Context, in *AcknowledgeSignalRequest, opts ...grpc.CallOption) (*AcknowledgeSignalResponse, error) {
	out := new(AcknowledgeSignalResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/AcknowledgeSignal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) EscalateIncident(ctx context.Context, in *EscalateIncidentRequest, opts ...grpc.CallOption) (*EscalateIncidentResponse, error) {
	out := new(EscalateIncidentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/EscalateIncident", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateArtifact(ctx context.Context, in *CreateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListArtifacts(ctx context.Context, in *ListArtifactsRequest, opts ...grpc.CallOption) (*ListArtifactsResponse, error) {
	out := new(ListArtifactsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListArtifacts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) UpdateArtifact(ctx context.Context, in *UpdateArtifactRequest, opts ...grpc.CallOption) (*Artifact, error) {
	out := new(Artifact)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/UpdateArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteArtifact(ctx context.Context, in *DeleteArtifactRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) GetShiftHandoffPresets(ctx context.Context, in *GetShiftHandoffPresetsRequest, opts ...grpc.CallOption) (*ShiftHandoffPresets, error) {
	out := new(ShiftHandoffPresets)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/GetShiftHandoffPresets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) SendShiftHandoff(ctx context.Context, in *SendShiftHandoffRequest, opts ...grpc.CallOption) (*SendShiftHandoffResponse, error) {
	out := new(SendShiftHandoffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/SendShiftHandoff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateSubscription(ctx context.Context, in *CreateSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListSubscriptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteSubscription", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CreateIncidentRoleAssignment(ctx context.Context, in *CreateIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CreateIncidentRoleAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) DeleteIncidentRoleAssignment(ctx context.Context, in *DeleteIncidentRoleAssignmentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/DeleteIncidentRoleAssignment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ListIncidentRoleAssignments(ctx context.Context, in *ListIncidentRoleAssignmentsRequest, opts ...grpc.CallOption) (*ListIncidentRoleAssignmentsResponse, error) {
	out := new(ListIncidentRoleAssignmentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ListIncidentRoleAssignments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) RequestIncidentRoleHandover(ctx context.Context, in *RequestIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/RequestIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ConfirmIncidentRoleHandover(ctx context.Context, in *ConfirmIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ConfirmIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) ForceIncidentRoleHandover(ctx context.Context, in *ForceIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/ForceIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *incidentServiceClient) CancelIncidentRoleHandover(ctx context.Context, in *CancelIncidentRoleHandoverRequest, opts ...grpc.CallOption) (*IncidentRoleAssignment, error) {
	out := new(IncidentRoleAssignment)
	err := c.cc.Invoke(ctx, "/google.cloud.irm.v1alpha2.IncidentService/CancelIncidentRoleHandover", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IncidentServiceServer is the server API for IncidentService service.
type IncidentServiceServer interface {
	// Creates a new incident.
	CreateIncident(context.Context, *CreateIncidentRequest) (*Incident, error)
	// Returns an incident by name.
	GetIncident(context.Context, *GetIncidentRequest) (*Incident, error)
	// Returns a list of incidents.
	// Incidents are ordered by start time, with the most recent incidents first.
	SearchIncidents(context.Context, *SearchIncidentsRequest) (*SearchIncidentsResponse, error)
	// Updates an existing incident.
	UpdateIncident(context.Context, *UpdateIncidentRequest) (*Incident, error)
	// Returns a list of incidents that are "similar" to the specified incident
	// or signal. This functionality is provided on a best-effort basis and the
	// definition of "similar" is subject to change.
	SearchSimilarIncidents(context.Context, *SearchSimilarIncidentsRequest) (*SearchSimilarIncidentsResponse, error)
	// Creates an annotation on an existing incident. Only 'text/plain' and
	// 'text/markdown' annotations can be created via this method.
	CreateAnnotation(context.Context, *CreateAnnotationRequest) (*Annotation, error)
	// Lists annotations that are part of an incident. No assumptions should be
	// made on the content-type of the annotation returned.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
	// Updates an annotation on an existing incident.
	UpdateAnnotation(context.Context, *UpdateAnnotationRequest) (*Annotation, error)
	// Creates a tag on an existing incident.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Deletes an existing tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*empty.Empty, error)
	// Lists tags that are part of an incident.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Creates a new signal.
	CreateSignal(context.Context, *CreateSignalRequest) (*Signal, error)
	// Lists signals that are part of an incident.
	// Signals are returned in reverse chronological order.
	ListSignals(context.Context, *ListSignalsRequest) (*ListSignalsResponse, error)
	// Returns a signal by name.
	GetSignal(context.Context, *GetSignalRequest) (*Signal, error)
	// Updates an existing signal (e.g. to assign/unassign it to an
	// incident).
	UpdateSignal(context.Context, *UpdateSignalRequest) (*Signal, error)
	// Acks a signal. This acknowledges the signal in the underlying system,
	// indicating that the caller takes responsibility for looking into this.
	AcknowledgeSignal(context.Context, *AcknowledgeSignalRequest) (*AcknowledgeSignalResponse, error)
	// Escalates an incident.
	EscalateIncident(context.Context, *EscalateIncidentRequest) (*EscalateIncidentResponse, error)
	// Creates a new artifact.
	CreateArtifact(context.Context, *CreateArtifactRequest) (*Artifact, error)
	// Returns a list of artifacts for an incident.
	ListArtifacts(context.Context, *ListArtifactsRequest) (*ListArtifactsResponse, error)
	// Updates an existing artifact.
	UpdateArtifact(context.Context, *UpdateArtifactRequest) (*Artifact, error)
	// Deletes an existing artifact.
	DeleteArtifact(context.Context, *DeleteArtifactRequest) (*empty.Empty, error)
	// Returns "presets" specific to shift handoff (see SendShiftHandoff), e.g.
	// default values for handoff message fields.
	GetShiftHandoffPresets(context.Context, *GetShiftHandoffPresetsRequest) (*ShiftHandoffPresets, error)
	// Sends a summary of the shift for oncall handoff.
	SendShiftHandoff(context.Context, *SendShiftHandoffRequest) (*SendShiftHandoffResponse, error)
	// Creates a new subscription.
	// This will fail if:
	//    a. there are too many (50) subscriptions in the incident already
	//    b. a subscription using the given channel already exists
	CreateSubscription(context.Context, *CreateSubscriptionRequest) (*Subscription, error)
	// Returns a list of subscriptions for an incident.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*empty.Empty, error)
	// Creates a role assignment on an existing incident. Normally, the user field
	// will be set when assigning a role to oneself, and the next field will be
	// set when proposing another user as the assignee. Setting the next field
	// directly to a user other than oneself is equivalent to proposing and
	// force-assigning the role to the user.
	CreateIncidentRoleAssignment(context.Context, *CreateIncidentRoleAssignmentRequest) (*IncidentRoleAssignment, error)
	// Deletes an existing role assignment.
	DeleteIncidentRoleAssignment(context.Context, *DeleteIncidentRoleAssignmentRequest) (*empty.Empty, error)
	// Lists role assignments that are part of an incident.
	ListIncidentRoleAssignments(context.Context, *ListIncidentRoleAssignmentsRequest) (*ListIncidentRoleAssignmentsResponse, error)
	// Starts a role handover. The proposed assignee will receive an email
	// notifying them of the assignment. This will fail if a role handover is
	// already pending.
	RequestIncidentRoleHandover(context.Context, *RequestIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Confirms a role handover. This will fail if the 'proposed_assignee' field
	// of the IncidentRoleAssignment is not equal to the 'new_assignee' field of
	// the request. If the caller is not the new_assignee,
	// ForceIncidentRoleHandover should be used instead.
	ConfirmIncidentRoleHandover(context.Context, *ConfirmIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Forces a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request. If the caller is the new_assignee, ConfirmIncidentRoleHandover
	// should be used instead.
	ForceIncidentRoleHandover(context.Context, *ForceIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
	// Cancels a role handover. This will fail if the 'proposed_assignee' field of
	// the IncidentRoleAssignment is not equal to the 'new_assignee' field of the
	// request.
	CancelIncidentRoleHandover(context.Context, *CancelIncidentRoleHandoverRequest) (*IncidentRoleAssignment, error)
}

func RegisterIncidentServiceServer(s *grpc.Server, srv IncidentServiceServer) {
	s.RegisterService(&_IncidentService_serviceDesc, srv)
}

func _IncidentService_CreateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateIncident(ctx, req.(*CreateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_GetIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).GetIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/GetIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).GetIncident(ctx, req.(*GetIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SearchIncidents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchIncidentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SearchIncidents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SearchIncidents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SearchIncidents(ctx, req.(*SearchIncidentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateIncident(ctx, req.(*UpdateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SearchSimilarIncidents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchSimilarIncidentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SearchSimilarIncidents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SearchSimilarIncidents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SearchSimilarIncidents(ctx, req.(*SearchSimilarIncidentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateAnnotation(ctx, req.(*CreateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListAnnotations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateAnnotation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAnnotationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateAnnotation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateAnnotation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateAnnotation(ctx, req.(*UpdateAnnotationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteTag",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListTags",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateSignal(ctx, req.(*CreateSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListSignals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSignalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListSignals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListSignals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListSignals(ctx, req.(*ListSignalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_GetSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).GetSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/GetSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).GetSignal(ctx, req.(*GetSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateSignal(ctx, req.(*UpdateSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_AcknowledgeSignal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeSignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).AcknowledgeSignal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/AcknowledgeSignal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).AcknowledgeSignal(ctx, req.(*AcknowledgeSignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_EscalateIncident_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EscalateIncidentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).EscalateIncident(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/EscalateIncident",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).EscalateIncident(ctx, req.(*EscalateIncidentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateArtifact(ctx, req.(*CreateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListArtifacts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListArtifacts(ctx, req.(*ListArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_UpdateArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).UpdateArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/UpdateArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).UpdateArtifact(ctx, req.(*UpdateArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteArtifact(ctx, req.(*DeleteArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_GetShiftHandoffPresets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShiftHandoffPresetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).GetShiftHandoffPresets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/GetShiftHandoffPresets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).GetShiftHandoffPresets(ctx, req.(*GetShiftHandoffPresetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_SendShiftHandoff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendShiftHandoffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).SendShiftHandoff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/SendShiftHandoff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).SendShiftHandoff(ctx, req.(*SendShiftHandoffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateSubscription(ctx, req.(*CreateSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CreateIncidentRoleAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIncidentRoleAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CreateIncidentRoleAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CreateIncidentRoleAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CreateIncidentRoleAssignment(ctx, req.(*CreateIncidentRoleAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_DeleteIncidentRoleAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIncidentRoleAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).DeleteIncidentRoleAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/DeleteIncidentRoleAssignment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).DeleteIncidentRoleAssignment(ctx, req.(*DeleteIncidentRoleAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ListIncidentRoleAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIncidentRoleAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ListIncidentRoleAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ListIncidentRoleAssignments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ListIncidentRoleAssignments(ctx, req.(*ListIncidentRoleAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_RequestIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).RequestIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/RequestIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).RequestIncidentRoleHandover(ctx, req.(*RequestIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ConfirmIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfirmIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ConfirmIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ConfirmIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ConfirmIncidentRoleHandover(ctx, req.(*ConfirmIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_ForceIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ForceIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).ForceIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/ForceIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).ForceIncidentRoleHandover(ctx, req.(*ForceIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IncidentService_CancelIncidentRoleHandover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelIncidentRoleHandoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IncidentServiceServer).CancelIncidentRoleHandover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.irm.v1alpha2.IncidentService/CancelIncidentRoleHandover",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IncidentServiceServer).CancelIncidentRoleHandover(ctx, req.(*CancelIncidentRoleHandoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IncidentService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.irm.v1alpha2.IncidentService",
	HandlerType: (*IncidentServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIncident",
			Handler:    _IncidentService_CreateIncident_Handler,
		},
		{
			MethodName: "GetIncident",
			Handler:    _IncidentService_GetIncident_Handler,
		},
		{
			MethodName: "SearchIncidents",
			Handler:    _IncidentService_SearchIncidents_Handler,
		},
		{
			MethodName: "UpdateIncident",
			Handler:    _IncidentService_UpdateIncident_Handler,
		},
		{
			MethodName: "SearchSimilarIncidents",
			Handler:    _IncidentService_SearchSimilarIncidents_Handler,
		},
		{
			MethodName: "CreateAnnotation",
			Handler:    _IncidentService_CreateAnnotation_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _IncidentService_ListAnnotations_Handler,
		},
		{
			MethodName: "UpdateAnnotation",
			Handler:    _IncidentService_UpdateAnnotation_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _IncidentService_CreateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _IncidentService_DeleteTag_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _IncidentService_ListTags_Handler,
		},
		{
			MethodName: "CreateSignal",
			Handler:    _IncidentService_CreateSignal_Handler,
		},
		{
			MethodName: "ListSignals",
			Handler:    _IncidentService_ListSignals_Handler,
		},
		{
			MethodName: "GetSignal",
			Handler:    _IncidentService_GetSignal_Handler,
		},
		{
			MethodName: "UpdateSignal",
			Handler:    _IncidentService_UpdateSignal_Handler,
		},
		{
			MethodName: "AcknowledgeSignal",
			Handler:    _IncidentService_AcknowledgeSignal_Handler,
		},
		{
			MethodName: "EscalateIncident",
			Handler:    _IncidentService_EscalateIncident_Handler,
		},
		{
			MethodName: "CreateArtifact",
			Handler:    _IncidentService_CreateArtifact_Handler,
		},
		{
			MethodName: "ListArtifacts",
			Handler:    _IncidentService_ListArtifacts_Handler,
		},
		{
			MethodName: "UpdateArtifact",
			Handler:    _IncidentService_UpdateArtifact_Handler,
		},
		{
			MethodName: "DeleteArtifact",
			Handler:    _IncidentService_DeleteArtifact_Handler,
		},
		{
			MethodName: "GetShiftHandoffPresets",
			Handler:    _IncidentService_GetShiftHandoffPresets_Handler,
		},
		{
			MethodName: "SendShiftHandoff",
			Handler:    _IncidentService_SendShiftHandoff_Handler,
		},
		{
			MethodName: "CreateSubscription",
			Handler:    _IncidentService_CreateSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _IncidentService_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _IncidentService_DeleteSubscription_Handler,
		},
		{
			MethodName: "CreateIncidentRoleAssignment",
			Handler:    _IncidentService_CreateIncidentRoleAssignment_Handler,
		},
		{
			MethodName: "DeleteIncidentRoleAssignment",
			Handler:    _IncidentService_DeleteIncidentRoleAssignment_Handler,
		},
		{
			MethodName: "ListIncidentRoleAssignments",
			Handler:    _IncidentService_ListIncidentRoleAssignments_Handler,
		},
		{
			MethodName: "RequestIncidentRoleHandover",
			Handler:    _IncidentService_RequestIncidentRoleHandover_Handler,
		},
		{
			MethodName: "ConfirmIncidentRoleHandover",
			Handler:    _IncidentService_ConfirmIncidentRoleHandover_Handler,
		},
		{
			MethodName: "ForceIncidentRoleHandover",
			Handler:    _IncidentService_ForceIncidentRoleHandover_Handler,
		},
		{
			MethodName: "CancelIncidentRoleHandover",
			Handler:    _IncidentService_CancelIncidentRoleHandover_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/irm/v1alpha2/incidents_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/irm/v1alpha2/incidents_service.proto", fileDescriptor_incidents_service_f1859dadab0f5205)
}

var fileDescriptor_incidents_service_f1859dadab0f5205 = []byte{
	// 2433 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xef, 0x6f, 0x1c, 0x47,
	0x19, 0xd6, 0xf8, 0x57, 0xec, 0xf7, 0x1c, 0xc7, 0x9d, 0x34, 0xf6, 0x79, 0xdd, 0xa4, 0xce, 0x58,
	0x4d, 0x1c, 0xa7, 0xbd, 0xb3, 0xcf, 0x49, 0x83, 0xcf, 0x4e, 0x52, 0xc7, 0x4d, 0x9d, 0x88, 0xa6,
	0x44, 0x67, 0x57, 0x88, 0x08, 0xe9, 0xb4, 0x59, 0x8f, 0xcf, 0x5b, 0xdf, 0xed, 0x5e, 0x77, 0xd7,
	0x71, 0xec, 0x12, 0x09, 0x55, 0x48, 0xa0, 0x0a, 0xbe, 0x14, 0x55, 0x20, 0x55, 0xa8, 0x12, 0x48,
	0x7c, 0x00, 0x09, 0xf8, 0x80, 0x54, 0x90, 0x40, 0x08, 0xf8, 0x13, 0xf8, 0xc0, 0xc7, 0x22, 0x04,
	0xdf, 0x90, 0xf8, 0xca, 0x47, 0xb4, 0xb3, 0x33, 0x77, 0xb3, 0x77, 0x7b, 0xb3, 0x73, 0x67, 0xac,
	0xf0, 0xcd, 0xb7, 0x3b, 0xef, 0xbc, 0xcf, 0xfb, 0xbc, 0xef, 0xcc, 0x3b, 0xfb, 0x8c, 0x61, 0xb1,
	0xe2, 0xba, 0x95, 0x2a, 0xcd, 0x5b, 0x55, 0x77, 0x7f, 0x3b, 0x6f, 0x7b, 0xb5, 0xfc, 0x93, 0x45,
	0xb3, 0x5a, 0xdf, 0x35, 0x0b, 0x79, 0xdb, 0xb1, 0xec, 0x6d, 0xea, 0x04, 0x7e, 0xd9, 0xa7, 0xde,
	0x13, 0xdb, 0xa2, 0xb9, 0xba, 0xe7, 0x06, 0x2e, 0x9e, 0x8a, 0x4c, 0x72, 0xcc, 0x24, 0x67, 0x7b,
	0xb5, 0x9c, 0x30, 0x31, 0x5e, 0xe2, 0xb3, 0x99, 0x75, 0x3b, 0x6f, 0x3a, 0x8e, 0x1b, 0x98, 0x81,
	0xed, 0x3a, 0x7e, 0x64, 0x68, 0x5c, 0xd1, 0xf0, 0xc5, 0x87, 0x4e, 0xf3, 0xa1, 0xec, 0xd7, 0xe3,
	0xfd, 0x9d, 0x3c, 0xad, 0xd5, 0x83, 0x43, 0xfe, 0x72, 0xa6, 0xf5, 0xe5, 0x8e, 0x4d, 0xab, 0xdb,
	0xe5, 0x9a, 0xe9, 0xef, 0xf1, 0x11, 0x2f, 0xb7, 0x8e, 0x08, 0xec, 0x1a, 0xf5, 0x03, 0xb3, 0x56,
	0x8f, 0x06, 0x90, 0x3a, 0x9c, 0x5b, 0xf7, 0xa8, 0x19, 0xd0, 0xfb, 0xdc, 0x71, 0x89, 0xbe, 0xbf,
	0x4f, 0xfd, 0x00, 0xdf, 0x86, 0x61, 0x81, 0x25, 0x8b, 0x66, 0xd0, 0x5c, 0xa6, 0x30, 0x9b, 0xeb,
	0x18, 0x6f, 0xae, 0x61, 0xdd, 0x30, 0xc2, 0x13, 0x30, 0x54, 0x37, 0xbd, 0xd0, 0xbc, 0x6f, 0x06,
	0xcd, 0x8d, 0x94, 0xf8, 0x2f, 0x32, 0x07, 0x78, 0x83, 0x06, 0xad, 0xee, 0x30, 0x0c, 0x38, 0x66,
	0x8d, 0x32, 0x57, 0x23, 0x25, 0xf6, 0x37, 0xf9, 0x04, 0xc1, 0xb9, 0x77, 0xeb, 0xdb, 0x27, 0x01,
	0x6e, 0x05, 0x32, 0xfb, 0x6c, 0x66, 0x46, 0x16, 0x43, 0x98, 0x29, 0x18, 0x62, 0x0e, 0xc1, 0x56,
	0xee, 0xad, 0x90, 0xcf, 0x07, 0xa6, 0xbf, 0x57, 0x82, 0x68, 0x78, 0xf8, 0x37, 0x71, 0xe1, 0xfc,
	0x26, 0x35, 0x3d, 0x6b, 0x77, 0xd3, 0xae, 0xd9, 0x55, 0xd3, 0x13, 0xf3, 0xfb, 0x8a, 0x60, 0xf0,
	0x34, 0x8c, 0xd4, 0xcd, 0x0a, 0x2d, 0xfb, 0xf6, 0x11, 0x65, 0xfe, 0x06, 0x4b, 0xc3, 0xe1, 0x83,
	0x4d, 0xfb, 0x88, 0xe2, 0xf3, 0x00, 0xec, 0x65, 0xe0, 0xee, 0x51, 0x27, 0xdb, 0xcf, 0xcc, 0xd8,
	0xf0, 0xad, 0xf0, 0x01, 0xf9, 0x37, 0x82, 0x0b, 0x9d, 0x3c, 0xfa, 0x75, 0xd7, 0xf1, 0x29, 0x7e,
	0x04, 0xa7, 0x3c, 0xea, 0xef, 0x57, 0x03, 0x3f, 0x8b, 0x66, 0xfa, 0xe7, 0x32, 0x85, 0x37, 0x14,
	0x84, 0xa8, 0xe7, 0xca, 0x95, 0xd8, 0x44, 0x25, 0x31, 0x21, 0xbe, 0x04, 0x67, 0x1c, 0xfa, 0x34,
	0x28, 0x4b, 0x10, 0xa3, 0x94, 0x9e, 0x0e, 0x1f, 0x3f, 0x14, 0x30, 0x8d, 0xfb, 0x30, 0x14, 0x99,
	0x1e, 0x3b, 0x3f, 0xe4, 0x29, 0x4c, 0x46, 0x65, 0xb9, 0xd6, 0x58, 0x3c, 0x82, 0xdc, 0x66, 0x5d,
	0x21, 0xb9, 0xae, 0xf0, 0x5d, 0x80, 0xe6, 0x4a, 0xe3, 0x19, 0x7d, 0x45, 0xe1, 0x55, 0x9a, 0x59,
	0x32, 0x24, 0x55, 0x98, 0x78, 0xdb, 0xf6, 0x83, 0xe6, 0x5b, 0x3f, 0xcd, 0xf1, 0x71, 0x32, 0xfb,
	0x11, 0x82, 0xc9, 0x36, 0x77, 0x3c, 0xa5, 0x1b, 0x90, 0x91, 0xb6, 0x0e, 0x9e, 0x56, 0xcd, 0x88,
	0x64, 0x4b, 0xdd, 0xfc, 0x91, 0xaf, 0xc3, 0x78, 0x44, 0xfa, 0x96, 0x59, 0x49, 0x0b, 0x7a, 0x01,
	0xfa, 0x03, 0xb3, 0xc2, 0x69, 0xbe, 0xa0, 0x00, 0x15, 0xce, 0x15, 0x0e, 0x25, 0x97, 0x60, 0xfc,
	0x4d, 0x5a, 0xa5, 0xb1, 0xd9, 0x93, 0x56, 0x3d, 0x85, 0x33, 0x21, 0x23, 0x5b, 0x66, 0xe5, 0x44,
	0x99, 0x77, 0x60, 0xbc, 0xe9, 0x86, 0x33, 0x5e, 0x80, 0x81, 0xc0, 0xac, 0x08, 0xaa, 0xd3, 0xa2,
	0x62, 0x63, 0xb5, 0xc9, 0xfd, 0x11, 0x82, 0xc9, 0x68, 0x33, 0x6b, 0x2f, 0xe9, 0x78, 0xe9, 0xa2,
	0x1e, 0x4b, 0xf7, 0x78, 0x9b, 0xda, 0x2e, 0x9c, 0x8d, 0x92, 0xbf, 0x69, 0x57, 0x1c, 0xb3, 0x9a,
	0x46, 0xfd, 0x32, 0x0c, 0xf9, 0x6c, 0x20, 0x77, 0x73, 0x51, 0xb5, 0xdd, 0x44, 0x33, 0x72, 0x03,
	0xf2, 0x4d, 0x04, 0x38, 0xa4, 0x3e, 0x7a, 0x9c, 0x9a, 0xe4, 0x09, 0x18, 0xda, 0xb1, 0xab, 0x01,
	0xf5, 0x44, 0x1f, 0x89, 0x7e, 0xc5, 0x93, 0xdf, 0xaf, 0x4c, 0xfe, 0x40, 0x6b, 0xf2, 0x8f, 0xe0,
	0x6c, 0x0c, 0x01, 0xcf, 0xff, 0x0a, 0x9c, 0x8a, 0x30, 0x8a, 0x12, 0xd0, 0x88, 0x4a, 0x58, 0x68,
	0x17, 0xc2, 0x25, 0x18, 0xdf, 0xa0, 0x41, 0x9c, 0xe5, 0xa4, 0x75, 0xf0, 0x3d, 0x04, 0x67, 0xa3,
	0x82, 0x89, 0x8f, 0x6d, 0x32, 0x8f, 0xba, 0x64, 0xfe, 0x78, 0x05, 0x92, 0x83, 0xec, 0x9a, 0xb5,
	0xe7, 0xb8, 0x07, 0x55, 0xba, 0x5d, 0xa1, 0xe9, 0xf8, 0xa7, 0x61, 0x2a, 0x61, 0x7c, 0xc4, 0x34,
	0xf9, 0x0c, 0xc1, 0x44, 0xd4, 0x85, 0xda, 0x9a, 0x67, 0xa7, 0x3a, 0x78, 0x11, 0x06, 0xdf, 0xdf,
	0xa7, 0xde, 0x21, 0x67, 0x35, 0xfa, 0x71, 0x9c, 0x2a, 0x08, 0x6d, 0xc3, 0xe3, 0x50, 0xf9, 0xc8,
	0x75, 0x68, 0x76, 0x90, 0xbd, 0x1d, 0x0e, 0x1f, 0x3c, 0x72, 0x1d, 0x4a, 0xbe, 0x85, 0x60, 0xb2,
	0x0d, 0x21, 0xaf, 0x93, 0x35, 0x18, 0x69, 0x9c, 0xd3, 0x78, 0xa5, 0x68, 0xf5, 0xb7, 0xa6, 0x95,
	0x76, 0xb5, 0xfc, 0xb4, 0x1f, 0x26, 0xef, 0xfa, 0x96, 0x59, 0xfd, 0x7f, 0x3b, 0x05, 0xe1, 0x07,
	0x70, 0xda, 0xdf, 0x7f, 0xec, 0x5b, 0x9e, 0x5d, 0x8f, 0x1a, 0x54, 0x3f, 0x23, 0xe2, 0xb2, 0xaa,
	0x1c, 0xa5, 0xf1, 0xa5, 0xb8, 0x75, 0x63, 0xef, 0x1d, 0xe8, 0x62, 0xef, 0xdd, 0x80, 0x41, 0xcf,
	0xad, 0x52, 0x3f, 0x3b, 0xc8, 0x8c, 0x16, 0x75, 0xa2, 0x77, 0xab, 0x74, 0xcd, 0x0f, 0xd7, 0x43,
	0x2d, 0xfc, 0x15, 0xd9, 0x87, 0x09, 0x35, 0xbd, 0xc0, 0xde, 0x31, 0xad, 0xc0, 0xcf, 0x0e, 0xa5,
	0x26, 0x74, 0x8d, 0x8f, 0x2d, 0x35, 0xad, 0xc8, 0xdf, 0xfa, 0x20, 0xdb, 0x9e, 0x28, 0x5e, 0x30,
	0xc7, 0xce, 0x54, 0x1b, 0xd9, 0x7d, 0xff, 0x13, 0xb2, 0xfb, 0xbb, 0x20, 0xfb, 0xa6, 0x20, 0x7b,
	0x20, 0xd5, 0xb5, 0x4c, 0x76, 0x22, 0xc5, 0x83, 0x3d, 0x51, 0xdc, 0xf8, 0x56, 0x69, 0xbc, 0x4c,
	0xd9, 0x32, 0x6e, 0xc3, 0xb0, 0xb0, 0xe6, 0xc5, 0xad, 0xe5, 0xb2, 0x61, 0x44, 0xde, 0x83, 0x17,
	0xd9, 0xe9, 0x4c, 0x40, 0x38, 0xc9, 0x03, 0xc9, 0x87, 0x08, 0xce, 0xb5, 0x38, 0x6b, 0x6e, 0x37,
	0x4d, 0xea, 0x50, 0x2f, 0xd4, 0x69, 0x6f, 0x37, 0xcd, 0x4f, 0xae, 0x56, 0x8e, 0x65, 0x2e, 0x51,
	0x0f, 0x5c, 0x1e, 0xaf, 0xf9, 0x5c, 0x85, 0x73, 0xd1, 0xe1, 0xb1, 0x15, 0x56, 0x52, 0xe7, 0xb9,
	0x01, 0xe7, 0xc3, 0x0e, 0xbb, 0x6b, 0xef, 0x04, 0xf7, 0x4c, 0x67, 0xdb, 0xdd, 0xd9, 0x79, 0xe8,
	0x51, 0x9f, 0xa6, 0xa6, 0x8f, 0x94, 0xe1, 0x6c, 0x82, 0x15, 0xbe, 0x00, 0xe0, 0x51, 0xcb, 0xae,
	0xdb, 0x8d, 0xfd, 0x7e, 0xa4, 0x24, 0x3d, 0xc1, 0x63, 0xd0, 0x67, 0x59, 0x6c, 0x45, 0x8e, 0x94,
	0xfa, 0x2c, 0x0b, 0x67, 0xe1, 0x94, 0xbf, 0xff, 0xf8, 0x3d, 0x6a, 0x05, 0x3c, 0xcb, 0xe2, 0x27,
	0xf9, 0x57, 0x5f, 0xd8, 0x54, 0x9c, 0x6d, 0xd9, 0x4b, 0x5a, 0x4d, 0xc5, 0xbd, 0xf7, 0x75, 0xf0,
	0xde, 0x9f, 0xe4, 0x7d, 0x20, 0xe6, 0x1d, 0xbf, 0x0a, 0xd8, 0x71, 0x03, 0xea, 0x97, 0x2d, 0xd7,
	0x09, 0xa8, 0x13, 0x94, 0x83, 0xc3, 0xba, 0x68, 0x7c, 0xe3, 0xec, 0xcd, 0x7a, 0xf4, 0x62, 0xeb,
	0xb0, 0x4e, 0xf1, 0x2c, 0x9c, 0x8e, 0x8d, 0xce, 0x0e, 0xb1, 0x81, 0xa3, 0xf2, 0x40, 0xfc, 0x35,
	0xb9, 0x13, 0x9e, 0x62, 0xa5, 0xb9, 0xa2, 0xfc, 0xf0, 0x4c, 0x8c, 0x3d, 0xb1, 0x43, 0x5e, 0x84,
	0xd1, 0xba, 0x47, 0x9f, 0xd8, 0xf4, 0xa0, 0xec, 0x3a, 0xd5, 0xc3, 0xec, 0xf0, 0x0c, 0x9a, 0x1b,
	0x2e, 0x65, 0xf8, 0xb3, 0xaf, 0x38, 0xd5, 0x43, 0xe3, 0x02, 0x0c, 0x0b, 0xcb, 0xc4, 0x42, 0xf8,
	0x2a, 0x64, 0xdb, 0x3d, 0xf2, 0x45, 0x75, 0x11, 0x46, 0x63, 0x34, 0x44, 0x76, 0x19, 0x4b, 0x62,
	0x20, 0x0b, 0xa7, 0x44, 0xec, 0xd1, 0x62, 0x11, 0x3f, 0xc3, 0x23, 0xec, 0x14, 0x3f, 0x2d, 0xcb,
	0xbb, 0x6c, 0x4a, 0x26, 0xbf, 0x0c, 0xa3, 0xf2, 0x36, 0xcc, 0x97, 0x80, 0xf6, 0x1e, 0x1e, 0x33,
	0x26, 0x0e, 0x64, 0xd9, 0x11, 0x56, 0xde, 0xd7, 0x4f, 0x72, 0x7b, 0xfa, 0x18, 0xc1, 0x54, 0x82,
	0x43, 0xce, 0x66, 0x5b, 0x7f, 0x42, 0xc7, 0xea, 0x4f, 0xba, 0xdb, 0x55, 0x1e, 0xa6, 0xa2, 0x6d,
	0x21, 0x29, 0x0d, 0x49, 0x15, 0xf1, 0x33, 0x04, 0xb3, 0x2d, 0x7a, 0x57, 0xfc, 0x40, 0x90, 0xc2,
	0xe0, 0x1e, 0x64, 0x45, 0x85, 0x96, 0xc3, 0xbe, 0x56, 0x36, 0x1b, 0xa6, 0x3c, 0x9d, 0x3d, 0x1c,
	0x42, 0x26, 0xec, 0xc4, 0xe7, 0x64, 0x19, 0x66, 0xa3, 0xe8, 0xd4, 0x58, 0x93, 0xe2, 0x7c, 0x0a,
	0x24, 0x4c, 0x56, 0xb2, 0xe1, 0x89, 0xd6, 0xc9, 0xef, 0x10, 0xcc, 0x2a, 0x5d, 0xf3, 0x8a, 0xa9,
	0xc1, 0x54, 0x27, 0x26, 0x45, 0xf5, 0xf4, 0x40, 0xe5, 0x64, 0x32, 0x95, 0xfa, 0x15, 0xf5, 0x0d,
	0x20, 0x9c, 0x1d, 0xd9, 0x03, 0xdb, 0x3c, 0x9e, 0x50, 0x4f, 0x25, 0xf0, 0xdd, 0x81, 0x51, 0x87,
	0x1e, 0xf0, 0x30, 0x28, 0xe5, 0xe5, 0xf0, 0xb2, 0x22, 0x86, 0x77, 0x7d, 0xea, 0x95, 0x32, 0x0e,
	0x3d, 0x58, 0xe3, 0x36, 0xa1, 0xf7, 0x75, 0xd7, 0xd9, 0xb1, 0xbd, 0xda, 0xf3, 0xf0, 0x7e, 0x04,
	0x33, 0x6f, 0xb9, 0x9e, 0x45, 0x9f, 0x87, 0xef, 0x0f, 0xe0, 0xe2, 0xba, 0xe9, 0x58, 0xb4, 0xfa,
	0x1c, 0x9c, 0x17, 0xbe, 0xbd, 0x00, 0x67, 0x84, 0xdf, 0xcd, 0x48, 0xe2, 0xc7, 0x3f, 0x46, 0x30,
	0x16, 0xdf, 0x29, 0xf0, 0x82, 0x62, 0xd2, 0x44, 0x11, 0xdd, 0xd0, 0x39, 0xe5, 0x93, 0xe5, 0x0f,
	0xff, 0xf2, 0x8f, 0xef, 0xf7, 0x2d, 0x91, 0xcb, 0xcd, 0x5b, 0x80, 0x0f, 0xa2, 0x85, 0x78, 0xb3,
	0xee, 0xb9, 0x61, 0xe7, 0xf6, 0xf3, 0xf3, 0xcf, 0x9a, 0x37, 0x03, 0xc5, 0xe6, 0x67, 0xc1, 0xc7,
	0x08, 0x32, 0x92, 0x98, 0x8e, 0x5f, 0x53, 0xf8, 0x6b, 0x17, 0xdd, 0xf5, 0xe0, 0xe5, 0x19, 0xbc,
	0x2b, 0x58, 0x86, 0x17, 0x32, 0x2f, 0x81, 0x6b, 0x62, 0xcb, 0xcf, 0x3f, 0xc3, 0xbf, 0x42, 0x70,
	0xa6, 0xe5, 0xcb, 0x19, 0x2f, 0xa6, 0xaa, 0xd1, 0xad, 0x3a, 0x80, 0x51, 0xe8, 0xc6, 0x84, 0xcb,
	0x0a, 0xaf, 0x33, 0xac, 0x0b, 0x38, 0xa7, 0x4b, 0xa5, 0xcf, 0x26, 0xc2, 0x3f, 0x47, 0x30, 0x16,
	0xbf, 0x69, 0x50, 0x26, 0x3b, 0xf1, 0x52, 0x42, 0x8f, 0xcd, 0x3b, 0x0c, 0xe1, 0x6a, 0x61, 0x41,
	0x42, 0x28, 0xe0, 0xe4, 0x54, 0xb4, 0x4a, 0x59, 0xff, 0x6e, 0x9f, 0x10, 0x4f, 0x5a, 0x25, 0x7c,
	0xfc, 0xa5, 0x1e, 0x54, 0xff, 0x08, 0xfd, 0x72, 0xcf, 0xf7, 0x05, 0xe4, 0x19, 0x8b, 0xe9, 0x00,
	0x5f, 0xd7, 0xac, 0x10, 0xce, 0x3a, 0x9f, 0xef, 0xd1, 0x2d, 0xbc, 0xaa, 0x30, 0xe4, 0xf2, 0x5a,
	0x9b, 0x59, 0x33, 0xe6, 0xdf, 0x20, 0xa1, 0x5b, 0x37, 0x75, 0x51, 0x5c, 0x48, 0x5d, 0xab, 0x6d,
	0x32, 0xac, 0xa1, 0x27, 0xb9, 0x92, 0xfb, 0x2c, 0xdc, 0x75, 0x72, 0x5d, 0x55, 0x64, 0xb1, 0x80,
	0xe5, 0x2b, 0xc0, 0xa2, 0xac, 0xd8, 0x7e, 0x8e, 0x22, 0xb1, 0x5b, 0x92, 0xff, 0x95, 0x4b, 0x25,
	0xf9, 0x66, 0x42, 0xb9, 0x54, 0x3a, 0xdc, 0x2e, 0x90, 0x9b, 0x2c, 0x8a, 0x1b, 0xb8, 0xb7, 0x28,
	0xf0, 0x9f, 0x11, 0x8c, 0xb7, 0xca, 0xd9, 0x4a, 0xd2, 0x3b, 0x68, 0xdf, 0xba, 0xa4, 0x6f, 0x31,
	0xb8, 0xef, 0x14, 0xde, 0x90, 0xe0, 0x36, 0xf1, 0xa8, 0x56, 0x8e, 0x0c, 0x3b, 0xac, 0x22, 0x99,
	0xff, 0x4f, 0x10, 0x8c, 0x34, 0xae, 0x3c, 0xf0, 0xd5, 0xd4, 0x9a, 0x69, 0x5e, 0x5d, 0x18, 0x29,
	0xa2, 0x09, 0x59, 0x61, 0x80, 0xaf, 0x93, 0x9c, 0x3e, 0xbf, 0x81, 0x59, 0xf1, 0x8b, 0xfd, 0x81,
	0x59, 0xc1, 0xdf, 0x41, 0x30, 0xd2, 0xb8, 0x2c, 0x51, 0xe2, 0x6a, 0xbd, 0x52, 0x31, 0x26, 0xda,
	0xbe, 0xa8, 0xef, 0xd6, 0xea, 0xc1, 0xa1, 0xd8, 0x1a, 0xe7, 0x73, 0x7a, 0x8b, 0x94, 0x81, 0x09,
	0x77, 0xf3, 0x4f, 0x11, 0x0c, 0x8b, 0x8b, 0x12, 0x3c, 0x9f, 0x52, 0x68, 0xd2, 0xa5, 0x8d, 0x71,
	0x55, 0x6b, 0x6c, 0x37, 0x1b, 0x77, 0x3b, 0x5b, 0xf8, 0x87, 0x08, 0x46, 0xe5, 0x6b, 0x0b, 0x9c,
	0x4b, 0xcd, 0x61, 0x4c, 0xb9, 0x36, 0xd2, 0xd5, 0x73, 0x72, 0x9d, 0x61, 0xcb, 0x93, 0x57, 0xd4,
	0x4d, 0x85, 0x6f, 0x54, 0x45, 0x21, 0xb6, 0x7f, 0x8a, 0x20, 0x23, 0x5d, 0x32, 0x28, 0x7b, 0x73,
	0xfb, 0x75, 0x88, 0x91, 0xd3, 0x1d, 0xce, 0x19, 0x7c, 0x8d, 0xa1, 0xbc, 0x8c, 0xf5, 0x50, 0xe2,
	0x8f, 0x10, 0x8c, 0x34, 0xae, 0x21, 0x94, 0x15, 0xd6, 0x7a, 0x59, 0xa1, 0x43, 0x59, 0x12, 0x98,
	0xce, 0x1b, 0x3b, 0xfe, 0x0c, 0xc1, 0xa8, 0x7c, 0xd5, 0xa1, 0xcc, 0x62, 0xc2, 0x9d, 0x88, 0x0e,
	0xa4, 0x55, 0x06, 0xe9, 0xf5, 0xc2, 0xab, 0x12, 0xa4, 0x08, 0x42, 0x4e, 0xd1, 0x72, 0x44, 0x32,
	0x7f, 0x8d, 0xe0, 0x85, 0xb6, 0xdb, 0x0c, 0xbc, 0xa4, 0xda, 0xbb, 0x3a, 0xdc, 0x95, 0x18, 0xd7,
	0xba, 0x33, 0xe2, 0xe9, 0xbd, 0xc6, 0xe0, 0xe7, 0xc8, 0x15, 0xbd, 0x56, 0x69, 0x5a, 0x7b, 0x45,
	0x34, 0x8f, 0xff, 0x88, 0x60, 0xbc, 0x55, 0x94, 0x56, 0xee, 0xd2, 0x1d, 0xae, 0x1a, 0x8c, 0xa5,
	0xae, 0x6c, 0x38, 0xe6, 0x37, 0x19, 0xe6, 0x5b, 0x64, 0xb9, 0xeb, 0xb3, 0x0e, 0xe5, 0x53, 0x86,
	0x31, 0xfc, 0xa2, 0x71, 0x10, 0x17, 0xda, 0x9f, 0xc6, 0x41, 0xbc, 0x45, 0x26, 0x34, 0x74, 0xb4,
	0x4a, 0x72, 0x97, 0xe1, 0xbd, 0x4d, 0x96, 0xba, 0x68, 0x89, 0x42, 0x61, 0x2d, 0x36, 0x85, 0xce,
	0x5f, 0x22, 0x38, 0x1d, 0x13, 0x72, 0x71, 0x3e, 0xad, 0x3f, 0xb7, 0xe8, 0xcb, 0xc6, 0x82, 0xbe,
	0x01, 0xe7, 0x9a, 0xb7, 0x1b, 0xdc, 0x0b, 0xf6, 0xf0, 0x18, 0x32, 0x16, 0x57, 0x7d, 0x35, 0x8e,
	0xbf, 0x3d, 0x51, 0xfc, 0x0e, 0x83, 0x79, 0xaf, 0x20, 0x9f, 0xf8, 0x04, 0x0e, 0x75, 0x13, 0x17,
	0x60, 0xd9, 0x51, 0xb8, 0xc1, 0xf5, 0x0f, 0x10, 0x8c, 0xc5, 0x85, 0x61, 0x25, 0xf2, 0x44, 0x0d,
	0xb9, 0x63, 0xcb, 0xe4, 0x9c, 0xce, 0x2f, 0x69, 0xb6, 0x4c, 0x19, 0x23, 0xfe, 0x3d, 0x82, 0x89,
	0x64, 0x15, 0x5a, 0x79, 0x48, 0x57, 0x0a, 0xd7, 0xca, 0xa6, 0x90, 0x60, 0x26, 0x3e, 0x2d, 0xf1,
	0x62, 0x4a, 0x53, 0x48, 0x00, 0xf9, 0x39, 0x82, 0xf1, 0x56, 0xf1, 0x14, 0x17, 0xba, 0xd7, 0x76,
	0x95, 0x5b, 0x47, 0x27, 0x75, 0x96, 0x14, 0x19, 0xf0, 0x6b, 0x24, 0xaf, 0x0f, 0xbc, 0xe8, 0x53,
	0x67, 0x3b, 0xdc, 0x30, 0xfe, 0x84, 0x00, 0xb7, 0x8b, 0xb3, 0xf8, 0x5a, 0xfa, 0xc9, 0xa0, 0x5d,
	0x44, 0x34, 0x74, 0x15, 0x4c, 0xf2, 0x80, 0x21, 0xde, 0x20, 0x37, 0xf4, 0x17, 0x60, 0x4c, 0xf3,
	0x2c, 0xc6, 0xe4, 0x5d, 0xfc, 0x07, 0x04, 0x2f, 0xb4, 0xc9, 0xad, 0xca, 0x86, 0xd3, 0x49, 0x0d,
	0x56, 0x36, 0x9c, 0x8e, 0x8a, 0x2e, 0xb9, 0xcd, 0xe2, 0x59, 0xc6, 0xbd, 0xc6, 0x83, 0x7f, 0x82,
	0x00, 0xb7, 0x8b, 0xb3, 0xca, 0x34, 0x74, 0xd4, 0x72, 0x3b, 0x2e, 0x51, 0x8e, 0x72, 0xfe, 0x86,
	0xe6, 0x12, 0x8d, 0x41, 0x0c, 0x97, 0xe9, 0x5f, 0x11, 0xbc, 0xa4, 0x12, 0x84, 0xf1, 0x2d, 0x7d,
	0xd1, 0x27, 0x49, 0x9d, 0x35, 0xba, 0x17, 0x31, 0x13, 0xfb, 0x66, 0x0a, 0xf5, 0x5e, 0x5c, 0xee,
	0x0c, 0x97, 0xc1, 0x6f, 0x11, 0xbc, 0xa4, 0x92, 0x8f, 0x95, 0x91, 0x69, 0xe8, 0xce, 0x1d, 0x73,
	0xb2, 0xc6, 0xe0, 0xaf, 0xcc, 0x2f, 0x6b, 0xe6, 0xa4, 0x05, 0x7b, 0x98, 0x95, 0x2f, 0x10, 0x4c,
	0x2b, 0x44, 0x64, 0x7c, 0x33, 0xa5, 0xa4, 0xd5, 0xba, 0xb7, 0x71, 0xab, 0x57, 0x73, 0xbe, 0x36,
	0x78, 0x84, 0xb8, 0xf7, 0x04, 0xe1, 0x7f, 0x22, 0x98, 0x56, 0x08, 0xcd, 0xca, 0x08, 0xd3, 0x05,
	0xea, 0x5e, 0xaa, 0x8e, 0x7f, 0x61, 0x93, 0xfb, 0x3d, 0xa7, 0xad, 0xe8, 0x45, 0xde, 0x05, 0x98,
	0xb0, 0x0a, 0xc3, 0x38, 0x15, 0x92, 0xb6, 0x32, 0xce, 0x74, 0x29, 0xfc, 0x39, 0xc5, 0x69, 0x45,
	0xc0, 0xe4, 0x38, 0xbf, 0x40, 0x30, 0xd5, 0x51, 0x3c, 0xc7, 0xaa, 0x3b, 0xd1, 0x34, 0xc9, 0xbd,
	0x97, 0x18, 0x4b, 0x2c, 0xc6, 0xb7, 0xc9, 0x46, 0xef, 0x31, 0xee, 0x84, 0xb0, 0xe4, 0x08, 0xff,
	0x8e, 0xc0, 0xe8, 0x2c, 0xd1, 0xe3, 0x55, 0x55, 0x22, 0xd3, 0x94, 0xfd, 0x5e, 0x62, 0xdc, 0x64,
	0x31, 0x3e, 0x20, 0xf7, 0x8e, 0x91, 0x47, 0x86, 0x4b, 0x0a, 0xf2, 0xce, 0x2e, 0xcc, 0x5a, 0x6e,
	0x4d, 0x80, 0x09, 0x61, 0x88, 0x7f, 0xf9, 0x6f, 0xc0, 0x31, 0xeb, 0xf6, 0x43, 0xf4, 0x68, 0x95,
	0x0f, 0xa9, 0xb8, 0x55, 0xd3, 0xa9, 0xe4, 0x5c, 0xaf, 0x92, 0xaf, 0x50, 0x87, 0xed, 0x84, 0xf9,
	0xe8, 0x95, 0x59, 0xb7, 0xfd, 0x84, 0xff, 0xf0, 0x5f, 0xb1, 0xbd, 0xda, 0x7f, 0x10, 0x7a, 0x3c,
	0xc4, 0xc6, 0x2e, 0xfd, 0x37, 0x00, 0x00, 0xff, 0xff, 0x4b, 0x0b, 0xd1, 0xee, 0x78, 0x30, 0x00,
	0x00,
}
