// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/filters.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import date "google.golang.org/genproto/googleapis/type/date"
import latlng "google.golang.org/genproto/googleapis/type/latlng"
import timeofday "google.golang.org/genproto/googleapis/type/timeofday"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Specify whether including telecommute jobs.
type LocationFilter_TelecommutePreference int32

const (
	// Default value if the telecommute preference isn't specified.
	LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED LocationFilter_TelecommutePreference = 0
	// Exclude telecommute jobs.
	LocationFilter_TELECOMMUTE_EXCLUDED LocationFilter_TelecommutePreference = 1
	// Allow telecommute jobs.
	LocationFilter_TELECOMMUTE_ALLOWED LocationFilter_TelecommutePreference = 2
)

var LocationFilter_TelecommutePreference_name = map[int32]string{
	0: "TELECOMMUTE_PREFERENCE_UNSPECIFIED",
	1: "TELECOMMUTE_EXCLUDED",
	2: "TELECOMMUTE_ALLOWED",
}
var LocationFilter_TelecommutePreference_value = map[string]int32{
	"TELECOMMUTE_PREFERENCE_UNSPECIFIED": 0,
	"TELECOMMUTE_EXCLUDED":               1,
	"TELECOMMUTE_ALLOWED":                2,
}

func (x LocationFilter_TelecommutePreference) String() string {
	return proto.EnumName(LocationFilter_TelecommutePreference_name, int32(x))
}
func (LocationFilter_TelecommutePreference) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{2, 0}
}

// Specify the type of filtering.
type CompensationFilter_FilterType int32

const (
	// Filter type unspecified. Position holder, INVALID, should never be used.
	CompensationFilter_FILTER_TYPE_UNSPECIFIED CompensationFilter_FilterType = 0
	// Filter by `base compensation entry's` unit. A job is a match if and
	// only if the job contains a base CompensationEntry and the base
	// CompensationEntry's unit matches provided [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	// Populate one or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	//
	// See [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry] for definition of
	// base compensation entry.
	CompensationFilter_UNIT_ONLY CompensationFilter_FilterType = 1
	// Filter by `base compensation entry's` unit and amount / range. A job
	// is a match if and only if the job contains a base CompensationEntry, and
	// the base entry's unit matches provided [compensation_units][] and amount
	// or range overlaps with provided [compensation_range][].
	//
	// See [CompensationInfo.CompensationEntry][google.cloud.talent.v4beta1.CompensationInfo.CompensationEntry] for definition of
	// base compensation entry.
	//
	// Set exactly one [units][google.cloud.talent.v4beta1.CompensationFilter.units] and populate [range][google.cloud.talent.v4beta1.CompensationFilter.range].
	CompensationFilter_UNIT_AND_AMOUNT CompensationFilter_FilterType = 2
	// Filter by annualized base compensation amount and `base compensation
	// entry's` unit. Populate [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_BASE_AMOUNT CompensationFilter_FilterType = 3
	// Filter by annualized total compensation amount and `base compensation
	// entry's` unit . Populate [range][google.cloud.talent.v4beta1.CompensationFilter.range] and zero or more [units][google.cloud.talent.v4beta1.CompensationFilter.units].
	CompensationFilter_ANNUALIZED_TOTAL_AMOUNT CompensationFilter_FilterType = 4
)

var CompensationFilter_FilterType_name = map[int32]string{
	0: "FILTER_TYPE_UNSPECIFIED",
	1: "UNIT_ONLY",
	2: "UNIT_AND_AMOUNT",
	3: "ANNUALIZED_BASE_AMOUNT",
	4: "ANNUALIZED_TOTAL_AMOUNT",
}
var CompensationFilter_FilterType_value = map[string]int32{
	"FILTER_TYPE_UNSPECIFIED": 0,
	"UNIT_ONLY":               1,
	"UNIT_AND_AMOUNT":         2,
	"ANNUALIZED_BASE_AMOUNT":  3,
	"ANNUALIZED_TOTAL_AMOUNT": 4,
}

func (x CompensationFilter_FilterType) String() string {
	return proto.EnumName(CompensationFilter_FilterType_name, int32(x))
}
func (CompensationFilter_FilterType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{3, 0}
}

// Method for commute.
type CommuteFilter_CommuteMethod int32

const (
	// Commute method isn't specified.
	CommuteFilter_COMMUTE_METHOD_UNSPECIFIED CommuteFilter_CommuteMethod = 0
	// Commute time is calculated based on driving time.
	CommuteFilter_DRIVING CommuteFilter_CommuteMethod = 1
	// Commute time is calculated based on public transit including bus, metro,
	// subway, etc.
	CommuteFilter_TRANSIT CommuteFilter_CommuteMethod = 2
	// Commute time is calculated based on walking time.
	CommuteFilter_WALKING CommuteFilter_CommuteMethod = 3
	// Commute time is calculated based on biking time.
	CommuteFilter_BICYCLING CommuteFilter_CommuteMethod = 4
	// Commute time is calculated based on public transit that is wheelchair
	// accessible.
	CommuteFilter_TRANSIT_ACCESSIBLE CommuteFilter_CommuteMethod = 5
)

var CommuteFilter_CommuteMethod_name = map[int32]string{
	0: "COMMUTE_METHOD_UNSPECIFIED",
	1: "DRIVING",
	2: "TRANSIT",
	3: "WALKING",
	4: "BICYCLING",
	5: "TRANSIT_ACCESSIBLE",
}
var CommuteFilter_CommuteMethod_value = map[string]int32{
	"COMMUTE_METHOD_UNSPECIFIED": 0,
	"DRIVING":                    1,
	"TRANSIT":                    2,
	"WALKING":                    3,
	"BICYCLING":                  4,
	"TRANSIT_ACCESSIBLE":         5,
}

func (x CommuteFilter_CommuteMethod) String() string {
	return proto.EnumName(CommuteFilter_CommuteMethod_name, int32(x))
}
func (CommuteFilter_CommuteMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{4, 0}
}

// The traffic density to use when calculating commute time.
type CommuteFilter_RoadTraffic int32

const (
	// Road traffic situation isn't specified.
	CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED CommuteFilter_RoadTraffic = 0
	// Optimal commute time without considering any traffic impact.
	CommuteFilter_TRAFFIC_FREE CommuteFilter_RoadTraffic = 1
	// Commute time calculation takes in account the peak traffic impact.
	CommuteFilter_BUSY_HOUR CommuteFilter_RoadTraffic = 2
)

var CommuteFilter_RoadTraffic_name = map[int32]string{
	0: "ROAD_TRAFFIC_UNSPECIFIED",
	1: "TRAFFIC_FREE",
	2: "BUSY_HOUR",
}
var CommuteFilter_RoadTraffic_value = map[string]int32{
	"ROAD_TRAFFIC_UNSPECIFIED": 0,
	"TRAFFIC_FREE":             1,
	"BUSY_HOUR":                2,
}

func (x CommuteFilter_RoadTraffic) String() string {
	return proto.EnumName(CommuteFilter_RoadTraffic_name, int32(x))
}
func (CommuteFilter_RoadTraffic) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{4, 1}
}

// Enum indicating which set of [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records] to search
// against.
type EmployerFilter_EmployerFilterMode int32

const (
	// Default value.
	EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED EmployerFilter_EmployerFilterMode = 0
	// Apply to all employers in [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_ALL_EMPLOYMENT_RECORDS EmployerFilter_EmployerFilterMode = 1
	// Apply only to current employer in [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_CURRENT_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 2
	// Apply only to past (not current) employers in
	// [Profile.employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	EmployerFilter_PAST_EMPLOYMENT_RECORDS_ONLY EmployerFilter_EmployerFilterMode = 3
)

var EmployerFilter_EmployerFilterMode_name = map[int32]string{
	0: "EMPLOYER_FILTER_MODE_UNSPECIFIED",
	1: "ALL_EMPLOYMENT_RECORDS",
	2: "CURRENT_EMPLOYMENT_RECORDS_ONLY",
	3: "PAST_EMPLOYMENT_RECORDS_ONLY",
}
var EmployerFilter_EmployerFilterMode_value = map[string]int32{
	"EMPLOYER_FILTER_MODE_UNSPECIFIED": 0,
	"ALL_EMPLOYMENT_RECORDS":           1,
	"CURRENT_EMPLOYMENT_RECORDS_ONLY":  2,
	"PAST_EMPLOYMENT_RECORDS_ONLY":     3,
}

func (x EmployerFilter_EmployerFilterMode) String() string {
	return proto.EnumName(EmployerFilter_EmployerFilterMode_name, int32(x))
}
func (EmployerFilter_EmployerFilterMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{7, 0}
}

// Time fields can be used in TimeFilter.
type TimeFilter_TimeField int32

const (
	// Default value.
	TimeFilter_TIME_FIELD_UNSPECIFIED TimeFilter_TimeField = 0
	// Earliest profile create time.
	TimeFilter_CREATE_TIME TimeFilter_TimeField = 1
	// Latest profile update time.
	TimeFilter_UPDATE_TIME TimeFilter_TimeField = 2
)

var TimeFilter_TimeField_name = map[int32]string{
	0: "TIME_FIELD_UNSPECIFIED",
	1: "CREATE_TIME",
	2: "UPDATE_TIME",
}
var TimeFilter_TimeField_value = map[string]int32{
	"TIME_FIELD_UNSPECIFIED": 0,
	"CREATE_TIME":            1,
	"UPDATE_TIME":            2,
}

func (x TimeFilter_TimeField) String() string {
	return proto.EnumName(TimeFilter_TimeField_name, int32(x))
}
func (TimeFilter_TimeField) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{15, 0}
}

// Input only.
//
// The query required to perform a search query.
type JobQuery struct {
	// Optional.
	//
	// The query string that matches against the job title, description, and
	// location fields.
	//
	// The maximum number of allowed characters is 255.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Optional.
	//
	// This filter specifies the company entities to search against.
	//
	// If a value isn't specified, jobs are searched for against all
	// companies.
	//
	// If multiple values are specified, jobs are searched against the
	// companies specified.
	//
	// The format is "projects/{project_id}/companies/{company_id}", for example,
	// "projects/api-test-project/companies/foo".
	//
	// At most 20 company filters are allowed.
	CompanyNames []string `protobuf:"bytes,2,rep,name=company_names,json=companyNames,proto3" json:"company_names,omitempty"`
	// Optional.
	//
	// The location filter specifies geo-regions containing the jobs to
	// search against. See [LocationFilter][google.cloud.talent.v4beta1.LocationFilter] for more information.
	//
	// If a location value isn't specified, jobs fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If multiple values are specified, jobs are retrieved from any of the
	// specified locations. If different values are specified for the
	// [LocationFilter.distance_in_miles][google.cloud.talent.v4beta1.LocationFilter.distance_in_miles] parameter, the maximum provided
	// distance is used for all locations.
	//
	// At most 5 location filters are allowed.
	LocationFilters []*LocationFilter `protobuf:"bytes,3,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// Optional.
	//
	// The category filter specifies the categories of jobs to search against.
	// See [Category][] for more information.
	//
	// If a value isn't specified, jobs from any category are searched against.
	//
	// If multiple values are specified, jobs from any of the specified
	// categories are searched against.
	JobCategories []JobCategory `protobuf:"varint,4,rep,packed,name=job_categories,json=jobCategories,proto3,enum=google.cloud.talent.v4beta1.JobCategory" json:"job_categories,omitempty"`
	// Optional.
	//
	//  Allows filtering jobs by commute time with different travel methods (for
	//  example, driving or public transit). Note: This only works with [COMMUTE
	//  MODE][Mode#COMMUTE]. When specified, [JobQuery.location_filters] is
	//  ignored.
	//
	//  Currently we don't support sorting by commute time.
	CommuteFilter *CommuteFilter `protobuf:"bytes,5,opt,name=commute_filter,json=commuteFilter,proto3" json:"commute_filter,omitempty"`
	// Optional.
	//
	// This filter specifies the exact [company display
	// name][Company.display_name] of the jobs to search against.
	//
	// If a value isn't specified, jobs within the search results are
	// associated with any company.
	//
	// If multiple values are specified, jobs within the search results may be
	// associated with any of the specified companies.
	//
	// At most 20 company display name filters are allowed.
	CompanyDisplayNames []string `protobuf:"bytes,6,rep,name=company_display_names,json=companyDisplayNames,proto3" json:"company_display_names,omitempty"`
	// Optional.
	//
	// This search filter is applied only to
	// [Job.compensation_info][google.cloud.talent.v4beta1.Job.compensation_info]. For example, if the filter is specified
	// as "Hourly job with per-hour compensation > $15", only jobs meeting
	// these criteria are searched. If a filter isn't defined, all open jobs
	// are searched.
	CompensationFilter *CompensationFilter `protobuf:"bytes,7,opt,name=compensation_filter,json=compensationFilter,proto3" json:"compensation_filter,omitempty"`
	// Optional.
	//
	// This filter specifies a structured syntax to match against the
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes] marked as `filterable`.
	//
	// The syntax for this expression is a subset of SQL syntax.
	//
	// Supported operators are: `=`, `!=`, `<`, `<=`, `>`, and `>=` where the
	// left of the operator is a custom field key and the right of the operator
	// is a number or a quoted string. You must escape backslash (\\) and
	// quote (\") characters.
	//
	// Supported functions are `LOWER([field_name])` to
	// perform a case insensitive match and `EMPTY([field_name])` to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
	// comparisons or functions are allowed in the expression. The expression
	// must be < 3000 bytes in length.
	//
	// Sample Query:
	// `(LOWER(driving_license)="class \"a\"" OR EMPTY(driving_license)) AND
	// driving_years > 10`
	CustomAttributeFilter string `protobuf:"bytes,8,opt,name=custom_attribute_filter,json=customAttributeFilter,proto3" json:"custom_attribute_filter,omitempty"`
	// Optional.
	//
	// This flag controls the spell-check feature. If false, the
	// service attempts to correct a misspelled query,
	// for example, "enginee" is corrected to "engineer".
	//
	// Defaults to false: a spell check is performed.
	DisableSpellCheck bool `protobuf:"varint,9,opt,name=disable_spell_check,json=disableSpellCheck,proto3" json:"disable_spell_check,omitempty"`
	// Optional.
	//
	// The employment type filter specifies the employment type of jobs to
	// search against, such as [EmploymentType.FULL_TIME][google.cloud.talent.v4beta1.EmploymentType.FULL_TIME].
	//
	// If a value isn't specified, jobs in the search results includes any
	// employment type.
	//
	// If multiple values are specified, jobs in the search results include
	// any of the specified employment types.
	EmploymentTypes []EmploymentType `protobuf:"varint,10,rep,packed,name=employment_types,json=employmentTypes,proto3,enum=google.cloud.talent.v4beta1.EmploymentType" json:"employment_types,omitempty"`
	// Optional.
	//
	// This filter specifies the locale of jobs to search against,
	// for example, "en-US".
	//
	// If a value isn't specified, the search results can contain jobs in any
	// locale.
	//
	//
	// Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
	//
	// At most 10 language code filters are allowed.
	LanguageCodes []string `protobuf:"bytes,11,rep,name=language_codes,json=languageCodes,proto3" json:"language_codes,omitempty"`
	// Optional.
	//
	// Jobs published within a range specified by this filter are searched
	// against.
	PublishTimeRange *TimestampRange `protobuf:"bytes,12,opt,name=publish_time_range,json=publishTimeRange,proto3" json:"publish_time_range,omitempty"`
	// Optional.
	//
	// This filter specifies a list of job names to be excluded during search.
	//
	// At most 200 excluded job names are allowed.
	ExcludedJobs         []string `protobuf:"bytes,13,rep,name=excluded_jobs,json=excludedJobs,proto3" json:"excluded_jobs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobQuery) Reset()         { *m = JobQuery{} }
func (m *JobQuery) String() string { return proto.CompactTextString(m) }
func (*JobQuery) ProtoMessage()    {}
func (*JobQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{0}
}
func (m *JobQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobQuery.Unmarshal(m, b)
}
func (m *JobQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobQuery.Marshal(b, m, deterministic)
}
func (dst *JobQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobQuery.Merge(dst, src)
}
func (m *JobQuery) XXX_Size() int {
	return xxx_messageInfo_JobQuery.Size(m)
}
func (m *JobQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_JobQuery.DiscardUnknown(m)
}

var xxx_messageInfo_JobQuery proto.InternalMessageInfo

func (m *JobQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *JobQuery) GetCompanyNames() []string {
	if m != nil {
		return m.CompanyNames
	}
	return nil
}

func (m *JobQuery) GetLocationFilters() []*LocationFilter {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *JobQuery) GetJobCategories() []JobCategory {
	if m != nil {
		return m.JobCategories
	}
	return nil
}

func (m *JobQuery) GetCommuteFilter() *CommuteFilter {
	if m != nil {
		return m.CommuteFilter
	}
	return nil
}

func (m *JobQuery) GetCompanyDisplayNames() []string {
	if m != nil {
		return m.CompanyDisplayNames
	}
	return nil
}

func (m *JobQuery) GetCompensationFilter() *CompensationFilter {
	if m != nil {
		return m.CompensationFilter
	}
	return nil
}

func (m *JobQuery) GetCustomAttributeFilter() string {
	if m != nil {
		return m.CustomAttributeFilter
	}
	return ""
}

func (m *JobQuery) GetDisableSpellCheck() bool {
	if m != nil {
		return m.DisableSpellCheck
	}
	return false
}

func (m *JobQuery) GetEmploymentTypes() []EmploymentType {
	if m != nil {
		return m.EmploymentTypes
	}
	return nil
}

func (m *JobQuery) GetLanguageCodes() []string {
	if m != nil {
		return m.LanguageCodes
	}
	return nil
}

func (m *JobQuery) GetPublishTimeRange() *TimestampRange {
	if m != nil {
		return m.PublishTimeRange
	}
	return nil
}

func (m *JobQuery) GetExcludedJobs() []string {
	if m != nil {
		return m.ExcludedJobs
	}
	return nil
}

// Filters to apply when performing the search query.
type ProfileQuery struct {
	// Optional.
	//
	// Keywords to match any text fields of profiles.
	//
	// For example, "software engineer in Palo Alto".
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	// Optional.
	//
	// The location filter specifies geo-regions containing the profiles to
	// search against.
	//
	// If a location filter isn't specified, profiles fitting the other search
	// criteria are retrieved regardless of where they're located.
	//
	// If [LocationFilter.negated][google.cloud.talent.v4beta1.LocationFilter.negated] is specified, the result doesn't contain
	// profiles from that location.
	//
	// For example, search for profiles with addresses in "New York City".
	LocationFilters []*LocationFilter `protobuf:"bytes,2,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// Optional.
	//
	// Job title filter specifies job titles of profiles to match on.
	//
	// If a job title isn't specified, profiles with any titles are retrieved.
	//
	// If multiple values are specified, profiles are retrieved with any of the
	// specified job titles.
	//
	// If [JobTitleFilter.negated][google.cloud.talent.v4beta1.JobTitleFilter.negated] is specified, the result won't contain
	// profiles with the job titles.
	//
	// For example, search for profiles with a job title "Product Manager".
	JobTitleFilters []*JobTitleFilter `protobuf:"bytes,3,rep,name=job_title_filters,json=jobTitleFilters,proto3" json:"job_title_filters,omitempty"`
	// Optional.
	//
	// Employer filter specifies employers of profiles to match on.
	//
	// If an employer filter isn't specified, profiles with any employers are
	// retrieved.
	//
	// If multiple employer filters are specified, profiles with any matching
	// employers are retrieved.
	//
	// If [EmployerFilter.negated][google.cloud.talent.v4beta1.EmployerFilter.negated] is specified, the result won't contain
	// profiles that match the employers.
	//
	// For example, search for profiles that have working experience at "Google
	// LLC".
	EmployerFilters []*EmployerFilter `protobuf:"bytes,4,rep,name=employer_filters,json=employerFilters,proto3" json:"employer_filters,omitempty"`
	// Optional.
	//
	// Education filter specifies education of profiles to match on.
	//
	// If an education filter isn't specified, profiles with any education are
	// retrieved.
	//
	// If multiple education filters are specified, profiles that match any
	// education filters are retrieved.
	//
	// If [EducationFilter.negated][google.cloud.talent.v4beta1.EducationFilter.negated] is specified, the result won't contain
	// profiles that match the educations.
	//
	// For example, search for profiles with a master degree.
	EducationFilters []*EducationFilter `protobuf:"bytes,5,rep,name=education_filters,json=educationFilters,proto3" json:"education_filters,omitempty"`
	// Optional.
	//
	// Skill filter specifies skill of profiles to match on.
	//
	// If a skill filter isn't specified, profiles with any skills are retrieved.
	//
	// If multiple skill filters are specified, profiles that match any skill
	// filters are retrieved.
	//
	// If [SkillFilter.negated][google.cloud.talent.v4beta1.SkillFilter.negated] is specified, the result won't contain profiles
	// that match the skills.
	//
	// For example, search for profiles that have "Java" and "Python" in skill
	// list.
	SkillFilters []*SkillFilter `protobuf:"bytes,6,rep,name=skill_filters,json=skillFilters,proto3" json:"skill_filters,omitempty"`
	// Optional.
	//
	// Work experience filter specifies the total working experience of profiles
	// to match on.
	//
	// If a work experience filter isn't specified, profiles with any
	// professional experience are retrieved.
	//
	// If multiple work experience filters are specified, profiles that match any
	// work experience filters are retrieved.
	//
	// For example, search for profiles with 10 years of work experience.
	WorkExperienceFilter []*WorkExperienceFilter `protobuf:"bytes,7,rep,name=work_experience_filter,json=workExperienceFilter,proto3" json:"work_experience_filter,omitempty"`
	// Optional.
	//
	// Time filter specifies the create/update timestamp of the profiles to match
	// on.
	//
	// For example, search for profiles created since "2018-1-1".
	TimeFilters []*TimeFilter `protobuf:"bytes,8,rep,name=time_filters,json=timeFilters,proto3" json:"time_filters,omitempty"`
	// Optional.
	//
	// The hirable filter specifies the profile's hirable status to match on.
	HirableFilter *wrappers.BoolValue `protobuf:"bytes,9,opt,name=hirable_filter,json=hirableFilter,proto3" json:"hirable_filter,omitempty"`
	// Optional.
	//
	// The application date filters specify application date ranges to match on.
	ApplicationDateFilters []*ApplicationDateFilter `protobuf:"bytes,10,rep,name=application_date_filters,json=applicationDateFilters,proto3" json:"application_date_filters,omitempty"`
	// Optional.
	//
	// The application outcome reason filters specify the reasons for outcome of
	// the job application.
	ApplicationOutcomeReasonFilters []*ApplicationOutcomeReasonFilter `protobuf:"bytes,11,rep,name=application_outcome_reason_filters,json=applicationOutcomeReasonFilters,proto3" json:"application_outcome_reason_filters,omitempty"`
	// Optional.
	//
	// The application last stage filters specify the last stage of job
	// application.
	ApplicationLastStageFilters []*ApplicationLastStageFilter `protobuf:"bytes,12,rep,name=application_last_stage_filters,json=applicationLastStageFilters,proto3" json:"application_last_stage_filters,omitempty"`
	// Optional.
	//
	// The application job filters specify the job applied for in the application.
	ApplicationJobFilters []*ApplicationJobFilter `protobuf:"bytes,13,rep,name=application_job_filters,json=applicationJobFilters,proto3" json:"application_job_filters,omitempty"`
	// Optional.
	//
	// The application status filters specify the status of job application.
	ApplicationStatusFilters []*ApplicationStatusFilter `protobuf:"bytes,14,rep,name=application_status_filters,json=applicationStatusFilters,proto3" json:"application_status_filters,omitempty"`
	// Optional.
	//
	// This filter specifies a structured syntax to match against the
	// [Profile.custom_attributes][google.cloud.talent.v4beta1.Profile.custom_attributes] that are marked as `filterable`.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// Supported operators are: =, != where the left of the operator is a custom
	// field key and the right of the operator is a string (surrounded by quotes)
	// value.
	//
	// Supported functions are LOWER(<field_name>) to
	// perform case insensitive match and EMPTY(<field_name>) to filter on the
	// existence of a key.
	//
	// Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
	// nesting (for example "((A AND B AND C) OR NOT D) AND E"), and there can be
	// a maximum of 50 comparisons/functions in the expression. The expression
	// must be < 2000 characters in length.
	//
	// Sample Query:
	// (key1 = "TEST" OR LOWER(key1)="test" OR NOT EMPTY(key1))
	CustomFieldFilter    string   `protobuf:"bytes,15,opt,name=custom_field_filter,json=customFieldFilter,proto3" json:"custom_field_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProfileQuery) Reset()         { *m = ProfileQuery{} }
func (m *ProfileQuery) String() string { return proto.CompactTextString(m) }
func (*ProfileQuery) ProtoMessage()    {}
func (*ProfileQuery) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{1}
}
func (m *ProfileQuery) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProfileQuery.Unmarshal(m, b)
}
func (m *ProfileQuery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProfileQuery.Marshal(b, m, deterministic)
}
func (dst *ProfileQuery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProfileQuery.Merge(dst, src)
}
func (m *ProfileQuery) XXX_Size() int {
	return xxx_messageInfo_ProfileQuery.Size(m)
}
func (m *ProfileQuery) XXX_DiscardUnknown() {
	xxx_messageInfo_ProfileQuery.DiscardUnknown(m)
}

var xxx_messageInfo_ProfileQuery proto.InternalMessageInfo

func (m *ProfileQuery) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *ProfileQuery) GetLocationFilters() []*LocationFilter {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *ProfileQuery) GetJobTitleFilters() []*JobTitleFilter {
	if m != nil {
		return m.JobTitleFilters
	}
	return nil
}

func (m *ProfileQuery) GetEmployerFilters() []*EmployerFilter {
	if m != nil {
		return m.EmployerFilters
	}
	return nil
}

func (m *ProfileQuery) GetEducationFilters() []*EducationFilter {
	if m != nil {
		return m.EducationFilters
	}
	return nil
}

func (m *ProfileQuery) GetSkillFilters() []*SkillFilter {
	if m != nil {
		return m.SkillFilters
	}
	return nil
}

func (m *ProfileQuery) GetWorkExperienceFilter() []*WorkExperienceFilter {
	if m != nil {
		return m.WorkExperienceFilter
	}
	return nil
}

func (m *ProfileQuery) GetTimeFilters() []*TimeFilter {
	if m != nil {
		return m.TimeFilters
	}
	return nil
}

func (m *ProfileQuery) GetHirableFilter() *wrappers.BoolValue {
	if m != nil {
		return m.HirableFilter
	}
	return nil
}

func (m *ProfileQuery) GetApplicationDateFilters() []*ApplicationDateFilter {
	if m != nil {
		return m.ApplicationDateFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationOutcomeReasonFilters() []*ApplicationOutcomeReasonFilter {
	if m != nil {
		return m.ApplicationOutcomeReasonFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationLastStageFilters() []*ApplicationLastStageFilter {
	if m != nil {
		return m.ApplicationLastStageFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationJobFilters() []*ApplicationJobFilter {
	if m != nil {
		return m.ApplicationJobFilters
	}
	return nil
}

func (m *ProfileQuery) GetApplicationStatusFilters() []*ApplicationStatusFilter {
	if m != nil {
		return m.ApplicationStatusFilters
	}
	return nil
}

func (m *ProfileQuery) GetCustomFieldFilter() string {
	if m != nil {
		return m.CustomFieldFilter
	}
	return ""
}

// Input only.
//
// Geographic region of the search.
type LocationFilter struct {
	// Optional.
	//
	// The address name, such as "Mountain View" or "Bay Area".
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Optional.
	//
	// CLDR region code of the country/region of the address. This is used
	// to address ambiguity of the user-input location, for example, "Liverpool"
	// against "Liverpool, NY, US" or "Liverpool, UK".
	//
	// Set this field if all the jobs to search against are from a same region,
	// or jobs are world-wide, but the job seeker is from a specific region.
	//
	// See http://cldr.unicode.org/ and
	// http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html
	// for details. Example: "CH" for Switzerland.
	RegionCode string `protobuf:"bytes,2,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional.
	//
	// The latitude and longitude of the geographic center from which to
	// search. This field's ignored if `address` is provided.
	LatLng *latlng.LatLng `protobuf:"bytes,3,opt,name=lat_lng,json=latLng,proto3" json:"lat_lng,omitempty"`
	// Optional.
	//
	//
	// The distance_in_miles is applied when the location being searched for is
	// identified as a city or smaller. When the location being searched for is a
	// state or larger, this field is ignored.
	DistanceInMiles float64 `protobuf:"fixed64,4,opt,name=distance_in_miles,json=distanceInMiles,proto3" json:"distance_in_miles,omitempty"`
	// Optional.
	//
	// Allows the client to return jobs without a
	// set location, specifically, telecommuting jobs (telecomuting is considered
	// by the service as a special location.
	// [Job.posting_region][google.cloud.talent.v4beta1.Job.posting_region] indicates if a job permits telecommuting.
	// If this field is set to [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
	// telecommuting jobs are searched, and [address][google.cloud.talent.v4beta1.LocationFilter.address] and [lat_lng][google.cloud.talent.v4beta1.LocationFilter.lat_lng] are
	// ignored. If not set or set to
	// [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4beta1.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED], telecommute job are not
	// searched.
	//
	// This filter can be used by itself to search exclusively for telecommuting
	// jobs, or it can be combined with another location
	// filter to search for a combination of job locations,
	// such as "Mountain View" or "telecommuting" jobs. However, when used in
	// combination with other location filters, telecommuting jobs can be
	// treated as less relevant than other jobs in the search response.
	TelecommutePreference LocationFilter_TelecommutePreference `protobuf:"varint,5,opt,name=telecommute_preference,json=telecommutePreference,proto3,enum=google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference" json:"telecommute_preference,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	//
	// Currently only supported in profile search.
	Negated              bool     `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LocationFilter) Reset()         { *m = LocationFilter{} }
func (m *LocationFilter) String() string { return proto.CompactTextString(m) }
func (*LocationFilter) ProtoMessage()    {}
func (*LocationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{2}
}
func (m *LocationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationFilter.Unmarshal(m, b)
}
func (m *LocationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationFilter.Marshal(b, m, deterministic)
}
func (dst *LocationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationFilter.Merge(dst, src)
}
func (m *LocationFilter) XXX_Size() int {
	return xxx_messageInfo_LocationFilter.Size(m)
}
func (m *LocationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_LocationFilter proto.InternalMessageInfo

func (m *LocationFilter) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *LocationFilter) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

func (m *LocationFilter) GetLatLng() *latlng.LatLng {
	if m != nil {
		return m.LatLng
	}
	return nil
}

func (m *LocationFilter) GetDistanceInMiles() float64 {
	if m != nil {
		return m.DistanceInMiles
	}
	return 0
}

func (m *LocationFilter) GetTelecommutePreference() LocationFilter_TelecommutePreference {
	if m != nil {
		return m.TelecommutePreference
	}
	return LocationFilter_TELECOMMUTE_PREFERENCE_UNSPECIFIED
}

func (m *LocationFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on job compensation type and amount.
type CompensationFilter struct {
	// Required.
	//
	// Type of filter.
	Type CompensationFilter_FilterType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.CompensationFilter_FilterType" json:"type,omitempty"`
	// Required.
	//
	// Specify desired `base compensation entry's`
	// [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit].
	Units []CompensationInfo_CompensationUnit `protobuf:"varint,2,rep,packed,name=units,proto3,enum=google.cloud.talent.v4beta1.CompensationInfo_CompensationUnit" json:"units,omitempty"`
	// Optional.
	//
	// Compensation range.
	Range *CompensationInfo_CompensationRange `protobuf:"bytes,3,opt,name=range,proto3" json:"range,omitempty"`
	// Optional.
	//
	// Whether to include jobs whose compensation range is unspecified.
	IncludeJobsWithUnspecifiedCompensationRange bool     `protobuf:"varint,4,opt,name=include_jobs_with_unspecified_compensation_range,json=includeJobsWithUnspecifiedCompensationRange,proto3" json:"include_jobs_with_unspecified_compensation_range,omitempty"`
	XXX_NoUnkeyedLiteral                        struct{} `json:"-"`
	XXX_unrecognized                            []byte   `json:"-"`
	XXX_sizecache                               int32    `json:"-"`
}

func (m *CompensationFilter) Reset()         { *m = CompensationFilter{} }
func (m *CompensationFilter) String() string { return proto.CompactTextString(m) }
func (*CompensationFilter) ProtoMessage()    {}
func (*CompensationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{3}
}
func (m *CompensationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CompensationFilter.Unmarshal(m, b)
}
func (m *CompensationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CompensationFilter.Marshal(b, m, deterministic)
}
func (dst *CompensationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CompensationFilter.Merge(dst, src)
}
func (m *CompensationFilter) XXX_Size() int {
	return xxx_messageInfo_CompensationFilter.Size(m)
}
func (m *CompensationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CompensationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CompensationFilter proto.InternalMessageInfo

func (m *CompensationFilter) GetType() CompensationFilter_FilterType {
	if m != nil {
		return m.Type
	}
	return CompensationFilter_FILTER_TYPE_UNSPECIFIED
}

func (m *CompensationFilter) GetUnits() []CompensationInfo_CompensationUnit {
	if m != nil {
		return m.Units
	}
	return nil
}

func (m *CompensationFilter) GetRange() *CompensationInfo_CompensationRange {
	if m != nil {
		return m.Range
	}
	return nil
}

func (m *CompensationFilter) GetIncludeJobsWithUnspecifiedCompensationRange() bool {
	if m != nil {
		return m.IncludeJobsWithUnspecifiedCompensationRange
	}
	return false
}

// Input only.
//
// Parameters needed for commute search.
type CommuteFilter struct {
	// Required.
	//
	// The method of transportation for which to calculate the commute time.
	CommuteMethod CommuteFilter_CommuteMethod `protobuf:"varint,1,opt,name=commute_method,json=commuteMethod,proto3,enum=google.cloud.talent.v4beta1.CommuteFilter_CommuteMethod" json:"commute_method,omitempty"`
	// Required.
	//
	// The latitude and longitude of the location from which to calculate the
	// commute time.
	StartCoordinates *latlng.LatLng `protobuf:"bytes,2,opt,name=start_coordinates,json=startCoordinates,proto3" json:"start_coordinates,omitempty"`
	// Required.
	//
	// The maximum travel time in seconds. The maximum allowed value is `3600s`
	// (one hour). Format is `123s`.
	TravelDuration *duration.Duration `protobuf:"bytes,3,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	// Optional.
	// If `true`, jobs without street level addresses may also be returned.
	// For city level addresses, the city center is used. For state and coarser
	// level addresses, text matching is used.
	// If this field is set to `false` or isn't specified, only jobs that include
	// street level addresses will be returned by commute search.
	AllowImpreciseAddresses bool `protobuf:"varint,4,opt,name=allow_imprecise_addresses,json=allowImpreciseAddresses,proto3" json:"allow_imprecise_addresses,omitempty"`
	// Optional.
	//
	// Traffic factor to take into account while searching by commute.
	//
	// Types that are valid to be assigned to TrafficOption:
	//	*CommuteFilter_RoadTraffic_
	//	*CommuteFilter_DepartureTime
	TrafficOption        isCommuteFilter_TrafficOption `protobuf_oneof:"traffic_option"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *CommuteFilter) Reset()         { *m = CommuteFilter{} }
func (m *CommuteFilter) String() string { return proto.CompactTextString(m) }
func (*CommuteFilter) ProtoMessage()    {}
func (*CommuteFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{4}
}
func (m *CommuteFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommuteFilter.Unmarshal(m, b)
}
func (m *CommuteFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommuteFilter.Marshal(b, m, deterministic)
}
func (dst *CommuteFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommuteFilter.Merge(dst, src)
}
func (m *CommuteFilter) XXX_Size() int {
	return xxx_messageInfo_CommuteFilter.Size(m)
}
func (m *CommuteFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_CommuteFilter.DiscardUnknown(m)
}

var xxx_messageInfo_CommuteFilter proto.InternalMessageInfo

func (m *CommuteFilter) GetCommuteMethod() CommuteFilter_CommuteMethod {
	if m != nil {
		return m.CommuteMethod
	}
	return CommuteFilter_COMMUTE_METHOD_UNSPECIFIED
}

func (m *CommuteFilter) GetStartCoordinates() *latlng.LatLng {
	if m != nil {
		return m.StartCoordinates
	}
	return nil
}

func (m *CommuteFilter) GetTravelDuration() *duration.Duration {
	if m != nil {
		return m.TravelDuration
	}
	return nil
}

func (m *CommuteFilter) GetAllowImpreciseAddresses() bool {
	if m != nil {
		return m.AllowImpreciseAddresses
	}
	return false
}

type isCommuteFilter_TrafficOption interface {
	isCommuteFilter_TrafficOption()
}

type CommuteFilter_RoadTraffic_ struct {
	RoadTraffic CommuteFilter_RoadTraffic `protobuf:"varint,5,opt,name=road_traffic,json=roadTraffic,proto3,enum=google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic,oneof"`
}

type CommuteFilter_DepartureTime struct {
	DepartureTime *timeofday.TimeOfDay `protobuf:"bytes,6,opt,name=departure_time,json=departureTime,proto3,oneof"`
}

func (*CommuteFilter_RoadTraffic_) isCommuteFilter_TrafficOption() {}

func (*CommuteFilter_DepartureTime) isCommuteFilter_TrafficOption() {}

func (m *CommuteFilter) GetTrafficOption() isCommuteFilter_TrafficOption {
	if m != nil {
		return m.TrafficOption
	}
	return nil
}

func (m *CommuteFilter) GetRoadTraffic() CommuteFilter_RoadTraffic {
	if x, ok := m.GetTrafficOption().(*CommuteFilter_RoadTraffic_); ok {
		return x.RoadTraffic
	}
	return CommuteFilter_ROAD_TRAFFIC_UNSPECIFIED
}

func (m *CommuteFilter) GetDepartureTime() *timeofday.TimeOfDay {
	if x, ok := m.GetTrafficOption().(*CommuteFilter_DepartureTime); ok {
		return x.DepartureTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommuteFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommuteFilter_OneofMarshaler, _CommuteFilter_OneofUnmarshaler, _CommuteFilter_OneofSizer, []interface{}{
		(*CommuteFilter_RoadTraffic_)(nil),
		(*CommuteFilter_DepartureTime)(nil),
	}
}

func _CommuteFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommuteFilter)
	// traffic_option
	switch x := m.TrafficOption.(type) {
	case *CommuteFilter_RoadTraffic_:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RoadTraffic))
	case *CommuteFilter_DepartureTime:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DepartureTime); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommuteFilter.TrafficOption has unexpected type %T", x)
	}
	return nil
}

func _CommuteFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommuteFilter)
	switch tag {
	case 5: // traffic_option.road_traffic
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TrafficOption = &CommuteFilter_RoadTraffic_{CommuteFilter_RoadTraffic(x)}
		return true, err
	case 6: // traffic_option.departure_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(timeofday.TimeOfDay)
		err := b.DecodeMessage(msg)
		m.TrafficOption = &CommuteFilter_DepartureTime{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommuteFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommuteFilter)
	// traffic_option
	switch x := m.TrafficOption.(type) {
	case *CommuteFilter_RoadTraffic_:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.RoadTraffic))
	case *CommuteFilter_DepartureTime:
		s := proto.Size(x.DepartureTime)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Input only.
//
// Job title of the search.
type JobTitleFilter struct {
	// Required.
	//
	// The job title, for example, "Software engineer", or "Product manager".
	JobTitle string `protobuf:"bytes,1,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobTitleFilter) Reset()         { *m = JobTitleFilter{} }
func (m *JobTitleFilter) String() string { return proto.CompactTextString(m) }
func (*JobTitleFilter) ProtoMessage()    {}
func (*JobTitleFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{5}
}
func (m *JobTitleFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobTitleFilter.Unmarshal(m, b)
}
func (m *JobTitleFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobTitleFilter.Marshal(b, m, deterministic)
}
func (dst *JobTitleFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobTitleFilter.Merge(dst, src)
}
func (m *JobTitleFilter) XXX_Size() int {
	return xxx_messageInfo_JobTitleFilter.Size(m)
}
func (m *JobTitleFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_JobTitleFilter.DiscardUnknown(m)
}

var xxx_messageInfo_JobTitleFilter proto.InternalMessageInfo

func (m *JobTitleFilter) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *JobTitleFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Skill filter of the search.
type SkillFilter struct {
	// Required.
	//
	// The skill name. For example, "java", "j2ee", etc.
	Skill string `protobuf:"bytes,1,opt,name=skill,proto3" json:"skill,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// are excluded.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SkillFilter) Reset()         { *m = SkillFilter{} }
func (m *SkillFilter) String() string { return proto.CompactTextString(m) }
func (*SkillFilter) ProtoMessage()    {}
func (*SkillFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{6}
}
func (m *SkillFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SkillFilter.Unmarshal(m, b)
}
func (m *SkillFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SkillFilter.Marshal(b, m, deterministic)
}
func (dst *SkillFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SkillFilter.Merge(dst, src)
}
func (m *SkillFilter) XXX_Size() int {
	return xxx_messageInfo_SkillFilter.Size(m)
}
func (m *SkillFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_SkillFilter.DiscardUnknown(m)
}

var xxx_messageInfo_SkillFilter proto.InternalMessageInfo

func (m *SkillFilter) GetSkill() string {
	if m != nil {
		return m.Skill
	}
	return ""
}

func (m *SkillFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Employer filter of the search.
type EmployerFilter struct {
	// Required.
	//
	// The name of the employer, for example "Google", "Alphabet".
	Employer string `protobuf:"bytes,1,opt,name=employer,proto3" json:"employer,omitempty"`
	// Optional.
	//
	// Define set of [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord]s to search against.
	//
	// Defaults to [EmployerFilterMode.ALL_EMPLOYMENT_RECORDS][google.cloud.talent.v4beta1.EmployerFilter.EmployerFilterMode.ALL_EMPLOYMENT_RECORDS].
	Mode EmployerFilter_EmployerFilterMode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.cloud.talent.v4beta1.EmployerFilter_EmployerFilterMode" json:"mode,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated              bool     `protobuf:"varint,3,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmployerFilter) Reset()         { *m = EmployerFilter{} }
func (m *EmployerFilter) String() string { return proto.CompactTextString(m) }
func (*EmployerFilter) ProtoMessage()    {}
func (*EmployerFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{7}
}
func (m *EmployerFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmployerFilter.Unmarshal(m, b)
}
func (m *EmployerFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmployerFilter.Marshal(b, m, deterministic)
}
func (dst *EmployerFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmployerFilter.Merge(dst, src)
}
func (m *EmployerFilter) XXX_Size() int {
	return xxx_messageInfo_EmployerFilter.Size(m)
}
func (m *EmployerFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EmployerFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EmployerFilter proto.InternalMessageInfo

func (m *EmployerFilter) GetEmployer() string {
	if m != nil {
		return m.Employer
	}
	return ""
}

func (m *EmployerFilter) GetMode() EmployerFilter_EmployerFilterMode {
	if m != nil {
		return m.Mode
	}
	return EmployerFilter_EMPLOYER_FILTER_MODE_UNSPECIFIED
}

func (m *EmployerFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Education filter of the search.
type EducationFilter struct {
	// Optional.
	//
	// The school name. For example "MIT", "University of California, Berkeley".
	School string `protobuf:"bytes,1,opt,name=school,proto3" json:"school,omitempty"`
	// Optional.
	//
	// The field of study. This is to search against value provided in
	// [Degree.fields_of_study][google.cloud.talent.v4beta1.Degree.fields_of_study].
	// For example "Computer Science", "Mathematics".
	FieldOfStudy string `protobuf:"bytes,2,opt,name=field_of_study,json=fieldOfStudy,proto3" json:"field_of_study,omitempty"`
	// Optional.
	//
	// Education degree in ISCED code. Each value in degree covers a specific
	// level of education, without any expansion to upper nor lower levels of
	// education degree.
	DegreeType DegreeType `protobuf:"varint,3,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Optional.
	//
	// Whether to apply negation to the filter so profiles matching the filter
	// is excluded.
	Negated              bool     `protobuf:"varint,6,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EducationFilter) Reset()         { *m = EducationFilter{} }
func (m *EducationFilter) String() string { return proto.CompactTextString(m) }
func (*EducationFilter) ProtoMessage()    {}
func (*EducationFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{8}
}
func (m *EducationFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EducationFilter.Unmarshal(m, b)
}
func (m *EducationFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EducationFilter.Marshal(b, m, deterministic)
}
func (dst *EducationFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EducationFilter.Merge(dst, src)
}
func (m *EducationFilter) XXX_Size() int {
	return xxx_messageInfo_EducationFilter.Size(m)
}
func (m *EducationFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EducationFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EducationFilter proto.InternalMessageInfo

func (m *EducationFilter) GetSchool() string {
	if m != nil {
		return m.School
	}
	return ""
}

func (m *EducationFilter) GetFieldOfStudy() string {
	if m != nil {
		return m.FieldOfStudy
	}
	return ""
}

func (m *EducationFilter) GetDegreeType() DegreeType {
	if m != nil {
		return m.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (m *EducationFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Work experience filter.
//
// This filter is used to search for profiles with working experience length
// between [min_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.min_experience] and [max_experience][google.cloud.talent.v4beta1.WorkExperienceFilter.max_experience].
type WorkExperienceFilter struct {
	// Optional.
	//
	// The minimum duration of the work experience (inclusive).
	MinExperience *duration.Duration `protobuf:"bytes,1,opt,name=min_experience,json=minExperience,proto3" json:"min_experience,omitempty"`
	// Optional.
	//
	// The maximum duration of the work experience (exclusive).
	MaxExperience        *duration.Duration `protobuf:"bytes,2,opt,name=max_experience,json=maxExperience,proto3" json:"max_experience,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *WorkExperienceFilter) Reset()         { *m = WorkExperienceFilter{} }
func (m *WorkExperienceFilter) String() string { return proto.CompactTextString(m) }
func (*WorkExperienceFilter) ProtoMessage()    {}
func (*WorkExperienceFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{9}
}
func (m *WorkExperienceFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkExperienceFilter.Unmarshal(m, b)
}
func (m *WorkExperienceFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkExperienceFilter.Marshal(b, m, deterministic)
}
func (dst *WorkExperienceFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkExperienceFilter.Merge(dst, src)
}
func (m *WorkExperienceFilter) XXX_Size() int {
	return xxx_messageInfo_WorkExperienceFilter.Size(m)
}
func (m *WorkExperienceFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkExperienceFilter.DiscardUnknown(m)
}

var xxx_messageInfo_WorkExperienceFilter proto.InternalMessageInfo

func (m *WorkExperienceFilter) GetMinExperience() *duration.Duration {
	if m != nil {
		return m.MinExperience
	}
	return nil
}

func (m *WorkExperienceFilter) GetMaxExperience() *duration.Duration {
	if m != nil {
		return m.MaxExperience
	}
	return nil
}

// Input only.
//
// Application Date Range Filter.
//
// The API matches profiles with [JobApplication.application_date][google.cloud.talent.v4beta1.JobApplication.application_date] between
// start date and end date (both boundaries are inclusive). The filter is
// ignored if both [start_date][google.cloud.talent.v4beta1.ApplicationDateFilter.start_date] and [end_date][google.cloud.talent.v4beta1.ApplicationDateFilter.end_date] are missing.
type ApplicationDateFilter struct {
	// Optional.
	//
	// Start date. If it's missing, The API matches profiles with application date
	// not after the end date.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional.
	//
	// End date. If it's missing, The API matches profiles with application date
	// not before the start date.
	EndDate              *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *ApplicationDateFilter) Reset()         { *m = ApplicationDateFilter{} }
func (m *ApplicationDateFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationDateFilter) ProtoMessage()    {}
func (*ApplicationDateFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{10}
}
func (m *ApplicationDateFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationDateFilter.Unmarshal(m, b)
}
func (m *ApplicationDateFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationDateFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationDateFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationDateFilter.Merge(dst, src)
}
func (m *ApplicationDateFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationDateFilter.Size(m)
}
func (m *ApplicationDateFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationDateFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationDateFilter proto.InternalMessageInfo

func (m *ApplicationDateFilter) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *ApplicationDateFilter) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

// Input only.
//
// Outcome Reason Filter.
type ApplicationOutcomeReasonFilter struct {
	// Required.
	//
	// User entered or selected outcome reason. The API does an exact match on the
	// [JobApplication.outcome_reason][google.cloud.talent.v4beta1.JobApplication.outcome_reason] in profiles.
	OutcomeReason string `protobuf:"bytes,1,opt,name=outcome_reason,json=outcomeReason,proto3" json:"outcome_reason,omitempty"`
	// Optional.
	//
	// If true, The API excludes all candidates with any
	// [JobApplication.outcome_reason][google.cloud.talent.v4beta1.JobApplication.outcome_reason] matching the outcome reason specified in
	// the filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationOutcomeReasonFilter) Reset()         { *m = ApplicationOutcomeReasonFilter{} }
func (m *ApplicationOutcomeReasonFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationOutcomeReasonFilter) ProtoMessage()    {}
func (*ApplicationOutcomeReasonFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{11}
}
func (m *ApplicationOutcomeReasonFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationOutcomeReasonFilter.Unmarshal(m, b)
}
func (m *ApplicationOutcomeReasonFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationOutcomeReasonFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationOutcomeReasonFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationOutcomeReasonFilter.Merge(dst, src)
}
func (m *ApplicationOutcomeReasonFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationOutcomeReasonFilter.Size(m)
}
func (m *ApplicationOutcomeReasonFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationOutcomeReasonFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationOutcomeReasonFilter proto.InternalMessageInfo

func (m *ApplicationOutcomeReasonFilter) GetOutcomeReason() string {
	if m != nil {
		return m.OutcomeReason
	}
	return ""
}

func (m *ApplicationOutcomeReasonFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on Last Stage of Application.
type ApplicationLastStageFilter struct {
	// Required.
	//
	// User entered or selected last stage the candidate reached in the
	// application. The API does an exact match on the
	// [JobApplication.last_stage][google.cloud.talent.v4beta1.JobApplication.last_stage] in profiles.
	LastStage string `protobuf:"bytes,1,opt,name=last_stage,json=lastStage,proto3" json:"last_stage,omitempty"`
	// Optional.
	// If true, The API excludes all candidates with any
	// [JobApplication.last_stage][google.cloud.talent.v4beta1.JobApplication.last_stage] matching the last stage specified in the
	// filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationLastStageFilter) Reset()         { *m = ApplicationLastStageFilter{} }
func (m *ApplicationLastStageFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationLastStageFilter) ProtoMessage()    {}
func (*ApplicationLastStageFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{12}
}
func (m *ApplicationLastStageFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationLastStageFilter.Unmarshal(m, b)
}
func (m *ApplicationLastStageFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationLastStageFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationLastStageFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationLastStageFilter.Merge(dst, src)
}
func (m *ApplicationLastStageFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationLastStageFilter.Size(m)
}
func (m *ApplicationLastStageFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationLastStageFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationLastStageFilter proto.InternalMessageInfo

func (m *ApplicationLastStageFilter) GetLastStage() string {
	if m != nil {
		return m.LastStage
	}
	return ""
}

func (m *ApplicationLastStageFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on the job information of Application.
type ApplicationJobFilter struct {
	// Optional.
	//
	// The job resource name in the application. The API does an exact match on
	// the [Job.name][google.cloud.talent.v4beta1.Job.name] of [JobApplication.job][google.cloud.talent.v4beta1.JobApplication.job] in profiles.
	JobName string `protobuf:"bytes,1,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	// Optional.
	//
	// The job requisition id in the application. The API does an exact match on
	// the [Job.requisistion_id][] of [JobApplication.job][google.cloud.talent.v4beta1.JobApplication.job] in profiles.
	JobRequisitionId string `protobuf:"bytes,2,opt,name=job_requisition_id,json=jobRequisitionId,proto3" json:"job_requisition_id,omitempty"`
	// Optional.
	//
	// The job title in the application. The API does an exact match on the
	// [Job.title][google.cloud.talent.v4beta1.Job.title] of [JobApplication.job][google.cloud.talent.v4beta1.JobApplication.job] in profiles.
	JobTitle string `protobuf:"bytes,3,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional.
	//
	// If true, the API excludes all profiles with any [JobApplication.job][google.cloud.talent.v4beta1.JobApplication.job]
	// matching the filters.
	Negated              bool     `protobuf:"varint,4,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationJobFilter) Reset()         { *m = ApplicationJobFilter{} }
func (m *ApplicationJobFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationJobFilter) ProtoMessage()    {}
func (*ApplicationJobFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{13}
}
func (m *ApplicationJobFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationJobFilter.Unmarshal(m, b)
}
func (m *ApplicationJobFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationJobFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationJobFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationJobFilter.Merge(dst, src)
}
func (m *ApplicationJobFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationJobFilter.Size(m)
}
func (m *ApplicationJobFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationJobFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationJobFilter proto.InternalMessageInfo

func (m *ApplicationJobFilter) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

func (m *ApplicationJobFilter) GetJobRequisitionId() string {
	if m != nil {
		return m.JobRequisitionId
	}
	return ""
}

func (m *ApplicationJobFilter) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *ApplicationJobFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on status of Application.
type ApplicationStatusFilter struct {
	// Required.
	//
	// User entered or selected application status. The API does an exact match
	// between the application status specified in this filter and the
	// [JobApplication.status][] in profiles.
	ApplicationStatus JobApplication_ApplicationStatus `protobuf:"varint,1,opt,name=application_status,json=applicationStatus,proto3,enum=google.cloud.talent.v4beta1.JobApplication_ApplicationStatus" json:"application_status,omitempty"`
	// Optional.
	//
	// If true, The API excludes all candidates with any [JobApplication.status][]
	// matching the status specified in the filter.
	Negated              bool     `protobuf:"varint,2,opt,name=negated,proto3" json:"negated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ApplicationStatusFilter) Reset()         { *m = ApplicationStatusFilter{} }
func (m *ApplicationStatusFilter) String() string { return proto.CompactTextString(m) }
func (*ApplicationStatusFilter) ProtoMessage()    {}
func (*ApplicationStatusFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{14}
}
func (m *ApplicationStatusFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ApplicationStatusFilter.Unmarshal(m, b)
}
func (m *ApplicationStatusFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ApplicationStatusFilter.Marshal(b, m, deterministic)
}
func (dst *ApplicationStatusFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ApplicationStatusFilter.Merge(dst, src)
}
func (m *ApplicationStatusFilter) XXX_Size() int {
	return xxx_messageInfo_ApplicationStatusFilter.Size(m)
}
func (m *ApplicationStatusFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_ApplicationStatusFilter.DiscardUnknown(m)
}

var xxx_messageInfo_ApplicationStatusFilter proto.InternalMessageInfo

func (m *ApplicationStatusFilter) GetApplicationStatus() JobApplication_ApplicationStatus {
	if m != nil {
		return m.ApplicationStatus
	}
	return JobApplication_APPLICATION_STATUS_UNSPECIFIED
}

func (m *ApplicationStatusFilter) GetNegated() bool {
	if m != nil {
		return m.Negated
	}
	return false
}

// Input only.
//
// Filter on create timestamp or update timestamp of profiles.
type TimeFilter struct {
	// Optional.
	//
	// Start timestamp, matching profiles with the start time. If this field
	// missing, The API matches profiles with create / update timestamp before the
	// end timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional.
	//
	// End timestamp, matching profiles with the end time. If this field
	// missing, The API matches profiles with create / update timestamp after the
	// start timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional.
	//
	// Specifies which time field to filter profiles.
	//
	// Defaults to [TimeField.CREATE_TIME][google.cloud.talent.v4beta1.TimeFilter.TimeField.CREATE_TIME].
	TimeField            TimeFilter_TimeField `protobuf:"varint,3,opt,name=time_field,json=timeField,proto3,enum=google.cloud.talent.v4beta1.TimeFilter_TimeField" json:"time_field,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeFilter) Reset()         { *m = TimeFilter{} }
func (m *TimeFilter) String() string { return proto.CompactTextString(m) }
func (*TimeFilter) ProtoMessage()    {}
func (*TimeFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_filters_37155a594c645a6c, []int{15}
}
func (m *TimeFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeFilter.Unmarshal(m, b)
}
func (m *TimeFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeFilter.Marshal(b, m, deterministic)
}
func (dst *TimeFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeFilter.Merge(dst, src)
}
func (m *TimeFilter) XXX_Size() int {
	return xxx_messageInfo_TimeFilter.Size(m)
}
func (m *TimeFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeFilter.DiscardUnknown(m)
}

var xxx_messageInfo_TimeFilter proto.InternalMessageInfo

func (m *TimeFilter) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeFilter) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *TimeFilter) GetTimeField() TimeFilter_TimeField {
	if m != nil {
		return m.TimeField
	}
	return TimeFilter_TIME_FIELD_UNSPECIFIED
}

func init() {
	proto.RegisterType((*JobQuery)(nil), "google.cloud.talent.v4beta1.JobQuery")
	proto.RegisterType((*ProfileQuery)(nil), "google.cloud.talent.v4beta1.ProfileQuery")
	proto.RegisterType((*LocationFilter)(nil), "google.cloud.talent.v4beta1.LocationFilter")
	proto.RegisterType((*CompensationFilter)(nil), "google.cloud.talent.v4beta1.CompensationFilter")
	proto.RegisterType((*CommuteFilter)(nil), "google.cloud.talent.v4beta1.CommuteFilter")
	proto.RegisterType((*JobTitleFilter)(nil), "google.cloud.talent.v4beta1.JobTitleFilter")
	proto.RegisterType((*SkillFilter)(nil), "google.cloud.talent.v4beta1.SkillFilter")
	proto.RegisterType((*EmployerFilter)(nil), "google.cloud.talent.v4beta1.EmployerFilter")
	proto.RegisterType((*EducationFilter)(nil), "google.cloud.talent.v4beta1.EducationFilter")
	proto.RegisterType((*WorkExperienceFilter)(nil), "google.cloud.talent.v4beta1.WorkExperienceFilter")
	proto.RegisterType((*ApplicationDateFilter)(nil), "google.cloud.talent.v4beta1.ApplicationDateFilter")
	proto.RegisterType((*ApplicationOutcomeReasonFilter)(nil), "google.cloud.talent.v4beta1.ApplicationOutcomeReasonFilter")
	proto.RegisterType((*ApplicationLastStageFilter)(nil), "google.cloud.talent.v4beta1.ApplicationLastStageFilter")
	proto.RegisterType((*ApplicationJobFilter)(nil), "google.cloud.talent.v4beta1.ApplicationJobFilter")
	proto.RegisterType((*ApplicationStatusFilter)(nil), "google.cloud.talent.v4beta1.ApplicationStatusFilter")
	proto.RegisterType((*TimeFilter)(nil), "google.cloud.talent.v4beta1.TimeFilter")
	proto.RegisterEnum("google.cloud.talent.v4beta1.LocationFilter_TelecommutePreference", LocationFilter_TelecommutePreference_name, LocationFilter_TelecommutePreference_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CompensationFilter_FilterType", CompensationFilter_FilterType_name, CompensationFilter_FilterType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CommuteFilter_CommuteMethod", CommuteFilter_CommuteMethod_name, CommuteFilter_CommuteMethod_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.CommuteFilter_RoadTraffic", CommuteFilter_RoadTraffic_name, CommuteFilter_RoadTraffic_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.EmployerFilter_EmployerFilterMode", EmployerFilter_EmployerFilterMode_name, EmployerFilter_EmployerFilterMode_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.TimeFilter_TimeField", TimeFilter_TimeField_name, TimeFilter_TimeField_value)
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/filters.proto", fileDescriptor_filters_37155a594c645a6c)
}

var fileDescriptor_filters_37155a594c645a6c = []byte{
	// 2208 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4b, 0x73, 0x1b, 0xc7,
	0xf1, 0x17, 0x00, 0x3e, 0x1b, 0x04, 0x08, 0x8e, 0x44, 0x12, 0xa2, 0xf4, 0x97, 0x58, 0xb0, 0xf5,
	0x0f, 0x63, 0xab, 0x40, 0x8b, 0x71, 0x9c, 0xc4, 0x2e, 0xc7, 0x06, 0x81, 0xa5, 0x05, 0x06, 0x2f,
	0x2f, 0x16, 0x52, 0xe8, 0x1c, 0x36, 0x03, 0xec, 0x00, 0x5c, 0x6a, 0xb1, 0xb3, 0xde, 0x19, 0x98,
	0x62, 0x2a, 0x39, 0xe4, 0x92, 0xca, 0x27, 0xc8, 0x21, 0xa9, 0x1c, 0x92, 0x7b, 0x2a, 0x87, 0xdc,
	0x72, 0xc8, 0xb7, 0xc8, 0xf7, 0x49, 0xcd, 0xec, 0x0c, 0xb0, 0xe0, 0x63, 0x49, 0xa5, 0x72, 0xc2,
	0xf6, 0xeb, 0xd7, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x80, 0xef, 0x8f, 0x28, 0x1d, 0x79, 0x64, 0x7f,
	0xe0, 0xd1, 0x89, 0xb3, 0xcf, 0xb1, 0x47, 0x7c, 0xbe, 0xff, 0xdd, 0xc7, 0x7d, 0xc2, 0xf1, 0x8b,
	0xfd, 0xa1, 0xeb, 0x71, 0x12, 0xb2, 0x72, 0x10, 0x52, 0x4e, 0xd1, 0xa3, 0x48, 0xb5, 0x2c, 0x55,
	0xcb, 0x91, 0x6a, 0x59, 0xa9, 0xee, 0x3c, 0x56, 0x38, 0x38, 0x70, 0xf7, 0xb1, 0xef, 0x53, 0x8e,
	0xb9, 0x4b, 0x7d, 0x65, 0xba, 0xb3, 0x97, 0xe4, 0x65, 0x40, 0xc7, 0x63, 0xea, 0x2b, 0xcd, 0x67,
	0x49, 0x9a, 0x67, 0xb4, 0xaf, 0xd4, 0x12, 0xc3, 0x0e, 0x42, 0x3a, 0x74, 0x3d, 0xa2, 0x54, 0x9f,
	0x28, 0x55, 0x49, 0xf5, 0x27, 0xc3, 0x7d, 0x67, 0x12, 0xca, 0xe0, 0x94, 0xfc, 0xe9, 0x65, 0x39,
	0x77, 0xc7, 0x84, 0x71, 0x3c, 0x0e, 0x6e, 0x02, 0x38, 0x0f, 0x71, 0x10, 0x4c, 0xf3, 0xb2, 0xb3,
	0xa5, 0xe4, 0xfc, 0x22, 0x20, 0xfb, 0x0e, 0xe6, 0xda, 0x71, 0x31, 0xce, 0xf7, 0x30, 0xf7, 0xfc,
	0x91, 0x92, 0x3c, 0x8a, 0x4b, 0x84, 0x3b, 0x3a, 0x74, 0xf0, 0x45, 0x24, 0x2c, 0xfd, 0x6b, 0x09,
	0x56, 0x8e, 0x69, 0xff, 0xeb, 0x09, 0x09, 0x2f, 0xd0, 0x03, 0x58, 0xfc, 0x56, 0x7c, 0x14, 0x53,
	0xbb, 0xa9, 0xbd, 0x55, 0x33, 0x22, 0xd0, 0x7b, 0x90, 0x1b, 0xd0, 0x71, 0x80, 0xfd, 0x0b, 0xdb,
	0xc7, 0x63, 0xc2, 0x8a, 0xe9, 0xdd, 0xcc, 0xde, 0xaa, 0xb9, 0xa6, 0x98, 0x2d, 0xc1, 0x43, 0xaf,
	0xa0, 0xe0, 0xd1, 0x81, 0x5c, 0xa9, 0xad, 0x36, 0xb2, 0x98, 0xd9, 0xcd, 0xec, 0x65, 0x0f, 0x3e,
	0x2c, 0x27, 0xec, 0x64, 0xb9, 0xa1, 0x8c, 0x8e, 0xa4, 0x8d, 0xb9, 0xee, 0xcd, 0xd1, 0x0c, 0xb5,
	0x21, 0x7f, 0x46, 0xfb, 0xf6, 0x00, 0x73, 0x32, 0xa2, 0xa1, 0x4b, 0x58, 0x71, 0x61, 0x37, 0xb3,
	0x97, 0x3f, 0xd8, 0x4b, 0x44, 0x3d, 0xa6, 0xfd, 0x6a, 0x64, 0x71, 0x61, 0xe6, 0xce, 0xa6, 0x84,
	0x4b, 0x18, 0xfa, 0x1a, 0xf2, 0xa2, 0x04, 0x26, 0x9c, 0xa8, 0x38, 0x8b, 0x8b, 0xbb, 0xa9, 0xbd,
	0xec, 0xc1, 0x07, 0x89, 0x80, 0xd5, 0xc8, 0x44, 0x45, 0x99, 0x1b, 0xc4, 0x49, 0x74, 0x00, 0x9b,
	0x3a, 0x41, 0x8e, 0xcb, 0x02, 0x0f, 0xeb, 0x44, 0x2d, 0xc9, 0x44, 0xdd, 0x57, 0xc2, 0x5a, 0x24,
	0x8b, 0xf2, 0xf5, 0x4b, 0x90, 0x6c, 0xe2, 0xb3, 0x78, 0xce, 0x8a, 0xcb, 0x32, 0x96, 0xfd, 0xdb,
	0x62, 0x99, 0xda, 0xa9, 0x80, 0xd0, 0xe0, 0x0a, 0x0f, 0x7d, 0x02, 0xdb, 0x83, 0x09, 0xe3, 0x74,
	0x6c, 0x63, 0xce, 0x43, 0xb7, 0x1f, 0x5b, 0xf1, 0x8a, 0xdc, 0xde, 0xcd, 0x48, 0x5c, 0xd1, 0x52,
	0x65, 0x57, 0x86, 0xfb, 0x8e, 0xcb, 0x70, 0xdf, 0x23, 0x36, 0x0b, 0x88, 0xe7, 0xd9, 0x83, 0x53,
	0x32, 0x78, 0x53, 0x5c, 0xdd, 0x4d, 0xed, 0xad, 0x98, 0x1b, 0x4a, 0xd4, 0x15, 0x92, 0xaa, 0x10,
	0x88, 0x9d, 0x27, 0xe3, 0xc0, 0xa3, 0x17, 0x63, 0xe2, 0x73, 0x5b, 0x14, 0x19, 0x2b, 0x82, 0xdc,
	0xa3, 0xe4, 0x9d, 0x37, 0xa6, 0x46, 0xd6, 0x45, 0x40, 0xcc, 0x75, 0x32, 0x47, 0x33, 0xf4, 0x0c,
	0xf2, 0x1e, 0xf6, 0x47, 0x13, 0x3c, 0x22, 0xf6, 0x80, 0x3a, 0x84, 0x15, 0xb3, 0x32, 0x9d, 0x39,
	0xcd, 0xad, 0x0a, 0x26, 0x3a, 0x01, 0x14, 0x4c, 0xfa, 0x9e, 0xcb, 0x4e, 0x6d, 0x51, 0xdb, 0x76,
	0x88, 0xfd, 0x11, 0x29, 0xae, 0xc9, 0x3c, 0x26, 0x07, 0x60, 0xe9, 0x93, 0x67, 0x0a, 0x13, 0xb3,
	0xa0, 0x60, 0x04, 0x5b, 0x72, 0x44, 0xe1, 0x93, 0xb7, 0x03, 0x6f, 0xe2, 0x10, 0xc7, 0x3e, 0xa3,
	0x7d, 0x56, 0xcc, 0x45, 0x85, 0xaf, 0x99, 0xc7, 0xb4, 0xcf, 0x4a, 0xff, 0x06, 0x58, 0xeb, 0x44,
	0x2d, 0x20, 0xe9, 0x10, 0x5d, 0x77, 0x3e, 0xd2, 0xff, 0x83, 0xf3, 0xf1, 0x1a, 0x36, 0xc4, 0xf9,
	0xe0, 0x2e, 0xf7, 0xc8, 0x3b, 0x1d, 0xbc, 0x63, 0xda, 0xb7, 0x84, 0x91, 0x06, 0x3e, 0x9b, 0xa3,
	0xd9, 0x6c, 0x5b, 0x49, 0x38, 0xc5, 0x5d, 0xb8, 0x03, 0xae, 0xa1, 0x8c, 0x34, 0x2e, 0x99, 0xa3,
	0xc5, 0x7e, 0x6d, 0x10, 0x67, 0x72, 0x29, 0x13, 0x8b, 0x12, 0xf8, 0x79, 0x32, 0xb0, 0xb6, 0x52,
	0xc8, 0x05, 0x32, 0xcf, 0x60, 0xa8, 0x09, 0x39, 0xf6, 0xc6, 0xf5, 0xbc, 0x29, 0xec, 0x92, 0x84,
	0x4d, 0x6e, 0x15, 0x5d, 0x61, 0xa1, 0x20, 0xd7, 0xd8, 0x8c, 0x60, 0x68, 0x04, 0x5b, 0xe7, 0x34,
	0x7c, 0x63, 0x93, 0xb7, 0x01, 0x09, 0x5d, 0xe2, 0x0f, 0xc8, 0xec, 0x94, 0x0a, 0xdc, 0x17, 0x89,
	0xb8, 0xaf, 0x69, 0xf8, 0xc6, 0x98, 0x5a, 0x2a, 0x07, 0x0f, 0xce, 0xaf, 0xe1, 0xa2, 0x63, 0x58,
	0x93, 0xa5, 0xab, 0xc3, 0x5e, 0x91, 0xf0, 0xdf, 0xbb, 0xb5, 0x78, 0x15, 0x68, 0x96, 0x4f, 0xbf,
	0x19, 0xaa, 0x40, 0xfe, 0xd4, 0x0d, 0xe5, 0xe9, 0x55, 0xc1, 0xae, 0xca, 0xa3, 0xb0, 0xa3, 0xd1,
	0xf4, 0xbd, 0x52, 0x3e, 0xa4, 0xd4, 0x7b, 0x85, 0xbd, 0x09, 0x31, 0x73, 0xca, 0x42, 0x85, 0xe3,
	0x41, 0x11, 0x07, 0x81, 0xe7, 0xaa, 0x3d, 0x12, 0x77, 0xcc, 0x34, 0x34, 0x90, 0xa1, 0x1d, 0x24,
	0x86, 0x56, 0x99, 0x19, 0xd7, 0xf0, 0xb4, 0x67, 0x6e, 0xe1, 0xeb, 0xd8, 0x0c, 0xfd, 0x3e, 0x05,
	0xa5, 0xb8, 0x3b, 0x3a, 0xe1, 0x03, 0x2a, 0xce, 0x31, 0xc1, 0x2c, 0x56, 0x21, 0x59, 0xe9, 0xf8,
	0xb3, 0xbb, 0x3a, 0x6e, 0x47, 0x28, 0xa6, 0x04, 0x51, 0x11, 0x3c, 0xc5, 0x89, 0x72, 0x86, 0x7e,
	0x0d, 0x4f, 0xe2, 0x91, 0x78, 0x98, 0x71, 0x9b, 0x71, 0xd1, 0x7f, 0x74, 0x14, 0x6b, 0x32, 0x8a,
	0x1f, 0xdd, 0x35, 0x8a, 0x06, 0x66, 0xbc, 0x2b, 0x00, 0x54, 0x04, 0x8f, 0xf0, 0x8d, 0x32, 0x86,
	0x5c, 0xd8, 0x8e, 0x7b, 0x17, 0xa7, 0x5a, 0xbb, 0xcd, 0xdd, 0xa1, 0xde, 0x62, 0x6e, 0x8f, 0x69,
	0x5f, 0x39, 0xdc, 0xc4, 0xd7, 0x70, 0x19, 0x0a, 0x61, 0x27, 0xee, 0x8a, 0x71, 0xcc, 0x27, 0x6c,
	0xea, 0x2d, 0x2f, 0xbd, 0x7d, 0x7c, 0x57, 0x6f, 0x5d, 0x69, 0xad, 0x1c, 0xc6, 0x2b, 0x27, 0x2e,
	0x60, 0xe2, 0x5a, 0x51, 0xd7, 0xd1, 0xd0, 0x25, 0x9e, 0xa3, 0xab, 0x73, 0x5d, 0x36, 0xc9, 0x8d,
	0x48, 0x74, 0x24, 0x24, 0x91, 0x41, 0xe9, 0x6f, 0x19, 0xc8, 0xcf, 0x37, 0x3f, 0x54, 0x84, 0x65,
	0xec, 0x38, 0x21, 0x61, 0x4c, 0xf5, 0x56, 0x4d, 0xa2, 0xa7, 0x90, 0x0d, 0xc9, 0x48, 0xac, 0x45,
	0xdc, 0x14, 0xc5, 0xb4, 0x94, 0x42, 0xc4, 0x12, 0xd7, 0x04, 0x7a, 0x0e, 0xcb, 0x1e, 0xe6, 0xb6,
	0xe7, 0x8f, 0x8a, 0x19, 0x79, 0x1e, 0xee, 0xeb, 0xe5, 0x89, 0x0b, 0xab, 0xdc, 0xc0, 0xbc, 0xe1,
	0x8f, 0xcc, 0x25, 0x4f, 0xfe, 0xa2, 0x0f, 0x40, 0xdc, 0x73, 0x1c, 0x8b, 0x23, 0xef, 0xfa, 0xf6,
	0xd8, 0xf5, 0xe4, 0xdc, 0x91, 0xda, 0x4b, 0x99, 0xeb, 0x5a, 0x50, 0xf7, 0x9b, 0x82, 0x8d, 0xde,
	0xc2, 0x16, 0x27, 0x1e, 0xd1, 0x33, 0x45, 0x10, 0x92, 0x21, 0x09, 0xc5, 0xe1, 0x96, 0x73, 0x45,
	0xfe, 0xa0, 0xf2, 0x0e, 0xed, 0xbd, 0x6c, 0xcd, 0x90, 0x3a, 0x53, 0x20, 0x73, 0x93, 0x5f, 0xc7,
	0x16, 0xe9, 0xf0, 0xc9, 0x08, 0x73, 0xe2, 0x14, 0x97, 0xe4, 0xe5, 0xac, 0xc9, 0x52, 0x08, 0x9b,
	0xd7, 0x22, 0xa1, 0xff, 0x87, 0x92, 0x65, 0x34, 0x8c, 0x6a, 0xbb, 0xd9, 0xec, 0x59, 0x86, 0xdd,
	0x31, 0x8d, 0x23, 0xc3, 0x34, 0x5a, 0x55, 0xc3, 0xee, 0xb5, 0xba, 0x1d, 0xa3, 0x5a, 0x3f, 0xaa,
	0x1b, 0xb5, 0xc2, 0x3d, 0x54, 0x84, 0x07, 0x71, 0x3d, 0xe3, 0xe7, 0xd5, 0x46, 0xaf, 0x66, 0xd4,
	0x0a, 0x29, 0xb4, 0x0d, 0xf7, 0xe3, 0x92, 0x4a, 0xa3, 0xd1, 0x7e, 0x6d, 0xd4, 0x0a, 0xe9, 0xd2,
	0x6f, 0x17, 0x00, 0x5d, 0x9d, 0x4c, 0x50, 0x0b, 0x16, 0x44, 0x86, 0xe5, 0x86, 0xe5, 0x0f, 0x3e,
	0x7d, 0xc7, 0xc1, 0xa6, 0x1c, 0xfd, 0xc8, 0x01, 0x41, 0xe2, 0x20, 0x0b, 0x16, 0x27, 0xbe, 0xcb,
	0xa3, 0xcb, 0x33, 0x7f, 0xf0, 0xd3, 0x3b, 0x03, 0xd6, 0xfd, 0x21, 0x9d, 0x63, 0xf4, 0x7c, 0x97,
	0x9b, 0x11, 0x18, 0xea, 0xc1, 0x62, 0x34, 0x37, 0x44, 0xc5, 0xf1, 0xc5, 0x7f, 0x8f, 0x1a, 0xcd,
	0x12, 0x11, 0x1a, 0x22, 0xf0, 0x91, 0xeb, 0xcb, 0x59, 0x41, 0xce, 0x0f, 0xf6, 0xb9, 0xcb, 0x4f,
	0xed, 0x89, 0xcf, 0x02, 0x32, 0x70, 0x87, 0x2e, 0x71, 0xec, 0xb9, 0x11, 0x30, 0x8a, 0x60, 0x41,
	0x6e, 0xe5, 0x87, 0xca, 0x4e, 0x8c, 0x18, 0xaf, 0x5d, 0x7e, 0xda, 0x9b, 0x19, 0x5d, 0xf1, 0x56,
	0xfa, 0x5d, 0x0a, 0x60, 0x96, 0x28, 0xf4, 0x08, 0xb6, 0x8f, 0xea, 0x0d, 0xcb, 0x30, 0x6d, 0xeb,
	0xa4, 0x73, 0x79, 0x67, 0x73, 0xb0, 0xda, 0x6b, 0xd5, 0x2d, 0xbb, 0xdd, 0x6a, 0x9c, 0x14, 0x52,
	0xe8, 0x3e, 0xac, 0x4b, 0xb2, 0xd2, 0xaa, 0xd9, 0x95, 0x66, 0xbb, 0xd7, 0xb2, 0x0a, 0x69, 0xb4,
	0x03, 0x5b, 0x95, 0x56, 0xab, 0x57, 0x69, 0xd4, 0xbf, 0x31, 0x6a, 0xf6, 0x61, 0xa5, 0x6b, 0x68,
	0x59, 0x46, 0x80, 0xc7, 0x64, 0x56, 0xdb, 0xaa, 0x34, 0xb4, 0x70, 0xa1, 0xf4, 0xf7, 0x45, 0xc8,
	0xcd, 0x4d, 0xca, 0xc8, 0x9e, 0x4d, 0xdb, 0x63, 0xc2, 0x4f, 0xa9, 0xa3, 0x0a, 0xe1, 0xc7, 0x77,
	0x9f, 0xb6, 0x35, 0xd5, 0x94, 0xf6, 0xd3, 0xd9, 0x3b, 0x22, 0xd1, 0x97, 0xb0, 0xc1, 0x38, 0x0e,
	0xb9, 0x3d, 0xa0, 0x34, 0x74, 0x5c, 0x1f, 0x73, 0xf9, 0x40, 0xb9, 0xf1, 0x88, 0x17, 0xa4, 0x76,
	0x75, 0xa6, 0x8c, 0x0e, 0x61, 0x9d, 0x87, 0xf8, 0x3b, 0xe2, 0xd9, 0xfa, 0xa9, 0xa6, 0xaa, 0xe0,
	0xe1, 0x95, 0x2b, 0xb3, 0xa6, 0x14, 0xcc, 0x7c, 0x64, 0xa1, 0x69, 0xf4, 0x29, 0x3c, 0xc4, 0x9e,
	0x47, 0xcf, 0x6d, 0x77, 0x1c, 0x84, 0x64, 0xe0, 0x32, 0x62, 0xab, 0xd6, 0xa4, 0x1a, 0xc7, 0x8a,
	0xb9, 0x2d, 0x15, 0xea, 0x5a, 0x5e, 0xd1, 0x62, 0xf4, 0x0b, 0x58, 0x0b, 0x29, 0x76, 0x6c, 0x1e,
	0xe2, 0xe1, 0xd0, 0x1d, 0xa8, 0xb6, 0xf1, 0xc9, 0x3b, 0x24, 0xc8, 0xa4, 0xd8, 0xb1, 0x22, 0xeb,
	0x97, 0xf7, 0xcc, 0x6c, 0x38, 0x23, 0xd1, 0x17, 0x90, 0x77, 0x48, 0x80, 0x43, 0x3e, 0x09, 0x89,
	0x9c, 0x8f, 0x65, 0xab, 0xc8, 0x1e, 0x6c, 0xcd, 0xe5, 0x46, 0x0c, 0x13, 0xed, 0x61, 0x0d, 0x5f,
	0xbc, 0xbc, 0x67, 0xe6, 0xa6, 0xfa, 0x82, 0x5b, 0xfa, 0xcd, 0x74, 0x47, 0x55, 0xc2, 0x9f, 0xc0,
	0x8e, 0x3e, 0xfc, 0x4d, 0xc3, 0x7a, 0xd9, 0xae, 0x5d, 0x2a, 0xb0, 0x2c, 0x2c, 0xd7, 0xcc, 0xfa,
	0xab, 0x7a, 0xeb, 0xab, 0x42, 0x4a, 0x10, 0x96, 0x59, 0x69, 0x75, 0xeb, 0xa2, 0xac, 0xb2, 0xb0,
	0xfc, 0xba, 0xd2, 0xf8, 0x99, 0x90, 0x64, 0x44, 0x1d, 0x1e, 0xd6, 0xab, 0x27, 0xd5, 0x86, 0x20,
	0x17, 0xd0, 0x16, 0x20, 0xa5, 0x68, 0x57, 0xaa, 0x55, 0xa3, 0xdb, 0xad, 0x1f, 0x36, 0x8c, 0xc2,
	0x62, 0xa9, 0x01, 0xd9, 0xd8, 0xea, 0xd0, 0x63, 0x28, 0x9a, 0xed, 0x4a, 0xcd, 0xb6, 0xcc, 0xca,
	0xd1, 0x51, 0xbd, 0x7a, 0xc9, 0x75, 0x01, 0xd6, 0xb4, 0xe0, 0xc8, 0x34, 0x8c, 0x42, 0x4a, 0x7a,
	0xe9, 0x75, 0x4f, 0xec, 0x97, 0xed, 0x9e, 0x59, 0x48, 0x1f, 0x16, 0x20, 0xaf, 0xb2, 0x6c, 0xd3,
	0x40, 0x6c, 0x5c, 0xe9, 0x2b, 0xc8, 0xcf, 0x0f, 0xc2, 0xe8, 0x11, 0xac, 0x4e, 0x07, 0x6a, 0x75,
	0xcd, 0xac, 0xe8, 0xd9, 0x38, 0xde, 0x72, 0xd3, 0xf3, 0x2d, 0xf7, 0x73, 0xc8, 0xc6, 0x26, 0x49,
	0xf1, 0x08, 0x90, 0xb3, 0xa4, 0x7e, 0x04, 0x48, 0x22, 0xc1, 0xfc, 0x9f, 0x69, 0xc8, 0xcf, 0x4f,
	0xce, 0x68, 0x07, 0x56, 0xf4, 0xec, 0xac, 0xe3, 0xd0, 0x34, 0x32, 0x61, 0x61, 0xac, 0x2f, 0xba,
	0xdb, 0x9a, 0xe0, 0x3c, 0xec, 0x25, 0xb2, 0x49, 0x1d, 0x62, 0x4a, 0xac, 0x78, 0x70, 0x99, 0xf9,
	0xe0, 0xfe, 0x9c, 0x02, 0x74, 0xd5, 0x0c, 0xbd, 0x0f, 0xbb, 0x46, 0xb3, 0xd3, 0x68, 0x9f, 0x18,
	0xa6, 0xad, 0x1a, 0x4e, 0xb3, 0x5d, 0xbb, 0xdc, 0x70, 0x44, 0x33, 0x69, 0x34, 0xec, 0x48, 0xb3,
	0x69, 0xb4, 0x2c, 0xdb, 0x34, 0xaa, 0x6d, 0xb3, 0xd6, 0x2d, 0xa4, 0xd0, 0x7b, 0xf0, 0xb4, 0xda,
	0x33, 0x4d, 0xc1, 0xbc, 0x2a, 0x8f, 0x5a, 0x54, 0x1a, 0xed, 0xc2, 0xe3, 0x4e, 0xa5, 0x7b, 0xb3,
	0x46, 0xa6, 0xf4, 0x8f, 0x14, 0xac, 0x5f, 0x7a, 0x1d, 0xa0, 0x2d, 0x58, 0x62, 0x83, 0x53, 0x4a,
	0xf5, 0x0e, 0x28, 0x0a, 0xbd, 0x0f, 0xf9, 0x68, 0xfe, 0xa0, 0x43, 0x9b, 0xf1, 0x89, 0x73, 0xa1,
	0x86, 0x85, 0x35, 0xc9, 0x6d, 0x0f, 0xbb, 0x82, 0x87, 0x5e, 0x42, 0xd6, 0x21, 0xa3, 0x90, 0x10,
	0xf9, 0x9e, 0x95, 0xf9, 0xc8, 0xdf, 0x32, 0x90, 0xd7, 0xa4, 0xbe, 0xbc, 0xa9, 0xc0, 0x99, 0x7e,
	0x27, 0x5c, 0xd2, 0x7f, 0x4c, 0xc1, 0x83, 0xeb, 0x1e, 0x09, 0xe8, 0x4b, 0xc8, 0x8f, 0x5d, 0x3f,
	0xf6, 0xec, 0x90, 0x4b, 0x48, 0xec, 0x47, 0xb9, 0xb1, 0xeb, 0xcf, 0x70, 0x24, 0x02, 0x7e, 0x1b,
	0x47, 0x48, 0xdf, 0x8e, 0x80, 0xdf, 0xce, 0x10, 0x4a, 0xe7, 0xb0, 0x79, 0xed, 0x18, 0x8f, 0x3e,
	0x02, 0x88, 0xfa, 0xad, 0x78, 0x16, 0xa8, 0xc0, 0x36, 0xe6, 0x9a, 0x89, 0x50, 0x36, 0x57, 0xa5,
	0x92, 0xf8, 0x44, 0xcf, 0x61, 0x85, 0xf8, 0x4e, 0xa4, 0x9f, 0xbe, 0x49, 0x7f, 0x99, 0xf8, 0x8e,
	0xf8, 0x28, 0x61, 0x78, 0x92, 0x3c, 0xc6, 0xa3, 0x67, 0x90, 0x9f, 0x7f, 0x23, 0xa8, 0x1d, 0xce,
	0xd1, 0xb8, 0x72, 0xc2, 0x59, 0xeb, 0xc1, 0xce, 0xcd, 0x33, 0x3a, 0xfa, 0x3f, 0x80, 0xd9, 0xe0,
	0xaf, 0xa0, 0x57, 0x3d, 0xad, 0x94, 0x00, 0xfb, 0x87, 0x14, 0x3c, 0xb8, 0x6e, 0x08, 0x47, 0x0f,
	0x41, 0x34, 0x10, 0xf9, 0x97, 0x90, 0x9e, 0x5b, 0xcf, 0x68, 0xbf, 0x85, 0xc7, 0x22, 0x37, 0x48,
	0x88, 0x42, 0xf2, 0xed, 0xc4, 0x65, 0xae, 0x9c, 0x02, 0x5c, 0x47, 0x55, 0x64, 0xe1, 0x8c, 0xf6,
	0xcd, 0x99, 0xa0, 0xee, 0xcc, 0xb7, 0xa6, 0xcc, 0xcd, 0xad, 0x69, 0x61, 0x3e, 0xb0, 0xbf, 0xa4,
	0x60, 0xfb, 0x86, 0x79, 0x1d, 0x79, 0x80, 0xae, 0xbe, 0x04, 0xd4, 0x1d, 0xfd, 0xf9, 0x6d, 0xff,
	0x1f, 0xc4, 0x40, 0xaf, 0x3e, 0x08, 0xcc, 0x8d, 0x2b, 0x4f, 0x81, 0x84, 0xe4, 0xfd, 0x29, 0x0d,
	0x30, 0x7b, 0xd2, 0xa2, 0x9f, 0xe8, 0x2a, 0x93, 0x57, 0x56, 0xea, 0x86, 0x17, 0xec, 0xec, 0x0f,
	0x9c, 0xa8, 0xdc, 0x04, 0x8d, 0x7e, 0x18, 0x95, 0x9b, 0x34, 0x4c, 0xdf, 0x6a, 0x28, 0xea, 0x4e,
	0x9a, 0x75, 0x00, 0xd4, 0x1b, 0x9c, 0x78, 0x8e, 0x3a, 0xf0, 0x2f, 0xee, 0xf8, 0x02, 0x57, 0x9f,
	0xc4, 0x73, 0xcc, 0x55, 0xae, 0x3f, 0x4b, 0x75, 0x58, 0x9d, 0xf2, 0x45, 0x17, 0xb4, 0xea, 0x4d,
	0xc3, 0x3e, 0xaa, 0x1b, 0x8d, 0xcb, 0x37, 0xe6, 0x3a, 0x64, 0xab, 0xa6, 0x51, 0xb1, 0x0c, 0x5b,
	0xa8, 0x14, 0x52, 0x82, 0xd1, 0xeb, 0xd4, 0xa6, 0x8c, 0xf4, 0xe1, 0xaf, 0xe0, 0xe9, 0x80, 0x8e,
	0x93, 0xa2, 0x39, 0x5c, 0x53, 0xef, 0xac, 0x8e, 0x58, 0x63, 0x27, 0xf5, 0x4d, 0x45, 0x29, 0x8f,
	0xa8, 0x87, 0xfd, 0x51, 0x99, 0x86, 0xa3, 0xfd, 0x11, 0xf1, 0x65, 0x06, 0xf6, 0x23, 0x11, 0x0e,
	0x5c, 0x76, 0xed, 0x3f, 0xda, 0x9f, 0x45, 0xe4, 0x5f, 0xd3, 0x99, 0xaa, 0xd5, 0xed, 0x2f, 0x49,
	0x9b, 0x1f, 0xfc, 0x27, 0x00, 0x00, 0xff, 0xff, 0x5a, 0x6f, 0x5c, 0x74, 0xbb, 0x17, 0x00, 0x00,
}
