// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/profile.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import date "google.golang.org/genproto/googleapis/type/date"
import postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Enum that represents the type of the telephone.
type Phone_PhoneType int32

const (
	// Default value.
	Phone_PHONE_TYPE_UNSPECIFIED Phone_PhoneType = 0
	// A landline.
	Phone_LANDLINE Phone_PhoneType = 1
	// A mobile.
	Phone_MOBILE Phone_PhoneType = 2
	// A fax.
	Phone_FAX Phone_PhoneType = 3
	// A pager.
	Phone_PAGER Phone_PhoneType = 4
	// A TTY (test telephone) or TDD (telecommunication device for the deaf).
	Phone_TTY_OR_TDD Phone_PhoneType = 5
	// A voicemail.
	Phone_VOICEMAIL Phone_PhoneType = 6
	// A virtual telephone number is a number that can be routed to another
	// number and managed by the user via Web, SMS, IVR, etc.  It is associated
	// with a particular person, and may be routed to either a MOBILE or
	// LANDLINE number. The phone usage (see ContactInfoUsage above) should be
	// set to PERSONAL for these phone types. Some more information can be
	// found here: http://en.wikipedia.org/wiki/Personal_Numbers
	Phone_VIRTUAL Phone_PhoneType = 7
	// Voice over IP numbers. This includes TSoIP (Telephony Service over IP).
	Phone_VOIP Phone_PhoneType = 8
	// In some regions (e.g. the USA), it is impossible to distinguish between
	// fixed-line and mobile numbers by looking at the phone number itself.
	Phone_MOBILE_OR_LANDLINE Phone_PhoneType = 9
)

var Phone_PhoneType_name = map[int32]string{
	0: "PHONE_TYPE_UNSPECIFIED",
	1: "LANDLINE",
	2: "MOBILE",
	3: "FAX",
	4: "PAGER",
	5: "TTY_OR_TDD",
	6: "VOICEMAIL",
	7: "VIRTUAL",
	8: "VOIP",
	9: "MOBILE_OR_LANDLINE",
}
var Phone_PhoneType_value = map[string]int32{
	"PHONE_TYPE_UNSPECIFIED": 0,
	"LANDLINE":               1,
	"MOBILE":                 2,
	"FAX":                    3,
	"PAGER":                  4,
	"TTY_OR_TDD":             5,
	"VOICEMAIL":              6,
	"VIRTUAL":                7,
	"VOIP":                   8,
	"MOBILE_OR_LANDLINE":     9,
}

func (x Phone_PhoneType) String() string {
	return proto.EnumName(Phone_PhoneType_name, int32(x))
}
func (Phone_PhoneType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{4, 0}
}

// Enum that represents the skill proficiency level.
type Skill_SkillProficiencyLevel int32

const (
	// Default value.
	Skill_SKILL_PROFICIENCY_LEVEL_UNSPECIFIED Skill_SkillProficiencyLevel = 0
	// Have a common knowledge or an understanding of basic techniques and
	// concepts.
	Skill_FUNDAMENTAL_AWARENESS Skill_SkillProficiencyLevel = 1
	// Have the level of experience gained in a classroom and/or experimental
	// scenarios or as a trainee on-the-job.
	Skill_NOVICE Skill_SkillProficiencyLevel = 2
	// Be able to successfully complete tasks in this skill as requested. Help
	// from an expert may be required from time to time, but can usually perform
	// skill independently.
	Skill_INTERMEDIATE Skill_SkillProficiencyLevel = 3
	// Can perform the actions associated with this skill without assistance.
	Skill_ADVANCED Skill_SkillProficiencyLevel = 4
	// Known as an expert in this area.
	Skill_EXPERT Skill_SkillProficiencyLevel = 5
)

var Skill_SkillProficiencyLevel_name = map[int32]string{
	0: "SKILL_PROFICIENCY_LEVEL_UNSPECIFIED",
	1: "FUNDAMENTAL_AWARENESS",
	2: "NOVICE",
	3: "INTERMEDIATE",
	4: "ADVANCED",
	5: "EXPERT",
}
var Skill_SkillProficiencyLevel_value = map[string]int32{
	"SKILL_PROFICIENCY_LEVEL_UNSPECIFIED": 0,
	"FUNDAMENTAL_AWARENESS":               1,
	"NOVICE":                              2,
	"INTERMEDIATE":                        3,
	"ADVANCED":                            4,
	"EXPERT":                              5,
}

func (x Skill_SkillProficiencyLevel) String() string {
	return proto.EnumName(Skill_SkillProficiencyLevel_name, int32(x))
}
func (Skill_SkillProficiencyLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{10, 0}
}

// Enum that represents the application status.
type JobApplication_ApplicationStatus int32

const (
	// Default value.
	JobApplication_APPLICATION_STATUS_UNSPECIFIED JobApplication_ApplicationStatus = 0
	// The offer is extended.
	JobApplication_OFFER_EXTENDED JobApplication_ApplicationStatus = 1
	// The offer is rejected by candidate.
	JobApplication_REJECTED_BY_CANDIDATE JobApplication_ApplicationStatus = 2
	// The application is active.
	JobApplication_ACTIVE JobApplication_ApplicationStatus = 3
	// The candidate is rejected by employer.
	JobApplication_REJECTED_BY_EMPLOYER JobApplication_ApplicationStatus = 4
	// The candidate is hired and hasn't started the new job.
	JobApplication_HIRED_PENDING_DATE JobApplication_ApplicationStatus = 5
	// The candidate is hired started.
	JobApplication_HIRED_STARTED JobApplication_ApplicationStatus = 6
	// The candidate is a prospect candidate.
	JobApplication_PROSPECTED JobApplication_ApplicationStatus = 7
)

var JobApplication_ApplicationStatus_name = map[int32]string{
	0: "APPLICATION_STATUS_UNSPECIFIED",
	1: "OFFER_EXTENDED",
	2: "REJECTED_BY_CANDIDATE",
	3: "ACTIVE",
	4: "REJECTED_BY_EMPLOYER",
	5: "HIRED_PENDING_DATE",
	6: "HIRED_STARTED",
	7: "PROSPECTED",
}
var JobApplication_ApplicationStatus_value = map[string]int32{
	"APPLICATION_STATUS_UNSPECIFIED": 0,
	"OFFER_EXTENDED":                 1,
	"REJECTED_BY_CANDIDATE":          2,
	"ACTIVE":                         3,
	"REJECTED_BY_EMPLOYER":           4,
	"HIRED_PENDING_DATE":             5,
	"HIRED_STARTED":                  6,
	"PROSPECTED":                     7,
}

func (x JobApplication_ApplicationStatus) String() string {
	return proto.EnumName(JobApplication_ApplicationStatus_name, int32(x))
}
func (JobApplication_ApplicationStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{14, 0}
}

// A resource that represents the profile for a job candidate (also referred to
// as a "single-source profile"). A profile belongs to a [Company][google.cloud.talent.v4beta1.Company], which is
// the company/organization that owns the profile.
type Profile struct {
	// Required during profile update.
	//
	// Resource name assigned to a profile by the API.
	//
	// The format is
	// "projects/{project_id}/companies/{company_id}/profiles/{profile_id}",
	// for example, "projects/api-test-project/companies/foo/profiles/bar".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional.
	//
	// Profile's id in client system if available.
	//
	// The maximum number of bytes allowed is 100.
	ExternalId string `protobuf:"bytes,2,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Optional.
	//
	// The source description indicating where the profile is acquired.
	//
	// For example, if a candidate profile is acquired from a resume, the user can
	// input "resume" here to indicate the source.
	//
	// The maximum number of bytes allowed is 100.
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// Optional.
	//
	// The URI set by clients that links to this profile's client-side copy.
	//
	// The maximum number of bytes allowed is 4000.
	Uri string `protobuf:"bytes,4,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional.
	//
	// The cluster id of the profile to associate with other profile(s) for the
	// same candidate.
	//
	// A random UUID is assigned if [group_id][google.cloud.talent.v4beta1.Profile.group_id] isn't provided. To ensure
	// global uniqueness, customized [group_id][google.cloud.talent.v4beta1.Profile.group_id] isn't supported. If
	// [group_id][google.cloud.talent.v4beta1.Profile.group_id] is set, there must be at least one other profile with the
	// same system generated [group_id][google.cloud.talent.v4beta1.Profile.group_id], otherwise an error is thrown.
	//
	// This is used to link multiple profiles to the same candidate. For example,
	// a client has a candidate with two profiles, where one was created recently
	// and the other one was created 5 years ago. These two profiles may be very
	// different. The clients can create the first profile and get a generated
	// [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
	// indicating these two profiles are referring to the same candidate.
	GroupId string `protobuf:"bytes,5,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Optional.
	//
	// Indicates the hirable status of the candidate.
	IsHirable *wrappers.BoolValue `protobuf:"bytes,6,opt,name=is_hirable,json=isHirable,proto3" json:"is_hirable,omitempty"`
	// Optional.
	//
	// The timestamp when the profile was first created at this source.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional.
	//
	// The timestamp when the profile was last updated at this source.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional.
	//
	// The profile contents in HR-XML format.
	// See http://schemas.liquid-technologies.com/hr-xml/2007-04-15/ for more
	// information about Human Resources XML.
	//
	// Users can create a profile with only [resume_hrxml][google.cloud.talent.v4beta1.Profile.resume_hrxml] field. For example,
	// the API parses the [resume_hrxml][google.cloud.talent.v4beta1.Profile.resume_hrxml] and creates a profile with all
	// structured fields populated, for example. [EmploymentRecord][google.cloud.talent.v4beta1.EmploymentRecord],
	// [EducationRecord][google.cloud.talent.v4beta1.EducationRecord], etc. An error is thrown if the [resume_hrxml][google.cloud.talent.v4beta1.Profile.resume_hrxml] can't
	// be parsed.
	//
	// If the [resume_hrxml][google.cloud.talent.v4beta1.Profile.resume_hrxml] is provided during profile creation or update,
	// any other structured data provided in the profile is ignored. The
	// API populates these fields by parsing the HR-XML.
	ResumeHrxml string `protobuf:"bytes,10,opt,name=resume_hrxml,json=resumeHrxml,proto3" json:"resume_hrxml,omitempty"`
	// Optional.
	//
	// The names of the candidate this profile references.
	//
	// Currently only one person name is supported.
	PersonNames []*PersonName `protobuf:"bytes,11,rep,name=person_names,json=personNames,proto3" json:"person_names,omitempty"`
	// Optional.
	//
	// The candidate's postal addresses.
	Addresses []*Address `protobuf:"bytes,12,rep,name=addresses,proto3" json:"addresses,omitempty"`
	// Optional.
	//
	// The candidate's email addresses.
	EmailAddresses []*Email `protobuf:"bytes,13,rep,name=email_addresses,json=emailAddresses,proto3" json:"email_addresses,omitempty"`
	// Optional.
	//
	// The candidate's phone number(s).
	PhoneNumbers []*Phone `protobuf:"bytes,14,rep,name=phone_numbers,json=phoneNumbers,proto3" json:"phone_numbers,omitempty"`
	// Optional.
	//
	// The candidate's personal URIs.
	PersonalUris []*PersonalUri `protobuf:"bytes,15,rep,name=personal_uris,json=personalUris,proto3" json:"personal_uris,omitempty"`
	// Optional.
	//
	// Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
	// [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
	AdditionalContactInfo []*AdditionalContactInfo `protobuf:"bytes,16,rep,name=additional_contact_info,json=additionalContactInfo,proto3" json:"additional_contact_info,omitempty"`
	// Optional.
	//
	// The employment history records of the candidate. It's highly recommended
	// to input this information as accurately as possible to help improve search
	// quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the employment records.
	// * List different employment types separately, no matter how minor the
	// change is.
	// For example, only job title is changed from "software engineer" to "senior
	// software engineer".
	// * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
	// possible. If not, it's inferred from user inputs.
	EmploymentRecords []*EmploymentRecord `protobuf:"bytes,17,rep,name=employment_records,json=employmentRecords,proto3" json:"employment_records,omitempty"`
	// Optional.
	//
	// The education history record of the candidate. It's highly recommended to
	// input this information as accurately as possible to help improve search
	// quality. Here are some recommendations:
	//
	// * Specify the start and end dates of the education records.
	// * List each education type separately, no matter how minor the change is.
	// For example, the profile contains the education experience from the same
	// school but different degrees.
	// * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
	// possible. If not, it's inferred from user inputs.
	EducationRecords []*EducationRecord `protobuf:"bytes,18,rep,name=education_records,json=educationRecords,proto3" json:"education_records,omitempty"`
	// Optional.
	//
	// The skill set of the candidate. It's highly recommended to provide as
	// much information as possible to help improve the search quality.
	Skills []*Skill `protobuf:"bytes,19,rep,name=skills,proto3" json:"skills,omitempty"`
	// Optional.
	//
	// The individual or collaborative activities which the candidate has
	// participated in, for example, open-source projects, class assignments that
	// aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
	Activities []*Activity `protobuf:"bytes,20,rep,name=activities,proto3" json:"activities,omitempty"`
	// Optional.
	//
	// The publications published by the candidate.
	Publications []*Publication `protobuf:"bytes,21,rep,name=publications,proto3" json:"publications,omitempty"`
	// Optional.
	//
	// The patents acquired by the candidate.
	Patents []*Patent `protobuf:"bytes,22,rep,name=patents,proto3" json:"patents,omitempty"`
	// Optional.
	//
	// The certifications acquired by the candidate.
	Certifications []*Certification `protobuf:"bytes,23,rep,name=certifications,proto3" json:"certifications,omitempty"`
	// Optional.
	//
	// The job applications of the candidate.
	JobApplications []*JobApplication `protobuf:"bytes,24,rep,name=job_applications,json=jobApplications,proto3" json:"job_applications,omitempty"`
	// Optional.
	//
	// The recruiting notes added for the candidate.
	//
	// For example, the recruiter can add some unstructured comments for this
	// candidate like "this candidate also has experiences in volunteer work".
	RecruitingNotes []*RecruitingNote `protobuf:"bytes,25,rep,name=recruiting_notes,json=recruitingNotes,proto3" json:"recruiting_notes,omitempty"`
	// Optional.
	//
	// A map of fields to hold both filterable and non-filterable custom profile
	// attributes that aren't covered by the provided structured fields. See
	// [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
	//
	// At most 100 filterable and at most 100 unfilterable keys are supported. If
	// limit is exceeded, an error is thrown.
	//
	// Numeric custom attributes: each key can only map to one numeric value,
	// otherwise an error is thrown.
	//
	// String custom attributes: each key can map up to 50 string values. For
	// filterable string value, each value has a byte size of no more than 256B.
	// For unfilterable string values, the maximum byte size of a single key is
	// 64B. An error is thrown for any request exceeding the limit.
	// The maximum total byte size is 10KB.
	//
	// Currently filterable numeric custom attributes are not supported, and
	// they automatically set to unfilterable.
	CustomAttributes map[string]*CustomAttribute `protobuf:"bytes,26,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Indicates if the profile is fully processed and searchable.
	Processed bool `protobuf:"varint,27,opt,name=processed,proto3" json:"processed,omitempty"`
	// Output only. Keyword snippet shows how the search result is related to a
	// search query.
	KeywordSnippet       string   `protobuf:"bytes,28,opt,name=keyword_snippet,json=keywordSnippet,proto3" json:"keyword_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Profile) Reset()         { *m = Profile{} }
func (m *Profile) String() string { return proto.CompactTextString(m) }
func (*Profile) ProtoMessage()    {}
func (*Profile) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{0}
}
func (m *Profile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Profile.Unmarshal(m, b)
}
func (m *Profile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Profile.Marshal(b, m, deterministic)
}
func (dst *Profile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Profile.Merge(dst, src)
}
func (m *Profile) XXX_Size() int {
	return xxx_messageInfo_Profile.Size(m)
}
func (m *Profile) XXX_DiscardUnknown() {
	xxx_messageInfo_Profile.DiscardUnknown(m)
}

var xxx_messageInfo_Profile proto.InternalMessageInfo

func (m *Profile) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Profile) GetExternalId() string {
	if m != nil {
		return m.ExternalId
	}
	return ""
}

func (m *Profile) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *Profile) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Profile) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *Profile) GetIsHirable() *wrappers.BoolValue {
	if m != nil {
		return m.IsHirable
	}
	return nil
}

func (m *Profile) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Profile) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Profile) GetResumeHrxml() string {
	if m != nil {
		return m.ResumeHrxml
	}
	return ""
}

func (m *Profile) GetPersonNames() []*PersonName {
	if m != nil {
		return m.PersonNames
	}
	return nil
}

func (m *Profile) GetAddresses() []*Address {
	if m != nil {
		return m.Addresses
	}
	return nil
}

func (m *Profile) GetEmailAddresses() []*Email {
	if m != nil {
		return m.EmailAddresses
	}
	return nil
}

func (m *Profile) GetPhoneNumbers() []*Phone {
	if m != nil {
		return m.PhoneNumbers
	}
	return nil
}

func (m *Profile) GetPersonalUris() []*PersonalUri {
	if m != nil {
		return m.PersonalUris
	}
	return nil
}

func (m *Profile) GetAdditionalContactInfo() []*AdditionalContactInfo {
	if m != nil {
		return m.AdditionalContactInfo
	}
	return nil
}

func (m *Profile) GetEmploymentRecords() []*EmploymentRecord {
	if m != nil {
		return m.EmploymentRecords
	}
	return nil
}

func (m *Profile) GetEducationRecords() []*EducationRecord {
	if m != nil {
		return m.EducationRecords
	}
	return nil
}

func (m *Profile) GetSkills() []*Skill {
	if m != nil {
		return m.Skills
	}
	return nil
}

func (m *Profile) GetActivities() []*Activity {
	if m != nil {
		return m.Activities
	}
	return nil
}

func (m *Profile) GetPublications() []*Publication {
	if m != nil {
		return m.Publications
	}
	return nil
}

func (m *Profile) GetPatents() []*Patent {
	if m != nil {
		return m.Patents
	}
	return nil
}

func (m *Profile) GetCertifications() []*Certification {
	if m != nil {
		return m.Certifications
	}
	return nil
}

func (m *Profile) GetJobApplications() []*JobApplication {
	if m != nil {
		return m.JobApplications
	}
	return nil
}

func (m *Profile) GetRecruitingNotes() []*RecruitingNote {
	if m != nil {
		return m.RecruitingNotes
	}
	return nil
}

func (m *Profile) GetCustomAttributes() map[string]*CustomAttribute {
	if m != nil {
		return m.CustomAttributes
	}
	return nil
}

func (m *Profile) GetProcessed() bool {
	if m != nil {
		return m.Processed
	}
	return false
}

func (m *Profile) GetKeywordSnippet() string {
	if m != nil {
		return m.KeywordSnippet
	}
	return ""
}

// Resource that represents the name of a person.
type PersonName struct {
	// The name of a person. It can be one of [formatted_name][] or
	// [structured_name][].
	//
	// Types that are valid to be assigned to PersonName:
	//	*PersonName_FormattedName
	//	*PersonName_StructuredName
	PersonName isPersonName_PersonName `protobuf_oneof:"person_name"`
	// Optional.
	//
	// Preferred name for the person.
	PreferredName        string   `protobuf:"bytes,3,opt,name=preferred_name,json=preferredName,proto3" json:"preferred_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonName) Reset()         { *m = PersonName{} }
func (m *PersonName) String() string { return proto.CompactTextString(m) }
func (*PersonName) ProtoMessage()    {}
func (*PersonName) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{1}
}
func (m *PersonName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonName.Unmarshal(m, b)
}
func (m *PersonName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonName.Marshal(b, m, deterministic)
}
func (dst *PersonName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonName.Merge(dst, src)
}
func (m *PersonName) XXX_Size() int {
	return xxx_messageInfo_PersonName.Size(m)
}
func (m *PersonName) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonName.DiscardUnknown(m)
}

var xxx_messageInfo_PersonName proto.InternalMessageInfo

type isPersonName_PersonName interface {
	isPersonName_PersonName()
}

type PersonName_FormattedName struct {
	FormattedName string `protobuf:"bytes,1,opt,name=formatted_name,json=formattedName,proto3,oneof"`
}

type PersonName_StructuredName struct {
	StructuredName *PersonName_PersonStructuredName `protobuf:"bytes,2,opt,name=structured_name,json=structuredName,proto3,oneof"`
}

func (*PersonName_FormattedName) isPersonName_PersonName() {}

func (*PersonName_StructuredName) isPersonName_PersonName() {}

func (m *PersonName) GetPersonName() isPersonName_PersonName {
	if m != nil {
		return m.PersonName
	}
	return nil
}

func (m *PersonName) GetFormattedName() string {
	if x, ok := m.GetPersonName().(*PersonName_FormattedName); ok {
		return x.FormattedName
	}
	return ""
}

func (m *PersonName) GetStructuredName() *PersonName_PersonStructuredName {
	if x, ok := m.GetPersonName().(*PersonName_StructuredName); ok {
		return x.StructuredName
	}
	return nil
}

func (m *PersonName) GetPreferredName() string {
	if m != nil {
		return m.PreferredName
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PersonName) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PersonName_OneofMarshaler, _PersonName_OneofUnmarshaler, _PersonName_OneofSizer, []interface{}{
		(*PersonName_FormattedName)(nil),
		(*PersonName_StructuredName)(nil),
	}
}

func _PersonName_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PersonName)
	// person_name
	switch x := m.PersonName.(type) {
	case *PersonName_FormattedName:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FormattedName)
	case *PersonName_StructuredName:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructuredName); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PersonName.PersonName has unexpected type %T", x)
	}
	return nil
}

func _PersonName_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PersonName)
	switch tag {
	case 1: // person_name.formatted_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PersonName = &PersonName_FormattedName{x}
		return true, err
	case 2: // person_name.structured_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PersonName_PersonStructuredName)
		err := b.DecodeMessage(msg)
		m.PersonName = &PersonName_StructuredName{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PersonName_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PersonName)
	// person_name
	switch x := m.PersonName.(type) {
	case *PersonName_FormattedName:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.FormattedName)))
		n += len(x.FormattedName)
	case *PersonName_StructuredName:
		s := proto.Size(x.StructuredName)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Resource that represents a person's structured name.
type PersonName_PersonStructuredName struct {
	// Optional.
	//
	// Given/first name.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 100.
	GivenName string `protobuf:"bytes,1,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Optional.
	//
	// Middle initial.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 20.
	MiddleInitial string `protobuf:"bytes,2,opt,name=middle_initial,json=middleInitial,proto3" json:"middle_initial,omitempty"`
	// Optional.
	//
	// Family/last name.
	//
	// It's derived from [formatted_name][google.cloud.talent.v4beta1.PersonName.formatted_name] if not provided.
	//
	// Number of characters allowed is 100.
	FamilyName string `protobuf:"bytes,3,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// Optional.
	//
	// Suffixes.
	//
	// Number of characters allowed is 20.
	Suffixes []string `protobuf:"bytes,4,rep,name=suffixes,proto3" json:"suffixes,omitempty"`
	// Optional.
	//
	// Prefixes.
	//
	// Number of characters allowed is 20.
	Prefixes             []string `protobuf:"bytes,5,rep,name=prefixes,proto3" json:"prefixes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonName_PersonStructuredName) Reset()         { *m = PersonName_PersonStructuredName{} }
func (m *PersonName_PersonStructuredName) String() string { return proto.CompactTextString(m) }
func (*PersonName_PersonStructuredName) ProtoMessage()    {}
func (*PersonName_PersonStructuredName) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{1, 0}
}
func (m *PersonName_PersonStructuredName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonName_PersonStructuredName.Unmarshal(m, b)
}
func (m *PersonName_PersonStructuredName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonName_PersonStructuredName.Marshal(b, m, deterministic)
}
func (dst *PersonName_PersonStructuredName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonName_PersonStructuredName.Merge(dst, src)
}
func (m *PersonName_PersonStructuredName) XXX_Size() int {
	return xxx_messageInfo_PersonName_PersonStructuredName.Size(m)
}
func (m *PersonName_PersonStructuredName) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonName_PersonStructuredName.DiscardUnknown(m)
}

var xxx_messageInfo_PersonName_PersonStructuredName proto.InternalMessageInfo

func (m *PersonName_PersonStructuredName) GetGivenName() string {
	if m != nil {
		return m.GivenName
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetMiddleInitial() string {
	if m != nil {
		return m.MiddleInitial
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *PersonName_PersonStructuredName) GetSuffixes() []string {
	if m != nil {
		return m.Suffixes
	}
	return nil
}

func (m *PersonName_PersonStructuredName) GetPrefixes() []string {
	if m != nil {
		return m.Prefixes
	}
	return nil
}

// Resource that represents a address.
type Address struct {
	// Optional.
	//
	// The usage of the address. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// The address of a person. It can be one of [unstructured_address][] or
	// [structured_address][].
	//
	// Types that are valid to be assigned to Address:
	//	*Address_UnstructuredAddress
	//	*Address_StructuredAddress
	Address isAddress_Address `protobuf_oneof:"address"`
	// Optional.
	//
	// Indicates if it's the person's current address.
	IsCurrent            *wrappers.BoolValue `protobuf:"bytes,4,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Address) Reset()         { *m = Address{} }
func (m *Address) String() string { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()    {}
func (*Address) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{2}
}
func (m *Address) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Address.Unmarshal(m, b)
}
func (m *Address) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Address.Marshal(b, m, deterministic)
}
func (dst *Address) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Address.Merge(dst, src)
}
func (m *Address) XXX_Size() int {
	return xxx_messageInfo_Address.Size(m)
}
func (m *Address) XXX_DiscardUnknown() {
	xxx_messageInfo_Address.DiscardUnknown(m)
}

var xxx_messageInfo_Address proto.InternalMessageInfo

func (m *Address) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

type isAddress_Address interface {
	isAddress_Address()
}

type Address_UnstructuredAddress struct {
	UnstructuredAddress string `protobuf:"bytes,2,opt,name=unstructured_address,json=unstructuredAddress,proto3,oneof"`
}

type Address_StructuredAddress struct {
	StructuredAddress *postaladdress.PostalAddress `protobuf:"bytes,3,opt,name=structured_address,json=structuredAddress,proto3,oneof"`
}

func (*Address_UnstructuredAddress) isAddress_Address() {}

func (*Address_StructuredAddress) isAddress_Address() {}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetUnstructuredAddress() string {
	if x, ok := m.GetAddress().(*Address_UnstructuredAddress); ok {
		return x.UnstructuredAddress
	}
	return ""
}

func (m *Address) GetStructuredAddress() *postaladdress.PostalAddress {
	if x, ok := m.GetAddress().(*Address_StructuredAddress); ok {
		return x.StructuredAddress
	}
	return nil
}

func (m *Address) GetIsCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.IsCurrent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Address) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Address_OneofMarshaler, _Address_OneofUnmarshaler, _Address_OneofSizer, []interface{}{
		(*Address_UnstructuredAddress)(nil),
		(*Address_StructuredAddress)(nil),
	}
}

func _Address_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_UnstructuredAddress:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.UnstructuredAddress)
	case *Address_StructuredAddress:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructuredAddress); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Address.Address has unexpected type %T", x)
	}
	return nil
}

func _Address_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Address)
	switch tag {
	case 2: // address.unstructured_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Address = &Address_UnstructuredAddress{x}
		return true, err
	case 3: // address.structured_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(postaladdress.PostalAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_StructuredAddress{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Address_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_UnstructuredAddress:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.UnstructuredAddress)))
		n += len(x.UnstructuredAddress)
	case *Address_StructuredAddress:
		s := proto.Size(x.StructuredAddress)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Resource that represents a person's email address.
type Email struct {
	// Optional.
	//
	// The usage of the email address. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional.
	//
	// Email address.
	//
	// Number of characters allowed is 4,000.
	EmailAddress         string   `protobuf:"bytes,2,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Email) Reset()         { *m = Email{} }
func (m *Email) String() string { return proto.CompactTextString(m) }
func (*Email) ProtoMessage()    {}
func (*Email) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{3}
}
func (m *Email) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Email.Unmarshal(m, b)
}
func (m *Email) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Email.Marshal(b, m, deterministic)
}
func (dst *Email) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Email.Merge(dst, src)
}
func (m *Email) XXX_Size() int {
	return xxx_messageInfo_Email.Size(m)
}
func (m *Email) XXX_DiscardUnknown() {
	xxx_messageInfo_Email.DiscardUnknown(m)
}

var xxx_messageInfo_Email proto.InternalMessageInfo

func (m *Email) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *Email) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

// Resource that represents a person's telephone number.
type Phone struct {
	// Optional.
	//
	// The usage of the phone. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional.
	//
	// The phone type. For example, LANDLINE, MOBILE, FAX.
	Type Phone_PhoneType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.talent.v4beta1.Phone_PhoneType" json:"type,omitempty"`
	// Optional.
	//
	// Phone number.
	//
	// Any phone formats are supported and only exact matches are performed on
	// searches. For example, if a phone number in profile is provided in the
	// format of "(xxx)xxx-xxxx", in profile searches the same phone format
	// has to be provided.
	//
	// Number of characters allowed is 20.
	Number string `protobuf:"bytes,3,opt,name=number,proto3" json:"number,omitempty"`
	// Optional.
	//
	// When this number is available. Any descriptive string is expected.
	//
	// Number of characters allowed is 100.
	WhenAvailable        string   `protobuf:"bytes,4,opt,name=when_available,json=whenAvailable,proto3" json:"when_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Phone) Reset()         { *m = Phone{} }
func (m *Phone) String() string { return proto.CompactTextString(m) }
func (*Phone) ProtoMessage()    {}
func (*Phone) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{4}
}
func (m *Phone) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Phone.Unmarshal(m, b)
}
func (m *Phone) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Phone.Marshal(b, m, deterministic)
}
func (dst *Phone) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Phone.Merge(dst, src)
}
func (m *Phone) XXX_Size() int {
	return xxx_messageInfo_Phone.Size(m)
}
func (m *Phone) XXX_DiscardUnknown() {
	xxx_messageInfo_Phone.DiscardUnknown(m)
}

var xxx_messageInfo_Phone proto.InternalMessageInfo

func (m *Phone) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *Phone) GetType() Phone_PhoneType {
	if m != nil {
		return m.Type
	}
	return Phone_PHONE_TYPE_UNSPECIFIED
}

func (m *Phone) GetNumber() string {
	if m != nil {
		return m.Number
	}
	return ""
}

func (m *Phone) GetWhenAvailable() string {
	if m != nil {
		return m.WhenAvailable
	}
	return ""
}

// Resource that represents a valid URI for a personal use.
type PersonalUri struct {
	// Optional.
	//
	// The personal URI.
	//
	// Number of characters allowed is 4,000.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PersonalUri) Reset()         { *m = PersonalUri{} }
func (m *PersonalUri) String() string { return proto.CompactTextString(m) }
func (*PersonalUri) ProtoMessage()    {}
func (*PersonalUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{5}
}
func (m *PersonalUri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PersonalUri.Unmarshal(m, b)
}
func (m *PersonalUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PersonalUri.Marshal(b, m, deterministic)
}
func (dst *PersonalUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersonalUri.Merge(dst, src)
}
func (m *PersonalUri) XXX_Size() int {
	return xxx_messageInfo_PersonalUri.Size(m)
}
func (m *PersonalUri) XXX_DiscardUnknown() {
	xxx_messageInfo_PersonalUri.DiscardUnknown(m)
}

var xxx_messageInfo_PersonalUri proto.InternalMessageInfo

func (m *PersonalUri) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// Resource that represents contact information other than phone, email,
// URI and addresses.
type AdditionalContactInfo struct {
	// Optional.
	//
	// The usage of this contact method. For example, SCHOOL, WORK, PERSONAL.
	Usage ContactInfoUsage `protobuf:"varint,1,opt,name=usage,proto3,enum=google.cloud.talent.v4beta1.ContactInfoUsage" json:"usage,omitempty"`
	// Optional.
	//
	// The name of the contact method.
	//
	// For example, "hangout", "skype".
	//
	// Number of characters allowed is 100.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional.
	//
	// The contact id.
	//
	// Number of characters allowed is 100.
	ContactId            string   `protobuf:"bytes,3,opt,name=contact_id,json=contactId,proto3" json:"contact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AdditionalContactInfo) Reset()         { *m = AdditionalContactInfo{} }
func (m *AdditionalContactInfo) String() string { return proto.CompactTextString(m) }
func (*AdditionalContactInfo) ProtoMessage()    {}
func (*AdditionalContactInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{6}
}
func (m *AdditionalContactInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdditionalContactInfo.Unmarshal(m, b)
}
func (m *AdditionalContactInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdditionalContactInfo.Marshal(b, m, deterministic)
}
func (dst *AdditionalContactInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdditionalContactInfo.Merge(dst, src)
}
func (m *AdditionalContactInfo) XXX_Size() int {
	return xxx_messageInfo_AdditionalContactInfo.Size(m)
}
func (m *AdditionalContactInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdditionalContactInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdditionalContactInfo proto.InternalMessageInfo

func (m *AdditionalContactInfo) GetUsage() ContactInfoUsage {
	if m != nil {
		return m.Usage
	}
	return ContactInfoUsage_CONTACT_INFO_USAGE_UNSPECIFIED
}

func (m *AdditionalContactInfo) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AdditionalContactInfo) GetContactId() string {
	if m != nil {
		return m.ContactId
	}
	return ""
}

// Resource that represents an employment record of a candidate.
type EmploymentRecord struct {
	// Optional.
	//
	// Start date of the employment.
	//
	// It can be a partial date (only year, or only year and month), but must be
	// valid. Otherwise an error is thrown.
	//
	// Examples:
	// {"year": 2017, "month": 2, "day": 28} is valid.
	// {"year": 2020, "month": 1, "date": 31} is valid.
	// {"year": 2018, "month": 12} is valid (partial date).
	// {"year": 2018} is valid (partial date).
	// {"year": 2015, "day": 21} is not valid (month is missing but day is
	// presented).
	// {"year": 2018, "month": 13} is not valid (invalid month).
	// {"year": 2017, "month": 1, "day": 32} is not valid (invalid day).
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional.
	//
	// End date of the employment.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Optional.
	//
	// The name of the employer company/organization.
	//
	// For example, "Google", "Alphabet", etc.
	//
	// Number of characters allowed is 100.
	EmployerName string `protobuf:"bytes,3,opt,name=employer_name,json=employerName,proto3" json:"employer_name,omitempty"`
	// Optional.
	//
	// The division name of the employment.
	//
	// For example, division, department, client, etc.
	//
	// Number of characters allowed is 100.
	DivisionName string `protobuf:"bytes,4,opt,name=division_name,json=divisionName,proto3" json:"division_name,omitempty"`
	// Optional.
	//
	// The physical address of the employer.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// Optional.
	//
	// The job title of the employment.
	//
	// For example, "Software Engineer", "Data Scientist", etc.
	//
	// Number of characters allowed is 100.
	JobTitle string `protobuf:"bytes,6,opt,name=job_title,json=jobTitle,proto3" json:"job_title,omitempty"`
	// Optional.
	//
	// The description of job content.
	//
	// Number of characters allowed is 100,000.
	JobDescription string `protobuf:"bytes,7,opt,name=job_description,json=jobDescription,proto3" json:"job_description,omitempty"`
	// Optional.
	//
	// If it's a supervised position.
	IsSupervisedPosition *wrappers.BoolValue `protobuf:"bytes,8,opt,name=is_supervised_position,json=isSupervisedPosition,proto3" json:"is_supervised_position,omitempty"`
	// Optional.
	//
	// If this employment is self-employed.
	IsSelfEmployed *wrappers.BoolValue `protobuf:"bytes,9,opt,name=is_self_employed,json=isSelfEmployed,proto3" json:"is_self_employed,omitempty"`
	// Optional.
	//
	// If this employment is current.
	IsCurrent *wrappers.BoolValue `protobuf:"bytes,10,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The job title snippet shows how the [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] is related
	// to a search query. It's empty if the [job_title][google.cloud.talent.v4beta1.EmploymentRecord.job_title] isn't related to the
	// search query.
	JobTitleSnippet string `protobuf:"bytes,11,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Output only. The job description snippet shows how the [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description]
	// is related to a search query. It's empty if the [job_description][google.cloud.talent.v4beta1.EmploymentRecord.job_description] isn't
	// related to the search query.
	JobDescriptionSnippet string `protobuf:"bytes,12,opt,name=job_description_snippet,json=jobDescriptionSnippet,proto3" json:"job_description_snippet,omitempty"`
	// Output only. The employer name snippet shows how the [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name] is
	// related to a search query. It's empty if the [employer_name][google.cloud.talent.v4beta1.EmploymentRecord.employer_name] isn't
	// related to the search query.
	EmployerNameSnippet  string   `protobuf:"bytes,13,opt,name=employer_name_snippet,json=employerNameSnippet,proto3" json:"employer_name_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmploymentRecord) Reset()         { *m = EmploymentRecord{} }
func (m *EmploymentRecord) String() string { return proto.CompactTextString(m) }
func (*EmploymentRecord) ProtoMessage()    {}
func (*EmploymentRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{7}
}
func (m *EmploymentRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmploymentRecord.Unmarshal(m, b)
}
func (m *EmploymentRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmploymentRecord.Marshal(b, m, deterministic)
}
func (dst *EmploymentRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmploymentRecord.Merge(dst, src)
}
func (m *EmploymentRecord) XXX_Size() int {
	return xxx_messageInfo_EmploymentRecord.Size(m)
}
func (m *EmploymentRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EmploymentRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EmploymentRecord proto.InternalMessageInfo

func (m *EmploymentRecord) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *EmploymentRecord) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *EmploymentRecord) GetEmployerName() string {
	if m != nil {
		return m.EmployerName
	}
	return ""
}

func (m *EmploymentRecord) GetDivisionName() string {
	if m != nil {
		return m.DivisionName
	}
	return ""
}

func (m *EmploymentRecord) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *EmploymentRecord) GetJobTitle() string {
	if m != nil {
		return m.JobTitle
	}
	return ""
}

func (m *EmploymentRecord) GetJobDescription() string {
	if m != nil {
		return m.JobDescription
	}
	return ""
}

func (m *EmploymentRecord) GetIsSupervisedPosition() *wrappers.BoolValue {
	if m != nil {
		return m.IsSupervisedPosition
	}
	return nil
}

func (m *EmploymentRecord) GetIsSelfEmployed() *wrappers.BoolValue {
	if m != nil {
		return m.IsSelfEmployed
	}
	return nil
}

func (m *EmploymentRecord) GetIsCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.IsCurrent
	}
	return nil
}

func (m *EmploymentRecord) GetJobTitleSnippet() string {
	if m != nil {
		return m.JobTitleSnippet
	}
	return ""
}

func (m *EmploymentRecord) GetJobDescriptionSnippet() string {
	if m != nil {
		return m.JobDescriptionSnippet
	}
	return ""
}

func (m *EmploymentRecord) GetEmployerNameSnippet() string {
	if m != nil {
		return m.EmployerNameSnippet
	}
	return ""
}

// Resource that represents an education record of a candidate.
type EducationRecord struct {
	// Optional.
	//
	// The start date of the education.
	StartDate *date.Date `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// Optional.
	//
	// The end date of the education.
	EndDate *date.Date `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
	// Optional.
	//
	// The expected graduation date if currently pursuing a degree.
	ExpectedGraduationDate *date.Date `protobuf:"bytes,3,opt,name=expected_graduation_date,json=expectedGraduationDate,proto3" json:"expected_graduation_date,omitempty"`
	// Optional.
	//
	// The name of the school or institution.
	//
	// For example, "Stanford University", "UC Berkeley", etc.
	//
	// Number of characters allowed is 100.
	SchoolName string `protobuf:"bytes,4,opt,name=school_name,json=schoolName,proto3" json:"school_name,omitempty"`
	// Optional.
	//
	// The physical address of the education institution.
	Address *Address `protobuf:"bytes,5,opt,name=address,proto3" json:"address,omitempty"`
	// The degree information. It can be one of [degree_description][] or
	// [structured_degree][].
	//
	// Types that are valid to be assigned to Degree:
	//	*EducationRecord_DegreeDescription
	//	*EducationRecord_StructuredDegree
	Degree isEducationRecord_Degree `protobuf_oneof:"degree"`
	// Optional.
	//
	// The description of the education.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// Optional.
	//
	// If this education is current.
	IsCurrent *wrappers.BoolValue `protobuf:"bytes,9,opt,name=is_current,json=isCurrent,proto3" json:"is_current,omitempty"`
	// Output only. The school name snippet shows how the [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name] is
	// related to a search query in search result. It's empty if the
	// [school_name][google.cloud.talent.v4beta1.EducationRecord.school_name] isn't related to the search query.
	SchoolNameSnippet string `protobuf:"bytes,10,opt,name=school_name_snippet,json=schoolNameSnippet,proto3" json:"school_name_snippet,omitempty"`
	// Output only. The job description snippet shows how the [degree][google.cloud.talent.v4beta1.degree] is
	// related to a search query in search result. It's empty if the [degree][google.cloud.talent.v4beta1.degree]
	// isn't related to the search query.
	DegreeSnippet        string   `protobuf:"bytes,11,opt,name=degree_snippet,json=degreeSnippet,proto3" json:"degree_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EducationRecord) Reset()         { *m = EducationRecord{} }
func (m *EducationRecord) String() string { return proto.CompactTextString(m) }
func (*EducationRecord) ProtoMessage()    {}
func (*EducationRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{8}
}
func (m *EducationRecord) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EducationRecord.Unmarshal(m, b)
}
func (m *EducationRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EducationRecord.Marshal(b, m, deterministic)
}
func (dst *EducationRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EducationRecord.Merge(dst, src)
}
func (m *EducationRecord) XXX_Size() int {
	return xxx_messageInfo_EducationRecord.Size(m)
}
func (m *EducationRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_EducationRecord.DiscardUnknown(m)
}

var xxx_messageInfo_EducationRecord proto.InternalMessageInfo

func (m *EducationRecord) GetStartDate() *date.Date {
	if m != nil {
		return m.StartDate
	}
	return nil
}

func (m *EducationRecord) GetEndDate() *date.Date {
	if m != nil {
		return m.EndDate
	}
	return nil
}

func (m *EducationRecord) GetExpectedGraduationDate() *date.Date {
	if m != nil {
		return m.ExpectedGraduationDate
	}
	return nil
}

func (m *EducationRecord) GetSchoolName() string {
	if m != nil {
		return m.SchoolName
	}
	return ""
}

func (m *EducationRecord) GetAddress() *Address {
	if m != nil {
		return m.Address
	}
	return nil
}

type isEducationRecord_Degree interface {
	isEducationRecord_Degree()
}

type EducationRecord_DegreeDescription struct {
	DegreeDescription string `protobuf:"bytes,6,opt,name=degree_description,json=degreeDescription,proto3,oneof"`
}

type EducationRecord_StructuredDegree struct {
	StructuredDegree *Degree `protobuf:"bytes,7,opt,name=structured_degree,json=structuredDegree,proto3,oneof"`
}

func (*EducationRecord_DegreeDescription) isEducationRecord_Degree() {}

func (*EducationRecord_StructuredDegree) isEducationRecord_Degree() {}

func (m *EducationRecord) GetDegree() isEducationRecord_Degree {
	if m != nil {
		return m.Degree
	}
	return nil
}

func (m *EducationRecord) GetDegreeDescription() string {
	if x, ok := m.GetDegree().(*EducationRecord_DegreeDescription); ok {
		return x.DegreeDescription
	}
	return ""
}

func (m *EducationRecord) GetStructuredDegree() *Degree {
	if x, ok := m.GetDegree().(*EducationRecord_StructuredDegree); ok {
		return x.StructuredDegree
	}
	return nil
}

func (m *EducationRecord) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *EducationRecord) GetIsCurrent() *wrappers.BoolValue {
	if m != nil {
		return m.IsCurrent
	}
	return nil
}

func (m *EducationRecord) GetSchoolNameSnippet() string {
	if m != nil {
		return m.SchoolNameSnippet
	}
	return ""
}

func (m *EducationRecord) GetDegreeSnippet() string {
	if m != nil {
		return m.DegreeSnippet
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*EducationRecord) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _EducationRecord_OneofMarshaler, _EducationRecord_OneofUnmarshaler, _EducationRecord_OneofSizer, []interface{}{
		(*EducationRecord_DegreeDescription)(nil),
		(*EducationRecord_StructuredDegree)(nil),
	}
}

func _EducationRecord_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*EducationRecord)
	// degree
	switch x := m.Degree.(type) {
	case *EducationRecord_DegreeDescription:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.DegreeDescription)
	case *EducationRecord_StructuredDegree:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructuredDegree); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("EducationRecord.Degree has unexpected type %T", x)
	}
	return nil
}

func _EducationRecord_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*EducationRecord)
	switch tag {
	case 6: // degree.degree_description
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Degree = &EducationRecord_DegreeDescription{x}
		return true, err
	case 7: // degree.structured_degree
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Degree)
		err := b.DecodeMessage(msg)
		m.Degree = &EducationRecord_StructuredDegree{msg}
		return true, err
	default:
		return false, nil
	}
}

func _EducationRecord_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*EducationRecord)
	// degree
	switch x := m.Degree.(type) {
	case *EducationRecord_DegreeDescription:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.DegreeDescription)))
		n += len(x.DegreeDescription)
	case *EducationRecord_StructuredDegree:
		s := proto.Size(x.StructuredDegree)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Resource that represents a degree pursuing or acquired by a candidate.
type Degree struct {
	// Optional.
	//
	// ISCED degree type.
	DegreeType DegreeType `protobuf:"varint,1,opt,name=degree_type,json=degreeType,proto3,enum=google.cloud.talent.v4beta1.DegreeType" json:"degree_type,omitempty"`
	// Optional.
	//
	// Full Degree name.
	//
	// For example, "B.S.", "Master of Arts", etc.
	//
	// Number of characters allowed is 100.
	DegreeName string `protobuf:"bytes,2,opt,name=degree_name,json=degreeName,proto3" json:"degree_name,omitempty"`
	// Optional.
	//
	// Fields of study for the degree.
	//
	// For example, "Computer science", "engineering".
	//
	// Number of characters allowed is 100.
	FieldsOfStudy        []string `protobuf:"bytes,3,rep,name=fields_of_study,json=fieldsOfStudy,proto3" json:"fields_of_study,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Degree) Reset()         { *m = Degree{} }
func (m *Degree) String() string { return proto.CompactTextString(m) }
func (*Degree) ProtoMessage()    {}
func (*Degree) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{9}
}
func (m *Degree) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Degree.Unmarshal(m, b)
}
func (m *Degree) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Degree.Marshal(b, m, deterministic)
}
func (dst *Degree) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Degree.Merge(dst, src)
}
func (m *Degree) XXX_Size() int {
	return xxx_messageInfo_Degree.Size(m)
}
func (m *Degree) XXX_DiscardUnknown() {
	xxx_messageInfo_Degree.DiscardUnknown(m)
}

var xxx_messageInfo_Degree proto.InternalMessageInfo

func (m *Degree) GetDegreeType() DegreeType {
	if m != nil {
		return m.DegreeType
	}
	return DegreeType_DEGREE_TYPE_UNSPECIFIED
}

func (m *Degree) GetDegreeName() string {
	if m != nil {
		return m.DegreeName
	}
	return ""
}

func (m *Degree) GetFieldsOfStudy() []string {
	if m != nil {
		return m.FieldsOfStudy
	}
	return nil
}

// Resource that represents a skill of a candidate.
type Skill struct {
	// Optional.
	//
	// Skill display name.
	//
	// For example, "Java", "Python".
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional.
	//
	// The last time this skill was used.
	LastUsedDate *date.Date `protobuf:"bytes,2,opt,name=last_used_date,json=lastUsedDate,proto3" json:"last_used_date,omitempty"`
	// Optional.
	//
	// Skill proficiency level which indicates how proficient the candidate is at
	// this skill.
	Level Skill_SkillProficiencyLevel `protobuf:"varint,3,opt,name=level,proto3,enum=google.cloud.talent.v4beta1.Skill_SkillProficiencyLevel" json:"level,omitempty"`
	// Optional.
	//
	// A paragraph describes context of this skill.
	//
	// Number of characters allowed is 100,000.
	Context string `protobuf:"bytes,4,opt,name=context,proto3" json:"context,omitempty"`
	// Output only. Skill name snippet shows how the [display_name][google.cloud.talent.v4beta1.Skill.display_name] is related
	// to a search query. It's empty if the [display_name][google.cloud.talent.v4beta1.Skill.display_name] isn't related to the
	// search query.
	SkillNameSnippet     string   `protobuf:"bytes,5,opt,name=skill_name_snippet,json=skillNameSnippet,proto3" json:"skill_name_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Skill) Reset()         { *m = Skill{} }
func (m *Skill) String() string { return proto.CompactTextString(m) }
func (*Skill) ProtoMessage()    {}
func (*Skill) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{10}
}
func (m *Skill) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Skill.Unmarshal(m, b)
}
func (m *Skill) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Skill.Marshal(b, m, deterministic)
}
func (dst *Skill) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Skill.Merge(dst, src)
}
func (m *Skill) XXX_Size() int {
	return xxx_messageInfo_Skill.Size(m)
}
func (m *Skill) XXX_DiscardUnknown() {
	xxx_messageInfo_Skill.DiscardUnknown(m)
}

var xxx_messageInfo_Skill proto.InternalMessageInfo

func (m *Skill) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Skill) GetLastUsedDate() *date.Date {
	if m != nil {
		return m.LastUsedDate
	}
	return nil
}

func (m *Skill) GetLevel() Skill_SkillProficiencyLevel {
	if m != nil {
		return m.Level
	}
	return Skill_SKILL_PROFICIENCY_LEVEL_UNSPECIFIED
}

func (m *Skill) GetContext() string {
	if m != nil {
		return m.Context
	}
	return ""
}

func (m *Skill) GetSkillNameSnippet() string {
	if m != nil {
		return m.SkillNameSnippet
	}
	return ""
}

// Resource that represents an individual or collaborative activity participated
// in by a candidate, for example, an open-source project, a class assignment,
// etc.
type Activity struct {
	// Optional.
	//
	// Activity display name.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional.
	//
	// Activity description.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Optional.
	//
	// Activity URI.
	//
	// Number of characters allowed is 4,000.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Optional.
	//
	// The first creation date of the activity.
	CreateDate *date.Date `protobuf:"bytes,4,opt,name=create_date,json=createDate,proto3" json:"create_date,omitempty"`
	// Optional.
	//
	// The last update date of the activity.
	UpdateDate *date.Date `protobuf:"bytes,5,opt,name=update_date,json=updateDate,proto3" json:"update_date,omitempty"`
	// Optional.
	//
	// A list of team members involved in this activity.
	//
	// Number of characters allowed is 100.
	TeamMembers []string `protobuf:"bytes,6,rep,name=team_members,json=teamMembers,proto3" json:"team_members,omitempty"`
	// Optional.
	//
	// A list of skills used in this activity.
	SkillsUsed []*Skill `protobuf:"bytes,7,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
	// Output only. Activity name snippet shows how the [display_name][google.cloud.talent.v4beta1.Activity.display_name] is
	// related to a search query. It's empty if the [display_name][google.cloud.talent.v4beta1.Activity.display_name] isn't related
	// to the search query.
	ActivityNameSnippet string `protobuf:"bytes,8,opt,name=activity_name_snippet,json=activityNameSnippet,proto3" json:"activity_name_snippet,omitempty"`
	// Output only. Activity description snippet shows how the
	// [description][google.cloud.talent.v4beta1.Activity.description] is related to a search query. It's empty if the
	// [description][google.cloud.talent.v4beta1.Activity.description] isn't related to the search query.
	ActivityDescriptionSnippet string `protobuf:"bytes,9,opt,name=activity_description_snippet,json=activityDescriptionSnippet,proto3" json:"activity_description_snippet,omitempty"`
	// Output only. Skill used snippet shows how the corresponding
	// [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are related to a search query. It's empty if the
	// corresponding [skills_used][google.cloud.talent.v4beta1.Activity.skills_used] are not related to the search query.
	SkillsUsedSnippet    []string `protobuf:"bytes,10,rep,name=skills_used_snippet,json=skillsUsedSnippet,proto3" json:"skills_used_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Activity) Reset()         { *m = Activity{} }
func (m *Activity) String() string { return proto.CompactTextString(m) }
func (*Activity) ProtoMessage()    {}
func (*Activity) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{11}
}
func (m *Activity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Activity.Unmarshal(m, b)
}
func (m *Activity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Activity.Marshal(b, m, deterministic)
}
func (dst *Activity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Activity.Merge(dst, src)
}
func (m *Activity) XXX_Size() int {
	return xxx_messageInfo_Activity.Size(m)
}
func (m *Activity) XXX_DiscardUnknown() {
	xxx_messageInfo_Activity.DiscardUnknown(m)
}

var xxx_messageInfo_Activity proto.InternalMessageInfo

func (m *Activity) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Activity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Activity) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Activity) GetCreateDate() *date.Date {
	if m != nil {
		return m.CreateDate
	}
	return nil
}

func (m *Activity) GetUpdateDate() *date.Date {
	if m != nil {
		return m.UpdateDate
	}
	return nil
}

func (m *Activity) GetTeamMembers() []string {
	if m != nil {
		return m.TeamMembers
	}
	return nil
}

func (m *Activity) GetSkillsUsed() []*Skill {
	if m != nil {
		return m.SkillsUsed
	}
	return nil
}

func (m *Activity) GetActivityNameSnippet() string {
	if m != nil {
		return m.ActivityNameSnippet
	}
	return ""
}

func (m *Activity) GetActivityDescriptionSnippet() string {
	if m != nil {
		return m.ActivityDescriptionSnippet
	}
	return ""
}

func (m *Activity) GetSkillsUsedSnippet() []string {
	if m != nil {
		return m.SkillsUsedSnippet
	}
	return nil
}

// Resource that represents a publication resource of a candidate.
type Publication struct {
	// Optional.
	//
	// A list of author names.
	//
	// Number of characters allowed is 100.
	Authors []string `protobuf:"bytes,1,rep,name=authors,proto3" json:"authors,omitempty"`
	// Optional.
	//
	// The title of the publication.
	//
	// Number of characters allowed is 100.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional.
	//
	// The description of the publication.
	//
	// Number of characters allowed is 100,000.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional.
	//
	// The journal name of the publication.
	//
	// Number of characters allowed is 100.
	Journal string `protobuf:"bytes,4,opt,name=journal,proto3" json:"journal,omitempty"`
	// Optional.
	//
	// Volume number.
	//
	// Number of characters allowed is 100.
	Volume string `protobuf:"bytes,5,opt,name=volume,proto3" json:"volume,omitempty"`
	// Optional.
	//
	// The publisher of the journal.
	//
	// Number of characters allowed is 100.
	Publisher string `protobuf:"bytes,6,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// Optional.
	//
	// The publication date.
	PublicationDate *date.Date `protobuf:"bytes,7,opt,name=publication_date,json=publicationDate,proto3" json:"publication_date,omitempty"`
	// Optional.
	//
	// The publication type.
	//
	// Number of characters allowed is 100.
	PublicationType string `protobuf:"bytes,8,opt,name=publication_type,json=publicationType,proto3" json:"publication_type,omitempty"`
	// Optional.
	//
	// ISBN number.
	//
	// Number of characters allowed is 100.
	Isbn                 string   `protobuf:"bytes,9,opt,name=isbn,proto3" json:"isbn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Publication) Reset()         { *m = Publication{} }
func (m *Publication) String() string { return proto.CompactTextString(m) }
func (*Publication) ProtoMessage()    {}
func (*Publication) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{12}
}
func (m *Publication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Publication.Unmarshal(m, b)
}
func (m *Publication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Publication.Marshal(b, m, deterministic)
}
func (dst *Publication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Publication.Merge(dst, src)
}
func (m *Publication) XXX_Size() int {
	return xxx_messageInfo_Publication.Size(m)
}
func (m *Publication) XXX_DiscardUnknown() {
	xxx_messageInfo_Publication.DiscardUnknown(m)
}

var xxx_messageInfo_Publication proto.InternalMessageInfo

func (m *Publication) GetAuthors() []string {
	if m != nil {
		return m.Authors
	}
	return nil
}

func (m *Publication) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Publication) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Publication) GetJournal() string {
	if m != nil {
		return m.Journal
	}
	return ""
}

func (m *Publication) GetVolume() string {
	if m != nil {
		return m.Volume
	}
	return ""
}

func (m *Publication) GetPublisher() string {
	if m != nil {
		return m.Publisher
	}
	return ""
}

func (m *Publication) GetPublicationDate() *date.Date {
	if m != nil {
		return m.PublicationDate
	}
	return nil
}

func (m *Publication) GetPublicationType() string {
	if m != nil {
		return m.PublicationType
	}
	return ""
}

func (m *Publication) GetIsbn() string {
	if m != nil {
		return m.Isbn
	}
	return ""
}

// Resource that represents the patent acquired by a candidate.
type Patent struct {
	// Optional.
	//
	// Name of the patent.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional.
	//
	// A list of inventors' names.
	//
	// Number of characters allowed for each is 100.
	Inventors []string `protobuf:"bytes,2,rep,name=inventors,proto3" json:"inventors,omitempty"`
	// Optional.
	//
	// The status of the patent.
	//
	// Number of characters allowed is 100.
	PatentStatus string `protobuf:"bytes,3,opt,name=patent_status,json=patentStatus,proto3" json:"patent_status,omitempty"`
	// Optional.
	//
	// The date the last time the status of the patent was checked.
	PatentStatusDate *date.Date `protobuf:"bytes,4,opt,name=patent_status_date,json=patentStatusDate,proto3" json:"patent_status_date,omitempty"`
	// Optional.
	//
	// The date that the patent was filed.
	PatentFilingDate *date.Date `protobuf:"bytes,5,opt,name=patent_filing_date,json=patentFilingDate,proto3" json:"patent_filing_date,omitempty"`
	// Optional.
	//
	// The name of the patent office.
	//
	// Number of characters allowed is 100.
	PatentOffice string `protobuf:"bytes,6,opt,name=patent_office,json=patentOffice,proto3" json:"patent_office,omitempty"`
	// Optional.
	//
	// The number of the patent.
	//
	// Number of characters allowed is 100.
	PatentNumber string `protobuf:"bytes,7,opt,name=patent_number,json=patentNumber,proto3" json:"patent_number,omitempty"`
	// Optional.
	//
	// The description of the patent.
	//
	// Number of characters allowed is 100,000.
	PatentDescription string `protobuf:"bytes,8,opt,name=patent_description,json=patentDescription,proto3" json:"patent_description,omitempty"`
	// Optional.
	//
	// The skills used in this patent.
	SkillsUsed           []*Skill `protobuf:"bytes,9,rep,name=skills_used,json=skillsUsed,proto3" json:"skills_used,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Patent) Reset()         { *m = Patent{} }
func (m *Patent) String() string { return proto.CompactTextString(m) }
func (*Patent) ProtoMessage()    {}
func (*Patent) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{13}
}
func (m *Patent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Patent.Unmarshal(m, b)
}
func (m *Patent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Patent.Marshal(b, m, deterministic)
}
func (dst *Patent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Patent.Merge(dst, src)
}
func (m *Patent) XXX_Size() int {
	return xxx_messageInfo_Patent.Size(m)
}
func (m *Patent) XXX_DiscardUnknown() {
	xxx_messageInfo_Patent.DiscardUnknown(m)
}

var xxx_messageInfo_Patent proto.InternalMessageInfo

func (m *Patent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Patent) GetInventors() []string {
	if m != nil {
		return m.Inventors
	}
	return nil
}

func (m *Patent) GetPatentStatus() string {
	if m != nil {
		return m.PatentStatus
	}
	return ""
}

func (m *Patent) GetPatentStatusDate() *date.Date {
	if m != nil {
		return m.PatentStatusDate
	}
	return nil
}

func (m *Patent) GetPatentFilingDate() *date.Date {
	if m != nil {
		return m.PatentFilingDate
	}
	return nil
}

func (m *Patent) GetPatentOffice() string {
	if m != nil {
		return m.PatentOffice
	}
	return ""
}

func (m *Patent) GetPatentNumber() string {
	if m != nil {
		return m.PatentNumber
	}
	return ""
}

func (m *Patent) GetPatentDescription() string {
	if m != nil {
		return m.PatentDescription
	}
	return ""
}

func (m *Patent) GetSkillsUsed() []*Skill {
	if m != nil {
		return m.SkillsUsed
	}
	return nil
}

// Resource that represents a job application record of a candidate.
type JobApplication struct {
	// Optional.
	//
	// The information of job which the candidate applied for.
	//
	// If [Job.name][google.cloud.talent.v4beta1.Job.name] is provided, the corresponding [Job][google.cloud.talent.v4beta1.Job] must be created.
	//
	// Otherwise, only [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id], [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.description][google.cloud.talent.v4beta1.Job.description] and [Job.addresses][google.cloud.talent.v4beta1.Job.addresses] provided here are persisted
	// in the application. No [Job][google.cloud.talent.v4beta1.Job] entity is created in this case.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Optional.
	//
	// The job application id.
	//
	// Number of characters allowed is 100.
	ApplicationId string `protobuf:"bytes,2,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Optional.
	//
	// The application date.
	ApplicationDate *date.Date `protobuf:"bytes,3,opt,name=application_date,json=applicationDate,proto3" json:"application_date,omitempty"`
	// Optional.
	//
	// The last stage the candidate reached in the application progress.
	// For example, "new", "phone screen", "interview".
	LastStage string `protobuf:"bytes,4,opt,name=last_stage,json=lastStage,proto3" json:"last_stage,omitempty"`
	// Optional.
	//
	// The application state.
	State JobApplication_ApplicationStatus `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.talent.v4beta1.JobApplication_ApplicationStatus" json:"state,omitempty"`
	// Optional.
	//
	// The average interview score.
	AverageInterviewScore float64 `protobuf:"fixed64,6,opt,name=average_interview_score,json=averageInterviewScore,proto3" json:"average_interview_score,omitempty"`
	// Optional.
	//
	// The scale id of the interview score.
	//
	// Number of characters allowed is 100.
	InterviewScoreScaleId string `protobuf:"bytes,7,opt,name=interview_score_scale_id,json=interviewScoreScaleId,proto3" json:"interview_score_scale_id,omitempty"`
	// Optional.
	//
	// The number of interviews.
	NumberOfInterviews int32 `protobuf:"varint,8,opt,name=number_of_interviews,json=numberOfInterviews,proto3" json:"number_of_interviews,omitempty"`
	// Optional.
	//
	// If the candidate is referred by a employee.
	IsEmployeeReferred *wrappers.BoolValue `protobuf:"bytes,9,opt,name=is_employee_referred,json=isEmployeeReferred,proto3" json:"is_employee_referred,omitempty"`
	// Optional.
	//
	// The last update timestamp.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional.
	//
	// The outcome reason for the job application.
	//
	// Number of characters allowed is 100.
	OutcomeReason string `protobuf:"bytes,11,opt,name=outcome_reason,json=outcomeReason,proto3" json:"outcome_reason,omitempty"`
	// Optional.
	//
	// Outcome positiveness shows how positive the outcome is.
	//
	// Currently only -1, 0 and 1 are accepted, where -1 means not positive, 0
	// means neutral and 1 means positive. An error is thrown if other value is
	// set.
	OutcomePositiveness float64 `protobuf:"fixed64,12,opt,name=outcome_positiveness,json=outcomePositiveness,proto3" json:"outcome_positiveness,omitempty"`
	// Output only. Indicates whether this job application is a match to
	// application related filters. This value is only applicable in profile
	// search response.
	IsMatch *wrappers.BoolValue `protobuf:"bytes,13,opt,name=is_match,json=isMatch,proto3" json:"is_match,omitempty"`
	// Output only. Job title snippet shows how the job title is related to a
	// search query. It's empty if the job title isn't related to the search
	// query.
	JobTitleSnippet      string   `protobuf:"bytes,14,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobApplication) Reset()         { *m = JobApplication{} }
func (m *JobApplication) String() string { return proto.CompactTextString(m) }
func (*JobApplication) ProtoMessage()    {}
func (*JobApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{14}
}
func (m *JobApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobApplication.Unmarshal(m, b)
}
func (m *JobApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobApplication.Marshal(b, m, deterministic)
}
func (dst *JobApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobApplication.Merge(dst, src)
}
func (m *JobApplication) XXX_Size() int {
	return xxx_messageInfo_JobApplication.Size(m)
}
func (m *JobApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_JobApplication.DiscardUnknown(m)
}

var xxx_messageInfo_JobApplication proto.InternalMessageInfo

func (m *JobApplication) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *JobApplication) GetApplicationId() string {
	if m != nil {
		return m.ApplicationId
	}
	return ""
}

func (m *JobApplication) GetApplicationDate() *date.Date {
	if m != nil {
		return m.ApplicationDate
	}
	return nil
}

func (m *JobApplication) GetLastStage() string {
	if m != nil {
		return m.LastStage
	}
	return ""
}

func (m *JobApplication) GetState() JobApplication_ApplicationStatus {
	if m != nil {
		return m.State
	}
	return JobApplication_APPLICATION_STATUS_UNSPECIFIED
}

func (m *JobApplication) GetAverageInterviewScore() float64 {
	if m != nil {
		return m.AverageInterviewScore
	}
	return 0
}

func (m *JobApplication) GetInterviewScoreScaleId() string {
	if m != nil {
		return m.InterviewScoreScaleId
	}
	return ""
}

func (m *JobApplication) GetNumberOfInterviews() int32 {
	if m != nil {
		return m.NumberOfInterviews
	}
	return 0
}

func (m *JobApplication) GetIsEmployeeReferred() *wrappers.BoolValue {
	if m != nil {
		return m.IsEmployeeReferred
	}
	return nil
}

func (m *JobApplication) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *JobApplication) GetOutcomeReason() string {
	if m != nil {
		return m.OutcomeReason
	}
	return ""
}

func (m *JobApplication) GetOutcomePositiveness() float64 {
	if m != nil {
		return m.OutcomePositiveness
	}
	return 0
}

func (m *JobApplication) GetIsMatch() *wrappers.BoolValue {
	if m != nil {
		return m.IsMatch
	}
	return nil
}

func (m *JobApplication) GetJobTitleSnippet() string {
	if m != nil {
		return m.JobTitleSnippet
	}
	return ""
}

// Resource that represents a license or certification.
type Certification struct {
	// Optional.
	//
	// Name of license or certification.
	//
	// Number of characters allowed is 100.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional.
	//
	// Acquirement date or effective date of license or certification.
	AcquireDate *date.Date `protobuf:"bytes,2,opt,name=acquire_date,json=acquireDate,proto3" json:"acquire_date,omitempty"`
	// Optional.
	//
	// Expiration date of license of certification.
	ExpireDate *date.Date `protobuf:"bytes,3,opt,name=expire_date,json=expireDate,proto3" json:"expire_date,omitempty"`
	// Optional.
	//
	// Authority of license, such as government.
	//
	// Number of characters allowed is 100.
	Authority string `protobuf:"bytes,4,opt,name=authority,proto3" json:"authority,omitempty"`
	// Optional.
	//
	// Description of license or certification.
	//
	// Number of characters allowed is 100,000.
	Description          string   `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Certification) Reset()         { *m = Certification{} }
func (m *Certification) String() string { return proto.CompactTextString(m) }
func (*Certification) ProtoMessage()    {}
func (*Certification) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{15}
}
func (m *Certification) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Certification.Unmarshal(m, b)
}
func (m *Certification) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Certification.Marshal(b, m, deterministic)
}
func (dst *Certification) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Certification.Merge(dst, src)
}
func (m *Certification) XXX_Size() int {
	return xxx_messageInfo_Certification.Size(m)
}
func (m *Certification) XXX_DiscardUnknown() {
	xxx_messageInfo_Certification.DiscardUnknown(m)
}

var xxx_messageInfo_Certification proto.InternalMessageInfo

func (m *Certification) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Certification) GetAcquireDate() *date.Date {
	if m != nil {
		return m.AcquireDate
	}
	return nil
}

func (m *Certification) GetExpireDate() *date.Date {
	if m != nil {
		return m.ExpireDate
	}
	return nil
}

func (m *Certification) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

func (m *Certification) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// RecruitingNote represents a note/comment regarding the recruiting for a
// candidate. For example, "This candidate is a potential match for a frontend
// engineer at SF".
type RecruitingNote struct {
	// Optional.
	//
	// The content of note.
	//
	// Number of characters allowed is 4,000.
	Note string `protobuf:"bytes,1,opt,name=note,proto3" json:"note,omitempty"`
	// Optional.
	//
	// The person who wrote the notes.
	//
	// Number of characters allowed is 100.
	Commenter string `protobuf:"bytes,2,opt,name=commenter,proto3" json:"commenter,omitempty"`
	// Optional.
	//
	// The create date of the note.
	CreateDate *date.Date `protobuf:"bytes,3,opt,name=create_date,json=createDate,proto3" json:"create_date,omitempty"`
	// Optional.
	//
	// The note type.
	//
	// Number of characters allowed is 100.
	Type                 string   `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecruitingNote) Reset()         { *m = RecruitingNote{} }
func (m *RecruitingNote) String() string { return proto.CompactTextString(m) }
func (*RecruitingNote) ProtoMessage()    {}
func (*RecruitingNote) Descriptor() ([]byte, []int) {
	return fileDescriptor_profile_bb9206fda8e136da, []int{16}
}
func (m *RecruitingNote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecruitingNote.Unmarshal(m, b)
}
func (m *RecruitingNote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecruitingNote.Marshal(b, m, deterministic)
}
func (dst *RecruitingNote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecruitingNote.Merge(dst, src)
}
func (m *RecruitingNote) XXX_Size() int {
	return xxx_messageInfo_RecruitingNote.Size(m)
}
func (m *RecruitingNote) XXX_DiscardUnknown() {
	xxx_messageInfo_RecruitingNote.DiscardUnknown(m)
}

var xxx_messageInfo_RecruitingNote proto.InternalMessageInfo

func (m *RecruitingNote) GetNote() string {
	if m != nil {
		return m.Note
	}
	return ""
}

func (m *RecruitingNote) GetCommenter() string {
	if m != nil {
		return m.Commenter
	}
	return ""
}

func (m *RecruitingNote) GetCreateDate() *date.Date {
	if m != nil {
		return m.CreateDate
	}
	return nil
}

func (m *RecruitingNote) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func init() {
	proto.RegisterType((*Profile)(nil), "google.cloud.talent.v4beta1.Profile")
	proto.RegisterMapType((map[string]*CustomAttribute)(nil), "google.cloud.talent.v4beta1.Profile.CustomAttributesEntry")
	proto.RegisterType((*PersonName)(nil), "google.cloud.talent.v4beta1.PersonName")
	proto.RegisterType((*PersonName_PersonStructuredName)(nil), "google.cloud.talent.v4beta1.PersonName.PersonStructuredName")
	proto.RegisterType((*Address)(nil), "google.cloud.talent.v4beta1.Address")
	proto.RegisterType((*Email)(nil), "google.cloud.talent.v4beta1.Email")
	proto.RegisterType((*Phone)(nil), "google.cloud.talent.v4beta1.Phone")
	proto.RegisterType((*PersonalUri)(nil), "google.cloud.talent.v4beta1.PersonalUri")
	proto.RegisterType((*AdditionalContactInfo)(nil), "google.cloud.talent.v4beta1.AdditionalContactInfo")
	proto.RegisterType((*EmploymentRecord)(nil), "google.cloud.talent.v4beta1.EmploymentRecord")
	proto.RegisterType((*EducationRecord)(nil), "google.cloud.talent.v4beta1.EducationRecord")
	proto.RegisterType((*Degree)(nil), "google.cloud.talent.v4beta1.Degree")
	proto.RegisterType((*Skill)(nil), "google.cloud.talent.v4beta1.Skill")
	proto.RegisterType((*Activity)(nil), "google.cloud.talent.v4beta1.Activity")
	proto.RegisterType((*Publication)(nil), "google.cloud.talent.v4beta1.Publication")
	proto.RegisterType((*Patent)(nil), "google.cloud.talent.v4beta1.Patent")
	proto.RegisterType((*JobApplication)(nil), "google.cloud.talent.v4beta1.JobApplication")
	proto.RegisterType((*Certification)(nil), "google.cloud.talent.v4beta1.Certification")
	proto.RegisterType((*RecruitingNote)(nil), "google.cloud.talent.v4beta1.RecruitingNote")
	proto.RegisterEnum("google.cloud.talent.v4beta1.Phone_PhoneType", Phone_PhoneType_name, Phone_PhoneType_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.Skill_SkillProficiencyLevel", Skill_SkillProficiencyLevel_name, Skill_SkillProficiencyLevel_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobApplication_ApplicationStatus", JobApplication_ApplicationStatus_name, JobApplication_ApplicationStatus_value)
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/profile.proto", fileDescriptor_profile_bb9206fda8e136da)
}

var fileDescriptor_profile_bb9206fda8e136da = []byte{
	// 2880 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x59, 0x4f, 0x73, 0xdb, 0xc6,
	0x15, 0x37, 0x45, 0x51, 0x14, 0x1f, 0xff, 0x88, 0x5a, 0x4b, 0x0a, 0xa2, 0x38, 0xb1, 0x42, 0xd7,
	0xb5, 0x93, 0x26, 0x52, 0xa3, 0xa4, 0x4d, 0x9a, 0x3f, 0x6d, 0x28, 0x12, 0xb6, 0x10, 0x53, 0x14,
	0x67, 0x49, 0xa9, 0x71, 0xa7, 0x33, 0x18, 0x08, 0x58, 0x52, 0xab, 0x80, 0x00, 0x82, 0x05, 0x64,
	0xeb, 0xda, 0x63, 0xa7, 0x33, 0x9d, 0x4e, 0x67, 0x7a, 0xe9, 0xad, 0xbd, 0xa6, 0xbd, 0xf5, 0x33,
	0xf4, 0xde, 0x4b, 0x2f, 0x3d, 0xf5, 0x2b, 0xf4, 0x0b, 0x74, 0xf6, 0x0f, 0x40, 0x90, 0x96, 0x28,
	0xb9, 0xe3, 0x5e, 0x38, 0xd8, 0xb7, 0xef, 0xf7, 0x76, 0xf7, 0xbd, 0xb7, 0xfb, 0x7e, 0xbb, 0x84,
	0x77, 0x46, 0xbe, 0x3f, 0x72, 0xc9, 0x8e, 0xed, 0xfa, 0xb1, 0xb3, 0x13, 0x59, 0x2e, 0xf1, 0xa2,
	0x9d, 0xf3, 0x8f, 0x4e, 0x48, 0x64, 0x7d, 0xb0, 0x13, 0x84, 0xfe, 0x90, 0xba, 0x64, 0x3b, 0x08,
	0xfd, 0xc8, 0x47, 0x6f, 0x48, 0xd5, 0x6d, 0xa1, 0xba, 0x2d, 0x55, 0xb7, 0x95, 0xea, 0xe6, 0x1d,
	0x65, 0xc7, 0x0a, 0xe8, 0x8e, 0xe5, 0x79, 0x7e, 0x64, 0x45, 0xd4, 0xf7, 0x98, 0x84, 0x6e, 0x3e,
	0x9c, 0x37, 0x8a, 0xed, 0x8f, 0xc7, 0xbe, 0xa7, 0x34, 0xef, 0xcf, 0xd3, 0x3c, 0xf3, 0x4f, 0x94,
	0xda, 0x5d, 0xa5, 0x26, 0x5a, 0x27, 0xf1, 0x70, 0x27, 0xa2, 0x63, 0xc2, 0x22, 0x6b, 0x1c, 0x28,
	0x85, 0xb7, 0x66, 0x15, 0x9e, 0x85, 0x56, 0x10, 0x90, 0x30, 0x99, 0xd1, 0x86, 0xea, 0x8f, 0x2e,
	0x02, 0xb2, 0xe3, 0x58, 0x91, 0x5a, 0xe4, 0xe6, 0x56, 0x56, 0x1e, 0xf8, 0x2c, 0xb2, 0x5c, 0xd3,
	0x72, 0x9c, 0x90, 0x30, 0x85, 0x6c, 0x7c, 0x57, 0x83, 0x62, 0x4f, 0x3a, 0x06, 0x21, 0x58, 0xf4,
	0xac, 0x31, 0xd1, 0x72, 0x5b, 0xb9, 0x87, 0x25, 0x2c, 0xbe, 0xd1, 0x5d, 0x28, 0x93, 0xe7, 0x11,
	0x09, 0x3d, 0xcb, 0x35, 0xa9, 0xa3, 0x2d, 0x88, 0x2e, 0x48, 0x44, 0x86, 0x83, 0x36, 0x60, 0x89,
	0xf9, 0x71, 0x68, 0x13, 0x2d, 0x2f, 0xfa, 0x54, 0x0b, 0xd5, 0x21, 0x1f, 0x87, 0x54, 0x5b, 0x14,
	0x42, 0xfe, 0x89, 0x5e, 0x87, 0xe5, 0x51, 0xe8, 0xc7, 0x01, 0xb7, 0x53, 0x10, 0xe2, 0xa2, 0x68,
	0x1b, 0x0e, 0xfa, 0x09, 0x00, 0x65, 0xe6, 0x29, 0x0d, 0xad, 0x13, 0x97, 0x68, 0x4b, 0x5b, 0xb9,
	0x87, 0xe5, 0xdd, 0xcd, 0x6d, 0x15, 0xa1, 0x64, 0xd1, 0xdb, 0x7b, 0xbe, 0xef, 0x1e, 0x5b, 0x6e,
	0x4c, 0x70, 0x89, 0xb2, 0x7d, 0xa9, 0x8c, 0x3e, 0x83, 0xb2, 0x1d, 0x12, 0x2b, 0x22, 0x26, 0x77,
	0x9a, 0x56, 0xbc, 0x02, 0x3b, 0x48, 0x3c, 0x8a, 0x41, 0xaa, 0x73, 0x01, 0x07, 0xc7, 0x81, 0x93,
	0x82, 0x97, 0xaf, 0x07, 0x4b, 0x75, 0x01, 0x7e, 0x1b, 0x2a, 0x21, 0x61, 0xf1, 0x98, 0x98, 0xa7,
	0xe1, 0xf3, 0xb1, 0xab, 0x81, 0x58, 0x53, 0x59, 0xca, 0xf6, 0xb9, 0x08, 0x7d, 0x05, 0x15, 0x1e,
	0x25, 0xdf, 0x33, 0xb9, 0x33, 0x99, 0x56, 0xde, 0xca, 0x3f, 0x2c, 0xef, 0x3e, 0xd8, 0x9e, 0x93,
	0x7b, 0xdb, 0x3d, 0x01, 0xe8, 0x5a, 0x63, 0x82, 0xcb, 0x41, 0xfa, 0xcd, 0xd0, 0x1e, 0x94, 0x54,
	0xe8, 0x08, 0xd3, 0x2a, 0xc2, 0xd0, 0xf7, 0xe6, 0x1a, 0x6a, 0x4a, 0x6d, 0x3c, 0x81, 0xa1, 0x27,
	0xb0, 0x42, 0xc6, 0x16, 0x4d, 0x93, 0x80, 0x30, 0xad, 0x2a, 0x2c, 0x35, 0xe6, 0x5a, 0xd2, 0x39,
	0x06, 0xd7, 0x04, 0xb4, 0x99, 0x1a, 0x7b, 0x0c, 0xd5, 0xe0, 0xd4, 0xf7, 0x88, 0xe9, 0xc5, 0xe3,
	0x13, 0x12, 0x32, 0xad, 0x76, 0x03, 0x53, 0x3d, 0x8e, 0xc0, 0x15, 0x01, 0xec, 0x4a, 0x1c, 0x3a,
	0x80, 0xaa, 0x5c, 0xa8, 0xe5, 0x9a, 0x71, 0x48, 0x99, 0xb6, 0x22, 0x0c, 0x3d, 0xbc, 0x81, 0x9b,
	0x2c, 0xf7, 0x28, 0xa4, 0xb8, 0x12, 0x4c, 0x1a, 0x0c, 0x9d, 0xc1, 0x6b, 0x96, 0xe3, 0x50, 0xbe,
	0x63, 0x2d, 0xd7, 0xb4, 0x7d, 0x2f, 0xb2, 0xec, 0xc8, 0xa4, 0xde, 0xd0, 0xd7, 0xea, 0xc2, 0xf0,
	0xee, 0x75, 0x6e, 0x53, 0xd8, 0x96, 0x84, 0x1a, 0xde, 0xd0, 0xc7, 0xeb, 0xd6, 0x65, 0x62, 0xf4,
	0x4b, 0x40, 0x64, 0x1c, 0xb8, 0xfe, 0xc5, 0x98, 0x78, 0x91, 0x19, 0x12, 0xdb, 0x0f, 0x1d, 0xa6,
	0xad, 0x8a, 0x61, 0xde, 0xbf, 0xc6, 0xa7, 0x09, 0x0c, 0x0b, 0x14, 0x5e, 0x25, 0x33, 0x12, 0x86,
	0x9e, 0xc2, 0x2a, 0x71, 0x62, 0x5b, 0x1c, 0x3e, 0xa9, 0x71, 0x24, 0x8c, 0xbf, 0x37, 0xdf, 0x78,
	0x82, 0x52, 0xb6, 0xeb, 0x64, 0x5a, 0xc0, 0xd0, 0xa7, 0xb0, 0xc4, 0xbe, 0xa1, 0xae, 0xcb, 0xb4,
	0xdb, 0x37, 0x88, 0x5a, 0x9f, 0xab, 0x62, 0x85, 0x40, 0x3a, 0x80, 0x65, 0x47, 0xf4, 0x9c, 0x46,
	0x94, 0x30, 0x6d, 0x4d, 0xe0, 0xef, 0xcf, 0xf7, 0xa9, 0x54, 0xbf, 0xc0, 0x19, 0x20, 0xea, 0x40,
	0x25, 0x88, 0x4f, 0x5c, 0x2a, 0x27, 0xc6, 0xb4, 0xf5, 0x9b, 0x44, 0x7d, 0x02, 0xc0, 0x53, 0x68,
	0xf4, 0x05, 0x14, 0x03, 0x2b, 0x22, 0x5e, 0xc4, 0xb4, 0x0d, 0x61, 0xe8, 0xde, 0x7c, 0x43, 0x42,
	0x17, 0x27, 0x18, 0x84, 0xa1, 0x66, 0x93, 0x30, 0xa2, 0xc3, 0x74, 0x3a, 0xaf, 0x09, 0x2b, 0xef,
	0xce, 0xb5, 0xd2, 0xca, 0x42, 0xf0, 0x8c, 0x05, 0x74, 0x0c, 0xf5, 0x33, 0xff, 0xc4, 0xb4, 0x82,
	0x60, 0xb2, 0x48, 0x4d, 0x58, 0xfd, 0xc1, 0x5c, 0xab, 0x5f, 0xf9, 0x27, 0xcd, 0x09, 0x06, 0xaf,
	0x9c, 0x4d, 0xb5, 0x85, 0xdd, 0x90, 0xd8, 0x61, 0x4c, 0x23, 0xea, 0x8d, 0x4c, 0xcf, 0x8f, 0x08,
	0xd3, 0x5e, 0xbf, 0x81, 0x5d, 0x9c, 0x82, 0xba, 0x7e, 0x44, 0xf0, 0x4a, 0x38, 0xd5, 0x66, 0x68,
	0x04, 0xab, 0x76, 0xcc, 0x22, 0x7f, 0x6c, 0x5a, 0x51, 0x14, 0xd2, 0x93, 0x98, 0x1b, 0xde, 0x14,
	0x86, 0x3f, 0x9d, 0xef, 0x4c, 0x55, 0x59, 0x5b, 0x02, 0xdd, 0x4c, 0xc1, 0xba, 0x17, 0x85, 0x17,
	0xb8, 0x6e, 0xcf, 0x88, 0xd1, 0x1d, 0x28, 0x05, 0xa1, 0x6f, 0xf3, 0x63, 0xc4, 0xd1, 0xde, 0xd8,
	0xca, 0x3d, 0x5c, 0xc6, 0x13, 0x01, 0x7a, 0x00, 0x2b, 0xdf, 0x90, 0x8b, 0x67, 0x7e, 0xe8, 0x98,
	0xcc, 0xa3, 0x41, 0x40, 0x22, 0xed, 0x8e, 0x38, 0x5a, 0x6b, 0x4a, 0xdc, 0x97, 0xd2, 0xcd, 0x6f,
	0x61, 0xfd, 0xd2, 0x11, 0x79, 0xed, 0xf9, 0x86, 0x5c, 0xa8, 0x3a, 0xc6, 0x3f, 0xd1, 0x1e, 0x14,
	0xce, 0x79, 0xe5, 0x10, 0x05, 0xec, 0xba, 0xdd, 0x33, 0x63, 0x14, 0x4b, 0xe8, 0xa7, 0x0b, 0x9f,
	0xe4, 0x1a, 0xbf, 0xc9, 0x03, 0x4c, 0x0e, 0x68, 0xf4, 0x00, 0x6a, 0x43, 0x3f, 0x1c, 0x5b, 0x51,
	0x44, 0x1c, 0x73, 0x52, 0x3b, 0xf7, 0x6f, 0xe1, 0x6a, 0x2a, 0x17, 0x8a, 0x23, 0x58, 0x61, 0x51,
	0x18, 0xdb, 0x51, 0x1c, 0x26, 0x9a, 0x72, 0x26, 0x9f, 0xdf, 0xb0, 0x16, 0xa8, 0xcf, 0x7e, 0x6a,
	0x84, 0x0b, 0xf7, 0x6f, 0xe1, 0x1a, 0x9b, 0x92, 0xa0, 0xfb, 0x50, 0x0b, 0x42, 0x32, 0x24, 0x61,
	0x3a, 0x8e, 0x2c, 0xcb, 0xd5, 0x54, 0xca, 0xd5, 0x36, 0xff, 0x96, 0x83, 0xb5, 0xcb, 0x2c, 0xa2,
	0x37, 0x01, 0x46, 0xf4, 0x9c, 0x78, 0x99, 0xd5, 0xe0, 0x92, 0x90, 0x24, 0xe6, 0xc7, 0xd4, 0x71,
	0x5c, 0x62, 0x52, 0x8f, 0x46, 0xd4, 0x72, 0x15, 0x23, 0xa8, 0x4a, 0xa9, 0x21, 0x85, 0x9c, 0x35,
	0x0c, 0xad, 0x31, 0x75, 0x2f, 0xb2, 0x53, 0x00, 0x29, 0x12, 0x76, 0x36, 0x61, 0x99, 0xc5, 0xc3,
	0x21, 0x7d, 0x4e, 0x98, 0xb6, 0xb8, 0x95, 0x7f, 0x58, 0xc2, 0x69, 0x9b, 0xf7, 0xf1, 0xc9, 0x8a,
	0xbe, 0x82, 0xec, 0x4b, 0xda, 0x7b, 0x55, 0x28, 0x67, 0x0a, 0x6a, 0xe3, 0x0f, 0x0b, 0x50, 0x54,
	0x05, 0x09, 0xb5, 0xa0, 0x10, 0x33, 0x6b, 0x24, 0x27, 0x5d, 0xbb, 0xe6, 0xf4, 0xcd, 0x9c, 0xe1,
	0x47, 0x1c, 0x84, 0x25, 0x16, 0x7d, 0x08, 0x6b, 0xb1, 0x97, 0x89, 0x94, 0xaa, 0x93, 0x72, 0x95,
	0xfb, 0xb7, 0xf0, 0xed, 0x6c, 0x6f, 0x32, 0xf2, 0x13, 0x40, 0x97, 0x40, 0xf2, 0xd3, 0x64, 0x82,
	0x53, 0xb0, 0xed, 0x9e, 0xa0, 0x60, 0x0a, 0xb7, 0x7f, 0x0b, 0xaf, 0xbe, 0x68, 0x4c, 0x52, 0x21,
	0x3b, 0x0e, 0x43, 0xe2, 0x45, 0x82, 0x3e, 0x5d, 0x4b, 0x85, 0x5a, 0x52, 0x79, 0xaf, 0x04, 0x45,
	0x35, 0x78, 0xe3, 0x5b, 0x28, 0x88, 0xa2, 0xfd, 0x6a, 0xbc, 0x72, 0x0f, 0xaa, 0x53, 0xb4, 0x41,
	0x05, 0xbd, 0x92, 0x25, 0x04, 0x8d, 0xff, 0x2c, 0x40, 0x41, 0x54, 0xf7, 0x57, 0x33, 0xe6, 0x97,
	0xb0, 0xc8, 0x5d, 0x26, 0x86, 0xaa, 0x5d, 0xb3, 0x61, 0xc5, 0xb0, 0xf2, 0x77, 0x70, 0x11, 0x10,
	0x2c, 0x90, 0x9c, 0x99, 0x4a, 0x66, 0x92, 0x30, 0x53, 0xd9, 0xe2, 0x39, 0xfc, 0xec, 0x94, 0x78,
	0xa6, 0x75, 0x6e, 0x51, 0x57, 0x10, 0x4e, 0x49, 0x52, 0xab, 0x5c, 0xda, 0x4c, 0x84, 0x8d, 0x3f,
	0xe7, 0xa0, 0x94, 0x9a, 0x44, 0x9b, 0xb0, 0xd1, 0xdb, 0x3f, 0xec, 0xea, 0xe6, 0xe0, 0x69, 0x4f,
	0x37, 0x8f, 0xba, 0xfd, 0x9e, 0xde, 0x32, 0x1e, 0x19, 0x7a, 0xbb, 0x7e, 0x0b, 0x55, 0x60, 0xb9,
	0xd3, 0xec, 0xb6, 0x3b, 0x46, 0x57, 0xaf, 0xe7, 0x10, 0xc0, 0xd2, 0xc1, 0xe1, 0x9e, 0xd1, 0xd1,
	0xeb, 0x0b, 0xa8, 0x08, 0xf9, 0x47, 0xcd, 0xaf, 0xeb, 0x79, 0x54, 0x82, 0x42, 0xaf, 0xf9, 0x58,
	0xc7, 0xf5, 0x45, 0x54, 0x03, 0x18, 0x0c, 0x9e, 0x9a, 0x87, 0xd8, 0x1c, 0xb4, 0xdb, 0xf5, 0x02,
	0xaa, 0x42, 0xe9, 0xf8, 0xd0, 0x68, 0xe9, 0x07, 0x4d, 0xa3, 0x53, 0x5f, 0x42, 0x65, 0x28, 0x1e,
	0x1b, 0x78, 0x70, 0xd4, 0xec, 0xd4, 0x8b, 0x68, 0x19, 0x16, 0x8f, 0x0f, 0x8d, 0x5e, 0x7d, 0x19,
	0x6d, 0x00, 0x92, 0x56, 0x39, 0x30, 0x1d, 0xad, 0xd4, 0xb8, 0x0b, 0xe5, 0x0c, 0x13, 0x4a, 0x58,
	0x77, 0x2e, 0x65, 0xdd, 0x8d, 0xdf, 0xe6, 0x60, 0xfd, 0x52, 0x4a, 0xf3, 0x6a, 0xc2, 0x94, 0xdc,
	0x19, 0x16, 0x32, 0x77, 0x86, 0x37, 0x01, 0x52, 0xd6, 0xe5, 0x28, 0xe7, 0x97, 0x94, 0xc4, 0x70,
	0x1a, 0x7f, 0x29, 0x40, 0x7d, 0x96, 0xfd, 0xa0, 0x1f, 0x02, 0xb0, 0xc8, 0x0a, 0x23, 0x93, 0xd3,
	0x6b, 0x31, 0xa3, 0xf2, 0xee, 0xea, 0xd4, 0xde, 0x69, 0x5b, 0x11, 0xc1, 0x25, 0xa1, 0xc4, 0x3f,
	0xd1, 0x7b, 0xb0, 0x4c, 0x3c, 0x47, 0xea, 0x2f, 0x5c, 0xa5, 0x5f, 0x24, 0x9e, 0x23, 0xb4, 0x45,
	0x0a, 0xf3, 0x31, 0x49, 0x98, 0x3d, 0x93, 0x2a, 0x89, 0x50, 0x9c, 0x4a, 0xf7, 0xa0, 0xea, 0xd0,
	0x73, 0xca, 0xa8, 0x3a, 0x5f, 0x54, 0x62, 0x54, 0x12, 0xa1, 0x50, 0xfa, 0x69, 0xba, 0xcb, 0xc4,
	0x2d, 0xe6, 0xa6, 0x2c, 0x3c, 0x01, 0xa1, 0x37, 0xa0, 0xc4, 0x59, 0x41, 0x44, 0x23, 0x75, 0xd5,
	0x29, 0xe1, 0xe5, 0x33, 0xff, 0x64, 0xc0, 0xdb, 0xbc, 0xf6, 0xf1, 0x4e, 0x87, 0x30, 0x3b, 0xa4,
	0x01, 0x8f, 0x99, 0xb8, 0xd1, 0x94, 0x70, 0xed, 0xcc, 0x3f, 0x69, 0x4f, 0xa4, 0xa8, 0x07, 0x1b,
	0x94, 0x99, 0x2c, 0x0e, 0x48, 0x78, 0x4e, 0x19, 0x71, 0xcc, 0xc0, 0x67, 0x22, 0xc6, 0x57, 0x5e,
	0x62, 0x26, 0x47, 0xc6, 0x1a, 0x65, 0xfd, 0x14, 0xd8, 0x53, 0x38, 0xd4, 0x86, 0x3a, 0xb7, 0x48,
	0xdc, 0xa1, 0xa9, 0x9c, 0xe2, 0x68, 0xa5, 0x6b, 0x6d, 0xd5, 0x28, 0xeb, 0x13, 0x77, 0xa8, 0x2b,
	0xc4, 0xcc, 0xf1, 0x05, 0x2f, 0x71, 0x7c, 0xa1, 0x77, 0x61, 0x35, 0x75, 0x4c, 0x5a, 0xf9, 0xcb,
	0x62, 0xf5, 0x2b, 0x89, 0x83, 0x54, 0xe9, 0x47, 0x3f, 0x86, 0xd7, 0x66, 0xfc, 0x94, 0x22, 0x2a,
	0x02, 0xb1, 0x3e, 0xed, 0xaf, 0x04, 0xb7, 0x0b, 0xeb, 0x53, 0x69, 0x90, 0xa2, 0xaa, 0x02, 0x75,
	0x3b, 0x9b, 0x0e, 0x0a, 0xd3, 0xf8, 0xf7, 0x22, 0xac, 0xcc, 0x10, 0xea, 0xff, 0x7b, 0xba, 0x3e,
	0x01, 0x8d, 0x3c, 0x0f, 0x88, 0xcd, 0x79, 0xc5, 0x28, 0xb4, 0x9c, 0x58, 0xde, 0x01, 0x04, 0x3a,
	0x7f, 0x15, 0x7a, 0x23, 0x81, 0x3c, 0x4e, 0x11, 0xc2, 0xd8, 0x5d, 0x28, 0x33, 0xfb, 0xd4, 0xf7,
	0xdd, 0x6c, 0x52, 0x83, 0x14, 0xbd, 0x92, 0x94, 0xde, 0x01, 0xe4, 0x90, 0x51, 0x48, 0xc8, 0x54,
	0xe2, 0x2e, 0xa9, 0x9a, 0xb9, 0x2a, 0xfb, 0xb2, 0xd9, 0x8b, 0x21, 0x53, 0xf9, 0x4c, 0xd9, 0xaf,
	0xae, 0xee, 0xf3, 0x69, 0x7b, 0x5b, 0xa8, 0xee, 0xdf, 0xc2, 0xf5, 0x09, 0x5e, 0xca, 0xd0, 0x16,
	0x94, 0xb3, 0xa3, 0x2f, 0xcb, 0xdb, 0x78, 0x46, 0x34, 0x93, 0x9b, 0xa5, 0x97, 0xc9, 0xcd, 0x6d,
	0xb8, 0x9d, 0x71, 0x61, 0x9a, 0x35, 0xf2, 0xca, 0xbf, 0x3a, 0x71, 0x65, 0x92, 0x67, 0xf7, 0xa1,
	0xa6, 0x3c, 0x32, 0x9d, 0xc8, 0x55, 0x29, 0x55, 0x6a, 0x7b, 0xcb, 0xb0, 0x24, 0x05, 0x8d, 0x3f,
	0xe6, 0x60, 0x49, 0x2d, 0x64, 0x9f, 0x2f, 0x44, 0x60, 0x45, 0x01, 0x94, 0xa7, 0xf3, 0x83, 0x1b,
	0xb8, 0x45, 0xd4, 0x3e, 0x70, 0xd2, 0x6f, 0x1e, 0x78, 0x65, 0x29, 0x73, 0x46, 0x2b, 0x05, 0x11,
	0xf8, 0xef, 0xc3, 0xca, 0x90, 0x12, 0xd7, 0x61, 0xa6, 0x3f, 0x34, 0x59, 0x14, 0x3b, 0x17, 0x5a,
	0x5e, 0x30, 0xae, 0xaa, 0x14, 0x1f, 0x0e, 0xfb, 0x5c, 0xd8, 0xf8, 0x5d, 0x1e, 0x0a, 0xe2, 0x0e,
	0x88, 0xde, 0x86, 0x8a, 0x43, 0x59, 0xe0, 0x5a, 0x17, 0x59, 0x86, 0x58, 0x56, 0x32, 0x61, 0xf4,
	0x63, 0xa8, 0xb9, 0x16, 0x8b, 0xcc, 0x98, 0x1f, 0x4b, 0xf3, 0xf3, 0xbd, 0xc2, 0x15, 0x8f, 0x18,
	0x91, 0x49, 0xdf, 0x85, 0x82, 0x4b, 0xce, 0x89, 0x2b, 0x32, 0xbc, 0xb6, 0xfb, 0xc9, 0xf5, 0x57,
	0x52, 0xf9, 0x2b, 0xae, 0x1f, 0x36, 0x25, 0x9e, 0x7d, 0xd1, 0xe1, 0x78, 0x2c, 0xcd, 0x20, 0x0d,
	0x8a, 0xbc, 0xea, 0x90, 0xe7, 0x91, 0xca, 0xf9, 0xa4, 0x89, 0xde, 0x03, 0x24, 0xee, 0xb2, 0xd3,
	0xd1, 0x94, 0x8f, 0x52, 0x75, 0xd1, 0x93, 0x3d, 0x00, 0x7e, 0x9f, 0x83, 0xf5, 0x4b, 0x07, 0x42,
	0x0f, 0xe0, 0x5e, 0xff, 0x89, 0xd1, 0xe9, 0x98, 0x3d, 0x7c, 0xf8, 0xc8, 0x68, 0x19, 0x7a, 0xb7,
	0xf5, 0xd4, 0xec, 0xe8, 0xc7, 0x7a, 0x67, 0x86, 0x22, 0xbc, 0x0e, 0xeb, 0x8f, 0x8e, 0xba, 0xed,
	0xe6, 0x81, 0xde, 0x1d, 0x34, 0x3b, 0x66, 0xf3, 0xe7, 0x4d, 0xac, 0x77, 0xf5, 0x7e, 0x5f, 0xf2,
	0x85, 0xee, 0xe1, 0xb1, 0xd1, 0xe2, 0x7c, 0xa1, 0x0e, 0x15, 0xa3, 0x3b, 0xd0, 0xf1, 0x81, 0xde,
	0x36, 0x9a, 0x03, 0xbd, 0x9e, 0xe7, 0xdc, 0xa2, 0xd9, 0x3e, 0x6e, 0x76, 0x5b, 0x7a, 0xbb, 0xbe,
	0xc8, 0x75, 0xf5, 0xaf, 0x7b, 0x3a, 0x1e, 0xd4, 0x0b, 0x8d, 0x7f, 0xe6, 0x61, 0x39, 0xb9, 0x57,
	0xdf, 0x24, 0x2c, 0x33, 0xfb, 0x63, 0xe1, 0xc5, 0xfd, 0xa1, 0xc8, 0x43, 0x7e, 0xf2, 0x64, 0xb7,
	0x9b, 0x3e, 0xae, 0x89, 0x38, 0x2e, 0x5e, 0x15, 0x47, 0xf5, 0xa6, 0x26, 0xa2, 0xb8, 0x9b, 0xbe,
	0xa9, 0x09, 0x4c, 0xe1, 0x4a, 0x8c, 0xd4, 0x12, 0x98, 0xb7, 0xa1, 0x12, 0x11, 0x6b, 0x6c, 0x8e,
	0x89, 0x7c, 0x49, 0x5a, 0x12, 0x49, 0x58, 0xe6, 0xb2, 0x03, 0x29, 0x42, 0x2d, 0x28, 0xcb, 0xe7,
	0x07, 0x91, 0x57, 0x5a, 0xf1, 0xc6, 0xaf, 0x16, 0x20, 0x61, 0x3c, 0xcb, 0xf8, 0xf1, 0xaf, 0x1e,
	0x20, 0x2e, 0xa6, 0x43, 0x2f, 0x4f, 0x8b, 0xdb, 0x49, 0x67, 0x76, 0x2b, 0x7f, 0x09, 0x77, 0x52,
	0xcc, 0x65, 0xf5, 0xa6, 0x24, 0xa0, 0x9b, 0x89, 0xce, 0x25, 0x45, 0x87, 0x1f, 0x1e, 0x93, 0xa9,
	0x67, 0x0e, 0x8f, 0xbc, 0x38, 0x3c, 0xd2, 0xe9, 0x25, 0xf9, 0xf6, 0xdd, 0x02, 0x94, 0x33, 0x0f,
	0x1d, 0x3c, 0x8f, 0xad, 0x38, 0x3a, 0xf5, 0x43, 0xa6, 0xe5, 0x04, 0x26, 0x69, 0xa2, 0x35, 0x28,
	0x48, 0x1e, 0x21, 0xa3, 0x29, 0x1b, 0xb3, 0x91, 0xce, 0xbf, 0x18, 0x69, 0x0d, 0x8a, 0x67, 0x7e,
	0x1c, 0x7a, 0x96, 0x9b, 0xec, 0x0c, 0xd5, 0xe4, 0xa4, 0xf9, 0xdc, 0x77, 0xe3, 0x31, 0x51, 0xbb,
	0x41, 0xb5, 0xc4, 0x95, 0x9d, 0x4f, 0x89, 0x9d, 0x92, 0x50, 0xb1, 0x96, 0x89, 0x00, 0x7d, 0x0e,
	0xf5, 0xcc, 0x63, 0x8c, 0x0c, 0x7c, 0xf1, 0xaa, 0xc0, 0xaf, 0x64, 0x54, 0x45, 0xf4, 0xdf, 0x99,
	0x46, 0x8b, 0x53, 0x4f, 0x06, 0x24, 0xab, 0x2a, 0x4e, 0x34, 0x04, 0x8b, 0x94, 0x9d, 0x78, 0xca,
	0xe9, 0xe2, 0xbb, 0xf1, 0xd7, 0x3c, 0x2c, 0xc9, 0xe7, 0x9c, 0x9b, 0x6c, 0x83, 0x3b, 0x50, 0xa2,
	0xde, 0x39, 0xf1, 0x22, 0xee, 0xce, 0x05, 0xe1, 0xce, 0x89, 0x80, 0x33, 0x40, 0xf9, 0x22, 0x64,
	0xb2, 0xc8, 0x8a, 0x62, 0x96, 0xd0, 0x44, 0x29, 0xec, 0x0b, 0x19, 0xfa, 0x19, 0xa0, 0x29, 0xa5,
	0x6b, 0x36, 0x47, 0x3d, 0x0b, 0x16, 0x0b, 0x9e, 0x18, 0x18, 0x52, 0x97, 0x7a, 0xa3, 0x6b, 0x76,
	0x8a, 0x32, 0xf0, 0x48, 0xe8, 0x26, 0x6c, 0x56, 0x19, 0xf0, 0x87, 0x43, 0x6a, 0x27, 0x3c, 0x52,
	0x4d, 0xf3, 0x50, 0xc8, 0x32, 0x4a, 0xea, 0x1a, 0x54, 0xcc, 0x2a, 0xc9, 0xc7, 0x57, 0xf4, 0x7e,
	0x3a, 0x95, 0x17, 0x8b, 0xe7, 0xaa, 0xec, 0xc9, 0x16, 0xee, 0x99, 0x5d, 0x58, 0xfa, 0x5f, 0x76,
	0x61, 0xe3, 0x1f, 0x45, 0xa8, 0x4d, 0xbf, 0x71, 0xa1, 0x5d, 0xc8, 0x9f, 0xf9, 0x27, 0x8a, 0x48,
	0x6d, 0x5d, 0xf7, 0x3a, 0x86, 0xb9, 0x32, 0xaf, 0xb1, 0x99, 0xa7, 0xb5, 0xc9, 0xbf, 0x13, 0xd5,
	0x8c, 0xd4, 0x70, 0x78, 0x6e, 0x66, 0xd5, 0xe6, 0x53, 0xa8, 0x95, 0x8c, 0xaa, 0xf0, 0xf4, 0x9b,
	0x00, 0xa2, 0x98, 0xb1, 0x88, 0xdf, 0x94, 0xe4, 0x66, 0x29, 0x71, 0x49, 0x9f, 0x0b, 0x50, 0x1f,
	0x0a, 0x3c, 0x07, 0x64, 0xf0, 0x6a, 0xbb, 0x5f, 0xbc, 0xc4, 0xbb, 0xde, 0x76, 0xe6, 0x5b, 0xe6,
	0x06, 0x96, 0xb6, 0x38, 0xb9, 0xb5, 0xce, 0x49, 0x68, 0x8d, 0x88, 0x49, 0xbd, 0x88, 0xf3, 0x74,
	0xf2, 0xcc, 0x64, 0xb6, 0x1f, 0xca, 0x38, 0xe7, 0xf0, 0xba, 0xea, 0x36, 0x92, 0xde, 0x3e, 0xef,
	0x44, 0x1f, 0x83, 0x36, 0xa3, 0x6f, 0x32, 0xdb, 0x72, 0x09, 0x77, 0x8d, 0x8c, 0xfd, 0x3a, 0x9d,
	0x42, 0xf4, 0x79, 0xaf, 0xc1, 0xd9, 0xec, 0x9a, 0x4c, 0x11, 0x4e, 0x03, 0x52, 0x15, 0x26, 0xd2,
	0xa0, 0x80, 0x91, 0xec, 0x3b, 0x1c, 0xa6, 0xc3, 0x31, 0xd4, 0x81, 0x35, 0xca, 0x92, 0x7b, 0x02,
	0x31, 0x93, 0xb7, 0xa5, 0x1b, 0x90, 0x2a, 0x44, 0x99, 0xba, 0x2c, 0x10, 0xac, 0x50, 0xb3, 0x7f,
	0xc3, 0xc0, 0x4b, 0xfd, 0x0d, 0x73, 0x1f, 0x6a, 0x7e, 0x1c, 0xd9, 0xfe, 0x98, 0x4f, 0xc3, 0x62,
	0xbe, 0x97, 0x50, 0x2d, 0x25, 0xc5, 0x42, 0x88, 0x3e, 0x80, 0xb5, 0x44, 0x4d, 0x5e, 0x95, 0xce,
	0x89, 0xc7, 0x09, 0x6f, 0x45, 0x78, 0xf4, 0xb6, 0xea, 0xeb, 0x65, 0xba, 0xd0, 0x8f, 0x60, 0x99,
	0x32, 0x73, 0x6c, 0x45, 0xf6, 0xa9, 0xb8, 0x1f, 0xcc, 0x5f, 0x58, 0x91, 0xb2, 0x03, 0xae, 0x7a,
	0xf9, 0x3d, 0xa6, 0x76, 0xe9, 0x3d, 0xa6, 0xf1, 0xf7, 0x1c, 0xac, 0xbe, 0x90, 0x07, 0xa8, 0x01,
	0x6f, 0x35, 0x7b, 0xbd, 0x8e, 0xd1, 0x6a, 0x0e, 0x8c, 0xc3, 0xae, 0xd9, 0x1f, 0x34, 0x07, 0x47,
	0xfd, 0x19, 0x46, 0x81, 0xa0, 0x76, 0xf8, 0xe8, 0x91, 0x8e, 0x4d, 0xfd, 0xeb, 0x81, 0xde, 0x6d,
	0xeb, 0xed, 0x7a, 0x8e, 0xb3, 0x0c, 0xac, 0x7f, 0xa5, 0xb7, 0x06, 0x7a, 0xdb, 0xdc, 0x7b, 0x6a,
	0xb6, 0x9a, 0xdd, 0xb6, 0xd1, 0xe6, 0x3c, 0x62, 0x81, 0x33, 0x87, 0x66, 0x6b, 0x60, 0x1c, 0x73,
	0x4e, 0xa1, 0xc1, 0x5a, 0x56, 0x4d, 0x3f, 0xe8, 0x75, 0x0e, 0x9f, 0x8a, 0xb7, 0x89, 0x0d, 0x40,
	0xfb, 0x06, 0xd6, 0xdb, 0x66, 0x4f, 0xef, 0xb6, 0x8d, 0xee, 0x63, 0x53, 0xa0, 0x0b, 0x68, 0x15,
	0xaa, 0x52, 0xde, 0x1f, 0x34, 0xf1, 0x40, 0x6f, 0xd7, 0x97, 0x50, 0x0d, 0xa0, 0x87, 0x0f, 0xf9,
	0x8c, 0x78, 0xbb, 0xd8, 0xf8, 0x57, 0x0e, 0xaa, 0x53, 0xcf, 0xe1, 0x37, 0x39, 0x8c, 0x3f, 0x82,
	0x8a, 0x65, 0x7f, 0x1b, 0xd3, 0x90, 0x5c, 0x43, 0x14, 0xcb, 0x4a, 0x2d, 0x61, 0x18, 0xe4, 0x79,
	0x90, 0x82, 0xae, 0xdc, 0xcc, 0x20, 0xb5, 0x04, 0xe6, 0x0e, 0x94, 0x64, 0xd1, 0xa4, 0xd1, 0x45,
	0xb2, 0x8d, 0x53, 0xc1, 0x6c, 0xc5, 0x2c, 0xbc, 0x50, 0x31, 0x1b, 0xbf, 0xce, 0x41, 0x6d, 0xfa,
	0xfd, 0x5c, 0x3c, 0x7d, 0xf8, 0xd1, 0xe4, 0xef, 0x52, 0x5f, 0x0e, 0x63, 0xfb, 0xe3, 0x31, 0xe1,
	0x3b, 0x45, 0x1d, 0x47, 0x13, 0xc1, 0x2c, 0x9d, 0xca, 0xdf, 0x84, 0x4e, 0x21, 0xf5, 0x0e, 0x26,
	0xe7, 0x2c, 0xbe, 0xf7, 0x7e, 0x95, 0x83, 0xbb, 0xb6, 0x3f, 0x9e, 0x77, 0xd8, 0xec, 0xad, 0xa9,
	0x47, 0x79, 0x4c, 0xe4, 0x1f, 0xb2, 0x3d, 0x9e, 0xb1, 0xbd, 0xdc, 0x2f, 0x9a, 0x0a, 0x34, 0xf2,
	0x5d, 0xcb, 0x1b, 0x6d, 0xfb, 0xe1, 0x68, 0x67, 0x44, 0x3c, 0x91, 0xcf, 0x3b, 0xb2, 0xcb, 0x0a,
	0x28, 0xbb, 0xf4, 0x1f, 0xeb, 0xcf, 0x64, 0xf3, 0x4f, 0x0b, 0xf9, 0xd6, 0xa0, 0x7f, 0xb2, 0x24,
	0x30, 0x1f, 0xfe, 0x37, 0x00, 0x00, 0xff, 0xff, 0x4a, 0xaa, 0x44, 0x25, 0x74, 0x1f, 0x00, 0x00,
}
