// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/resume_service.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Parse resume request.
type ParseResumeRequest struct {
	// Required.
	//
	// The resource name of the project.
	//
	// The format is "projects/{project_id}", for example,
	// "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The bytes of the resume file in common format. Currently the API supports
	// the following formats:
	// PDF, TXT, DOC, RTF and DOCX.
	Resume []byte `protobuf:"bytes,2,opt,name=resume,proto3" json:"resume,omitempty"`
	// Optional.
	//
	// The region code indicating where the resume is from. Values
	// are as per the ISO-3166-2 format. For example, US, FR, DE.
	//
	// This value is optional, but providing this value improves the resume
	// parsing quality and performance.
	//
	// An error is thrown if the regionCode is invalid.
	RegionCode string `protobuf:"bytes,3,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Optional.
	//
	// The language code of contents in the resume.
	//
	// Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
	// For more information, see
	// [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
	// class="external" target="_blank" }.
	LanguageCode         string   `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ParseResumeRequest) Reset()         { *m = ParseResumeRequest{} }
func (m *ParseResumeRequest) String() string { return proto.CompactTextString(m) }
func (*ParseResumeRequest) ProtoMessage()    {}
func (*ParseResumeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_resume_service_1cf6bb11c787af60, []int{0}
}
func (m *ParseResumeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParseResumeRequest.Unmarshal(m, b)
}
func (m *ParseResumeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParseResumeRequest.Marshal(b, m, deterministic)
}
func (dst *ParseResumeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseResumeRequest.Merge(dst, src)
}
func (m *ParseResumeRequest) XXX_Size() int {
	return xxx_messageInfo_ParseResumeRequest.Size(m)
}
func (m *ParseResumeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseResumeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ParseResumeRequest proto.InternalMessageInfo

func (m *ParseResumeRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ParseResumeRequest) GetResume() []byte {
	if m != nil {
		return m.Resume
	}
	return nil
}

func (m *ParseResumeRequest) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

func (m *ParseResumeRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Parse resume response.
type ParseResumeResponse struct {
	// The profile parsed from resume.
	Profile *Profile `protobuf:"bytes,1,opt,name=profile,proto3" json:"profile,omitempty"`
	// Raw text from resume.
	RawText              string   `protobuf:"bytes,2,opt,name=raw_text,json=rawText,proto3" json:"raw_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ParseResumeResponse) Reset()         { *m = ParseResumeResponse{} }
func (m *ParseResumeResponse) String() string { return proto.CompactTextString(m) }
func (*ParseResumeResponse) ProtoMessage()    {}
func (*ParseResumeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_resume_service_1cf6bb11c787af60, []int{1}
}
func (m *ParseResumeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParseResumeResponse.Unmarshal(m, b)
}
func (m *ParseResumeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParseResumeResponse.Marshal(b, m, deterministic)
}
func (dst *ParseResumeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParseResumeResponse.Merge(dst, src)
}
func (m *ParseResumeResponse) XXX_Size() int {
	return xxx_messageInfo_ParseResumeResponse.Size(m)
}
func (m *ParseResumeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ParseResumeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ParseResumeResponse proto.InternalMessageInfo

func (m *ParseResumeResponse) GetProfile() *Profile {
	if m != nil {
		return m.Profile
	}
	return nil
}

func (m *ParseResumeResponse) GetRawText() string {
	if m != nil {
		return m.RawText
	}
	return ""
}

func init() {
	proto.RegisterType((*ParseResumeRequest)(nil), "google.cloud.talent.v4beta1.ParseResumeRequest")
	proto.RegisterType((*ParseResumeResponse)(nil), "google.cloud.talent.v4beta1.ParseResumeResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ResumeServiceClient is the client API for ResumeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ResumeServiceClient interface {
	// Parses a resume into a [Profile][google.cloud.talent.v4beta1.Profile]. The API attempts to fill out the
	// following profile fields if present within the resume:
	//
	// * personNames
	// * addresses
	// * emailAddress
	// * phoneNumbers
	// * personalUris
	// * employmentRecords
	// * educationRecords
	// * skills
	//
	// Note that some attributes in these fields may not be populated if they're
	// not present within the resume or unrecognizable by the resume parser.
	//
	// This API does not save the resume or profile. To create a profile from this
	// resume, clients need to call the CreateProfile method again with the
	// profile returned.
	//
	// This API supports the following list of formats:
	//
	// * PDF
	// * TXT
	// * DOC
	// * RTF
	// * DOCX
	//
	// An error is thrown if the input format is not supported.
	ParseResume(ctx context.Context, in *ParseResumeRequest, opts ...grpc.CallOption) (*ParseResumeResponse, error)
}

type resumeServiceClient struct {
	cc *grpc.ClientConn
}

func NewResumeServiceClient(cc *grpc.ClientConn) ResumeServiceClient {
	return &resumeServiceClient{cc}
}

func (c *resumeServiceClient) ParseResume(ctx context.Context, in *ParseResumeRequest, opts ...grpc.CallOption) (*ParseResumeResponse, error) {
	out := new(ParseResumeResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.ResumeService/ParseResume", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ResumeServiceServer is the server API for ResumeService service.
type ResumeServiceServer interface {
	// Parses a resume into a [Profile][google.cloud.talent.v4beta1.Profile]. The API attempts to fill out the
	// following profile fields if present within the resume:
	//
	// * personNames
	// * addresses
	// * emailAddress
	// * phoneNumbers
	// * personalUris
	// * employmentRecords
	// * educationRecords
	// * skills
	//
	// Note that some attributes in these fields may not be populated if they're
	// not present within the resume or unrecognizable by the resume parser.
	//
	// This API does not save the resume or profile. To create a profile from this
	// resume, clients need to call the CreateProfile method again with the
	// profile returned.
	//
	// This API supports the following list of formats:
	//
	// * PDF
	// * TXT
	// * DOC
	// * RTF
	// * DOCX
	//
	// An error is thrown if the input format is not supported.
	ParseResume(context.Context, *ParseResumeRequest) (*ParseResumeResponse, error)
}

func RegisterResumeServiceServer(s *grpc.Server, srv ResumeServiceServer) {
	s.RegisterService(&_ResumeService_serviceDesc, srv)
}

func _ResumeService_ParseResume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ParseResumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ResumeServiceServer).ParseResume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.ResumeService/ParseResume",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ResumeServiceServer).ParseResume(ctx, req.(*ParseResumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ResumeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.ResumeService",
	HandlerType: (*ResumeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ParseResume",
			Handler:    _ResumeService_ParseResume_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/resume_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/resume_service.proto", fileDescriptor_resume_service_1cf6bb11c787af60)
}

var fileDescriptor_resume_service_1cf6bb11c787af60 = []byte{
	// 396 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xc1, 0xaa, 0x13, 0x31,
	0x14, 0x86, 0x49, 0xaf, 0xdc, 0xeb, 0x4d, 0xef, 0xdd, 0x44, 0x90, 0x5a, 0x85, 0x7b, 0x19, 0x5d,
	0xd4, 0x2e, 0x26, 0xb5, 0xea, 0xa6, 0xa2, 0x60, 0xfb, 0x02, 0xc3, 0xb4, 0x2b, 0x37, 0x25, 0x9d,
	0x1e, 0xc3, 0xc8, 0x34, 0x27, 0x26, 0x99, 0xb6, 0x20, 0x82, 0xb8, 0x74, 0xeb, 0x1b, 0xb8, 0xf1,
	0x19, 0x7c, 0x0e, 0x5f, 0xc1, 0x07, 0x91, 0x49, 0x52, 0xb1, 0x28, 0xc3, 0x5d, 0x9e, 0x93, 0xf3,
	0xe5, 0xff, 0xf3, 0xe7, 0xd0, 0x91, 0x44, 0x94, 0x15, 0xf0, 0xa2, 0xc2, 0x7a, 0xcd, 0x9d, 0xa8,
	0x40, 0x39, 0xbe, 0x7d, 0xb6, 0x02, 0x27, 0x9e, 0x70, 0x03, 0xb6, 0xde, 0xc0, 0xd2, 0x82, 0xd9,
	0x96, 0x05, 0xa4, 0xda, 0xa0, 0x43, 0x76, 0x3f, 0x10, 0xa9, 0x27, 0xd2, 0x40, 0xa4, 0x91, 0xe8,
	0x3f, 0x88, 0xd7, 0x09, 0x5d, 0x72, 0xa1, 0x14, 0x3a, 0xe1, 0x4a, 0x54, 0x36, 0xa0, 0xfd, 0xc7,
	0x6d, 0x62, 0xda, 0xe0, 0xdb, 0xb2, 0x8a, 0x2a, 0xc9, 0x17, 0x42, 0x59, 0x26, 0x8c, 0x85, 0xdc,
	0x7b, 0xc8, 0xe1, 0x7d, 0x0d, 0xd6, 0xb1, 0xbb, 0xf4, 0x54, 0x0b, 0x03, 0xca, 0xf5, 0xc8, 0x35,
	0x19, 0x9c, 0xe7, 0xb1, 0x6a, 0xfa, 0xc1, 0x6c, 0xaf, 0x73, 0x4d, 0x06, 0x17, 0x79, 0xac, 0xd8,
	0x15, 0xed, 0x1a, 0x90, 0x25, 0xaa, 0x65, 0x81, 0x6b, 0xe8, 0x9d, 0x78, 0x88, 0x86, 0xd6, 0x0c,
	0xd7, 0xc0, 0x1e, 0xd2, 0xcb, 0x4a, 0x28, 0x59, 0x0b, 0x09, 0x61, 0xe4, 0x96, 0x1f, 0xb9, 0x38,
	0x34, 0x9b, 0xa1, 0x44, 0xd3, 0x3b, 0x47, 0x5e, 0xac, 0x46, 0x65, 0x81, 0xbd, 0xa2, 0x67, 0xd1,
	0xb4, 0x77, 0xd3, 0x1d, 0x3f, 0x4a, 0x5b, 0xb2, 0x49, 0xb3, 0x30, 0x9b, 0x1f, 0x20, 0x76, 0x8f,
	0xde, 0x36, 0x62, 0xb7, 0x74, 0xb0, 0x77, 0xde, 0xf6, 0x79, 0x7e, 0x66, 0xc4, 0x6e, 0x01, 0x7b,
	0x37, 0xfe, 0x41, 0xe8, 0x65, 0x50, 0x9b, 0x87, 0xf0, 0xd9, 0x77, 0x42, 0xbb, 0x7f, 0x99, 0x60,
	0xbc, 0x5d, 0xeb, 0x9f, 0xe8, 0xfa, 0xa3, 0x9b, 0x03, 0xe1, 0x7d, 0xc9, 0xf3, 0xcf, 0x3f, 0x7f,
	0x7d, 0xed, 0xf0, 0x64, 0xf8, 0xe7, 0x8f, 0x3e, 0x84, 0xb8, 0x5f, 0x6a, 0x83, 0xef, 0xa0, 0x70,
	0x96, 0x0f, 0x3f, 0xc6, 0x25, 0xb1, 0x13, 0xdd, 0xdc, 0x30, 0x21, 0xc3, 0xe9, 0x27, 0x42, 0xaf,
	0x0a, 0xdc, 0xb4, 0xc9, 0x4d, 0xd9, 0xd1, 0xe3, 0xb2, 0xe6, 0xcb, 0x33, 0xf2, 0xe6, 0x75, 0x44,
	0x24, 0x36, 0xf1, 0xa7, 0x68, 0x24, 0x97, 0xa0, 0xfc, 0x42, 0xf0, 0x70, 0x24, 0x74, 0x69, 0xff,
	0xbb, 0x3e, 0x2f, 0x42, 0xf9, 0xad, 0x73, 0x32, 0x5b, 0xcc, 0x57, 0xa7, 0x9e, 0x79, 0xfa, 0x3b,
	0x00, 0x00, 0xff, 0xff, 0x62, 0x8f, 0xa7, 0xd2, 0xde, 0x02, 0x00, 0x00,
}
