// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/ad_group_ad_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [AdGroupAdService.GetAdGroupAd][google.ads.googleads.v0.services.AdGroupAdService.GetAdGroupAd].
type GetAdGroupAdRequest struct {
	// The resource name of the ad to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupAdRequest) Reset()         { *m = GetAdGroupAdRequest{} }
func (m *GetAdGroupAdRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupAdRequest) ProtoMessage()    {}
func (*GetAdGroupAdRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_61deec0bae9cbde4, []int{0}
}
func (m *GetAdGroupAdRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupAdRequest.Unmarshal(m, b)
}
func (m *GetAdGroupAdRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupAdRequest.Marshal(b, m, deterministic)
}
func (dst *GetAdGroupAdRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupAdRequest.Merge(dst, src)
}
func (m *GetAdGroupAdRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupAdRequest.Size(m)
}
func (m *GetAdGroupAdRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupAdRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupAdRequest proto.InternalMessageInfo

func (m *GetAdGroupAdRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupAdService.MutateAdGroupAds][google.ads.googleads.v0.services.AdGroupAdService.MutateAdGroupAds].
type MutateAdGroupAdsRequest struct {
	// The ID of the customer whose ads are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual ads.
	Operations []*AdGroupAdOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupAdsRequest) Reset()         { *m = MutateAdGroupAdsRequest{} }
func (m *MutateAdGroupAdsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdsRequest) ProtoMessage()    {}
func (*MutateAdGroupAdsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_61deec0bae9cbde4, []int{1}
}
func (m *MutateAdGroupAdsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupAdsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdsRequest.Merge(dst, src)
}
func (m *MutateAdGroupAdsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdsRequest.Size(m)
}
func (m *MutateAdGroupAdsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdsRequest proto.InternalMessageInfo

func (m *MutateAdGroupAdsRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupAdsRequest) GetOperations() []*AdGroupAdOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdGroupAdsRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdGroupAdsRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on an ad group ad.
type AdGroupAdOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Configuration for how policies are validated.
	PolicyValidationParameter *common.PolicyValidationParameter `protobuf:"bytes,5,opt,name=policy_validation_parameter,json=policyValidationParameter,proto3" json:"policy_validation_parameter,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupAdOperation_Create
	//	*AdGroupAdOperation_Update
	//	*AdGroupAdOperation_Remove
	Operation            isAdGroupAdOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *AdGroupAdOperation) Reset()         { *m = AdGroupAdOperation{} }
func (m *AdGroupAdOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupAdOperation) ProtoMessage()    {}
func (*AdGroupAdOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_61deec0bae9cbde4, []int{2}
}
func (m *AdGroupAdOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupAdOperation.Unmarshal(m, b)
}
func (m *AdGroupAdOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupAdOperation.Marshal(b, m, deterministic)
}
func (dst *AdGroupAdOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupAdOperation.Merge(dst, src)
}
func (m *AdGroupAdOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupAdOperation.Size(m)
}
func (m *AdGroupAdOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupAdOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupAdOperation proto.InternalMessageInfo

func (m *AdGroupAdOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *AdGroupAdOperation) GetPolicyValidationParameter() *common.PolicyValidationParameter {
	if m != nil {
		return m.PolicyValidationParameter
	}
	return nil
}

type isAdGroupAdOperation_Operation interface {
	isAdGroupAdOperation_Operation()
}

type AdGroupAdOperation_Create struct {
	Create *resources.AdGroupAd `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupAdOperation_Update struct {
	Update *resources.AdGroupAd `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupAdOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupAdOperation_Create) isAdGroupAdOperation_Operation() {}

func (*AdGroupAdOperation_Update) isAdGroupAdOperation_Operation() {}

func (*AdGroupAdOperation_Remove) isAdGroupAdOperation_Operation() {}

func (m *AdGroupAdOperation) GetOperation() isAdGroupAdOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupAdOperation) GetCreate() *resources.AdGroupAd {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupAdOperation) GetUpdate() *resources.AdGroupAd {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupAdOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupAdOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupAdOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupAdOperation_OneofMarshaler, _AdGroupAdOperation_OneofUnmarshaler, _AdGroupAdOperation_OneofSizer, []interface{}{
		(*AdGroupAdOperation_Create)(nil),
		(*AdGroupAdOperation_Update)(nil),
		(*AdGroupAdOperation_Remove)(nil),
	}
}

func _AdGroupAdOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupAdOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupAdOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *AdGroupAdOperation_Update:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *AdGroupAdOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("AdGroupAdOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _AdGroupAdOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupAdOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupAd)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupAdOperation_Create{msg}
		return true, err
	case 2: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.AdGroupAd)
		err := b.DecodeMessage(msg)
		m.Operation = &AdGroupAdOperation_Update{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &AdGroupAdOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupAdOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupAdOperation)
	// operation
	switch x := m.Operation.(type) {
	case *AdGroupAdOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupAdOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupAdOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for an ad group ad mutate.
type MutateAdGroupAdsResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdGroupAdResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *MutateAdGroupAdsResponse) Reset()         { *m = MutateAdGroupAdsResponse{} }
func (m *MutateAdGroupAdsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdsResponse) ProtoMessage()    {}
func (*MutateAdGroupAdsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_61deec0bae9cbde4, []int{3}
}
func (m *MutateAdGroupAdsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupAdsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdsResponse.Merge(dst, src)
}
func (m *MutateAdGroupAdsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdsResponse.Size(m)
}
func (m *MutateAdGroupAdsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdsResponse proto.InternalMessageInfo

func (m *MutateAdGroupAdsResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdGroupAdsResponse) GetResults() []*MutateAdGroupAdResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad mutate.
type MutateAdGroupAdResult struct {
	// The resource name returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupAdResult) Reset()         { *m = MutateAdGroupAdResult{} }
func (m *MutateAdGroupAdResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupAdResult) ProtoMessage()    {}
func (*MutateAdGroupAdResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_ad_service_61deec0bae9cbde4, []int{4}
}
func (m *MutateAdGroupAdResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupAdResult.Unmarshal(m, b)
}
func (m *MutateAdGroupAdResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupAdResult.Marshal(b, m, deterministic)
}
func (dst *MutateAdGroupAdResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupAdResult.Merge(dst, src)
}
func (m *MutateAdGroupAdResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupAdResult.Size(m)
}
func (m *MutateAdGroupAdResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupAdResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupAdResult proto.InternalMessageInfo

func (m *MutateAdGroupAdResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupAdRequest)(nil), "google.ads.googleads.v0.services.GetAdGroupAdRequest")
	proto.RegisterType((*MutateAdGroupAdsRequest)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdsRequest")
	proto.RegisterType((*AdGroupAdOperation)(nil), "google.ads.googleads.v0.services.AdGroupAdOperation")
	proto.RegisterType((*MutateAdGroupAdsResponse)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdsResponse")
	proto.RegisterType((*MutateAdGroupAdResult)(nil), "google.ads.googleads.v0.services.MutateAdGroupAdResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AdGroupAdServiceClient is the client API for AdGroupAdService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupAdServiceClient interface {
	// Returns the requested ad in full detail.
	GetAdGroupAd(ctx context.Context, in *GetAdGroupAdRequest, opts ...grpc.CallOption) (*resources.AdGroupAd, error)
	// Creates, updates, or removes ads. Operation statuses are returned.
	MutateAdGroupAds(ctx context.Context, in *MutateAdGroupAdsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdsResponse, error)
}

type adGroupAdServiceClient struct {
	cc *grpc.ClientConn
}

func NewAdGroupAdServiceClient(cc *grpc.ClientConn) AdGroupAdServiceClient {
	return &adGroupAdServiceClient{cc}
}

func (c *adGroupAdServiceClient) GetAdGroupAd(ctx context.Context, in *GetAdGroupAdRequest, opts ...grpc.CallOption) (*resources.AdGroupAd, error) {
	out := new(resources.AdGroupAd)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupAdService/GetAdGroupAd", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupAdServiceClient) MutateAdGroupAds(ctx context.Context, in *MutateAdGroupAdsRequest, opts ...grpc.CallOption) (*MutateAdGroupAdsResponse, error) {
	out := new(MutateAdGroupAdsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.AdGroupAdService/MutateAdGroupAds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupAdServiceServer is the server API for AdGroupAdService service.
type AdGroupAdServiceServer interface {
	// Returns the requested ad in full detail.
	GetAdGroupAd(context.Context, *GetAdGroupAdRequest) (*resources.AdGroupAd, error)
	// Creates, updates, or removes ads. Operation statuses are returned.
	MutateAdGroupAds(context.Context, *MutateAdGroupAdsRequest) (*MutateAdGroupAdsResponse, error)
}

func RegisterAdGroupAdServiceServer(s *grpc.Server, srv AdGroupAdServiceServer) {
	s.RegisterService(&_AdGroupAdService_serviceDesc, srv)
}

func _AdGroupAdService_GetAdGroupAd_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupAdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdServiceServer).GetAdGroupAd(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupAdService/GetAdGroupAd",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdServiceServer).GetAdGroupAd(ctx, req.(*GetAdGroupAdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupAdService_MutateAdGroupAds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupAdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupAdServiceServer).MutateAdGroupAds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.AdGroupAdService/MutateAdGroupAds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupAdServiceServer).MutateAdGroupAds(ctx, req.(*MutateAdGroupAdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupAdService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.AdGroupAdService",
	HandlerType: (*AdGroupAdServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupAd",
			Handler:    _AdGroupAdService_GetAdGroupAd_Handler,
		},
		{
			MethodName: "MutateAdGroupAds",
			Handler:    _AdGroupAdService_MutateAdGroupAds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/ad_group_ad_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/ad_group_ad_service.proto", fileDescriptor_ad_group_ad_service_61deec0bae9cbde4)
}

var fileDescriptor_ad_group_ad_service_61deec0bae9cbde4 = []byte{
	// 766 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xc1, 0x6e, 0xd3, 0x4a,
	0x14, 0x7d, 0x4e, 0xde, 0xeb, 0x7b, 0x9d, 0xf4, 0x41, 0x35, 0x55, 0x55, 0x13, 0x10, 0x44, 0xa6,
	0x12, 0x55, 0xa8, 0xec, 0x28, 0x2d, 0x42, 0x75, 0xe9, 0x22, 0x95, 0x68, 0xca, 0xa2, 0x34, 0xb8,
	0x28, 0x0b, 0x14, 0xc9, 0x9a, 0xda, 0xd3, 0xc8, 0xaa, 0xed, 0x19, 0x66, 0xc6, 0x41, 0x51, 0xd5,
	0x0d, 0x48, 0xfc, 0x00, 0x7f, 0xc0, 0x0e, 0xf6, 0x7c, 0x02, 0x1b, 0xb6, 0xec, 0x59, 0xb1, 0xe2,
	0x1b, 0x58, 0x20, 0x7b, 0x3c, 0x26, 0x4d, 0x1b, 0x85, 0x76, 0x37, 0xbe, 0x73, 0xcf, 0xb9, 0x67,
	0xe6, 0xdc, 0xb9, 0x06, 0x76, 0x9f, 0x90, 0x7e, 0x88, 0x2d, 0xe4, 0x73, 0x4b, 0x2e, 0xd3, 0xd5,
	0xa0, 0x61, 0x71, 0xcc, 0x06, 0x81, 0x87, 0xb9, 0x85, 0x7c, 0xb7, 0xcf, 0x48, 0x42, 0x5d, 0xe4,
	0xbb, 0x79, 0xd0, 0xa4, 0x8c, 0x08, 0x02, 0x6b, 0x12, 0x60, 0x22, 0x9f, 0x9b, 0x05, 0xd6, 0x1c,
	0x34, 0x4c, 0x85, 0xad, 0xde, 0x9f, 0xc4, 0xee, 0x91, 0x28, 0x22, 0xb1, 0x45, 0x49, 0x18, 0x78,
	0x43, 0x49, 0x57, 0x5d, 0x9b, 0x94, 0xcc, 0x30, 0x27, 0x09, 0x1b, 0xd3, 0x92, 0x83, 0x6e, 0x29,
	0x10, 0x0d, 0x2c, 0x14, 0xc7, 0x44, 0x20, 0x11, 0x90, 0x98, 0xe7, 0xbb, 0xb9, 0x42, 0x2b, 0xfb,
	0x3a, 0x4c, 0x8e, 0xac, 0xa3, 0x00, 0x87, 0xbe, 0x1b, 0x21, 0x7e, 0x9c, 0x67, 0xdc, 0x1e, 0xcf,
	0x78, 0xc5, 0x10, 0xa5, 0x98, 0x29, 0x86, 0xa5, 0x7c, 0x9f, 0x51, 0xcf, 0xe2, 0x02, 0x89, 0x24,
	0xdf, 0x30, 0x6c, 0xb0, 0xd0, 0xc6, 0xa2, 0xe5, 0xb7, 0x53, 0x3d, 0x2d, 0xdf, 0xc1, 0x2f, 0x13,
	0xcc, 0x05, 0xbc, 0x0b, 0xfe, 0x57, 0x72, 0xdd, 0x18, 0x45, 0x58, 0xd7, 0x6a, 0xda, 0xca, 0xac,
	0x33, 0xa7, 0x82, 0x4f, 0x51, 0x84, 0x8d, 0x6f, 0x1a, 0x58, 0xda, 0x4b, 0x04, 0x12, 0xb8, 0xc0,
	0x73, 0x45, 0x70, 0x07, 0x54, 0xbc, 0x84, 0x0b, 0x12, 0x61, 0xe6, 0x06, 0x7e, 0x0e, 0x07, 0x2a,
	0xf4, 0xc4, 0x87, 0xcf, 0x01, 0x20, 0x14, 0x33, 0x79, 0x4e, 0xbd, 0x54, 0x2b, 0xaf, 0x54, 0x9a,
	0xeb, 0xe6, 0x34, 0x2b, 0xcc, 0xa2, 0xd2, 0xbe, 0x02, 0x3b, 0x23, 0x3c, 0xf0, 0x1e, 0xb8, 0x4e,
	0x11, 0x13, 0x01, 0x0a, 0xdd, 0x23, 0x14, 0x84, 0x09, 0xc3, 0x7a, 0xb9, 0xa6, 0xad, 0xfc, 0xe7,
	0x5c, 0xcb, 0xc3, 0x3b, 0x32, 0x9a, 0x1e, 0x70, 0x80, 0xc2, 0xc0, 0x47, 0x02, 0xbb, 0x24, 0x0e,
	0x87, 0xfa, 0xdf, 0x59, 0xda, 0x9c, 0x0a, 0xee, 0xc7, 0xe1, 0xd0, 0x78, 0x53, 0x06, 0xf0, 0x7c,
	0x41, 0xb8, 0x09, 0x2a, 0x09, 0xcd, 0x90, 0xa9, 0x03, 0x19, 0xb2, 0xd2, 0xac, 0x2a, 0xed, 0xca,
	0x02, 0x73, 0x27, 0x35, 0x69, 0x0f, 0xf1, 0x63, 0x07, 0xc8, 0xf4, 0x74, 0x0d, 0x87, 0xe0, 0xa6,
	0x6c, 0x17, 0x37, 0x2f, 0x15, 0x90, 0xd8, 0xa5, 0x88, 0xa1, 0x08, 0x0b, 0xcc, 0xf4, 0x7f, 0x32,
	0xb2, 0x8d, 0x89, 0x17, 0x21, 0x3b, 0xce, 0xec, 0x64, 0x14, 0xdd, 0x82, 0xa1, 0xa3, 0x08, 0x9c,
	0x1b, 0x74, 0xd2, 0x16, 0xdc, 0x01, 0x33, 0x1e, 0xc3, 0x48, 0x48, 0x37, 0x2b, 0xcd, 0xd5, 0x89,
	0x55, 0x8a, 0x56, 0xfd, 0x7d, 0xdf, 0xbb, 0x7f, 0x39, 0x39, 0x3a, 0xe5, 0x91, 0x07, 0xd2, 0x4b,
	0x57, 0xe3, 0x91, 0x68, 0xa8, 0x83, 0x19, 0x86, 0x23, 0x32, 0x90, 0x1e, 0xcd, 0xa6, 0x3b, 0xf2,
	0x7b, 0xbb, 0x02, 0x66, 0x0b, 0x53, 0x8d, 0x4f, 0x1a, 0xd0, 0xcf, 0xb7, 0x19, 0xa7, 0x24, 0xe6,
	0xa9, 0x96, 0xc5, 0x31, 0xc3, 0x5d, 0xcc, 0x18, 0x61, 0x19, 0x65, 0xa5, 0x09, 0x95, 0x34, 0x46,
	0x3d, 0xf3, 0x20, 0x6b, 0x7c, 0x67, 0xe1, 0x6c, 0x2b, 0x3c, 0x4e, 0xd3, 0xe1, 0x33, 0xf0, 0x2f,
	0xc3, 0x3c, 0x09, 0x85, 0xea, 0xc5, 0x87, 0xd3, 0x7b, 0x71, 0x4c, 0x94, 0x93, 0xe1, 0x1d, 0xc5,
	0x63, 0x3c, 0x02, 0x8b, 0x17, 0x66, 0xfc, 0xd1, 0xe3, 0x6a, 0xbe, 0x2d, 0x83, 0xf9, 0x02, 0x78,
	0x20, 0x4b, 0xc2, 0x0f, 0x1a, 0x98, 0x1b, 0x7d, 0xae, 0xf0, 0xc1, 0x74, 0x95, 0x17, 0x3c, 0xef,
	0xea, 0xa5, 0x1c, 0x33, 0xd6, 0x5f, 0x7f, 0xfd, 0xfe, 0xae, 0x64, 0xc2, 0xd5, 0x74, 0x8a, 0x9d,
	0x9c, 0x91, 0xbe, 0xa5, 0x5e, 0x34, 0xb7, 0xea, 0x16, 0x2a, 0xec, 0xb1, 0xea, 0xa7, 0xf0, 0xb3,
	0x06, 0xe6, 0xc7, 0x6d, 0x83, 0x1b, 0x97, 0xbe, 0x55, 0x35, 0x51, 0xaa, 0xf6, 0x55, 0xa0, 0xb2,
	0x4b, 0x0c, 0x3b, 0x3b, 0xc1, 0xba, 0x61, 0x65, 0x43, 0xbb, 0x90, 0x7c, 0x32, 0x32, 0xa2, 0xb6,
	0xea, 0xa7, 0x23, 0x07, 0xb0, 0xa3, 0x8c, 0xca, 0xd6, 0xea, 0xdb, 0x3f, 0x35, 0xb0, 0xec, 0x91,
	0x68, 0x6a, 0xf5, 0xed, 0xc5, 0x71, 0xbb, 0x3a, 0xe9, 0x24, 0xe8, 0x68, 0x2f, 0x76, 0x73, 0x68,
	0x9f, 0x84, 0x28, 0xee, 0x9b, 0x84, 0xf5, 0xad, 0x3e, 0x8e, 0xb3, 0x39, 0xa1, 0xfe, 0x10, 0x34,
	0xe0, 0x93, 0xff, 0x5d, 0x9b, 0x6a, 0xf1, 0xbe, 0x54, 0x6e, 0xb7, 0x5a, 0x1f, 0x4b, 0xb5, 0xb6,
	0x24, 0x6c, 0xf9, 0xdc, 0x94, 0xcb, 0x74, 0xd5, 0x6d, 0x98, 0x79, 0x61, 0xfe, 0x45, 0xa5, 0xf4,
	0x5a, 0x3e, 0xef, 0x15, 0x29, 0xbd, 0x6e, 0xa3, 0xa7, 0x52, 0x7e, 0x94, 0x96, 0x65, 0xdc, 0xb6,
	0xd3, 0xf3, 0xda, 0x45, 0x92, 0x6d, 0x77, 0x1b, 0xb6, 0xad, 0xd2, 0x0e, 0x67, 0x32, 0x9d, 0x6b,
	0xbf, 0x02, 0x00, 0x00, 0xff, 0xff, 0x5f, 0xef, 0x59, 0x8e, 0x62, 0x07, 0x00, 0x00,
}
