// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// Test intersects and includes semantics
func TestGeoIntersectionInclusionSuite(t *testing.T) {
	suite.Run(t, new(GeoIntersectionInclusionSuite))
}

type GeoIntersectionInclusionSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *GeoIntersectionInclusionSuite) SetupTest() {
	suite.T().Log("Setting up GeoIntersectionInclusionSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *GeoIntersectionInclusionSuite) TearDownSuite() {
	suite.T().Log("Tearing down GeoIntersectionInclusionSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *GeoIntersectionInclusionSuite) TestCases() {
	suite.T().Log("Running GeoIntersectionInclusionSuite: Test intersects and includes semantics")

	{
		// geo/intersection_inclusion.yaml line #4
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #4: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #4")
	}

	{
		// geo/intersection_inclusion.yaml line #6
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.point(2.5,2.5)) */

		suite.T().Log("About to run line #6: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2.5, 2.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2.5, 2.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	{
		// geo/intersection_inclusion.yaml line #8
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #8: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #8")
	}

	{
		// geo/intersection_inclusion.yaml line #10
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.point(1.05,1.05)) */

		suite.T().Log("About to run line #10: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.05, 1.05))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.05, 1.05)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #10")
	}

	{
		// geo/intersection_inclusion.yaml line #13
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.point(2,2)) */

		suite.T().Log("About to run line #13: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2, 2))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2, 2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #13")
	}

	{
		// geo/intersection_inclusion.yaml line #15
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.point(2,1.5)) */

		suite.T().Log("About to run line #15: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Point(2, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #15")
	}

	{
		// geo/intersection_inclusion.yaml line #17
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.line([1.5,1.5], [2,2])) */

		suite.T().Log("About to run line #17: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #17")
	}

	{
		// geo/intersection_inclusion.yaml line #19
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.line([1.5,1.5], [2,1.5])) */

		suite.T().Log("About to run line #19: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 1.5}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 1.5})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #19")
	}

	{
		// geo/intersection_inclusion.yaml line #22
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.point(1.1,1.1)) */

		suite.T().Log("About to run line #22: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.1, 1.1))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.1, 1.1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #22")
	}

	{
		// geo/intersection_inclusion.yaml line #24
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.point(1.5,1.1)) */

		suite.T().Log("About to run line #24: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.5, 1.1))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Point(1.5, 1.1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #24")
	}

	{
		// geo/intersection_inclusion.yaml line #27
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.line([2,2], [3,3])) */

		suite.T().Log("About to run line #27: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{2, 2}, []interface{}{3, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{2, 2}, []interface{}{3, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #27")
	}

	{
		// geo/intersection_inclusion.yaml line #29
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.line([2,1.5], [3,3])) */

		suite.T().Log("About to run line #29: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{2, 1.5}, []interface{}{3, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{2, 1.5}, []interface{}{3, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #29")
	}

	{
		// geo/intersection_inclusion.yaml line #31
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.line([1.5,1.5], [3,3])) */

		suite.T().Log("About to run line #31: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{3, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Line([]interface{}{1.5, 1.5}, []interface{}{3, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #31")
	}

	{
		// geo/intersection_inclusion.yaml line #33
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.polygon([1.2,1.2], [1.8,1.2], [1.8,1.8], [1.2,1.8])) */

		suite.T().Log("About to run line #33: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #33")
	}

	{
		// geo/intersection_inclusion.yaml line #35
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.polygon([1.5,1.5], [2.5,1.5], [2.5,2.5], [1.5,2.5])) */

		suite.T().Log("About to run line #35: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2.5, 1.5}, []interface{}{2.5, 2.5}, []interface{}{1.5, 2.5}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2.5, 1.5}, []interface{}{2.5, 2.5}, []interface{}{1.5, 2.5})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #35")
	}

	{
		// geo/intersection_inclusion.yaml line #37
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.polygon([1.2,1.2], [1.8,1.2], [1.8,1.8], [1.2,1.8])) */

		suite.T().Log("About to run line #37: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #37")
	}

	{
		// geo/intersection_inclusion.yaml line #39
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).intersects(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])) */

		suite.T().Log("About to run line #39: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Intersects(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	{
		// geo/intersection_inclusion.yaml line #42
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.polygon([2,1.1], [3,1.1], [3,1.9], [2,1.9])) */

		suite.T().Log("About to run line #42: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{2, 1.1}, []interface{}{3, 1.1}, []interface{}{3, 1.9}, []interface{}{2, 1.9}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{2, 1.1}, []interface{}{3, 1.1}, []interface{}{3, 1.9}, []interface{}{2, 1.9})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #42")
	}

	{
		// geo/intersection_inclusion.yaml line #44
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).intersects(r.polygon([2,2], [3,2], [3,3], [2,3])) */

		suite.T().Log("About to run line #44: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{2, 2}, []interface{}{3, 2}, []interface{}{3, 3}, []interface{}{2, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Intersects(r.Polygon([]interface{}{2, 2}, []interface{}{3, 2}, []interface{}{3, 3}, []interface{}{2, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #44")
	}

	{
		// geo/intersection_inclusion.yaml line #46
		/* false */
		var expected_ bool = false
		/* r.point(1,1).intersects(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #46: r.Point(1, 1).Intersects(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Point(1, 1).Intersects(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// geo/intersection_inclusion.yaml line #48
		/* true */
		var expected_ bool = true
		/* r.point(1,1).intersects(r.point(1,1)) */

		suite.T().Log("About to run line #48: r.Point(1, 1).Intersects(r.Point(1, 1))")

		runAndAssert(suite.Suite, expected_, r.Point(1, 1).Intersects(r.Point(1, 1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #48")
	}

	{
		// geo/intersection_inclusion.yaml line #50
		/* true */
		var expected_ bool = true
		/* r.line([1,1], [2,1]).intersects(r.point(1,1)) */

		suite.T().Log("About to run line #50: r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Point(1, 1))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Point(1, 1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #50")
	}

	{
		// geo/intersection_inclusion.yaml line #55
		/* true */
		var expected_ bool = true
		/* r.line([1,1], [1,2]).intersects(r.point(1,1.8)) */

		suite.T().Log("About to run line #55: r.Line([]interface{}{1, 1}, []interface{}{1, 2}).Intersects(r.Point(1, 1.8))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{1, 1}, []interface{}{1, 2}).Intersects(r.Point(1, 1.8)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #55")
	}

	{
		// geo/intersection_inclusion.yaml line #57
		/* true */
		var expected_ bool = true
		/* r.line([1,0], [2,0]).intersects(r.point(1.8,0)) */

		suite.T().Log("About to run line #57: r.Line([]interface{}{1, 0}, []interface{}{2, 0}).Intersects(r.Point(1.8, 0))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{1, 0}, []interface{}{2, 0}).Intersects(r.Point(1.8, 0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #57")
	}

	{
		// geo/intersection_inclusion.yaml line #59
		/* false */
		var expected_ bool = false
		/* r.line([1,1], [2,1]).intersects(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #59: r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #59")
	}

	{
		// geo/intersection_inclusion.yaml line #61
		/* true */
		var expected_ bool = true
		/* r.line([1,1], [2,1]).intersects(r.line([2,1], [3,1])) */

		suite.T().Log("About to run line #61: r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Line([]interface{}{2, 1}, []interface{}{3, 1}))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{1, 1}, []interface{}{2, 1}).Intersects(r.Line([]interface{}{2, 1}, []interface{}{3, 1})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #61")
	}

	{
		// geo/intersection_inclusion.yaml line #64
		/* 2 */
		var expected_ int = 2
		/* r.expr([r.point(1, 0), r.point(3,0), r.point(2, 0)]).intersects(r.line([0,0], [2, 0])).count() */

		suite.T().Log("About to run line #64: r.Expr([]interface{}{r.Point(1, 0), r.Point(3, 0), r.Point(2, 0)}).Intersects(r.Line([]interface{}{0, 0}, []interface{}{2, 0})).Count()")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{r.Point(1, 0), r.Point(3, 0), r.Point(2, 0)}).Intersects(r.Line([]interface{}{0, 0}, []interface{}{2, 0})).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #64")
	}

	{
		// geo/intersection_inclusion.yaml line #68
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #68: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #68")
	}

	{
		// geo/intersection_inclusion.yaml line #70
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.point(2.5,2.5)) */

		suite.T().Log("About to run line #70: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2.5, 2.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2.5, 2.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #70")
	}

	{
		// geo/intersection_inclusion.yaml line #72
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.point(1.5,1.5)) */

		suite.T().Log("About to run line #72: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.5, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.5, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #72")
	}

	{
		// geo/intersection_inclusion.yaml line #74
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.point(1.05,1.05)) */

		suite.T().Log("About to run line #74: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.05, 1.05))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.05, 1.05)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #74")
	}

	{
		// geo/intersection_inclusion.yaml line #76
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.point(2,2)) */

		suite.T().Log("About to run line #76: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2, 2))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2, 2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #76")
	}

	{
		// geo/intersection_inclusion.yaml line #78
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.point(2,1.5)) */

		suite.T().Log("About to run line #78: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2, 1.5))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Point(2, 1.5)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #78")
	}

	{
		// geo/intersection_inclusion.yaml line #80
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([1.5,1.5], [2,2])) */

		suite.T().Log("About to run line #80: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #80")
	}

	{
		// geo/intersection_inclusion.yaml line #82
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([1.5,1.5], [2,1.5])) */

		suite.T().Log("About to run line #82: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 1.5}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{2, 1.5})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #82")
	}

	{
		// geo/intersection_inclusion.yaml line #84
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.point(1.1,1.1)) */

		suite.T().Log("About to run line #84: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.1, 1.1))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.1, 1.1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #84")
	}

	{
		// geo/intersection_inclusion.yaml line #86
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.point(1.5,1.1)) */

		suite.T().Log("About to run line #86: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.5, 1.1))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Point(1.5, 1.1)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #86")
	}

	{
		// geo/intersection_inclusion.yaml line #88
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([2,2], [3,3])) */

		suite.T().Log("About to run line #88: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 2}, []interface{}{3, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 2}, []interface{}{3, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #88")
	}

	{
		// geo/intersection_inclusion.yaml line #90
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([2,1.5], [2,2])) */

		suite.T().Log("About to run line #90: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 1.5}, []interface{}{2, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 1.5}, []interface{}{2, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #90")
	}

	{
		// geo/intersection_inclusion.yaml line #92
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([2,1], [2,2])) */

		suite.T().Log("About to run line #92: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 1}, []interface{}{2, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{2, 1}, []interface{}{2, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #92")
	}

	{
		// geo/intersection_inclusion.yaml line #94
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.line([1.5,1.5], [3,3])) */

		suite.T().Log("About to run line #94: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{3, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Line([]interface{}{1.5, 1.5}, []interface{}{3, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #94")
	}

	{
		// geo/intersection_inclusion.yaml line #96
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([1,1], [2,1], [2,2], [1,2])) */

		suite.T().Log("About to run line #96: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #96")
	}

	{
		// geo/intersection_inclusion.yaml line #98
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([1.2,1.2], [1.8,1.2], [1.8,1.8], [1.2,1.8])) */

		suite.T().Log("About to run line #98: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #98")
	}

	{
		// geo/intersection_inclusion.yaml line #100
		/* true */
		var expected_ bool = true
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([1.5,1.5], [2,1.5], [2,2], [1.5,2])) */

		suite.T().Log("About to run line #100: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2, 1.5}, []interface{}{2, 2}, []interface{}{1.5, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2, 1.5}, []interface{}{2, 2}, []interface{}{1.5, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// geo/intersection_inclusion.yaml line #102
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([1.5,1.5], [2.5,1.5], [2.5,2.5], [1.5,2.5])) */

		suite.T().Log("About to run line #102: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2.5, 1.5}, []interface{}{2.5, 2.5}, []interface{}{1.5, 2.5}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{1.5, 1.5}, []interface{}{2.5, 1.5}, []interface{}{2.5, 2.5}, []interface{}{1.5, 2.5})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #102")
	}

	{
		// geo/intersection_inclusion.yaml line #104
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.polygon([1.2,1.2], [1.8,1.2], [1.8,1.8], [1.2,1.8])) */

		suite.T().Log("About to run line #104: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Polygon([]interface{}{1.2, 1.2}, []interface{}{1.8, 1.2}, []interface{}{1.8, 1.8}, []interface{}{1.2, 1.8})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #104")
	}

	{
		// geo/intersection_inclusion.yaml line #106
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).polygon_sub(r.polygon([1.1,1.1], [1.9,1.1], [1.9,1.9], [1.1,1.9])).includes(r.polygon([1.1,1.1], [2,1.1], [2,2], [1.1,2])) */

		suite.T().Log("About to run line #106: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{2, 1.1}, []interface{}{2, 2}, []interface{}{1.1, 2}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).PolygonSub(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{1.9, 1.1}, []interface{}{1.9, 1.9}, []interface{}{1.1, 1.9})).Includes(r.Polygon([]interface{}{1.1, 1.1}, []interface{}{2, 1.1}, []interface{}{2, 2}, []interface{}{1.1, 2})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #106")
	}

	{
		// geo/intersection_inclusion.yaml line #108
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([2,1.1], [3,1.1], [3,1.9], [2,1.9])) */

		suite.T().Log("About to run line #108: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{2, 1.1}, []interface{}{3, 1.1}, []interface{}{3, 1.9}, []interface{}{2, 1.9}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{2, 1.1}, []interface{}{3, 1.1}, []interface{}{3, 1.9}, []interface{}{2, 1.9})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #108")
	}

	{
		// geo/intersection_inclusion.yaml line #110
		/* false */
		var expected_ bool = false
		/* r.polygon([1,1], [2,1], [2,2], [1,2]).includes(r.polygon([2,2], [3,2], [3,3], [2,3])) */

		suite.T().Log("About to run line #110: r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{2, 2}, []interface{}{3, 2}, []interface{}{3, 3}, []interface{}{2, 3}))")

		runAndAssert(suite.Suite, expected_, r.Polygon([]interface{}{1, 1}, []interface{}{2, 1}, []interface{}{2, 2}, []interface{}{1, 2}).Includes(r.Polygon([]interface{}{2, 2}, []interface{}{3, 2}, []interface{}{3, 3}, []interface{}{2, 3})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #110")
	}

	{
		// geo/intersection_inclusion.yaml line #113
		/* 1 */
		var expected_ int = 1
		/* r.expr([r.polygon([0,0], [1,1], [1,0]), r.polygon([0,1], [1,2], [1,1])]).includes(r.point(0,0)).count() */

		suite.T().Log("About to run line #113: r.Expr([]interface{}{r.Polygon([]interface{}{0, 0}, []interface{}{1, 1}, []interface{}{1, 0}), r.Polygon([]interface{}{0, 1}, []interface{}{1, 2}, []interface{}{1, 1})}).Includes(r.Point(0, 0)).Count()")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{r.Polygon([]interface{}{0, 0}, []interface{}{1, 1}, []interface{}{1, 0}), r.Polygon([]interface{}{0, 1}, []interface{}{1, 2}, []interface{}{1, 1})}).Includes(r.Point(0, 0)).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #113")
	}

	{
		// geo/intersection_inclusion.yaml line #116
		/* err('ReqlQueryLogicError', 'Expected geometry of type `Polygon` but found `Point`.') */
		var expected_ Err = err("ReqlQueryLogicError", "Expected geometry of type `Polygon` but found `Point`.")
		/* r.point(0,0).includes(r.point(0,0)) */

		suite.T().Log("About to run line #116: r.Point(0, 0).Includes(r.Point(0, 0))")

		runAndAssert(suite.Suite, expected_, r.Point(0, 0).Includes(r.Point(0, 0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #116")
	}

	{
		// geo/intersection_inclusion.yaml line #118
		/* err('ReqlQueryLogicError', 'Expected geometry of type `Polygon` but found `LineString`.') */
		var expected_ Err = err("ReqlQueryLogicError", "Expected geometry of type `Polygon` but found `LineString`.")
		/* r.line([0,0], [0,1]).includes(r.point(0,0)) */

		suite.T().Log("About to run line #118: r.Line([]interface{}{0, 0}, []interface{}{0, 1}).Includes(r.Point(0, 0))")

		runAndAssert(suite.Suite, expected_, r.Line([]interface{}{0, 0}, []interface{}{0, 1}).Includes(r.Point(0, 0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #118")
	}
}
