package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainWhoisInfo invokes the alidns.DescribeDomainWhoisInfo API synchronously
// api document: https://help.aliyun.com/api/alidns/describedomainwhoisinfo.html
func (client *Client) DescribeDomainWhoisInfo(request *DescribeDomainWhoisInfoRequest) (response *DescribeDomainWhoisInfoResponse, err error) {
	response = CreateDescribeDomainWhoisInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainWhoisInfoWithChan invokes the alidns.DescribeDomainWhoisInfo API asynchronously
// api document: https://help.aliyun.com/api/alidns/describedomainwhoisinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainWhoisInfoWithChan(request *DescribeDomainWhoisInfoRequest) (<-chan *DescribeDomainWhoisInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainWhoisInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainWhoisInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainWhoisInfoWithCallback invokes the alidns.DescribeDomainWhoisInfo API asynchronously
// api document: https://help.aliyun.com/api/alidns/describedomainwhoisinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDomainWhoisInfoWithCallback(request *DescribeDomainWhoisInfoRequest, callback func(response *DescribeDomainWhoisInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainWhoisInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainWhoisInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainWhoisInfoRequest is the request struct for api DescribeDomainWhoisInfo
type DescribeDomainWhoisInfoRequest struct {
	*requests.RpcRequest
	Lang         string `position:"Query" name:"Lang"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	DomainName   string `position:"Query" name:"DomainName"`
	GroupId      string `position:"Query" name:"GroupId"`
}

// DescribeDomainWhoisInfoResponse is the response struct for api DescribeDomainWhoisInfo
type DescribeDomainWhoisInfoResponse struct {
	*responses.BaseResponse
	RequestId        string                              `json:"RequestId" xml:"RequestId"`
	RegistrantName   string                              `json:"RegistrantName" xml:"RegistrantName"`
	RegistrantEmail  string                              `json:"RegistrantEmail" xml:"RegistrantEmail"`
	Registrar        string                              `json:"Registrar" xml:"Registrar"`
	RegistrationDate string                              `json:"RegistrationDate" xml:"RegistrationDate"`
	ExpirationDate   string                              `json:"ExpirationDate" xml:"ExpirationDate"`
	StatusList       StatusList                          `json:"StatusList" xml:"StatusList"`
	DnsServers       DnsServersInDescribeDomainWhoisInfo `json:"DnsServers" xml:"DnsServers"`
}

// CreateDescribeDomainWhoisInfoRequest creates a request to invoke DescribeDomainWhoisInfo API
func CreateDescribeDomainWhoisInfoRequest() (request *DescribeDomainWhoisInfoRequest) {
	request = &DescribeDomainWhoisInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDomainWhoisInfo", "", "")
	return
}

// CreateDescribeDomainWhoisInfoResponse creates a response to parse from DescribeDomainWhoisInfo response
func CreateDescribeDomainWhoisInfoResponse() (response *DescribeDomainWhoisInfoResponse) {
	response = &DescribeDomainWhoisInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
