package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExplorer invokes the baas.DescribeExplorer API synchronously
// api document: https://help.aliyun.com/api/baas/describeexplorer.html
func (client *Client) DescribeExplorer(request *DescribeExplorerRequest) (response *DescribeExplorerResponse, err error) {
	response = CreateDescribeExplorerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExplorerWithChan invokes the baas.DescribeExplorer API asynchronously
// api document: https://help.aliyun.com/api/baas/describeexplorer.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeExplorerWithChan(request *DescribeExplorerRequest) (<-chan *DescribeExplorerResponse, <-chan error) {
	responseChan := make(chan *DescribeExplorerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExplorer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExplorerWithCallback invokes the baas.DescribeExplorer API asynchronously
// api document: https://help.aliyun.com/api/baas/describeexplorer.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeExplorerWithCallback(request *DescribeExplorerRequest, callback func(response *DescribeExplorerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExplorerResponse
		var err error
		defer close(result)
		response, err = client.DescribeExplorer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExplorerRequest is the request struct for api DescribeExplorer
type DescribeExplorerRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	ExBody         string `position:"Query" name:"ExBody"`
	ExUrl          string `position:"Query" name:"ExUrl"`
	ExMethod       string `position:"Query" name:"ExMethod"`
}

// DescribeExplorerResponse is the response struct for api DescribeExplorer
type DescribeExplorerResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      int    `json:"ErrorCode" xml:"ErrorCode"`
	Result         string `json:"Result" xml:"Result"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateDescribeExplorerRequest creates a request to invoke DescribeExplorer API
func CreateDescribeExplorerRequest() (request *DescribeExplorerRequest) {
	request = &DescribeExplorerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeExplorer", "", "")
	return
}

// CreateDescribeExplorerResponse creates a response to parse from DescribeExplorer response
func CreateDescribeExplorerResponse() (response *DescribeExplorerResponse) {
	response = &DescribeExplorerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
