package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserCertificateList invokes the cas.DescribeUserCertificateList API synchronously
// api document: https://help.aliyun.com/api/cas/describeusercertificatelist.html
func (client *Client) DescribeUserCertificateList(request *DescribeUserCertificateListRequest) (response *DescribeUserCertificateListResponse, err error) {
	response = CreateDescribeUserCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserCertificateListWithChan invokes the cas.DescribeUserCertificateList API asynchronously
// api document: https://help.aliyun.com/api/cas/describeusercertificatelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserCertificateListWithChan(request *DescribeUserCertificateListRequest) (<-chan *DescribeUserCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeUserCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserCertificateListWithCallback invokes the cas.DescribeUserCertificateList API asynchronously
// api document: https://help.aliyun.com/api/cas/describeusercertificatelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserCertificateListWithCallback(request *DescribeUserCertificateListRequest, callback func(response *DescribeUserCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserCertificateListRequest is the request struct for api DescribeUserCertificateList
type DescribeUserCertificateListRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	ShowSize    requests.Integer `position:"Query" name:"ShowSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
}

type Certificate struct {
	Id			int		`json:"id" xml:"id"`
	Name		string	`json:"name" xml:"name"`
	Common		string	`json:"common" xml:"common"`
	Fingerprint string	`json:"fingerprint" xml:"fingerprint"`
	Issuer		string	`json:"issuer" xml:"issuer"`
	OrgName		string	`json:"orgName" xml:"orgName"`
	Province	string	`json:"province" xml:"province"`
	City		string	`json:"city" xml:"city"`
	Country		string	`json:"country" xml:"country"`
	StartDate	string	`json:"startDate" xml:"startDate"`
	EndDate		string	`json:"endDate" xml:"endDate"`
	Sans		string	`json:"sans" xml:"sans"`
	Expired		bool	`json:"expired" xml:"expired"`
	BuyInAliyun	bool	`json:"buyInAliyun" xml:"buyInAliyun"`
}

// DescribeUserCertificateListResponse is the response struct for api DescribeUserCertificateList
type DescribeUserCertificateListResponse struct {
	*responses.BaseResponse
	RequestId       string			`json:"RequestId" xml:"RequestId"`
	TotalCount      int				`json:"TotalCount" xml:"TotalCount"`
	ShowSize        int				`json:"ShowSize" xml:"ShowSize"`
	CurrentPage     int				`json:"CurrentPage" xml:"CurrentPage"`
	CertificateList []Certificate	`json:"CertificateList" xml:"CertificateList"`
}

// CreateDescribeUserCertificateListRequest creates a request to invoke DescribeUserCertificateList API
func CreateDescribeUserCertificateListRequest() (request *DescribeUserCertificateListRequest) {
	request = &DescribeUserCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2018-07-13", "DescribeUserCertificateList", "cas", "openAPI")
	return
}

// CreateDescribeUserCertificateListResponse creates a response to parse from DescribeUserCertificateList response
func CreateDescribeUserCertificateListResponse() (response *DescribeUserCertificateListResponse) {
	response = &DescribeUserCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
