package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMyGroupCategories invokes the cms.ListMyGroupCategories API synchronously
// api document: https://help.aliyun.com/api/cms/listmygroupcategories.html
func (client *Client) ListMyGroupCategories(request *ListMyGroupCategoriesRequest) (response *ListMyGroupCategoriesResponse, err error) {
	response = CreateListMyGroupCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListMyGroupCategoriesWithChan invokes the cms.ListMyGroupCategories API asynchronously
// api document: https://help.aliyun.com/api/cms/listmygroupcategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMyGroupCategoriesWithChan(request *ListMyGroupCategoriesRequest) (<-chan *ListMyGroupCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListMyGroupCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMyGroupCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMyGroupCategoriesWithCallback invokes the cms.ListMyGroupCategories API asynchronously
// api document: https://help.aliyun.com/api/cms/listmygroupcategories.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMyGroupCategoriesWithCallback(request *ListMyGroupCategoriesRequest, callback func(response *ListMyGroupCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMyGroupCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListMyGroupCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMyGroupCategoriesRequest is the request struct for api ListMyGroupCategories
type ListMyGroupCategoriesRequest struct {
	*requests.RpcRequest
	GroupId requests.Integer `position:"Query" name:"GroupId"`
}

// ListMyGroupCategoriesResponse is the response struct for api ListMyGroupCategories
type ListMyGroupCategoriesResponse struct {
	*responses.BaseResponse
	RequestId    string   `json:"RequestId" xml:"RequestId"`
	Success      bool     `json:"Success" xml:"Success"`
	ErrorCode    int      `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string   `json:"ErrorMessage" xml:"ErrorMessage"`
	Category     Category `json:"Category" xml:"Category"`
}

// CreateListMyGroupCategoriesRequest creates a request to invoke ListMyGroupCategories API
func CreateListMyGroupCategoriesRequest() (request *ListMyGroupCategoriesRequest) {
	request = &ListMyGroupCategoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ListMyGroupCategories", "cms", "openAPI")
	return
}

// CreateListMyGroupCategoriesResponse creates a response to parse from ListMyGroupCategories response
func CreateListMyGroupCategoriesResponse() (response *ListMyGroupCategoriesResponse) {
	response = &ListMyGroupCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
