package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMirrorList invokes the cr.GetMirrorList API synchronously
// api document: https://help.aliyun.com/api/cr/getmirrorlist.html
func (client *Client) GetMirrorList(request *GetMirrorListRequest) (response *GetMirrorListResponse, err error) {
	response = CreateGetMirrorListResponse()
	err = client.DoAction(request, response)
	return
}

// GetMirrorListWithChan invokes the cr.GetMirrorList API asynchronously
// api document: https://help.aliyun.com/api/cr/getmirrorlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMirrorListWithChan(request *GetMirrorListRequest) (<-chan *GetMirrorListResponse, <-chan error) {
	responseChan := make(chan *GetMirrorListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMirrorList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMirrorListWithCallback invokes the cr.GetMirrorList API asynchronously
// api document: https://help.aliyun.com/api/cr/getmirrorlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetMirrorListWithCallback(request *GetMirrorListRequest, callback func(response *GetMirrorListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMirrorListResponse
		var err error
		defer close(result)
		response, err = client.GetMirrorList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMirrorListRequest is the request struct for api GetMirrorList
type GetMirrorListRequest struct {
	*requests.RoaRequest
}

// GetMirrorListResponse is the response struct for api GetMirrorList
type GetMirrorListResponse struct {
	*responses.BaseResponse
}

// CreateGetMirrorListRequest creates a request to invoke GetMirrorList API
func CreateGetMirrorListRequest() (request *GetMirrorListRequest) {
	request = &GetMirrorListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetMirrorList", "/mirrors", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetMirrorListResponse creates a response to parse from GetMirrorList response
func CreateGetMirrorListResponse() (response *GetMirrorListResponse) {
	response = &GetMirrorListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
