package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CallBackAgilityCluster invokes the cs.CallBackAgilityCluster API synchronously
// api document: https://help.aliyun.com/api/cs/callbackagilitycluster.html
func (client *Client) CallBackAgilityCluster(request *CallBackAgilityClusterRequest) (response *CallBackAgilityClusterResponse, err error) {
	response = CreateCallBackAgilityClusterResponse()
	err = client.DoAction(request, response)
	return
}

// CallBackAgilityClusterWithChan invokes the cs.CallBackAgilityCluster API asynchronously
// api document: https://help.aliyun.com/api/cs/callbackagilitycluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CallBackAgilityClusterWithChan(request *CallBackAgilityClusterRequest) (<-chan *CallBackAgilityClusterResponse, <-chan error) {
	responseChan := make(chan *CallBackAgilityClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CallBackAgilityCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CallBackAgilityClusterWithCallback invokes the cs.CallBackAgilityCluster API asynchronously
// api document: https://help.aliyun.com/api/cs/callbackagilitycluster.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CallBackAgilityClusterWithCallback(request *CallBackAgilityClusterRequest, callback func(response *CallBackAgilityClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CallBackAgilityClusterResponse
		var err error
		defer close(result)
		response, err = client.CallBackAgilityCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CallBackAgilityClusterRequest is the request struct for api CallBackAgilityCluster
type CallBackAgilityClusterRequest struct {
	*requests.RoaRequest
	Token   string `position:"Path" name:"Token"`
	ReqOnce string `position:"Path" name:"ReqOnce"`
}

// CallBackAgilityClusterResponse is the response struct for api CallBackAgilityCluster
type CallBackAgilityClusterResponse struct {
	*responses.BaseResponse
}

// CreateCallBackAgilityClusterRequest creates a request to invoke CallBackAgilityCluster API
func CreateCallBackAgilityClusterRequest() (request *CallBackAgilityClusterRequest) {
	request = &CallBackAgilityClusterRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "CallBackAgilityCluster", "/agility/token/[Token]/req_once/[ReqOnce]/callback", "", "")
	request.Method = requests.POST
	return
}

// CreateCallBackAgilityClusterResponse creates a response to parse from CallBackAgilityCluster response
func CreateCallBackAgilityClusterResponse() (response *CallBackAgilityClusterResponse) {
	response = &CallBackAgilityClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
