package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterScaledNode invokes the cs.DescribeClusterScaledNode API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusterscalednode.html
func (client *Client) DescribeClusterScaledNode(request *DescribeClusterScaledNodeRequest) (response *DescribeClusterScaledNodeResponse, err error) {
	response = CreateDescribeClusterScaledNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterScaledNodeWithChan invokes the cs.DescribeClusterScaledNode API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterscalednode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterScaledNodeWithChan(request *DescribeClusterScaledNodeRequest) (<-chan *DescribeClusterScaledNodeResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterScaledNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterScaledNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterScaledNodeWithCallback invokes the cs.DescribeClusterScaledNode API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterscalednode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterScaledNodeWithCallback(request *DescribeClusterScaledNodeRequest, callback func(response *DescribeClusterScaledNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterScaledNodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterScaledNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterScaledNodeRequest is the request struct for api DescribeClusterScaledNode
type DescribeClusterScaledNodeRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterScaledNodeResponse is the response struct for api DescribeClusterScaledNode
type DescribeClusterScaledNodeResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterScaledNodeRequest creates a request to invoke DescribeClusterScaledNode API
func CreateDescribeClusterScaledNodeRequest() (request *DescribeClusterScaledNodeRequest) {
	request = &DescribeClusterScaledNodeRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterScaledNode", "/clusters/[ClusterId]/scaled_nodes/", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterScaledNodeResponse creates a response to parse from DescribeClusterScaledNode response
func CreateDescribeClusterScaledNodeResponse() (response *DescribeClusterScaledNodeResponse) {
	response = &DescribeClusterScaledNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
