package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDrdsDBs invokes the drds.DescribeDrdsDBs API synchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbs.html
func (client *Client) DescribeDrdsDBs(request *DescribeDrdsDBsRequest) (response *DescribeDrdsDBsResponse, err error) {
	response = CreateDescribeDrdsDBsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDrdsDBsWithChan invokes the drds.DescribeDrdsDBs API asynchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDrdsDBsWithChan(request *DescribeDrdsDBsRequest) (<-chan *DescribeDrdsDBsResponse, <-chan error) {
	responseChan := make(chan *DescribeDrdsDBsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDrdsDBs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDrdsDBsWithCallback invokes the drds.DescribeDrdsDBs API asynchronously
// api document: https://help.aliyun.com/api/drds/describedrdsdbs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDrdsDBsWithCallback(request *DescribeDrdsDBsRequest, callback func(response *DescribeDrdsDBsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDrdsDBsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDrdsDBs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDrdsDBsRequest is the request struct for api DescribeDrdsDBs
type DescribeDrdsDBsRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
}

// DescribeDrdsDBsResponse is the response struct for api DescribeDrdsDBs
type DescribeDrdsDBsResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Success   bool                  `json:"Success" xml:"Success"`
	Data      DataInDescribeDrdsDBs `json:"Data" xml:"Data"`
}

// CreateDescribeDrdsDBsRequest creates a request to invoke DescribeDrdsDBs API
func CreateDescribeDrdsDBsRequest() (request *DescribeDrdsDBsRequest) {
	request = &DescribeDrdsDBsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2017-10-16", "DescribeDrdsDBs", "", "")
	return
}

// CreateDescribeDrdsDBsResponse creates a response to parse from DescribeDrdsDBs response
func CreateDescribeDrdsDBsResponse() (response *DescribeDrdsDBsResponse) {
	response = &DescribeDrdsDBsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
