package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckDataSource invokes the emr.CheckDataSource API synchronously
// api document: https://help.aliyun.com/api/emr/checkdatasource.html
func (client *Client) CheckDataSource(request *CheckDataSourceRequest) (response *CheckDataSourceResponse, err error) {
	response = CreateCheckDataSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CheckDataSourceWithChan invokes the emr.CheckDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/checkdatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckDataSourceWithChan(request *CheckDataSourceRequest) (<-chan *CheckDataSourceResponse, <-chan error) {
	responseChan := make(chan *CheckDataSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckDataSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckDataSourceWithCallback invokes the emr.CheckDataSource API asynchronously
// api document: https://help.aliyun.com/api/emr/checkdatasource.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckDataSourceWithCallback(request *CheckDataSourceRequest, callback func(response *CheckDataSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckDataSourceResponse
		var err error
		defer close(result)
		response, err = client.CheckDataSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckDataSourceRequest is the request struct for api CheckDataSource
type CheckDataSourceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Conf            string           `position:"Query" name:"Conf"`
	Id              string           `position:"Query" name:"Id"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
}

// CheckDataSourceResponse is the response struct for api CheckDataSource
type CheckDataSourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	CommandId string `json:"CommandId" xml:"CommandId"`
}

// CreateCheckDataSourceRequest creates a request to invoke CheckDataSource API
func CreateCheckDataSourceRequest() (request *CheckDataSourceRequest) {
	request = &CheckDataSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "CheckDataSource", "emr", "openAPI")
	return
}

// CreateCheckDataSourceResponse creates a response to parse from CheckDataSource response
func CreateCheckDataSourceResponse() (response *CheckDataSourceResponse) {
	response = &CheckDataSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
