package finmall

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySignResult invokes the finmall.QuerySignResult API synchronously
// api document: https://help.aliyun.com/api/finmall/querysignresult.html
func (client *Client) QuerySignResult(request *QuerySignResultRequest) (response *QuerySignResultResponse, err error) {
	response = CreateQuerySignResultResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySignResultWithChan invokes the finmall.QuerySignResult API asynchronously
// api document: https://help.aliyun.com/api/finmall/querysignresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySignResultWithChan(request *QuerySignResultRequest) (<-chan *QuerySignResultResponse, <-chan error) {
	responseChan := make(chan *QuerySignResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySignResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySignResultWithCallback invokes the finmall.QuerySignResult API asynchronously
// api document: https://help.aliyun.com/api/finmall/querysignresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySignResultWithCallback(request *QuerySignResultRequest, callback func(response *QuerySignResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySignResultResponse
		var err error
		defer close(result)
		response, err = client.QuerySignResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySignResultRequest is the request struct for api QuerySignResult
type QuerySignResultRequest struct {
	*requests.RpcRequest
	ExtInfo string `position:"Query" name:"ExtInfo"`
	BizId   string `position:"Query" name:"BizId"`
	SceneId string `position:"Query" name:"SceneId"`
	Type    string `position:"Query" name:"Type"`
	UserId  string `position:"Query" name:"UserId"`
}

// QuerySignResultResponse is the response struct for api QuerySignResult
type QuerySignResultResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQuerySignResultRequest creates a request to invoke QuerySignResult API
func CreateQuerySignResultRequest() (request *QuerySignResultRequest) {
	request = &QuerySignResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("finmall", "2018-07-23", "QuerySignResult", "finmall", "openAPI")
	return
}

// CreateQuerySignResultResponse creates a response to parse from QuerySignResult response
func CreateQuerySignResultResponse() (response *QuerySignResultResponse) {
	response = &QuerySignResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
