package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccessRules invokes the nas.DescribeAccessRules API synchronously
// api document: https://help.aliyun.com/api/nas/describeaccessrules.html
func (client *Client) DescribeAccessRules(request *DescribeAccessRulesRequest) (response *DescribeAccessRulesResponse, err error) {
	response = CreateDescribeAccessRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccessRulesWithChan invokes the nas.DescribeAccessRules API asynchronously
// api document: https://help.aliyun.com/api/nas/describeaccessrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessRulesWithChan(request *DescribeAccessRulesRequest) (<-chan *DescribeAccessRulesResponse, <-chan error) {
	responseChan := make(chan *DescribeAccessRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccessRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccessRulesWithCallback invokes the nas.DescribeAccessRules API asynchronously
// api document: https://help.aliyun.com/api/nas/describeaccessrules.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAccessRulesWithCallback(request *DescribeAccessRulesRequest, callback func(response *DescribeAccessRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccessRulesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccessRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccessRulesRequest is the request struct for api DescribeAccessRules
type DescribeAccessRulesRequest struct {
	*requests.RpcRequest
	AccessGroupName string           `position:"Query" name:"AccessGroupName"`
	AccessRuleId    string           `position:"Query" name:"AccessRuleId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeAccessRulesResponse is the response struct for api DescribeAccessRules
type DescribeAccessRulesResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	TotalCount  int         `json:"TotalCount" xml:"TotalCount"`
	PageSize    int         `json:"PageSize" xml:"PageSize"`
	PageNumber  int         `json:"PageNumber" xml:"PageNumber"`
	AccessRules AccessRules `json:"AccessRules" xml:"AccessRules"`
}

// CreateDescribeAccessRulesRequest creates a request to invoke DescribeAccessRules API
func CreateDescribeAccessRulesRequest() (request *DescribeAccessRulesRequest) {
	request = &DescribeAccessRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeAccessRules", "nas", "openAPI")
	return
}

// CreateDescribeAccessRulesResponse creates a response to parse from DescribeAccessRules response
func CreateDescribeAccessRulesResponse() (response *DescribeAccessRulesResponse) {
	response = &DescribeAccessRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
