package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTags invokes the ots.DeleteTags API synchronously
// api document: https://help.aliyun.com/api/ots/deletetags.html
func (client *Client) DeleteTags(request *DeleteTagsRequest) (response *DeleteTagsResponse, err error) {
	response = CreateDeleteTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTagsWithChan invokes the ots.DeleteTags API asynchronously
// api document: https://help.aliyun.com/api/ots/deletetags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagsWithChan(request *DeleteTagsRequest) (<-chan *DeleteTagsResponse, <-chan error) {
	responseChan := make(chan *DeleteTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTagsWithCallback invokes the ots.DeleteTags API asynchronously
// api document: https://help.aliyun.com/api/ots/deletetags.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteTagsWithCallback(request *DeleteTagsRequest, callback func(response *DeleteTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTagsResponse
		var err error
		defer close(result)
		response, err = client.DeleteTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTagsRequest is the request struct for api DeleteTags
type DeleteTagsRequest struct {
	*requests.RpcRequest
	AccessKeyId     string               `position:"Query" name:"access_key_id"`
	ResourceOwnerId requests.Integer     `position:"Query" name:"ResourceOwnerId"`
	InstanceName    string               `position:"Query" name:"InstanceName"`
	TagInfo         *[]DeleteTagsTagInfo `position:"Query" name:"TagInfo"  type:"Repeated"`
}

// DeleteTagsTagInfo is a repeated param struct in DeleteTagsRequest
type DeleteTagsTagInfo struct {
	TagKey   string `name:"TagKey"`
	TagValue string `name:"TagValue"`
}

// DeleteTagsResponse is the response struct for api DeleteTags
type DeleteTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTagsRequest creates a request to invoke DeleteTags API
func CreateDeleteTagsRequest() (request *DeleteTagsRequest) {
	request = &DeleteTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "DeleteTags", "ots", "openAPI")
	return
}

// CreateDeleteTagsResponse creates a response to parse from DeleteTags response
func CreateDeleteTagsResponse() (response *DeleteTagsResponse) {
	response = &DeleteTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
