package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

func (client *Client) DeleteTrigger(request *DeleteTriggerRequest) (response *DeleteTriggerResponse, err error) {
	response = CreateDeleteTriggerResponse()
	err = client.DoAction(request, response)
	return
}

func (client *Client) DeleteTriggerWithChan(request *DeleteTriggerRequest) (<-chan *DeleteTriggerResponse, <-chan error) {
	responseChan := make(chan *DeleteTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTrigger(request)
		responseChan <- response
		errChan <- err
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

func (client *Client) DeleteTriggerWithCallback(request *DeleteTriggerRequest, callback func(response *DeleteTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTriggerResponse
		var err error
		defer close(result)
		response, err = client.DeleteTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

type DeleteTriggerRequest struct {
	*requests.RoaRequest
	InstanceName string `position:"Path" name:"InstanceName"`
	TriggerName  string `position:"Path" name:"TriggerName"`
	ApiVersion   string `position:"Path" name:"ApiVersion"`
	TableName    string `position:"Path" name:"TableName"`
}

type DeleteTriggerResponse struct {
	*responses.BaseResponse
}

func NewDeleteTriggerRequest(domain, instance, table, trigger, triggerArn string) (request *DeleteTriggerRequest) {
	triggerName := trigger
	if triggerArn != "" {
		triggerName += (TriggerQueryJointer + triggerArn)
	}
	request = &DeleteTriggerRequest{
		RoaRequest:   &requests.RoaRequest{},
		InstanceName: instance,
		TableName:    table,
		TriggerName:  triggerName,
		ApiVersion:   ApiVersion,
	}
	request.InitWithApiInfo("Ots", "2017-11-11", "DeleteTrigger", "/[ApiVersion]/instance/[InstanceName]/table/[TableName]/trigger/[TriggerName]", "", "")
	request.Domain = domain
	request.Method = "DELETE"
	return
}

func CreateDeleteTriggerResponse() (response *DeleteTriggerResponse) {
	response = &DeleteTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
