package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaskParam invokes the rtc.GetTaskParam API synchronously
// api document: https://help.aliyun.com/api/rtc/gettaskparam.html
func (client *Client) GetTaskParam(request *GetTaskParamRequest) (response *GetTaskParamResponse, err error) {
	response = CreateGetTaskParamResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaskParamWithChan invokes the rtc.GetTaskParam API asynchronously
// api document: https://help.aliyun.com/api/rtc/gettaskparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskParamWithChan(request *GetTaskParamRequest) (<-chan *GetTaskParamResponse, <-chan error) {
	responseChan := make(chan *GetTaskParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaskParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaskParamWithCallback invokes the rtc.GetTaskParam API asynchronously
// api document: https://help.aliyun.com/api/rtc/gettaskparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetTaskParamWithCallback(request *GetTaskParamRequest, callback func(response *GetTaskParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaskParamResponse
		var err error
		defer close(result)
		response, err = client.GetTaskParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaskParamRequest is the request struct for api GetTaskParam
type GetTaskParamRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
	TaskId  requests.Integer `position:"Query" name:"TaskId"`
}

// GetTaskParamResponse is the response struct for api GetTaskParam
type GetTaskParamResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	ChannelId  string  `json:"ChannelId" xml:"ChannelId"`
	TemplateId int     `json:"TemplateId" xml:"TemplateId"`
	MixPane    MixPane `json:"MixPane" xml:"MixPane"`
}

// CreateGetTaskParamRequest creates a request to invoke GetTaskParam API
func CreateGetTaskParamRequest() (request *GetTaskParamRequest) {
	request = &GetTaskParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "GetTaskParam", "rtc", "openAPI")
	return
}

// CreateGetTaskParamResponse creates a response to parse from GetTaskParam response
func CreateGetTaskParamResponse() (response *GetTaskParamResponse) {
	response = &GetTaskParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
