package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUisNodeIp invokes the uis.DeleteUisNodeIp API synchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnodeip.html
func (client *Client) DeleteUisNodeIp(request *DeleteUisNodeIpRequest) (response *DeleteUisNodeIpResponse, err error) {
	response = CreateDeleteUisNodeIpResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUisNodeIpWithChan invokes the uis.DeleteUisNodeIp API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnodeip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNodeIpWithChan(request *DeleteUisNodeIpRequest) (<-chan *DeleteUisNodeIpResponse, <-chan error) {
	responseChan := make(chan *DeleteUisNodeIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUisNodeIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUisNodeIpWithCallback invokes the uis.DeleteUisNodeIp API asynchronously
// api document: https://help.aliyun.com/api/uis/deleteuisnodeip.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteUisNodeIpWithCallback(request *DeleteUisNodeIpRequest, callback func(response *DeleteUisNodeIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUisNodeIpResponse
		var err error
		defer close(result)
		response, err = client.DeleteUisNodeIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUisNodeIpRequest is the request struct for api DeleteUisNodeIp
type DeleteUisNodeIpRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	UisNodeIpAddress     string           `position:"Query" name:"UisNodeIpAddress"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteUisNodeIpResponse is the response struct for api DeleteUisNodeIp
type DeleteUisNodeIpResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUisNodeIpRequest creates a request to invoke DeleteUisNodeIp API
func CreateDeleteUisNodeIpRequest() (request *DeleteUisNodeIpRequest) {
	request = &DeleteUisNodeIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "DeleteUisNodeIp", "uis", "openAPI")
	return
}

// CreateDeleteUisNodeIpResponse creates a response to parse from DeleteUisNodeIp response
func CreateDeleteUisNodeIpResponse() (response *DeleteUisNodeIpResponse) {
	response = &DeleteUisNodeIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
