// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/metrics.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v1/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Metrics data.
type Metrics struct {
	// The percent of your ad impressions that are shown as the very first ad
	// above the organic search results.
	AbsoluteTopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,95,opt,name=absolute_top_impression_percentage,json=absoluteTopImpressionPercentage,proto3" json:"absolute_top_impression_percentage,omitempty"`
	// Average cost of viewable impressions (`active_view_impressions`).
	ActiveViewCpm *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=active_view_cpm,json=activeViewCpm,proto3" json:"active_view_cpm,omitempty"`
	// Active view measurable clicks divided by active view viewable impressions.
	// This metric is reported only for display network.
	ActiveViewCtr *wrappers.DoubleValue `protobuf:"bytes,79,opt,name=active_view_ctr,json=activeViewCtr,proto3" json:"active_view_ctr,omitempty"`
	// A measurement of how often your ad has become viewable on a Display
	// Network site.
	ActiveViewImpressions *wrappers.Int64Value `protobuf:"bytes,2,opt,name=active_view_impressions,json=activeViewImpressions,proto3" json:"active_view_impressions,omitempty"`
	// The ratio of impressions that could be measured by Active View over the
	// number of served impressions.
	ActiveViewMeasurability *wrappers.DoubleValue `protobuf:"bytes,96,opt,name=active_view_measurability,json=activeViewMeasurability,proto3" json:"active_view_measurability,omitempty"`
	// The cost of the impressions you received that were measurable by Active
	// View.
	ActiveViewMeasurableCostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=active_view_measurable_cost_micros,json=activeViewMeasurableCostMicros,proto3" json:"active_view_measurable_cost_micros,omitempty"`
	// The number of times your ads are appearing on placements in positions
	// where they can be seen.
	ActiveViewMeasurableImpressions *wrappers.Int64Value `protobuf:"bytes,4,opt,name=active_view_measurable_impressions,json=activeViewMeasurableImpressions,proto3" json:"active_view_measurable_impressions,omitempty"`
	// The percentage of time when your ad appeared on an Active View enabled site
	// (measurable impressions) and was viewable (viewable impressions).
	ActiveViewViewability *wrappers.DoubleValue `protobuf:"bytes,97,opt,name=active_view_viewability,json=activeViewViewability,proto3" json:"active_view_viewability,omitempty"`
	// All conversions from interactions (as oppose to view through conversions)
	// divided by the number of ad interactions.
	AllConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,65,opt,name=all_conversions_from_interactions_rate,json=allConversionsFromInteractionsRate,proto3" json:"all_conversions_from_interactions_rate,omitempty"`
	// The total value of all conversions.
	AllConversionsValue *wrappers.DoubleValue `protobuf:"bytes,66,opt,name=all_conversions_value,json=allConversionsValue,proto3" json:"all_conversions_value,omitempty"`
	// The total number of conversions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	AllConversions *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=all_conversions,json=allConversions,proto3" json:"all_conversions,omitempty"`
	// The value of all conversions divided by the total cost of ad interactions
	// (such as clicks for text ads or views for video ads).
	AllConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,62,opt,name=all_conversions_value_per_cost,json=allConversionsValuePerCost,proto3" json:"all_conversions_value_per_cost,omitempty"`
	// The value of all conversions from interactions divided by the total number
	// of interactions.
	AllConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,67,opt,name=all_conversions_from_interactions_value_per_interaction,json=allConversionsFromInteractionsValuePerInteraction,proto3" json:"all_conversions_from_interactions_value_per_interaction,omitempty"`
	// The average amount you pay per interaction. This amount is the total cost
	// of your ads divided by the total number of interactions.
	AverageCost *wrappers.DoubleValue `protobuf:"bytes,8,opt,name=average_cost,json=averageCost,proto3" json:"average_cost,omitempty"`
	// The total cost of all clicks divided by the total number of clicks
	// received.
	AverageCpc *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=average_cpc,json=averageCpc,proto3" json:"average_cpc,omitempty"`
	// The average amount that you've been charged for an ad engagement. This
	// amount is the total cost of all ad engagements divided by the total number
	// of ad engagements.
	AverageCpe *wrappers.DoubleValue `protobuf:"bytes,98,opt,name=average_cpe,json=averageCpe,proto3" json:"average_cpe,omitempty"`
	// Average cost-per-thousand impressions (CPM).
	AverageCpm *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=average_cpm,json=averageCpm,proto3" json:"average_cpm,omitempty"`
	// The average amount you pay each time someone views your ad.
	// The average CPV is defined by the total cost of all ad views divided by
	// the number of views.
	AverageCpv *wrappers.DoubleValue `protobuf:"bytes,11,opt,name=average_cpv,json=averageCpv,proto3" json:"average_cpv,omitempty"`
	// Average number of times a unique cookie was exposed to your ad
	// over a given time period. Imported from Google Analytics.
	AverageFrequency *wrappers.DoubleValue `protobuf:"bytes,12,opt,name=average_frequency,json=averageFrequency,proto3" json:"average_frequency,omitempty"`
	// Average number of pages viewed per session.
	AveragePageViews *wrappers.DoubleValue `protobuf:"bytes,99,opt,name=average_page_views,json=averagePageViews,proto3" json:"average_page_views,omitempty"`
	// Your ad's position relative to those of other advertisers.
	AveragePosition *wrappers.DoubleValue `protobuf:"bytes,13,opt,name=average_position,json=averagePosition,proto3" json:"average_position,omitempty"`
	// Total duration of all sessions (in seconds) / number of sessions. Imported
	// from Google Analytics.
	AverageTimeOnSite *wrappers.DoubleValue `protobuf:"bytes,84,opt,name=average_time_on_site,json=averageTimeOnSite,proto3" json:"average_time_on_site,omitempty"`
	// An indication of how other advertisers are bidding on similar products.
	BenchmarkAverageMaxCpc *wrappers.DoubleValue `protobuf:"bytes,14,opt,name=benchmark_average_max_cpc,json=benchmarkAverageMaxCpc,proto3" json:"benchmark_average_max_cpc,omitempty"`
	// An indication on how other advertisers' Shopping ads for similar products
	// are performing based on how often people who see their ad click on it.
	BenchmarkCtr *wrappers.DoubleValue `protobuf:"bytes,77,opt,name=benchmark_ctr,json=benchmarkCtr,proto3" json:"benchmark_ctr,omitempty"`
	// Percentage of clicks where the user only visited a single page on your
	// site. Imported from Google Analytics.
	BounceRate *wrappers.DoubleValue `protobuf:"bytes,15,opt,name=bounce_rate,json=bounceRate,proto3" json:"bounce_rate,omitempty"`
	// The number of clicks.
	Clicks *wrappers.Int64Value `protobuf:"bytes,19,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// The estimated percent of times that your ad was eligible to show
	// on the Display Network but didn't because your budget was too low.
	// Note: Content budget lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,20,opt,name=content_budget_lost_impression_share,json=contentBudgetLostImpressionShare,proto3" json:"content_budget_lost_impression_share,omitempty"`
	// The impressions you've received on the Display Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Content impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	ContentImpressionShare *wrappers.DoubleValue `protobuf:"bytes,21,opt,name=content_impression_share,json=contentImpressionShare,proto3" json:"content_impression_share,omitempty"`
	// The last date/time a conversion tag for this conversion action successfully
	// fired and was seen by Google Ads. This firing event may not have been the
	// result of an attributable conversion (e.g. because the tag was fired from a
	// browser that did not previously click an ad from an appropriate
	// advertiser). The date/time is in the customer's time zone.
	ConversionLastReceivedRequestDateTime *wrappers.StringValue `protobuf:"bytes,73,opt,name=conversion_last_received_request_date_time,json=conversionLastReceivedRequestDateTime,proto3" json:"conversion_last_received_request_date_time,omitempty"`
	// The date of the most recent conversion for this conversion action. The date
	// is in the customer's time zone.
	ConversionLastConversionDate *wrappers.StringValue `protobuf:"bytes,74,opt,name=conversion_last_conversion_date,json=conversionLastConversionDate,proto3" json:"conversion_last_conversion_date,omitempty"`
	// The estimated percentage of impressions on the Display Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Content rank lost impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	ContentRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,22,opt,name=content_rank_lost_impression_share,json=contentRankLostImpressionShare,proto3" json:"content_rank_lost_impression_share,omitempty"`
	// Conversions from interactions divided by the number of ad interactions
	// (such as clicks for text ads or views for video ads). This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	ConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,69,opt,name=conversions_from_interactions_rate,json=conversionsFromInteractionsRate,proto3" json:"conversions_from_interactions_rate,omitempty"`
	// The total value of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsValue *wrappers.DoubleValue `protobuf:"bytes,70,opt,name=conversions_value,json=conversionsValue,proto3" json:"conversions_value,omitempty"`
	// The value of conversions divided by the cost of ad interactions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,71,opt,name=conversions_value_per_cost,json=conversionsValuePerCost,proto3" json:"conversions_value_per_cost,omitempty"`
	// The value of conversions from interactions divided by the number of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,72,opt,name=conversions_from_interactions_value_per_interaction,json=conversionsFromInteractionsValuePerInteraction,proto3" json:"conversions_from_interactions_value_per_interaction,omitempty"`
	// The number of conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,25,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// The sum of your cost-per-click (CPC) and cost-per-thousand impressions
	// (CPM) costs during this period.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,26,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// The cost of ad interactions divided by all conversions.
	CostPerAllConversions *wrappers.DoubleValue `protobuf:"bytes,68,opt,name=cost_per_all_conversions,json=costPerAllConversions,proto3" json:"cost_per_all_conversions,omitempty"`
	// The cost of ad interactions divided by conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CostPerConversion *wrappers.DoubleValue `protobuf:"bytes,28,opt,name=cost_per_conversion,json=costPerConversion,proto3" json:"cost_per_conversion,omitempty"`
	// The cost of ad interactions divided by current model attributed
	// conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CostPerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,106,opt,name=cost_per_current_model_attributed_conversion,json=costPerCurrentModelAttributedConversion,proto3" json:"cost_per_current_model_attributed_conversion,omitempty"`
	// Conversions from when a customer clicks on a Google Ads ad on one device,
	// then converts on a different device or browser.
	// Cross-device conversions are already included in all_conversions.
	CrossDeviceConversions *wrappers.DoubleValue `protobuf:"bytes,29,opt,name=cross_device_conversions,json=crossDeviceConversions,proto3" json:"cross_device_conversions,omitempty"`
	// The number of clicks your ad receives (Clicks) divided by the number
	// of times your ad is shown (Impressions).
	Ctr *wrappers.DoubleValue `protobuf:"bytes,30,opt,name=ctr,proto3" json:"ctr,omitempty"`
	// Shows how your historic conversions data would look under the attribution
	// model you've currently selected. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversions *wrappers.DoubleValue `protobuf:"bytes,101,opt,name=current_model_attributed_conversions,json=currentModelAttributedConversions,proto3" json:"current_model_attributed_conversions,omitempty"`
	// Current model attributed conversions from interactions divided by the
	// number of ad interactions (such as clicks for text ads or views for video
	// ads). This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsRate *wrappers.DoubleValue `protobuf:"bytes,102,opt,name=current_model_attributed_conversions_from_interactions_rate,json=currentModelAttributedConversionsFromInteractionsRate,proto3" json:"current_model_attributed_conversions_from_interactions_rate,omitempty"`
	// The value of current model attributed conversions from interactions divided
	// by the number of ad interactions. This only includes conversion actions
	// which include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsFromInteractionsValuePerInteraction *wrappers.DoubleValue `protobuf:"bytes,103,opt,name=current_model_attributed_conversions_from_interactions_value_per_interaction,json=currentModelAttributedConversionsFromInteractionsValuePerInteraction,proto3" json:"current_model_attributed_conversions_from_interactions_value_per_interaction,omitempty"`
	// The total value of current model attributed conversions. This only includes
	// conversion actions which include_in_conversions_metric attribute is set to
	// true.
	CurrentModelAttributedConversionsValue *wrappers.DoubleValue `protobuf:"bytes,104,opt,name=current_model_attributed_conversions_value,json=currentModelAttributedConversionsValue,proto3" json:"current_model_attributed_conversions_value,omitempty"`
	// The value of current model attributed conversions divided by the cost of ad
	// interactions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	CurrentModelAttributedConversionsValuePerCost *wrappers.DoubleValue `protobuf:"bytes,105,opt,name=current_model_attributed_conversions_value_per_cost,json=currentModelAttributedConversionsValuePerCost,proto3" json:"current_model_attributed_conversions_value_per_cost,omitempty"`
	// How often people engage with your ad after it's shown to them. This is the
	// number of ad expansions divided by the number of times your ad is shown.
	EngagementRate *wrappers.DoubleValue `protobuf:"bytes,31,opt,name=engagement_rate,json=engagementRate,proto3" json:"engagement_rate,omitempty"`
	// The number of engagements.
	// An engagement occurs when a viewer expands your Lightbox ad. Also, in the
	// future, other ad types may support engagement metrics.
	Engagements *wrappers.Int64Value `protobuf:"bytes,32,opt,name=engagements,proto3" json:"engagements,omitempty"`
	// Average lead value of hotel.
	HotelAverageLeadValueMicros *wrappers.DoubleValue `protobuf:"bytes,75,opt,name=hotel_average_lead_value_micros,json=hotelAverageLeadValueMicros,proto3" json:"hotel_average_lead_value_micros,omitempty"`
	// The creative historical quality score.
	HistoricalCreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,80,opt,name=historical_creative_quality_score,json=historicalCreativeQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_creative_quality_score,omitempty"`
	// The quality of historical landing page experience.
	HistoricalLandingPageQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,81,opt,name=historical_landing_page_quality_score,json=historicalLandingPageQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_landing_page_quality_score,omitempty"`
	// The historical quality score.
	HistoricalQualityScore *wrappers.Int64Value `protobuf:"bytes,82,opt,name=historical_quality_score,json=historicalQualityScore,proto3" json:"historical_quality_score,omitempty"`
	// The historical search predicted click through rate (CTR).
	HistoricalSearchPredictedCtr enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,83,opt,name=historical_search_predicted_ctr,json=historicalSearchPredictedCtr,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"historical_search_predicted_ctr,omitempty"`
	// The number of times the ad was forwarded to someone else as a message.
	GmailForwards *wrappers.Int64Value `protobuf:"bytes,85,opt,name=gmail_forwards,json=gmailForwards,proto3" json:"gmail_forwards,omitempty"`
	// The number of times someone has saved your Gmail ad to their inbox as a
	// message.
	GmailSaves *wrappers.Int64Value `protobuf:"bytes,86,opt,name=gmail_saves,json=gmailSaves,proto3" json:"gmail_saves,omitempty"`
	// The number of clicks to the landing page on the expanded state of Gmail
	// ads.
	GmailSecondaryClicks *wrappers.Int64Value `protobuf:"bytes,87,opt,name=gmail_secondary_clicks,json=gmailSecondaryClicks,proto3" json:"gmail_secondary_clicks,omitempty"`
	// Number of unique cookies that were exposed to your ad over a given time
	// period.
	ImpressionReach *wrappers.Int64Value `protobuf:"bytes,36,opt,name=impression_reach,json=impressionReach,proto3" json:"impression_reach,omitempty"`
	// Count of how often your ad has appeared on a search results page or
	// website on the Google Network.
	Impressions *wrappers.Int64Value `protobuf:"bytes,37,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// How often people interact with your ad after it is shown to them.
	// This is the number of interactions divided by the number of times your ad
	// is shown.
	InteractionRate *wrappers.DoubleValue `protobuf:"bytes,38,opt,name=interaction_rate,json=interactionRate,proto3" json:"interaction_rate,omitempty"`
	// The number of interactions.
	// An interaction is the main user action associated with an ad format-clicks
	// for text and shopping ads, views for video ads, and so on.
	Interactions *wrappers.Int64Value `protobuf:"bytes,39,opt,name=interactions,proto3" json:"interactions,omitempty"`
	// The types of payable and free interactions.
	InteractionEventTypes []enums.InteractionEventTypeEnum_InteractionEventType `protobuf:"varint,100,rep,packed,name=interaction_event_types,json=interactionEventTypes,proto3,enum=google.ads.googleads.v1.enums.InteractionEventTypeEnum_InteractionEventType" json:"interaction_event_types,omitempty"`
	// The percentage of clicks filtered out of your total number of clicks
	// (filtered + non-filtered clicks) during the reporting period.
	InvalidClickRate *wrappers.DoubleValue `protobuf:"bytes,40,opt,name=invalid_click_rate,json=invalidClickRate,proto3" json:"invalid_click_rate,omitempty"`
	// Number of clicks Google considers illegitimate and doesn't charge you for.
	InvalidClicks *wrappers.Int64Value `protobuf:"bytes,41,opt,name=invalid_clicks,json=invalidClicks,proto3" json:"invalid_clicks,omitempty"`
	// Percentage of first-time sessions (from people who had never visited your
	// site before). Imported from Google Analytics.
	PercentNewVisitors *wrappers.DoubleValue `protobuf:"bytes,42,opt,name=percent_new_visitors,json=percentNewVisitors,proto3" json:"percent_new_visitors,omitempty"`
	// Number of offline phone calls.
	PhoneCalls *wrappers.Int64Value `protobuf:"bytes,43,opt,name=phone_calls,json=phoneCalls,proto3" json:"phone_calls,omitempty"`
	// Number of offline phone impressions.
	PhoneImpressions *wrappers.Int64Value `protobuf:"bytes,44,opt,name=phone_impressions,json=phoneImpressions,proto3" json:"phone_impressions,omitempty"`
	// Number of phone calls received (phone_calls) divided by the number of
	// times your phone number is shown (phone_impressions).
	PhoneThroughRate *wrappers.DoubleValue `protobuf:"bytes,45,opt,name=phone_through_rate,json=phoneThroughRate,proto3" json:"phone_through_rate,omitempty"`
	// Your clickthrough rate (Ctr) divided by the average clickthrough rate of
	// all advertisers on the websites that show your ads. Measures how your ads
	// perform on Display Network sites compared to other ads on the same sites.
	RelativeCtr *wrappers.DoubleValue `protobuf:"bytes,46,opt,name=relative_ctr,json=relativeCtr,proto3" json:"relative_ctr,omitempty"`
	// The percentage of the customer's Shopping or Search ad impressions that are
	// shown in the most prominent Shopping position. See
	// <a href="https://support.google.com/adwords/answer/7501826">this Merchant
	// Center article</a> for details. Any value below 0.1 is reported as 0.0999.
	SearchAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,78,opt,name=search_absolute_top_impression_share,json=searchAbsoluteTopImpressionShare,proto3" json:"search_absolute_top_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to a low budget. Note: Search
	// budget lost absolute top impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchBudgetLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,88,opt,name=search_budget_lost_absolute_top_impression_share,json=searchBudgetLostAbsoluteTopImpressionShare,proto3" json:"search_budget_lost_absolute_top_impression_share,omitempty"`
	// The estimated percent of times that your ad was eligible to show on the
	// Search Network but didn't because your budget was too low. Note: Search
	// budget lost impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,47,opt,name=search_budget_lost_impression_share,json=searchBudgetLostImpressionShare,proto3" json:"search_budget_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to a low budget. Note: Search
	// budget lost top impression share is reported in the range of 0 to 0.9. Any
	// value above 0.9 is reported as 0.9001.
	SearchBudgetLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,89,opt,name=search_budget_lost_top_impression_share,json=searchBudgetLostTopImpressionShare,proto3" json:"search_budget_lost_top_impression_share,omitempty"`
	// The number of clicks you've received on the Search Network
	// divided by the estimated number of clicks you were eligible to receive.
	// Note: Search click share is reported in the range of 0.1 to 1. Any value
	// below 0.1 is reported as 0.0999.
	SearchClickShare *wrappers.DoubleValue `protobuf:"bytes,48,opt,name=search_click_share,json=searchClickShare,proto3" json:"search_click_share,omitempty"`
	// The impressions you've received divided by the estimated number of
	// impressions you were eligible to receive on the Search Network for search
	// terms that matched your keywords exactly (or were close variants of your
	// keyword), regardless of your keyword match types. Note: Search exact match
	// impression share is reported in the range of 0.1 to 1. Any value below 0.1
	// is reported as 0.0999.
	SearchExactMatchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,49,opt,name=search_exact_match_impression_share,json=searchExactMatchImpressionShare,proto3" json:"search_exact_match_impression_share,omitempty"`
	// The impressions you've received on the Search Network divided
	// by the estimated number of impressions you were eligible to receive.
	// Note: Search impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchImpressionShare *wrappers.DoubleValue `protobuf:"bytes,50,opt,name=search_impression_share,json=searchImpressionShare,proto3" json:"search_impression_share,omitempty"`
	// The number estimating how often your ad wasn't the very first ad above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost absolute top impression share is reported in the
	// range of 0 to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostAbsoluteTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,90,opt,name=search_rank_lost_absolute_top_impression_share,json=searchRankLostAbsoluteTopImpressionShare,proto3" json:"search_rank_lost_absolute_top_impression_share,omitempty"`
	// The estimated percentage of impressions on the Search Network
	// that your ads didn't receive due to poor Ad Rank.
	// Note: Search rank lost impression share is reported in the range of 0 to
	// 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostImpressionShare *wrappers.DoubleValue `protobuf:"bytes,51,opt,name=search_rank_lost_impression_share,json=searchRankLostImpressionShare,proto3" json:"search_rank_lost_impression_share,omitempty"`
	// The number estimating how often your ad didn't show anywhere above the
	// organic search results due to poor Ad Rank.
	// Note: Search rank lost top impression share is reported in the range of 0
	// to 0.9. Any value above 0.9 is reported as 0.9001.
	SearchRankLostTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,91,opt,name=search_rank_lost_top_impression_share,json=searchRankLostTopImpressionShare,proto3" json:"search_rank_lost_top_impression_share,omitempty"`
	// The impressions you've received in the top location (anywhere above the
	// organic search results) compared to the estimated number of impressions you
	// were eligible to receive in the top location.
	// Note: Search top impression share is reported in the range of 0.1 to 1. Any
	// value below 0.1 is reported as 0.0999.
	SearchTopImpressionShare *wrappers.DoubleValue `protobuf:"bytes,92,opt,name=search_top_impression_share,json=searchTopImpressionShare,proto3" json:"search_top_impression_share,omitempty"`
	// The percent of your ad impressions that are shown anywhere above the
	// organic search results.
	TopImpressionPercentage *wrappers.DoubleValue `protobuf:"bytes,93,opt,name=top_impression_percentage,json=topImpressionPercentage,proto3" json:"top_impression_percentage,omitempty"`
	// The value of all conversions divided by the number of all conversions.
	ValuePerAllConversions *wrappers.DoubleValue `protobuf:"bytes,52,opt,name=value_per_all_conversions,json=valuePerAllConversions,proto3" json:"value_per_all_conversions,omitempty"`
	// The value of conversions divided by the number of conversions. This only
	// includes conversion actions which include_in_conversions_metric attribute
	// is set to true.
	ValuePerConversion *wrappers.DoubleValue `protobuf:"bytes,53,opt,name=value_per_conversion,json=valuePerConversion,proto3" json:"value_per_conversion,omitempty"`
	// The value of current model attributed conversions divided by the number of
	// the conversions. This only includes conversion actions which
	// include_in_conversions_metric attribute is set to true.
	ValuePerCurrentModelAttributedConversion *wrappers.DoubleValue `protobuf:"bytes,94,opt,name=value_per_current_model_attributed_conversion,json=valuePerCurrentModelAttributedConversion,proto3" json:"value_per_current_model_attributed_conversion,omitempty"`
	// Percentage of impressions where the viewer watched all of your video.
	VideoQuartile_100Rate *wrappers.DoubleValue `protobuf:"bytes,54,opt,name=video_quartile_100_rate,json=videoQuartile100Rate,proto3" json:"video_quartile_100_rate,omitempty"`
	// Percentage of impressions where the viewer watched 25% of your video.
	VideoQuartile_25Rate *wrappers.DoubleValue `protobuf:"bytes,55,opt,name=video_quartile_25_rate,json=videoQuartile25Rate,proto3" json:"video_quartile_25_rate,omitempty"`
	// Percentage of impressions where the viewer watched 50% of your video.
	VideoQuartile_50Rate *wrappers.DoubleValue `protobuf:"bytes,56,opt,name=video_quartile_50_rate,json=videoQuartile50Rate,proto3" json:"video_quartile_50_rate,omitempty"`
	// Percentage of impressions where the viewer watched 75% of your video.
	VideoQuartile_75Rate *wrappers.DoubleValue `protobuf:"bytes,57,opt,name=video_quartile_75_rate,json=videoQuartile75Rate,proto3" json:"video_quartile_75_rate,omitempty"`
	// The number of views your TrueView video ad receives divided by its number
	// of impressions, including thumbnail impressions for TrueView in-display
	// ads.
	VideoViewRate *wrappers.DoubleValue `protobuf:"bytes,58,opt,name=video_view_rate,json=videoViewRate,proto3" json:"video_view_rate,omitempty"`
	// The number of times your video ads were viewed.
	VideoViews *wrappers.Int64Value `protobuf:"bytes,59,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	// The total number of view-through conversions.
	// These happen when a customer sees an image or rich media ad, then later
	// completes a conversion on your site without interacting with (e.g.,
	// clicking on) another ad.
	ViewThroughConversions *wrappers.Int64Value `protobuf:"bytes,60,opt,name=view_through_conversions,json=viewThroughConversions,proto3" json:"view_through_conversions,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}             `json:"-"`
	XXX_unrecognized       []byte               `json:"-"`
	XXX_sizecache          int32                `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_metrics_2cc5cc247c8c5e27, []int{0}
}
func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (dst *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(dst, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetAbsoluteTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.AbsoluteTopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetActiveViewCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCpm
	}
	return nil
}

func (m *Metrics) GetActiveViewCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewCtr
	}
	return nil
}

func (m *Metrics) GetActiveViewImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewMeasurability
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableCostMicros
	}
	return nil
}

func (m *Metrics) GetActiveViewMeasurableImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.ActiveViewMeasurableImpressions
	}
	return nil
}

func (m *Metrics) GetActiveViewViewability() *wrappers.DoubleValue {
	if m != nil {
		return m.ActiveViewViewability
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetAllConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValue
	}
	return nil
}

func (m *Metrics) GetAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversions
	}
	return nil
}

func (m *Metrics) GetAllConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetAllConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.AllConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetAverageCost() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCost
	}
	return nil
}

func (m *Metrics) GetAverageCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpc
	}
	return nil
}

func (m *Metrics) GetAverageCpe() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpe
	}
	return nil
}

func (m *Metrics) GetAverageCpm() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpm
	}
	return nil
}

func (m *Metrics) GetAverageCpv() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageCpv
	}
	return nil
}

func (m *Metrics) GetAverageFrequency() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageFrequency
	}
	return nil
}

func (m *Metrics) GetAveragePageViews() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePageViews
	}
	return nil
}

func (m *Metrics) GetAveragePosition() *wrappers.DoubleValue {
	if m != nil {
		return m.AveragePosition
	}
	return nil
}

func (m *Metrics) GetAverageTimeOnSite() *wrappers.DoubleValue {
	if m != nil {
		return m.AverageTimeOnSite
	}
	return nil
}

func (m *Metrics) GetBenchmarkAverageMaxCpc() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkAverageMaxCpc
	}
	return nil
}

func (m *Metrics) GetBenchmarkCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.BenchmarkCtr
	}
	return nil
}

func (m *Metrics) GetBounceRate() *wrappers.DoubleValue {
	if m != nil {
		return m.BounceRate
	}
	return nil
}

func (m *Metrics) GetClicks() *wrappers.Int64Value {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Metrics) GetContentBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetContentImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionLastReceivedRequestDateTime() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastReceivedRequestDateTime
	}
	return nil
}

func (m *Metrics) GetConversionLastConversionDate() *wrappers.StringValue {
	if m != nil {
		return m.ConversionLastConversionDate
	}
	return nil
}

func (m *Metrics) GetContentRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.ContentRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValue
	}
	return nil
}

func (m *Metrics) GetConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.ConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Metrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Metrics) GetCostPerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerAllConversions
	}
	return nil
}

func (m *Metrics) GetCostPerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerConversion
	}
	return nil
}

func (m *Metrics) GetCostPerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.CostPerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetCrossDeviceConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CrossDeviceConversions
	}
	return nil
}

func (m *Metrics) GetCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.Ctr
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversions
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsRate() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsRate
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsFromInteractionsValuePerInteraction() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsFromInteractionsValuePerInteraction
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValue() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValue
	}
	return nil
}

func (m *Metrics) GetCurrentModelAttributedConversionsValuePerCost() *wrappers.DoubleValue {
	if m != nil {
		return m.CurrentModelAttributedConversionsValuePerCost
	}
	return nil
}

func (m *Metrics) GetEngagementRate() *wrappers.DoubleValue {
	if m != nil {
		return m.EngagementRate
	}
	return nil
}

func (m *Metrics) GetEngagements() *wrappers.Int64Value {
	if m != nil {
		return m.Engagements
	}
	return nil
}

func (m *Metrics) GetHotelAverageLeadValueMicros() *wrappers.DoubleValue {
	if m != nil {
		return m.HotelAverageLeadValueMicros
	}
	return nil
}

func (m *Metrics) GetHistoricalCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalCreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalLandingPageQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalLandingPageQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetHistoricalQualityScore() *wrappers.Int64Value {
	if m != nil {
		return m.HistoricalQualityScore
	}
	return nil
}

func (m *Metrics) GetHistoricalSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.HistoricalSearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *Metrics) GetGmailForwards() *wrappers.Int64Value {
	if m != nil {
		return m.GmailForwards
	}
	return nil
}

func (m *Metrics) GetGmailSaves() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSaves
	}
	return nil
}

func (m *Metrics) GetGmailSecondaryClicks() *wrappers.Int64Value {
	if m != nil {
		return m.GmailSecondaryClicks
	}
	return nil
}

func (m *Metrics) GetImpressionReach() *wrappers.Int64Value {
	if m != nil {
		return m.ImpressionReach
	}
	return nil
}

func (m *Metrics) GetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Metrics) GetInteractionRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InteractionRate
	}
	return nil
}

func (m *Metrics) GetInteractions() *wrappers.Int64Value {
	if m != nil {
		return m.Interactions
	}
	return nil
}

func (m *Metrics) GetInteractionEventTypes() []enums.InteractionEventTypeEnum_InteractionEventType {
	if m != nil {
		return m.InteractionEventTypes
	}
	return nil
}

func (m *Metrics) GetInvalidClickRate() *wrappers.DoubleValue {
	if m != nil {
		return m.InvalidClickRate
	}
	return nil
}

func (m *Metrics) GetInvalidClicks() *wrappers.Int64Value {
	if m != nil {
		return m.InvalidClicks
	}
	return nil
}

func (m *Metrics) GetPercentNewVisitors() *wrappers.DoubleValue {
	if m != nil {
		return m.PercentNewVisitors
	}
	return nil
}

func (m *Metrics) GetPhoneCalls() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneCalls
	}
	return nil
}

func (m *Metrics) GetPhoneImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.PhoneImpressions
	}
	return nil
}

func (m *Metrics) GetPhoneThroughRate() *wrappers.DoubleValue {
	if m != nil {
		return m.PhoneThroughRate
	}
	return nil
}

func (m *Metrics) GetRelativeCtr() *wrappers.DoubleValue {
	if m != nil {
		return m.RelativeCtr
	}
	return nil
}

func (m *Metrics) GetSearchAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchBudgetLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchBudgetLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchClickShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchClickShare
	}
	return nil
}

func (m *Metrics) GetSearchExactMatchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchExactMatchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostAbsoluteTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostAbsoluteTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchRankLostTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchRankLostTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetSearchTopImpressionShare() *wrappers.DoubleValue {
	if m != nil {
		return m.SearchTopImpressionShare
	}
	return nil
}

func (m *Metrics) GetTopImpressionPercentage() *wrappers.DoubleValue {
	if m != nil {
		return m.TopImpressionPercentage
	}
	return nil
}

func (m *Metrics) GetValuePerAllConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerAllConversions
	}
	return nil
}

func (m *Metrics) GetValuePerConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerConversion
	}
	return nil
}

func (m *Metrics) GetValuePerCurrentModelAttributedConversion() *wrappers.DoubleValue {
	if m != nil {
		return m.ValuePerCurrentModelAttributedConversion
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_100Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_100Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_25Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_25Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_50Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_50Rate
	}
	return nil
}

func (m *Metrics) GetVideoQuartile_75Rate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoQuartile_75Rate
	}
	return nil
}

func (m *Metrics) GetVideoViewRate() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViewRate
	}
	return nil
}

func (m *Metrics) GetVideoViews() *wrappers.Int64Value {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

func (m *Metrics) GetViewThroughConversions() *wrappers.Int64Value {
	if m != nil {
		return m.ViewThroughConversions
	}
	return nil
}

func init() {
	proto.RegisterType((*Metrics)(nil), "google.ads.googleads.v1.common.Metrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/metrics.proto", fileDescriptor_metrics_2cc5cc247c8c5e27)
}

var fileDescriptor_metrics_2cc5cc247c8c5e27 = []byte{
	// 2168 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x9a, 0xdb, 0x72, 0x1b, 0xb7,
	0x19, 0xc7, 0x87, 0x76, 0x27, 0x69, 0x3f, 0xc9, 0x92, 0xb3, 0x96, 0x25, 0x48, 0x56, 0x24, 0x59,
	0xf5, 0x41, 0x75, 0x6d, 0x52, 0x92, 0xa3, 0x38, 0xa5, 0xed, 0x64, 0xa8, 0x93, 0x2d, 0x55, 0x72,
	0x74, 0x32, 0xed, 0x24, 0x6a, 0x37, 0xe0, 0x2e, 0x44, 0x6e, 0xb4, 0x07, 0x1a, 0x00, 0x29, 0x6b,
	0x3a, 0xed, 0x45, 0xa7, 0x17, 0xed, 0x55, 0x3b, 0xd3, 0x9b, 0x4c, 0x2f, 0x7b, 0xd9, 0x27, 0xe8,
	0x33, 0xf4, 0x45, 0x3a, 0xd3, 0xa7, 0xe8, 0xe0, 0xb0, 0xdc, 0x25, 0xb9, 0xd4, 0x42, 0x99, 0xdc,
	0xd8, 0xf4, 0x1a, 0xff, 0xdf, 0xff, 0x03, 0x16, 0xf8, 0x00, 0x7c, 0x24, 0x3c, 0xac, 0x47, 0x51,
	0xdd, 0x27, 0x25, 0xec, 0xb2, 0x92, 0xfa, 0x28, 0x3e, 0xb5, 0x97, 0x4a, 0x4e, 0x14, 0x04, 0x51,
	0x58, 0x0a, 0x08, 0xa7, 0x9e, 0xc3, 0x8a, 0x4d, 0x1a, 0xf1, 0xc8, 0x9a, 0x51, 0x4d, 0x8a, 0xd8,
	0x65, 0xc5, 0x4e, 0xeb, 0x62, 0x7b, 0xa9, 0xa8, 0x5a, 0x4f, 0x95, 0x07, 0xd1, 0x48, 0xd8, 0x0a,
	0x58, 0xc9, 0x0b, 0x39, 0xa1, 0xd8, 0xe1, 0x5e, 0x14, 0xda, 0xa4, 0x4d, 0x42, 0x6e, 0xf3, 0xf3,
	0x26, 0x51, 0xec, 0xa9, 0xcf, 0x2e, 0xd6, 0xbe, 0x6b, 0x61, 0xdf, 0xe3, 0xe7, 0x36, 0x73, 0x22,
	0x4a, 0xec, 0x5a, 0xcb, 0x39, 0x25, 0x5c, 0x2b, 0x75, 0x54, 0x25, 0xf9, 0xaf, 0x5a, 0xeb, 0xa4,
	0x74, 0x46, 0x71, 0xb3, 0x49, 0xa8, 0x8e, 0x7a, 0x6a, 0x3a, 0x26, 0x37, 0xbd, 0x12, 0x0e, 0xc3,
	0x88, 0x63, 0x11, 0x81, 0xfe, 0xdf, 0xf9, 0xef, 0x2b, 0xf0, 0xe1, 0xae, 0xea, 0xa5, 0xe5, 0xc1,
	0x3c, 0xae, 0xb1, 0xc8, 0x6f, 0x71, 0x62, 0xf3, 0xa8, 0x69, 0x7b, 0x41, 0x93, 0x12, 0xc6, 0x44,
	0xbc, 0x4d, 0x42, 0x1d, 0x12, 0x72, 0x5c, 0x27, 0xc8, 0x9e, 0x2b, 0x2c, 0x0c, 0x2d, 0x4f, 0xeb,
	0x11, 0x28, 0xc6, 0xb6, 0xc5, 0xf5, 0xa8, 0x55, 0xf3, 0x49, 0x15, 0xfb, 0x2d, 0x72, 0x30, 0x1b,
	0x73, 0x8e, 0xa2, 0xe6, 0x56, 0x87, 0xb2, 0xd7, 0x81, 0x58, 0xeb, 0x30, 0x2a, 0x46, 0xa2, 0x4d,
	0xec, 0xb6, 0x47, 0xce, 0x6c, 0xa7, 0x19, 0xa0, 0x82, 0x01, 0xf7, 0x9a, 0x12, 0x55, 0x3d, 0x72,
	0xb6, 0xd6, 0x0c, 0xfa, 0x28, 0x9c, 0xa2, 0x2f, 0x2f, 0x49, 0xe1, 0xd4, 0x3a, 0x84, 0x89, 0x34,
	0x25, 0xe9, 0x35, 0x43, 0x57, 0x24, 0xed, 0x56, 0x1f, 0x6d, 0x2b, 0xe4, 0x9f, 0x7e, 0xa2, 0x60,
	0x37, 0x13, 0x58, 0xd2, 0x53, 0x66, 0xbd, 0x85, 0xc9, 0x34, 0x34, 0x20, 0x98, 0xb5, 0x28, 0xae,
	0x79, 0xe2, 0x2d, 0xa2, 0x6f, 0x0d, 0x82, 0x9c, 0x48, 0xb8, 0xbb, 0x69, 0xb1, 0x55, 0x87, 0xf9,
	0x2c, 0xb2, 0x4f, 0x6c, 0x27, 0x62, 0xdc, 0x0e, 0x3c, 0x87, 0x46, 0x0c, 0x5d, 0xcd, 0x8f, 0x7c,
	0xa6, 0xdf, 0xc1, 0x27, 0x6b, 0x11, 0xe3, 0xbb, 0x12, 0x61, 0x35, 0x06, 0x1a, 0xa5, 0x87, 0xe8,
	0x27, 0xf9, 0x46, 0xb3, 0x59, 0x46, 0xe9, 0xc1, 0x3a, 0xea, 0x7e, 0x03, 0xe2, 0x8f, 0x78, 0xa8,
	0xb0, 0xc1, 0x50, 0xa5, 0x5e, 0x41, 0x35, 0x91, 0x5a, 0x4d, 0xb8, 0x87, 0x7d, 0xdf, 0x76, 0xa2,
	0xb0, 0x4d, 0xa8, 0x34, 0xb2, 0x4f, 0x68, 0x14, 0xd8, 0xa9, 0x75, 0xc8, 0x6c, 0x8a, 0x39, 0x41,
	0x15, 0x03, 0x93, 0x79, 0xec, 0xfb, 0x6b, 0x09, 0x6a, 0x93, 0x46, 0xc1, 0x56, 0x0a, 0x74, 0x80,
	0x39, 0xb1, 0xf6, 0xe0, 0x66, 0xaf, 0x63, 0x5b, 0x88, 0xd1, 0xaa, 0x81, 0xc1, 0x8d, 0x6e, 0x03,
	0xf9, 0xd0, 0xda, 0x80, 0xd1, 0x1e, 0x22, 0xfa, 0xd0, 0x80, 0x35, 0xd2, 0xcd, 0xb2, 0xbe, 0x85,
	0x99, 0xcc, 0xc0, 0xc4, 0xba, 0x96, 0xd3, 0x06, 0x7d, 0x6e, 0x40, 0x9d, 0xca, 0x88, 0x70, 0x8f,
	0x50, 0x31, 0x65, 0xac, 0xbf, 0x15, 0xe0, 0x49, 0xfe, 0x68, 0x27, 0xa6, 0xa9, 0xc7, 0x68, 0xcd,
	0xc0, 0x7b, 0xe9, 0xe2, 0xe1, 0x8f, 0x63, 0x49, 0x3d, 0xb3, 0xbe, 0x80, 0x61, 0xdc, 0x26, 0x14,
	0xd7, 0xd5, 0xca, 0x40, 0x3f, 0x35, 0xb0, 0x19, 0xd2, 0x0a, 0xd9, 0xa7, 0xe7, 0x30, 0xd4, 0x01,
	0x34, 0x1d, 0xf4, 0x33, 0x03, 0x3d, 0xc4, 0xfa, 0xa6, 0xd3, 0x2d, 0x27, 0xa8, 0x76, 0x29, 0x39,
	0xe9, 0x96, 0x07, 0x08, 0x2e, 0x25, 0x0f, 0xba, 0xe5, 0x6d, 0x34, 0x74, 0x29, 0x79, 0xdb, 0xda,
	0x82, 0x8f, 0x62, 0xf9, 0x09, 0x25, 0xef, 0x5a, 0x24, 0x74, 0xce, 0xd1, 0xb0, 0x01, 0xe4, 0xba,
	0x96, 0x6d, 0xc6, 0x2a, 0x6b, 0x1b, 0xac, 0x18, 0xd5, 0x14, 0x7f, 0x88, 0xe5, 0xcd, 0x90, 0x73,
	0x09, 0xd6, 0x1e, 0xae, 0xcb, 0xd5, 0xcd, 0xac, 0x17, 0x70, 0xbd, 0xc3, 0x8a, 0x98, 0x27, 0xa7,
	0xcf, 0x35, 0x03, 0xd2, 0x68, 0x4c, 0xd2, 0x22, 0x6b, 0x17, 0xc6, 0x62, 0x10, 0xf7, 0x02, 0x62,
	0x47, 0xa1, 0xcd, 0x3c, 0x4e, 0xd0, 0x91, 0x01, 0x2c, 0x1e, 0x99, 0x23, 0x2f, 0x20, 0x5f, 0x86,
	0x87, 0x1e, 0x27, 0xd6, 0x1b, 0x98, 0xac, 0x91, 0xd0, 0x69, 0x04, 0x98, 0x9e, 0xda, 0x31, 0x38,
	0xc0, 0xef, 0xe5, 0xc4, 0x19, 0x31, 0x60, 0x8e, 0x77, 0xe4, 0x15, 0xa5, 0xde, 0xc5, 0xef, 0xc5,
	0x24, 0xaa, 0xc0, 0xb5, 0x04, 0x2c, 0x36, 0xb8, 0x5d, 0x03, 0xd8, 0x70, 0x47, 0x22, 0xf6, 0xb7,
	0xe7, 0x30, 0x54, 0x8b, 0x5a, 0xa1, 0x43, 0x54, 0xb2, 0x1b, 0x35, 0x99, 0x09, 0x4a, 0x20, 0x93,
	0xda, 0x63, 0xf8, 0xc0, 0xf1, 0x3d, 0xe7, 0x94, 0xa1, 0x1b, 0xf9, 0xa9, 0x5e, 0x37, 0xb5, 0x7c,
	0xb8, 0xe3, 0x44, 0x21, 0x17, 0x87, 0x9c, 0x5a, 0xcb, 0xad, 0x13, 0x6e, 0xfb, 0x62, 0x73, 0x4a,
	0x9d, 0x28, 0x58, 0x03, 0x53, 0x82, 0xc6, 0x0c, 0x82, 0x99, 0xd3, 0xa4, 0x55, 0x09, 0xda, 0x89,
	0x18, 0x4f, 0xf6, 0x8e, 0x43, 0x41, 0xb1, 0xaa, 0x80, 0x62, 0xb7, 0x3e, 0x87, 0x9b, 0x26, 0x83,
	0xaf, 0xd5, 0xbd, 0xdc, 0x33, 0x78, 0x90, 0xe4, 0x33, 0xdb, 0xc7, 0x8c, 0xdb, 0x94, 0x38, 0xc4,
	0x6b, 0x13, 0xd7, 0x96, 0xd3, 0x9b, 0x71, 0xdb, 0xc5, 0x5c, 0x4d, 0x21, 0xb4, 0x35, 0xc0, 0xe9,
	0x90, 0x53, 0x2f, 0xac, 0x2b, 0xa7, 0xbb, 0x09, 0x6f, 0x07, 0x33, 0x7e, 0xa0, 0x69, 0x07, 0x0a,
	0xb6, 0x8e, 0xb9, 0x9c, 0x54, 0x96, 0x03, 0xb3, 0xbd, 0xc6, 0xa9, 0x7f, 0x0b, 0x4b, 0xb4, 0x6d,
	0xe0, 0x36, 0xdd, 0xed, 0x96, 0xe4, 0x4f, 0x61, 0x24, 0xf6, 0xf7, 0x78, 0xd4, 0x28, 0x0e, 0x4f,
	0x07, 0xbc, 0xa1, 0x71, 0x83, 0xf1, 0x9b, 0xd1, 0x9c, 0x03, 0x1c, 0x9e, 0x66, 0xbd, 0x1f, 0x4f,
	0x3a, 0xe5, 0xed, 0xc2, 0x1b, 0x26, 0x07, 0x4b, 0x27, 0x67, 0x0b, 0xde, 0x82, 0x8f, 0xfa, 0xb7,
	0xdf, 0x4d, 0x93, 0x5c, 0xe3, 0xf4, 0xee, 0xbd, 0x5f, 0xc1, 0xd4, 0x05, 0x1b, 0xe6, 0x0b, 0x93,
	0x33, 0x9c, 0x33, 0x60, 0xb7, 0xfc, 0x4b, 0x01, 0x1e, 0xff, 0x90, 0x9d, 0xf2, 0xa5, 0x81, 0x69,
	0xd1, 0xb9, 0xdc, 0x36, 0xf9, 0x39, 0x0c, 0xa5, 0x8f, 0x17, 0x93, 0x26, 0xbb, 0x64, 0x4a, 0x60,
	0x3d, 0x13, 0xfa, 0xe4, 0xe0, 0x39, 0x95, 0x9f, 0x24, 0xc0, 0x49, 0x0e, 0x99, 0xaf, 0xc5, 0xd2,
	0x65, 0x5c, 0xf6, 0xb4, 0xf7, 0xa4, 0xb3, 0x6e, 0x72, 0xf6, 0x13, 0xea, 0x3d, 0x42, 0x2b, 0xdd,
	0x07, 0x9e, 0x1d, 0xb8, 0xd1, 0xc1, 0x26, 0x48, 0x34, 0x6d, 0x92, 0xdd, 0x35, 0x31, 0xc1, 0x59,
	0xbf, 0x83, 0x87, 0x09, 0xad, 0x45, 0xa9, 0x58, 0x32, 0x41, 0xe4, 0x12, 0xdf, 0xc6, 0x9c, 0x53,
	0xaf, 0xd6, 0xe2, 0xc4, 0x4d, 0xdb, 0x7c, 0x67, 0x60, 0x73, 0x3f, 0xb6, 0x51, 0xbc, 0x5d, 0x81,
	0xab, 0x74, 0x68, 0x29, 0x73, 0x91, 0xdc, 0x68, 0xc4, 0x98, 0xed, 0x92, 0xb6, 0xe7, 0x90, 0xae,
	0x11, 0xfa, 0xd8, 0x28, 0xb9, 0x09, 0xf5, 0xba, 0x14, 0xa7, 0x87, 0xa8, 0x08, 0x57, 0xc5, 0x7e,
	0x32, 0x63, 0x80, 0x10, 0x0d, 0xad, 0x00, 0xee, 0x18, 0xf4, 0x9d, 0x21, 0x62, 0x00, 0xbc, 0xed,
	0xe4, 0xf4, 0x9a, 0x59, 0xdf, 0x17, 0xe0, 0xa9, 0x89, 0xdf, 0xa0, 0x6c, 0x72, 0x62, 0x10, 0xc6,
	0x4a, 0x6e, 0x18, 0x99, 0x39, 0xe6, 0xdf, 0x05, 0xd8, 0xf9, 0x81, 0xa1, 0x65, 0x2f, 0xeb, 0xba,
	0x41, 0xac, 0xeb, 0x97, 0x8e, 0x35, 0x6b, 0xb1, 0xbf, 0x87, 0x07, 0x46, 0x91, 0xab, 0xbc, 0xd9,
	0x30, 0x88, 0xeb, 0x5e, 0x6e, 0x5c, 0x2a, 0x9b, 0xfe, 0x59, 0xa4, 0x3c, 0x63, 0xeb, 0x24, 0xcf,
	0x7a, 0x06, 0x31, 0x3c, 0x32, 0x8b, 0x21, 0xce, 0xbe, 0x1b, 0x30, 0x4a, 0xc2, 0x3a, 0xae, 0x93,
	0x40, 0xed, 0x7d, 0x9c, 0xa0, 0x59, 0x93, 0x4b, 0x55, 0x22, 0x92, 0xd3, 0xe0, 0x39, 0x0c, 0x25,
	0x4f, 0x18, 0x9a, 0xcb, 0x4f, 0x7c, 0xe9, 0xf6, 0x56, 0x0d, 0x66, 0x1b, 0x11, 0x17, 0xe3, 0xa0,
	0x8f, 0x8b, 0x3e, 0xc1, 0xae, 0xee, 0xbd, 0xce, 0xa5, 0xbf, 0x36, 0x88, 0xea, 0x96, 0x84, 0xe8,
	0x43, 0xe3, 0x0e, 0xc1, 0xae, 0x7c, 0xac, 0xb3, 0xeb, 0xdf, 0x0b, 0x70, 0xbb, 0xe1, 0x31, 0x1e,
	0x51, 0xcf, 0xc1, 0xbe, 0xed, 0x50, 0x82, 0xe5, 0x35, 0xbb, 0xab, 0x9c, 0x84, 0xf6, 0xe6, 0x0a,
	0x0b, 0x23, 0xcb, 0x2f, 0x8b, 0x83, 0xca, 0x5b, 0xb2, 0x04, 0x55, 0xdc, 0x57, 0x9a, 0x43, 0x21,
	0x59, 0x95, 0x05, 0xa8, 0x8d, 0xb0, 0x15, 0x64, 0x3c, 0x3e, 0x98, 0x49, 0x2c, 0xd7, 0xb4, 0x63,
	0xba, 0x95, 0xf5, 0x8f, 0x02, 0xdc, 0x4d, 0x45, 0xe5, 0xe3, 0xd0, 0xf5, 0xc2, 0xba, 0xba, 0x1c,
	0x74, 0x47, 0xb6, 0xff, 0x23, 0x47, 0x96, 0x1a, 0x8c, 0x1d, 0xe5, 0x2a, 0xae, 0x16, 0x5d, 0xc1,
	0xbd, 0x06, 0x94, 0x8a, 0xad, 0x3b, 0x9c, 0x83, 0xfc, 0x57, 0x3c, 0x9e, 0x88, 0xbb, 0xb0, 0x7f,
	0x2d, 0xc0, 0x6c, 0x8a, 0xcb, 0x08, 0xa6, 0x4e, 0xc3, 0x6e, 0x52, 0xe2, 0x7a, 0x8e, 0x5c, 0x01,
	0x9c, 0xa2, 0xc3, 0x1f, 0xb9, 0xb7, 0xd3, 0x89, 0xe1, 0xa1, 0xf4, 0xdb, 0x8b, 0xed, 0xc4, 0xb5,
	0x60, 0x15, 0x46, 0xea, 0x01, 0xf6, 0x7c, 0xfb, 0x24, 0xa2, 0x67, 0x98, 0xba, 0x0c, 0xbd, 0xce,
	0xef, 0xde, 0x35, 0x29, 0xd9, 0xd4, 0x0a, 0xb1, 0xf7, 0x2b, 0x06, 0xc3, 0x6d, 0xc2, 0x50, 0xd5,
	0x60, 0xef, 0x97, 0xed, 0x0f, 0x45, 0x73, 0x6b, 0x1f, 0xc6, 0xb5, 0x9a, 0x38, 0x51, 0xe8, 0x62,
	0x7a, 0x6e, 0xeb, 0x9b, 0xc6, 0x9b, 0x7c, 0xd0, 0x98, 0x02, 0xc5, 0xca, 0x35, 0x75, 0xef, 0xd8,
	0x84, 0xeb, 0xa9, 0x13, 0x2c, 0x25, 0xd8, 0x69, 0xa0, 0x3b, 0xf9, 0xb0, 0xd1, 0x44, 0x74, 0x20,
	0x34, 0x62, 0x6d, 0xa7, 0x8b, 0x5c, 0x77, 0x0d, 0xd6, 0x76, 0xaa, 0xbd, 0xb8, 0xa6, 0xa6, 0xab,
	0xbd, 0x32, 0xc5, 0xdc, 0x33, 0xb9, 0xa6, 0xa6, 0x54, 0x32, 0xc7, 0x7c, 0x01, 0xc3, 0xe9, 0xfd,
	0x03, 0xdd, 0xcf, 0x0f, 0xa4, 0x4b, 0x60, 0xfd, 0xa9, 0x00, 0x13, 0xd9, 0x85, 0x67, 0x86, 0xdc,
	0xb9, 0xab, 0x0b, 0x23, 0xcb, 0x3b, 0x39, 0xf3, 0x2d, 0xb5, 0x7d, 0x6c, 0x08, 0xf1, 0xd1, 0x79,
	0x93, 0xc8, 0x19, 0x97, 0xf5, 0x1f, 0x07, 0x37, 0xbd, 0x8c, 0xa7, 0xcc, 0xda, 0x06, 0xcb, 0x0b,
	0xdb, 0xd8, 0xf7, 0x5c, 0xf5, 0x8a, 0xd5, 0x90, 0x2c, 0x98, 0x9c, 0xcb, 0xb5, 0x4e, 0xbe, 0x60,
	0x39, 0x26, 0xab, 0x30, 0xd2, 0xc5, 0x62, 0xe8, 0x17, 0x06, 0x13, 0x37, 0x8d, 0x61, 0xd6, 0x2b,
	0x18, 0xd3, 0x25, 0x6d, 0x3b, 0x94, 0x15, 0x47, 0xe6, 0xf1, 0x88, 0x32, 0xf4, 0xc0, 0x20, 0x22,
	0x4b, 0x2b, 0x5f, 0x91, 0xb3, 0xaa, 0xd6, 0x89, 0x85, 0xd0, 0x6c, 0x44, 0x21, 0xb1, 0x1d, 0xec,
	0xfb, 0x0c, 0xfd, 0xd2, 0x60, 0x21, 0xc8, 0xf6, 0x6b, 0xa2, 0xb9, 0xf5, 0x12, 0x3e, 0x52, 0xea,
	0xf4, 0x9c, 0x7b, 0x98, 0xcf, 0xb8, 0x2e, 0x55, 0xe9, 0x4a, 0xea, 0x36, 0x58, 0x8a, 0xc4, 0x1b,
	0x34, 0x6a, 0xd5, 0x1b, 0x6a, 0x9c, 0x1f, 0x99, 0x8c, 0xb3, 0xd4, 0x1d, 0x29, 0x59, 0x3c, 0xf7,
	0x28, 0xf1, 0xd5, 0x86, 0x21, 0xd2, 0x53, 0xd1, 0xe4, 0x66, 0x10, 0x2b, 0x44, 0x86, 0xf1, 0xe1,
	0x8e, 0xce, 0x73, 0x83, 0xbe, 0x56, 0x50, 0x57, 0xcc, 0x57, 0x26, 0x45, 0x00, 0x45, 0xaa, 0x64,
	0x7d, 0xaf, 0xa0, 0x2e, 0x99, 0x7f, 0x2c, 0xc0, 0xa2, 0xb6, 0x4b, 0x97, 0x1c, 0x2e, 0xb6, 0x7e,
	0x6b, 0x60, 0xfd, 0x40, 0x51, 0x93, 0xf2, 0xc3, 0x05, 0x41, 0x7c, 0x07, 0x3f, 0xcf, 0x88, 0xa1,
	0xcf, 0xb6, 0x64, 0x72, 0xd5, 0xed, 0xb5, 0xed, 0xf5, 0x7a, 0x07, 0xf7, 0x33, 0xbc, 0x32, 0xbb,
	0xf9, 0x95, 0x49, 0x81, 0xbb, 0xd7, 0x2f, 0xa3, 0x7b, 0xdb, 0x60, 0x69, 0x4b, 0xb5, 0x8a, 0x15,
	0x7d, 0xd1, 0x64, 0x7a, 0x29, 0x9d, 0x5c, 0x7e, 0xbd, 0x43, 0x45, 0xde, 0x63, 0x87, 0xdb, 0x01,
	0xe6, 0x4e, 0xa3, 0x3f, 0xf4, 0x25, 0xf3, 0xa1, 0xda, 0x10, 0x9c, 0x5d, 0x81, 0xe9, 0x8d, 0xfb,
	0x08, 0x26, 0xb4, 0x57, 0x1f, 0x7f, 0xd9, 0xe4, 0x92, 0xa9, 0xc4, 0xbd, 0xd4, 0x3f, 0x40, 0x51,
	0x53, 0x93, 0xfa, 0xc9, 0xc5, 0xd3, 0xed, 0x6b, 0x03, 0xb3, 0x05, 0xc5, 0x8c, 0x6b, 0x29, 0x17,
	0x4c, 0xb6, 0x13, 0xb8, 0xdd, 0xe7, 0xdf, 0x67, 0xf9, 0xd8, 0xc0, 0xf2, 0xe3, 0x6e, 0xcb, 0x5e,
	0x9f, 0x00, 0xee, 0xf6, 0xf9, 0x64, 0x76, 0xef, 0x1b, 0xf3, 0x85, 0x1c, 0x7b, 0x65, 0x74, 0xeb,
	0x1b, 0xb8, 0xa5, 0xed, 0x32, 0x4d, 0x8e, 0x0d, 0x4c, 0x90, 0x02, 0x64, 0xc0, 0xdf, 0xc2, 0xe4,
	0xe0, 0xaf, 0x36, 0x7f, 0x63, 0x52, 0xd3, 0xe1, 0x03, 0xbe, 0xd2, 0x7c, 0x03, 0x93, 0xc9, 0xd5,
	0xa5, 0xb7, 0x94, 0xf1, 0x89, 0xc9, 0x45, 0xbd, 0xad, 0x2f, 0x29, 0x3d, 0xb5, 0x8c, 0x57, 0x30,
	0x96, 0xbe, 0x13, 0x75, 0xaa, 0x0c, 0x2b, 0x26, 0x7b, 0x55, 0xbb, 0x73, 0xf1, 0xe9, 0x14, 0x14,
	0x7e, 0x0f, 0x8f, 0x52, 0x3c, 0x83, 0x72, 0xc6, 0x6f, 0x4d, 0x66, 0x6d, 0xc7, 0x28, 0xaf, 0x9e,
	0x71, 0x08, 0x13, 0x6d, 0xcf, 0x25, 0x91, 0x38, 0x5b, 0x53, 0xee, 0xf9, 0xc4, 0x5e, 0x5a, 0x5c,
	0x54, 0xfb, 0xd4, 0xa7, 0x06, 0x46, 0x63, 0x52, 0xbc, 0xaf, 0xb5, 0x4b, 0x8b, 0x8b, 0x72, 0xaf,
	0xda, 0x87, 0xf1, 0x1e, 0xe8, 0xf2, 0x8a, 0x62, 0x3e, 0x31, 0xf9, 0xea, 0xad, 0x8b, 0xb9, 0xbc,
	0x32, 0x00, 0xb9, 0xa2, 0xc3, 0xfc, 0xec, 0xd2, 0xc8, 0x95, 0x41, 0x51, 0x3e, 0xd1, 0x51, 0xfe,
	0xea, 0xd2, 0xc8, 0x27, 0x2a, 0xca, 0x75, 0x18, 0x55, 0x48, 0xf9, 0xcd, 0xa9, 0x64, 0x95, 0x4d,
	0xbe, 0x02, 0x97, 0xa2, 0xaa, 0x47, 0xce, 0x24, 0xe5, 0x19, 0x0c, 0x25, 0x14, 0x86, 0x9e, 0x1a,
	0x1c, 0x5f, 0x3a, 0x00, 0x59, 0xc3, 0x93, 0xee, 0xf1, 0x99, 0x23, 0x3d, 0xf1, 0x9f, 0x19, 0x5c,
	0x99, 0x84, 0x58, 0x1f, 0x3c, 0x52, 0xf3, 0x7e, 0xf5, 0xbf, 0x05, 0x98, 0x77, 0xa2, 0xa0, 0x78,
	0xf1, 0xaf, 0x2e, 0x56, 0x87, 0xf5, 0xcf, 0x17, 0xf6, 0x04, 0x7a, 0xaf, 0xf0, 0xf5, 0xba, 0x6e,
	0x5f, 0x8f, 0x7c, 0x1c, 0xd6, 0x8b, 0x11, 0xad, 0x97, 0xea, 0x24, 0x94, 0xc6, 0xf1, 0x2f, 0x2b,
	0x9a, 0x1e, 0x1b, 0xf4, 0x93, 0x8f, 0xa7, 0xea, 0xaf, 0x7f, 0x5e, 0xb9, 0xfa, 0xa2, 0x52, 0xf9,
	0xd7, 0x95, 0x99, 0x17, 0x0a, 0x56, 0x71, 0x59, 0x51, 0x7d, 0x14, 0x9f, 0xaa, 0x4b, 0xc5, 0x35,
	0xd9, 0xec, 0x3f, 0x71, 0x83, 0xe3, 0x8a, 0xcb, 0x8e, 0x3b, 0x0d, 0x8e, 0xab, 0x4b, 0xc7, 0xaa,
	0xc1, 0xff, 0xae, 0xcc, 0xab, 0xa7, 0xe5, 0x72, 0xc5, 0x65, 0xe5, 0x72, 0xa7, 0x49, 0xb9, 0x5c,
	0x5d, 0x2a, 0x97, 0x55, 0xa3, 0xda, 0x07, 0x32, 0xba, 0xc7, 0xff, 0x0f, 0x00, 0x00, 0xff, 0xff,
	0x17, 0x3c, 0x42, 0xe1, 0x8f, 0x22, 0x00, 0x00,
}
