package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/sql/mgmt/2017-03-01-preview/sql"

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// ADPassword ...
	ADPassword AuthenticationType = "ADPassword"
	// SQL ...
	SQL AuthenticationType = "SQL"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{ADPassword, SQL}
}

// AutomaticTuningDisabledReason enumerates the values for automatic tuning disabled reason.
type AutomaticTuningDisabledReason string

const (
	// AutoConfigured ...
	AutoConfigured AutomaticTuningDisabledReason = "AutoConfigured"
	// Default ...
	Default AutomaticTuningDisabledReason = "Default"
	// Disabled ...
	Disabled AutomaticTuningDisabledReason = "Disabled"
	// InheritedFromServer ...
	InheritedFromServer AutomaticTuningDisabledReason = "InheritedFromServer"
	// NotSupported ...
	NotSupported AutomaticTuningDisabledReason = "NotSupported"
	// QueryStoreOff ...
	QueryStoreOff AutomaticTuningDisabledReason = "QueryStoreOff"
	// QueryStoreReadOnly ...
	QueryStoreReadOnly AutomaticTuningDisabledReason = "QueryStoreReadOnly"
)

// PossibleAutomaticTuningDisabledReasonValues returns an array of possible values for the AutomaticTuningDisabledReason const type.
func PossibleAutomaticTuningDisabledReasonValues() []AutomaticTuningDisabledReason {
	return []AutomaticTuningDisabledReason{AutoConfigured, Default, Disabled, InheritedFromServer, NotSupported, QueryStoreOff, QueryStoreReadOnly}
}

// AutomaticTuningMode enumerates the values for automatic tuning mode.
type AutomaticTuningMode string

const (
	// Auto ...
	Auto AutomaticTuningMode = "Auto"
	// Custom ...
	Custom AutomaticTuningMode = "Custom"
	// Inherit ...
	Inherit AutomaticTuningMode = "Inherit"
	// Unspecified ...
	Unspecified AutomaticTuningMode = "Unspecified"
)

// PossibleAutomaticTuningModeValues returns an array of possible values for the AutomaticTuningMode const type.
func PossibleAutomaticTuningModeValues() []AutomaticTuningMode {
	return []AutomaticTuningMode{Auto, Custom, Inherit, Unspecified}
}

// AutomaticTuningOptionModeActual enumerates the values for automatic tuning option mode actual.
type AutomaticTuningOptionModeActual string

const (
	// Off ...
	Off AutomaticTuningOptionModeActual = "Off"
	// On ...
	On AutomaticTuningOptionModeActual = "On"
)

// PossibleAutomaticTuningOptionModeActualValues returns an array of possible values for the AutomaticTuningOptionModeActual const type.
func PossibleAutomaticTuningOptionModeActualValues() []AutomaticTuningOptionModeActual {
	return []AutomaticTuningOptionModeActual{Off, On}
}

// AutomaticTuningOptionModeDesired enumerates the values for automatic tuning option mode desired.
type AutomaticTuningOptionModeDesired string

const (
	// AutomaticTuningOptionModeDesiredDefault ...
	AutomaticTuningOptionModeDesiredDefault AutomaticTuningOptionModeDesired = "Default"
	// AutomaticTuningOptionModeDesiredOff ...
	AutomaticTuningOptionModeDesiredOff AutomaticTuningOptionModeDesired = "Off"
	// AutomaticTuningOptionModeDesiredOn ...
	AutomaticTuningOptionModeDesiredOn AutomaticTuningOptionModeDesired = "On"
)

// PossibleAutomaticTuningOptionModeDesiredValues returns an array of possible values for the AutomaticTuningOptionModeDesired const type.
func PossibleAutomaticTuningOptionModeDesiredValues() []AutomaticTuningOptionModeDesired {
	return []AutomaticTuningOptionModeDesired{AutomaticTuningOptionModeDesiredDefault, AutomaticTuningOptionModeDesiredOff, AutomaticTuningOptionModeDesiredOn}
}

// AutomaticTuningServerMode enumerates the values for automatic tuning server mode.
type AutomaticTuningServerMode string

const (
	// AutomaticTuningServerModeAuto ...
	AutomaticTuningServerModeAuto AutomaticTuningServerMode = "Auto"
	// AutomaticTuningServerModeCustom ...
	AutomaticTuningServerModeCustom AutomaticTuningServerMode = "Custom"
	// AutomaticTuningServerModeUnspecified ...
	AutomaticTuningServerModeUnspecified AutomaticTuningServerMode = "Unspecified"
)

// PossibleAutomaticTuningServerModeValues returns an array of possible values for the AutomaticTuningServerMode const type.
func PossibleAutomaticTuningServerModeValues() []AutomaticTuningServerMode {
	return []AutomaticTuningServerMode{AutomaticTuningServerModeAuto, AutomaticTuningServerModeCustom, AutomaticTuningServerModeUnspecified}
}

// AutomaticTuningServerReason enumerates the values for automatic tuning server reason.
type AutomaticTuningServerReason string

const (
	// AutomaticTuningServerReasonAutoConfigured ...
	AutomaticTuningServerReasonAutoConfigured AutomaticTuningServerReason = "AutoConfigured"
	// AutomaticTuningServerReasonDefault ...
	AutomaticTuningServerReasonDefault AutomaticTuningServerReason = "Default"
	// AutomaticTuningServerReasonDisabled ...
	AutomaticTuningServerReasonDisabled AutomaticTuningServerReason = "Disabled"
)

// PossibleAutomaticTuningServerReasonValues returns an array of possible values for the AutomaticTuningServerReason const type.
func PossibleAutomaticTuningServerReasonValues() []AutomaticTuningServerReason {
	return []AutomaticTuningServerReason{AutomaticTuningServerReasonAutoConfigured, AutomaticTuningServerReasonDefault, AutomaticTuningServerReasonDisabled}
}

// BackupLongTermRetentionPolicyState enumerates the values for backup long term retention policy state.
type BackupLongTermRetentionPolicyState string

const (
	// BackupLongTermRetentionPolicyStateDisabled ...
	BackupLongTermRetentionPolicyStateDisabled BackupLongTermRetentionPolicyState = "Disabled"
	// BackupLongTermRetentionPolicyStateEnabled ...
	BackupLongTermRetentionPolicyStateEnabled BackupLongTermRetentionPolicyState = "Enabled"
)

// PossibleBackupLongTermRetentionPolicyStateValues returns an array of possible values for the BackupLongTermRetentionPolicyState const type.
func PossibleBackupLongTermRetentionPolicyStateValues() []BackupLongTermRetentionPolicyState {
	return []BackupLongTermRetentionPolicyState{BackupLongTermRetentionPolicyStateDisabled, BackupLongTermRetentionPolicyStateEnabled}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable ...
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault ...
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled ...
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible ...
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns an array of possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{CapabilityStatusAvailable, CapabilityStatusDefault, CapabilityStatusDisabled, CapabilityStatusVisible}
}

// CatalogCollationType enumerates the values for catalog collation type.
type CatalogCollationType string

const (
	// DATABASEDEFAULT ...
	DATABASEDEFAULT CatalogCollationType = "DATABASE_DEFAULT"
	// SQLLatin1GeneralCP1CIAS ...
	SQLLatin1GeneralCP1CIAS CatalogCollationType = "SQL_Latin1_General_CP1_CI_AS"
)

// PossibleCatalogCollationTypeValues returns an array of possible values for the CatalogCollationType const type.
func PossibleCatalogCollationTypeValues() []CatalogCollationType {
	return []CatalogCollationType{DATABASEDEFAULT, SQLLatin1GeneralCP1CIAS}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// AlreadyExists ...
	AlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// Invalid ...
	Invalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{AlreadyExists, Invalid}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeCopy ...
	CreateModeCopy CreateMode = "Copy"
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeNonReadableSecondary ...
	CreateModeNonReadableSecondary CreateMode = "NonReadableSecondary"
	// CreateModeOnlineSecondary ...
	CreateModeOnlineSecondary CreateMode = "OnlineSecondary"
	// CreateModePointInTimeRestore ...
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	// CreateModeRecovery ...
	CreateModeRecovery CreateMode = "Recovery"
	// CreateModeRestore ...
	CreateModeRestore CreateMode = "Restore"
	// CreateModeRestoreLongTermRetentionBackup ...
	CreateModeRestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeCopy, CreateModeDefault, CreateModeNonReadableSecondary, CreateModeOnlineSecondary, CreateModePointInTimeRestore, CreateModeRecovery, CreateModeRestore, CreateModeRestoreLongTermRetentionBackup}
}

// DatabaseEdition enumerates the values for database edition.
type DatabaseEdition string

const (
	// Basic ...
	Basic DatabaseEdition = "Basic"
	// Business ...
	Business DatabaseEdition = "Business"
	// DataWarehouse ...
	DataWarehouse DatabaseEdition = "DataWarehouse"
	// Free ...
	Free DatabaseEdition = "Free"
	// Premium ...
	Premium DatabaseEdition = "Premium"
	// PremiumRS ...
	PremiumRS DatabaseEdition = "PremiumRS"
	// Standard ...
	Standard DatabaseEdition = "Standard"
	// Stretch ...
	Stretch DatabaseEdition = "Stretch"
	// System ...
	System DatabaseEdition = "System"
	// System2 ...
	System2 DatabaseEdition = "System2"
	// Web ...
	Web DatabaseEdition = "Web"
)

// PossibleDatabaseEditionValues returns an array of possible values for the DatabaseEdition const type.
func PossibleDatabaseEditionValues() []DatabaseEdition {
	return []DatabaseEdition{Basic, Business, DataWarehouse, Free, Premium, PremiumRS, Standard, Stretch, System, System2, Web}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// ElasticPoolEdition enumerates the values for elastic pool edition.
type ElasticPoolEdition string

const (
	// ElasticPoolEditionBasic ...
	ElasticPoolEditionBasic ElasticPoolEdition = "Basic"
	// ElasticPoolEditionPremium ...
	ElasticPoolEditionPremium ElasticPoolEdition = "Premium"
	// ElasticPoolEditionStandard ...
	ElasticPoolEditionStandard ElasticPoolEdition = "Standard"
)

// PossibleElasticPoolEditionValues returns an array of possible values for the ElasticPoolEdition const type.
func PossibleElasticPoolEditionValues() []ElasticPoolEdition {
	return []ElasticPoolEdition{ElasticPoolEditionBasic, ElasticPoolEditionPremium, ElasticPoolEditionStandard}
}

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating ...
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled ...
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady ...
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns an array of possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{ElasticPoolStateCreating, ElasticPoolStateDisabled, ElasticPoolStateReady}
}

// FailoverGroupReplicationRole enumerates the values for failover group replication role.
type FailoverGroupReplicationRole string

const (
	// Primary ...
	Primary FailoverGroupReplicationRole = "Primary"
	// Secondary ...
	Secondary FailoverGroupReplicationRole = "Secondary"
)

// PossibleFailoverGroupReplicationRoleValues returns an array of possible values for the FailoverGroupReplicationRole const type.
func PossibleFailoverGroupReplicationRoleValues() []FailoverGroupReplicationRole {
	return []FailoverGroupReplicationRole{Primary, Secondary}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// SystemAssigned ...
	SystemAssigned IdentityType = "SystemAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{SystemAssigned}
}

// JobAgentState enumerates the values for job agent state.
type JobAgentState string

const (
	// JobAgentStateCreating ...
	JobAgentStateCreating JobAgentState = "Creating"
	// JobAgentStateDeleting ...
	JobAgentStateDeleting JobAgentState = "Deleting"
	// JobAgentStateDisabled ...
	JobAgentStateDisabled JobAgentState = "Disabled"
	// JobAgentStateReady ...
	JobAgentStateReady JobAgentState = "Ready"
	// JobAgentStateUpdating ...
	JobAgentStateUpdating JobAgentState = "Updating"
)

// PossibleJobAgentStateValues returns an array of possible values for the JobAgentState const type.
func PossibleJobAgentStateValues() []JobAgentState {
	return []JobAgentState{JobAgentStateCreating, JobAgentStateDeleting, JobAgentStateDisabled, JobAgentStateReady, JobAgentStateUpdating}
}

// JobExecutionLifecycle enumerates the values for job execution lifecycle.
type JobExecutionLifecycle string

const (
	// Canceled ...
	Canceled JobExecutionLifecycle = "Canceled"
	// Created ...
	Created JobExecutionLifecycle = "Created"
	// Failed ...
	Failed JobExecutionLifecycle = "Failed"
	// InProgress ...
	InProgress JobExecutionLifecycle = "InProgress"
	// Skipped ...
	Skipped JobExecutionLifecycle = "Skipped"
	// Succeeded ...
	Succeeded JobExecutionLifecycle = "Succeeded"
	// SucceededWithSkipped ...
	SucceededWithSkipped JobExecutionLifecycle = "SucceededWithSkipped"
	// TimedOut ...
	TimedOut JobExecutionLifecycle = "TimedOut"
	// WaitingForChildJobExecutions ...
	WaitingForChildJobExecutions JobExecutionLifecycle = "WaitingForChildJobExecutions"
	// WaitingForRetry ...
	WaitingForRetry JobExecutionLifecycle = "WaitingForRetry"
)

// PossibleJobExecutionLifecycleValues returns an array of possible values for the JobExecutionLifecycle const type.
func PossibleJobExecutionLifecycleValues() []JobExecutionLifecycle {
	return []JobExecutionLifecycle{Canceled, Created, Failed, InProgress, Skipped, Succeeded, SucceededWithSkipped, TimedOut, WaitingForChildJobExecutions, WaitingForRetry}
}

// JobScheduleType enumerates the values for job schedule type.
type JobScheduleType string

const (
	// Once ...
	Once JobScheduleType = "Once"
	// Recurring ...
	Recurring JobScheduleType = "Recurring"
)

// PossibleJobScheduleTypeValues returns an array of possible values for the JobScheduleType const type.
func PossibleJobScheduleTypeValues() []JobScheduleType {
	return []JobScheduleType{Once, Recurring}
}

// JobStepActionSource enumerates the values for job step action source.
type JobStepActionSource string

const (
	// Inline ...
	Inline JobStepActionSource = "Inline"
)

// PossibleJobStepActionSourceValues returns an array of possible values for the JobStepActionSource const type.
func PossibleJobStepActionSourceValues() []JobStepActionSource {
	return []JobStepActionSource{Inline}
}

// JobStepActionType enumerates the values for job step action type.
type JobStepActionType string

const (
	// TSQL ...
	TSQL JobStepActionType = "TSql"
)

// PossibleJobStepActionTypeValues returns an array of possible values for the JobStepActionType const type.
func PossibleJobStepActionTypeValues() []JobStepActionType {
	return []JobStepActionType{TSQL}
}

// JobStepOutputType enumerates the values for job step output type.
type JobStepOutputType string

const (
	// SQLDatabase ...
	SQLDatabase JobStepOutputType = "SqlDatabase"
)

// PossibleJobStepOutputTypeValues returns an array of possible values for the JobStepOutputType const type.
func PossibleJobStepOutputTypeValues() []JobStepOutputType {
	return []JobStepOutputType{SQLDatabase}
}

// JobTargetGroupMembershipType enumerates the values for job target group membership type.
type JobTargetGroupMembershipType string

const (
	// Exclude ...
	Exclude JobTargetGroupMembershipType = "Exclude"
	// Include ...
	Include JobTargetGroupMembershipType = "Include"
)

// PossibleJobTargetGroupMembershipTypeValues returns an array of possible values for the JobTargetGroupMembershipType const type.
func PossibleJobTargetGroupMembershipTypeValues() []JobTargetGroupMembershipType {
	return []JobTargetGroupMembershipType{Exclude, Include}
}

// JobTargetType enumerates the values for job target type.
type JobTargetType string

const (
	// JobTargetTypeSQLDatabase ...
	JobTargetTypeSQLDatabase JobTargetType = "SqlDatabase"
	// JobTargetTypeSQLElasticPool ...
	JobTargetTypeSQLElasticPool JobTargetType = "SqlElasticPool"
	// JobTargetTypeSQLServer ...
	JobTargetTypeSQLServer JobTargetType = "SqlServer"
	// JobTargetTypeSQLShardMap ...
	JobTargetTypeSQLShardMap JobTargetType = "SqlShardMap"
	// JobTargetTypeTargetGroup ...
	JobTargetTypeTargetGroup JobTargetType = "TargetGroup"
)

// PossibleJobTargetTypeValues returns an array of possible values for the JobTargetType const type.
func PossibleJobTargetTypeValues() []JobTargetType {
	return []JobTargetType{JobTargetTypeSQLDatabase, JobTargetTypeSQLElasticPool, JobTargetTypeSQLServer, JobTargetTypeSQLShardMap, JobTargetTypeTargetGroup}
}

// ManagedDatabaseCreateMode enumerates the values for managed database create mode.
type ManagedDatabaseCreateMode string

const (
	// ManagedDatabaseCreateModeDefault ...
	ManagedDatabaseCreateModeDefault ManagedDatabaseCreateMode = "Default"
	// ManagedDatabaseCreateModePointInTimeRestore ...
	ManagedDatabaseCreateModePointInTimeRestore ManagedDatabaseCreateMode = "PointInTimeRestore"
	// ManagedDatabaseCreateModeRecovery ...
	ManagedDatabaseCreateModeRecovery ManagedDatabaseCreateMode = "Recovery"
	// ManagedDatabaseCreateModeRestoreExternalBackup ...
	ManagedDatabaseCreateModeRestoreExternalBackup ManagedDatabaseCreateMode = "RestoreExternalBackup"
)

// PossibleManagedDatabaseCreateModeValues returns an array of possible values for the ManagedDatabaseCreateMode const type.
func PossibleManagedDatabaseCreateModeValues() []ManagedDatabaseCreateMode {
	return []ManagedDatabaseCreateMode{ManagedDatabaseCreateModeDefault, ManagedDatabaseCreateModePointInTimeRestore, ManagedDatabaseCreateModeRecovery, ManagedDatabaseCreateModeRestoreExternalBackup}
}

// ManagedDatabaseStatus enumerates the values for managed database status.
type ManagedDatabaseStatus string

const (
	// Creating ...
	Creating ManagedDatabaseStatus = "Creating"
	// Inaccessible ...
	Inaccessible ManagedDatabaseStatus = "Inaccessible"
	// Offline ...
	Offline ManagedDatabaseStatus = "Offline"
	// Online ...
	Online ManagedDatabaseStatus = "Online"
	// Shutdown ...
	Shutdown ManagedDatabaseStatus = "Shutdown"
	// Updating ...
	Updating ManagedDatabaseStatus = "Updating"
)

// PossibleManagedDatabaseStatusValues returns an array of possible values for the ManagedDatabaseStatus const type.
func PossibleManagedDatabaseStatusValues() []ManagedDatabaseStatus {
	return []ManagedDatabaseStatus{Creating, Inaccessible, Offline, Online, Shutdown, Updating}
}

// ManagedInstanceProxyOverride enumerates the values for managed instance proxy override.
type ManagedInstanceProxyOverride string

const (
	// ManagedInstanceProxyOverrideDefault ...
	ManagedInstanceProxyOverrideDefault ManagedInstanceProxyOverride = "Default"
	// ManagedInstanceProxyOverrideProxy ...
	ManagedInstanceProxyOverrideProxy ManagedInstanceProxyOverride = "Proxy"
	// ManagedInstanceProxyOverrideRedirect ...
	ManagedInstanceProxyOverrideRedirect ManagedInstanceProxyOverride = "Redirect"
)

// PossibleManagedInstanceProxyOverrideValues returns an array of possible values for the ManagedInstanceProxyOverride const type.
func PossibleManagedInstanceProxyOverrideValues() []ManagedInstanceProxyOverride {
	return []ManagedInstanceProxyOverride{ManagedInstanceProxyOverrideDefault, ManagedInstanceProxyOverrideProxy, ManagedInstanceProxyOverrideRedirect}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// ManagementOperationStateCancelInProgress ...
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	// ManagementOperationStateCancelled ...
	ManagementOperationStateCancelled ManagementOperationState = "Cancelled"
	// ManagementOperationStateFailed ...
	ManagementOperationStateFailed ManagementOperationState = "Failed"
	// ManagementOperationStateInProgress ...
	ManagementOperationStateInProgress ManagementOperationState = "InProgress"
	// ManagementOperationStatePending ...
	ManagementOperationStatePending ManagementOperationState = "Pending"
	// ManagementOperationStateSucceeded ...
	ManagementOperationStateSucceeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{ManagementOperationStateCancelInProgress, ManagementOperationStateCancelled, ManagementOperationStateFailed, ManagementOperationStateInProgress, ManagementOperationStatePending, ManagementOperationStateSucceeded}
}

// MaxSizeUnits enumerates the values for max size units.
type MaxSizeUnits string

const (
	// Gigabytes ...
	Gigabytes MaxSizeUnits = "Gigabytes"
	// Megabytes ...
	Megabytes MaxSizeUnits = "Megabytes"
	// Petabytes ...
	Petabytes MaxSizeUnits = "Petabytes"
	// Terabytes ...
	Terabytes MaxSizeUnits = "Terabytes"
)

// PossibleMaxSizeUnitsValues returns an array of possible values for the MaxSizeUnits const type.
func PossibleMaxSizeUnitsValues() []MaxSizeUnits {
	return []MaxSizeUnits{Gigabytes, Megabytes, Petabytes, Terabytes}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser}
}

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// DTU ...
	DTU PerformanceLevelUnit = "DTU"
)

// PossiblePerformanceLevelUnitValues returns an array of possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{DTU}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// Average ...
	Average PrimaryAggregationType = "Average"
	// Count ...
	Count PrimaryAggregationType = "Count"
	// Maximum ...
	Maximum PrimaryAggregationType = "Maximum"
	// Minimum ...
	Minimum PrimaryAggregationType = "Minimum"
	// None ...
	None PrimaryAggregationType = "None"
	// Total ...
	Total PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{Average, Count, Maximum, Minimum, None, Total}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// ReadOnlyEndpointFailoverPolicy enumerates the values for read only endpoint failover policy.
type ReadOnlyEndpointFailoverPolicy string

const (
	// ReadOnlyEndpointFailoverPolicyDisabled ...
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	// ReadOnlyEndpointFailoverPolicyEnabled ...
	ReadOnlyEndpointFailoverPolicyEnabled ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// PossibleReadOnlyEndpointFailoverPolicyValues returns an array of possible values for the ReadOnlyEndpointFailoverPolicy const type.
func PossibleReadOnlyEndpointFailoverPolicyValues() []ReadOnlyEndpointFailoverPolicy {
	return []ReadOnlyEndpointFailoverPolicy{ReadOnlyEndpointFailoverPolicyDisabled, ReadOnlyEndpointFailoverPolicyEnabled}
}

// ReadScale enumerates the values for read scale.
type ReadScale string

const (
	// ReadScaleDisabled ...
	ReadScaleDisabled ReadScale = "Disabled"
	// ReadScaleEnabled ...
	ReadScaleEnabled ReadScale = "Enabled"
)

// PossibleReadScaleValues returns an array of possible values for the ReadScale const type.
func PossibleReadScaleValues() []ReadScale {
	return []ReadScale{ReadScaleDisabled, ReadScaleEnabled}
}

// ReadWriteEndpointFailoverPolicy enumerates the values for read write endpoint failover policy.
type ReadWriteEndpointFailoverPolicy string

const (
	// Automatic ...
	Automatic ReadWriteEndpointFailoverPolicy = "Automatic"
	// Manual ...
	Manual ReadWriteEndpointFailoverPolicy = "Manual"
)

// PossibleReadWriteEndpointFailoverPolicyValues returns an array of possible values for the ReadWriteEndpointFailoverPolicy const type.
func PossibleReadWriteEndpointFailoverPolicyValues() []ReadWriteEndpointFailoverPolicy {
	return []ReadWriteEndpointFailoverPolicy{Automatic, Manual}
}

// RecommendedIndexAction enumerates the values for recommended index action.
type RecommendedIndexAction string

const (
	// Create ...
	Create RecommendedIndexAction = "Create"
	// Drop ...
	Drop RecommendedIndexAction = "Drop"
	// Rebuild ...
	Rebuild RecommendedIndexAction = "Rebuild"
)

// PossibleRecommendedIndexActionValues returns an array of possible values for the RecommendedIndexAction const type.
func PossibleRecommendedIndexActionValues() []RecommendedIndexAction {
	return []RecommendedIndexAction{Create, Drop, Rebuild}
}

// RecommendedIndexState enumerates the values for recommended index state.
type RecommendedIndexState string

const (
	// Active ...
	Active RecommendedIndexState = "Active"
	// Blocked ...
	Blocked RecommendedIndexState = "Blocked"
	// Executing ...
	Executing RecommendedIndexState = "Executing"
	// Expired ...
	Expired RecommendedIndexState = "Expired"
	// Ignored ...
	Ignored RecommendedIndexState = "Ignored"
	// Pending ...
	Pending RecommendedIndexState = "Pending"
	// PendingRevert ...
	PendingRevert RecommendedIndexState = "Pending Revert"
	// Reverted ...
	Reverted RecommendedIndexState = "Reverted"
	// Reverting ...
	Reverting RecommendedIndexState = "Reverting"
	// Success ...
	Success RecommendedIndexState = "Success"
	// Verifying ...
	Verifying RecommendedIndexState = "Verifying"
)

// PossibleRecommendedIndexStateValues returns an array of possible values for the RecommendedIndexState const type.
func PossibleRecommendedIndexStateValues() []RecommendedIndexState {
	return []RecommendedIndexState{Active, Blocked, Executing, Expired, Ignored, Pending, PendingRevert, Reverted, Reverting, Success, Verifying}
}

// RecommendedIndexType enumerates the values for recommended index type.
type RecommendedIndexType string

const (
	// CLUSTERED ...
	CLUSTERED RecommendedIndexType = "CLUSTERED"
	// CLUSTEREDCOLUMNSTORE ...
	CLUSTEREDCOLUMNSTORE RecommendedIndexType = "CLUSTERED COLUMNSTORE"
	// COLUMNSTORE ...
	COLUMNSTORE RecommendedIndexType = "COLUMNSTORE"
	// NONCLUSTERED ...
	NONCLUSTERED RecommendedIndexType = "NONCLUSTERED"
)

// PossibleRecommendedIndexTypeValues returns an array of possible values for the RecommendedIndexType const type.
func PossibleRecommendedIndexTypeValues() []RecommendedIndexType {
	return []RecommendedIndexType{CLUSTERED, CLUSTEREDCOLUMNSTORE, COLUMNSTORE, NONCLUSTERED}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// CATCHUP ...
	CATCHUP ReplicationState = "CATCH_UP"
	// PENDING ...
	PENDING ReplicationState = "PENDING"
	// SEEDING ...
	SEEDING ReplicationState = "SEEDING"
	// SUSPENDED ...
	SUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{CATCHUP, PENDING, SEEDING, SUSPENDED}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// CONTINUOUS ...
	CONTINUOUS RestorePointType = "CONTINUOUS"
	// DISCRETE ...
	DISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{CONTINUOUS, DISCRETE}
}

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// AdventureWorksLT ...
	AdventureWorksLT SampleName = "AdventureWorksLT"
)

// PossibleSampleNameValues returns an array of possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{AdventureWorksLT}
}

// SecurityAlertPolicyEmailAccountAdmins enumerates the values for security alert policy email account admins.
type SecurityAlertPolicyEmailAccountAdmins string

const (
	// SecurityAlertPolicyEmailAccountAdminsDisabled ...
	SecurityAlertPolicyEmailAccountAdminsDisabled SecurityAlertPolicyEmailAccountAdmins = "Disabled"
	// SecurityAlertPolicyEmailAccountAdminsEnabled ...
	SecurityAlertPolicyEmailAccountAdminsEnabled SecurityAlertPolicyEmailAccountAdmins = "Enabled"
)

// PossibleSecurityAlertPolicyEmailAccountAdminsValues returns an array of possible values for the SecurityAlertPolicyEmailAccountAdmins const type.
func PossibleSecurityAlertPolicyEmailAccountAdminsValues() []SecurityAlertPolicyEmailAccountAdmins {
	return []SecurityAlertPolicyEmailAccountAdmins{SecurityAlertPolicyEmailAccountAdminsDisabled, SecurityAlertPolicyEmailAccountAdminsEnabled}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SecurityAlertPolicyUseServerDefault enumerates the values for security alert policy use server default.
type SecurityAlertPolicyUseServerDefault string

const (
	// SecurityAlertPolicyUseServerDefaultDisabled ...
	SecurityAlertPolicyUseServerDefaultDisabled SecurityAlertPolicyUseServerDefault = "Disabled"
	// SecurityAlertPolicyUseServerDefaultEnabled ...
	SecurityAlertPolicyUseServerDefaultEnabled SecurityAlertPolicyUseServerDefault = "Enabled"
)

// PossibleSecurityAlertPolicyUseServerDefaultValues returns an array of possible values for the SecurityAlertPolicyUseServerDefault const type.
func PossibleSecurityAlertPolicyUseServerDefaultValues() []SecurityAlertPolicyUseServerDefault {
	return []SecurityAlertPolicyUseServerDefault{SecurityAlertPolicyUseServerDefaultDisabled, SecurityAlertPolicyUseServerDefaultEnabled}
}

// SensitivityLabelSource enumerates the values for sensitivity label source.
type SensitivityLabelSource string

const (
	// Current ...
	Current SensitivityLabelSource = "current"
	// Recommended ...
	Recommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns an array of possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{Current, Recommended}
}

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault ...
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy ...
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect ...
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns an array of possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{ServerConnectionTypeDefault, ServerConnectionTypeProxy, ServerConnectionTypeRedirect}
}

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// AzureKeyVault ...
	AzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServiceManaged ...
	ServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns an array of possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{AzureKeyVault, ServiceManaged}
}

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic ...
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameDS100 ...
	ServiceObjectiveNameDS100 ServiceObjectiveName = "DS100"
	// ServiceObjectiveNameDS1000 ...
	ServiceObjectiveNameDS1000 ServiceObjectiveName = "DS1000"
	// ServiceObjectiveNameDS1200 ...
	ServiceObjectiveNameDS1200 ServiceObjectiveName = "DS1200"
	// ServiceObjectiveNameDS1500 ...
	ServiceObjectiveNameDS1500 ServiceObjectiveName = "DS1500"
	// ServiceObjectiveNameDS200 ...
	ServiceObjectiveNameDS200 ServiceObjectiveName = "DS200"
	// ServiceObjectiveNameDS2000 ...
	ServiceObjectiveNameDS2000 ServiceObjectiveName = "DS2000"
	// ServiceObjectiveNameDS300 ...
	ServiceObjectiveNameDS300 ServiceObjectiveName = "DS300"
	// ServiceObjectiveNameDS400 ...
	ServiceObjectiveNameDS400 ServiceObjectiveName = "DS400"
	// ServiceObjectiveNameDS500 ...
	ServiceObjectiveNameDS500 ServiceObjectiveName = "DS500"
	// ServiceObjectiveNameDS600 ...
	ServiceObjectiveNameDS600 ServiceObjectiveName = "DS600"
	// ServiceObjectiveNameDW100 ...
	ServiceObjectiveNameDW100 ServiceObjectiveName = "DW100"
	// ServiceObjectiveNameDW1000 ...
	ServiceObjectiveNameDW1000 ServiceObjectiveName = "DW1000"
	// ServiceObjectiveNameDW10000c ...
	ServiceObjectiveNameDW10000c ServiceObjectiveName = "DW10000c"
	// ServiceObjectiveNameDW1000c ...
	ServiceObjectiveNameDW1000c ServiceObjectiveName = "DW1000c"
	// ServiceObjectiveNameDW1200 ...
	ServiceObjectiveNameDW1200 ServiceObjectiveName = "DW1200"
	// ServiceObjectiveNameDW1500 ...
	ServiceObjectiveNameDW1500 ServiceObjectiveName = "DW1500"
	// ServiceObjectiveNameDW15000c ...
	ServiceObjectiveNameDW15000c ServiceObjectiveName = "DW15000c"
	// ServiceObjectiveNameDW1500c ...
	ServiceObjectiveNameDW1500c ServiceObjectiveName = "DW1500c"
	// ServiceObjectiveNameDW200 ...
	ServiceObjectiveNameDW200 ServiceObjectiveName = "DW200"
	// ServiceObjectiveNameDW2000 ...
	ServiceObjectiveNameDW2000 ServiceObjectiveName = "DW2000"
	// ServiceObjectiveNameDW2000c ...
	ServiceObjectiveNameDW2000c ServiceObjectiveName = "DW2000c"
	// ServiceObjectiveNameDW2500c ...
	ServiceObjectiveNameDW2500c ServiceObjectiveName = "DW2500c"
	// ServiceObjectiveNameDW300 ...
	ServiceObjectiveNameDW300 ServiceObjectiveName = "DW300"
	// ServiceObjectiveNameDW3000 ...
	ServiceObjectiveNameDW3000 ServiceObjectiveName = "DW3000"
	// ServiceObjectiveNameDW30000c ...
	ServiceObjectiveNameDW30000c ServiceObjectiveName = "DW30000c"
	// ServiceObjectiveNameDW3000c ...
	ServiceObjectiveNameDW3000c ServiceObjectiveName = "DW3000c"
	// ServiceObjectiveNameDW400 ...
	ServiceObjectiveNameDW400 ServiceObjectiveName = "DW400"
	// ServiceObjectiveNameDW500 ...
	ServiceObjectiveNameDW500 ServiceObjectiveName = "DW500"
	// ServiceObjectiveNameDW5000c ...
	ServiceObjectiveNameDW5000c ServiceObjectiveName = "DW5000c"
	// ServiceObjectiveNameDW600 ...
	ServiceObjectiveNameDW600 ServiceObjectiveName = "DW600"
	// ServiceObjectiveNameDW6000 ...
	ServiceObjectiveNameDW6000 ServiceObjectiveName = "DW6000"
	// ServiceObjectiveNameDW6000c ...
	ServiceObjectiveNameDW6000c ServiceObjectiveName = "DW6000c"
	// ServiceObjectiveNameDW7500c ...
	ServiceObjectiveNameDW7500c ServiceObjectiveName = "DW7500c"
	// ServiceObjectiveNameElasticPool ...
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameFree ...
	ServiceObjectiveNameFree ServiceObjectiveName = "Free"
	// ServiceObjectiveNameP1 ...
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 ...
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 ...
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 ...
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 ...
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 ...
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 ...
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNamePRS1 ...
	ServiceObjectiveNamePRS1 ServiceObjectiveName = "PRS1"
	// ServiceObjectiveNamePRS2 ...
	ServiceObjectiveNamePRS2 ServiceObjectiveName = "PRS2"
	// ServiceObjectiveNamePRS4 ...
	ServiceObjectiveNamePRS4 ServiceObjectiveName = "PRS4"
	// ServiceObjectiveNamePRS6 ...
	ServiceObjectiveNamePRS6 ServiceObjectiveName = "PRS6"
	// ServiceObjectiveNameS0 ...
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 ...
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS12 ...
	ServiceObjectiveNameS12 ServiceObjectiveName = "S12"
	// ServiceObjectiveNameS2 ...
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 ...
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameS4 ...
	ServiceObjectiveNameS4 ServiceObjectiveName = "S4"
	// ServiceObjectiveNameS6 ...
	ServiceObjectiveNameS6 ServiceObjectiveName = "S6"
	// ServiceObjectiveNameS7 ...
	ServiceObjectiveNameS7 ServiceObjectiveName = "S7"
	// ServiceObjectiveNameS9 ...
	ServiceObjectiveNameS9 ServiceObjectiveName = "S9"
	// ServiceObjectiveNameSystem ...
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem0 ...
	ServiceObjectiveNameSystem0 ServiceObjectiveName = "System0"
	// ServiceObjectiveNameSystem1 ...
	ServiceObjectiveNameSystem1 ServiceObjectiveName = "System1"
	// ServiceObjectiveNameSystem2 ...
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
	// ServiceObjectiveNameSystem2L ...
	ServiceObjectiveNameSystem2L ServiceObjectiveName = "System2L"
	// ServiceObjectiveNameSystem3 ...
	ServiceObjectiveNameSystem3 ServiceObjectiveName = "System3"
	// ServiceObjectiveNameSystem3L ...
	ServiceObjectiveNameSystem3L ServiceObjectiveName = "System3L"
	// ServiceObjectiveNameSystem4 ...
	ServiceObjectiveNameSystem4 ServiceObjectiveName = "System4"
	// ServiceObjectiveNameSystem4L ...
	ServiceObjectiveNameSystem4L ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns an array of possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{ServiceObjectiveNameBasic, ServiceObjectiveNameDS100, ServiceObjectiveNameDS1000, ServiceObjectiveNameDS1200, ServiceObjectiveNameDS1500, ServiceObjectiveNameDS200, ServiceObjectiveNameDS2000, ServiceObjectiveNameDS300, ServiceObjectiveNameDS400, ServiceObjectiveNameDS500, ServiceObjectiveNameDS600, ServiceObjectiveNameDW100, ServiceObjectiveNameDW1000, ServiceObjectiveNameDW10000c, ServiceObjectiveNameDW1000c, ServiceObjectiveNameDW1200, ServiceObjectiveNameDW1500, ServiceObjectiveNameDW15000c, ServiceObjectiveNameDW1500c, ServiceObjectiveNameDW200, ServiceObjectiveNameDW2000, ServiceObjectiveNameDW2000c, ServiceObjectiveNameDW2500c, ServiceObjectiveNameDW300, ServiceObjectiveNameDW3000, ServiceObjectiveNameDW30000c, ServiceObjectiveNameDW3000c, ServiceObjectiveNameDW400, ServiceObjectiveNameDW500, ServiceObjectiveNameDW5000c, ServiceObjectiveNameDW600, ServiceObjectiveNameDW6000, ServiceObjectiveNameDW6000c, ServiceObjectiveNameDW7500c, ServiceObjectiveNameElasticPool, ServiceObjectiveNameFree, ServiceObjectiveNameP1, ServiceObjectiveNameP11, ServiceObjectiveNameP15, ServiceObjectiveNameP2, ServiceObjectiveNameP3, ServiceObjectiveNameP4, ServiceObjectiveNameP6, ServiceObjectiveNamePRS1, ServiceObjectiveNamePRS2, ServiceObjectiveNamePRS4, ServiceObjectiveNamePRS6, ServiceObjectiveNameS0, ServiceObjectiveNameS1, ServiceObjectiveNameS12, ServiceObjectiveNameS2, ServiceObjectiveNameS3, ServiceObjectiveNameS4, ServiceObjectiveNameS6, ServiceObjectiveNameS7, ServiceObjectiveNameS9, ServiceObjectiveNameSystem, ServiceObjectiveNameSystem0, ServiceObjectiveNameSystem1, ServiceObjectiveNameSystem2, ServiceObjectiveNameSystem2L, ServiceObjectiveNameSystem3, ServiceObjectiveNameSystem3L, ServiceObjectiveNameSystem4, ServiceObjectiveNameSystem4L}
}

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// SharedAccessKey ...
	SharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageAccessKey ...
	StorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns an array of possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{SharedAccessKey, StorageAccessKey}
}

// SyncAgentState enumerates the values for sync agent state.
type SyncAgentState string

const (
	// SyncAgentStateNeverConnected ...
	SyncAgentStateNeverConnected SyncAgentState = "NeverConnected"
	// SyncAgentStateOffline ...
	SyncAgentStateOffline SyncAgentState = "Offline"
	// SyncAgentStateOnline ...
	SyncAgentStateOnline SyncAgentState = "Online"
)

// PossibleSyncAgentStateValues returns an array of possible values for the SyncAgentState const type.
func PossibleSyncAgentStateValues() []SyncAgentState {
	return []SyncAgentState{SyncAgentStateNeverConnected, SyncAgentStateOffline, SyncAgentStateOnline}
}

// SyncConflictResolutionPolicy enumerates the values for sync conflict resolution policy.
type SyncConflictResolutionPolicy string

const (
	// HubWin ...
	HubWin SyncConflictResolutionPolicy = "HubWin"
	// MemberWin ...
	MemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// PossibleSyncConflictResolutionPolicyValues returns an array of possible values for the SyncConflictResolutionPolicy const type.
func PossibleSyncConflictResolutionPolicyValues() []SyncConflictResolutionPolicy {
	return []SyncConflictResolutionPolicy{HubWin, MemberWin}
}

// SyncDirection enumerates the values for sync direction.
type SyncDirection string

const (
	// Bidirectional ...
	Bidirectional SyncDirection = "Bidirectional"
	// OneWayHubToMember ...
	OneWayHubToMember SyncDirection = "OneWayHubToMember"
	// OneWayMemberToHub ...
	OneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// PossibleSyncDirectionValues returns an array of possible values for the SyncDirection const type.
func PossibleSyncDirectionValues() []SyncDirection {
	return []SyncDirection{Bidirectional, OneWayHubToMember, OneWayMemberToHub}
}

// SyncGroupLogType enumerates the values for sync group log type.
type SyncGroupLogType string

const (
	// SyncGroupLogTypeAll ...
	SyncGroupLogTypeAll SyncGroupLogType = "All"
	// SyncGroupLogTypeError ...
	SyncGroupLogTypeError SyncGroupLogType = "Error"
	// SyncGroupLogTypeSuccess ...
	SyncGroupLogTypeSuccess SyncGroupLogType = "Success"
	// SyncGroupLogTypeWarning ...
	SyncGroupLogTypeWarning SyncGroupLogType = "Warning"
)

// PossibleSyncGroupLogTypeValues returns an array of possible values for the SyncGroupLogType const type.
func PossibleSyncGroupLogTypeValues() []SyncGroupLogType {
	return []SyncGroupLogType{SyncGroupLogTypeAll, SyncGroupLogTypeError, SyncGroupLogTypeSuccess, SyncGroupLogTypeWarning}
}

// SyncGroupState enumerates the values for sync group state.
type SyncGroupState string

const (
	// Error ...
	Error SyncGroupState = "Error"
	// Good ...
	Good SyncGroupState = "Good"
	// NotReady ...
	NotReady SyncGroupState = "NotReady"
	// Progressing ...
	Progressing SyncGroupState = "Progressing"
	// Warning ...
	Warning SyncGroupState = "Warning"
)

// PossibleSyncGroupStateValues returns an array of possible values for the SyncGroupState const type.
func PossibleSyncGroupStateValues() []SyncGroupState {
	return []SyncGroupState{Error, Good, NotReady, Progressing, Warning}
}

// SyncMemberDbType enumerates the values for sync member db type.
type SyncMemberDbType string

const (
	// AzureSQLDatabase ...
	AzureSQLDatabase SyncMemberDbType = "AzureSqlDatabase"
	// SQLServerDatabase ...
	SQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// PossibleSyncMemberDbTypeValues returns an array of possible values for the SyncMemberDbType const type.
func PossibleSyncMemberDbTypeValues() []SyncMemberDbType {
	return []SyncMemberDbType{AzureSQLDatabase, SQLServerDatabase}
}

// SyncMemberState enumerates the values for sync member state.
type SyncMemberState string

const (
	// DeProvisioned ...
	DeProvisioned SyncMemberState = "DeProvisioned"
	// DeProvisionFailed ...
	DeProvisionFailed SyncMemberState = "DeProvisionFailed"
	// DeProvisioning ...
	DeProvisioning SyncMemberState = "DeProvisioning"
	// DisabledBackupRestore ...
	DisabledBackupRestore SyncMemberState = "DisabledBackupRestore"
	// DisabledTombstoneCleanup ...
	DisabledTombstoneCleanup SyncMemberState = "DisabledTombstoneCleanup"
	// Provisioned ...
	Provisioned SyncMemberState = "Provisioned"
	// ProvisionFailed ...
	ProvisionFailed SyncMemberState = "ProvisionFailed"
	// Provisioning ...
	Provisioning SyncMemberState = "Provisioning"
	// ReprovisionFailed ...
	ReprovisionFailed SyncMemberState = "ReprovisionFailed"
	// Reprovisioning ...
	Reprovisioning SyncMemberState = "Reprovisioning"
	// SyncCancelled ...
	SyncCancelled SyncMemberState = "SyncCancelled"
	// SyncCancelling ...
	SyncCancelling SyncMemberState = "SyncCancelling"
	// SyncFailed ...
	SyncFailed SyncMemberState = "SyncFailed"
	// SyncInProgress ...
	SyncInProgress SyncMemberState = "SyncInProgress"
	// SyncSucceeded ...
	SyncSucceeded SyncMemberState = "SyncSucceeded"
	// SyncSucceededWithWarnings ...
	SyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	// UnProvisioned ...
	UnProvisioned SyncMemberState = "UnProvisioned"
	// UnReprovisioned ...
	UnReprovisioned SyncMemberState = "UnReprovisioned"
)

// PossibleSyncMemberStateValues returns an array of possible values for the SyncMemberState const type.
func PossibleSyncMemberStateValues() []SyncMemberState {
	return []SyncMemberState{DeProvisioned, DeProvisionFailed, DeProvisioning, DisabledBackupRestore, DisabledTombstoneCleanup, Provisioned, ProvisionFailed, Provisioning, ReprovisionFailed, Reprovisioning, SyncCancelled, SyncCancelling, SyncFailed, SyncInProgress, SyncSucceeded, SyncSucceededWithWarnings, UnProvisioned, UnReprovisioned}
}

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity
// status.
type TransparentDataEncryptionActivityStatus string

const (
	// Decrypting ...
	Decrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// Encrypting ...
	Encrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// PossibleTransparentDataEncryptionActivityStatusValues returns an array of possible values for the TransparentDataEncryptionActivityStatus const type.
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return []TransparentDataEncryptionActivityStatus{Decrypting, Encrypting}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// UnitDefinitionTypeBytes ...
	UnitDefinitionTypeBytes UnitDefinitionType = "Bytes"
	// UnitDefinitionTypeBytesPerSecond ...
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// UnitDefinitionTypeCount ...
	UnitDefinitionTypeCount UnitDefinitionType = "Count"
	// UnitDefinitionTypeCountPerSecond ...
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	// UnitDefinitionTypePercent ...
	UnitDefinitionTypePercent UnitDefinitionType = "Percent"
	// UnitDefinitionTypeSeconds ...
	UnitDefinitionTypeSeconds UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns an array of possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{UnitDefinitionTypeBytes, UnitDefinitionTypeBytesPerSecond, UnitDefinitionTypeCount, UnitDefinitionTypeCountPerSecond, UnitDefinitionTypePercent, UnitDefinitionTypeSeconds}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes ...
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond ...
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount ...
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond ...
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent ...
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds ...
	UnitTypeSeconds UnitType = "seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{UnitTypeBytes, UnitTypeBytesPerSecond, UnitTypeCount, UnitTypeCountPerSecond, UnitTypePercent, UnitTypeSeconds}
}

// VirtualNetworkRuleState enumerates the values for virtual network rule state.
type VirtualNetworkRuleState string

const (
	// VirtualNetworkRuleStateDeleting ...
	VirtualNetworkRuleStateDeleting VirtualNetworkRuleState = "Deleting"
	// VirtualNetworkRuleStateInitializing ...
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = "Initializing"
	// VirtualNetworkRuleStateInProgress ...
	VirtualNetworkRuleStateInProgress VirtualNetworkRuleState = "InProgress"
	// VirtualNetworkRuleStateReady ...
	VirtualNetworkRuleStateReady VirtualNetworkRuleState = "Ready"
	// VirtualNetworkRuleStateUnknown ...
	VirtualNetworkRuleStateUnknown VirtualNetworkRuleState = "Unknown"
)

// PossibleVirtualNetworkRuleStateValues returns an array of possible values for the VirtualNetworkRuleState const type.
func PossibleVirtualNetworkRuleStateValues() []VirtualNetworkRuleState {
	return []VirtualNetworkRuleState{VirtualNetworkRuleStateDeleting, VirtualNetworkRuleStateInitializing, VirtualNetworkRuleStateInProgress, VirtualNetworkRuleStateReady, VirtualNetworkRuleStateUnknown}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// VulnerabilityAssessmentPolicyBaselineNameDefault ...
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
	// VulnerabilityAssessmentPolicyBaselineNameMaster ...
	VulnerabilityAssessmentPolicyBaselineNameMaster VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{VulnerabilityAssessmentPolicyBaselineNameDefault, VulnerabilityAssessmentPolicyBaselineNameMaster}
}

// AutomaticTuningOptions automatic tuning properties for individual advisors.
type AutomaticTuningOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - Reason description if desired and actual state are different. Possible values include: 'Default', 'Disabled', 'AutoConfigured', 'InheritedFromServer', 'QueryStoreOff', 'QueryStoreReadOnly', 'NotSupported'
	ReasonDesc AutomaticTuningDisabledReason `json:"reasonDesc,omitempty"`
}

// AutomaticTuningServerOptions automatic tuning properties for individual advisors.
type AutomaticTuningServerOptions struct {
	// DesiredState - Automatic tuning option desired state. Possible values include: 'AutomaticTuningOptionModeDesiredOff', 'AutomaticTuningOptionModeDesiredOn', 'AutomaticTuningOptionModeDesiredDefault'
	DesiredState AutomaticTuningOptionModeDesired `json:"desiredState,omitempty"`
	// ActualState - Automatic tuning option actual state. Possible values include: 'Off', 'On'
	ActualState AutomaticTuningOptionModeActual `json:"actualState,omitempty"`
	// ReasonCode - Reason code if desired and actual state are different.
	ReasonCode *int32 `json:"reasonCode,omitempty"`
	// ReasonDesc - Reason description if desired and actual state are different. Possible values include: 'AutomaticTuningServerReasonDefault', 'AutomaticTuningServerReasonDisabled', 'AutomaticTuningServerReasonAutoConfigured'
	ReasonDesc AutomaticTuningServerReason `json:"reasonDesc,omitempty"`
}

// AutomaticTuningServerProperties server-level Automatic Tuning properties.
type AutomaticTuningServerProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	DesiredState AutomaticTuningServerMode `json:"desiredState,omitempty"`
	// ActualState - Automatic tuning actual state. Possible values include: 'AutomaticTuningServerModeCustom', 'AutomaticTuningServerModeAuto', 'AutomaticTuningServerModeUnspecified'
	ActualState AutomaticTuningServerMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningServerOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for AutomaticTuningServerProperties.
func (atsp AutomaticTuningServerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if atsp.DesiredState != "" {
		objectMap["desiredState"] = atsp.DesiredState
	}
	if atsp.ActualState != "" {
		objectMap["actualState"] = atsp.ActualState
	}
	if atsp.Options != nil {
		objectMap["options"] = atsp.Options
	}
	return json.Marshal(objectMap)
}

// BackupLongTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type BackupLongTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupLongTermRetentionPoliciesCreateOrUpdateFuture) Result(client BackupLongTermRetentionPoliciesClient) (bltrp BackupLongTermRetentionPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bltrp.Response.Response, err = future.GetResult(sender); err == nil && bltrp.Response.Response.StatusCode != http.StatusNoContent {
		bltrp, err = client.CreateOrUpdateResponder(bltrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionPoliciesCreateOrUpdateFuture", "Result", bltrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// BackupLongTermRetentionPolicy a backup long term retention policy
type BackupLongTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// BackupLongTermRetentionPolicyProperties - The properties of the backup long term retention policy
	*BackupLongTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupLongTermRetentionPolicy.
func (bltrp BackupLongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bltrp.Location != nil {
		objectMap["location"] = bltrp.Location
	}
	if bltrp.BackupLongTermRetentionPolicyProperties != nil {
		objectMap["properties"] = bltrp.BackupLongTermRetentionPolicyProperties
	}
	if bltrp.ID != nil {
		objectMap["id"] = bltrp.ID
	}
	if bltrp.Name != nil {
		objectMap["name"] = bltrp.Name
	}
	if bltrp.Type != nil {
		objectMap["type"] = bltrp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupLongTermRetentionPolicy struct.
func (bltrp *BackupLongTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bltrp.Location = &location
			}
		case "properties":
			if v != nil {
				var backupLongTermRetentionPolicyProperties BackupLongTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &backupLongTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				bltrp.BackupLongTermRetentionPolicyProperties = &backupLongTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bltrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bltrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bltrp.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupLongTermRetentionPolicyListResult represents the response to a list long-term retention policies
// request.
type BackupLongTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of long-term retention policies in the database.
	Value *[]BackupLongTermRetentionPolicy `json:"value,omitempty"`
}

// BackupLongTermRetentionPolicyProperties the properties of a backup long term retention policy
type BackupLongTermRetentionPolicyProperties struct {
	// State - The status of the backup long term retention policy. Possible values include: 'BackupLongTermRetentionPolicyStateDisabled', 'BackupLongTermRetentionPolicyStateEnabled'
	State BackupLongTermRetentionPolicyState `json:"state,omitempty"`
	// RecoveryServicesBackupPolicyResourceID - The azure recovery services backup protection policy resource id
	RecoveryServicesBackupPolicyResourceID *string `json:"recoveryServicesBackupPolicyResourceId,omitempty"`
}

// BackupLongTermRetentionVault a backup long term retention vault
type BackupLongTermRetentionVault struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// BackupLongTermRetentionVaultProperties - The properties of the backup long term retention vault
	*BackupLongTermRetentionVaultProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for BackupLongTermRetentionVault.
func (bltrv BackupLongTermRetentionVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bltrv.Location != nil {
		objectMap["location"] = bltrv.Location
	}
	if bltrv.BackupLongTermRetentionVaultProperties != nil {
		objectMap["properties"] = bltrv.BackupLongTermRetentionVaultProperties
	}
	if bltrv.ID != nil {
		objectMap["id"] = bltrv.ID
	}
	if bltrv.Name != nil {
		objectMap["name"] = bltrv.Name
	}
	if bltrv.Type != nil {
		objectMap["type"] = bltrv.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for BackupLongTermRetentionVault struct.
func (bltrv *BackupLongTermRetentionVault) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				bltrv.Location = &location
			}
		case "properties":
			if v != nil {
				var backupLongTermRetentionVaultProperties BackupLongTermRetentionVaultProperties
				err = json.Unmarshal(*v, &backupLongTermRetentionVaultProperties)
				if err != nil {
					return err
				}
				bltrv.BackupLongTermRetentionVaultProperties = &backupLongTermRetentionVaultProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				bltrv.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				bltrv.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				bltrv.Type = &typeVar
			}
		}
	}

	return nil
}

// BackupLongTermRetentionVaultListResult represents the response to a list vaults request.
type BackupLongTermRetentionVaultListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of vaults in the server.
	Value *[]BackupLongTermRetentionVault `json:"value,omitempty"`
}

// BackupLongTermRetentionVaultProperties the properties of a backup long term retention vault.
type BackupLongTermRetentionVaultProperties struct {
	// RecoveryServicesVaultResourceID - The azure recovery services vault resource id
	RecoveryServicesVaultResourceID *string `json:"recoveryServicesVaultResourceId,omitempty"`
}

// BackupLongTermRetentionVaultsCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type BackupLongTermRetentionVaultsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *BackupLongTermRetentionVaultsCreateOrUpdateFuture) Result(client BackupLongTermRetentionVaultsClient) (bltrv BackupLongTermRetentionVault, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionVaultsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.BackupLongTermRetentionVaultsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if bltrv.Response.Response, err = future.GetResult(sender); err == nil && bltrv.Response.Response.StatusCode != http.StatusNoContent {
		bltrv, err = client.CreateOrUpdateResponder(bltrv.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.BackupLongTermRetentionVaultsCreateOrUpdateFuture", "Result", bltrv.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CheckNameAvailabilityRequest a request to check whether the specified name for a resource is available.
type CheckNameAvailabilityRequest struct {
	// Name - The name whose availability is to be checked.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource that is used as the scope of the availability check.
	Type *string `json:"type,omitempty"`
}

// CheckNameAvailabilityResponse a response indicating whether the specified name for a resource is
// available.
type CheckNameAvailabilityResponse struct {
	autorest.Response `json:"-"`
	// Available - True if the name is available, otherwise false.
	Available *bool `json:"available,omitempty"`
	// Message - A message explaining why the name is unavailable. Will be null if the name is available.
	Message *string `json:"message,omitempty"`
	// Name - The name whose availability was checked.
	Name *string `json:"name,omitempty"`
	// Reason - The reason code explaining why the name is unavailable. Will be null if the name is available. Possible values include: 'Invalid', 'AlreadyExists'
	Reason CheckNameAvailabilityReason `json:"reason,omitempty"`
}

// CompleteDatabaseRestoreDefinition contains the information necessary to perform a complete database
// restore operation.
type CompleteDatabaseRestoreDefinition struct {
	// LastBackupName - The last backup name to apply
	LastBackupName *string `json:"lastBackupName,omitempty"`
}

// CreateDatabaseRestorePointDefinition contains the information necessary to perform a create database
// restore point operation.
type CreateDatabaseRestorePointDefinition struct {
	// RestorePointLabel - The restore point label to apply
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// Database represents a database.
type Database struct {
	autorest.Response `json:"-"`
	// Kind - Kind of database.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Database.
func (d Database) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Kind != nil {
		objectMap["kind"] = d.Kind
	}
	if d.DatabaseProperties != nil {
		objectMap["properties"] = d.DatabaseProperties
	}
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	if d.ID != nil {
		objectMap["id"] = d.ID
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	if d.Type != nil {
		objectMap["type"] = d.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Database struct.
func (d *Database) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				d.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				d.DatabaseProperties = &databaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				d.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				d.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				d.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				d.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				d.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuning database-level Automatic Tuning.
type DatabaseAutomaticTuning struct {
	autorest.Response `json:"-"`
	// DatabaseAutomaticTuningProperties - Resource properties.
	*DatabaseAutomaticTuningProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuning.
func (dat DatabaseAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dat.DatabaseAutomaticTuningProperties != nil {
		objectMap["properties"] = dat.DatabaseAutomaticTuningProperties
	}
	if dat.ID != nil {
		objectMap["id"] = dat.ID
	}
	if dat.Name != nil {
		objectMap["name"] = dat.Name
	}
	if dat.Type != nil {
		objectMap["type"] = dat.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAutomaticTuning struct.
func (dat *DatabaseAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseAutomaticTuningProperties DatabaseAutomaticTuningProperties
				err = json.Unmarshal(*v, &databaseAutomaticTuningProperties)
				if err != nil {
					return err
				}
				dat.DatabaseAutomaticTuningProperties = &databaseAutomaticTuningProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dat.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseAutomaticTuningProperties database-level Automatic Tuning properties.
type DatabaseAutomaticTuningProperties struct {
	// DesiredState - Automatic tuning desired state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	DesiredState AutomaticTuningMode `json:"desiredState,omitempty"`
	// ActualState - Automatic tuning actual state. Possible values include: 'Inherit', 'Custom', 'Auto', 'Unspecified'
	ActualState AutomaticTuningMode `json:"actualState,omitempty"`
	// Options - Automatic tuning options definition.
	Options map[string]*AutomaticTuningOptions `json:"options"`
}

// MarshalJSON is the custom marshaler for DatabaseAutomaticTuningProperties.
func (datp DatabaseAutomaticTuningProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if datp.DesiredState != "" {
		objectMap["desiredState"] = datp.DesiredState
	}
	if datp.ActualState != "" {
		objectMap["actualState"] = datp.ActualState
	}
	if datp.Options != nil {
		objectMap["options"] = datp.Options
	}
	return json.Marshal(objectMap)
}

// DatabaseBlobAuditingPolicy a database blob auditing policy.
type DatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// Kind - Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseBlobAuditingPolicyProperties - Resource properties.
	*DatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseBlobAuditingPolicy.
func (dbap DatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dbap.Kind != nil {
		objectMap["kind"] = dbap.Kind
	}
	if dbap.DatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = dbap.DatabaseBlobAuditingPolicyProperties
	}
	if dbap.ID != nil {
		objectMap["id"] = dbap.ID
	}
	if dbap.Name != nil {
		objectMap["name"] = dbap.Name
	}
	if dbap.Type != nil {
		objectMap["type"] = dbap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseBlobAuditingPolicy struct.
func (dbap *DatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dbap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseBlobAuditingPolicyProperties DatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &databaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				dbap.DatabaseBlobAuditingPolicyProperties = &databaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dbap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseBlobAuditingPolicyProperties properties of a database blob auditing policy.
type DatabaseBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// DatabaseListResult represents the response to a list database request.
type DatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of databases housed in the server.
	Value *[]Database `json:"value,omitempty"`
}

// DatabaseOperation a database operation.
type DatabaseOperation struct {
	// DatabaseOperationProperties - Resource properties.
	*DatabaseOperationProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseOperation.
func (do DatabaseOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.DatabaseOperationProperties != nil {
		objectMap["properties"] = do.DatabaseOperationProperties
	}
	if do.ID != nil {
		objectMap["id"] = do.ID
	}
	if do.Name != nil {
		objectMap["name"] = do.Name
	}
	if do.Type != nil {
		objectMap["type"] = do.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseOperation struct.
func (do *DatabaseOperation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseOperationProperties DatabaseOperationProperties
				err = json.Unmarshal(*v, &databaseOperationProperties)
				if err != nil {
					return err
				}
				do.DatabaseOperationProperties = &databaseOperationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				do.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				do.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				do.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseOperationListResult the response to a list database operations request
type DatabaseOperationListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]DatabaseOperation `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseOperationListResultIterator provides access to a complete listing of DatabaseOperation values.
type DatabaseOperationListResultIterator struct {
	i    int
	page DatabaseOperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseOperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseOperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseOperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseOperationListResultIterator) Response() DatabaseOperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseOperationListResultIterator) Value() DatabaseOperation {
	if !iter.page.NotDone() {
		return DatabaseOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseOperationListResultIterator type.
func NewDatabaseOperationListResultIterator(page DatabaseOperationListResultPage) DatabaseOperationListResultIterator {
	return DatabaseOperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DatabaseOperationListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// databaseOperationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DatabaseOperationListResult) databaseOperationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dolr.NextLink == nil || len(to.String(dolr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DatabaseOperationListResultPage contains a page of DatabaseOperation values.
type DatabaseOperationListResultPage struct {
	fn   func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)
	dolr DatabaseOperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseOperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseOperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dolr)
	if err != nil {
		return err
	}
	page.dolr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseOperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseOperationListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseOperationListResultPage) Response() DatabaseOperationListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseOperationListResultPage) Values() []DatabaseOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DatabaseOperationListResultPage type.
func NewDatabaseOperationListResultPage(getNextPage func(context.Context, DatabaseOperationListResult) (DatabaseOperationListResult, error)) DatabaseOperationListResultPage {
	return DatabaseOperationListResultPage{fn: getNextPage}
}

// DatabaseOperationProperties the properties of a database operation.
type DatabaseOperationProperties struct {
	// DatabaseName - The name of the database the operation is being performed on.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Operation - The name of operation.
	Operation *string `json:"operation,omitempty"`
	// OperationFriendlyName - The friendly name of operation.
	OperationFriendlyName *string `json:"operationFriendlyName,omitempty"`
	// PercentComplete - The percentage of the operation completed.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ServerName - The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - The operation start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - The operation state. Possible values include: 'ManagementOperationStatePending', 'ManagementOperationStateInProgress', 'ManagementOperationStateSucceeded', 'ManagementOperationStateFailed', 'ManagementOperationStateCancelInProgress', 'ManagementOperationStateCancelled'
	State ManagementOperationState `json:"state,omitempty"`
	// ErrorCode - The operation error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorDescription - The operation error description.
	ErrorDescription *string `json:"errorDescription,omitempty"`
	// ErrorSeverity - The operation error severity.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// IsUserError - Whether or not the error is a user error.
	IsUserError *bool `json:"isUserError,omitempty"`
	// EstimatedCompletionTime - The estimated completion time of the operation.
	EstimatedCompletionTime *date.Time `json:"estimatedCompletionTime,omitempty"`
	// Description - The operation description.
	Description *string `json:"description,omitempty"`
	// IsCancellable - Whether the operation can be cancelled.
	IsCancellable *bool `json:"isCancellable,omitempty"`
}

// DatabaseProperties represents the properties of a database.
type DatabaseProperties struct {
	// Collation - The collation of the database. If createMode is not Default, this value is ignored.
	Collation *string `json:"collation,omitempty"`
	// CreationDate - The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ContainmentState - The containment state of the database.
	ContainmentState *int64 `json:"containmentState,omitempty"`
	// CurrentServiceObjectiveID - The current service level objective ID of the database. This is the ID of the service level objective that is currently active.
	CurrentServiceObjectiveID *uuid.UUID `json:"currentServiceObjectiveId,omitempty"`
	// DatabaseID - The ID of the database.
	DatabaseID *uuid.UUID `json:"databaseId,omitempty"`
	// EarliestRestoreDate - This records the earliest start date and time that restore is available for this database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// CreateMode - Specifies the mode of database creation.
	// Default: regular database creation.
	// Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
	// OnlineSecondary/NonReadableSecondary: creates a database as a (readable or nonreadable) secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
	// PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
	// Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
	// Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
	// RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
	// Copy, NonReadableSecondary, OnlineSecondary and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition. Possible values include: 'CreateModeCopy', 'CreateModeDefault', 'CreateModeNonReadableSecondary', 'CreateModeOnlineSecondary', 'CreateModePointInTimeRestore', 'CreateModeRecovery', 'CreateModeRestore', 'CreateModeRestoreLongTermRetentionBackup'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// SourceDatabaseID - Conditional. If createMode is Copy, NonReadableSecondary, OnlineSecondary, PointInTimeRestore, Recovery, or Restore, then this value is required. Specifies the resource ID of the source database. If createMode is NonReadableSecondary or OnlineSecondary, the name of the source database must be the same as the new database being created.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// SourceDatabaseDeletionDate - Conditional. If createMode is Restore and sourceDatabaseId is the deleted database's original resource id when it existed (as opposed to its current restorable dropped database id), then this value is required. Specifies the time that the database was deleted.
	SourceDatabaseDeletionDate *date.Time `json:"sourceDatabaseDeletionDate,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. If createMode is Restore, this value is optional. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database. Must be greater than or equal to the source database's earliestRestoreDate value.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// RecoveryServicesRecoveryPointResourceID - Conditional. If createMode is RestoreLongTermRetentionBackup, then this value is required. Specifies the resource ID of the recovery point to restore from.
	RecoveryServicesRecoveryPointResourceID *string `json:"recoveryServicesRecoveryPointResourceId,omitempty"`
	// Edition - The edition of the database. The DatabaseEditions enumeration contains all the valid editions. If createMode is NonReadableSecondary or OnlineSecondary, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation." or use the Azure CLI command `az sql db list-editions -l westus --query [].name`. Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// MaxSizeBytes - The max size of the database expressed in bytes. If createMode is not Default, this value is ignored. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation."
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// RequestedServiceObjectiveID - The configured service level objective ID of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of currentServiceObjectiveId property. If requestedServiceObjectiveId and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveId overrides the value of requestedServiceObjectiveName. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation." or use the Azure CLI command `az sql db list-editions --location <location> --query [].supportedServiceLevelObjectives[].name` .
	RequestedServiceObjectiveID *uuid.UUID `json:"requestedServiceObjectiveId,omitempty"`
	// RequestedServiceObjectiveName - The name of the configured service level objective of the database. This is the service level objective that is in the process of being applied to the database. Once successfully updated, it will match the value of serviceLevelObjective property. To see possible values, query the capabilities API (/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationID}/capabilities) referred to by operationId: "Capabilities_ListByLocation." or use the Azure CLI command `az sql db list-editions --location <location> --query [].supportedServiceLevelObjectives[].name`. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	RequestedServiceObjectiveName ServiceObjectiveName `json:"requestedServiceObjectiveName,omitempty"`
	// ServiceLevelObjective - The current service level objective of the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// Status - The status of the database.
	Status *string `json:"status,omitempty"`
	// ElasticPoolName - The name of the elastic pool the database is in. If elasticPoolName and requestedServiceObjectiveName are both updated, the value of requestedServiceObjectiveName is ignored. Not supported for DataWarehouse edition.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// DefaultSecondaryLocation - The default secondary region for this database.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// ServiceTierAdvisors - The list of service tier advisors for this database. Expanded property
	ServiceTierAdvisors *[]ServiceTierAdvisor `json:"serviceTierAdvisors,omitempty"`
	// TransparentDataEncryption - The transparent data encryption info for this database.
	TransparentDataEncryption *[]TransparentDataEncryption `json:"transparentDataEncryption,omitempty"`
	// RecommendedIndex - The recommended indices for this database.
	RecommendedIndex *[]RecommendedIndex `json:"recommendedIndex,omitempty"`
	// FailoverGroupID - The resource identifier of the failover group containing this database.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// ReadScale - Conditional. If the database is a geo-secondary, readScale indicates whether read-only connections are allowed to this database or not. Not supported for DataWarehouse edition. Possible values include: 'ReadScaleEnabled', 'ReadScaleDisabled'
	ReadScale ReadScale `json:"readScale,omitempty"`
	// SampleName - Indicates the name of the sample schema to apply when creating this database. If createMode is not Default, this value is ignored. Not supported for DataWarehouse edition. Possible values include: 'AdventureWorksLT'
	SampleName SampleName `json:"sampleName,omitempty"`
	// ZoneRedundant - Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// DatabasesCreateImportOperationFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabasesCreateImportOperationFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesCreateImportOperationFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateImportOperationFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.CreateImportOperationResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateImportOperationFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesCreateOrUpdateFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.CreateOrUpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesCreateOrUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseSecurityAlertPolicy contains information about a database Threat Detection policy.
type DatabaseSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// Kind - Resource kind.
	Kind *string `json:"kind,omitempty"`
	// DatabaseSecurityAlertPolicyProperties - Properties of the security alert policy.
	*DatabaseSecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseSecurityAlertPolicy.
func (dsap DatabaseSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsap.Location != nil {
		objectMap["location"] = dsap.Location
	}
	if dsap.Kind != nil {
		objectMap["kind"] = dsap.Kind
	}
	if dsap.DatabaseSecurityAlertPolicyProperties != nil {
		objectMap["properties"] = dsap.DatabaseSecurityAlertPolicyProperties
	}
	if dsap.ID != nil {
		objectMap["id"] = dsap.ID
	}
	if dsap.Name != nil {
		objectMap["name"] = dsap.Name
	}
	if dsap.Type != nil {
		objectMap["type"] = dsap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseSecurityAlertPolicy struct.
func (dsap *DatabaseSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dsap.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dsap.Kind = &kind
			}
		case "properties":
			if v != nil {
				var databaseSecurityAlertPolicyProperties DatabaseSecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &databaseSecurityAlertPolicyProperties)
				if err != nil {
					return err
				}
				dsap.DatabaseSecurityAlertPolicyProperties = &databaseSecurityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dsap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dsap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dsap.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseSecurityAlertPolicyProperties properties for a database Threat Detection policy.
type DatabaseSecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
	DisabledAlerts *string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
	EmailAddresses *string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators. Possible values include: 'SecurityAlertPolicyEmailAccountAdminsEnabled', 'SecurityAlertPolicyEmailAccountAdminsDisabled'
	EmailAccountAdmins SecurityAlertPolicyEmailAccountAdmins `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account. If state is Enabled, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// UseServerDefault - Specifies whether to use the default server policy. Possible values include: 'SecurityAlertPolicyUseServerDefaultEnabled', 'SecurityAlertPolicyUseServerDefaultDisabled'
	UseServerDefault SecurityAlertPolicyUseServerDefault `json:"useServerDefault,omitempty"`
}

// DatabasesExportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesExportFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesExportFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesExportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ExportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesExportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesImportFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesImportFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesImportFuture) Result(client DatabasesClient) (ier ImportExportResponse, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesImportFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ier.Response.Response, err = future.GetResult(sender); err == nil && ier.Response.Response.StatusCode != http.StatusNoContent {
		ier, err = client.ImportResponder(ier.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesImportFuture", "Result", ier.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabasesPauseFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesPauseFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesPauseFuture) Result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesPauseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesPauseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesResumeFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesResumeFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesResumeFuture) Result(client DatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesResumeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesResumeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabasesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DatabasesUpdateFuture) Result(client DatabasesClient) (d Database, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.DatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if d.Response.Response, err = future.GetResult(sender); err == nil && d.Response.Response.StatusCode != http.StatusNoContent {
		d, err = client.UpdateResponder(d.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.DatabasesUpdateFuture", "Result", d.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseUpdate represents a database update.
type DatabaseUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// DatabaseProperties - The properties representing the resource.
	*DatabaseProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseUpdate.
func (du DatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if du.Tags != nil {
		objectMap["tags"] = du.Tags
	}
	if du.DatabaseProperties != nil {
		objectMap["properties"] = du.DatabaseProperties
	}
	if du.ID != nil {
		objectMap["id"] = du.ID
	}
	if du.Name != nil {
		objectMap["name"] = du.Name
	}
	if du.Type != nil {
		objectMap["type"] = du.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseUpdate struct.
func (du *DatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				du.Tags = tags
			}
		case "properties":
			if v != nil {
				var databaseProperties DatabaseProperties
				err = json.Unmarshal(*v, &databaseProperties)
				if err != nil {
					return err
				}
				du.DatabaseProperties = &databaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				du.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				du.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				du.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseUsage the database usages.
type DatabaseUsage struct {
	// Name - The name of the usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - The usage metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - The current value of the usage metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - The current limit of the usage metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - The units of the usage metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - The next reset time for the usage metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// DatabaseUsageListResult the response to a list database metrics request.
type DatabaseUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database usages for the database.
	Value *[]DatabaseUsage `json:"value,omitempty"`
}

// DatabaseVulnerabilityAssessment a database vulnerability assessment.
type DatabaseVulnerabilityAssessment struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessment.
func (dva DatabaseVulnerabilityAssessment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dva.DatabaseVulnerabilityAssessmentProperties != nil {
		objectMap["properties"] = dva.DatabaseVulnerabilityAssessmentProperties
	}
	if dva.ID != nil {
		objectMap["id"] = dva.ID
	}
	if dva.Name != nil {
		objectMap["name"] = dva.Name
	}
	if dva.Type != nil {
		objectMap["type"] = dva.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessment struct.
func (dva *DatabaseVulnerabilityAssessment) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentProperties DatabaseVulnerabilityAssessmentProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentProperties)
				if err != nil {
					return err
				}
				dva.DatabaseVulnerabilityAssessmentProperties = &databaseVulnerabilityAssessmentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dva.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dva.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dva.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentListResult a list of the database's vulnerability assessments.
type DatabaseVulnerabilityAssessmentListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]DatabaseVulnerabilityAssessment `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatabaseVulnerabilityAssessmentListResultIterator provides access to a complete listing of
// DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultIterator struct {
	i    int
	page DatabaseVulnerabilityAssessmentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DatabaseVulnerabilityAssessmentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Response() DatabaseVulnerabilityAssessmentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DatabaseVulnerabilityAssessmentListResultIterator) Value() DatabaseVulnerabilityAssessment {
	if !iter.page.NotDone() {
		return DatabaseVulnerabilityAssessment{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultIterator type.
func NewDatabaseVulnerabilityAssessmentListResultIterator(page DatabaseVulnerabilityAssessmentListResultPage) DatabaseVulnerabilityAssessmentListResultIterator {
	return DatabaseVulnerabilityAssessmentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvalr DatabaseVulnerabilityAssessmentListResult) IsEmpty() bool {
	return dvalr.Value == nil || len(*dvalr.Value) == 0
}

// databaseVulnerabilityAssessmentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvalr DatabaseVulnerabilityAssessmentListResult) databaseVulnerabilityAssessmentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dvalr.NextLink == nil || len(to.String(dvalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvalr.NextLink)))
}

// DatabaseVulnerabilityAssessmentListResultPage contains a page of DatabaseVulnerabilityAssessment values.
type DatabaseVulnerabilityAssessmentListResultPage struct {
	fn    func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)
	dvalr DatabaseVulnerabilityAssessmentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DatabaseVulnerabilityAssessmentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DatabaseVulnerabilityAssessmentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dvalr)
	if err != nil {
		return err
	}
	page.dvalr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DatabaseVulnerabilityAssessmentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DatabaseVulnerabilityAssessmentListResultPage) NotDone() bool {
	return !page.dvalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DatabaseVulnerabilityAssessmentListResultPage) Response() DatabaseVulnerabilityAssessmentListResult {
	return page.dvalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DatabaseVulnerabilityAssessmentListResultPage) Values() []DatabaseVulnerabilityAssessment {
	if page.dvalr.IsEmpty() {
		return nil
	}
	return *page.dvalr.Value
}

// Creates a new instance of the DatabaseVulnerabilityAssessmentListResultPage type.
func NewDatabaseVulnerabilityAssessmentListResultPage(getNextPage func(context.Context, DatabaseVulnerabilityAssessmentListResult) (DatabaseVulnerabilityAssessmentListResult, error)) DatabaseVulnerabilityAssessmentListResultPage {
	return DatabaseVulnerabilityAssessmentListResultPage{fn: getNextPage}
}

// DatabaseVulnerabilityAssessmentProperties properties of a database Vulnerability Assessment.
type DatabaseVulnerabilityAssessmentProperties struct {
	// StorageContainerPath - A blob storage container path to hold the scan results (e.g. https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level vulnerability assessment policy doesn't set
	StorageContainerPath *string `json:"storageContainerPath,omitempty"`
	// StorageContainerSasKey - A shared access signature (SAS Key) that has write access to the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required.
	StorageContainerSasKey *string `json:"storageContainerSasKey,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the storage account for vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RecurringScans - The recurring scans settings
	RecurringScans *VulnerabilityAssessmentRecurringScansProperties `json:"recurringScans,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaseline a database vulnerability assessment rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaseline struct {
	autorest.Response `json:"-"`
	// DatabaseVulnerabilityAssessmentRuleBaselineProperties - Resource properties.
	*DatabaseVulnerabilityAssessmentRuleBaselineProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseVulnerabilityAssessmentRuleBaseline.
func (dvarb DatabaseVulnerabilityAssessmentRuleBaseline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties != nil {
		objectMap["properties"] = dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties
	}
	if dvarb.ID != nil {
		objectMap["id"] = dvarb.ID
	}
	if dvarb.Name != nil {
		objectMap["name"] = dvarb.Name
	}
	if dvarb.Type != nil {
		objectMap["type"] = dvarb.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseVulnerabilityAssessmentRuleBaseline struct.
func (dvarb *DatabaseVulnerabilityAssessmentRuleBaseline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var databaseVulnerabilityAssessmentRuleBaselineProperties DatabaseVulnerabilityAssessmentRuleBaselineProperties
				err = json.Unmarshal(*v, &databaseVulnerabilityAssessmentRuleBaselineProperties)
				if err != nil {
					return err
				}
				dvarb.DatabaseVulnerabilityAssessmentRuleBaselineProperties = &databaseVulnerabilityAssessmentRuleBaselineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dvarb.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dvarb.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dvarb.Type = &typeVar
			}
		}
	}

	return nil
}

// DatabaseVulnerabilityAssessmentRuleBaselineItem properties for an Azure SQL Database Vulnerability
// Assessment rule baseline's result.
type DatabaseVulnerabilityAssessmentRuleBaselineItem struct {
	// Result - The rule baseline result
	Result *[]string `json:"result,omitempty"`
}

// DatabaseVulnerabilityAssessmentRuleBaselineProperties properties of a database Vulnerability Assessment
// rule baseline.
type DatabaseVulnerabilityAssessmentRuleBaselineProperties struct {
	// BaselineResults - The rule baseline result
	BaselineResults *[]DatabaseVulnerabilityAssessmentRuleBaselineItem `json:"baselineResults,omitempty"`
}

// DataMaskingPolicy represents a database data masking policy.
type DataMaskingPolicy struct {
	autorest.Response `json:"-"`
	// DataMaskingPolicyProperties - The properties of the data masking policy.
	*DataMaskingPolicyProperties `json:"properties,omitempty"`
	// Location - The location of the data masking policy.
	Location *string `json:"location,omitempty"`
	// Kind - The kind of data masking policy. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingPolicy.
func (dmp DataMaskingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmp.DataMaskingPolicyProperties != nil {
		objectMap["properties"] = dmp.DataMaskingPolicyProperties
	}
	if dmp.Location != nil {
		objectMap["location"] = dmp.Location
	}
	if dmp.Kind != nil {
		objectMap["kind"] = dmp.Kind
	}
	if dmp.ID != nil {
		objectMap["id"] = dmp.ID
	}
	if dmp.Name != nil {
		objectMap["name"] = dmp.Name
	}
	if dmp.Type != nil {
		objectMap["type"] = dmp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingPolicy struct.
func (dmp *DataMaskingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingPolicyProperties DataMaskingPolicyProperties
				err = json.Unmarshal(*v, &dataMaskingPolicyProperties)
				if err != nil {
					return err
				}
				dmp.DataMaskingPolicyProperties = &dataMaskingPolicyProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmp.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmp.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmp.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingPolicyProperties the properties of a database data masking policy.
type DataMaskingPolicyProperties struct {
	// DataMaskingState - The state of the data masking policy. Possible values include: 'DataMaskingStateDisabled', 'DataMaskingStateEnabled'
	DataMaskingState DataMaskingState `json:"dataMaskingState,omitempty"`
	// ExemptPrincipals - The list of the exempt principals. Specifies the semicolon-separated list of database users for which the data masking policy does not apply. The specified users receive data results without masking for all of the database queries.
	ExemptPrincipals *string `json:"exemptPrincipals,omitempty"`
	// ApplicationPrincipals - The list of the application principals. This is a legacy parameter and is no longer used.
	ApplicationPrincipals *string `json:"applicationPrincipals,omitempty"`
	// MaskingLevel - The masking level. This is a legacy parameter and is no longer used.
	MaskingLevel *string `json:"maskingLevel,omitempty"`
}

// DataMaskingRule represents a database data masking rule.
type DataMaskingRule struct {
	autorest.Response `json:"-"`
	// DataMaskingRuleProperties - The properties of the resource.
	*DataMaskingRuleProperties `json:"properties,omitempty"`
	// Location - The location of the data masking rule.
	Location *string `json:"location,omitempty"`
	// Kind - The kind of Data Masking Rule. Metadata, used for Azure portal.
	Kind *string `json:"kind,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataMaskingRule.
func (dmr DataMaskingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmr.DataMaskingRuleProperties != nil {
		objectMap["properties"] = dmr.DataMaskingRuleProperties
	}
	if dmr.Location != nil {
		objectMap["location"] = dmr.Location
	}
	if dmr.Kind != nil {
		objectMap["kind"] = dmr.Kind
	}
	if dmr.ID != nil {
		objectMap["id"] = dmr.ID
	}
	if dmr.Name != nil {
		objectMap["name"] = dmr.Name
	}
	if dmr.Type != nil {
		objectMap["type"] = dmr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataMaskingRule struct.
func (dmr *DataMaskingRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataMaskingRuleProperties DataMaskingRuleProperties
				err = json.Unmarshal(*v, &dataMaskingRuleProperties)
				if err != nil {
					return err
				}
				dmr.DataMaskingRuleProperties = &dataMaskingRuleProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dmr.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dmr.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dmr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dmr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dmr.Type = &typeVar
			}
		}
	}

	return nil
}

// DataMaskingRuleListResult the response to a list data masking rules request.
type DataMaskingRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database data masking rules.
	Value *[]DataMaskingRule `json:"value,omitempty"`
}

// DataMaskingRuleProperties the properties of a database data masking rule.
type DataMaskingRuleProperties struct {
	// ID - The rule Id.
	ID *string `json:"id,omitempty"`
	// AliasName - The alias name. This is a legacy parameter and is no longer used.
	AliasName *string `json:"aliasName,omitempty"`
	// RuleState - The rule state. Used to delete a rule. To delete an existing rule, specify the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled. However, if the rule doesn't already exist, the rule will be created with ruleState set to enabled, regardless of the provided value of ruleState. Possible values include: 'DataMaskingRuleStateDisabled', 'DataMaskingRuleStateEnabled'
	RuleState DataMaskingRuleState `json:"ruleState,omitempty"`
	// SchemaName - The schema name on which the data masking rule is applied.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The table name on which the data masking rule is applied.
	TableName *string `json:"tableName,omitempty"`
	// ColumnName - The column name on which the data masking rule is applied.
	ColumnName *string `json:"columnName,omitempty"`
	// MaskingFunction - The masking function that is used for the data masking rule. Possible values include: 'DataMaskingFunctionDefault', 'DataMaskingFunctionCCN', 'DataMaskingFunctionEmail', 'DataMaskingFunctionNumber', 'DataMaskingFunctionSSN', 'DataMaskingFunctionText'
	MaskingFunction DataMaskingFunction `json:"maskingFunction,omitempty"`
	// NumberFrom - The numberFrom property of the masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberFrom *string `json:"numberFrom,omitempty"`
	// NumberTo - The numberTo property of the data masking rule. Required if maskingFunction is set to Number, otherwise this parameter will be ignored.
	NumberTo *string `json:"numberTo,omitempty"`
	// PrefixSize - If maskingFunction is set to Text, the number of characters to show unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
	PrefixSize *string `json:"prefixSize,omitempty"`
	// SuffixSize - If maskingFunction is set to Text, the number of characters to show unmasked at the end of the string. Otherwise, this parameter will be ignored.
	SuffixSize *string `json:"suffixSize,omitempty"`
	// ReplacementString - If maskingFunction is set to Text, the character to use for masking the unexposed part of the string. Otherwise, this parameter will be ignored.
	ReplacementString *string `json:"replacementString,omitempty"`
}

// DataWarehouseUserActivities user activities of a data warehouse
type DataWarehouseUserActivities struct {
	autorest.Response `json:"-"`
	// DataWarehouseUserActivitiesProperties - Resource properties.
	*DataWarehouseUserActivitiesProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DataWarehouseUserActivities.
func (dwua DataWarehouseUserActivities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dwua.DataWarehouseUserActivitiesProperties != nil {
		objectMap["properties"] = dwua.DataWarehouseUserActivitiesProperties
	}
	if dwua.ID != nil {
		objectMap["id"] = dwua.ID
	}
	if dwua.Name != nil {
		objectMap["name"] = dwua.Name
	}
	if dwua.Type != nil {
		objectMap["type"] = dwua.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DataWarehouseUserActivities struct.
func (dwua *DataWarehouseUserActivities) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var dataWarehouseUserActivitiesProperties DataWarehouseUserActivitiesProperties
				err = json.Unmarshal(*v, &dataWarehouseUserActivitiesProperties)
				if err != nil {
					return err
				}
				dwua.DataWarehouseUserActivitiesProperties = &dataWarehouseUserActivitiesProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dwua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dwua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dwua.Type = &typeVar
			}
		}
	}

	return nil
}

// DataWarehouseUserActivitiesProperties user activities of a data warehouse. This currently includes the
// count of running or suspended queries. For more information, please view the sys.dm_pdw_exec_requests
// dynamic management view (DMV).
type DataWarehouseUserActivitiesProperties struct {
	// ActiveQueriesCount - Count of running and suspended queries.
	ActiveQueriesCount *int32 `json:"activeQueriesCount,omitempty"`
}

// EditionCapability the database edition capabilities.
type EditionCapability struct {
	// Name - The edition name.
	Name *string `json:"name,omitempty"`
	// Status - The status of the edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServiceLevelObjectives - The list of supported service objectives for the edition.
	SupportedServiceLevelObjectives *[]ServiceObjectiveCapability `json:"supportedServiceLevelObjectives,omitempty"`
	// ZoneRedundant - Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPool represents a database elastic pool.
type ElasticPool struct {
	autorest.Response `json:"-"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// Kind - Kind of elastic pool.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPool.
func (ep ElasticPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.ElasticPoolProperties != nil {
		objectMap["properties"] = ep.ElasticPoolProperties
	}
	if ep.Kind != nil {
		objectMap["kind"] = ep.Kind
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Tags != nil {
		objectMap["tags"] = ep.Tags
	}
	if ep.ID != nil {
		objectMap["id"] = ep.ID
	}
	if ep.Name != nil {
		objectMap["name"] = ep.Name
	}
	if ep.Type != nil {
		objectMap["type"] = ep.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPool struct.
func (ep *ElasticPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				ep.ElasticPoolProperties = &elasticPoolProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ep.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivity represents the activity on an elastic pool.
type ElasticPoolActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolActivityProperties - The properties representing the resource.
	*ElasticPoolActivityProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolActivity.
func (epa ElasticPoolActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epa.Location != nil {
		objectMap["location"] = epa.Location
	}
	if epa.ElasticPoolActivityProperties != nil {
		objectMap["properties"] = epa.ElasticPoolActivityProperties
	}
	if epa.ID != nil {
		objectMap["id"] = epa.ID
	}
	if epa.Name != nil {
		objectMap["name"] = epa.Name
	}
	if epa.Type != nil {
		objectMap["type"] = epa.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolActivity struct.
func (epa *ElasticPoolActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epa.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolActivityProperties ElasticPoolActivityProperties
				err = json.Unmarshal(*v, &elasticPoolActivityProperties)
				if err != nil {
					return err
				}
				epa.ElasticPoolActivityProperties = &elasticPoolActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epa.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolActivityListResult represents the response to a list elastic pool activity request.
type ElasticPoolActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool activities.
	Value *[]ElasticPoolActivity `json:"value,omitempty"`
}

// ElasticPoolActivityProperties represents the properties of an elastic pool.
type ElasticPoolActivityProperties struct {
	// EndTime - The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedDatabaseDtuMax - The requested max DTU per database if available.
	RequestedDatabaseDtuMax *int32 `json:"requestedDatabaseDtuMax,omitempty"`
	// RequestedDatabaseDtuMin - The requested min DTU per database if available.
	RequestedDatabaseDtuMin *int32 `json:"requestedDatabaseDtuMin,omitempty"`
	// RequestedDtu - The requested DTU for the pool if available.
	RequestedDtu *int32 `json:"requestedDtu,omitempty"`
	// RequestedElasticPoolName - The requested name for the elastic pool if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// RequestedStorageLimitInGB - The requested storage limit for the pool in GB if available.
	RequestedStorageLimitInGB *int64 `json:"requestedStorageLimitInGB,omitempty"`
	// ElasticPoolName - The name of the elastic pool.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ServerName - The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - The current state of the operation.
	State *string `json:"state,omitempty"`
	// RequestedStorageLimitInMB - The requested storage limit in MB.
	RequestedStorageLimitInMB *int32 `json:"requestedStorageLimitInMB,omitempty"`
	// RequestedDatabaseDtuGuarantee - The requested per database DTU guarantee.
	RequestedDatabaseDtuGuarantee *int32 `json:"requestedDatabaseDtuGuarantee,omitempty"`
	// RequestedDatabaseDtuCap - The requested per database DTU cap.
	RequestedDatabaseDtuCap *int32 `json:"requestedDatabaseDtuCap,omitempty"`
	// RequestedDtuGuarantee - The requested DTU guarantee.
	RequestedDtuGuarantee *int32 `json:"requestedDtuGuarantee,omitempty"`
}

// ElasticPoolDatabaseActivity represents the activity on an elastic pool.
type ElasticPoolDatabaseActivity struct {
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ElasticPoolDatabaseActivityProperties - The properties representing the resource.
	*ElasticPoolDatabaseActivityProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolDatabaseActivity.
func (epda ElasticPoolDatabaseActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epda.Location != nil {
		objectMap["location"] = epda.Location
	}
	if epda.ElasticPoolDatabaseActivityProperties != nil {
		objectMap["properties"] = epda.ElasticPoolDatabaseActivityProperties
	}
	if epda.ID != nil {
		objectMap["id"] = epda.ID
	}
	if epda.Name != nil {
		objectMap["name"] = epda.Name
	}
	if epda.Type != nil {
		objectMap["type"] = epda.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolDatabaseActivity struct.
func (epda *ElasticPoolDatabaseActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				epda.Location = &location
			}
		case "properties":
			if v != nil {
				var elasticPoolDatabaseActivityProperties ElasticPoolDatabaseActivityProperties
				err = json.Unmarshal(*v, &elasticPoolDatabaseActivityProperties)
				if err != nil {
					return err
				}
				epda.ElasticPoolDatabaseActivityProperties = &elasticPoolDatabaseActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epda.Type = &typeVar
			}
		}
	}

	return nil
}

// ElasticPoolDatabaseActivityListResult represents the response to a list elastic pool database activity
// request.
type ElasticPoolDatabaseActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pool database activities.
	Value *[]ElasticPoolDatabaseActivity `json:"value,omitempty"`
}

// ElasticPoolDatabaseActivityProperties represents the properties of an elastic pool database activity.
type ElasticPoolDatabaseActivityProperties struct {
	// DatabaseName - The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// EndTime - The time the operation finished (ISO8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// ErrorCode - The error code if available.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorMessage - The error message if available.
	ErrorMessage *string `json:"errorMessage,omitempty"`
	// ErrorSeverity - The error severity if available.
	ErrorSeverity *int32 `json:"errorSeverity,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// OperationID - The unique operation ID.
	OperationID *uuid.UUID `json:"operationId,omitempty"`
	// PercentComplete - The percentage complete if available.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// RequestedElasticPoolName - The name for the elastic pool the database is moving into if available.
	RequestedElasticPoolName *string `json:"requestedElasticPoolName,omitempty"`
	// CurrentElasticPoolName - The name of the current elastic pool the database is in if available.
	CurrentElasticPoolName *string `json:"currentElasticPoolName,omitempty"`
	// CurrentServiceObjective - The name of the current service objective if available.
	CurrentServiceObjective *string `json:"currentServiceObjective,omitempty"`
	// RequestedServiceObjective - The name of the requested service objective if available.
	RequestedServiceObjective *string `json:"requestedServiceObjective,omitempty"`
	// ServerName - The name of the server the elastic pool is in.
	ServerName *string `json:"serverName,omitempty"`
	// StartTime - The time the operation started (ISO8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// State - The current state of the operation.
	State *string `json:"state,omitempty"`
}

// ElasticPoolDtuCapability the Elastic Pool DTU capability.
type ElasticPoolDtuCapability struct {
	// Limit - The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// MaxDatabaseCount - The maximum number of databases supported.
	MaxDatabaseCount *int64 `json:"maxDatabaseCount,omitempty"`
	// Status - The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedMaxSizes - The list of supported max sizes.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
	// SupportedPerDatabaseMaxSizes - The list of supported max database sizes.
	SupportedPerDatabaseMaxSizes *[]MaxSizeCapability `json:"supportedPerDatabaseMaxSizes,omitempty"`
	// SupportedPerDatabaseMaxDtus - The list of supported max database DTUs.
	SupportedPerDatabaseMaxDtus *[]ElasticPoolPerDatabaseMaxDtuCapability `json:"supportedPerDatabaseMaxDtus,omitempty"`
}

// ElasticPoolEditionCapability the elastic pool edition capabilities.
type ElasticPoolEditionCapability struct {
	// Name - The elastic pool edition name.
	Name *string `json:"name,omitempty"`
	// Status - The status of the elastic pool edition. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedElasticPoolDtus - The list of supported elastic pool DTU levels for the edition.
	SupportedElasticPoolDtus *[]ElasticPoolDtuCapability `json:"supportedElasticPoolDtus,omitempty"`
	// ZoneRedundant - Whether or not zone redundancy is supported for the edition.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPoolListResult represents the response to a list elastic pool request.
type ElasticPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of elastic pools hosted in the server.
	Value *[]ElasticPool `json:"value,omitempty"`
}

// ElasticPoolPerDatabaseMaxDtuCapability the max per-database DTU capability.
type ElasticPoolPerDatabaseMaxDtuCapability struct {
	// Limit - The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedPerDatabaseMinDtus - The list of supported min database DTUs.
	SupportedPerDatabaseMinDtus *[]ElasticPoolPerDatabaseMinDtuCapability `json:"supportedPerDatabaseMinDtus,omitempty"`
}

// ElasticPoolPerDatabaseMinDtuCapability the minimum per-database DTU capability.
type ElasticPoolPerDatabaseMinDtuCapability struct {
	// Limit - The maximum DTUs per database.
	Limit *int64 `json:"limit,omitempty"`
	// Status - The status of the capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// ElasticPoolProperties represents the properties of an elastic pool.
type ElasticPoolProperties struct {
	// CreationDate - The creation date of the elastic pool (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// State - The state of the elastic pool. Possible values include: 'ElasticPoolStateCreating', 'ElasticPoolStateReady', 'ElasticPoolStateDisabled'
	State ElasticPoolState `json:"state,omitempty"`
	// Edition - The edition of the elastic pool. Possible values include: 'ElasticPoolEditionBasic', 'ElasticPoolEditionStandard', 'ElasticPoolEditionPremium'
	Edition ElasticPoolEdition `json:"edition,omitempty"`
	// Dtu - The total shared DTU for the database elastic pool.
	Dtu *int32 `json:"dtu,omitempty"`
	// DatabaseDtuMax - The maximum DTU any one database can consume.
	DatabaseDtuMax *int32 `json:"databaseDtuMax,omitempty"`
	// DatabaseDtuMin - The minimum DTU all databases are guaranteed.
	DatabaseDtuMin *int32 `json:"databaseDtuMin,omitempty"`
	// StorageMB - Gets storage limit for the database elastic pool in MB.
	StorageMB *int32 `json:"storageMB,omitempty"`
	// ZoneRedundant - Whether or not this database elastic pool is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`
}

// ElasticPoolsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ElasticPoolsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsCreateOrUpdateFuture) Result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ElasticPoolsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ElasticPoolsUpdateFuture) Result(client ElasticPoolsClient) (ep ElasticPool, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ElasticPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.UpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ElasticPoolsUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ElasticPoolUpdate represents an elastic pool update.
type ElasticPoolUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ElasticPoolProperties - The properties representing the resource.
	*ElasticPoolProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ElasticPoolUpdate.
func (epu ElasticPoolUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epu.Tags != nil {
		objectMap["tags"] = epu.Tags
	}
	if epu.ElasticPoolProperties != nil {
		objectMap["properties"] = epu.ElasticPoolProperties
	}
	if epu.ID != nil {
		objectMap["id"] = epu.ID
	}
	if epu.Name != nil {
		objectMap["name"] = epu.Name
	}
	if epu.Type != nil {
		objectMap["type"] = epu.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ElasticPoolUpdate struct.
func (epu *ElasticPoolUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				epu.Tags = tags
			}
		case "properties":
			if v != nil {
				var elasticPoolProperties ElasticPoolProperties
				err = json.Unmarshal(*v, &elasticPoolProperties)
				if err != nil {
					return err
				}
				epu.ElasticPoolProperties = &elasticPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				epu.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				epu.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				epu.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtector the server encryption protector.
type EncryptionProtector struct {
	autorest.Response `json:"-"`
	// Kind - Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// EncryptionProtectorProperties - Resource properties.
	*EncryptionProtectorProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncryptionProtector.
func (ep EncryptionProtector) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Kind != nil {
		objectMap["kind"] = ep.Kind
	}
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.EncryptionProtectorProperties != nil {
		objectMap["properties"] = ep.EncryptionProtectorProperties
	}
	if ep.ID != nil {
		objectMap["id"] = ep.ID
	}
	if ep.Name != nil {
		objectMap["name"] = ep.Name
	}
	if ep.Type != nil {
		objectMap["type"] = ep.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EncryptionProtector struct.
func (ep *EncryptionProtector) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ep.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "properties":
			if v != nil {
				var encryptionProtectorProperties EncryptionProtectorProperties
				err = json.Unmarshal(*v, &encryptionProtectorProperties)
				if err != nil {
					return err
				}
				ep.EncryptionProtectorProperties = &encryptionProtectorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		}
	}

	return nil
}

// EncryptionProtectorListResult a list of server encryption protectors.
type EncryptionProtectorListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]EncryptionProtector `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// EncryptionProtectorListResultIterator provides access to a complete listing of EncryptionProtector
// values.
type EncryptionProtectorListResultIterator struct {
	i    int
	page EncryptionProtectorListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EncryptionProtectorListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EncryptionProtectorListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EncryptionProtectorListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EncryptionProtectorListResultIterator) Response() EncryptionProtectorListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EncryptionProtectorListResultIterator) Value() EncryptionProtector {
	if !iter.page.NotDone() {
		return EncryptionProtector{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EncryptionProtectorListResultIterator type.
func NewEncryptionProtectorListResultIterator(page EncryptionProtectorListResultPage) EncryptionProtectorListResultIterator {
	return EncryptionProtectorListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr EncryptionProtectorListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// encryptionProtectorListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr EncryptionProtectorListResult) encryptionProtectorListResultPreparer(ctx context.Context) (*http.Request, error) {
	if eplr.NextLink == nil || len(to.String(eplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// EncryptionProtectorListResultPage contains a page of EncryptionProtector values.
type EncryptionProtectorListResultPage struct {
	fn   func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)
	eplr EncryptionProtectorListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EncryptionProtectorListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EncryptionProtectorListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.eplr)
	if err != nil {
		return err
	}
	page.eplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EncryptionProtectorListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EncryptionProtectorListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EncryptionProtectorListResultPage) Response() EncryptionProtectorListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EncryptionProtectorListResultPage) Values() []EncryptionProtector {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the EncryptionProtectorListResultPage type.
func NewEncryptionProtectorListResultPage(getNextPage func(context.Context, EncryptionProtectorListResult) (EncryptionProtectorListResult, error)) EncryptionProtectorListResultPage {
	return EncryptionProtectorListResultPage{fn: getNextPage}
}

// EncryptionProtectorProperties properties for an encryption protector execution.
type EncryptionProtectorProperties struct {
	// Subregion - Subregion of the encryption protector.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyName - The name of the server key.
	ServerKeyName *string `json:"serverKeyName,omitempty"`
	// ServerKeyType - The encryption protector type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
}

// EncryptionProtectorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type EncryptionProtectorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *EncryptionProtectorsCreateOrUpdateFuture) Result(client EncryptionProtectorsClient) (ep EncryptionProtector, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.EncryptionProtectorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateOrUpdateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.EncryptionProtectorsCreateOrUpdateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExportRequest export database parameters.
type ExportRequest struct {
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ExtendedDatabaseBlobAuditingPolicy an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedDatabaseBlobAuditingPolicyProperties - Resource properties.
	*ExtendedDatabaseBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedDatabaseBlobAuditingPolicy.
func (edbap ExtendedDatabaseBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if edbap.ExtendedDatabaseBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = edbap.ExtendedDatabaseBlobAuditingPolicyProperties
	}
	if edbap.ID != nil {
		objectMap["id"] = edbap.ID
	}
	if edbap.Name != nil {
		objectMap["name"] = edbap.Name
	}
	if edbap.Type != nil {
		objectMap["type"] = edbap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedDatabaseBlobAuditingPolicy struct.
func (edbap *ExtendedDatabaseBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedDatabaseBlobAuditingPolicyProperties ExtendedDatabaseBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedDatabaseBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				edbap.ExtendedDatabaseBlobAuditingPolicyProperties = &extendedDatabaseBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				edbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				edbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				edbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedDatabaseBlobAuditingPolicyProperties properties of an extended database blob auditing policy.
type ExtendedDatabaseBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture) Result(client ExtendedServerBlobAuditingPoliciesClient) (esbap ExtendedServerBlobAuditingPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if esbap.Response.Response, err = future.GetResult(sender); err == nil && esbap.Response.Response.StatusCode != http.StatusNoContent {
		esbap, err = client.CreateOrUpdateResponder(esbap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ExtendedServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", esbap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtendedServerBlobAuditingPolicy an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ExtendedServerBlobAuditingPolicyProperties - Resource properties.
	*ExtendedServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtendedServerBlobAuditingPolicy.
func (esbap ExtendedServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if esbap.ExtendedServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = esbap.ExtendedServerBlobAuditingPolicyProperties
	}
	if esbap.ID != nil {
		objectMap["id"] = esbap.ID
	}
	if esbap.Name != nil {
		objectMap["name"] = esbap.Name
	}
	if esbap.Type != nil {
		objectMap["type"] = esbap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtendedServerBlobAuditingPolicy struct.
func (esbap *ExtendedServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var extendedServerBlobAuditingPolicyProperties ExtendedServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &extendedServerBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				esbap.ExtendedServerBlobAuditingPolicyProperties = &extendedServerBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				esbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				esbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				esbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtendedServerBlobAuditingPolicyProperties properties of an extended server blob auditing policy.
type ExtendedServerBlobAuditingPolicyProperties struct {
	// PredicateExpression - Specifies condition of where clause when creating an audit.
	PredicateExpression *string `json:"predicateExpression,omitempty"`
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// FailoverGroup a failover group.
type FailoverGroup struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// FailoverGroupProperties - Resource properties.
	*FailoverGroupProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverGroup.
func (fg FailoverGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fg.Location != nil {
		objectMap["location"] = fg.Location
	}
	if fg.Tags != nil {
		objectMap["tags"] = fg.Tags
	}
	if fg.FailoverGroupProperties != nil {
		objectMap["properties"] = fg.FailoverGroupProperties
	}
	if fg.ID != nil {
		objectMap["id"] = fg.ID
	}
	if fg.Name != nil {
		objectMap["name"] = fg.Name
	}
	if fg.Type != nil {
		objectMap["type"] = fg.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroup struct.
func (fg *FailoverGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fg.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fg.Tags = tags
			}
		case "properties":
			if v != nil {
				var failoverGroupProperties FailoverGroupProperties
				err = json.Unmarshal(*v, &failoverGroupProperties)
				if err != nil {
					return err
				}
				fg.FailoverGroupProperties = &failoverGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fg.Type = &typeVar
			}
		}
	}

	return nil
}

// FailoverGroupListResult a list of failover groups.
type FailoverGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]FailoverGroup `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// FailoverGroupListResultIterator provides access to a complete listing of FailoverGroup values.
type FailoverGroupListResultIterator struct {
	i    int
	page FailoverGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *FailoverGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *FailoverGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter FailoverGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter FailoverGroupListResultIterator) Response() FailoverGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter FailoverGroupListResultIterator) Value() FailoverGroup {
	if !iter.page.NotDone() {
		return FailoverGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the FailoverGroupListResultIterator type.
func NewFailoverGroupListResultIterator(page FailoverGroupListResultPage) FailoverGroupListResultIterator {
	return FailoverGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (fglr FailoverGroupListResult) IsEmpty() bool {
	return fglr.Value == nil || len(*fglr.Value) == 0
}

// failoverGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (fglr FailoverGroupListResult) failoverGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if fglr.NextLink == nil || len(to.String(fglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(fglr.NextLink)))
}

// FailoverGroupListResultPage contains a page of FailoverGroup values.
type FailoverGroupListResultPage struct {
	fn   func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)
	fglr FailoverGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *FailoverGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/FailoverGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.fglr)
	if err != nil {
		return err
	}
	page.fglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *FailoverGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page FailoverGroupListResultPage) NotDone() bool {
	return !page.fglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page FailoverGroupListResultPage) Response() FailoverGroupListResult {
	return page.fglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page FailoverGroupListResultPage) Values() []FailoverGroup {
	if page.fglr.IsEmpty() {
		return nil
	}
	return *page.fglr.Value
}

// Creates a new instance of the FailoverGroupListResultPage type.
func NewFailoverGroupListResultPage(getNextPage func(context.Context, FailoverGroupListResult) (FailoverGroupListResult, error)) FailoverGroupListResultPage {
	return FailoverGroupListResultPage{fn: getNextPage}
}

// FailoverGroupProperties properties of a failover group.
type FailoverGroupProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// ReplicationRole - Local replication role of the failover group instance. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
	// ReplicationState - Replication state of the failover group instance.
	ReplicationState *string `json:"replicationState,omitempty"`
	// PartnerServers - List of partner server information for the failover group.
	PartnerServers *[]PartnerInfo `json:"partnerServers,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// FailoverGroupReadOnlyEndpoint read-only endpoint of the failover group instance.
type FailoverGroupReadOnlyEndpoint struct {
	// FailoverPolicy - Failover policy of the read-only endpoint for the failover group. Possible values include: 'ReadOnlyEndpointFailoverPolicyDisabled', 'ReadOnlyEndpointFailoverPolicyEnabled'
	FailoverPolicy ReadOnlyEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
}

// FailoverGroupReadWriteEndpoint read-write endpoint of the failover group instance.
type FailoverGroupReadWriteEndpoint struct {
	// FailoverPolicy - Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Possible values include: 'Manual', 'Automatic'
	FailoverPolicy ReadWriteEndpointFailoverPolicy `json:"failoverPolicy,omitempty"`
	// FailoverWithDataLossGracePeriodMinutes - Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
	FailoverWithDataLossGracePeriodMinutes *int32 `json:"failoverWithDataLossGracePeriodMinutes,omitempty"`
}

// FailoverGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FailoverGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsCreateOrUpdateFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.CreateOrUpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsCreateOrUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsDeleteFuture) Result(client FailoverGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// FailoverGroupsFailoverFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsFailoverFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsFailoverFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.FailoverResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsFailoverFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsForceFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type FailoverGroupsForceFailoverAllowDataLossFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsForceFailoverAllowDataLossFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsForceFailoverAllowDataLossFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.ForceFailoverAllowDataLossResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsForceFailoverAllowDataLossFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type FailoverGroupsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *FailoverGroupsUpdateFuture) Result(client FailoverGroupsClient) (fg FailoverGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.FailoverGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if fg.Response.Response, err = future.GetResult(sender); err == nil && fg.Response.Response.StatusCode != http.StatusNoContent {
		fg, err = client.UpdateResponder(fg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.FailoverGroupsUpdateFuture", "Result", fg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// FailoverGroupUpdate a failover group update request.
type FailoverGroupUpdate struct {
	// FailoverGroupUpdateProperties - Resource properties.
	*FailoverGroupUpdateProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for FailoverGroupUpdate.
func (fgu FailoverGroupUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fgu.FailoverGroupUpdateProperties != nil {
		objectMap["properties"] = fgu.FailoverGroupUpdateProperties
	}
	if fgu.Tags != nil {
		objectMap["tags"] = fgu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FailoverGroupUpdate struct.
func (fgu *FailoverGroupUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var failoverGroupUpdateProperties FailoverGroupUpdateProperties
				err = json.Unmarshal(*v, &failoverGroupUpdateProperties)
				if err != nil {
					return err
				}
				fgu.FailoverGroupUpdateProperties = &failoverGroupUpdateProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				fgu.Tags = tags
			}
		}
	}

	return nil
}

// FailoverGroupUpdateProperties properties of a failover group update.
type FailoverGroupUpdateProperties struct {
	// ReadWriteEndpoint - Read-write endpoint of the failover group instance.
	ReadWriteEndpoint *FailoverGroupReadWriteEndpoint `json:"readWriteEndpoint,omitempty"`
	// ReadOnlyEndpoint - Read-only endpoint of the failover group instance.
	ReadOnlyEndpoint *FailoverGroupReadOnlyEndpoint `json:"readOnlyEndpoint,omitempty"`
	// Databases - List of databases in the failover group.
	Databases *[]string `json:"databases,omitempty"`
}

// FirewallRule represents a server firewall rule.
type FirewallRule struct {
	autorest.Response `json:"-"`
	// Kind - Kind of server that contains this firewall rule.
	Kind *string `json:"kind,omitempty"`
	// Location - Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// FirewallRuleProperties - The properties representing the resource.
	*FirewallRuleProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FirewallRule.
func (fr FirewallRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fr.Kind != nil {
		objectMap["kind"] = fr.Kind
	}
	if fr.Location != nil {
		objectMap["location"] = fr.Location
	}
	if fr.FirewallRuleProperties != nil {
		objectMap["properties"] = fr.FirewallRuleProperties
	}
	if fr.ID != nil {
		objectMap["id"] = fr.ID
	}
	if fr.Name != nil {
		objectMap["name"] = fr.Name
	}
	if fr.Type != nil {
		objectMap["type"] = fr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for FirewallRule struct.
func (fr *FirewallRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				fr.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				fr.Location = &location
			}
		case "properties":
			if v != nil {
				var firewallRuleProperties FirewallRuleProperties
				err = json.Unmarshal(*v, &firewallRuleProperties)
				if err != nil {
					return err
				}
				fr.FirewallRuleProperties = &firewallRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				fr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				fr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				fr.Type = &typeVar
			}
		}
	}

	return nil
}

// FirewallRuleListResult represents the response to a List Firewall Rules request.
type FirewallRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server firewall rules.
	Value *[]FirewallRule `json:"value,omitempty"`
}

// FirewallRuleProperties represents the properties of a server firewall rule.
type FirewallRuleProperties struct {
	// StartIPAddress - The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	StartIPAddress *string `json:"startIpAddress,omitempty"`
	// EndIPAddress - The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' to represent all Azure-internal IP addresses.
	EndIPAddress *string `json:"endIpAddress,omitempty"`
}

// GeoBackupPolicy a database geo backup policy.
type GeoBackupPolicy struct {
	autorest.Response `json:"-"`
	// GeoBackupPolicyProperties - The properties of the geo backup policy.
	*GeoBackupPolicyProperties `json:"properties,omitempty"`
	// Kind - Kind of geo backup policy.  This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Backup policy location.
	Location *string `json:"location,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for GeoBackupPolicy.
func (gbp GeoBackupPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gbp.GeoBackupPolicyProperties != nil {
		objectMap["properties"] = gbp.GeoBackupPolicyProperties
	}
	if gbp.Kind != nil {
		objectMap["kind"] = gbp.Kind
	}
	if gbp.Location != nil {
		objectMap["location"] = gbp.Location
	}
	if gbp.ID != nil {
		objectMap["id"] = gbp.ID
	}
	if gbp.Name != nil {
		objectMap["name"] = gbp.Name
	}
	if gbp.Type != nil {
		objectMap["type"] = gbp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GeoBackupPolicy struct.
func (gbp *GeoBackupPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var geoBackupPolicyProperties GeoBackupPolicyProperties
				err = json.Unmarshal(*v, &geoBackupPolicyProperties)
				if err != nil {
					return err
				}
				gbp.GeoBackupPolicyProperties = &geoBackupPolicyProperties
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				gbp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gbp.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gbp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gbp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gbp.Type = &typeVar
			}
		}
	}

	return nil
}

// GeoBackupPolicyListResult the response to a list geo backup policies request.
type GeoBackupPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of geo backup policies.
	Value *[]GeoBackupPolicy `json:"value,omitempty"`
}

// GeoBackupPolicyProperties the properties of the geo backup policy.
type GeoBackupPolicyProperties struct {
	// State - The state of the geo backup policy. Possible values include: 'GeoBackupPolicyStateDisabled', 'GeoBackupPolicyStateEnabled'
	State GeoBackupPolicyState `json:"state,omitempty"`
	// StorageType - The storage type of the geo backup policy.
	StorageType *string `json:"storageType,omitempty"`
}

// ImportExportResponse response for Import/Export Get operation.
type ImportExportResponse struct {
	autorest.Response `json:"-"`
	// ImportExportResponseProperties - The import/export operation properties.
	*ImportExportResponseProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExportResponse.
func (ier ImportExportResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.ImportExportResponseProperties != nil {
		objectMap["properties"] = ier.ImportExportResponseProperties
	}
	if ier.ID != nil {
		objectMap["id"] = ier.ID
	}
	if ier.Name != nil {
		objectMap["name"] = ier.Name
	}
	if ier.Type != nil {
		objectMap["type"] = ier.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExportResponse struct.
func (ier *ImportExportResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var importExportResponseProperties ImportExportResponseProperties
				err = json.Unmarshal(*v, &importExportResponseProperties)
				if err != nil {
					return err
				}
				ier.ImportExportResponseProperties = &importExportResponseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ier.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		}
	}

	return nil
}

// ImportExportResponseProperties response for Import/Export Status operation.
type ImportExportResponseProperties struct {
	// RequestType - The request type of the operation.
	RequestType *string `json:"requestType,omitempty"`
	// RequestID - The request type of the operation.
	RequestID *uuid.UUID `json:"requestId,omitempty"`
	// ServerName - The name of the server.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Status - The status message returned from the server.
	Status *string `json:"status,omitempty"`
	// LastModifiedTime - The operation status last modified time.
	LastModifiedTime *string `json:"lastModifiedTime,omitempty"`
	// QueuedTime - The operation queued time.
	QueuedTime *string `json:"queuedTime,omitempty"`
	// BlobURI - The blob uri.
	BlobURI *string `json:"blobUri,omitempty"`
	// ErrorMessage - The error message returned from the server.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// ImportExtensionProperties represents the properties for an import operation
type ImportExtensionProperties struct {
	// OperationMode - The type of import operation being performed. This is always Import.
	OperationMode *string `json:"operationMode,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// ImportExtensionRequest import database parameters.
type ImportExtensionRequest struct {
	// Name - The name of the extension.
	Name *string `json:"name,omitempty"`
	// Type - The type of the extension.
	Type *string `json:"type,omitempty"`
	// ImportExtensionProperties - Represents the properties of the resource.
	*ImportExtensionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportExtensionRequest.
func (ier ImportExtensionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ier.Name != nil {
		objectMap["name"] = ier.Name
	}
	if ier.Type != nil {
		objectMap["type"] = ier.Type
	}
	if ier.ImportExtensionProperties != nil {
		objectMap["properties"] = ier.ImportExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportExtensionRequest struct.
func (ier *ImportExtensionRequest) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ier.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ier.Type = &typeVar
			}
		case "properties":
			if v != nil {
				var importExtensionProperties ImportExtensionProperties
				err = json.Unmarshal(*v, &importExtensionProperties)
				if err != nil {
					return err
				}
				ier.ImportExtensionProperties = &importExtensionProperties
			}
		}
	}

	return nil
}

// ImportRequest import database parameters.
type ImportRequest struct {
	// DatabaseName - The name of the database to import.
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - The edition for the database being created. Possible values include: 'Web', 'Business', 'Basic', 'Standard', 'Premium', 'PremiumRS', 'Free', 'Stretch', 'DataWarehouse', 'System', 'System2'
	Edition DatabaseEdition `json:"edition,omitempty"`
	// ServiceObjectiveName - The name of the service objective to assign to the database. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceObjectiveName ServiceObjectiveName `json:"serviceObjectiveName,omitempty"`
	// MaxSizeBytes - The maximum size for the newly imported database.
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// StorageKeyType - The type of the storage key to use. Possible values include: 'StorageAccessKey', 'SharedAccessKey'
	StorageKeyType StorageKeyType `json:"storageKeyType,omitempty"`
	// StorageKey - The storage key to use.  If storage key type is SharedAccessKey, it must be preceded with a "?."
	StorageKey *string `json:"storageKey,omitempty"`
	// StorageURI - The storage uri to use.
	StorageURI *string `json:"storageUri,omitempty"`
	// AdministratorLogin - The name of the SQL administrator.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The password of the SQL administrator.
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// AuthenticationType - The authentication type. Possible values include: 'SQL', 'ADPassword'
	AuthenticationType AuthenticationType `json:"authenticationType,omitempty"`
}

// Job a job.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - Resource properties.
	*JobProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	if j.ID != nil {
		objectMap["id"] = j.ID
	}
	if j.Name != nil {
		objectMap["name"] = j.Name
	}
	if j.Type != nil {
		objectMap["type"] = j.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgent an Azure SQL job agent.
type JobAgent struct {
	autorest.Response `json:"-"`
	// Sku - The name and tier of the SKU.
	Sku *Sku `json:"sku,omitempty"`
	// JobAgentProperties - Resource properties.
	*JobAgentProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobAgent.
func (ja JobAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ja.Sku != nil {
		objectMap["sku"] = ja.Sku
	}
	if ja.JobAgentProperties != nil {
		objectMap["properties"] = ja.JobAgentProperties
	}
	if ja.Location != nil {
		objectMap["location"] = ja.Location
	}
	if ja.Tags != nil {
		objectMap["tags"] = ja.Tags
	}
	if ja.ID != nil {
		objectMap["id"] = ja.ID
	}
	if ja.Name != nil {
		objectMap["name"] = ja.Name
	}
	if ja.Type != nil {
		objectMap["type"] = ja.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobAgent struct.
func (ja *JobAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ja.Sku = &sku
			}
		case "properties":
			if v != nil {
				var jobAgentProperties JobAgentProperties
				err = json.Unmarshal(*v, &jobAgentProperties)
				if err != nil {
					return err
				}
				ja.JobAgentProperties = &jobAgentProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ja.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ja.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ja.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ja.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ja.Type = &typeVar
			}
		}
	}

	return nil
}

// JobAgentListResult a list of Azure SQL job agents.
type JobAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobAgent `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobAgentListResultIterator provides access to a complete listing of JobAgent values.
type JobAgentListResultIterator struct {
	i    int
	page JobAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobAgentListResultIterator) Response() JobAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobAgentListResultIterator) Value() JobAgent {
	if !iter.page.NotDone() {
		return JobAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobAgentListResultIterator type.
func NewJobAgentListResultIterator(page JobAgentListResultPage) JobAgentListResultIterator {
	return JobAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jalr JobAgentListResult) IsEmpty() bool {
	return jalr.Value == nil || len(*jalr.Value) == 0
}

// jobAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jalr JobAgentListResult) jobAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jalr.NextLink == nil || len(to.String(jalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jalr.NextLink)))
}

// JobAgentListResultPage contains a page of JobAgent values.
type JobAgentListResultPage struct {
	fn   func(context.Context, JobAgentListResult) (JobAgentListResult, error)
	jalr JobAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jalr)
	if err != nil {
		return err
	}
	page.jalr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobAgentListResultPage) NotDone() bool {
	return !page.jalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobAgentListResultPage) Response() JobAgentListResult {
	return page.jalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobAgentListResultPage) Values() []JobAgent {
	if page.jalr.IsEmpty() {
		return nil
	}
	return *page.jalr.Value
}

// Creates a new instance of the JobAgentListResultPage type.
func NewJobAgentListResultPage(getNextPage func(context.Context, JobAgentListResult) (JobAgentListResult, error)) JobAgentListResultPage {
	return JobAgentListResultPage{fn: getNextPage}
}

// JobAgentProperties properties of a job agent.
type JobAgentProperties struct {
	// DatabaseID - Resource ID of the database to store job metadata in.
	DatabaseID *string `json:"databaseId,omitempty"`
	// State - The state of the job agent. Possible values include: 'JobAgentStateCreating', 'JobAgentStateReady', 'JobAgentStateUpdating', 'JobAgentStateDeleting', 'JobAgentStateDisabled'
	State JobAgentState `json:"state,omitempty"`
}

// JobAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsCreateOrUpdateFuture) Result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.CreateOrUpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsCreateOrUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsDeleteFuture) Result(client JobAgentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// JobAgentsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobAgentsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobAgentsUpdateFuture) Result(client JobAgentsClient) (ja JobAgent, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobAgentsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ja.Response.Response, err = future.GetResult(sender); err == nil && ja.Response.Response.StatusCode != http.StatusNoContent {
		ja, err = client.UpdateResponder(ja.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobAgentsUpdateFuture", "Result", ja.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobAgentUpdate an update to an Azure SQL job agent.
type JobAgentUpdate struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for JobAgentUpdate.
func (jau JobAgentUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jau.Tags != nil {
		objectMap["tags"] = jau.Tags
	}
	return json.Marshal(objectMap)
}

// JobCredential a stored credential that can be used by a job to connect to target databases.
type JobCredential struct {
	autorest.Response `json:"-"`
	// JobCredentialProperties - Resource properties.
	*JobCredentialProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobCredential.
func (jc JobCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jc.JobCredentialProperties != nil {
		objectMap["properties"] = jc.JobCredentialProperties
	}
	if jc.ID != nil {
		objectMap["id"] = jc.ID
	}
	if jc.Name != nil {
		objectMap["name"] = jc.Name
	}
	if jc.Type != nil {
		objectMap["type"] = jc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobCredential struct.
func (jc *JobCredential) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobCredentialProperties JobCredentialProperties
				err = json.Unmarshal(*v, &jobCredentialProperties)
				if err != nil {
					return err
				}
				jc.JobCredentialProperties = &jobCredentialProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jc.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCredentialListResult a list of job credentials.
type JobCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobCredential `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobCredentialListResultIterator provides access to a complete listing of JobCredential values.
type JobCredentialListResultIterator struct {
	i    int
	page JobCredentialListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCredentialListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCredentialListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCredentialListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCredentialListResultIterator) Response() JobCredentialListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCredentialListResultIterator) Value() JobCredential {
	if !iter.page.NotDone() {
		return JobCredential{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCredentialListResultIterator type.
func NewJobCredentialListResultIterator(page JobCredentialListResultPage) JobCredentialListResultIterator {
	return JobCredentialListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jclr JobCredentialListResult) IsEmpty() bool {
	return jclr.Value == nil || len(*jclr.Value) == 0
}

// jobCredentialListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jclr JobCredentialListResult) jobCredentialListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jclr.NextLink == nil || len(to.String(jclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jclr.NextLink)))
}

// JobCredentialListResultPage contains a page of JobCredential values.
type JobCredentialListResultPage struct {
	fn   func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)
	jclr JobCredentialListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCredentialListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCredentialListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jclr)
	if err != nil {
		return err
	}
	page.jclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCredentialListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCredentialListResultPage) NotDone() bool {
	return !page.jclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCredentialListResultPage) Response() JobCredentialListResult {
	return page.jclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCredentialListResultPage) Values() []JobCredential {
	if page.jclr.IsEmpty() {
		return nil
	}
	return *page.jclr.Value
}

// Creates a new instance of the JobCredentialListResultPage type.
func NewJobCredentialListResultPage(getNextPage func(context.Context, JobCredentialListResult) (JobCredentialListResult, error)) JobCredentialListResultPage {
	return JobCredentialListResultPage{fn: getNextPage}
}

// JobCredentialProperties properties of a job credential.
type JobCredentialProperties struct {
	// Username - The credential user name.
	Username *string `json:"username,omitempty"`
	// Password - The credential password.
	Password *string `json:"password,omitempty"`
}

// JobExecution an execution of a job
type JobExecution struct {
	autorest.Response `json:"-"`
	// JobExecutionProperties - Resource properties.
	*JobExecutionProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobExecution.
func (je JobExecution) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if je.JobExecutionProperties != nil {
		objectMap["properties"] = je.JobExecutionProperties
	}
	if je.ID != nil {
		objectMap["id"] = je.ID
	}
	if je.Name != nil {
		objectMap["name"] = je.Name
	}
	if je.Type != nil {
		objectMap["type"] = je.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobExecution struct.
func (je *JobExecution) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobExecutionProperties JobExecutionProperties
				err = json.Unmarshal(*v, &jobExecutionProperties)
				if err != nil {
					return err
				}
				je.JobExecutionProperties = &jobExecutionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				je.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				je.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				je.Type = &typeVar
			}
		}
	}

	return nil
}

// JobExecutionListResult a list of job executions.
type JobExecutionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobExecution `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobExecutionListResultIterator provides access to a complete listing of JobExecution values.
type JobExecutionListResultIterator struct {
	i    int
	page JobExecutionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobExecutionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobExecutionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobExecutionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobExecutionListResultIterator) Response() JobExecutionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobExecutionListResultIterator) Value() JobExecution {
	if !iter.page.NotDone() {
		return JobExecution{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobExecutionListResultIterator type.
func NewJobExecutionListResultIterator(page JobExecutionListResultPage) JobExecutionListResultIterator {
	return JobExecutionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jelr JobExecutionListResult) IsEmpty() bool {
	return jelr.Value == nil || len(*jelr.Value) == 0
}

// jobExecutionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jelr JobExecutionListResult) jobExecutionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jelr.NextLink == nil || len(to.String(jelr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jelr.NextLink)))
}

// JobExecutionListResultPage contains a page of JobExecution values.
type JobExecutionListResultPage struct {
	fn   func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)
	jelr JobExecutionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobExecutionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobExecutionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jelr)
	if err != nil {
		return err
	}
	page.jelr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobExecutionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobExecutionListResultPage) NotDone() bool {
	return !page.jelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobExecutionListResultPage) Response() JobExecutionListResult {
	return page.jelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobExecutionListResultPage) Values() []JobExecution {
	if page.jelr.IsEmpty() {
		return nil
	}
	return *page.jelr.Value
}

// Creates a new instance of the JobExecutionListResultPage type.
func NewJobExecutionListResultPage(getNextPage func(context.Context, JobExecutionListResult) (JobExecutionListResult, error)) JobExecutionListResultPage {
	return JobExecutionListResultPage{fn: getNextPage}
}

// JobExecutionProperties properties for an Azure SQL Database Elastic job execution.
type JobExecutionProperties struct {
	// JobVersion - The job version number.
	JobVersion *int32 `json:"jobVersion,omitempty"`
	// StepName - The job step name.
	StepName *string `json:"stepName,omitempty"`
	// StepID - The job step id.
	StepID *int32 `json:"stepId,omitempty"`
	// JobExecutionID - The unique identifier of the job execution.
	JobExecutionID *uuid.UUID `json:"jobExecutionId,omitempty"`
	// Lifecycle - The detailed state of the job execution. Possible values include: 'Created', 'InProgress', 'WaitingForChildJobExecutions', 'WaitingForRetry', 'Succeeded', 'SucceededWithSkipped', 'Failed', 'TimedOut', 'Canceled', 'Skipped'
	Lifecycle JobExecutionLifecycle `json:"lifecycle,omitempty"`
	// ProvisioningState - The ARM provisioning state of the job execution. Possible values include: 'ProvisioningStateCreated', 'ProvisioningStateInProgress', 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreateTime - The time that the job execution was created.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - The time that the job execution started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time that the job execution completed.
	EndTime *date.Time `json:"endTime,omitempty"`
	// CurrentAttempts - Number of times the job execution has been attempted.
	CurrentAttempts *int32 `json:"currentAttempts,omitempty"`
	// CurrentAttemptStartTime - Start time of the current attempt.
	CurrentAttemptStartTime *date.Time `json:"currentAttemptStartTime,omitempty"`
	// LastMessage - The last status or error message.
	LastMessage *string `json:"lastMessage,omitempty"`
	// Target - The target that this execution is executed on.
	Target *JobExecutionTarget `json:"target,omitempty"`
}

// JobExecutionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type JobExecutionsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobExecutionsCreateFuture) Result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type JobExecutionsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *JobExecutionsCreateOrUpdateFuture) Result(client JobExecutionsClient) (je JobExecution, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.JobExecutionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if je.Response.Response, err = future.GetResult(sender); err == nil && je.Response.Response.StatusCode != http.StatusNoContent {
		je, err = client.CreateOrUpdateResponder(je.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.JobExecutionsCreateOrUpdateFuture", "Result", je.Response.Response, "Failure responding to request")
		}
	}
	return
}

// JobExecutionTarget the target that a job execution is executed on.
type JobExecutionTarget struct {
	// Type - The type of the target. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - The server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The database name.
	DatabaseName *string `json:"databaseName,omitempty"`
}

// JobListResult a list of jobs.
type JobListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]Job `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobListResultIterator provides access to a complete listing of Job values.
type JobListResultIterator struct {
	i    int
	page JobListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobListResultIterator) Response() JobListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobListResultIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobListResultIterator type.
func NewJobListResultIterator(page JobListResultPage) JobListResultIterator {
	return JobListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jlr JobListResult) IsEmpty() bool {
	return jlr.Value == nil || len(*jlr.Value) == 0
}

// jobListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jlr JobListResult) jobListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jlr.NextLink == nil || len(to.String(jlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jlr.NextLink)))
}

// JobListResultPage contains a page of Job values.
type JobListResultPage struct {
	fn  func(context.Context, JobListResult) (JobListResult, error)
	jlr JobListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jlr)
	if err != nil {
		return err
	}
	page.jlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobListResultPage) NotDone() bool {
	return !page.jlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobListResultPage) Response() JobListResult {
	return page.jlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobListResultPage) Values() []Job {
	if page.jlr.IsEmpty() {
		return nil
	}
	return *page.jlr.Value
}

// Creates a new instance of the JobListResultPage type.
func NewJobListResultPage(getNextPage func(context.Context, JobListResult) (JobListResult, error)) JobListResultPage {
	return JobListResultPage{fn: getNextPage}
}

// JobProperties properties of a job.
type JobProperties struct {
	// Description - User-defined description of the job.
	Description *string `json:"description,omitempty"`
	// Version - The job version number.
	Version *int32 `json:"version,omitempty"`
	// Schedule - Schedule properties of the job.
	Schedule *JobSchedule `json:"schedule,omitempty"`
}

// JobSchedule scheduling properties of a job.
type JobSchedule struct {
	// StartTime - Schedule start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - Schedule end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Type - Schedule interval type. Possible values include: 'Once', 'Recurring'
	Type JobScheduleType `json:"type,omitempty"`
	// Enabled - Whether or not the schedule is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// Interval - Value of the schedule's recurring interval, if the schedule type is recurring. ISO8601 duration format.
	Interval *string `json:"interval,omitempty"`
}

// JobStep a job step.
type JobStep struct {
	autorest.Response `json:"-"`
	// JobStepProperties - Resource properties.
	*JobStepProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStep.
func (js JobStep) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobStepProperties != nil {
		objectMap["properties"] = js.JobStepProperties
	}
	if js.ID != nil {
		objectMap["id"] = js.ID
	}
	if js.Name != nil {
		objectMap["name"] = js.Name
	}
	if js.Type != nil {
		objectMap["type"] = js.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobStep struct.
func (js *JobStep) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobStepProperties JobStepProperties
				err = json.Unmarshal(*v, &jobStepProperties)
				if err != nil {
					return err
				}
				js.JobStepProperties = &jobStepProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				js.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				js.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				js.Type = &typeVar
			}
		}
	}

	return nil
}

// JobStepAction the action to be executed by a job step.
type JobStepAction struct {
	// Type - Type of action being executed by the job step. Possible values include: 'TSQL'
	Type JobStepActionType `json:"type,omitempty"`
	// Source - The source of the action to execute. Possible values include: 'Inline'
	Source JobStepActionSource `json:"source,omitempty"`
	// Value - The action value, for example the text of the T-SQL script to execute.
	Value *string `json:"value,omitempty"`
}

// JobStepExecutionOptions the execution options of a job step.
type JobStepExecutionOptions struct {
	// TimeoutSeconds - Execution timeout for the job step.
	TimeoutSeconds *int32 `json:"timeoutSeconds,omitempty"`
	// RetryAttempts - Maximum number of times the job step will be reattempted if the first attempt fails.
	RetryAttempts *int32 `json:"retryAttempts,omitempty"`
	// InitialRetryIntervalSeconds - Initial delay between retries for job step execution.
	InitialRetryIntervalSeconds *int32 `json:"initialRetryIntervalSeconds,omitempty"`
	// MaximumRetryIntervalSeconds - The maximum amount of time to wait between retries for job step execution.
	MaximumRetryIntervalSeconds *int32 `json:"maximumRetryIntervalSeconds,omitempty"`
	// RetryIntervalBackoffMultiplier - The backoff multiplier for the time between retries.
	RetryIntervalBackoffMultiplier *float64 `json:"retryIntervalBackoffMultiplier,omitempty"`
}

// JobStepListResult a list of job steps.
type JobStepListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobStep `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobStepListResultIterator provides access to a complete listing of JobStep values.
type JobStepListResultIterator struct {
	i    int
	page JobStepListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobStepListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobStepListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobStepListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobStepListResultIterator) Response() JobStepListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobStepListResultIterator) Value() JobStep {
	if !iter.page.NotDone() {
		return JobStep{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobStepListResultIterator type.
func NewJobStepListResultIterator(page JobStepListResultPage) JobStepListResultIterator {
	return JobStepListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jslr JobStepListResult) IsEmpty() bool {
	return jslr.Value == nil || len(*jslr.Value) == 0
}

// jobStepListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jslr JobStepListResult) jobStepListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jslr.NextLink == nil || len(to.String(jslr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jslr.NextLink)))
}

// JobStepListResultPage contains a page of JobStep values.
type JobStepListResultPage struct {
	fn   func(context.Context, JobStepListResult) (JobStepListResult, error)
	jslr JobStepListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobStepListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobStepListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jslr)
	if err != nil {
		return err
	}
	page.jslr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobStepListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobStepListResultPage) NotDone() bool {
	return !page.jslr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobStepListResultPage) Response() JobStepListResult {
	return page.jslr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobStepListResultPage) Values() []JobStep {
	if page.jslr.IsEmpty() {
		return nil
	}
	return *page.jslr.Value
}

// Creates a new instance of the JobStepListResultPage type.
func NewJobStepListResultPage(getNextPage func(context.Context, JobStepListResult) (JobStepListResult, error)) JobStepListResultPage {
	return JobStepListResultPage{fn: getNextPage}
}

// JobStepOutput the output configuration of a job step.
type JobStepOutput struct {
	// Type - The output destination type. Possible values include: 'SQLDatabase'
	Type JobStepOutputType `json:"type,omitempty"`
	// SubscriptionID - The output destination subscription id.
	SubscriptionID *uuid.UUID `json:"subscriptionId,omitempty"`
	// ResourceGroupName - The output destination resource group.
	ResourceGroupName *string `json:"resourceGroupName,omitempty"`
	// ServerName - The output destination server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The output destination database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// SchemaName - The output destination schema.
	SchemaName *string `json:"schemaName,omitempty"`
	// TableName - The output destination table.
	TableName *string `json:"tableName,omitempty"`
	// Credential - The resource ID of the credential to use to connect to the output destination.
	Credential *string `json:"credential,omitempty"`
}

// JobStepProperties properties of a job step.
type JobStepProperties struct {
	// StepID - The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
	StepID *int32 `json:"stepId,omitempty"`
	// TargetGroup - The resource ID of the target group that the job step will be executed on.
	TargetGroup *string `json:"targetGroup,omitempty"`
	// Credential - The resource ID of the job credential that will be used to connect to the targets.
	Credential *string `json:"credential,omitempty"`
	// Action - The action payload of the job step.
	Action *JobStepAction `json:"action,omitempty"`
	// Output - Output destination properties of the job step.
	Output *JobStepOutput `json:"output,omitempty"`
	// ExecutionOptions - Execution options for the job step.
	ExecutionOptions *JobStepExecutionOptions `json:"executionOptions,omitempty"`
}

// JobTarget a job target, for example a specific database or a container of databases that is evaluated
// during job execution.
type JobTarget struct {
	// MembershipType - Whether the target is included or excluded from the group. Possible values include: 'Include', 'Exclude'
	MembershipType JobTargetGroupMembershipType `json:"membershipType,omitempty"`
	// Type - The target type. Possible values include: 'JobTargetTypeTargetGroup', 'JobTargetTypeSQLDatabase', 'JobTargetTypeSQLElasticPool', 'JobTargetTypeSQLShardMap', 'JobTargetTypeSQLServer'
	Type JobTargetType `json:"type,omitempty"`
	// ServerName - The target server name.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - The target database name.
	DatabaseName *string `json:"databaseName,omitempty"`
	// ElasticPoolName - The target elastic pool name.
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// ShardMapName - The target shard map.
	ShardMapName *string `json:"shardMapName,omitempty"`
	// RefreshCredential - The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
	RefreshCredential *string `json:"refreshCredential,omitempty"`
}

// JobTargetGroup a group of job targets.
type JobTargetGroup struct {
	autorest.Response `json:"-"`
	// JobTargetGroupProperties - Resource properties.
	*JobTargetGroupProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobTargetGroup.
func (jtg JobTargetGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jtg.JobTargetGroupProperties != nil {
		objectMap["properties"] = jtg.JobTargetGroupProperties
	}
	if jtg.ID != nil {
		objectMap["id"] = jtg.ID
	}
	if jtg.Name != nil {
		objectMap["name"] = jtg.Name
	}
	if jtg.Type != nil {
		objectMap["type"] = jtg.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobTargetGroup struct.
func (jtg *JobTargetGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobTargetGroupProperties JobTargetGroupProperties
				err = json.Unmarshal(*v, &jobTargetGroupProperties)
				if err != nil {
					return err
				}
				jtg.JobTargetGroupProperties = &jobTargetGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jtg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jtg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jtg.Type = &typeVar
			}
		}
	}

	return nil
}

// JobTargetGroupListResult a list of target groups.
type JobTargetGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobTargetGroup `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobTargetGroupListResultIterator provides access to a complete listing of JobTargetGroup values.
type JobTargetGroupListResultIterator struct {
	i    int
	page JobTargetGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobTargetGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobTargetGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobTargetGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobTargetGroupListResultIterator) Response() JobTargetGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobTargetGroupListResultIterator) Value() JobTargetGroup {
	if !iter.page.NotDone() {
		return JobTargetGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobTargetGroupListResultIterator type.
func NewJobTargetGroupListResultIterator(page JobTargetGroupListResultPage) JobTargetGroupListResultIterator {
	return JobTargetGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jtglr JobTargetGroupListResult) IsEmpty() bool {
	return jtglr.Value == nil || len(*jtglr.Value) == 0
}

// jobTargetGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jtglr JobTargetGroupListResult) jobTargetGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jtglr.NextLink == nil || len(to.String(jtglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jtglr.NextLink)))
}

// JobTargetGroupListResultPage contains a page of JobTargetGroup values.
type JobTargetGroupListResultPage struct {
	fn    func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)
	jtglr JobTargetGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobTargetGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobTargetGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jtglr)
	if err != nil {
		return err
	}
	page.jtglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobTargetGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobTargetGroupListResultPage) NotDone() bool {
	return !page.jtglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobTargetGroupListResultPage) Response() JobTargetGroupListResult {
	return page.jtglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobTargetGroupListResultPage) Values() []JobTargetGroup {
	if page.jtglr.IsEmpty() {
		return nil
	}
	return *page.jtglr.Value
}

// Creates a new instance of the JobTargetGroupListResultPage type.
func NewJobTargetGroupListResultPage(getNextPage func(context.Context, JobTargetGroupListResult) (JobTargetGroupListResult, error)) JobTargetGroupListResultPage {
	return JobTargetGroupListResultPage{fn: getNextPage}
}

// JobTargetGroupProperties properties of job target group.
type JobTargetGroupProperties struct {
	// Members - Members of the target group.
	Members *[]JobTarget `json:"members,omitempty"`
}

// JobVersion a job version.
type JobVersion struct {
	autorest.Response `json:"-"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// JobVersionListResult a list of job versions.
type JobVersionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]JobVersion `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobVersionListResultIterator provides access to a complete listing of JobVersion values.
type JobVersionListResultIterator struct {
	i    int
	page JobVersionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobVersionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobVersionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobVersionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobVersionListResultIterator) Response() JobVersionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobVersionListResultIterator) Value() JobVersion {
	if !iter.page.NotDone() {
		return JobVersion{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobVersionListResultIterator type.
func NewJobVersionListResultIterator(page JobVersionListResultPage) JobVersionListResultIterator {
	return JobVersionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jvlr JobVersionListResult) IsEmpty() bool {
	return jvlr.Value == nil || len(*jvlr.Value) == 0
}

// jobVersionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jvlr JobVersionListResult) jobVersionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if jvlr.NextLink == nil || len(to.String(jvlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jvlr.NextLink)))
}

// JobVersionListResultPage contains a page of JobVersion values.
type JobVersionListResultPage struct {
	fn   func(context.Context, JobVersionListResult) (JobVersionListResult, error)
	jvlr JobVersionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobVersionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobVersionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.jvlr)
	if err != nil {
		return err
	}
	page.jvlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobVersionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobVersionListResultPage) NotDone() bool {
	return !page.jvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobVersionListResultPage) Response() JobVersionListResult {
	return page.jvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobVersionListResultPage) Values() []JobVersion {
	if page.jvlr.IsEmpty() {
		return nil
	}
	return *page.jvlr.Value
}

// Creates a new instance of the JobVersionListResultPage type.
func NewJobVersionListResultPage(getNextPage func(context.Context, JobVersionListResult) (JobVersionListResult, error)) JobVersionListResultPage {
	return JobVersionListResultPage{fn: getNextPage}
}

// LocationCapabilities the capabilities for a location.
type LocationCapabilities struct {
	autorest.Response `json:"-"`
	// Name - The location name.
	Name *string `json:"name,omitempty"`
	// Status - Azure SQL Database's status for the location. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedServerVersions - The list of supported server versions.
	SupportedServerVersions *[]ServerVersionCapability `json:"supportedServerVersions,omitempty"`
}

// LogicalServerSecurityAlertPolicyListResult a list of the server's security alert policies.
type LogicalServerSecurityAlertPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ServerSecurityAlertPolicy `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// LogicalServerSecurityAlertPolicyListResultIterator provides access to a complete listing of
// ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultIterator struct {
	i    int
	page LogicalServerSecurityAlertPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LogicalServerSecurityAlertPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Response() LogicalServerSecurityAlertPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LogicalServerSecurityAlertPolicyListResultIterator) Value() ServerSecurityAlertPolicy {
	if !iter.page.NotDone() {
		return ServerSecurityAlertPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultIterator type.
func NewLogicalServerSecurityAlertPolicyListResultIterator(page LogicalServerSecurityAlertPolicyListResultPage) LogicalServerSecurityAlertPolicyListResultIterator {
	return LogicalServerSecurityAlertPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) IsEmpty() bool {
	return lssaplr.Value == nil || len(*lssaplr.Value) == 0
}

// logicalServerSecurityAlertPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lssaplr LogicalServerSecurityAlertPolicyListResult) logicalServerSecurityAlertPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if lssaplr.NextLink == nil || len(to.String(lssaplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lssaplr.NextLink)))
}

// LogicalServerSecurityAlertPolicyListResultPage contains a page of ServerSecurityAlertPolicy values.
type LogicalServerSecurityAlertPolicyListResultPage struct {
	fn      func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)
	lssaplr LogicalServerSecurityAlertPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LogicalServerSecurityAlertPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LogicalServerSecurityAlertPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lssaplr)
	if err != nil {
		return err
	}
	page.lssaplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LogicalServerSecurityAlertPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LogicalServerSecurityAlertPolicyListResultPage) NotDone() bool {
	return !page.lssaplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LogicalServerSecurityAlertPolicyListResultPage) Response() LogicalServerSecurityAlertPolicyListResult {
	return page.lssaplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LogicalServerSecurityAlertPolicyListResultPage) Values() []ServerSecurityAlertPolicy {
	if page.lssaplr.IsEmpty() {
		return nil
	}
	return *page.lssaplr.Value
}

// Creates a new instance of the LogicalServerSecurityAlertPolicyListResultPage type.
func NewLogicalServerSecurityAlertPolicyListResultPage(getNextPage func(context.Context, LogicalServerSecurityAlertPolicyListResult) (LogicalServerSecurityAlertPolicyListResult, error)) LogicalServerSecurityAlertPolicyListResultPage {
	return LogicalServerSecurityAlertPolicyListResultPage{fn: getNextPage}
}

// ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture) Result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.CreateOrUpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesCreateOrUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPoliciesUpdateFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type ManagedBackupShortTermRetentionPoliciesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedBackupShortTermRetentionPoliciesUpdateFuture) Result(client ManagedBackupShortTermRetentionPoliciesClient) (mbstrp ManagedBackupShortTermRetentionPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mbstrp.Response.Response, err = future.GetResult(sender); err == nil && mbstrp.Response.Response.StatusCode != http.StatusNoContent {
		mbstrp, err = client.UpdateResponder(mbstrp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedBackupShortTermRetentionPoliciesUpdateFuture", "Result", mbstrp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedBackupShortTermRetentionPolicy a short term retention policy.
type ManagedBackupShortTermRetentionPolicy struct {
	autorest.Response `json:"-"`
	// ManagedBackupShortTermRetentionPolicyProperties - Resource properties.
	*ManagedBackupShortTermRetentionPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedBackupShortTermRetentionPolicy.
func (mbstrp ManagedBackupShortTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mbstrp.ManagedBackupShortTermRetentionPolicyProperties != nil {
		objectMap["properties"] = mbstrp.ManagedBackupShortTermRetentionPolicyProperties
	}
	if mbstrp.ID != nil {
		objectMap["id"] = mbstrp.ID
	}
	if mbstrp.Name != nil {
		objectMap["name"] = mbstrp.Name
	}
	if mbstrp.Type != nil {
		objectMap["type"] = mbstrp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedBackupShortTermRetentionPolicy struct.
func (mbstrp *ManagedBackupShortTermRetentionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedBackupShortTermRetentionPolicyProperties ManagedBackupShortTermRetentionPolicyProperties
				err = json.Unmarshal(*v, &managedBackupShortTermRetentionPolicyProperties)
				if err != nil {
					return err
				}
				mbstrp.ManagedBackupShortTermRetentionPolicyProperties = &managedBackupShortTermRetentionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mbstrp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mbstrp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mbstrp.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedBackupShortTermRetentionPolicyListResult a list of short term retention policies.
type ManagedBackupShortTermRetentionPolicyListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ManagedBackupShortTermRetentionPolicy `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedBackupShortTermRetentionPolicyListResultIterator provides access to a complete listing of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultIterator struct {
	i    int
	page ManagedBackupShortTermRetentionPolicyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedBackupShortTermRetentionPolicyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedBackupShortTermRetentionPolicyListResultIterator) Value() ManagedBackupShortTermRetentionPolicy {
	if !iter.page.NotDone() {
		return ManagedBackupShortTermRetentionPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultIterator type.
func NewManagedBackupShortTermRetentionPolicyListResultIterator(page ManagedBackupShortTermRetentionPolicyListResultPage) ManagedBackupShortTermRetentionPolicyListResultIterator {
	return ManagedBackupShortTermRetentionPolicyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) IsEmpty() bool {
	return mbstrplr.Value == nil || len(*mbstrplr.Value) == 0
}

// managedBackupShortTermRetentionPolicyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mbstrplr ManagedBackupShortTermRetentionPolicyListResult) managedBackupShortTermRetentionPolicyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if mbstrplr.NextLink == nil || len(to.String(mbstrplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mbstrplr.NextLink)))
}

// ManagedBackupShortTermRetentionPolicyListResultPage contains a page of
// ManagedBackupShortTermRetentionPolicy values.
type ManagedBackupShortTermRetentionPolicyListResultPage struct {
	fn       func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)
	mbstrplr ManagedBackupShortTermRetentionPolicyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedBackupShortTermRetentionPolicyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mbstrplr)
	if err != nil {
		return err
	}
	page.mbstrplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedBackupShortTermRetentionPolicyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) NotDone() bool {
	return !page.mbstrplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Response() ManagedBackupShortTermRetentionPolicyListResult {
	return page.mbstrplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedBackupShortTermRetentionPolicyListResultPage) Values() []ManagedBackupShortTermRetentionPolicy {
	if page.mbstrplr.IsEmpty() {
		return nil
	}
	return *page.mbstrplr.Value
}

// Creates a new instance of the ManagedBackupShortTermRetentionPolicyListResultPage type.
func NewManagedBackupShortTermRetentionPolicyListResultPage(getNextPage func(context.Context, ManagedBackupShortTermRetentionPolicyListResult) (ManagedBackupShortTermRetentionPolicyListResult, error)) ManagedBackupShortTermRetentionPolicyListResultPage {
	return ManagedBackupShortTermRetentionPolicyListResultPage{fn: getNextPage}
}

// ManagedBackupShortTermRetentionPolicyProperties properties of a short term retention policy
type ManagedBackupShortTermRetentionPolicyProperties struct {
	// RetentionDays - The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
}

// ManagedDatabase a managed database resource.
type ManagedDatabase struct {
	autorest.Response `json:"-"`
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedDatabase.
func (md ManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.ManagedDatabaseProperties != nil {
		objectMap["properties"] = md.ManagedDatabaseProperties
	}
	if md.Location != nil {
		objectMap["location"] = md.Location
	}
	if md.Tags != nil {
		objectMap["tags"] = md.Tags
	}
	if md.ID != nil {
		objectMap["id"] = md.ID
	}
	if md.Name != nil {
		objectMap["name"] = md.Name
	}
	if md.Type != nil {
		objectMap["type"] = md.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabase struct.
func (md *ManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				md.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				md.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				md.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				md.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				md.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				md.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedDatabaseListResult a list of managed databases.
type ManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ManagedDatabase `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedDatabaseListResultIterator provides access to a complete listing of ManagedDatabase values.
type ManagedDatabaseListResultIterator struct {
	i    int
	page ManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedDatabaseListResultIterator) Response() ManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedDatabaseListResultIterator) Value() ManagedDatabase {
	if !iter.page.NotDone() {
		return ManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedDatabaseListResultIterator type.
func NewManagedDatabaseListResultIterator(page ManagedDatabaseListResultPage) ManagedDatabaseListResultIterator {
	return ManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mdlr ManagedDatabaseListResult) IsEmpty() bool {
	return mdlr.Value == nil || len(*mdlr.Value) == 0
}

// managedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mdlr ManagedDatabaseListResult) managedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if mdlr.NextLink == nil || len(to.String(mdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mdlr.NextLink)))
}

// ManagedDatabaseListResultPage contains a page of ManagedDatabase values.
type ManagedDatabaseListResultPage struct {
	fn   func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)
	mdlr ManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.mdlr)
	if err != nil {
		return err
	}
	page.mdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedDatabaseListResultPage) NotDone() bool {
	return !page.mdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedDatabaseListResultPage) Response() ManagedDatabaseListResult {
	return page.mdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedDatabaseListResultPage) Values() []ManagedDatabase {
	if page.mdlr.IsEmpty() {
		return nil
	}
	return *page.mdlr.Value
}

// Creates a new instance of the ManagedDatabaseListResultPage type.
func NewManagedDatabaseListResultPage(getNextPage func(context.Context, ManagedDatabaseListResult) (ManagedDatabaseListResult, error)) ManagedDatabaseListResultPage {
	return ManagedDatabaseListResultPage{fn: getNextPage}
}

// ManagedDatabaseProperties the managed database's properties.
type ManagedDatabaseProperties struct {
	// Collation - Collation of the managed database.
	Collation *string `json:"collation,omitempty"`
	// Status - Status of the database. Possible values include: 'Online', 'Offline', 'Shutdown', 'Creating', 'Inaccessible', 'Updating'
	Status ManagedDatabaseStatus `json:"status,omitempty"`
	// CreationDate - Creation date of the database.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// EarliestRestorePoint - Earliest restore point in time for point in time restore.
	EarliestRestorePoint *date.Time `json:"earliestRestorePoint,omitempty"`
	// RestorePointInTime - Conditional. If createMode is PointInTimeRestore, this value is required. Specifies the point in time (ISO8601 format) of the source database that will be restored to create the new database.
	RestorePointInTime *date.Time `json:"restorePointInTime,omitempty"`
	// DefaultSecondaryLocation - Geo paired region.
	DefaultSecondaryLocation *string `json:"defaultSecondaryLocation,omitempty"`
	// CatalogCollation - Collation of the metadata catalog. Possible values include: 'DATABASEDEFAULT', 'SQLLatin1GeneralCP1CIAS'
	CatalogCollation CatalogCollationType `json:"catalogCollation,omitempty"`
	// CreateMode - Managed database create mode. PointInTimeRestore: Create a database by restoring a point in time backup of an existing database. SourceDatabaseName, SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a database by restoring from external backup files. Collation, StorageContainerUri and StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database resource ID to restore. Possible values include: 'ManagedDatabaseCreateModeDefault', 'ManagedDatabaseCreateModeRestoreExternalBackup', 'ManagedDatabaseCreateModePointInTimeRestore', 'ManagedDatabaseCreateModeRecovery'
	CreateMode ManagedDatabaseCreateMode `json:"createMode,omitempty"`
	// StorageContainerURI - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the uri of the storage container where backups for this restore are stored.
	StorageContainerURI *string `json:"storageContainerUri,omitempty"`
	// SourceDatabaseID - The resource identifier of the source database associated with create operation of this database.
	SourceDatabaseID *string `json:"sourceDatabaseId,omitempty"`
	// RestorableDroppedDatabaseID - The restorable dropped database resource id to restore when creating this database.
	RestorableDroppedDatabaseID *string `json:"restorableDroppedDatabaseId,omitempty"`
	// StorageContainerSasToken - Conditional. If createMode is RestoreExternalBackup, this value is required. Specifies the storage container sas token.
	StorageContainerSasToken *string `json:"storageContainerSasToken,omitempty"`
	// FailoverGroupID - Instance Failover Group resource identifier that this managed database belongs to.
	FailoverGroupID *string `json:"failoverGroupId,omitempty"`
	// RecoverableDatabaseID - The resource identifier of the recoverable database associated with create operation of this database.
	RecoverableDatabaseID *string `json:"recoverableDatabaseId,omitempty"`
}

// ManagedDatabasesCompleteRestoreFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCompleteRestoreFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesCompleteRestoreFuture) Result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCompleteRestoreFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCompleteRestoreFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedDatabasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesCreateOrUpdateFuture) Result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.CreateOrUpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesCreateOrUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesDeleteFuture) Result(client ManagedDatabasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedDatabasesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedDatabasesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedDatabasesUpdateFuture) Result(client ManagedDatabasesClient) (md ManagedDatabase, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedDatabasesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if md.Response.Response, err = future.GetResult(sender); err == nil && md.Response.Response.StatusCode != http.StatusNoContent {
		md, err = client.UpdateResponder(md.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedDatabasesUpdateFuture", "Result", md.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedDatabaseUpdate an managed database update.
type ManagedDatabaseUpdate struct {
	// ManagedDatabaseProperties - Resource properties.
	*ManagedDatabaseProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedDatabaseUpdate.
func (mdu ManagedDatabaseUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdu.ManagedDatabaseProperties != nil {
		objectMap["properties"] = mdu.ManagedDatabaseProperties
	}
	if mdu.Tags != nil {
		objectMap["tags"] = mdu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedDatabaseUpdate struct.
func (mdu *ManagedDatabaseUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var managedDatabaseProperties ManagedDatabaseProperties
				err = json.Unmarshal(*v, &managedDatabaseProperties)
				if err != nil {
					return err
				}
				mdu.ManagedDatabaseProperties = &managedDatabaseProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdu.Tags = tags
			}
		}
	}

	return nil
}

// ManagedInstance an Azure SQL managed instance.
type ManagedInstance struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the managed instance.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Sku - Managed instance sku
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedInstance.
func (mi ManagedInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mi.Identity != nil {
		objectMap["identity"] = mi.Identity
	}
	if mi.Sku != nil {
		objectMap["sku"] = mi.Sku
	}
	if mi.ManagedInstanceProperties != nil {
		objectMap["properties"] = mi.ManagedInstanceProperties
	}
	if mi.Location != nil {
		objectMap["location"] = mi.Location
	}
	if mi.Tags != nil {
		objectMap["tags"] = mi.Tags
	}
	if mi.ID != nil {
		objectMap["id"] = mi.ID
	}
	if mi.Name != nil {
		objectMap["name"] = mi.Name
	}
	if mi.Type != nil {
		objectMap["type"] = mi.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstance struct.
func (mi *ManagedInstance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				mi.Identity = &identity
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mi.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				mi.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mi.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mi.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mi.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mi.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mi.Type = &typeVar
			}
		}
	}

	return nil
}

// ManagedInstanceListResult a list of managed instances.
type ManagedInstanceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ManagedInstance `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedInstanceListResultIterator provides access to a complete listing of ManagedInstance values.
type ManagedInstanceListResultIterator struct {
	i    int
	page ManagedInstanceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedInstanceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedInstanceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedInstanceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedInstanceListResultIterator) Response() ManagedInstanceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedInstanceListResultIterator) Value() ManagedInstance {
	if !iter.page.NotDone() {
		return ManagedInstance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedInstanceListResultIterator type.
func NewManagedInstanceListResultIterator(page ManagedInstanceListResultPage) ManagedInstanceListResultIterator {
	return ManagedInstanceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (milr ManagedInstanceListResult) IsEmpty() bool {
	return milr.Value == nil || len(*milr.Value) == 0
}

// managedInstanceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (milr ManagedInstanceListResult) managedInstanceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if milr.NextLink == nil || len(to.String(milr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(milr.NextLink)))
}

// ManagedInstanceListResultPage contains a page of ManagedInstance values.
type ManagedInstanceListResultPage struct {
	fn   func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)
	milr ManagedInstanceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedInstanceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedInstanceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.milr)
	if err != nil {
		return err
	}
	page.milr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedInstanceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedInstanceListResultPage) NotDone() bool {
	return !page.milr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedInstanceListResultPage) Response() ManagedInstanceListResult {
	return page.milr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedInstanceListResultPage) Values() []ManagedInstance {
	if page.milr.IsEmpty() {
		return nil
	}
	return *page.milr.Value
}

// Creates a new instance of the ManagedInstanceListResultPage type.
func NewManagedInstanceListResultPage(getNextPage func(context.Context, ManagedInstanceListResult) (ManagedInstanceListResult, error)) ManagedInstanceListResultPage {
	return ManagedInstanceListResultPage{fn: getNextPage}
}

// ManagedInstanceProperties the properties of a managed instance.
type ManagedInstanceProperties struct {
	// FullyQualifiedDomainName - The fully qualified domain name of the managed instance.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
	// AdministratorLogin - Administrator username for the managed instance. Can only be specified when the managed instance is being created (and is required for creation).
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for managed instance creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// SubnetID - Subnet resource ID for the managed instance.
	SubnetID *string `json:"subnetId,omitempty"`
	// State - The state of the managed instance.
	State *string `json:"state,omitempty"`
	// LicenseType - The license type. Possible values are 'LicenseIncluded' and 'BasePrice'.
	LicenseType *string `json:"licenseType,omitempty"`
	// VCores - The number of VCores.
	VCores *int32 `json:"vCores,omitempty"`
	// StorageSizeInGB - The maximum storage size in GB.
	StorageSizeInGB *int32 `json:"storageSizeInGB,omitempty"`
	// Collation - Collation of the managed instance.
	Collation *string `json:"collation,omitempty"`
	// DNSZone - The Dns Zone that the managed instance is in.
	DNSZone *string `json:"dnsZone,omitempty"`
	// DNSZonePartner - The resource id of another managed instance whose DNS zone this managed instance will share after creation.
	DNSZonePartner *string `json:"dnsZonePartner,omitempty"`
	// PublicDataEndpointEnabled - Whether or not the public data endpoint is enabled.
	PublicDataEndpointEnabled *bool `json:"publicDataEndpointEnabled,omitempty"`
	// ProxyOverride - Connection type used for connecting to the instance. Possible values include: 'ManagedInstanceProxyOverrideProxy', 'ManagedInstanceProxyOverrideRedirect', 'ManagedInstanceProxyOverrideDefault'
	ProxyOverride ManagedInstanceProxyOverride `json:"proxyOverride,omitempty"`
	// TimezoneID - Id of the timezone. Allowed values are timezones supported by Windows.
	// Windows keeps details on supported timezones, including the id, in registry under
	// KEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones.
	// You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM sys.time_zone_info.
	// List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in PowerShell.
	// An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
	TimezoneID *string `json:"timezoneId,omitempty"`
}

// ManagedInstancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedInstancesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesCreateOrUpdateFuture) Result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.CreateOrUpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesCreateOrUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesDeleteFuture) Result(client ManagedInstancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedInstancesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedInstancesUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ManagedInstancesUpdateFuture) Result(client ManagedInstancesClient) (mi ManagedInstance, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ManagedInstancesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mi.Response.Response, err = future.GetResult(sender); err == nil && mi.Response.Response.StatusCode != http.StatusNoContent {
		mi, err = client.UpdateResponder(mi.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ManagedInstancesUpdateFuture", "Result", mi.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedInstanceUpdate an update request for an Azure SQL Database managed instance.
type ManagedInstanceUpdate struct {
	// Sku - Managed instance sku
	Sku *Sku `json:"sku,omitempty"`
	// ManagedInstanceProperties - Resource properties.
	*ManagedInstanceProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ManagedInstanceUpdate.
func (miu ManagedInstanceUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if miu.Sku != nil {
		objectMap["sku"] = miu.Sku
	}
	if miu.ManagedInstanceProperties != nil {
		objectMap["properties"] = miu.ManagedInstanceProperties
	}
	if miu.Tags != nil {
		objectMap["tags"] = miu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ManagedInstanceUpdate struct.
func (miu *ManagedInstanceUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				miu.Sku = &sku
			}
		case "properties":
			if v != nil {
				var managedInstanceProperties ManagedInstanceProperties
				err = json.Unmarshal(*v, &managedInstanceProperties)
				if err != nil {
					return err
				}
				miu.ManagedInstanceProperties = &managedInstanceProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				miu.Tags = tags
			}
		}
	}

	return nil
}

// MaxSizeCapability the maximum size limits for a database.
type MaxSizeCapability struct {
	// Limit - The maximum size of the database (see 'unit' for the units).
	Limit *int64 `json:"limit,omitempty"`
	// Unit - The units that the limit is expressed in. Possible values include: 'Megabytes', 'Gigabytes', 'Terabytes', 'Petabytes'
	Unit MaxSizeUnits `json:"unit,omitempty"`
	// Status - The status of the maximum size capability. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
}

// Metric database metrics.
type Metric struct {
	// StartTime - The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - The time step to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'UnitTypeCount', 'UnitTypeBytes', 'UnitTypeSeconds', 'UnitTypePercent', 'UnitTypeCountPerSecond', 'UnitTypeBytesPerSecond'
	Unit UnitType `json:"unit,omitempty"`
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MetricAvailability a metric availability value.
type MetricAvailability struct {
	// Retention - The length of retention for the database metric.
	Retention *string `json:"retention,omitempty"`
	// TimeGrain - The granularity of the database metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// MetricDefinition a database metric definition.
type MetricDefinition struct {
	// Name - The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// PrimaryAggregationType - The primary aggregation type defining how metric values are displayed. Possible values include: 'None', 'Average', 'Count', 'Minimum', 'Maximum', 'Total'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// ResourceURI - The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'UnitDefinitionTypeCount', 'UnitDefinitionTypeBytes', 'UnitDefinitionTypeSeconds', 'UnitDefinitionTypePercent', 'UnitDefinitionTypeCountPerSecond', 'UnitDefinitionTypeBytesPerSecond'
	Unit UnitDefinitionType `json:"unit,omitempty"`
	// MetricAvailabilities - The list of database metric availabilities for the metric.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
}

// MetricDefinitionListResult the response to a list database metric definitions request.
type MetricDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metric definitions for the database.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list database metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of metrics for the database.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a database metric name.
type MetricName struct {
	// Value - The name of the database metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - The friendly name of the database metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents database metrics.
type MetricValue struct {
	// Count - The number of values for the metric.
	Count *float64 `json:"count,omitempty"`
	// Average - The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// Operation SQL REST API operation definition.
type Operation struct {
	// Name - The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation. Possible values include: 'OperationOriginUser', 'OperationOriginSystem'
	Origin OperationOrigin `json:"origin,omitempty"`
	// Properties - Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != "" {
		objectMap["origin"] = o.Origin
	}
	if o.Properties != nil {
		objectMap["properties"] = o.Properties
	}
	return json.Marshal(objectMap)
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty"`
	// Operation - The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - The localized friendly description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationImpact the impact of an operation, both in absolute and relative terms.
type OperationImpact struct {
	// Name - The name of the impact dimension.
	Name *string `json:"name,omitempty"`
	// Unit - The unit in which estimated impact to dimension is measured.
	Unit *string `json:"unit,omitempty"`
	// ChangeValueAbsolute - The absolute impact to dimension.
	ChangeValueAbsolute *float64 `json:"changeValueAbsolute,omitempty"`
	// ChangeValueRelative - The relative impact to dimension (null if not applicable)
	ChangeValueRelative *float64 `json:"changeValueRelative,omitempty"`
}

// OperationListResult result of the request to list SQL operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{fn: getNextPage}
}

// PartnerInfo partner server information for the failover group.
type PartnerInfo struct {
	// ID - Resource identifier of the partner server.
	ID *string `json:"id,omitempty"`
	// Location - Geo location of the partner server.
	Location *string `json:"location,omitempty"`
	// ReplicationRole - Replication role of the partner server. Possible values include: 'Primary', 'Secondary'
	ReplicationRole FailoverGroupReplicationRole `json:"replicationRole,omitempty"`
}

// PerformanceLevel a possible performance level of a service objective capability.
type PerformanceLevel struct {
	// Unit - Unit type used to measure service objective performance level. Possible values include: 'DTU'
	Unit PerformanceLevelUnit `json:"unit,omitempty"`
	// Value - Performance level value.
	Value *int32 `json:"value,omitempty"`
}

// ProxyResource ARM proxy resource.
type ProxyResource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// RecommendedIndex represents a database recommended index.
type RecommendedIndex struct {
	// RecommendedIndexProperties - The properties representing the resource.
	*RecommendedIndexProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecommendedIndex.
func (ri RecommendedIndex) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ri.RecommendedIndexProperties != nil {
		objectMap["properties"] = ri.RecommendedIndexProperties
	}
	if ri.ID != nil {
		objectMap["id"] = ri.ID
	}
	if ri.Name != nil {
		objectMap["name"] = ri.Name
	}
	if ri.Type != nil {
		objectMap["type"] = ri.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecommendedIndex struct.
func (ri *RecommendedIndex) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recommendedIndexProperties RecommendedIndexProperties
				err = json.Unmarshal(*v, &recommendedIndexProperties)
				if err != nil {
					return err
				}
				ri.RecommendedIndexProperties = &recommendedIndexProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ri.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ri.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ri.Type = &typeVar
			}
		}
	}

	return nil
}

// RecommendedIndexProperties represents the properties of a database recommended index.
type RecommendedIndexProperties struct {
	// Action - The proposed index action. You can create a missing index, drop an unused index, or rebuild an existing index to improve its performance. Possible values include: 'Create', 'Drop', 'Rebuild'
	Action RecommendedIndexAction `json:"action,omitempty"`
	// State - The current recommendation state. Possible values include: 'Active', 'Pending', 'Executing', 'Verifying', 'PendingRevert', 'Reverting', 'Reverted', 'Ignored', 'Expired', 'Blocked', 'Success'
	State RecommendedIndexState `json:"state,omitempty"`
	// Created - The UTC datetime showing when this resource was created (ISO8601 format).
	Created *date.Time `json:"created,omitempty"`
	// LastModified - The UTC datetime of when was this resource last changed (ISO8601 format).
	LastModified *date.Time `json:"lastModified,omitempty"`
	// IndexType - The type of index (CLUSTERED, NONCLUSTERED, COLUMNSTORE, CLUSTERED COLUMNSTORE). Possible values include: 'CLUSTERED', 'NONCLUSTERED', 'COLUMNSTORE', 'CLUSTEREDCOLUMNSTORE'
	IndexType RecommendedIndexType `json:"indexType,omitempty"`
	// Schema - The schema where table to build index over resides
	Schema *string `json:"schema,omitempty"`
	// Table - The table on which to build index.
	Table *string `json:"table,omitempty"`
	// Columns - Columns over which to build index
	Columns *[]string `json:"columns,omitempty"`
	// IncludedColumns - The list of column names to be included in the index
	IncludedColumns *[]string `json:"includedColumns,omitempty"`
	// IndexScript - The full build index script
	IndexScript *string `json:"indexScript,omitempty"`
	// EstimatedImpact - The estimated impact of doing recommended index action.
	EstimatedImpact *[]OperationImpact `json:"estimatedImpact,omitempty"`
	// ReportedImpact - The values reported after index action is complete.
	ReportedImpact *[]OperationImpact `json:"reportedImpact,omitempty"`
}

// RecoverableDatabase a recoverable database
type RecoverableDatabase struct {
	autorest.Response `json:"-"`
	// RecoverableDatabaseProperties - The properties of a recoverable database
	*RecoverableDatabaseProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoverableDatabase.
func (rd RecoverableDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rd.RecoverableDatabaseProperties != nil {
		objectMap["properties"] = rd.RecoverableDatabaseProperties
	}
	if rd.ID != nil {
		objectMap["id"] = rd.ID
	}
	if rd.Name != nil {
		objectMap["name"] = rd.Name
	}
	if rd.Type != nil {
		objectMap["type"] = rd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoverableDatabase struct.
func (rd *RecoverableDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var recoverableDatabaseProperties RecoverableDatabaseProperties
				err = json.Unmarshal(*v, &recoverableDatabaseProperties)
				if err != nil {
					return err
				}
				rd.RecoverableDatabaseProperties = &recoverableDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rd.Type = &typeVar
			}
		}
	}

	return nil
}

// RecoverableDatabaseListResult the response to a list recoverable databases request
type RecoverableDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of recoverable databases
	Value *[]RecoverableDatabase `json:"value,omitempty"`
}

// RecoverableDatabaseProperties the properties of a recoverable database
type RecoverableDatabaseProperties struct {
	// Edition - The edition of the database
	Edition *string `json:"edition,omitempty"`
	// ServiceLevelObjective - The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// LastAvailableBackupDate - The last available backup date of the database (ISO8601 format)
	LastAvailableBackupDate *date.Time `json:"lastAvailableBackupDate,omitempty"`
}

// ReplicationLink represents a database replication link.
type ReplicationLink struct {
	autorest.Response `json:"-"`
	// Location - Location of the server that contains this firewall rule.
	Location *string `json:"location,omitempty"`
	// ReplicationLinkProperties - The properties representing the resource.
	*ReplicationLinkProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationLink.
func (rl ReplicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rl.Location != nil {
		objectMap["location"] = rl.Location
	}
	if rl.ReplicationLinkProperties != nil {
		objectMap["properties"] = rl.ReplicationLinkProperties
	}
	if rl.ID != nil {
		objectMap["id"] = rl.ID
	}
	if rl.Name != nil {
		objectMap["name"] = rl.Name
	}
	if rl.Type != nil {
		objectMap["type"] = rl.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationLink struct.
func (rl *ReplicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rl.Location = &location
			}
		case "properties":
			if v != nil {
				var replicationLinkProperties ReplicationLinkProperties
				err = json.Unmarshal(*v, &replicationLinkProperties)
				if err != nil {
					return err
				}
				rl.ReplicationLinkProperties = &replicationLinkProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rl.Type = &typeVar
			}
		}
	}

	return nil
}

// ReplicationLinkListResult represents the response to a List database replication link request.
type ReplicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database replication links housed in the database.
	Value *[]ReplicationLink `json:"value,omitempty"`
}

// ReplicationLinkProperties represents the properties of a database replication link.
type ReplicationLinkProperties struct {
	// IsTerminationAllowed - Legacy value indicating whether termination is allowed.  Currently always returns true.
	IsTerminationAllowed *bool `json:"isTerminationAllowed,omitempty"`
	// ReplicationMode - Replication mode of this replication link.
	ReplicationMode *string `json:"replicationMode,omitempty"`
	// PartnerServer - The name of the server hosting the partner database.
	PartnerServer *string `json:"partnerServer,omitempty"`
	// PartnerDatabase - The name of the partner database.
	PartnerDatabase *string `json:"partnerDatabase,omitempty"`
	// PartnerLocation - The Azure Region of the partner database.
	PartnerLocation *string `json:"partnerLocation,omitempty"`
	// Role - The role of the database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	Role ReplicationRole `json:"role,omitempty"`
	// PartnerRole - The role of the partner database in the replication link. Possible values include: 'ReplicationRolePrimary', 'ReplicationRoleSecondary', 'ReplicationRoleNonReadableSecondary', 'ReplicationRoleSource', 'ReplicationRoleCopy'
	PartnerRole ReplicationRole `json:"partnerRole,omitempty"`
	// StartTime - The start time for the replication link.
	StartTime *date.Time `json:"startTime,omitempty"`
	// PercentComplete - The percentage of seeding complete for the replication link.
	PercentComplete *int32 `json:"percentComplete,omitempty"`
	// ReplicationState - The replication state for the replication link. Possible values include: 'PENDING', 'SEEDING', 'CATCHUP', 'SUSPENDED'
	ReplicationState ReplicationState `json:"replicationState,omitempty"`
}

// ReplicationLinksFailoverAllowDataLossFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ReplicationLinksFailoverAllowDataLossFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationLinksFailoverAllowDataLossFuture) Result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverAllowDataLossFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverAllowDataLossFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationLinksFailoverFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ReplicationLinksFailoverFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ReplicationLinksFailoverFuture) Result(client ReplicationLinksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ReplicationLinksFailoverFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ReplicationLinksFailoverFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Resource ARM resource.
type Resource struct {
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// ResourceIdentity azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// PrincipalID - The Azure Active Directory principal id.
	PrincipalID *uuid.UUID `json:"principalId,omitempty"`
	// Type - The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource. Possible values include: 'SystemAssigned'
	Type IdentityType `json:"type,omitempty"`
	// TenantID - The Azure Active Directory tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ResourceMoveDefinition contains the information necessary to perform a resource move (rename).
type ResourceMoveDefinition struct {
	// ID - The target ID for the resource
	ID *string `json:"id,omitempty"`
}

// RestorableDroppedDatabase a restorable dropped database
type RestorableDroppedDatabase struct {
	autorest.Response `json:"-"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// RestorableDroppedDatabaseProperties - The properties of a restorable dropped database
	*RestorableDroppedDatabaseProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedDatabase.
func (rdd RestorableDroppedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdd.Location != nil {
		objectMap["location"] = rdd.Location
	}
	if rdd.RestorableDroppedDatabaseProperties != nil {
		objectMap["properties"] = rdd.RestorableDroppedDatabaseProperties
	}
	if rdd.ID != nil {
		objectMap["id"] = rdd.ID
	}
	if rdd.Name != nil {
		objectMap["name"] = rdd.Name
	}
	if rdd.Type != nil {
		objectMap["type"] = rdd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedDatabase struct.
func (rdd *RestorableDroppedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdd.Location = &location
			}
		case "properties":
			if v != nil {
				var restorableDroppedDatabaseProperties RestorableDroppedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedDatabaseProperties)
				if err != nil {
					return err
				}
				rdd.RestorableDroppedDatabaseProperties = &restorableDroppedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedDatabaseListResult the response to a list restorable dropped databases request
type RestorableDroppedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - A list of restorable dropped databases
	Value *[]RestorableDroppedDatabase `json:"value,omitempty"`
}

// RestorableDroppedDatabaseProperties the properties of a restorable dropped database
type RestorableDroppedDatabaseProperties struct {
	// DatabaseName - The name of the database
	DatabaseName *string `json:"databaseName,omitempty"`
	// Edition - The edition of the database
	Edition *string `json:"edition,omitempty"`
	// MaxSizeBytes - The max size in bytes of the database
	MaxSizeBytes *string `json:"maxSizeBytes,omitempty"`
	// ServiceLevelObjective - The service level objective name of the database
	ServiceLevelObjective *string `json:"serviceLevelObjective,omitempty"`
	// ElasticPoolName - The elastic pool name of the database
	ElasticPoolName *string `json:"elasticPoolName,omitempty"`
	// CreationDate - The creation date of the database (ISO8601 format)
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - The deletion date of the database (ISO8601 format)
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - The earliest restore date of the database (ISO8601 format)
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorableDroppedManagedDatabase a restorable dropped managed database resource.
type RestorableDroppedManagedDatabase struct {
	autorest.Response `json:"-"`
	// RestorableDroppedManagedDatabaseProperties - Resource properties.
	*RestorableDroppedManagedDatabaseProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorableDroppedManagedDatabase.
func (rdmd RestorableDroppedManagedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rdmd.RestorableDroppedManagedDatabaseProperties != nil {
		objectMap["properties"] = rdmd.RestorableDroppedManagedDatabaseProperties
	}
	if rdmd.Location != nil {
		objectMap["location"] = rdmd.Location
	}
	if rdmd.Tags != nil {
		objectMap["tags"] = rdmd.Tags
	}
	if rdmd.ID != nil {
		objectMap["id"] = rdmd.ID
	}
	if rdmd.Name != nil {
		objectMap["name"] = rdmd.Name
	}
	if rdmd.Type != nil {
		objectMap["type"] = rdmd.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorableDroppedManagedDatabase struct.
func (rdmd *RestorableDroppedManagedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var restorableDroppedManagedDatabaseProperties RestorableDroppedManagedDatabaseProperties
				err = json.Unmarshal(*v, &restorableDroppedManagedDatabaseProperties)
				if err != nil {
					return err
				}
				rdmd.RestorableDroppedManagedDatabaseProperties = &restorableDroppedManagedDatabaseProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rdmd.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rdmd.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rdmd.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rdmd.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rdmd.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorableDroppedManagedDatabaseListResult a list of restorable dropped managed databases.
type RestorableDroppedManagedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]RestorableDroppedManagedDatabase `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorableDroppedManagedDatabaseListResultIterator provides access to a complete listing of
// RestorableDroppedManagedDatabase values.
type RestorableDroppedManagedDatabaseListResultIterator struct {
	i    int
	page RestorableDroppedManagedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RestorableDroppedManagedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RestorableDroppedManagedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Response() RestorableDroppedManagedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RestorableDroppedManagedDatabaseListResultIterator) Value() RestorableDroppedManagedDatabase {
	if !iter.page.NotDone() {
		return RestorableDroppedManagedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultIterator type.
func NewRestorableDroppedManagedDatabaseListResultIterator(page RestorableDroppedManagedDatabaseListResultPage) RestorableDroppedManagedDatabaseListResultIterator {
	return RestorableDroppedManagedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) IsEmpty() bool {
	return rdmdlr.Value == nil || len(*rdmdlr.Value) == 0
}

// restorableDroppedManagedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rdmdlr RestorableDroppedManagedDatabaseListResult) restorableDroppedManagedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if rdmdlr.NextLink == nil || len(to.String(rdmdlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rdmdlr.NextLink)))
}

// RestorableDroppedManagedDatabaseListResultPage contains a page of RestorableDroppedManagedDatabase
// values.
type RestorableDroppedManagedDatabaseListResultPage struct {
	fn     func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)
	rdmdlr RestorableDroppedManagedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RestorableDroppedManagedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RestorableDroppedManagedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.rdmdlr)
	if err != nil {
		return err
	}
	page.rdmdlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RestorableDroppedManagedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RestorableDroppedManagedDatabaseListResultPage) NotDone() bool {
	return !page.rdmdlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RestorableDroppedManagedDatabaseListResultPage) Response() RestorableDroppedManagedDatabaseListResult {
	return page.rdmdlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RestorableDroppedManagedDatabaseListResultPage) Values() []RestorableDroppedManagedDatabase {
	if page.rdmdlr.IsEmpty() {
		return nil
	}
	return *page.rdmdlr.Value
}

// Creates a new instance of the RestorableDroppedManagedDatabaseListResultPage type.
func NewRestorableDroppedManagedDatabaseListResultPage(getNextPage func(context.Context, RestorableDroppedManagedDatabaseListResult) (RestorableDroppedManagedDatabaseListResult, error)) RestorableDroppedManagedDatabaseListResultPage {
	return RestorableDroppedManagedDatabaseListResultPage{fn: getNextPage}
}

// RestorableDroppedManagedDatabaseProperties the restorable dropped managed database's properties.
type RestorableDroppedManagedDatabaseProperties struct {
	// DatabaseName - The name of the database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// CreationDate - The creation date of the database (ISO8601 format).
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// DeletionDate - The deletion date of the database (ISO8601 format).
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// EarliestRestoreDate - The earliest restore date of the database (ISO8601 format).
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
}

// RestorePoint database restore points.
type RestorePoint struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// RestorePointProperties - Resource properties.
	*RestorePointProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for RestorePoint.
func (rp RestorePoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Location != nil {
		objectMap["location"] = rp.Location
	}
	if rp.RestorePointProperties != nil {
		objectMap["properties"] = rp.RestorePointProperties
	}
	if rp.ID != nil {
		objectMap["id"] = rp.ID
	}
	if rp.Name != nil {
		objectMap["name"] = rp.Name
	}
	if rp.Type != nil {
		objectMap["type"] = rp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestorePoint struct.
func (rp *RestorePoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rp.Location = &location
			}
		case "properties":
			if v != nil {
				var restorePointProperties RestorePointProperties
				err = json.Unmarshal(*v, &restorePointProperties)
				if err != nil {
					return err
				}
				rp.RestorePointProperties = &restorePointProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rp.Type = &typeVar
			}
		}
	}

	return nil
}

// RestorePointListResult a list of long term retention backups.
type RestorePointListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]RestorePoint `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RestorePointProperties properties of a database restore point
type RestorePointProperties struct {
	// RestorePointType - The type of restore point. Possible values include: 'CONTINUOUS', 'DISCRETE'
	RestorePointType RestorePointType `json:"restorePointType,omitempty"`
	// EarliestRestoreDate - The earliest time to which this database can be restored
	EarliestRestoreDate *date.Time `json:"earliestRestoreDate,omitempty"`
	// RestorePointCreationDate - The time the backup was taken
	RestorePointCreationDate *date.Time `json:"restorePointCreationDate,omitempty"`
	// RestorePointLabel - The label of restore point for backup request by user
	RestorePointLabel *string `json:"restorePointLabel,omitempty"`
}

// RestorePointsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RestorePointsCreateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *RestorePointsCreateFuture) Result(client RestorePointsClient) (rp RestorePoint, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.RestorePointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.RestorePointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if rp.Response.Response, err = future.GetResult(sender); err == nil && rp.Response.Response.StatusCode != http.StatusNoContent {
		rp, err = client.CreateResponder(rp.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.RestorePointsCreateFuture", "Result", rp.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SecurityAlertPolicyProperties properties of a security alert policy.
type SecurityAlertPolicyProperties struct {
	// State - Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database. Possible values include: 'SecurityAlertPolicyStateNew', 'SecurityAlertPolicyStateEnabled', 'SecurityAlertPolicyStateDisabled'
	State SecurityAlertPolicyState `json:"state,omitempty"`
	// DisabledAlerts - Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action
	DisabledAlerts *[]string `json:"disabledAlerts,omitempty"`
	// EmailAddresses - Specifies an array of e-mail addresses to which the alert is sent.
	EmailAddresses *[]string `json:"emailAddresses,omitempty"`
	// EmailAccountAdmins - Specifies that the alert is sent to the account administrators.
	EmailAccountAdmins *bool `json:"emailAccountAdmins,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the Threat Detection audit storage account.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the Threat Detection audit logs.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// CreationTime - Specifies the UTC creation time of the policy.
	CreationTime *date.Time `json:"creationTime,omitempty"`
}

// SensitivityLabel a sensitivity label.
type SensitivityLabel struct {
	autorest.Response `json:"-"`
	// SensitivityLabelProperties - Resource properties.
	*SensitivityLabelProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SensitivityLabel.
func (sl SensitivityLabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.SensitivityLabelProperties != nil {
		objectMap["properties"] = sl.SensitivityLabelProperties
	}
	if sl.ID != nil {
		objectMap["id"] = sl.ID
	}
	if sl.Name != nil {
		objectMap["name"] = sl.Name
	}
	if sl.Type != nil {
		objectMap["type"] = sl.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SensitivityLabel struct.
func (sl *SensitivityLabel) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var sensitivityLabelProperties SensitivityLabelProperties
				err = json.Unmarshal(*v, &sensitivityLabelProperties)
				if err != nil {
					return err
				}
				sl.SensitivityLabelProperties = &sensitivityLabelProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// SensitivityLabelListResult a list of sensitivity labels.
type SensitivityLabelListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SensitivityLabel `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SensitivityLabelListResultIterator provides access to a complete listing of SensitivityLabel values.
type SensitivityLabelListResultIterator struct {
	i    int
	page SensitivityLabelListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SensitivityLabelListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SensitivityLabelListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SensitivityLabelListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SensitivityLabelListResultIterator) Response() SensitivityLabelListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SensitivityLabelListResultIterator) Value() SensitivityLabel {
	if !iter.page.NotDone() {
		return SensitivityLabel{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SensitivityLabelListResultIterator type.
func NewSensitivityLabelListResultIterator(page SensitivityLabelListResultPage) SensitivityLabelListResultIterator {
	return SensitivityLabelListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr SensitivityLabelListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// sensitivityLabelListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr SensitivityLabelListResult) sensitivityLabelListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sllr.NextLink == nil || len(to.String(sllr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// SensitivityLabelListResultPage contains a page of SensitivityLabel values.
type SensitivityLabelListResultPage struct {
	fn   func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)
	sllr SensitivityLabelListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SensitivityLabelListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SensitivityLabelListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sllr)
	if err != nil {
		return err
	}
	page.sllr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SensitivityLabelListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SensitivityLabelListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SensitivityLabelListResultPage) Response() SensitivityLabelListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SensitivityLabelListResultPage) Values() []SensitivityLabel {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the SensitivityLabelListResultPage type.
func NewSensitivityLabelListResultPage(getNextPage func(context.Context, SensitivityLabelListResult) (SensitivityLabelListResult, error)) SensitivityLabelListResultPage {
	return SensitivityLabelListResultPage{fn: getNextPage}
}

// SensitivityLabelProperties properties of a sensitivity label.
type SensitivityLabelProperties struct {
	// LabelName - The label name.
	LabelName *string `json:"labelName,omitempty"`
	// LabelID - The label ID.
	LabelID *string `json:"labelId,omitempty"`
	// InformationType - The information type.
	InformationType *string `json:"informationType,omitempty"`
	// InformationTypeID - The information type ID.
	InformationTypeID *string `json:"informationTypeId,omitempty"`
}

// Server an Azure SQL Database server.
type Server struct {
	autorest.Response `json:"-"`
	// Identity - The Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`
	// Kind - Kind of sql server. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Server.
func (s Server) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.Kind != nil {
		objectMap["kind"] = s.Kind
	}
	if s.ServerProperties != nil {
		objectMap["properties"] = s.ServerProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.ID != nil {
		objectMap["id"] = s.ID
	}
	if s.Name != nil {
		objectMap["name"] = s.Name
	}
	if s.Type != nil {
		objectMap["type"] = s.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Server struct.
func (s *Server) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity ResourceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				s.Kind = &kind
			}
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				s.ServerProperties = &serverProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAdministratorListResult the response to a list Active Directory Administrators request.
type ServerAdministratorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server Active Directory Administrators for the server.
	Value *[]ServerAzureADAdministrator `json:"value,omitempty"`
}

// ServerAdministratorProperties the properties of an server Administrator.
type ServerAdministratorProperties struct {
	// AdministratorType - The type of administrator.
	AdministratorType *string `json:"administratorType,omitempty"`
	// Login - The server administrator login value.
	Login *string `json:"login,omitempty"`
	// Sid - The server administrator Sid (Secure ID).
	Sid *uuid.UUID `json:"sid,omitempty"`
	// TenantID - The server Active Directory Administrator tenant id.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
}

// ServerAutomaticTuning server-level Automatic Tuning.
type ServerAutomaticTuning struct {
	autorest.Response `json:"-"`
	// AutomaticTuningServerProperties - Resource properties.
	*AutomaticTuningServerProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAutomaticTuning.
func (sat ServerAutomaticTuning) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sat.AutomaticTuningServerProperties != nil {
		objectMap["properties"] = sat.AutomaticTuningServerProperties
	}
	if sat.ID != nil {
		objectMap["id"] = sat.ID
	}
	if sat.Name != nil {
		objectMap["name"] = sat.Name
	}
	if sat.Type != nil {
		objectMap["type"] = sat.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAutomaticTuning struct.
func (sat *ServerAutomaticTuning) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var automaticTuningServerProperties AutomaticTuningServerProperties
				err = json.Unmarshal(*v, &automaticTuningServerProperties)
				if err != nil {
					return err
				}
				sat.AutomaticTuningServerProperties = &automaticTuningServerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sat.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sat.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sat.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministrator an server Active Directory Administrator.
type ServerAzureADAdministrator struct {
	autorest.Response `json:"-"`
	// ServerAdministratorProperties - The properties of the resource.
	*ServerAdministratorProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerAzureADAdministrator.
func (saaa ServerAzureADAdministrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if saaa.ServerAdministratorProperties != nil {
		objectMap["properties"] = saaa.ServerAdministratorProperties
	}
	if saaa.ID != nil {
		objectMap["id"] = saaa.ID
	}
	if saaa.Name != nil {
		objectMap["name"] = saaa.Name
	}
	if saaa.Type != nil {
		objectMap["type"] = saaa.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerAzureADAdministrator struct.
func (saaa *ServerAzureADAdministrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverAdministratorProperties ServerAdministratorProperties
				err = json.Unmarshal(*v, &serverAdministratorProperties)
				if err != nil {
					return err
				}
				saaa.ServerAdministratorProperties = &serverAdministratorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				saaa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				saaa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				saaa.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerAzureADAdministratorsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerAzureADAdministratorsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADAdministratorsCreateOrUpdateFuture) Result(client ServerAzureADAdministratorsClient) (saaa ServerAzureADAdministrator, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaa.Response.Response, err = future.GetResult(sender); err == nil && saaa.Response.Response.StatusCode != http.StatusNoContent {
		saaa, err = client.CreateOrUpdateResponder(saaa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsCreateOrUpdateFuture", "Result", saaa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerAzureADAdministratorsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerAzureADAdministratorsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerAzureADAdministratorsDeleteFuture) Result(client ServerAzureADAdministratorsClient) (saaa ServerAzureADAdministrator, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerAzureADAdministratorsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if saaa.Response.Response, err = future.GetResult(sender); err == nil && saaa.Response.Response.StatusCode != http.StatusNoContent {
		saaa, err = client.DeleteResponder(saaa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerAzureADAdministratorsDeleteFuture", "Result", saaa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerBlobAuditingPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerBlobAuditingPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerBlobAuditingPoliciesCreateOrUpdateFuture) Result(client ServerBlobAuditingPoliciesClient) (sbap ServerBlobAuditingPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sbap.Response.Response, err = future.GetResult(sender); err == nil && sbap.Response.Response.StatusCode != http.StatusNoContent {
		sbap, err = client.CreateOrUpdateResponder(sbap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerBlobAuditingPoliciesCreateOrUpdateFuture", "Result", sbap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerBlobAuditingPolicy a server blob auditing policy.
type ServerBlobAuditingPolicy struct {
	autorest.Response `json:"-"`
	// ServerBlobAuditingPolicyProperties - Resource properties.
	*ServerBlobAuditingPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerBlobAuditingPolicy.
func (sbap ServerBlobAuditingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sbap.ServerBlobAuditingPolicyProperties != nil {
		objectMap["properties"] = sbap.ServerBlobAuditingPolicyProperties
	}
	if sbap.ID != nil {
		objectMap["id"] = sbap.ID
	}
	if sbap.Name != nil {
		objectMap["name"] = sbap.Name
	}
	if sbap.Type != nil {
		objectMap["type"] = sbap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerBlobAuditingPolicy struct.
func (sbap *ServerBlobAuditingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverBlobAuditingPolicyProperties ServerBlobAuditingPolicyProperties
				err = json.Unmarshal(*v, &serverBlobAuditingPolicyProperties)
				if err != nil {
					return err
				}
				sbap.ServerBlobAuditingPolicyProperties = &serverBlobAuditingPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sbap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sbap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sbap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerBlobAuditingPolicyProperties properties of a server blob auditing policy.
type ServerBlobAuditingPolicyProperties struct {
	// State - Specifies the state of the policy. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required. Possible values include: 'BlobAuditingPolicyStateEnabled', 'BlobAuditingPolicyStateDisabled'
	State BlobAuditingPolicyState `json:"state,omitempty"`
	// StorageEndpoint - Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint is required.
	StorageEndpoint *string `json:"storageEndpoint,omitempty"`
	// StorageAccountAccessKey - Specifies the identifier key of the auditing storage account. If state is Enabled and storageEndpoint is specified, storageAccountAccessKey is required.
	StorageAccountAccessKey *string `json:"storageAccountAccessKey,omitempty"`
	// RetentionDays - Specifies the number of days to keep in the audit logs in the storage account.
	RetentionDays *int32 `json:"retentionDays,omitempty"`
	// AuditActionsAndGroups - Specifies the Actions-Groups and Actions to audit.
	//
	// The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
	//
	// BATCH_COMPLETED_GROUP,
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
	// FAILED_DATABASE_AUTHENTICATION_GROUP.
	//
	// This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
	//
	// The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
	//
	// APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
	// BACKUP_RESTORE_GROUP
	// DATABASE_LOGOUT_GROUP
	// DATABASE_OBJECT_CHANGE_GROUP
	// DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
	// DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
	// DATABASE_OPERATION_GROUP
	// DATABASE_PERMISSION_CHANGE_GROUP
	// DATABASE_PRINCIPAL_CHANGE_GROUP
	// DATABASE_PRINCIPAL_IMPERSONATION_GROUP
	// DATABASE_ROLE_MEMBER_CHANGE_GROUP
	// FAILED_DATABASE_AUTHENTICATION_GROUP
	// SCHEMA_OBJECT_ACCESS_GROUP
	// SCHEMA_OBJECT_CHANGE_GROUP
	// SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
	// SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
	// SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
	// USER_CHANGE_PASSWORD_GROUP
	// BATCH_STARTED_GROUP
	// BATCH_COMPLETED_GROUP
	//
	// These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
	//
	// For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
	//
	// For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
	// SELECT
	// UPDATE
	// INSERT
	// DELETE
	// EXECUTE
	// RECEIVE
	// REFERENCES
	//
	// The general form for defining an action to be audited is:
	// {action} ON {object} BY {principal}
	//
	// Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
	//
	// For example:
	// SELECT on dbo.myTable by public
	// SELECT on DATABASE::myDatabase by public
	// SELECT on SCHEMA::mySchema by public
	//
	// For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
	AuditActionsAndGroups *[]string `json:"auditActionsAndGroups,omitempty"`
	// StorageAccountSubscriptionID - Specifies the blob storage subscription Id.
	StorageAccountSubscriptionID *uuid.UUID `json:"storageAccountSubscriptionId,omitempty"`
	// IsStorageSecondaryKeyInUse - Specifies whether storageAccountAccessKey value is the storage's secondary key.
	IsStorageSecondaryKeyInUse *bool `json:"isStorageSecondaryKeyInUse,omitempty"`
	// IsAzureMonitorTargetEnabled - Specifies whether audit events are sent to Azure Monitor.
	// In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
	//
	// When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
	// Note that for server level audit you should use the 'master' database as {databaseName}.
	//
	// Diagnostic Settings URI format:
	// PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
	//
	// For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
	// or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
	IsAzureMonitorTargetEnabled *bool `json:"isAzureMonitorTargetEnabled,omitempty"`
}

// ServerCommunicationLink server communication link.
type ServerCommunicationLink struct {
	autorest.Response `json:"-"`
	// ServerCommunicationLinkProperties - The properties of resource.
	*ServerCommunicationLinkProperties `json:"properties,omitempty"`
	// Location - Communication link location.
	Location *string `json:"location,omitempty"`
	// Kind - Communication link kind.  This property is used for Azure Portal metadata.
	Kind *string `json:"kind,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerCommunicationLink.
func (scl ServerCommunicationLink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scl.ServerCommunicationLinkProperties != nil {
		objectMap["properties"] = scl.ServerCommunicationLinkProperties
	}
	if scl.Location != nil {
		objectMap["location"] = scl.Location
	}
	if scl.Kind != nil {
		objectMap["kind"] = scl.Kind
	}
	if scl.ID != nil {
		objectMap["id"] = scl.ID
	}
	if scl.Name != nil {
		objectMap["name"] = scl.Name
	}
	if scl.Type != nil {
		objectMap["type"] = scl.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerCommunicationLink struct.
func (scl *ServerCommunicationLink) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverCommunicationLinkProperties ServerCommunicationLinkProperties
				err = json.Unmarshal(*v, &serverCommunicationLinkProperties)
				if err != nil {
					return err
				}
				scl.ServerCommunicationLinkProperties = &serverCommunicationLinkProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scl.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scl.Kind = &kind
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerCommunicationLinkListResult a list of server communication links.
type ServerCommunicationLinkListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server communication links.
	Value *[]ServerCommunicationLink `json:"value,omitempty"`
}

// ServerCommunicationLinkProperties the properties of a server communication link.
type ServerCommunicationLinkProperties struct {
	// State - The state.
	State *string `json:"state,omitempty"`
	// PartnerServer - The name of the partner server.
	PartnerServer *string `json:"partnerServer,omitempty"`
}

// ServerCommunicationLinksCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ServerCommunicationLinksCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerCommunicationLinksCreateOrUpdateFuture) Result(client ServerCommunicationLinksClient) (scl ServerCommunicationLink, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerCommunicationLinksCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scl.Response.Response, err = future.GetResult(sender); err == nil && scl.Response.Response.StatusCode != http.StatusNoContent {
		scl, err = client.CreateOrUpdateResponder(scl.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerCommunicationLinksCreateOrUpdateFuture", "Result", scl.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerConnectionPolicy a server secure connection policy.
type ServerConnectionPolicy struct {
	autorest.Response `json:"-"`
	// Kind - Metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ServerConnectionPolicyProperties - The properties of the server secure connection policy.
	*ServerConnectionPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerConnectionPolicy.
func (scp ServerConnectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scp.Kind != nil {
		objectMap["kind"] = scp.Kind
	}
	if scp.Location != nil {
		objectMap["location"] = scp.Location
	}
	if scp.ServerConnectionPolicyProperties != nil {
		objectMap["properties"] = scp.ServerConnectionPolicyProperties
	}
	if scp.ID != nil {
		objectMap["id"] = scp.ID
	}
	if scp.Name != nil {
		objectMap["name"] = scp.Name
	}
	if scp.Type != nil {
		objectMap["type"] = scp.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerConnectionPolicy struct.
func (scp *ServerConnectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				scp.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scp.Location = &location
			}
		case "properties":
			if v != nil {
				var serverConnectionPolicyProperties ServerConnectionPolicyProperties
				err = json.Unmarshal(*v, &serverConnectionPolicyProperties)
				if err != nil {
					return err
				}
				scp.ServerConnectionPolicyProperties = &serverConnectionPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerConnectionPolicyProperties the properties of a server secure connection policy.
type ServerConnectionPolicyProperties struct {
	// ConnectionType - The server connection type. Possible values include: 'ServerConnectionTypeDefault', 'ServerConnectionTypeProxy', 'ServerConnectionTypeRedirect'
	ConnectionType ServerConnectionType `json:"connectionType,omitempty"`
}

// ServerDNSAlias a server DNS alias.
type ServerDNSAlias struct {
	autorest.Response `json:"-"`
	// ServerDNSAliasProperties - Resource properties.
	*ServerDNSAliasProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerDNSAlias.
func (sda ServerDNSAlias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sda.ServerDNSAliasProperties != nil {
		objectMap["properties"] = sda.ServerDNSAliasProperties
	}
	if sda.ID != nil {
		objectMap["id"] = sda.ID
	}
	if sda.Name != nil {
		objectMap["name"] = sda.Name
	}
	if sda.Type != nil {
		objectMap["type"] = sda.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerDNSAlias struct.
func (sda *ServerDNSAlias) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverDNSAliasProperties ServerDNSAliasProperties
				err = json.Unmarshal(*v, &serverDNSAliasProperties)
				if err != nil {
					return err
				}
				sda.ServerDNSAliasProperties = &serverDNSAliasProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sda.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sda.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sda.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerDNSAliasAcquisition a server DNS alias acquisition request.
type ServerDNSAliasAcquisition struct {
	// OldServerDNSAliasID - The id of the server alias that will be acquired to point to this server instead.
	OldServerDNSAliasID *string `json:"oldServerDnsAliasId,omitempty"`
}

// ServerDNSAliasesAcquireFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesAcquireFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesAcquireFuture) Result(client ServerDNSAliasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesAcquireFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesAcquireFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerDNSAliasesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerDNSAliasesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesCreateOrUpdateFuture) Result(client ServerDNSAliasesClient) (sda ServerDNSAlias, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sda.Response.Response, err = future.GetResult(sender); err == nil && sda.Response.Response.StatusCode != http.StatusNoContent {
		sda, err = client.CreateOrUpdateResponder(sda.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesCreateOrUpdateFuture", "Result", sda.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerDNSAliasesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerDNSAliasesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerDNSAliasesDeleteFuture) Result(client ServerDNSAliasesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerDNSAliasesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerDNSAliasesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerDNSAliasListResult a list of server DNS aliases.
type ServerDNSAliasListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ServerDNSAlias `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerDNSAliasListResultIterator provides access to a complete listing of ServerDNSAlias values.
type ServerDNSAliasListResultIterator struct {
	i    int
	page ServerDNSAliasListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerDNSAliasListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerDNSAliasListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerDNSAliasListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerDNSAliasListResultIterator) Response() ServerDNSAliasListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerDNSAliasListResultIterator) Value() ServerDNSAlias {
	if !iter.page.NotDone() {
		return ServerDNSAlias{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerDNSAliasListResultIterator type.
func NewServerDNSAliasListResultIterator(page ServerDNSAliasListResultPage) ServerDNSAliasListResultIterator {
	return ServerDNSAliasListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdalr ServerDNSAliasListResult) IsEmpty() bool {
	return sdalr.Value == nil || len(*sdalr.Value) == 0
}

// serverDNSAliasListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdalr ServerDNSAliasListResult) serverDNSAliasListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sdalr.NextLink == nil || len(to.String(sdalr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdalr.NextLink)))
}

// ServerDNSAliasListResultPage contains a page of ServerDNSAlias values.
type ServerDNSAliasListResultPage struct {
	fn    func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)
	sdalr ServerDNSAliasListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerDNSAliasListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerDNSAliasListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sdalr)
	if err != nil {
		return err
	}
	page.sdalr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerDNSAliasListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerDNSAliasListResultPage) NotDone() bool {
	return !page.sdalr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerDNSAliasListResultPage) Response() ServerDNSAliasListResult {
	return page.sdalr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerDNSAliasListResultPage) Values() []ServerDNSAlias {
	if page.sdalr.IsEmpty() {
		return nil
	}
	return *page.sdalr.Value
}

// Creates a new instance of the ServerDNSAliasListResultPage type.
func NewServerDNSAliasListResultPage(getNextPage func(context.Context, ServerDNSAliasListResult) (ServerDNSAliasListResult, error)) ServerDNSAliasListResultPage {
	return ServerDNSAliasListResultPage{fn: getNextPage}
}

// ServerDNSAliasProperties properties of a server DNS alias.
type ServerDNSAliasProperties struct {
	// AzureDNSRecord - The fully qualified DNS record for alias
	AzureDNSRecord *string `json:"azureDnsRecord,omitempty"`
}

// ServerKey a server key.
type ServerKey struct {
	autorest.Response `json:"-"`
	// Kind - Kind of encryption protector. This is metadata used for the Azure portal experience.
	Kind *string `json:"kind,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// ServerKeyProperties - Resource properties.
	*ServerKeyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerKey.
func (sk ServerKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sk.Kind != nil {
		objectMap["kind"] = sk.Kind
	}
	if sk.Location != nil {
		objectMap["location"] = sk.Location
	}
	if sk.ServerKeyProperties != nil {
		objectMap["properties"] = sk.ServerKeyProperties
	}
	if sk.ID != nil {
		objectMap["id"] = sk.ID
	}
	if sk.Name != nil {
		objectMap["name"] = sk.Name
	}
	if sk.Type != nil {
		objectMap["type"] = sk.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerKey struct.
func (sk *ServerKey) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				sk.Kind = &kind
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sk.Location = &location
			}
		case "properties":
			if v != nil {
				var serverKeyProperties ServerKeyProperties
				err = json.Unmarshal(*v, &serverKeyProperties)
				if err != nil {
					return err
				}
				sk.ServerKeyProperties = &serverKeyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sk.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sk.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sk.Type = &typeVar
			}
		}
	}

	return nil
}

// ServerKeyListResult a list of server keys.
type ServerKeyListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]ServerKey `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerKeyListResultIterator provides access to a complete listing of ServerKey values.
type ServerKeyListResultIterator struct {
	i    int
	page ServerKeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerKeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerKeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerKeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerKeyListResultIterator) Response() ServerKeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerKeyListResultIterator) Value() ServerKey {
	if !iter.page.NotDone() {
		return ServerKey{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerKeyListResultIterator type.
func NewServerKeyListResultIterator(page ServerKeyListResultPage) ServerKeyListResultIterator {
	return ServerKeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sklr ServerKeyListResult) IsEmpty() bool {
	return sklr.Value == nil || len(*sklr.Value) == 0
}

// serverKeyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sklr ServerKeyListResult) serverKeyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sklr.NextLink == nil || len(to.String(sklr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sklr.NextLink)))
}

// ServerKeyListResultPage contains a page of ServerKey values.
type ServerKeyListResultPage struct {
	fn   func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)
	sklr ServerKeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerKeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerKeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sklr)
	if err != nil {
		return err
	}
	page.sklr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerKeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerKeyListResultPage) NotDone() bool {
	return !page.sklr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerKeyListResultPage) Response() ServerKeyListResult {
	return page.sklr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerKeyListResultPage) Values() []ServerKey {
	if page.sklr.IsEmpty() {
		return nil
	}
	return *page.sklr.Value
}

// Creates a new instance of the ServerKeyListResultPage type.
func NewServerKeyListResultPage(getNextPage func(context.Context, ServerKeyListResult) (ServerKeyListResult, error)) ServerKeyListResultPage {
	return ServerKeyListResultPage{fn: getNextPage}
}

// ServerKeyProperties properties for a server key execution.
type ServerKeyProperties struct {
	// Subregion - Subregion of the server key.
	Subregion *string `json:"subregion,omitempty"`
	// ServerKeyType - The server key type like 'ServiceManaged', 'AzureKeyVault'. Possible values include: 'ServiceManaged', 'AzureKeyVault'
	ServerKeyType ServerKeyType `json:"serverKeyType,omitempty"`
	// URI - The URI of the server key.
	URI *string `json:"uri,omitempty"`
	// Thumbprint - Thumbprint of the server key.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// CreationDate - The server key creation date.
	CreationDate *date.Time `json:"creationDate,omitempty"`
}

// ServerKeysCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ServerKeysCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerKeysCreateOrUpdateFuture) Result(client ServerKeysClient) (sk ServerKey, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerKeysCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerKeysCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sk.Response.Response, err = future.GetResult(sender); err == nil && sk.Response.Response.StatusCode != http.StatusNoContent {
		sk, err = client.CreateOrUpdateResponder(sk.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerKeysCreateOrUpdateFuture", "Result", sk.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerKeysDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServerKeysDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerKeysDeleteFuture) Result(client ServerKeysClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerKeysDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerKeysDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerListResult a list of servers.
type ServerListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]Server `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerListResultIterator provides access to a complete listing of Server values.
type ServerListResultIterator struct {
	i    int
	page ServerListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServerListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServerListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServerListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServerListResultIterator) Response() ServerListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServerListResultIterator) Value() Server {
	if !iter.page.NotDone() {
		return Server{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServerListResultIterator type.
func NewServerListResultIterator(page ServerListResultPage) ServerListResultIterator {
	return ServerListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServerListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// serverListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServerListResult) serverListResultPreparer(ctx context.Context) (*http.Request, error) {
	if slr.NextLink == nil || len(to.String(slr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServerListResultPage contains a page of Server values.
type ServerListResultPage struct {
	fn  func(context.Context, ServerListResult) (ServerListResult, error)
	slr ServerListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServerListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServerListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.slr)
	if err != nil {
		return err
	}
	page.slr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServerListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServerListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServerListResultPage) Response() ServerListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServerListResultPage) Values() []Server {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServerListResultPage type.
func NewServerListResultPage(getNextPage func(context.Context, ServerListResult) (ServerListResult, error)) ServerListResultPage {
	return ServerListResultPage{fn: getNextPage}
}

// ServerProperties the properties of a server.
type ServerProperties struct {
	// AdministratorLogin - Administrator username for the server. Once created it cannot be changed.
	AdministratorLogin *string `json:"administratorLogin,omitempty"`
	// AdministratorLoginPassword - The administrator login password (required for server creation).
	AdministratorLoginPassword *string `json:"administratorLoginPassword,omitempty"`
	// Version - The version of the server.
	Version *string `json:"version,omitempty"`
	// State - The state of the server.
	State *string `json:"state,omitempty"`
	// FullyQualifiedDomainName - The fully qualified domain name of the server.
	FullyQualifiedDomainName *string `json:"fullyQualifiedDomainName,omitempty"`
}

// ServersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersCreateOrUpdateFuture) Result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.CreateOrUpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServersCreateOrUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersDeleteFuture) Result(client ServersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ServerSecurityAlertPoliciesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type ServerSecurityAlertPoliciesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServerSecurityAlertPoliciesCreateOrUpdateFuture) Result(client ServerSecurityAlertPoliciesClient) (ssap ServerSecurityAlertPolicy, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ssap.Response.Response, err = future.GetResult(sender); err == nil && ssap.Response.Response.StatusCode != http.StatusNoContent {
		ssap, err = client.CreateOrUpdateResponder(ssap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServerSecurityAlertPoliciesCreateOrUpdateFuture", "Result", ssap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerSecurityAlertPolicy a server security alert policy.
type ServerSecurityAlertPolicy struct {
	autorest.Response `json:"-"`
	// SecurityAlertPolicyProperties - Resource properties.
	*SecurityAlertPolicyProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServerSecurityAlertPolicy.
func (ssap ServerSecurityAlertPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ssap.SecurityAlertPolicyProperties != nil {
		objectMap["properties"] = ssap.SecurityAlertPolicyProperties
	}
	if ssap.ID != nil {
		objectMap["id"] = ssap.ID
	}
	if ssap.Name != nil {
		objectMap["name"] = ssap.Name
	}
	if ssap.Type != nil {
		objectMap["type"] = ssap.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerSecurityAlertPolicy struct.
func (ssap *ServerSecurityAlertPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var securityAlertPolicyProperties SecurityAlertPolicyProperties
				err = json.Unmarshal(*v, &securityAlertPolicyProperties)
				if err != nil {
					return err
				}
				ssap.SecurityAlertPolicyProperties = &securityAlertPolicyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ssap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ssap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ssap.Type = &typeVar
			}
		}
	}

	return nil
}

// ServersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ServersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ServersUpdateFuture) Result(client ServersClient) (s Server, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ServersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.ServersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if s.Response.Response, err = future.GetResult(sender); err == nil && s.Response.Response.StatusCode != http.StatusNoContent {
		s, err = client.UpdateResponder(s.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.ServersUpdateFuture", "Result", s.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ServerUpdate an update request for an Azure SQL Database server.
type ServerUpdate struct {
	// ServerProperties - Resource properties.
	*ServerProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ServerUpdate.
func (su ServerUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.ServerProperties != nil {
		objectMap["properties"] = su.ServerProperties
	}
	if su.Tags != nil {
		objectMap["tags"] = su.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServerUpdate struct.
func (su *ServerUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serverProperties ServerProperties
				err = json.Unmarshal(*v, &serverProperties)
				if err != nil {
					return err
				}
				su.ServerProperties = &serverProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				su.Tags = tags
			}
		}
	}

	return nil
}

// ServerUsage represents server metrics.
type ServerUsage struct {
	// Name - Name of the server usage metric.
	Name *string `json:"name,omitempty"`
	// ResourceName - The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// DisplayName - The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - The current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - The current limit of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - The units of the metric.
	Unit *string `json:"unit,omitempty"`
	// NextResetTime - The next reset time for the metric (ISO8601 format).
	NextResetTime *date.Time `json:"nextResetTime,omitempty"`
}

// ServerUsageListResult represents the response to a list server metrics request.
type ServerUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of server metrics for the server.
	Value *[]ServerUsage `json:"value,omitempty"`
}

// ServerVersionCapability the server capabilities.
type ServerVersionCapability struct {
	// Name - The server version name.
	Name *string `json:"name,omitempty"`
	// Status - The status of the server version. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// SupportedEditions - The list of supported database editions.
	SupportedEditions *[]EditionCapability `json:"supportedEditions,omitempty"`
	// SupportedElasticPoolEditions - The list of supported elastic pool editions.
	SupportedElasticPoolEditions *[]ElasticPoolEditionCapability `json:"supportedElasticPoolEditions,omitempty"`
}

// ServiceObjective represents a database service objective.
type ServiceObjective struct {
	autorest.Response `json:"-"`
	// ServiceObjectiveProperties - Represents the properties of the resource.
	*ServiceObjectiveProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjective.
func (so ServiceObjective) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if so.ServiceObjectiveProperties != nil {
		objectMap["properties"] = so.ServiceObjectiveProperties
	}
	if so.ID != nil {
		objectMap["id"] = so.ID
	}
	if so.Name != nil {
		objectMap["name"] = so.Name
	}
	if so.Type != nil {
		objectMap["type"] = so.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjective struct.
func (so *ServiceObjective) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceObjectiveProperties ServiceObjectiveProperties
				err = json.Unmarshal(*v, &serviceObjectiveProperties)
				if err != nil {
					return err
				}
				so.ServiceObjectiveProperties = &serviceObjectiveProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				so.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				so.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				so.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceObjectiveCapability the service objectives capability.
type ServiceObjectiveCapability struct {
	// Name - The service objective name.
	Name *string `json:"name,omitempty"`
	// Status - The status of the service objective. Possible values include: 'CapabilityStatusVisible', 'CapabilityStatusAvailable', 'CapabilityStatusDefault', 'CapabilityStatusDisabled'
	Status CapabilityStatus `json:"status,omitempty"`
	// PerformanceLevel - The performance level of the service objective capability.
	*PerformanceLevel `json:"performanceLevel,omitempty"`
	// ID - The unique ID of the service objective.
	ID *uuid.UUID `json:"id,omitempty"`
	// SupportedMaxSizes - The list of supported maximum database sizes for this service objective.
	SupportedMaxSizes *[]MaxSizeCapability `json:"supportedMaxSizes,omitempty"`
	// IncludedMaxSize - The included (free) max size for this service level objective.
	IncludedMaxSize *MaxSizeCapability `json:"includedMaxSize,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceObjectiveCapability.
func (soc ServiceObjectiveCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if soc.Name != nil {
		objectMap["name"] = soc.Name
	}
	if soc.Status != "" {
		objectMap["status"] = soc.Status
	}
	if soc.PerformanceLevel != nil {
		objectMap["performanceLevel"] = soc.PerformanceLevel
	}
	if soc.ID != nil {
		objectMap["id"] = soc.ID
	}
	if soc.SupportedMaxSizes != nil {
		objectMap["supportedMaxSizes"] = soc.SupportedMaxSizes
	}
	if soc.IncludedMaxSize != nil {
		objectMap["includedMaxSize"] = soc.IncludedMaxSize
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceObjectiveCapability struct.
func (soc *ServiceObjectiveCapability) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				soc.Name = &name
			}
		case "status":
			if v != nil {
				var status CapabilityStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				soc.Status = status
			}
		case "performanceLevel":
			if v != nil {
				var performanceLevel PerformanceLevel
				err = json.Unmarshal(*v, &performanceLevel)
				if err != nil {
					return err
				}
				soc.PerformanceLevel = &performanceLevel
			}
		case "id":
			if v != nil {
				var ID uuid.UUID
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				soc.ID = &ID
			}
		case "supportedMaxSizes":
			if v != nil {
				var supportedMaxSizes []MaxSizeCapability
				err = json.Unmarshal(*v, &supportedMaxSizes)
				if err != nil {
					return err
				}
				soc.SupportedMaxSizes = &supportedMaxSizes
			}
		case "includedMaxSize":
			if v != nil {
				var includedMaxSize MaxSizeCapability
				err = json.Unmarshal(*v, &includedMaxSize)
				if err != nil {
					return err
				}
				soc.IncludedMaxSize = &includedMaxSize
			}
		}
	}

	return nil
}

// ServiceObjectiveListResult represents the response to a get database service objectives request.
type ServiceObjectiveListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database service objectives.
	Value *[]ServiceObjective `json:"value,omitempty"`
}

// ServiceObjectiveProperties represents the properties of a database service objective.
type ServiceObjectiveProperties struct {
	// ServiceObjectiveName - The name for the service objective.
	ServiceObjectiveName *string `json:"serviceObjectiveName,omitempty"`
	// IsDefault - Gets whether the service level objective is the default service objective.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsSystem - Gets whether the service level objective is a system service objective.
	IsSystem *bool `json:"isSystem,omitempty"`
	// Description - The description for the service level objective.
	Description *string `json:"description,omitempty"`
	// Enabled - Gets whether the service level objective is enabled.
	Enabled *bool `json:"enabled,omitempty"`
}

// ServiceTierAdvisor represents a Service Tier Advisor.
type ServiceTierAdvisor struct {
	autorest.Response `json:"-"`
	// ServiceTierAdvisorProperties - The properties representing the resource.
	*ServiceTierAdvisorProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceTierAdvisor.
func (sta ServiceTierAdvisor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sta.ServiceTierAdvisorProperties != nil {
		objectMap["properties"] = sta.ServiceTierAdvisorProperties
	}
	if sta.ID != nil {
		objectMap["id"] = sta.ID
	}
	if sta.Name != nil {
		objectMap["name"] = sta.Name
	}
	if sta.Type != nil {
		objectMap["type"] = sta.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceTierAdvisor struct.
func (sta *ServiceTierAdvisor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceTierAdvisorProperties ServiceTierAdvisorProperties
				err = json.Unmarshal(*v, &serviceTierAdvisorProperties)
				if err != nil {
					return err
				}
				sta.ServiceTierAdvisorProperties = &serviceTierAdvisorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sta.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sta.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sta.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceTierAdvisorListResult represents the response to a list service tier advisor request.
type ServiceTierAdvisorListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of service tier advisors for specified database.
	Value *[]ServiceTierAdvisor `json:"value,omitempty"`
}

// ServiceTierAdvisorProperties represents the properties of a Service Tier Advisor.
type ServiceTierAdvisorProperties struct {
	// ObservationPeriodStart - The observation period start (ISO8601 format).
	ObservationPeriodStart *date.Time `json:"observationPeriodStart,omitempty"`
	// ObservationPeriodEnd - The observation period start (ISO8601 format).
	ObservationPeriodEnd *date.Time `json:"observationPeriodEnd,omitempty"`
	// ActiveTimeRatio - The activeTimeRatio for service tier advisor.
	ActiveTimeRatio *float64 `json:"activeTimeRatio,omitempty"`
	// MinDtu - Gets or sets minDtu for service tier advisor.
	MinDtu *float64 `json:"minDtu,omitempty"`
	// AvgDtu - Gets or sets avgDtu for service tier advisor.
	AvgDtu *float64 `json:"avgDtu,omitempty"`
	// MaxDtu - Gets or sets maxDtu for service tier advisor.
	MaxDtu *float64 `json:"maxDtu,omitempty"`
	// MaxSizeInGB - Gets or sets maxSizeInGB for service tier advisor.
	MaxSizeInGB *float64 `json:"maxSizeInGB,omitempty"`
	// ServiceLevelObjectiveUsageMetrics - Gets or sets serviceLevelObjectiveUsageMetrics for the service tier advisor.
	ServiceLevelObjectiveUsageMetrics *[]SloUsageMetric `json:"serviceLevelObjectiveUsageMetrics,omitempty"`
	// CurrentServiceLevelObjective - Gets or sets currentServiceLevelObjective for service tier advisor.
	CurrentServiceLevelObjective *string `json:"currentServiceLevelObjective,omitempty"`
	// CurrentServiceLevelObjectiveID - Gets or sets currentServiceLevelObjectiveId for service tier advisor.
	CurrentServiceLevelObjectiveID *uuid.UUID `json:"currentServiceLevelObjectiveId,omitempty"`
	// UsageBasedRecommendationServiceLevelObjective - Gets or sets usageBasedRecommendationServiceLevelObjective for service tier advisor.
	UsageBasedRecommendationServiceLevelObjective *string `json:"usageBasedRecommendationServiceLevelObjective,omitempty"`
	// UsageBasedRecommendationServiceLevelObjectiveID - Gets or sets usageBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	UsageBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"usageBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjective - Gets or sets databaseSizeBasedRecommendationServiceLevelObjective for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjective *string `json:"databaseSizeBasedRecommendationServiceLevelObjective,omitempty"`
	// DatabaseSizeBasedRecommendationServiceLevelObjectiveID - Gets or sets databaseSizeBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DatabaseSizeBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"databaseSizeBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjective - Gets or sets disasterPlanBasedRecommendationServiceLevelObjective for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjective *string `json:"disasterPlanBasedRecommendationServiceLevelObjective,omitempty"`
	// DisasterPlanBasedRecommendationServiceLevelObjectiveID - Gets or sets disasterPlanBasedRecommendationServiceLevelObjectiveId for service tier advisor.
	DisasterPlanBasedRecommendationServiceLevelObjectiveID *uuid.UUID `json:"disasterPlanBasedRecommendationServiceLevelObjectiveId,omitempty"`
	// OverallRecommendationServiceLevelObjective - Gets or sets overallRecommendationServiceLevelObjective for service tier advisor.
	OverallRecommendationServiceLevelObjective *string `json:"overallRecommendationServiceLevelObjective,omitempty"`
	// OverallRecommendationServiceLevelObjectiveID - Gets or sets overallRecommendationServiceLevelObjectiveId for service tier advisor.
	OverallRecommendationServiceLevelObjectiveID *uuid.UUID `json:"overallRecommendationServiceLevelObjectiveId,omitempty"`
	// Confidence - Gets or sets confidence for service tier advisor.
	Confidence *float64 `json:"confidence,omitempty"`
}

// Sku the resource model definition representing SKU
type Sku struct {
	// Name - The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string `json:"name,omitempty"`
	// Tier - This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required on a PUT.
	Tier *string `json:"tier,omitempty"`
	// Size - The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string `json:"size,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// Capacity - If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the resource this may be omitted.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SloUsageMetric a Slo Usage Metric.
type SloUsageMetric struct {
	// ServiceLevelObjective - The serviceLevelObjective for SLO usage metric. Possible values include: 'ServiceObjectiveNameSystem', 'ServiceObjectiveNameSystem0', 'ServiceObjectiveNameSystem1', 'ServiceObjectiveNameSystem2', 'ServiceObjectiveNameSystem3', 'ServiceObjectiveNameSystem4', 'ServiceObjectiveNameSystem2L', 'ServiceObjectiveNameSystem3L', 'ServiceObjectiveNameSystem4L', 'ServiceObjectiveNameFree', 'ServiceObjectiveNameBasic', 'ServiceObjectiveNameS0', 'ServiceObjectiveNameS1', 'ServiceObjectiveNameS2', 'ServiceObjectiveNameS3', 'ServiceObjectiveNameS4', 'ServiceObjectiveNameS6', 'ServiceObjectiveNameS7', 'ServiceObjectiveNameS9', 'ServiceObjectiveNameS12', 'ServiceObjectiveNameP1', 'ServiceObjectiveNameP2', 'ServiceObjectiveNameP3', 'ServiceObjectiveNameP4', 'ServiceObjectiveNameP6', 'ServiceObjectiveNameP11', 'ServiceObjectiveNameP15', 'ServiceObjectiveNamePRS1', 'ServiceObjectiveNamePRS2', 'ServiceObjectiveNamePRS4', 'ServiceObjectiveNamePRS6', 'ServiceObjectiveNameDW100', 'ServiceObjectiveNameDW200', 'ServiceObjectiveNameDW300', 'ServiceObjectiveNameDW400', 'ServiceObjectiveNameDW500', 'ServiceObjectiveNameDW600', 'ServiceObjectiveNameDW1000', 'ServiceObjectiveNameDW1200', 'ServiceObjectiveNameDW1000c', 'ServiceObjectiveNameDW1500', 'ServiceObjectiveNameDW1500c', 'ServiceObjectiveNameDW2000', 'ServiceObjectiveNameDW2000c', 'ServiceObjectiveNameDW3000', 'ServiceObjectiveNameDW2500c', 'ServiceObjectiveNameDW3000c', 'ServiceObjectiveNameDW6000', 'ServiceObjectiveNameDW5000c', 'ServiceObjectiveNameDW6000c', 'ServiceObjectiveNameDW7500c', 'ServiceObjectiveNameDW10000c', 'ServiceObjectiveNameDW15000c', 'ServiceObjectiveNameDW30000c', 'ServiceObjectiveNameDS100', 'ServiceObjectiveNameDS200', 'ServiceObjectiveNameDS300', 'ServiceObjectiveNameDS400', 'ServiceObjectiveNameDS500', 'ServiceObjectiveNameDS600', 'ServiceObjectiveNameDS1000', 'ServiceObjectiveNameDS1200', 'ServiceObjectiveNameDS1500', 'ServiceObjectiveNameDS2000', 'ServiceObjectiveNameElasticPool'
	ServiceLevelObjective ServiceObjectiveName `json:"serviceLevelObjective,omitempty"`
	// ServiceLevelObjectiveID - The serviceLevelObjectiveId for SLO usage metric.
	ServiceLevelObjectiveID *uuid.UUID `json:"serviceLevelObjectiveId,omitempty"`
	// InRangeTimeRatio - Gets or sets inRangeTimeRatio for SLO usage metric.
	InRangeTimeRatio *float64 `json:"inRangeTimeRatio,omitempty"`
}

// SubscriptionUsage usage Metric of a Subscription in a Location.
type SubscriptionUsage struct {
	autorest.Response `json:"-"`
	// SubscriptionUsageProperties - Resource properties.
	*SubscriptionUsageProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SubscriptionUsage.
func (su SubscriptionUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if su.SubscriptionUsageProperties != nil {
		objectMap["properties"] = su.SubscriptionUsageProperties
	}
	if su.ID != nil {
		objectMap["id"] = su.ID
	}
	if su.Name != nil {
		objectMap["name"] = su.Name
	}
	if su.Type != nil {
		objectMap["type"] = su.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SubscriptionUsage struct.
func (su *SubscriptionUsage) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var subscriptionUsageProperties SubscriptionUsageProperties
				err = json.Unmarshal(*v, &subscriptionUsageProperties)
				if err != nil {
					return err
				}
				su.SubscriptionUsageProperties = &subscriptionUsageProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				su.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				su.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				su.Type = &typeVar
			}
		}
	}

	return nil
}

// SubscriptionUsageListResult a list of subscription usage metrics in a location.
type SubscriptionUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SubscriptionUsage `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SubscriptionUsageListResultIterator provides access to a complete listing of SubscriptionUsage values.
type SubscriptionUsageListResultIterator struct {
	i    int
	page SubscriptionUsageListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SubscriptionUsageListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SubscriptionUsageListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SubscriptionUsageListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SubscriptionUsageListResultIterator) Response() SubscriptionUsageListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SubscriptionUsageListResultIterator) Value() SubscriptionUsage {
	if !iter.page.NotDone() {
		return SubscriptionUsage{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SubscriptionUsageListResultIterator type.
func NewSubscriptionUsageListResultIterator(page SubscriptionUsageListResultPage) SubscriptionUsageListResultIterator {
	return SubscriptionUsageListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sulr SubscriptionUsageListResult) IsEmpty() bool {
	return sulr.Value == nil || len(*sulr.Value) == 0
}

// subscriptionUsageListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sulr SubscriptionUsageListResult) subscriptionUsageListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sulr.NextLink == nil || len(to.String(sulr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sulr.NextLink)))
}

// SubscriptionUsageListResultPage contains a page of SubscriptionUsage values.
type SubscriptionUsageListResultPage struct {
	fn   func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)
	sulr SubscriptionUsageListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SubscriptionUsageListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SubscriptionUsageListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sulr)
	if err != nil {
		return err
	}
	page.sulr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SubscriptionUsageListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SubscriptionUsageListResultPage) NotDone() bool {
	return !page.sulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SubscriptionUsageListResultPage) Response() SubscriptionUsageListResult {
	return page.sulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SubscriptionUsageListResultPage) Values() []SubscriptionUsage {
	if page.sulr.IsEmpty() {
		return nil
	}
	return *page.sulr.Value
}

// Creates a new instance of the SubscriptionUsageListResultPage type.
func NewSubscriptionUsageListResultPage(getNextPage func(context.Context, SubscriptionUsageListResult) (SubscriptionUsageListResult, error)) SubscriptionUsageListResultPage {
	return SubscriptionUsageListResultPage{fn: getNextPage}
}

// SubscriptionUsageProperties properties of a subscription usage.
type SubscriptionUsageProperties struct {
	// DisplayName - User-readable name of the metric.
	DisplayName *string `json:"displayName,omitempty"`
	// CurrentValue - Current value of the metric.
	CurrentValue *float64 `json:"currentValue,omitempty"`
	// Limit - Boundary value of the metric.
	Limit *float64 `json:"limit,omitempty"`
	// Unit - Unit of the metric.
	Unit *string `json:"unit,omitempty"`
}

// SyncAgent an Azure SQL Database sync agent.
type SyncAgent struct {
	autorest.Response `json:"-"`
	// SyncAgentProperties - Resource properties.
	*SyncAgentProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgent.
func (sa SyncAgent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.SyncAgentProperties != nil {
		objectMap["properties"] = sa.SyncAgentProperties
	}
	if sa.ID != nil {
		objectMap["id"] = sa.ID
	}
	if sa.Name != nil {
		objectMap["name"] = sa.Name
	}
	if sa.Type != nil {
		objectMap["type"] = sa.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgent struct.
func (sa *SyncAgent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentProperties SyncAgentProperties
				err = json.Unmarshal(*v, &syncAgentProperties)
				if err != nil {
					return err
				}
				sa.SyncAgentProperties = &syncAgentProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sa.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sa.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sa.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentKeyProperties properties of an Azure SQL Database sync agent key.
type SyncAgentKeyProperties struct {
	autorest.Response `json:"-"`
	// SyncAgentKey - Key of sync agent.
	SyncAgentKey *string `json:"syncAgentKey,omitempty"`
}

// SyncAgentLinkedDatabase an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabase struct {
	// SyncAgentLinkedDatabaseProperties - Resource properties.
	*SyncAgentLinkedDatabaseProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncAgentLinkedDatabase.
func (sald SyncAgentLinkedDatabase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sald.SyncAgentLinkedDatabaseProperties != nil {
		objectMap["properties"] = sald.SyncAgentLinkedDatabaseProperties
	}
	if sald.ID != nil {
		objectMap["id"] = sald.ID
	}
	if sald.Name != nil {
		objectMap["name"] = sald.Name
	}
	if sald.Type != nil {
		objectMap["type"] = sald.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncAgentLinkedDatabase struct.
func (sald *SyncAgentLinkedDatabase) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncAgentLinkedDatabaseProperties SyncAgentLinkedDatabaseProperties
				err = json.Unmarshal(*v, &syncAgentLinkedDatabaseProperties)
				if err != nil {
					return err
				}
				sald.SyncAgentLinkedDatabaseProperties = &syncAgentLinkedDatabaseProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sald.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sald.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sald.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncAgentLinkedDatabaseListResult a list of sync agent linked databases.
type SyncAgentLinkedDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncAgentLinkedDatabase `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentLinkedDatabaseListResultIterator provides access to a complete listing of
// SyncAgentLinkedDatabase values.
type SyncAgentLinkedDatabaseListResultIterator struct {
	i    int
	page SyncAgentLinkedDatabaseListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentLinkedDatabaseListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentLinkedDatabaseListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentLinkedDatabaseListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentLinkedDatabaseListResultIterator) Response() SyncAgentLinkedDatabaseListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentLinkedDatabaseListResultIterator) Value() SyncAgentLinkedDatabase {
	if !iter.page.NotDone() {
		return SyncAgentLinkedDatabase{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultIterator type.
func NewSyncAgentLinkedDatabaseListResultIterator(page SyncAgentLinkedDatabaseListResultPage) SyncAgentLinkedDatabaseListResultIterator {
	return SyncAgentLinkedDatabaseListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (saldlr SyncAgentLinkedDatabaseListResult) IsEmpty() bool {
	return saldlr.Value == nil || len(*saldlr.Value) == 0
}

// syncAgentLinkedDatabaseListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saldlr SyncAgentLinkedDatabaseListResult) syncAgentLinkedDatabaseListResultPreparer(ctx context.Context) (*http.Request, error) {
	if saldlr.NextLink == nil || len(to.String(saldlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saldlr.NextLink)))
}

// SyncAgentLinkedDatabaseListResultPage contains a page of SyncAgentLinkedDatabase values.
type SyncAgentLinkedDatabaseListResultPage struct {
	fn     func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)
	saldlr SyncAgentLinkedDatabaseListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentLinkedDatabaseListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentLinkedDatabaseListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.saldlr)
	if err != nil {
		return err
	}
	page.saldlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentLinkedDatabaseListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentLinkedDatabaseListResultPage) NotDone() bool {
	return !page.saldlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentLinkedDatabaseListResultPage) Response() SyncAgentLinkedDatabaseListResult {
	return page.saldlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentLinkedDatabaseListResultPage) Values() []SyncAgentLinkedDatabase {
	if page.saldlr.IsEmpty() {
		return nil
	}
	return *page.saldlr.Value
}

// Creates a new instance of the SyncAgentLinkedDatabaseListResultPage type.
func NewSyncAgentLinkedDatabaseListResultPage(getNextPage func(context.Context, SyncAgentLinkedDatabaseListResult) (SyncAgentLinkedDatabaseListResult, error)) SyncAgentLinkedDatabaseListResultPage {
	return SyncAgentLinkedDatabaseListResultPage{fn: getNextPage}
}

// SyncAgentLinkedDatabaseProperties properties of an Azure SQL Database sync agent linked database.
type SyncAgentLinkedDatabaseProperties struct {
	// DatabaseType - Type of the sync agent linked database. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// DatabaseID - Id of the sync agent linked database.
	DatabaseID *string `json:"databaseId,omitempty"`
	// Description - Description of the sync agent linked database.
	Description *string `json:"description,omitempty"`
	// ServerName - Server name of the sync agent linked database.
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Database name of the sync agent linked database.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - User name of the sync agent linked database.
	UserName *string `json:"userName,omitempty"`
}

// SyncAgentListResult a list of sync agents.
type SyncAgentListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncAgent `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncAgentListResultIterator provides access to a complete listing of SyncAgent values.
type SyncAgentListResultIterator struct {
	i    int
	page SyncAgentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncAgentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncAgentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncAgentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncAgentListResultIterator) Response() SyncAgentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncAgentListResultIterator) Value() SyncAgent {
	if !iter.page.NotDone() {
		return SyncAgent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncAgentListResultIterator type.
func NewSyncAgentListResultIterator(page SyncAgentListResultPage) SyncAgentListResultIterator {
	return SyncAgentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (salr SyncAgentListResult) IsEmpty() bool {
	return salr.Value == nil || len(*salr.Value) == 0
}

// syncAgentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (salr SyncAgentListResult) syncAgentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if salr.NextLink == nil || len(to.String(salr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(salr.NextLink)))
}

// SyncAgentListResultPage contains a page of SyncAgent values.
type SyncAgentListResultPage struct {
	fn   func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)
	salr SyncAgentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncAgentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncAgentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.salr)
	if err != nil {
		return err
	}
	page.salr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncAgentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncAgentListResultPage) NotDone() bool {
	return !page.salr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncAgentListResultPage) Response() SyncAgentListResult {
	return page.salr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncAgentListResultPage) Values() []SyncAgent {
	if page.salr.IsEmpty() {
		return nil
	}
	return *page.salr.Value
}

// Creates a new instance of the SyncAgentListResultPage type.
func NewSyncAgentListResultPage(getNextPage func(context.Context, SyncAgentListResult) (SyncAgentListResult, error)) SyncAgentListResultPage {
	return SyncAgentListResultPage{fn: getNextPage}
}

// SyncAgentProperties properties of an Azure SQL Database sync agent.
type SyncAgentProperties struct {
	// Name - Name of the sync agent.
	Name *string `json:"name,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync agent.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// LastAliveTime - Last alive time of the sync agent.
	LastAliveTime *date.Time `json:"lastAliveTime,omitempty"`
	// State - State of the sync agent. Possible values include: 'SyncAgentStateOnline', 'SyncAgentStateOffline', 'SyncAgentStateNeverConnected'
	State SyncAgentState `json:"state,omitempty"`
	// IsUpToDate - If the sync agent version is up to date.
	IsUpToDate *bool `json:"isUpToDate,omitempty"`
	// ExpiryTime - Expiration time of the sync agent version.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// Version - Version of the sync agent.
	Version *string `json:"version,omitempty"`
}

// SyncAgentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncAgentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncAgentsCreateOrUpdateFuture) Result(client SyncAgentsClient) (sa SyncAgent, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncAgentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncAgentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sa.Response.Response, err = future.GetResult(sender); err == nil && sa.Response.Response.StatusCode != http.StatusNoContent {
		sa, err = client.CreateOrUpdateResponder(sa.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncAgentsCreateOrUpdateFuture", "Result", sa.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncAgentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncAgentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncAgentsDeleteFuture) Result(client SyncAgentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncAgentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncAgentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncDatabaseIDListResult a list of sync database ID properties.
type SyncDatabaseIDListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncDatabaseIDProperties `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncDatabaseIDListResultIterator provides access to a complete listing of SyncDatabaseIDProperties
// values.
type SyncDatabaseIDListResultIterator struct {
	i    int
	page SyncDatabaseIDListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncDatabaseIDListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncDatabaseIDListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncDatabaseIDListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncDatabaseIDListResultIterator) Response() SyncDatabaseIDListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncDatabaseIDListResultIterator) Value() SyncDatabaseIDProperties {
	if !iter.page.NotDone() {
		return SyncDatabaseIDProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncDatabaseIDListResultIterator type.
func NewSyncDatabaseIDListResultIterator(page SyncDatabaseIDListResultPage) SyncDatabaseIDListResultIterator {
	return SyncDatabaseIDListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sdilr SyncDatabaseIDListResult) IsEmpty() bool {
	return sdilr.Value == nil || len(*sdilr.Value) == 0
}

// syncDatabaseIDListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sdilr SyncDatabaseIDListResult) syncDatabaseIDListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sdilr.NextLink == nil || len(to.String(sdilr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sdilr.NextLink)))
}

// SyncDatabaseIDListResultPage contains a page of SyncDatabaseIDProperties values.
type SyncDatabaseIDListResultPage struct {
	fn    func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)
	sdilr SyncDatabaseIDListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncDatabaseIDListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncDatabaseIDListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sdilr)
	if err != nil {
		return err
	}
	page.sdilr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncDatabaseIDListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncDatabaseIDListResultPage) NotDone() bool {
	return !page.sdilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncDatabaseIDListResultPage) Response() SyncDatabaseIDListResult {
	return page.sdilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncDatabaseIDListResultPage) Values() []SyncDatabaseIDProperties {
	if page.sdilr.IsEmpty() {
		return nil
	}
	return *page.sdilr.Value
}

// Creates a new instance of the SyncDatabaseIDListResultPage type.
func NewSyncDatabaseIDListResultPage(getNextPage func(context.Context, SyncDatabaseIDListResult) (SyncDatabaseIDListResult, error)) SyncDatabaseIDListResultPage {
	return SyncDatabaseIDListResultPage{fn: getNextPage}
}

// SyncDatabaseIDProperties properties of the sync database id.
type SyncDatabaseIDProperties struct {
	// ID - ARM resource id of sync database.
	ID *string `json:"id,omitempty"`
}

// SyncFullSchemaProperties properties of the database full schema.
type SyncFullSchemaProperties struct {
	// Tables - List of tables in the database full schema.
	Tables *[]SyncFullSchemaTable `json:"tables,omitempty"`
	// LastUpdateTime - Last update time of the database schema.
	LastUpdateTime *date.Time `json:"lastUpdateTime,omitempty"`
}

// SyncFullSchemaPropertiesListResult a list of sync schema properties.
type SyncFullSchemaPropertiesListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncFullSchemaProperties `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncFullSchemaPropertiesListResultIterator provides access to a complete listing of
// SyncFullSchemaProperties values.
type SyncFullSchemaPropertiesListResultIterator struct {
	i    int
	page SyncFullSchemaPropertiesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncFullSchemaPropertiesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncFullSchemaPropertiesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncFullSchemaPropertiesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncFullSchemaPropertiesListResultIterator) Response() SyncFullSchemaPropertiesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncFullSchemaPropertiesListResultIterator) Value() SyncFullSchemaProperties {
	if !iter.page.NotDone() {
		return SyncFullSchemaProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultIterator type.
func NewSyncFullSchemaPropertiesListResultIterator(page SyncFullSchemaPropertiesListResultPage) SyncFullSchemaPropertiesListResultIterator {
	return SyncFullSchemaPropertiesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sfsplr SyncFullSchemaPropertiesListResult) IsEmpty() bool {
	return sfsplr.Value == nil || len(*sfsplr.Value) == 0
}

// syncFullSchemaPropertiesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sfsplr SyncFullSchemaPropertiesListResult) syncFullSchemaPropertiesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sfsplr.NextLink == nil || len(to.String(sfsplr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sfsplr.NextLink)))
}

// SyncFullSchemaPropertiesListResultPage contains a page of SyncFullSchemaProperties values.
type SyncFullSchemaPropertiesListResultPage struct {
	fn     func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)
	sfsplr SyncFullSchemaPropertiesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncFullSchemaPropertiesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncFullSchemaPropertiesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sfsplr)
	if err != nil {
		return err
	}
	page.sfsplr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncFullSchemaPropertiesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncFullSchemaPropertiesListResultPage) NotDone() bool {
	return !page.sfsplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncFullSchemaPropertiesListResultPage) Response() SyncFullSchemaPropertiesListResult {
	return page.sfsplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncFullSchemaPropertiesListResultPage) Values() []SyncFullSchemaProperties {
	if page.sfsplr.IsEmpty() {
		return nil
	}
	return *page.sfsplr.Value
}

// Creates a new instance of the SyncFullSchemaPropertiesListResultPage type.
func NewSyncFullSchemaPropertiesListResultPage(getNextPage func(context.Context, SyncFullSchemaPropertiesListResult) (SyncFullSchemaPropertiesListResult, error)) SyncFullSchemaPropertiesListResultPage {
	return SyncFullSchemaPropertiesListResultPage{fn: getNextPage}
}

// SyncFullSchemaTable properties of the table in the database full schema.
type SyncFullSchemaTable struct {
	// Columns - List of columns in the table of database full schema.
	Columns *[]SyncFullSchemaTableColumn `json:"columns,omitempty"`
	// ErrorID - Error id of the table.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// Name - Name of the table.
	Name *string `json:"name,omitempty"`
	// QuotedName - Quoted name of the table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncFullSchemaTableColumn properties of the column in the table of database full schema.
type SyncFullSchemaTableColumn struct {
	// DataSize - Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - Data type of the column.
	DataType *string `json:"dataType,omitempty"`
	// ErrorID - Error id of the column.
	ErrorID *string `json:"errorId,omitempty"`
	// HasError - If there is error in the table.
	HasError *bool `json:"hasError,omitempty"`
	// IsPrimaryKey - If it is the primary key of the table.
	IsPrimaryKey *bool `json:"isPrimaryKey,omitempty"`
	// Name - Name of the column.
	Name *string `json:"name,omitempty"`
	// QuotedName - Quoted name of the column.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroup an Azure SQL Database sync group.
type SyncGroup struct {
	autorest.Response `json:"-"`
	// SyncGroupProperties - Resource properties.
	*SyncGroupProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncGroup.
func (sg SyncGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sg.SyncGroupProperties != nil {
		objectMap["properties"] = sg.SyncGroupProperties
	}
	if sg.ID != nil {
		objectMap["id"] = sg.ID
	}
	if sg.Name != nil {
		objectMap["name"] = sg.Name
	}
	if sg.Type != nil {
		objectMap["type"] = sg.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncGroup struct.
func (sg *SyncGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncGroupProperties SyncGroupProperties
				err = json.Unmarshal(*v, &syncGroupProperties)
				if err != nil {
					return err
				}
				sg.SyncGroupProperties = &syncGroupProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sg.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sg.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sg.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncGroupListResult a list of sync groups.
type SyncGroupListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncGroup `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupListResultIterator provides access to a complete listing of SyncGroup values.
type SyncGroupListResultIterator struct {
	i    int
	page SyncGroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupListResultIterator) Response() SyncGroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupListResultIterator) Value() SyncGroup {
	if !iter.page.NotDone() {
		return SyncGroup{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupListResultIterator type.
func NewSyncGroupListResultIterator(page SyncGroupListResultPage) SyncGroupListResultIterator {
	return SyncGroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sglr SyncGroupListResult) IsEmpty() bool {
	return sglr.Value == nil || len(*sglr.Value) == 0
}

// syncGroupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sglr SyncGroupListResult) syncGroupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sglr.NextLink == nil || len(to.String(sglr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sglr.NextLink)))
}

// SyncGroupListResultPage contains a page of SyncGroup values.
type SyncGroupListResultPage struct {
	fn   func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)
	sglr SyncGroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sglr)
	if err != nil {
		return err
	}
	page.sglr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupListResultPage) NotDone() bool {
	return !page.sglr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupListResultPage) Response() SyncGroupListResult {
	return page.sglr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupListResultPage) Values() []SyncGroup {
	if page.sglr.IsEmpty() {
		return nil
	}
	return *page.sglr.Value
}

// Creates a new instance of the SyncGroupListResultPage type.
func NewSyncGroupListResultPage(getNextPage func(context.Context, SyncGroupListResult) (SyncGroupListResult, error)) SyncGroupListResultPage {
	return SyncGroupListResultPage{fn: getNextPage}
}

// SyncGroupLogListResult a list of sync group log properties.
type SyncGroupLogListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncGroupLogProperties `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncGroupLogListResultIterator provides access to a complete listing of SyncGroupLogProperties values.
type SyncGroupLogListResultIterator struct {
	i    int
	page SyncGroupLogListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncGroupLogListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncGroupLogListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncGroupLogListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncGroupLogListResultIterator) Response() SyncGroupLogListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncGroupLogListResultIterator) Value() SyncGroupLogProperties {
	if !iter.page.NotDone() {
		return SyncGroupLogProperties{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncGroupLogListResultIterator type.
func NewSyncGroupLogListResultIterator(page SyncGroupLogListResultPage) SyncGroupLogListResultIterator {
	return SyncGroupLogListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sgllr SyncGroupLogListResult) IsEmpty() bool {
	return sgllr.Value == nil || len(*sgllr.Value) == 0
}

// syncGroupLogListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sgllr SyncGroupLogListResult) syncGroupLogListResultPreparer(ctx context.Context) (*http.Request, error) {
	if sgllr.NextLink == nil || len(to.String(sgllr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sgllr.NextLink)))
}

// SyncGroupLogListResultPage contains a page of SyncGroupLogProperties values.
type SyncGroupLogListResultPage struct {
	fn    func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)
	sgllr SyncGroupLogListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncGroupLogListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncGroupLogListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.sgllr)
	if err != nil {
		return err
	}
	page.sgllr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncGroupLogListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncGroupLogListResultPage) NotDone() bool {
	return !page.sgllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncGroupLogListResultPage) Response() SyncGroupLogListResult {
	return page.sgllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncGroupLogListResultPage) Values() []SyncGroupLogProperties {
	if page.sgllr.IsEmpty() {
		return nil
	}
	return *page.sgllr.Value
}

// Creates a new instance of the SyncGroupLogListResultPage type.
func NewSyncGroupLogListResultPage(getNextPage func(context.Context, SyncGroupLogListResult) (SyncGroupLogListResult, error)) SyncGroupLogListResultPage {
	return SyncGroupLogListResultPage{fn: getNextPage}
}

// SyncGroupLogProperties properties of an Azure SQL Database sync group log.
type SyncGroupLogProperties struct {
	// Timestamp - Timestamp of the sync group log.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Type - Type of the sync group log. Possible values include: 'SyncGroupLogTypeAll', 'SyncGroupLogTypeError', 'SyncGroupLogTypeWarning', 'SyncGroupLogTypeSuccess'
	Type SyncGroupLogType `json:"type,omitempty"`
	// Source - Source of the sync group log.
	Source *string `json:"source,omitempty"`
	// Details - Details of the sync group log.
	Details *string `json:"details,omitempty"`
	// TracingID - TracingId of the sync group log.
	TracingID *uuid.UUID `json:"tracingId,omitempty"`
	// OperationStatus - OperationStatus of the sync group log.
	OperationStatus *string `json:"operationStatus,omitempty"`
}

// SyncGroupProperties properties of a sync group.
type SyncGroupProperties struct {
	// Interval - Sync interval of the sync group.
	Interval *int32 `json:"interval,omitempty"`
	// LastSyncTime - Last sync time of the sync group.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// ConflictResolutionPolicy - Conflict resolution policy of the sync group. Possible values include: 'HubWin', 'MemberWin'
	ConflictResolutionPolicy SyncConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// SyncDatabaseID - ARM resource id of the sync database in the sync group.
	SyncDatabaseID *string `json:"syncDatabaseId,omitempty"`
	// HubDatabaseUserName - User name for the sync group hub database credential.
	HubDatabaseUserName *string `json:"hubDatabaseUserName,omitempty"`
	// HubDatabasePassword - Password for the sync group hub database credential.
	HubDatabasePassword *string `json:"hubDatabasePassword,omitempty"`
	// SyncState - Sync state of the sync group. Possible values include: 'NotReady', 'Error', 'Warning', 'Progressing', 'Good'
	SyncState SyncGroupState `json:"syncState,omitempty"`
	// Schema - Sync schema of the sync group.
	Schema *SyncGroupSchema `json:"schema,omitempty"`
}

// SyncGroupSchema properties of sync group schema.
type SyncGroupSchema struct {
	// Tables - List of tables in sync group schema.
	Tables *[]SyncGroupSchemaTable `json:"tables,omitempty"`
	// MasterSyncMemberName - Name of master sync member where the schema is from.
	MasterSyncMemberName *string `json:"masterSyncMemberName,omitempty"`
}

// SyncGroupSchemaTable properties of table in sync group schema.
type SyncGroupSchemaTable struct {
	// Columns - List of columns in sync group schema.
	Columns *[]SyncGroupSchemaTableColumn `json:"columns,omitempty"`
	// QuotedName - Quoted name of sync group schema table.
	QuotedName *string `json:"quotedName,omitempty"`
}

// SyncGroupSchemaTableColumn properties of column in sync group table.
type SyncGroupSchemaTableColumn struct {
	// QuotedName - Quoted name of sync group table column.
	QuotedName *string `json:"quotedName,omitempty"`
	// DataSize - Data size of the column.
	DataSize *string `json:"dataSize,omitempty"`
	// DataType - Data type of the column.
	DataType *string `json:"dataType,omitempty"`
}

// SyncGroupsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncGroupsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsCreateOrUpdateFuture) Result(client SyncGroupsClient) (sg SyncGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sg.Response.Response, err = future.GetResult(sender); err == nil && sg.Response.Response.StatusCode != http.StatusNoContent {
		sg, err = client.CreateOrUpdateResponder(sg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncGroupsCreateOrUpdateFuture", "Result", sg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncGroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsDeleteFuture) Result(client SyncGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncGroupsRefreshHubSchemaFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncGroupsRefreshHubSchemaFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsRefreshHubSchemaFuture) Result(client SyncGroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsRefreshHubSchemaFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsRefreshHubSchemaFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncGroupsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncGroupsUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncGroupsUpdateFuture) Result(client SyncGroupsClient) (sg SyncGroup, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncGroupsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncGroupsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sg.Response.Response, err = future.GetResult(sender); err == nil && sg.Response.Response.StatusCode != http.StatusNoContent {
		sg, err = client.UpdateResponder(sg.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncGroupsUpdateFuture", "Result", sg.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncMember an Azure SQL Database sync member.
type SyncMember struct {
	autorest.Response `json:"-"`
	// SyncMemberProperties - Resource properties.
	*SyncMemberProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncMember.
func (sm SyncMember) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sm.SyncMemberProperties != nil {
		objectMap["properties"] = sm.SyncMemberProperties
	}
	if sm.ID != nil {
		objectMap["id"] = sm.ID
	}
	if sm.Name != nil {
		objectMap["name"] = sm.Name
	}
	if sm.Type != nil {
		objectMap["type"] = sm.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SyncMember struct.
func (sm *SyncMember) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var syncMemberProperties SyncMemberProperties
				err = json.Unmarshal(*v, &syncMemberProperties)
				if err != nil {
					return err
				}
				sm.SyncMemberProperties = &syncMemberProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sm.Type = &typeVar
			}
		}
	}

	return nil
}

// SyncMemberListResult a list of Azure SQL Database sync members.
type SyncMemberListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]SyncMember `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// SyncMemberListResultIterator provides access to a complete listing of SyncMember values.
type SyncMemberListResultIterator struct {
	i    int
	page SyncMemberListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SyncMemberListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SyncMemberListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SyncMemberListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SyncMemberListResultIterator) Response() SyncMemberListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SyncMemberListResultIterator) Value() SyncMember {
	if !iter.page.NotDone() {
		return SyncMember{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SyncMemberListResultIterator type.
func NewSyncMemberListResultIterator(page SyncMemberListResultPage) SyncMemberListResultIterator {
	return SyncMemberListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smlr SyncMemberListResult) IsEmpty() bool {
	return smlr.Value == nil || len(*smlr.Value) == 0
}

// syncMemberListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smlr SyncMemberListResult) syncMemberListResultPreparer(ctx context.Context) (*http.Request, error) {
	if smlr.NextLink == nil || len(to.String(smlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smlr.NextLink)))
}

// SyncMemberListResultPage contains a page of SyncMember values.
type SyncMemberListResultPage struct {
	fn   func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)
	smlr SyncMemberListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SyncMemberListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SyncMemberListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.smlr)
	if err != nil {
		return err
	}
	page.smlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SyncMemberListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SyncMemberListResultPage) NotDone() bool {
	return !page.smlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SyncMemberListResultPage) Response() SyncMemberListResult {
	return page.smlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SyncMemberListResultPage) Values() []SyncMember {
	if page.smlr.IsEmpty() {
		return nil
	}
	return *page.smlr.Value
}

// Creates a new instance of the SyncMemberListResultPage type.
func NewSyncMemberListResultPage(getNextPage func(context.Context, SyncMemberListResult) (SyncMemberListResult, error)) SyncMemberListResultPage {
	return SyncMemberListResultPage{fn: getNextPage}
}

// SyncMemberProperties properties of a sync member.
type SyncMemberProperties struct {
	// DatabaseType - Database type of the sync member. Possible values include: 'AzureSQLDatabase', 'SQLServerDatabase'
	DatabaseType SyncMemberDbType `json:"databaseType,omitempty"`
	// SyncAgentID - ARM resource id of the sync agent in the sync member.
	SyncAgentID *string `json:"syncAgentId,omitempty"`
	// SQLServerDatabaseID - SQL Server database id of the sync member.
	SQLServerDatabaseID *uuid.UUID `json:"sqlServerDatabaseId,omitempty"`
	// ServerName - Server name of the member database in the sync member
	ServerName *string `json:"serverName,omitempty"`
	// DatabaseName - Database name of the member database in the sync member.
	DatabaseName *string `json:"databaseName,omitempty"`
	// UserName - User name of the member database in the sync member.
	UserName *string `json:"userName,omitempty"`
	// Password - Password of the member database in the sync member.
	Password *string `json:"password,omitempty"`
	// SyncDirection - Sync direction of the sync member. Possible values include: 'Bidirectional', 'OneWayMemberToHub', 'OneWayHubToMember'
	SyncDirection SyncDirection `json:"syncDirection,omitempty"`
	// SyncState - Sync state of the sync member. Possible values include: 'SyncInProgress', 'SyncSucceeded', 'SyncFailed', 'DisabledTombstoneCleanup', 'DisabledBackupRestore', 'SyncSucceededWithWarnings', 'SyncCancelling', 'SyncCancelled', 'UnProvisioned', 'Provisioning', 'Provisioned', 'ProvisionFailed', 'DeProvisioning', 'DeProvisioned', 'DeProvisionFailed', 'Reprovisioning', 'ReprovisionFailed', 'UnReprovisioned'
	SyncState SyncMemberState `json:"syncState,omitempty"`
}

// SyncMembersCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncMembersCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersCreateOrUpdateFuture) Result(client SyncMembersClient) (sm SyncMember, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.CreateOrUpdateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncMembersCreateOrUpdateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SyncMembersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersDeleteFuture) Result(client SyncMembersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncMembersRefreshMemberSchemaFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SyncMembersRefreshMemberSchemaFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersRefreshMemberSchemaFuture) Result(client SyncMembersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersRefreshMemberSchemaFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersRefreshMemberSchemaFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SyncMembersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type SyncMembersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *SyncMembersUpdateFuture) Result(client SyncMembersClient) (sm SyncMember, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.SyncMembersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.SyncMembersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.UpdateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.SyncMembersUpdateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TrackedResource ARM tracked top level resource.
type TrackedResource struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// TransparentDataEncryption represents a database transparent data encryption configuration.
type TransparentDataEncryption struct {
	autorest.Response `json:"-"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionProperties - Represents the properties of the resource.
	*TransparentDataEncryptionProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryption.
func (tde TransparentDataEncryption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tde.Location != nil {
		objectMap["location"] = tde.Location
	}
	if tde.TransparentDataEncryptionProperties != nil {
		objectMap["properties"] = tde.TransparentDataEncryptionProperties
	}
	if tde.ID != nil {
		objectMap["id"] = tde.ID
	}
	if tde.Name != nil {
		objectMap["name"] = tde.Name
	}
	if tde.Type != nil {
		objectMap["type"] = tde.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryption struct.
func (tde *TransparentDataEncryption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tde.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionProperties TransparentDataEncryptionProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionProperties)
				if err != nil {
					return err
				}
				tde.TransparentDataEncryptionProperties = &transparentDataEncryptionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tde.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tde.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tde.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivity represents a database transparent data encryption Scan.
type TransparentDataEncryptionActivity struct {
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// TransparentDataEncryptionActivityProperties - Represents the properties of the resource.
	*TransparentDataEncryptionActivityProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransparentDataEncryptionActivity.
func (tdea TransparentDataEncryptionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tdea.Location != nil {
		objectMap["location"] = tdea.Location
	}
	if tdea.TransparentDataEncryptionActivityProperties != nil {
		objectMap["properties"] = tdea.TransparentDataEncryptionActivityProperties
	}
	if tdea.ID != nil {
		objectMap["id"] = tdea.ID
	}
	if tdea.Name != nil {
		objectMap["name"] = tdea.Name
	}
	if tdea.Type != nil {
		objectMap["type"] = tdea.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TransparentDataEncryptionActivity struct.
func (tdea *TransparentDataEncryptionActivity) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tdea.Location = &location
			}
		case "properties":
			if v != nil {
				var transparentDataEncryptionActivityProperties TransparentDataEncryptionActivityProperties
				err = json.Unmarshal(*v, &transparentDataEncryptionActivityProperties)
				if err != nil {
					return err
				}
				tdea.TransparentDataEncryptionActivityProperties = &transparentDataEncryptionActivityProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tdea.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tdea.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tdea.Type = &typeVar
			}
		}
	}

	return nil
}

// TransparentDataEncryptionActivityListResult represents the response to a list database transparent data
// encryption activity request.
type TransparentDataEncryptionActivityListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of database transparent data encryption activities.
	Value *[]TransparentDataEncryptionActivity `json:"value,omitempty"`
}

// TransparentDataEncryptionActivityProperties represents the properties of a database transparent data
// encryption Scan.
type TransparentDataEncryptionActivityProperties struct {
	// Status - The status of the database. Possible values include: 'Encrypting', 'Decrypting'
	Status TransparentDataEncryptionActivityStatus `json:"status,omitempty"`
	// PercentComplete - The percent complete of the transparent data encryption scan for a database.
	PercentComplete *float64 `json:"percentComplete,omitempty"`
}

// TransparentDataEncryptionProperties represents the properties of a database transparent data encryption.
type TransparentDataEncryptionProperties struct {
	// Status - The status of the database transparent data encryption. Possible values include: 'TransparentDataEncryptionStatusEnabled', 'TransparentDataEncryptionStatusDisabled'
	Status TransparentDataEncryptionStatus `json:"status,omitempty"`
}

// VirtualCluster an Azure SQL virtual cluster.
type VirtualCluster struct {
	autorest.Response `json:"-"`
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualCluster.
func (vc VirtualCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vc.VirtualClusterProperties != nil {
		objectMap["properties"] = vc.VirtualClusterProperties
	}
	if vc.Location != nil {
		objectMap["location"] = vc.Location
	}
	if vc.Tags != nil {
		objectMap["tags"] = vc.Tags
	}
	if vc.ID != nil {
		objectMap["id"] = vc.ID
	}
	if vc.Name != nil {
		objectMap["name"] = vc.Name
	}
	if vc.Type != nil {
		objectMap["type"] = vc.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualCluster struct.
func (vc *VirtualCluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vc.VirtualClusterProperties = &virtualClusterProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				vc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vc.Tags = tags
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vc.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualClusterListResult a list of virtual clusters.
type VirtualClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]VirtualCluster `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualClusterListResultIterator provides access to a complete listing of VirtualCluster values.
type VirtualClusterListResultIterator struct {
	i    int
	page VirtualClusterListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualClusterListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualClusterListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualClusterListResultIterator) Response() VirtualClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualClusterListResultIterator) Value() VirtualCluster {
	if !iter.page.NotDone() {
		return VirtualCluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualClusterListResultIterator type.
func NewVirtualClusterListResultIterator(page VirtualClusterListResultPage) VirtualClusterListResultIterator {
	return VirtualClusterListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vclr VirtualClusterListResult) IsEmpty() bool {
	return vclr.Value == nil || len(*vclr.Value) == 0
}

// virtualClusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vclr VirtualClusterListResult) virtualClusterListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vclr.NextLink == nil || len(to.String(vclr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vclr.NextLink)))
}

// VirtualClusterListResultPage contains a page of VirtualCluster values.
type VirtualClusterListResultPage struct {
	fn   func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)
	vclr VirtualClusterListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualClusterListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualClusterListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vclr)
	if err != nil {
		return err
	}
	page.vclr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualClusterListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualClusterListResultPage) NotDone() bool {
	return !page.vclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualClusterListResultPage) Response() VirtualClusterListResult {
	return page.vclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualClusterListResultPage) Values() []VirtualCluster {
	if page.vclr.IsEmpty() {
		return nil
	}
	return *page.vclr.Value
}

// Creates a new instance of the VirtualClusterListResultPage type.
func NewVirtualClusterListResultPage(getNextPage func(context.Context, VirtualClusterListResult) (VirtualClusterListResult, error)) VirtualClusterListResultPage {
	return VirtualClusterListResultPage{fn: getNextPage}
}

// VirtualClusterProperties the properties of a virtual cluster.
type VirtualClusterProperties struct {
	// SubnetID - Subnet resource ID for the virtual cluster.
	SubnetID *string `json:"subnetId,omitempty"`
	// Family - If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string `json:"family,omitempty"`
	// ChildResources - List of resources in this virtual cluster.
	ChildResources *[]string `json:"childResources,omitempty"`
}

// VirtualClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualClustersDeleteFuture) Result(client VirtualClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualClustersUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VirtualClustersUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualClustersUpdateFuture) Result(client VirtualClustersClient) (vc VirtualCluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualClustersUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualClustersUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vc.Response.Response, err = future.GetResult(sender); err == nil && vc.Response.Response.StatusCode != http.StatusNoContent {
		vc, err = client.UpdateResponder(vc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.VirtualClustersUpdateFuture", "Result", vc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualClusterUpdate an update request for an Azure SQL Database virtual cluster.
type VirtualClusterUpdate struct {
	// VirtualClusterProperties - Resource properties.
	*VirtualClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for VirtualClusterUpdate.
func (vcu VirtualClusterUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcu.VirtualClusterProperties != nil {
		objectMap["properties"] = vcu.VirtualClusterProperties
	}
	if vcu.Tags != nil {
		objectMap["tags"] = vcu.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualClusterUpdate struct.
func (vcu *VirtualClusterUpdate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualClusterProperties VirtualClusterProperties
				err = json.Unmarshal(*v, &virtualClusterProperties)
				if err != nil {
					return err
				}
				vcu.VirtualClusterProperties = &virtualClusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				vcu.Tags = tags
			}
		}
	}

	return nil
}

// VirtualNetworkRule a virtual network rule.
type VirtualNetworkRule struct {
	autorest.Response `json:"-"`
	// VirtualNetworkRuleProperties - Resource properties.
	*VirtualNetworkRuleProperties `json:"properties,omitempty"`
	// ID - Resource ID.
	ID *string `json:"id,omitempty"`
	// Name - Resource name.
	Name *string `json:"name,omitempty"`
	// Type - Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkRule.
func (vnr VirtualNetworkRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vnr.VirtualNetworkRuleProperties != nil {
		objectMap["properties"] = vnr.VirtualNetworkRuleProperties
	}
	if vnr.ID != nil {
		objectMap["id"] = vnr.ID
	}
	if vnr.Name != nil {
		objectMap["name"] = vnr.Name
	}
	if vnr.Type != nil {
		objectMap["type"] = vnr.Type
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for VirtualNetworkRule struct.
func (vnr *VirtualNetworkRule) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var virtualNetworkRuleProperties VirtualNetworkRuleProperties
				err = json.Unmarshal(*v, &virtualNetworkRuleProperties)
				if err != nil {
					return err
				}
				vnr.VirtualNetworkRuleProperties = &virtualNetworkRuleProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				vnr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				vnr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				vnr.Type = &typeVar
			}
		}
	}

	return nil
}

// VirtualNetworkRuleListResult a list of virtual network rules.
type VirtualNetworkRuleListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of results.
	Value *[]VirtualNetworkRule `json:"value,omitempty"`
	// NextLink - Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// VirtualNetworkRuleListResultIterator provides access to a complete listing of VirtualNetworkRule values.
type VirtualNetworkRuleListResultIterator struct {
	i    int
	page VirtualNetworkRuleListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VirtualNetworkRuleListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VirtualNetworkRuleListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VirtualNetworkRuleListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VirtualNetworkRuleListResultIterator) Response() VirtualNetworkRuleListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VirtualNetworkRuleListResultIterator) Value() VirtualNetworkRule {
	if !iter.page.NotDone() {
		return VirtualNetworkRule{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VirtualNetworkRuleListResultIterator type.
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return VirtualNetworkRuleListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vnrlr VirtualNetworkRuleListResult) IsEmpty() bool {
	return vnrlr.Value == nil || len(*vnrlr.Value) == 0
}

// virtualNetworkRuleListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vnrlr VirtualNetworkRuleListResult) virtualNetworkRuleListResultPreparer(ctx context.Context) (*http.Request, error) {
	if vnrlr.NextLink == nil || len(to.String(vnrlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vnrlr.NextLink)))
}

// VirtualNetworkRuleListResultPage contains a page of VirtualNetworkRule values.
type VirtualNetworkRuleListResultPage struct {
	fn    func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)
	vnrlr VirtualNetworkRuleListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VirtualNetworkRuleListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VirtualNetworkRuleListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.vnrlr)
	if err != nil {
		return err
	}
	page.vnrlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VirtualNetworkRuleListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VirtualNetworkRuleListResultPage) NotDone() bool {
	return !page.vnrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VirtualNetworkRuleListResultPage) Response() VirtualNetworkRuleListResult {
	return page.vnrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VirtualNetworkRuleListResultPage) Values() []VirtualNetworkRule {
	if page.vnrlr.IsEmpty() {
		return nil
	}
	return *page.vnrlr.Value
}

// Creates a new instance of the VirtualNetworkRuleListResultPage type.
func NewVirtualNetworkRuleListResultPage(getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return VirtualNetworkRuleListResultPage{fn: getNextPage}
}

// VirtualNetworkRuleProperties properties of a virtual network rule.
type VirtualNetworkRuleProperties struct {
	// VirtualNetworkSubnetID - The ARM resource id of the virtual network subnet.
	VirtualNetworkSubnetID *string `json:"virtualNetworkSubnetId,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
	// State - Virtual Network Rule State. Possible values include: 'VirtualNetworkRuleStateInitializing', 'VirtualNetworkRuleStateInProgress', 'VirtualNetworkRuleStateReady', 'VirtualNetworkRuleStateDeleting', 'VirtualNetworkRuleStateUnknown'
	State VirtualNetworkRuleState `json:"state,omitempty"`
}

// VirtualNetworkRulesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkRulesCreateOrUpdateFuture) Result(client VirtualNetworkRulesClient) (vnr VirtualNetworkRule, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualNetworkRulesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vnr.Response.Response, err = future.GetResult(sender); err == nil && vnr.Response.Response.StatusCode != http.StatusNoContent {
		vnr, err = client.CreateOrUpdateResponder(vnr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesCreateOrUpdateFuture", "Result", vnr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VirtualNetworkRulesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type VirtualNetworkRulesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *VirtualNetworkRulesDeleteFuture) Result(client VirtualNetworkRulesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VirtualNetworkRulesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("sql.VirtualNetworkRulesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VulnerabilityAssessmentRecurringScansProperties properties of a Vulnerability Assessment recurring
// scans.
type VulnerabilityAssessmentRecurringScansProperties struct {
	// IsEnabled - Recurring scans state.
	IsEnabled *bool `json:"isEnabled,omitempty"`
	// EmailSubscriptionAdmins - Specifies that the schedule scan notification will be is sent to the subscription administrators.
	EmailSubscriptionAdmins *bool `json:"emailSubscriptionAdmins,omitempty"`
	// Emails - Specifies an array of e-mail addresses to which the scan notification is sent.
	Emails *[]string `json:"emails,omitempty"`
}
