// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideo

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateStream = "CreateStream"

// CreateStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStream for more information on using the CreateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStreamRequest method.
//    req, resp := client.CreateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/CreateStream
func (c *KinesisVideo) CreateStreamRequest(input *CreateStreamInput) (req *request.Request, output *CreateStreamOutput) {
	op := &request.Operation{
		Name:       opCreateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/createStream",
	}

	if input == nil {
		input = &CreateStreamInput{}
	}

	output = &CreateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStream API operation for Amazon Kinesis Video Streams.
//
// Creates a new Kinesis video stream.
//
// When you create a new stream, Kinesis Video Streams assigns it a version
// number. When you change the stream's metadata, Kinesis Video Streams updates
// the version.
//
// CreateStream is an asynchronous operation.
//
// For information about how the service works, see How it Works (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html).
//
// You must have permissions for the KinesisVideo:CreateStream action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation CreateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeAccountStreamLimitExceededException "AccountStreamLimitExceededException"
//   The number of streams created for the account is too high.
//
//   * ErrCodeDeviceStreamLimitExceededException "DeviceStreamLimitExceededException"
//   Not implemented.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The stream is currently not available for this operation.
//
//   * ErrCodeInvalidDeviceException "InvalidDeviceException"
//   Not implemented.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/CreateStream
func (c *KinesisVideo) CreateStream(input *CreateStreamInput) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	return out, req.Send()
}

// CreateStreamWithContext is the same as CreateStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) CreateStreamWithContext(ctx aws.Context, input *CreateStreamInput, opts ...request.Option) (*CreateStreamOutput, error) {
	req, out := c.CreateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStream for more information on using the DeleteStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStreamRequest method.
//    req, resp := client.DeleteStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteStream
func (c *KinesisVideo) DeleteStreamRequest(input *DeleteStreamInput) (req *request.Request, output *DeleteStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteStream",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	output = &DeleteStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteStream API operation for Amazon Kinesis Video Streams.
//
// Deletes a Kinesis video stream and the data contained in the stream.
//
// This method marks the stream for deletion, and makes the data in the stream
// inaccessible immediately.
//
// To ensure that you have the latest version of the stream before deleting
// it, you can specify the stream version. Kinesis Video Streams assigns a version
// to each stream. When you update a stream, Kinesis Video Streams assigns a
// new version number. To get the latest stream version, use the DescribeStream
// API.
//
// This operation requires permission for the KinesisVideo:DeleteStream action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation DeleteStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteStream
func (c *KinesisVideo) DeleteStream(input *DeleteStreamInput) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	return out, req.Send()
}

// DeleteStreamWithContext is the same as DeleteStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) DeleteStreamWithContext(ctx aws.Context, input *DeleteStreamInput, opts ...request.Option) (*DeleteStreamOutput, error) {
	req, out := c.DeleteStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStream = "DescribeStream"

// DescribeStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStream for more information on using the DescribeStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStreamRequest method.
//    req, resp := client.DescribeStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DescribeStream
func (c *KinesisVideo) DescribeStreamRequest(input *DescribeStreamInput) (req *request.Request, output *DescribeStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeStream,
		HTTPMethod: "POST",
		HTTPPath:   "/describeStream",
	}

	if input == nil {
		input = &DescribeStreamInput{}
	}

	output = &DescribeStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStream API operation for Amazon Kinesis Video Streams.
//
// Returns the most current information about the specified stream. You must
// specify either the StreamName or the StreamARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation DescribeStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DescribeStream
func (c *KinesisVideo) DescribeStream(input *DescribeStreamInput) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	return out, req.Send()
}

// DescribeStreamWithContext is the same as DescribeStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) DescribeStreamWithContext(ctx aws.Context, input *DescribeStreamInput, opts ...request.Option) (*DescribeStreamOutput, error) {
	req, out := c.DescribeStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataEndpoint = "GetDataEndpoint"

// GetDataEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetDataEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataEndpoint for more information on using the GetDataEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataEndpointRequest method.
//    req, resp := client.GetDataEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/GetDataEndpoint
func (c *KinesisVideo) GetDataEndpointRequest(input *GetDataEndpointInput) (req *request.Request, output *GetDataEndpointOutput) {
	op := &request.Operation{
		Name:       opGetDataEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/getDataEndpoint",
	}

	if input == nil {
		input = &GetDataEndpointInput{}
	}

	output = &GetDataEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataEndpoint API operation for Amazon Kinesis Video Streams.
//
// Gets an endpoint for a specified stream for either reading or writing. Use
// this endpoint in your application to read from the specified stream (using
// the GetMedia or GetMediaForFragmentList operations) or write to it (using
// the PutMedia operation).
//
// The returned endpoint does not have the API name appended. The client needs
// to add the API name to the returned endpoint.
//
// In the request, specify the stream either by StreamName or StreamARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation GetDataEndpoint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/GetDataEndpoint
func (c *KinesisVideo) GetDataEndpoint(input *GetDataEndpointInput) (*GetDataEndpointOutput, error) {
	req, out := c.GetDataEndpointRequest(input)
	return out, req.Send()
}

// GetDataEndpointWithContext is the same as GetDataEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) GetDataEndpointWithContext(ctx aws.Context, input *GetDataEndpointInput, opts ...request.Option) (*GetDataEndpointOutput, error) {
	req, out := c.GetDataEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStreams = "ListStreams"

// ListStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStreams for more information on using the ListStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListStreamsRequest method.
//    req, resp := client.ListStreamsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/ListStreams
func (c *KinesisVideo) ListStreamsRequest(input *ListStreamsInput) (req *request.Request, output *ListStreamsOutput) {
	op := &request.Operation{
		Name:       opListStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/listStreams",
	}

	if input == nil {
		input = &ListStreamsInput{}
	}

	output = &ListStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStreams API operation for Amazon Kinesis Video Streams.
//
// Returns an array of StreamInfo objects. Each object describes a stream. To
// retrieve only streams that satisfy a specific condition, you can specify
// a StreamNameCondition.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation ListStreams for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/ListStreams
func (c *KinesisVideo) ListStreams(input *ListStreamsInput) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	return out, req.Send()
}

// ListStreamsWithContext is the same as ListStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) ListStreamsWithContext(ctx aws.Context, input *ListStreamsInput, opts ...request.Option) (*ListStreamsOutput, error) {
	req, out := c.ListStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForStream = "ListTagsForStream"

// ListTagsForStreamRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForStream for more information on using the ListTagsForStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForStreamRequest method.
//    req, resp := client.ListTagsForStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/ListTagsForStream
func (c *KinesisVideo) ListTagsForStreamRequest(input *ListTagsForStreamInput) (req *request.Request, output *ListTagsForStreamOutput) {
	op := &request.Operation{
		Name:       opListTagsForStream,
		HTTPMethod: "POST",
		HTTPPath:   "/listTagsForStream",
	}

	if input == nil {
		input = &ListTagsForStreamInput{}
	}

	output = &ListTagsForStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForStream API operation for Amazon Kinesis Video Streams.
//
// Returns a list of tags associated with the specified stream.
//
// In the request, you must specify either the StreamName or the StreamARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation ListTagsForStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
//   * ErrCodeInvalidResourceFormatException "InvalidResourceFormatException"
//   The format of the StreamARN is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/ListTagsForStream
func (c *KinesisVideo) ListTagsForStream(input *ListTagsForStreamInput) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	return out, req.Send()
}

// ListTagsForStreamWithContext is the same as ListTagsForStream with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) ListTagsForStreamWithContext(ctx aws.Context, input *ListTagsForStreamInput, opts ...request.Option) (*ListTagsForStreamOutput, error) {
	req, out := c.ListTagsForStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagStream = "TagStream"

// TagStreamRequest generates a "aws/request.Request" representing the
// client's request for the TagStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagStream for more information on using the TagStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagStreamRequest method.
//    req, resp := client.TagStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/TagStream
func (c *KinesisVideo) TagStreamRequest(input *TagStreamInput) (req *request.Request, output *TagStreamOutput) {
	op := &request.Operation{
		Name:       opTagStream,
		HTTPMethod: "POST",
		HTTPPath:   "/tagStream",
	}

	if input == nil {
		input = &TagStreamInput{}
	}

	output = &TagStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagStream API operation for Amazon Kinesis Video Streams.
//
// Adds one or more tags to a stream. A tag is a key-value pair (the value is
// optional) that you can define and assign to AWS resources. If you specify
// a tag that already exists, the tag value is replaced with the value that
// you specify in the request. For more information, see Using Cost Allocation
// Tags (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management User Guide.
//
// You must provide either the StreamName or the StreamARN.
//
// This operation requires permission for the KinesisVideo:TagStream action.
//
// Kinesis video streams support up to 50 tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation TagStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
//   * ErrCodeInvalidResourceFormatException "InvalidResourceFormatException"
//   The format of the StreamARN is invalid.
//
//   * ErrCodeTagsPerResourceExceededLimitException "TagsPerResourceExceededLimitException"
//   You have exceeded the limit of tags that you can associate with the resource.
//   Kinesis video streams support up to 50 tags.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/TagStream
func (c *KinesisVideo) TagStream(input *TagStreamInput) (*TagStreamOutput, error) {
	req, out := c.TagStreamRequest(input)
	return out, req.Send()
}

// TagStreamWithContext is the same as TagStream with the addition of
// the ability to pass a context and additional request options.
//
// See TagStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) TagStreamWithContext(ctx aws.Context, input *TagStreamInput, opts ...request.Option) (*TagStreamOutput, error) {
	req, out := c.TagStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagStream = "UntagStream"

// UntagStreamRequest generates a "aws/request.Request" representing the
// client's request for the UntagStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagStream for more information on using the UntagStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagStreamRequest method.
//    req, resp := client.UntagStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UntagStream
func (c *KinesisVideo) UntagStreamRequest(input *UntagStreamInput) (req *request.Request, output *UntagStreamOutput) {
	op := &request.Operation{
		Name:       opUntagStream,
		HTTPMethod: "POST",
		HTTPPath:   "/untagStream",
	}

	if input == nil {
		input = &UntagStreamInput{}
	}

	output = &UntagStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagStream API operation for Amazon Kinesis Video Streams.
//
// Removes one or more tags from a stream. In the request, specify only a tag
// key or keys; don't specify the value. If you specify a tag key that does
// not exist, it's ignored.
//
// In the request, you must provide the StreamName or StreamARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation UntagStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
//   * ErrCodeInvalidResourceFormatException "InvalidResourceFormatException"
//   The format of the StreamARN is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UntagStream
func (c *KinesisVideo) UntagStream(input *UntagStreamInput) (*UntagStreamOutput, error) {
	req, out := c.UntagStreamRequest(input)
	return out, req.Send()
}

// UntagStreamWithContext is the same as UntagStream with the addition of
// the ability to pass a context and additional request options.
//
// See UntagStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) UntagStreamWithContext(ctx aws.Context, input *UntagStreamInput, opts ...request.Option) (*UntagStreamOutput, error) {
	req, out := c.UntagStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataRetention = "UpdateDataRetention"

// UpdateDataRetentionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataRetention operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataRetention for more information on using the UpdateDataRetention
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataRetentionRequest method.
//    req, resp := client.UpdateDataRetentionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UpdateDataRetention
func (c *KinesisVideo) UpdateDataRetentionRequest(input *UpdateDataRetentionInput) (req *request.Request, output *UpdateDataRetentionOutput) {
	op := &request.Operation{
		Name:       opUpdateDataRetention,
		HTTPMethod: "POST",
		HTTPPath:   "/updateDataRetention",
	}

	if input == nil {
		input = &UpdateDataRetentionInput{}
	}

	output = &UpdateDataRetentionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataRetention API operation for Amazon Kinesis Video Streams.
//
// Increases or decreases the stream's data retention period by the value that
// you specify. To indicate whether you want to increase or decrease the data
// retention period, specify the Operation parameter in the request body. In
// the request, you must specify either the StreamName or the StreamARN.
//
// The retention period that you specify replaces the current value.
//
// This operation requires permission for the KinesisVideo:UpdateDataRetention
// action.
//
// Changing the data retention period affects the data in the stream as follows:
//
//    * If the data retention period is increased, existing data is retained
//    for the new retention period. For example, if the data retention period
//    is increased from one hour to seven hours, all existing data is retained
//    for seven hours.
//
//    * If the data retention period is decreased, existing data is retained
//    for the new retention period. For example, if the data retention period
//    is decreased from seven hours to one hour, all existing data is retained
//    for one hour, and any data older than one hour is deleted immediately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation UpdateDataRetention for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The stream is currently not available for this operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
//   * ErrCodeVersionMismatchException "VersionMismatchException"
//   The stream version that you specified is not the latest version. To get the
//   latest version, use the DescribeStream (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html)
//   API.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UpdateDataRetention
func (c *KinesisVideo) UpdateDataRetention(input *UpdateDataRetentionInput) (*UpdateDataRetentionOutput, error) {
	req, out := c.UpdateDataRetentionRequest(input)
	return out, req.Send()
}

// UpdateDataRetentionWithContext is the same as UpdateDataRetention with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataRetention for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) UpdateDataRetentionWithContext(ctx aws.Context, input *UpdateDataRetentionInput, opts ...request.Option) (*UpdateDataRetentionOutput, error) {
	req, out := c.UpdateDataRetentionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStream = "UpdateStream"

// UpdateStreamRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStream for more information on using the UpdateStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStreamRequest method.
//    req, resp := client.UpdateStreamRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UpdateStream
func (c *KinesisVideo) UpdateStreamRequest(input *UpdateStreamInput) (req *request.Request, output *UpdateStreamOutput) {
	op := &request.Operation{
		Name:       opUpdateStream,
		HTTPMethod: "POST",
		HTTPPath:   "/updateStream",
	}

	if input == nil {
		input = &UpdateStreamInput{}
	}

	output = &UpdateStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStream API operation for Amazon Kinesis Video Streams.
//
// Updates stream metadata, such as the device name and media type.
//
// You must provide the stream name or the Amazon Resource Name (ARN) of the
// stream.
//
// To make sure that you have the latest version of the stream before updating
// it, you can specify the stream version. Kinesis Video Streams assigns a version
// to each stream. When you update a stream, Kinesis Video Streams assigns a
// new version number. To get the latest stream version, use the DescribeStream
// API.
//
// UpdateStream is an asynchronous operation, and takes time to complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Video Streams's
// API operation UpdateStream for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientLimitExceededException "ClientLimitExceededException"
//   Kinesis Video Streams has throttled the request because you have exceeded
//   the limit of allowed client calls. Try making the call later.
//
//   * ErrCodeInvalidArgumentException "InvalidArgumentException"
//   The value for this input parameter is invalid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   Amazon Kinesis Video Streams can't find the stream that you specified.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The stream is currently not available for this operation.
//
//   * ErrCodeNotAuthorizedException "NotAuthorizedException"
//   The caller is not authorized to perform this operation.
//
//   * ErrCodeVersionMismatchException "VersionMismatchException"
//   The stream version that you specified is not the latest version. To get the
//   latest version, use the DescribeStream (http://docs.aws.amazon.com/kinesisvideostreams/latest/dg/API_DescribeStream.html)
//   API.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/UpdateStream
func (c *KinesisVideo) UpdateStream(input *UpdateStreamInput) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	return out, req.Send()
}

// UpdateStreamWithContext is the same as UpdateStream with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KinesisVideo) UpdateStreamWithContext(ctx aws.Context, input *UpdateStreamInput, opts ...request.Option) (*UpdateStreamOutput, error) {
	req, out := c.UpdateStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateStreamInput struct {
	_ struct{} `type:"structure"`

	// The number of hours that you want to retain the data in the stream. Kinesis
	// Video Streams retains the data in a data store that is associated with the
	// stream.
	//
	// The default value is 0, indicating that the stream does not persist data.
	//
	// When the DataRetentionInHours value is 0, consumers can still consume the
	// fragments that remain in the service host buffer, which has a retention time
	// limit of 5 minutes and a retention memory limit of 200 MB. Fragments are
	// removed from the buffer when either limit is reached.
	DataRetentionInHours *int64 `type:"integer"`

	// The name of the device that is writing to the stream.
	//
	// In the current implementation, Kinesis Video Streams does not use this name.
	DeviceName *string `min:"1" type:"string"`

	// The ID of the AWS Key Management Service (AWS KMS) key that you want Kinesis
	// Video Streams to use to encrypt stream data.
	//
	// If no key ID is specified, the default, Kinesis Video-managed key (aws/kinesisvideo)
	// is used.
	//
	// For more information, see DescribeKey (http://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters).
	KmsKeyId *string `min:"1" type:"string"`

	// The media type of the stream. Consumers of the stream can use this information
	// when processing the stream. For more information about media types, see Media
	// Types (http://www.iana.org/assignments/media-types/media-types.xhtml). If
	// you choose to specify the MediaType, see Naming Requirements (https://tools.ietf.org/html/rfc6838#section-4.2)
	// for guidelines.
	//
	// To play video on the console, the media must be H.264 encoded, and you need
	// to specify this video type in this parameter as video/h264.
	//
	// This parameter is optional; the default value is null (or empty in JSON).
	MediaType *string `min:"1" type:"string"`

	// A name for the stream that you are creating.
	//
	// The stream name is an identifier for the stream, and must be unique for each
	// account and region.
	//
	// StreamName is a required field
	StreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStreamInput"}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.KmsKeyId != nil && len(*s.KmsKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyId", 1))
	}
	if s.MediaType != nil && len(*s.MediaType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaType", 1))
	}
	if s.StreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamName"))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataRetentionInHours sets the DataRetentionInHours field's value.
func (s *CreateStreamInput) SetDataRetentionInHours(v int64) *CreateStreamInput {
	s.DataRetentionInHours = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *CreateStreamInput) SetDeviceName(v string) *CreateStreamInput {
	s.DeviceName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateStreamInput) SetKmsKeyId(v string) *CreateStreamInput {
	s.KmsKeyId = &v
	return s
}

// SetMediaType sets the MediaType field's value.
func (s *CreateStreamInput) SetMediaType(v string) *CreateStreamInput {
	s.MediaType = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *CreateStreamInput) SetStreamName(v string) *CreateStreamInput {
	s.StreamName = &v
	return s
}

type CreateStreamOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStreamOutput) GoString() string {
	return s.String()
}

// SetStreamARN sets the StreamARN field's value.
func (s *CreateStreamOutput) SetStreamARN(v string) *CreateStreamOutput {
	s.StreamARN = &v
	return s
}

type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// Optional: The version of the stream that you want to delete.
	//
	// Specify the version as a safeguard to ensure that your are deleting the correct
	// stream. To get the stream version, use the DescribeStream API.
	//
	// If not specified, only the CreationTime is checked before deleting the stream.
	CurrentVersion *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the stream that you want to delete.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.CurrentVersion != nil && len(*s.CurrentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentVersion", 1))
	}
	if s.StreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *DeleteStreamInput) SetCurrentVersion(v string) *DeleteStreamInput {
	s.CurrentVersion = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *DeleteStreamInput) SetStreamARN(v string) *DeleteStreamInput {
	s.StreamARN = &v
	return s
}

type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStreamOutput) GoString() string {
	return s.String()
}

type DescribeStreamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *DescribeStreamInput) SetStreamARN(v string) *DescribeStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *DescribeStreamInput) SetStreamName(v string) *DescribeStreamInput {
	s.StreamName = &v
	return s
}

type DescribeStreamOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the stream.
	StreamInfo *StreamInfo `type:"structure"`
}

// String returns the string representation
func (s DescribeStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStreamOutput) GoString() string {
	return s.String()
}

// SetStreamInfo sets the StreamInfo field's value.
func (s *DescribeStreamOutput) SetStreamInfo(v *StreamInfo) *DescribeStreamOutput {
	s.StreamInfo = v
	return s
}

type GetDataEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the API action for which to get an endpoint.
	//
	// APIName is a required field
	APIName *string `type:"string" required:"true" enum:"APIName"`

	// The Amazon Resource Name (ARN) of the stream that you want to get the endpoint
	// for. You must specify either this parameter or a StreamName in the request.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream that you want to get the endpoint for. You must specify
	// either this parameter or a StreamARN in the request.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDataEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataEndpointInput"}
	if s.APIName == nil {
		invalidParams.Add(request.NewErrParamRequired("APIName"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAPIName sets the APIName field's value.
func (s *GetDataEndpointInput) SetAPIName(v string) *GetDataEndpointInput {
	s.APIName = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *GetDataEndpointInput) SetStreamARN(v string) *GetDataEndpointInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *GetDataEndpointInput) SetStreamName(v string) *GetDataEndpointInput {
	s.StreamName = &v
	return s
}

type GetDataEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint value. To read data from the stream or to write data to it,
	// specify this endpoint in your application.
	DataEndpoint *string `type:"string"`
}

// String returns the string representation
func (s GetDataEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataEndpointOutput) GoString() string {
	return s.String()
}

// SetDataEndpoint sets the DataEndpoint field's value.
func (s *GetDataEndpointOutput) SetDataEndpoint(v string) *GetDataEndpointOutput {
	s.DataEndpoint = &v
	return s
}

type ListStreamsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of streams to return in the response. The default is 10,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you specify this parameter, when the result of a ListStreams operation
	// is truncated, the call returns the NextToken in the response. To get another
	// batch of streams, provide this token in your next request.
	NextToken *string `type:"string"`

	// Optional: Returns only streams that satisfy a specific condition. Currently,
	// you can specify only the prefix of a stream name as a condition.
	StreamNameCondition *StreamNameCondition `type:"structure"`
}

// String returns the string representation
func (s ListStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStreamsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.StreamNameCondition != nil {
		if err := s.StreamNameCondition.Validate(); err != nil {
			invalidParams.AddNested("StreamNameCondition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStreamsInput) SetMaxResults(v int64) *ListStreamsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsInput) SetNextToken(v string) *ListStreamsInput {
	s.NextToken = &v
	return s
}

// SetStreamNameCondition sets the StreamNameCondition field's value.
func (s *ListStreamsInput) SetStreamNameCondition(v *StreamNameCondition) *ListStreamsInput {
	s.StreamNameCondition = v
	return s
}

type ListStreamsOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, the call returns this element with a token.
	// To get the next batch of streams, use this token in your next request.
	NextToken *string `type:"string"`

	// An array of StreamInfo objects.
	StreamInfoList []*StreamInfo `type:"list"`
}

// String returns the string representation
func (s ListStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStreamsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStreamsOutput) SetNextToken(v string) *ListStreamsOutput {
	s.NextToken = &v
	return s
}

// SetStreamInfoList sets the StreamInfoList field's value.
func (s *ListStreamsOutput) SetStreamInfoList(v []*StreamInfo) *ListStreamsOutput {
	s.StreamInfoList = v
	return s
}

type ListTagsForStreamInput struct {
	_ struct{} `type:"structure"`

	// If you specify this parameter and the result of a ListTagsForStream call
	// is truncated, the response includes a token that you can use in the next
	// request to fetch the next batch of tags.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the stream that you want to list tags for.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream that you want to list tags for.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTagsForStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForStreamInput) SetNextToken(v string) *ListTagsForStreamInput {
	s.NextToken = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *ListTagsForStreamInput) SetStreamARN(v string) *ListTagsForStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *ListTagsForStreamInput) SetStreamName(v string) *ListTagsForStreamInput {
	s.StreamName = &v
	return s
}

type ListTagsForStreamOutput struct {
	_ struct{} `type:"structure"`

	// If you specify this parameter and the result of a ListTags call is truncated,
	// the response includes a token that you can use in the next request to fetch
	// the next set of tags.
	NextToken *string `type:"string"`

	// A map of tag keys and values associated with the specified stream.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForStreamOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForStreamOutput) SetNextToken(v string) *ListTagsForStreamOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForStreamOutput) SetTags(v map[string]*string) *ListTagsForStreamOutput {
	s.Tags = v
	return s
}

// An object describing a Kinesis video stream.
type StreamInfo struct {
	_ struct{} `type:"structure"`

	// A time stamp that indicates when the stream was created.
	CreationTime *time.Time `type:"timestamp"`

	// How long the stream retains data, in hours.
	DataRetentionInHours *int64 `type:"integer"`

	// The name of the device that is associated with the stream.
	DeviceName *string `min:"1" type:"string"`

	// The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video
	// Streams uses to encrypt data on the stream.
	KmsKeyId *string `min:"1" type:"string"`

	// The MediaType of the stream.
	MediaType *string `min:"1" type:"string"`

	// The status of the stream.
	Status *string `type:"string" enum:"Status"`

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream.
	StreamName *string `min:"1" type:"string"`

	// The version of the stream.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StreamInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamInfo) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *StreamInfo) SetCreationTime(v time.Time) *StreamInfo {
	s.CreationTime = &v
	return s
}

// SetDataRetentionInHours sets the DataRetentionInHours field's value.
func (s *StreamInfo) SetDataRetentionInHours(v int64) *StreamInfo {
	s.DataRetentionInHours = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *StreamInfo) SetDeviceName(v string) *StreamInfo {
	s.DeviceName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *StreamInfo) SetKmsKeyId(v string) *StreamInfo {
	s.KmsKeyId = &v
	return s
}

// SetMediaType sets the MediaType field's value.
func (s *StreamInfo) SetMediaType(v string) *StreamInfo {
	s.MediaType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *StreamInfo) SetStatus(v string) *StreamInfo {
	s.Status = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *StreamInfo) SetStreamARN(v string) *StreamInfo {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *StreamInfo) SetStreamName(v string) *StreamInfo {
	s.StreamName = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *StreamInfo) SetVersion(v string) *StreamInfo {
	s.Version = &v
	return s
}

// Specifies the condition that streams must satisfy to be returned when you
// list streams (see the ListStreams API). A condition has a comparison operation
// and a value. Currently, you can specify only the BEGINS_WITH operator, which
// finds streams whose names start with a given prefix.
type StreamNameCondition struct {
	_ struct{} `type:"structure"`

	// A comparison operator. Currently, you can specify only the BEGINS_WITH operator,
	// which finds streams whose names start with a given prefix.
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// A value to compare.
	ComparisonValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StreamNameCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamNameCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamNameCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamNameCondition"}
	if s.ComparisonValue != nil && len(*s.ComparisonValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComparisonValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *StreamNameCondition) SetComparisonOperator(v string) *StreamNameCondition {
	s.ComparisonOperator = &v
	return s
}

// SetComparisonValue sets the ComparisonValue field's value.
func (s *StreamNameCondition) SetComparisonValue(v string) *StreamNameCondition {
	s.ComparisonValue = &v
	return s
}

type TagStreamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to add the tag
	// or tags to.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream that you want to add the tag or tags to.
	StreamName *string `min:"1" type:"string"`

	// A list of tags to associate with the specified stream. Each tag is a key-value
	// pair (the value is optional).
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *TagStreamInput) SetStreamARN(v string) *TagStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *TagStreamInput) SetStreamName(v string) *TagStreamInput {
	s.StreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagStreamInput) SetTags(v map[string]*string) *TagStreamInput {
	s.Tags = v
	return s
}

type TagStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagStreamOutput) GoString() string {
	return s.String()
}

type UntagStreamInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the stream that you want to remove tags
	// from.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream that you want to remove tags from.
	StreamName *string `min:"1" type:"string"`

	// A list of the keys of the tags that you want to remove.
	//
	// TagKeyList is a required field
	TagKeyList []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagStreamInput"}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}
	if s.TagKeyList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeyList"))
	}
	if s.TagKeyList != nil && len(s.TagKeyList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeyList", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamARN sets the StreamARN field's value.
func (s *UntagStreamInput) SetStreamARN(v string) *UntagStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UntagStreamInput) SetStreamName(v string) *UntagStreamInput {
	s.StreamName = &v
	return s
}

// SetTagKeyList sets the TagKeyList field's value.
func (s *UntagStreamInput) SetTagKeyList(v []*string) *UntagStreamInput {
	s.TagKeyList = v
	return s
}

type UntagStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagStreamOutput) GoString() string {
	return s.String()
}

type UpdateDataRetentionInput struct {
	_ struct{} `type:"structure"`

	// The version of the stream whose retention period you want to change. To get
	// the version, call either the DescribeStream or the ListStreams API.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `min:"1" type:"string" required:"true"`

	// The retention period, in hours. The value you specify replaces the current
	// value.
	//
	// DataRetentionChangeInHours is a required field
	DataRetentionChangeInHours *int64 `min:"1" type:"integer" required:"true"`

	// Indicates whether you want to increase or decrease the retention period.
	//
	// Operation is a required field
	Operation *string `type:"string" required:"true" enum:"UpdateDataRetentionOperation"`

	// The Amazon Resource Name (ARN) of the stream whose retention period you want
	// to change.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream whose retention period you want to change.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateDataRetentionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataRetentionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataRetentionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataRetentionInput"}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.CurrentVersion != nil && len(*s.CurrentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentVersion", 1))
	}
	if s.DataRetentionChangeInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("DataRetentionChangeInHours"))
	}
	if s.DataRetentionChangeInHours != nil && *s.DataRetentionChangeInHours < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DataRetentionChangeInHours", 1))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateDataRetentionInput) SetCurrentVersion(v string) *UpdateDataRetentionInput {
	s.CurrentVersion = &v
	return s
}

// SetDataRetentionChangeInHours sets the DataRetentionChangeInHours field's value.
func (s *UpdateDataRetentionInput) SetDataRetentionChangeInHours(v int64) *UpdateDataRetentionInput {
	s.DataRetentionChangeInHours = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateDataRetentionInput) SetOperation(v string) *UpdateDataRetentionInput {
	s.Operation = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *UpdateDataRetentionInput) SetStreamARN(v string) *UpdateDataRetentionInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateDataRetentionInput) SetStreamName(v string) *UpdateDataRetentionInput {
	s.StreamName = &v
	return s
}

type UpdateDataRetentionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDataRetentionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataRetentionOutput) GoString() string {
	return s.String()
}

type UpdateStreamInput struct {
	_ struct{} `type:"structure"`

	// The version of the stream whose metadata you want to update.
	//
	// CurrentVersion is a required field
	CurrentVersion *string `min:"1" type:"string" required:"true"`

	// The name of the device that is writing to the stream.
	//
	// In the current implementation, Kinesis Video Streams does not use this name.
	DeviceName *string `min:"1" type:"string"`

	// The stream's media type. Use MediaType to specify the type of content that
	// the stream contains to the consumers of the stream. For more information
	// about media types, see Media Types (http://www.iana.org/assignments/media-types/media-types.xhtml).
	// If you choose to specify the MediaType, see Naming Requirements (https://tools.ietf.org/html/rfc6838#section-4.2).
	//
	// To play video on the console, you must specify the correct video type. For
	// example, if the video in the stream is H.264, specify video/h264 as the MediaType.
	MediaType *string `min:"1" type:"string"`

	// The ARN of the stream whose metadata you want to update.
	StreamARN *string `min:"1" type:"string"`

	// The name of the stream whose metadata you want to update.
	//
	// The stream name is an identifier for the stream, and must be unique for each
	// account and region.
	StreamName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStreamInput"}
	if s.CurrentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentVersion"))
	}
	if s.CurrentVersion != nil && len(*s.CurrentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentVersion", 1))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.MediaType != nil && len(*s.MediaType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaType", 1))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamARN", 1))
	}
	if s.StreamName != nil && len(*s.StreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentVersion sets the CurrentVersion field's value.
func (s *UpdateStreamInput) SetCurrentVersion(v string) *UpdateStreamInput {
	s.CurrentVersion = &v
	return s
}

// SetDeviceName sets the DeviceName field's value.
func (s *UpdateStreamInput) SetDeviceName(v string) *UpdateStreamInput {
	s.DeviceName = &v
	return s
}

// SetMediaType sets the MediaType field's value.
func (s *UpdateStreamInput) SetMediaType(v string) *UpdateStreamInput {
	s.MediaType = &v
	return s
}

// SetStreamARN sets the StreamARN field's value.
func (s *UpdateStreamInput) SetStreamARN(v string) *UpdateStreamInput {
	s.StreamARN = &v
	return s
}

// SetStreamName sets the StreamName field's value.
func (s *UpdateStreamInput) SetStreamName(v string) *UpdateStreamInput {
	s.StreamName = &v
	return s
}

type UpdateStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStreamOutput) GoString() string {
	return s.String()
}

const (
	// APINamePutMedia is a APIName enum value
	APINamePutMedia = "PUT_MEDIA"

	// APINameGetMedia is a APIName enum value
	APINameGetMedia = "GET_MEDIA"

	// APINameListFragments is a APIName enum value
	APINameListFragments = "LIST_FRAGMENTS"

	// APINameGetMediaForFragmentList is a APIName enum value
	APINameGetMediaForFragmentList = "GET_MEDIA_FOR_FRAGMENT_LIST"

	// APINameGetHlsStreamingSessionUrl is a APIName enum value
	APINameGetHlsStreamingSessionUrl = "GET_HLS_STREAMING_SESSION_URL"
)

const (
	// ComparisonOperatorBeginsWith is a ComparisonOperator enum value
	ComparisonOperatorBeginsWith = "BEGINS_WITH"
)

const (
	// StatusCreating is a Status enum value
	StatusCreating = "CREATING"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"
)

const (
	// UpdateDataRetentionOperationIncreaseDataRetention is a UpdateDataRetentionOperation enum value
	UpdateDataRetentionOperationIncreaseDataRetention = "INCREASE_DATA_RETENTION"

	// UpdateDataRetentionOperationDecreaseDataRetention is a UpdateDataRetentionOperation enum value
	UpdateDataRetentionOperationDecreaseDataRetention = "DECREASE_DATA_RETENTION"
)
