// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// Tests of converstion to and from the RQL binary type
func TestDatumBinarySuite(t *testing.T) {
	suite.Run(t, new(DatumBinarySuite))
}

type DatumBinarySuite struct {
	suite.Suite

	session *r.Session
}

func (suite *DatumBinarySuite) SetupTest() {
	suite.T().Log("Setting up DatumBinarySuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *DatumBinarySuite) TearDownSuite() {
	suite.T().Log("Tearing down DatumBinarySuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *DatumBinarySuite) TestCases() {
	suite.T().Log("Running DatumBinarySuite: Tests of converstion to and from the RQL binary type")

	// datum/binary.yaml line #8
	// s = b''
	suite.T().Log("Possibly executing: var s []byte = []byte{}")

	s := []byte{}
	_ = s // Prevent any noused variable errors

	{
		// datum/binary.yaml line #10
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #10: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #10")
	}

	{
		// datum/binary.yaml line #12
		/* 0 */
		var expected_ int = 0
		/* r.binary(s).count() */

		suite.T().Log("About to run line #12: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	// datum/binary.yaml line #17
	// s = b'\x00'
	suite.T().Log("Possibly executing: var s []byte = []byte{0}")

	s = []byte{0}

	{
		// datum/binary.yaml line #19
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #19: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #19")
	}

	{
		// datum/binary.yaml line #21
		/* 1 */
		var expected_ int = 1
		/* r.binary(s).count() */

		suite.T().Log("About to run line #21: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	// datum/binary.yaml line #26
	// s = b'\x00\x42'
	suite.T().Log("Possibly executing: var s []byte = []byte{0,66}")

	s = []byte{0, 66}

	{
		// datum/binary.yaml line #28
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #28: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #28")
	}

	{
		// datum/binary.yaml line #30
		/* 2 */
		var expected_ int = 2
		/* r.binary(s).count() */

		suite.T().Log("About to run line #30: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #30")
	}

	// datum/binary.yaml line #35
	// s = b'\x00\xfe\x7a'
	suite.T().Log("Possibly executing: var s []byte = []byte{0,254,122}")

	s = []byte{0, 254, 122}

	{
		// datum/binary.yaml line #37
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #37: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #37")
	}

	{
		// datum/binary.yaml line #39
		/* 3 */
		var expected_ int = 3
		/* r.binary(s).count() */

		suite.T().Log("About to run line #39: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	// datum/binary.yaml line #44
	// s = b'\xed\xfe\x00\xba'
	suite.T().Log("Possibly executing: var s []byte = []byte{237,254,0,186}")

	s = []byte{237, 254, 0, 186}

	{
		// datum/binary.yaml line #46
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #46: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #46")
	}

	{
		// datum/binary.yaml line #48
		/* 4 */
		var expected_ int = 4
		/* r.binary(s).count() */

		suite.T().Log("About to run line #48: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #48")
	}

	// datum/binary.yaml line #53
	// s = b'\x50\xf9\x00\x77\xf9'
	suite.T().Log("Possibly executing: var s []byte = []byte{80,249,0,119,249}")

	s = []byte{80, 249, 0, 119, 249}

	{
		// datum/binary.yaml line #55
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #55: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #55")
	}

	{
		// datum/binary.yaml line #57
		/* 5 */
		var expected_ int = 5
		/* r.binary(s).count() */

		suite.T().Log("About to run line #57: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #57")
	}

	// datum/binary.yaml line #62
	// s = b'\x2f\xe3\xb5\x57\x00\x92'
	suite.T().Log("Possibly executing: var s []byte = []byte{47,227,181,87,0,146}")

	s = []byte{47, 227, 181, 87, 0, 146}

	{
		// datum/binary.yaml line #64
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #64: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #64")
	}

	{
		// datum/binary.yaml line #66
		/* 6 */
		var expected_ int = 6
		/* r.binary(s).count() */

		suite.T().Log("About to run line #66: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #66")
	}

	// datum/binary.yaml line #71
	// s = b'\xa9\x43\x54\xe9\x00\xf8\xfb'
	suite.T().Log("Possibly executing: var s []byte = []byte{169,67,84,233,0,248,251}")

	s = []byte{169, 67, 84, 233, 0, 248, 251}

	{
		// datum/binary.yaml line #73
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #73: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #73")
	}

	{
		// datum/binary.yaml line #75
		/* 7 */
		var expected_ int = 7
		/* r.binary(s).count() */

		suite.T().Log("About to run line #75: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #75")
	}

	// datum/binary.yaml line #80
	// s = b'\x57\xbb\xe5\x82\x8b\xd3\x00\xf9'
	suite.T().Log("Possibly executing: var s []byte = []byte{87,187,229,130,139,211,0,249}")

	s = []byte{87, 187, 229, 130, 139, 211, 0, 249}

	{
		// datum/binary.yaml line #82
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #82: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #82")
	}

	{
		// datum/binary.yaml line #84
		/* 8 */
		var expected_ int = 8
		/* r.binary(s).count() */

		suite.T().Log("About to run line #84: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #84")
	}

	// datum/binary.yaml line #89
	// s = b'\x44\x1b\x3e\x00\x13\x19\x29\x2a\xbf'
	suite.T().Log("Possibly executing: var s []byte = []byte{68,27,62,0,19,25,41,42,191}")

	s = []byte{68, 27, 62, 0, 19, 25, 41, 42, 191}

	{
		// datum/binary.yaml line #91
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #91: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #91")
	}

	{
		// datum/binary.yaml line #93
		/* 9 */
		var expected_ int = 9
		/* r.binary(s).count() */

		suite.T().Log("About to run line #93: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #93")
	}

	// datum/binary.yaml line #98
	// s = b'\x8a\x1d\x09\x00\x5d\x60\x6b\x2e\x70\xd9'
	suite.T().Log("Possibly executing: var s []byte = []byte{138,29,9,0,93,96,107,46,112,217}")

	s = []byte{138, 29, 9, 0, 93, 96, 107, 46, 112, 217}

	{
		// datum/binary.yaml line #100
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #100: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// datum/binary.yaml line #102
		/* 10 */
		var expected_ int = 10
		/* r.binary(s).count() */

		suite.T().Log("About to run line #102: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #102")
	}

	// datum/binary.yaml line #107
	// s = b'\x00\xaf\x47\x4b\x38\x99\x14\x8d\x8f\x10\x51'
	suite.T().Log("Possibly executing: var s []byte = []byte{0,175,71,75,56,153,20,141,143,16,81}")

	s = []byte{0, 175, 71, 75, 56, 153, 20, 141, 143, 16, 81}

	{
		// datum/binary.yaml line #109
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #109: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #109")
	}

	{
		// datum/binary.yaml line #111
		/* 11 */
		var expected_ int = 11
		/* r.binary(s).count() */

		suite.T().Log("About to run line #111: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #111")
	}

	// datum/binary.yaml line #116
	// s = b'\x45\x39\x00\xf7\xc2\x37\xfd\xe0\x38\x82\x40\xa9'
	suite.T().Log("Possibly executing: var s []byte = []byte{69,57,0,247,194,55,253,224,56,130,64,169}")

	s = []byte{69, 57, 0, 247, 194, 55, 253, 224, 56, 130, 64, 169}

	{
		// datum/binary.yaml line #118
		/* s */
		var expected_ []byte = s
		/* r.binary(s) */

		suite.T().Log("About to run line #118: r.Binary(s)")

		runAndAssert(suite.Suite, expected_, r.Binary(s), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #118")
	}

	{
		// datum/binary.yaml line #120
		/* 12 */
		var expected_ int = 12
		/* r.binary(s).count() */

		suite.T().Log("About to run line #120: r.Binary(s).Count()")

		runAndAssert(suite.Suite, expected_, r.Binary(s).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #120")
	}

	// datum/binary.yaml line #128
	// a = b'\x00'
	suite.T().Log("Possibly executing: var a []byte = []byte{0}")

	a := []byte{0}
	_ = a // Prevent any noused variable errors

	// datum/binary.yaml line #132
	// b = b'\x00\x01'
	suite.T().Log("Possibly executing: var b []byte = []byte{0,1}")

	b := []byte{0, 1}
	_ = b // Prevent any noused variable errors

	// datum/binary.yaml line #136
	// c = b'\x01'
	suite.T().Log("Possibly executing: var c []byte = []byte{1}")

	c := []byte{1}
	_ = c // Prevent any noused variable errors

	// datum/binary.yaml line #140
	// d = b'\x70\x22'
	suite.T().Log("Possibly executing: var d []byte = []byte{112,34}")

	d := []byte{112, 34}
	_ = d // Prevent any noused variable errors

	// datum/binary.yaml line #144
	// e = b'\x80'
	suite.T().Log("Possibly executing: var e []byte = []byte{128}")

	e := []byte{128}
	_ = e // Prevent any noused variable errors

	// datum/binary.yaml line #148
	// f = b'\xFE'
	suite.T().Log("Possibly executing: var f []byte = []byte{254}")

	f := []byte{254}
	_ = f // Prevent any noused variable errors

	{
		// datum/binary.yaml line #151
		/* true */
		var expected_ bool = true
		/* r.binary(a).eq(r.binary(a)) */

		suite.T().Log("About to run line #151: r.Binary(a).Eq(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Eq(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #151")
	}

	{
		// datum/binary.yaml line #153
		/* true */
		var expected_ bool = true
		/* r.binary(a).le(r.binary(a)) */

		suite.T().Log("About to run line #153: r.Binary(a).Le(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Le(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #153")
	}

	{
		// datum/binary.yaml line #155
		/* true */
		var expected_ bool = true
		/* r.binary(a).ge(r.binary(a)) */

		suite.T().Log("About to run line #155: r.Binary(a).Ge(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Ge(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #155")
	}

	{
		// datum/binary.yaml line #157
		/* false */
		var expected_ bool = false
		/* r.binary(a).ne(r.binary(a)) */

		suite.T().Log("About to run line #157: r.Binary(a).Ne(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Ne(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #157")
	}

	{
		// datum/binary.yaml line #159
		/* false */
		var expected_ bool = false
		/* r.binary(a).lt(r.binary(a)) */

		suite.T().Log("About to run line #159: r.Binary(a).Lt(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Lt(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// datum/binary.yaml line #161
		/* false */
		var expected_ bool = false
		/* r.binary(a).gt(r.binary(a)) */

		suite.T().Log("About to run line #161: r.Binary(a).Gt(r.Binary(a))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Gt(r.Binary(a)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #161")
	}

	{
		// datum/binary.yaml line #165
		/* true */
		var expected_ bool = true
		/* r.binary(a).ne(r.binary(b)) */

		suite.T().Log("About to run line #165: r.Binary(a).Ne(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Ne(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #165")
	}

	{
		// datum/binary.yaml line #167
		/* true */
		var expected_ bool = true
		/* r.binary(a).lt(r.binary(b)) */

		suite.T().Log("About to run line #167: r.Binary(a).Lt(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Lt(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #167")
	}

	{
		// datum/binary.yaml line #169
		/* true */
		var expected_ bool = true
		/* r.binary(a).le(r.binary(b)) */

		suite.T().Log("About to run line #169: r.Binary(a).Le(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Le(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #169")
	}

	{
		// datum/binary.yaml line #171
		/* false */
		var expected_ bool = false
		/* r.binary(a).ge(r.binary(b)) */

		suite.T().Log("About to run line #171: r.Binary(a).Ge(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Ge(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #171")
	}

	{
		// datum/binary.yaml line #173
		/* false */
		var expected_ bool = false
		/* r.binary(a).gt(r.binary(b)) */

		suite.T().Log("About to run line #173: r.Binary(a).Gt(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Gt(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #173")
	}

	{
		// datum/binary.yaml line #175
		/* false */
		var expected_ bool = false
		/* r.binary(a).eq(r.binary(b)) */

		suite.T().Log("About to run line #175: r.Binary(a).Eq(r.Binary(b))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).Eq(r.Binary(b)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #175")
	}

	{
		// datum/binary.yaml line #179
		/* true */
		var expected_ bool = true
		/* r.binary(b).ne(r.binary(c)) */

		suite.T().Log("About to run line #179: r.Binary(b).Ne(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Ne(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #179")
	}

	{
		// datum/binary.yaml line #181
		/* true */
		var expected_ bool = true
		/* r.binary(b).lt(r.binary(c)) */

		suite.T().Log("About to run line #181: r.Binary(b).Lt(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Lt(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #181")
	}

	{
		// datum/binary.yaml line #183
		/* true */
		var expected_ bool = true
		/* r.binary(b).le(r.binary(c)) */

		suite.T().Log("About to run line #183: r.Binary(b).Le(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Le(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #183")
	}

	{
		// datum/binary.yaml line #185
		/* false */
		var expected_ bool = false
		/* r.binary(b).ge(r.binary(c)) */

		suite.T().Log("About to run line #185: r.Binary(b).Ge(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Ge(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #185")
	}

	{
		// datum/binary.yaml line #187
		/* false */
		var expected_ bool = false
		/* r.binary(b).gt(r.binary(c)) */

		suite.T().Log("About to run line #187: r.Binary(b).Gt(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Gt(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #187")
	}

	{
		// datum/binary.yaml line #189
		/* false */
		var expected_ bool = false
		/* r.binary(b).eq(r.binary(c)) */

		suite.T().Log("About to run line #189: r.Binary(b).Eq(r.Binary(c))")

		runAndAssert(suite.Suite, expected_, r.Binary(b).Eq(r.Binary(c)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #189")
	}

	{
		// datum/binary.yaml line #193
		/* true */
		var expected_ bool = true
		/* r.binary(c).ne(r.binary(d)) */

		suite.T().Log("About to run line #193: r.Binary(c).Ne(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Ne(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #193")
	}

	{
		// datum/binary.yaml line #195
		/* true */
		var expected_ bool = true
		/* r.binary(c).lt(r.binary(d)) */

		suite.T().Log("About to run line #195: r.Binary(c).Lt(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Lt(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #195")
	}

	{
		// datum/binary.yaml line #197
		/* true */
		var expected_ bool = true
		/* r.binary(c).le(r.binary(d)) */

		suite.T().Log("About to run line #197: r.Binary(c).Le(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Le(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #197")
	}

	{
		// datum/binary.yaml line #199
		/* false */
		var expected_ bool = false
		/* r.binary(c).ge(r.binary(d)) */

		suite.T().Log("About to run line #199: r.Binary(c).Ge(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Ge(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #199")
	}

	{
		// datum/binary.yaml line #201
		/* false */
		var expected_ bool = false
		/* r.binary(c).gt(r.binary(d)) */

		suite.T().Log("About to run line #201: r.Binary(c).Gt(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Gt(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #201")
	}

	{
		// datum/binary.yaml line #203
		/* false */
		var expected_ bool = false
		/* r.binary(c).eq(r.binary(d)) */

		suite.T().Log("About to run line #203: r.Binary(c).Eq(r.Binary(d))")

		runAndAssert(suite.Suite, expected_, r.Binary(c).Eq(r.Binary(d)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #203")
	}

	{
		// datum/binary.yaml line #207
		/* true */
		var expected_ bool = true
		/* r.binary(d).ne(r.binary(e)) */

		suite.T().Log("About to run line #207: r.Binary(d).Ne(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Ne(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #207")
	}

	{
		// datum/binary.yaml line #209
		/* true */
		var expected_ bool = true
		/* r.binary(d).lt(r.binary(e)) */

		suite.T().Log("About to run line #209: r.Binary(d).Lt(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Lt(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #209")
	}

	{
		// datum/binary.yaml line #211
		/* true */
		var expected_ bool = true
		/* r.binary(d).le(r.binary(e)) */

		suite.T().Log("About to run line #211: r.Binary(d).Le(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Le(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #211")
	}

	{
		// datum/binary.yaml line #213
		/* false */
		var expected_ bool = false
		/* r.binary(d).ge(r.binary(e)) */

		suite.T().Log("About to run line #213: r.Binary(d).Ge(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Ge(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #213")
	}

	{
		// datum/binary.yaml line #215
		/* false */
		var expected_ bool = false
		/* r.binary(d).gt(r.binary(e)) */

		suite.T().Log("About to run line #215: r.Binary(d).Gt(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Gt(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #215")
	}

	{
		// datum/binary.yaml line #217
		/* false */
		var expected_ bool = false
		/* r.binary(d).eq(r.binary(e)) */

		suite.T().Log("About to run line #217: r.Binary(d).Eq(r.Binary(e))")

		runAndAssert(suite.Suite, expected_, r.Binary(d).Eq(r.Binary(e)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #217")
	}

	{
		// datum/binary.yaml line #221
		/* true */
		var expected_ bool = true
		/* r.binary(e).ne(r.binary(f)) */

		suite.T().Log("About to run line #221: r.Binary(e).Ne(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Ne(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #221")
	}

	{
		// datum/binary.yaml line #223
		/* true */
		var expected_ bool = true
		/* r.binary(e).lt(r.binary(f)) */

		suite.T().Log("About to run line #223: r.Binary(e).Lt(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Lt(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #223")
	}

	{
		// datum/binary.yaml line #225
		/* true */
		var expected_ bool = true
		/* r.binary(e).le(r.binary(f)) */

		suite.T().Log("About to run line #225: r.Binary(e).Le(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Le(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #225")
	}

	{
		// datum/binary.yaml line #227
		/* false */
		var expected_ bool = false
		/* r.binary(e).ge(r.binary(f)) */

		suite.T().Log("About to run line #227: r.Binary(e).Ge(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Ge(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #227")
	}

	{
		// datum/binary.yaml line #229
		/* false */
		var expected_ bool = false
		/* r.binary(e).gt(r.binary(f)) */

		suite.T().Log("About to run line #229: r.Binary(e).Gt(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Gt(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #229")
	}

	{
		// datum/binary.yaml line #231
		/* false */
		var expected_ bool = false
		/* r.binary(e).eq(r.binary(f)) */

		suite.T().Log("About to run line #231: r.Binary(e).Eq(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(e).Eq(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// datum/binary.yaml line #235
		/* true */
		var expected_ bool = true
		/* r.binary(f).eq(r.binary(f)) */

		suite.T().Log("About to run line #235: r.Binary(f).Eq(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Eq(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #235")
	}

	{
		// datum/binary.yaml line #237
		/* true */
		var expected_ bool = true
		/* r.binary(f).le(r.binary(f)) */

		suite.T().Log("About to run line #237: r.Binary(f).Le(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Le(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #237")
	}

	{
		// datum/binary.yaml line #239
		/* true */
		var expected_ bool = true
		/* r.binary(f).ge(r.binary(f)) */

		suite.T().Log("About to run line #239: r.Binary(f).Ge(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Ge(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #239")
	}

	{
		// datum/binary.yaml line #241
		/* false */
		var expected_ bool = false
		/* r.binary(f).ne(r.binary(f)) */

		suite.T().Log("About to run line #241: r.Binary(f).Ne(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Ne(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #241")
	}

	{
		// datum/binary.yaml line #243
		/* false */
		var expected_ bool = false
		/* r.binary(f).lt(r.binary(f)) */

		suite.T().Log("About to run line #243: r.Binary(f).Lt(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Lt(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #243")
	}

	{
		// datum/binary.yaml line #245
		/* false */
		var expected_ bool = false
		/* r.binary(f).gt(r.binary(f)) */

		suite.T().Log("About to run line #245: r.Binary(f).Gt(r.Binary(f))")

		runAndAssert(suite.Suite, expected_, r.Binary(f).Gt(r.Binary(f)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #245")
	}

	{
		// datum/binary.yaml line #269
		/* 'foo' */
		var expected_ string = "foo"
		/* r.binary(b'foo').coerce_to('string') */

		suite.T().Log("About to run line #269: r.Binary([]byte{102,111,111}).CoerceTo('string')")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{102, 111, 111}).CoerceTo("string"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #269")
	}

	{
		// datum/binary.yaml line #284
		/* b'foo' */
		var expected_ []byte = []byte{102, 111, 111}
		/* r.expr('foo').coerce_to('binary') */

		suite.T().Log("About to run line #284: r.Expr('foo').CoerceTo('binary')")

		runAndAssert(suite.Suite, expected_, r.Expr("foo").CoerceTo("binary"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #284")
	}

	{
		// datum/binary.yaml line #287
		/* True */
		var expected_ bool = true
		/* r.binary(a).coerce_to('bool') */

		suite.T().Log("About to run line #287: r.Binary(a).CoerceTo('bool')")

		runAndAssert(suite.Suite, expected_, r.Binary(a).CoerceTo("bool"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #287")
	}

	{
		// datum/binary.yaml line #290
		/* b'foo' */
		var expected_ []byte = []byte{102, 111, 111}
		/* r.binary(b'foo').coerce_to('binary') */

		suite.T().Log("About to run line #290: r.Binary([]byte{102,111,111}).CoerceTo('binary')")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{102, 111, 111}).CoerceTo("binary"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #290")
	}

	{
		// datum/binary.yaml line #294
		/* b'ef' */
		var expected_ []byte = []byte{101, 102}
		/* r.binary(b'abcdefg').slice(-3,-1) */

		suite.T().Log("About to run line #294: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(-3, -1)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(-3, -1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #294")
	}

	{
		// datum/binary.yaml line #296
		/* b'ab' */
		var expected_ []byte = []byte{97, 98}
		/* r.binary(b'abcdefg').slice(0, 2) */

		suite.T().Log("About to run line #296: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(0, 2)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(0, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #296")
	}

	{
		// datum/binary.yaml line #298
		/* b'def' */
		var expected_ []byte = []byte{100, 101, 102}
		/* r.binary(b'abcdefg').slice(3, -1) */

		suite.T().Log("About to run line #298: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(3, -1)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(3, -1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #298")
	}

	{
		// datum/binary.yaml line #300
		/* b'cde' */
		var expected_ []byte = []byte{99, 100, 101}
		/* r.binary(b'abcdefg').slice(-5, 5) */

		suite.T().Log("About to run line #300: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(-5, 5)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(-5, 5), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #300")
	}

	{
		// datum/binary.yaml line #302
		/* b'ab' */
		var expected_ []byte = []byte{97, 98}
		/* r.binary(b'abcdefg').slice(-8, 2) */

		suite.T().Log("About to run line #302: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(-8, 2)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(-8, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #302")
	}

	{
		// datum/binary.yaml line #304
		/* b'fg' */
		var expected_ []byte = []byte{102, 103}
		/* r.binary(b'abcdefg').slice(5, 7) */

		suite.T().Log("About to run line #304: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(5, 7)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(5, 7), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #304")
	}

	{
		// datum/binary.yaml line #308
		/* b'ab' */
		var expected_ []byte = []byte{97, 98}
		/* r.binary(b'abcdefg').slice(-9, 2) */

		suite.T().Log("About to run line #308: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(-9, 2)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(-9, 2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #308")
	}

	{
		// datum/binary.yaml line #312
		/* b'fg' */
		var expected_ []byte = []byte{102, 103}
		/* r.binary(b'abcdefg').slice(5, 9) */

		suite.T().Log("About to run line #312: r.Binary([]byte{97,98,99,100,101,102,103}).Slice(5, 9)")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{97, 98, 99, 100, 101, 102, 103}).Slice(5, 9), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #312")
	}

	{
		// datum/binary.yaml line #316
		/* b */
		var expected_ []byte = b
		/* r.binary(b) */

		suite.T().Log("About to run line #316: r.Binary(b)")

		runAndAssert(suite.Suite, expected_, r.Binary(b), suite.session, r.RunOpts{
			BinaryFormat:   "native",
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #316")
	}

	{
		// datum/binary.yaml line #320
		/* {'$reql_type$':'BINARY','data':'AAE='} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"$reql_type$": "BINARY", "data": "AAE="}
		/* r.binary(b) */

		suite.T().Log("About to run line #320: r.Binary(b)")

		runAndAssert(suite.Suite, expected_, r.Binary(b), suite.session, r.RunOpts{
			BinaryFormat:   "raw",
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #320")
	}

	{
		// datum/binary.yaml line #326
		/* b"data" */
		var expected_ []byte = []byte{100, 97, 116, 97}
		/* r.binary(r.expr("data")) */

		suite.T().Log("About to run line #326: r.Binary(r.Expr('data'))")

		runAndAssert(suite.Suite, expected_, r.Binary(r.Expr("data")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #326")
	}

	{
		// datum/binary.yaml line #332
		/* err('ReqlQueryLogicError', 'Expected type STRING but found OBJECT.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found OBJECT.")
		/* r.binary(r.expr({})) */

		suite.T().Log("About to run line #332: r.Binary(r.Expr(map[interface{}]interface{}{}))")

		runAndAssert(suite.Suite, expected_, r.Binary(r.Expr(map[interface{}]interface{}{})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #332")
	}

	{
		// datum/binary.yaml line #335
		/* err('ReqlQueryLogicError', 'Expected type STRING but found ARRAY.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found ARRAY.")
		/* r.binary(r.expr([])) */

		suite.T().Log("About to run line #335: r.Binary(r.Expr([]interface{}{}))")

		runAndAssert(suite.Suite, expected_, r.Binary(r.Expr([]interface{}{})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #335")
	}

	{
		// datum/binary.yaml line #341
		/* err('ReqlQueryLogicError','Invalid binary pseudotype:'+' lacking `data` key.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid binary pseudotype:"+" lacking `data` key.")
		/* r.expr({'$reql_type$':'BINARY'}) */

		suite.T().Log("About to run line #341: r.Expr(map[interface{}]interface{}{'$reql_type$': 'BINARY', })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"$reql_type$": "BINARY"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #341")
	}

	{
		// datum/binary.yaml line #346
		/* err('ReqlQueryLogicError','Invalid base64 format, data found after padding character \'=\'.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid base64 format, data found after padding character '='.")
		/* r.expr({'$reql_type$':'BINARY','data':'ABCDEFGH==AA'}) */

		suite.T().Log("About to run line #346: r.Expr(map[interface{}]interface{}{'$reql_type$': 'BINARY', 'data': 'ABCDEFGH==AA', })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"$reql_type$": "BINARY", "data": "ABCDEFGH==AA"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #346")
	}

	{
		// datum/binary.yaml line #348
		/* err('ReqlQueryLogicError','Invalid base64 format, data found after padding character \'=\'.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid base64 format, data found after padding character '='.")
		/* r.expr({'$reql_type$':'BINARY','data':'ABCDEF==$'}) */

		suite.T().Log("About to run line #348: r.Expr(map[interface{}]interface{}{'$reql_type$': 'BINARY', 'data': 'ABCDEF==$', })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"$reql_type$": "BINARY", "data": "ABCDEF==$"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #348")
	}

	{
		// datum/binary.yaml line #350
		/* err('ReqlQueryLogicError','Invalid base64 character found:'+' \'^\'.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid base64 character found:"+" '^'.")
		/* r.expr({'$reql_type$':'BINARY','data':'A^CDEFGH'}) */

		suite.T().Log("About to run line #350: r.Expr(map[interface{}]interface{}{'$reql_type$': 'BINARY', 'data': 'A^CDEFGH', })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"$reql_type$": "BINARY", "data": "A^CDEFGH"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #350")
	}

	{
		// datum/binary.yaml line #352
		/* err('ReqlQueryLogicError','Invalid base64 length:'+' 1 character remaining, cannot decode a full byte.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid base64 length:"+" 1 character remaining, cannot decode a full byte.")
		/* r.expr({'$reql_type$':'BINARY','data':'ABCDE'}) */

		suite.T().Log("About to run line #352: r.Expr(map[interface{}]interface{}{'$reql_type$': 'BINARY', 'data': 'ABCDE', })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"$reql_type$": "BINARY", "data": "ABCDE"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #352")
	}

	{
		// datum/binary.yaml line #356
		/* err('ReqlQueryLogicError','Cannot coerce BINARY to ARRAY.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot coerce BINARY to ARRAY.")
		/* r.binary(a).coerce_to('array') */

		suite.T().Log("About to run line #356: r.Binary(a).CoerceTo('array')")

		runAndAssert(suite.Suite, expected_, r.Binary(a).CoerceTo("array"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #356")
	}

	{
		// datum/binary.yaml line #358
		/* err('ReqlQueryLogicError','Cannot coerce BINARY to OBJECT.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot coerce BINARY to OBJECT.")
		/* r.binary(a).coerce_to('object') */

		suite.T().Log("About to run line #358: r.Binary(a).CoerceTo('object')")

		runAndAssert(suite.Suite, expected_, r.Binary(a).CoerceTo("object"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #358")
	}

	{
		// datum/binary.yaml line #360
		/* err('ReqlQueryLogicError','Cannot coerce BINARY to NUMBER.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot coerce BINARY to NUMBER.")
		/* r.binary(a).coerce_to('number') */

		suite.T().Log("About to run line #360: r.Binary(a).CoerceTo('number')")

		runAndAssert(suite.Suite, expected_, r.Binary(a).CoerceTo("number"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #360")
	}

	{
		// datum/binary.yaml line #362
		/* err('ReqlQueryLogicError','Cannot coerce BINARY to NULL.',[]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot coerce BINARY to NULL.")
		/* r.binary(a).coerce_to('nu'+'ll') */

		suite.T().Log("About to run line #362: r.Binary(a).CoerceTo(r.Add('nu', 'll'))")

		runAndAssert(suite.Suite, expected_, r.Binary(a).CoerceTo(r.Add("nu", "ll")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #362")
	}
}
