// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v4"
	"gopkg.in/gorethink/gorethink.v4/internal/compare"
)

// Tests that manipulation data in tables
func TestTransformationSuite(t *testing.T) {
	suite.Run(t, new(TransformationSuite))
}

type TransformationSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *TransformationSuite) SetupTest() {
	suite.T().Log("Setting up TransformationSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

	r.DB("test").TableDrop("tbl").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl").Wait().Exec(suite.session)
	suite.Require().NoError(err)
	r.DB("test").TableDrop("tbl2").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl2").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl2").Wait().Exec(suite.session)
	suite.Require().NoError(err)
	r.DB("test").TableDrop("tbl3").Exec(suite.session)
	err = r.DB("test").TableCreate("tbl3").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Table("tbl3").Wait().Exec(suite.session)
	suite.Require().NoError(err)
}

func (suite *TransformationSuite) TearDownSuite() {
	suite.T().Log("Tearing down TransformationSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DB("test").TableDrop("tbl").Exec(suite.session)
		r.DB("test").TableDrop("tbl2").Exec(suite.session)
		r.DB("test").TableDrop("tbl3").Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *TransformationSuite) TestCases() {
	suite.T().Log("Running TransformationSuite: Tests that manipulation data in tables")

	tbl := r.DB("test").Table("tbl")
	_ = tbl // Prevent any noused variable errors
	tbl2 := r.DB("test").Table("tbl2")
	_ = tbl2 // Prevent any noused variable errors
	tbl3 := r.DB("test").Table("tbl3")
	_ = tbl3 // Prevent any noused variable errors

	{
		// transformation.yaml line #6
		/* {'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':100} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 100}
		/* tbl.insert([{'id':i, 'a':i%4} for i in xrange(100)]) */

		suite.T().Log("About to run line #6: tbl.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 0; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': i, 'a': r.Mod(i, 4), })\n    }\n    return res\n}()))")

		runAndAssert(suite.Suite, expected_, tbl.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 0; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": i, "a": r.Mod(i, 4)})
			}
			return res
		}())), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	{
		// transformation.yaml line #18
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* tbl.index_create('a') */

		suite.T().Log("About to run line #18: tbl.IndexCreate('a')")

		runAndAssert(suite.Suite, expected_, tbl.IndexCreate("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #18")
	}

	{
		// transformation.yaml line #21
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* tbl.index_create('truncated_a', lambda x: ['a' * 300, x['a']]) */

		suite.T().Log("About to run line #21: tbl.IndexCreateFunc('truncated_a', func(x r.Term) interface{} { return []interface{}{'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', x.AtIndex('a')}})")

		runAndAssert(suite.Suite, expected_, tbl.IndexCreateFunc("truncated_a", func(x r.Term) interface{} {
			return []interface{}{"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", x.AtIndex("a")}
		}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #21")
	}

	{
		// transformation.yaml line #24
		/* {'created':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"created": 1}
		/* tbl.index_create('error_prone', lambda x: 1/x['a']) */

		suite.T().Log("About to run line #24: tbl.IndexCreateFunc('error_prone', func(x r.Term) interface{} { return r.Div(1, x.AtIndex('a'))})")

		runAndAssert(suite.Suite, expected_, tbl.IndexCreateFunc("error_prone", func(x r.Term) interface{} { return r.Div(1, x.AtIndex("a")) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #24")
	}

	{
		// transformation.yaml line #27
		/* AnythingIsFine */
		var expected_ string = compare.AnythingIsFine
		/* tbl.index_wait().pluck('index', 'ready') */

		suite.T().Log("About to run line #27: tbl.IndexWait().Pluck('index', 'ready')")

		runAndAssert(suite.Suite, expected_, tbl.IndexWait().Pluck("index", "ready"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #27")
	}

	{
		// transformation.yaml line #29
		/* {'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':100} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 100}
		/* tbl2.insert([{'id':i, 'b':i%4} for i in xrange(100)]) */

		suite.T().Log("About to run line #29: tbl2.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 0; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': i, 'b': r.Mod(i, 4), })\n    }\n    return res\n}()))")

		runAndAssert(suite.Suite, expected_, tbl2.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 0; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": i, "b": r.Mod(i, 4)})
			}
			return res
		}())), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #29")
	}

	{
		// transformation.yaml line #41
		/* {'deleted':0.0,'replaced':0.0,'unchanged':0.0,'errors':0.0,'skipped':0.0,'inserted':100} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"deleted": 0.0, "replaced": 0.0, "unchanged": 0.0, "errors": 0.0, "skipped": 0.0, "inserted": 100}
		/* tbl3.insert([{'id':i, 'a':i%4, 'b':{'c':i%5}} for i in xrange(100)]) */

		suite.T().Log("About to run line #41: tbl3.Insert((func() []interface{} {\n    res := []interface{}{}\n    for iterator_ := 0; iterator_ < 100; iterator_++ {\n        i := iterator_\n        res = append(res, map[interface{}]interface{}{'id': i, 'a': r.Mod(i, 4), 'b': map[interface{}]interface{}{'c': r.Mod(i, 5), }, })\n    }\n    return res\n}()))")

		runAndAssert(suite.Suite, expected_, tbl3.Insert((func() []interface{} {
			res := []interface{}{}
			for iterator_ := 0; iterator_ < 100; iterator_++ {
				i := iterator_
				res = append(res, map[interface{}]interface{}{"id": i, "a": r.Mod(i, 4), "b": map[interface{}]interface{}{"c": r.Mod(i, 5)}})
			}
			return res
		}())), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #41")
	}

	{
		// transformation.yaml line #55
		/* 4950 */
		var expected_ int = 4950
		/* tbl.map(lambda row:row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #55: tbl.Map(func(row r.Term) interface{} { return row.AtIndex('id')}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Map(func(row r.Term) interface{} { return row.AtIndex("id") }).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #55")
	}

	{
		// transformation.yaml line #56
		/* 4950 */
		var expected_ int = 4950
		/* tbl.map(r.row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #56: tbl.Map(r.Row.AtIndex('id')).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Map(r.Row.AtIndex("id")).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #56")
	}

	{
		// transformation.yaml line #65
		/* 9900 */
		var expected_ int = 9900
		/* tbl.union(tbl).map(lambda row:row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #65: tbl.Union(tbl).Map(func(row r.Term) interface{} { return row.AtIndex('id')}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Union(tbl).Map(func(row r.Term) interface{} { return row.AtIndex("id") }).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #65")
	}

	{
		// transformation.yaml line #66
		/* 9900 */
		var expected_ int = 9900
		/* tbl.union(tbl).map(r.row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #66: tbl.Union(tbl).Map(r.Row.AtIndex('id')).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Union(tbl).Map(r.Row.AtIndex("id")).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #66")
	}

	{
		// transformation.yaml line #75
		/* 9900 */
		var expected_ int = 9900
		/* tbl.coerce_to("array").union(tbl).map(lambda row:row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #75: tbl.CoerceTo('array').Union(tbl).Map(func(row r.Term) interface{} { return row.AtIndex('id')}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Union(tbl).Map(func(row r.Term) interface{} { return row.AtIndex("id") }).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #75")
	}

	{
		// transformation.yaml line #76
		/* 9900 */
		var expected_ int = 9900
		/* tbl.coerce_to("array").union(tbl).map(r.row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #76: tbl.CoerceTo('array').Union(tbl).Map(r.Row.AtIndex('id')).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Union(tbl).Map(r.Row.AtIndex("id")).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #76")
	}

	{
		// transformation.yaml line #85
		/* 9900 */
		var expected_ int = 9900
		/* tbl.union(tbl.coerce_to("array")).map(lambda row:row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #85: tbl.Union(tbl.CoerceTo('array')).Map(func(row r.Term) interface{} { return row.AtIndex('id')}).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Union(tbl.CoerceTo("array")).Map(func(row r.Term) interface{} { return row.AtIndex("id") }).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #85")
	}

	{
		// transformation.yaml line #86
		/* 9900 */
		var expected_ int = 9900
		/* tbl.union(tbl.coerce_to("array")).map(r.row['id']).reduce(lambda a,b:a+b) */

		suite.T().Log("About to run line #86: tbl.Union(tbl.CoerceTo('array')).Map(r.Row.AtIndex('id')).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b)})")

		runAndAssert(suite.Suite, expected_, tbl.Union(tbl.CoerceTo("array")).Map(r.Row.AtIndex("id")).Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #86")
	}

	{
		// transformation.yaml line #94
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* tbl.get_all().fold(0, lambda acc, _: acc.add(1), emit=lambda old,row,acc: [acc]) */

		suite.T().Log("About to run line #94: tbl.GetAll().Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1)}).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return []interface{}{acc}}, })")

		runAndAssert(suite.Suite, expected_, tbl.GetAll().Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1) }).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return []interface{}{acc} }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #94")
	}

	{
		// transformation.yaml line #97
		/* err("ReqlQueryLogicError", "Expected type ARRAY but found NUMBER.") */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type ARRAY but found NUMBER.")
		/* r.range(0, 10).fold(0, lambda acc, _: acc.add(1), emit=lambda old,row,acc: acc) */

		suite.T().Log("About to run line #97: r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1)}).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return acc}, })")

		runAndAssert(suite.Suite, expected_, r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1) }).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return acc }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #97")
	}

	{
		// transformation.yaml line #100
		/* err("ReqlQueryLogicError", "Expected type DATUM but found SEQUENCE:") */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type DATUM but found SEQUENCE:")
		/* r.range(0, 10).fold(0, lambda acc, _: acc.add(1), emit=lambda old,row,acc: r.range()) */

		suite.T().Log("About to run line #100: r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1)}).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return r.Range()}, })")

		runAndAssert(suite.Suite, expected_, r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1) }).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return r.Range() }}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #100")
	}

	{
		// transformation.yaml line #103
		/* err("ReqlQueryLogicError", "Cannot call `changes` on an eager stream.") */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot call `changes` on an eager stream.")
		/* r.range(0, 10).fold(0, lambda acc, _: acc.add(1), emit=lambda old,row,acc: [acc]).changes() */

		suite.T().Log("About to run line #103: r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1)}).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return []interface{}{acc}}, }).Changes()")

		runAndAssert(suite.Suite, expected_, r.Range(0, 10).Fold(0, func(acc r.Term, _ r.Term) interface{} { return acc.Add(1) }).OptArgs(r.FoldOpts{Emit: func(old r.Term, row r.Term, acc r.Term) interface{} { return []interface{}{acc} }}).Changes(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #103")
	}

	{
		// transformation.yaml line #111
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* tbl.concat_map(lambda row:[]) */

		suite.T().Log("About to run line #111: tbl.ConcatMap(func(row r.Term) interface{} { return []interface{}{}})")

		runAndAssert(suite.Suite, expected_, tbl.ConcatMap(func(row r.Term) interface{} { return []interface{}{} }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #111")
	}

	// transformation.yaml line #116
	// ccm = tbl.concat_map(lambda row:[row['a'], (row['a'] + 1) % 4])
	suite.T().Log("Possibly executing: var ccm r.Term = tbl.ConcatMap(func(row r.Term) interface{} { return []interface{}{row.AtIndex('a'), row.AtIndex('a').Add(1).Mod(4)}})")

	ccm := tbl.ConcatMap(func(row r.Term) interface{} { return []interface{}{row.AtIndex("a"), row.AtIndex("a").Add(1).Mod(4)} })
	_ = ccm // Prevent any noused variable errors

	{
		// transformation.yaml line #119
		/* 200 */
		var expected_ int = 200
		/* ccm.count() */

		suite.T().Log("About to run line #119: ccm.Count()")

		runAndAssert(suite.Suite, expected_, ccm.Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #119")
	}

	{
		// transformation.yaml line #121
		/* 0 */
		var expected_ int = 0
		/* ccm.reduce(lambda a,b:(a+b) % 4) */

		suite.T().Log("About to run line #121: ccm.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b).Mod(4)})")

		runAndAssert(suite.Suite, expected_, ccm.Reduce(func(a r.Term, b r.Term) interface{} { return r.Add(a, b).Mod(4) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #121")
	}

	{
		// transformation.yaml line #127
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('id')[0] */

		suite.T().Log("About to run line #127: tbl.OrderBy('id').AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #127")
	}

	{
		// transformation.yaml line #132
		/* err('ReqlQueryLogicError', 'Expected type STRING but found ARRAY.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type STRING but found ARRAY.")
		/* tbl.order_by([1,2,3]) */

		suite.T().Log("About to run line #132: tbl.OrderBy([]interface{}{1, 2, 3})")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy([]interface{}{1, 2, 3}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #132")
	}

	{
		// transformation.yaml line #137
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by(index='id')[0] */

		suite.T().Log("About to run line #137: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #137")
	}

	{
		// transformation.yaml line #142
		/* 1 */
		var expected_ int = 1
		/* tbl.order_by(index='id')[0].update({'a':0})['unchanged'] */

		suite.T().Log("About to run line #142: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0).Update(map[interface{}]interface{}{'a': 0, }).AtIndex('unchanged')")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0).Update(map[interface{}]interface{}{"a": 0}).AtIndex("unchanged"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #142")
	}

	{
		// transformation.yaml line #147
		/* 1 */
		var expected_ int = 1
		/* tbl.get_all(0).update({'a':0})['unchanged'] */

		suite.T().Log("About to run line #147: tbl.GetAll(0).Update(map[interface{}]interface{}{'a': 0, }).AtIndex('unchanged')")

		runAndAssert(suite.Suite, expected_, tbl.GetAll(0).Update(map[interface{}]interface{}{"a": 0}).AtIndex("unchanged"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #147")
	}

	{
		// transformation.yaml line #152
		/* err('ReqlQueryLogicError', 'Cannot perform multiple indexed ORDER_BYs on the same table.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform multiple indexed ORDER_BYs on the same table.")
		/* tbl.order_by(index='id').order_by(index='id')[0] */

		suite.T().Log("About to run line #152: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #152")
	}

	{
		// transformation.yaml line #158
		/* err('ReqlQueryLogicError', 'Cannot perform multiple indexed ORDER_BYs on the same table.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform multiple indexed ORDER_BYs on the same table.")
		/* tbl.order_by(index='id').order_by(index='id')[0] */

		suite.T().Log("About to run line #158: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #158")
	}

	{
		// transformation.yaml line #163
		/* err('ReqlQueryLogicError', 'Indexed order_by can only be performed on a TABLE or TABLE_SLICE.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Indexed order_by can only be performed on a TABLE or TABLE_SLICE.")
		/* tbl.order_by('id').order_by(index='id')[0] */

		suite.T().Log("About to run line #163: tbl.OrderBy('id').OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #163")
	}

	{
		// transformation.yaml line #168
		/* err('ReqlQueryLogicError', 'Indexed order_by can only be performed on a TABLE or TABLE_SLICE.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Indexed order_by can only be performed on a TABLE or TABLE_SLICE.")
		/* tbl.order_by('id').order_by(index='a')[0] */

		suite.T().Log("About to run line #168: tbl.OrderBy('id').OrderBy().OptArgs(r.OrderByOpts{Index: 'a', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OrderBy().OptArgs(r.OrderByOpts{Index: "a"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #168")
	}

	{
		// transformation.yaml line #173
		/* {'id':5, 'a':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 5, "a": 1}
		/* tbl.between(5, r.maxval, index='id').order_by(index='id')[0] */

		suite.T().Log("About to run line #173: tbl.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', }).OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id"}).OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #173")
	}

	{
		// transformation.yaml line #178
		/* err('ReqlQueryLogicError', 'Expected type TABLE_SLICE but found SELECTION:', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type TABLE_SLICE but found SELECTION:")
		/* tbl.order_by('a', index='id').between(5, r.maxval, index='id')[0] */

		suite.T().Log("About to run line #178: tbl.OrderBy('a').OptArgs(r.OrderByOpts{Index: 'id', }).Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: 'id', }).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("a").OptArgs(r.OrderByOpts{Index: "id"}).Between(5, r.MaxVal).OptArgs(r.BetweenOpts{Index: "id"}).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #178")
	}

	{
		// transformation.yaml line #183
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by(lambda x: x['id'])[0] */

		suite.T().Log("About to run line #183: tbl.OrderBy(func(x r.Term) interface{} { return x.AtIndex('id')}).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(func(x r.Term) interface{} { return x.AtIndex("id") }).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #183")
	}

	{
		// transformation.yaml line #188
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('a', 'id').nth(0) */

		suite.T().Log("About to run line #188: tbl.OrderBy('a', 'id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("a", "id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #188")
	}

	{
		// transformation.yaml line #191
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('id', index='a').nth(0) */

		suite.T().Log("About to run line #191: tbl.OrderBy('id').OptArgs(r.OrderByOpts{Index: 'a', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OptArgs(r.OrderByOpts{Index: "a"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #191")
	}

	{
		// transformation.yaml line #196
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('id', index='truncated_a').nth(0) */

		suite.T().Log("About to run line #196: tbl.OrderBy('id').OptArgs(r.OrderByOpts{Index: 'truncated_a', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OptArgs(r.OrderByOpts{Index: "truncated_a"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	{
		// transformation.yaml line #199
		/* {'id':3,'a':3} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 3, "a": 3}
		/* tbl.order_by('id', index='error_prone').nth(0) */

		suite.T().Log("About to run line #199: tbl.OrderBy('id').OptArgs(r.OrderByOpts{Index: 'error_prone', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OptArgs(r.OrderByOpts{Index: "error_prone"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #199")
	}

	{
		// transformation.yaml line #202
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by(lambda x: [x['a'], x['id']])[0] */

		suite.T().Log("About to run line #202: tbl.OrderBy(func(x r.Term) interface{} { return []interface{}{x.AtIndex('a'), x.AtIndex('id')}}).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(func(x r.Term) interface{} { return []interface{}{x.AtIndex("a"), x.AtIndex("id")} }).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #202")
	}

	{
		// transformation.yaml line #207
		/* {'id':3,'a':3} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 3, "a": 3}
		/* tbl.order_by(r.desc('a'), r.asc('id')).nth(0) */

		suite.T().Log("About to run line #207: tbl.OrderBy(r.Desc('a'), r.Asc('id')).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(r.Desc("a"), r.Asc("id")).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #207")
	}

	{
		// transformation.yaml line #210
		/* {'id':3,'a':3} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 3, "a": 3}
		/* tbl.order_by('id', index=r.desc('a')).nth(0) */

		suite.T().Log("About to run line #210: tbl.OrderBy('id').OptArgs(r.OrderByOpts{Index: r.Desc('a'), }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").OptArgs(r.OrderByOpts{Index: r.Desc("a")}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #210")
	}

	{
		// transformation.yaml line #215
		/* {'id':3, 'a':3} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 3, "a": 3}
		/* tbl.order_by(r.desc(lambda x: x['a']), lambda x: x['id'])[0] */

		suite.T().Log("About to run line #215: tbl.OrderBy(r.Desc(func(x r.Term) interface{} { return x.AtIndex('a')}), func(x r.Term) interface{} { return x.AtIndex('id')}).AtIndex(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(r.Desc(func(x r.Term) interface{} { return x.AtIndex("a") }), func(x r.Term) interface{} { return x.AtIndex("id") }).AtIndex(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #215")
	}

	{
		// transformation.yaml line #220
		/* {'id':96,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 96, "a": 0}
		/* tbl.order_by(r.asc('a'), r.desc('id')).nth(0) */

		suite.T().Log("About to run line #220: tbl.OrderBy(r.Asc('a'), r.Desc('id')).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(r.Asc("a"), r.Desc("id")).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #220")
	}

	{
		// transformation.yaml line #223
		/* {'id':96,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 96, "a": 0}
		/* tbl.order_by(r.desc('id'), index='a').nth(0) */

		suite.T().Log("About to run line #223: tbl.OrderBy(r.Desc('id')).OptArgs(r.OrderByOpts{Index: 'a', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(r.Desc("id")).OptArgs(r.OrderByOpts{Index: "a"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #223")
	}

	{
		// transformation.yaml line #228
		/* 'SELECTION<ARRAY>' */
		var expected_ string = "SELECTION<ARRAY>"
		/* tbl.order_by('id').type_of() */

		suite.T().Log("About to run line #228: tbl.OrderBy('id').TypeOf()")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #228")
	}

	{
		// transformation.yaml line #231
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('missing').order_by('id').nth(0) */

		suite.T().Log("About to run line #231: tbl.OrderBy('missing').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("missing").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// transformation.yaml line #234
		/* err('ReqlQueryLogicError', 'Indexed order_by can only be performed on a TABLE or TABLE_SLICE.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Indexed order_by can only be performed on a TABLE or TABLE_SLICE.")
		/* tbl.order_by('missing').order_by(index='id').nth(0) */

		suite.T().Log("About to run line #234: tbl.OrderBy('missing').OrderBy().OptArgs(r.OrderByOpts{Index: 'id', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("missing").OrderBy().OptArgs(r.OrderByOpts{Index: "id"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #234")
	}

	{
		// transformation.yaml line #239
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('id', 'missing').nth(0) */

		suite.T().Log("About to run line #239: tbl.OrderBy('id', 'missing').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id", "missing").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #239")
	}

	{
		// transformation.yaml line #242
		/* {'id':0, 'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.order_by('missing', index='id').nth(0) */

		suite.T().Log("About to run line #242: tbl.OrderBy('missing').OptArgs(r.OrderByOpts{Index: 'id', }).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("missing").OptArgs(r.OrderByOpts{Index: "id"}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #242")
	}

	{
		// transformation.yaml line #247
		/* true */
		var expected_ bool = true
		/* tbl.order_by(r.desc('id')).coerce_to('ARRAY') == tbl.order_by(lambda x: 0 - x['id']).coerce_to('ARRAY') */

		suite.T().Log("About to run line #247: tbl.OrderBy(r.Desc('id')).CoerceTo('ARRAY').Eq(tbl.OrderBy(func(x r.Term) interface{} { return r.Sub(0, x.AtIndex('id'))}).CoerceTo('ARRAY'))")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy(r.Desc("id")).CoerceTo("ARRAY").Eq(tbl.OrderBy(func(x r.Term) interface{} { return r.Sub(0, x.AtIndex("id")) }).CoerceTo("ARRAY")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #247")
	}

	{
		// transformation.yaml line #252
		/* true */
		var expected_ bool = true
		/* tbl.order_by(index=r.desc('id')).coerce_to('ARRAY') == tbl.order_by(lambda x: 0 - x['id']).coerce_to('ARRAY') */

		suite.T().Log("About to run line #252: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc('id'), }).CoerceTo('ARRAY').Eq(tbl.OrderBy(func(x r.Term) interface{} { return r.Sub(0, x.AtIndex('id'))}).CoerceTo('ARRAY'))")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc("id")}).CoerceTo("ARRAY").Eq(tbl.OrderBy(func(x r.Term) interface{} { return r.Sub(0, x.AtIndex("id")) }).CoerceTo("ARRAY")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #252")
	}

	{
		// transformation.yaml line #257
		/* true */
		var expected_ bool = true
		/* tbl.order_by(index=r.desc('id')).coerce_to('ARRAY') == tbl.order_by(r.desc('id')).coerce_to('ARRAY') */

		suite.T().Log("About to run line #257: tbl.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc('id'), }).CoerceTo('ARRAY').Eq(tbl.OrderBy(r.Desc('id')).CoerceTo('ARRAY'))")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy().OptArgs(r.OrderByOpts{Index: r.Desc("id")}).CoerceTo("ARRAY").Eq(tbl.OrderBy(r.Desc("id")).CoerceTo("ARRAY")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #257")
	}

	{
		// transformation.yaml line #263
		/* 99 */
		var expected_ int = 99
		/* tbl.skip(1).count() */

		suite.T().Log("About to run line #263: tbl.Skip(1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Skip(1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #263")
	}

	{
		// transformation.yaml line #265
		/* err('ReqlQueryLogicError', 'Cannot use a negative left index on a stream.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.")
		/* tbl.skip(-1).count() */

		suite.T().Log("About to run line #265: tbl.Skip(-1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Skip(-1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #265")
	}

	{
		// transformation.yaml line #267
		/* err('ReqlQueryLogicError', 'Expected type NUMBER but found STRING.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* tbl.skip('foo').count() */

		suite.T().Log("About to run line #267: tbl.Skip('foo').Count()")

		runAndAssert(suite.Suite, expected_, tbl.Skip("foo").Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #267")
	}

	{
		// transformation.yaml line #271
		/* 1 */
		var expected_ int = 1
		/* tbl.limit(1).count() */

		suite.T().Log("About to run line #271: tbl.Limit(1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Limit(1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #271")
	}

	{
		// transformation.yaml line #273
		/* err('ReqlQueryLogicError', 'LIMIT takes a non-negative argument (got -1)', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "LIMIT takes a non-negative argument (got -1)")
		/* tbl.limit(-1).count() */

		suite.T().Log("About to run line #273: tbl.Limit(-1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Limit(-1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #273")
	}

	{
		// transformation.yaml line #275
		/* err('ReqlQueryLogicError', 'Expected type NUMBER but found STRING.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* tbl.limit('foo').count() */

		suite.T().Log("About to run line #275: tbl.Limit('foo').Count()")

		runAndAssert(suite.Suite, expected_, tbl.Limit("foo").Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #275")
	}

	{
		// transformation.yaml line #279
		/* 2 */
		var expected_ int = 2
		/* tbl.slice(1, 3).count() */

		suite.T().Log("About to run line #279: tbl.Slice(1, 3).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(1, 3).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #279")
	}

	{
		// transformation.yaml line #281
		/* 95 */
		var expected_ int = 95
		/* tbl.slice(5).count() */

		suite.T().Log("About to run line #281: tbl.Slice(5).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(5).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #281")
	}

	{
		// transformation.yaml line #283
		/* err('ReqlQueryLogicError', 'Cannot use a negative left index on a stream.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.")
		/* tbl.slice(-1, -3).count() */

		suite.T().Log("About to run line #283: tbl.Slice(-1, -3).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(-1, -3).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #283")
	}

	{
		// transformation.yaml line #285
		/* err('ReqlQueryLogicError', 'Cannot use a right index < -1 on a stream.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a right index < -1 on a stream.")
		/* tbl.slice(0, -3).count() */

		suite.T().Log("About to run line #285: tbl.Slice(0, -3).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(0, -3).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #285")
	}

	{
		// transformation.yaml line #287
		/* err('ReqlQueryLogicError', 'Cannot slice to an open right index of -1 on a stream.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot slice to an open right index of -1 on a stream.")
		/* tbl.slice(0, -1).count() */

		suite.T().Log("About to run line #287: tbl.Slice(0, -1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(0, -1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #287")
	}

	{
		// transformation.yaml line #289
		/* err('ReqlQueryLogicError', 'Expected type NUMBER but found STRING.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* tbl.slice('foo', 'bar').count() */

		suite.T().Log("About to run line #289: tbl.Slice('foo', 'bar').Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice("foo", "bar").Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #289")
	}

	{
		// transformation.yaml line #291
		/* err('ReqlNonExistenceError', 'Expected type NUMBER but found NULL.', [0]) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* tbl.slice(1, null).count() */

		suite.T().Log("About to run line #291: tbl.Slice(1, nil).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(1, nil).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #291")
	}

	{
		// transformation.yaml line #293
		/* err('ReqlNonExistenceError', 'Expected type NUMBER but found NULL.', [0]) */
		var expected_ Err = err("ReqlNonExistenceError", "Expected type NUMBER but found NULL.")
		/* tbl.slice(null, 1).count() */

		suite.T().Log("About to run line #293: tbl.Slice(nil, 1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(nil, 1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #293")
	}

	{
		// transformation.yaml line #296
		/* 8 */
		var expected_ int = 8
		/* tbl.slice(12, 20).count() */

		suite.T().Log("About to run line #296: tbl.Slice(12, 20).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, 20).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #296")
	}

	{
		// transformation.yaml line #299
		/* 9 */
		var expected_ int = 9
		/* tbl.slice(12, 20, right_bound='closed').count() */

		suite.T().Log("About to run line #299: tbl.Slice(12, 20).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, 20).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #299")
	}

	{
		// transformation.yaml line #303
		/* 7 */
		var expected_ int = 7
		/* tbl.slice(12, 20, left_bound='open').count() */

		suite.T().Log("About to run line #303: tbl.Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #303")
	}

	{
		// transformation.yaml line #307
		/* 8 */
		var expected_ int = 8
		/* tbl.slice(12, 20, left_bound='open', right_bound='closed').count() */

		suite.T().Log("About to run line #307: tbl.Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: 'open', RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: "open", RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #307")
	}

	{
		// transformation.yaml line #311
		/* err("ReqlQueryLogicError", "Cannot slice to an open right index of -1 on a stream.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot slice to an open right index of -1 on a stream.")
		/* tbl.slice(12, -1).count() */

		suite.T().Log("About to run line #311: tbl.Slice(12, -1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, -1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #311")
	}

	{
		// transformation.yaml line #314
		/* 88 */
		var expected_ int = 88
		/* tbl.slice(12, -1, right_bound='closed').count() */

		suite.T().Log("About to run line #314: tbl.Slice(12, -1).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, -1).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #314")
	}

	{
		// transformation.yaml line #318
		/* err("ReqlQueryLogicError", "Cannot use a right index < -1 on a stream.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a right index < -1 on a stream.")
		/* tbl.slice(12, -2).count() */

		suite.T().Log("About to run line #318: tbl.Slice(12, -2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, -2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #318")
	}

	{
		// transformation.yaml line #321
		/* err("ReqlQueryLogicError", "Cannot use a right index < -1 on a stream.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a right index < -1 on a stream.")
		/* tbl.slice(12, -2, right_bound='closed').count() */

		suite.T().Log("About to run line #321: tbl.Slice(12, -2).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(12, -2).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #321")
	}

	{
		// transformation.yaml line #325
		/* err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.")
		/* tbl.slice(-12, -2).count() */

		suite.T().Log("About to run line #325: tbl.Slice(-12, -2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(-12, -2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #325")
	}

	{
		// transformation.yaml line #328
		/* err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.", []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot use a negative left index on a stream.")
		/* tbl.slice(-12, -2, right_bound='closed').count() */

		suite.T().Log("About to run line #328: tbl.Slice(-12, -2).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Slice(-12, -2).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #328")
	}

	{
		// transformation.yaml line #332
		/* 8 */
		var expected_ int = 8
		/* tbl.coerce_to('array').slice(12, 20).count() */

		suite.T().Log("About to run line #332: tbl.CoerceTo('array').Slice(12, 20).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, 20).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #332")
	}

	{
		// transformation.yaml line #335
		/* 9 */
		var expected_ int = 9
		/* tbl.coerce_to('array').slice(12, 20, right_bound='closed').count() */

		suite.T().Log("About to run line #335: tbl.CoerceTo('array').Slice(12, 20).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, 20).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #335")
	}

	{
		// transformation.yaml line #339
		/* 7 */
		var expected_ int = 7
		/* tbl.coerce_to('array').slice(12, 20, left_bound='open').count() */

		suite.T().Log("About to run line #339: tbl.CoerceTo('array').Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: 'open', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: "open"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #339")
	}

	{
		// transformation.yaml line #343
		/* 8 */
		var expected_ int = 8
		/* tbl.coerce_to('array').slice(12, 20, left_bound='open', right_bound='closed').count() */

		suite.T().Log("About to run line #343: tbl.CoerceTo('array').Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: 'open', RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, 20).OptArgs(r.SliceOpts{LeftBound: "open", RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #343")
	}

	{
		// transformation.yaml line #347
		/* 87 */
		var expected_ int = 87
		/* tbl.coerce_to('array').slice(12, -1).count() */

		suite.T().Log("About to run line #347: tbl.CoerceTo('array').Slice(12, -1).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, -1).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #347")
	}

	{
		// transformation.yaml line #350
		/* 88 */
		var expected_ int = 88
		/* tbl.coerce_to('array').slice(12, -1, right_bound='closed').count() */

		suite.T().Log("About to run line #350: tbl.CoerceTo('array').Slice(12, -1).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, -1).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #350")
	}

	{
		// transformation.yaml line #354
		/* 86 */
		var expected_ int = 86
		/* tbl.coerce_to('array').slice(12, -2).count() */

		suite.T().Log("About to run line #354: tbl.CoerceTo('array').Slice(12, -2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, -2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #354")
	}

	{
		// transformation.yaml line #357
		/* 87 */
		var expected_ int = 87
		/* tbl.coerce_to('array').slice(12, -2, right_bound='closed').count() */

		suite.T().Log("About to run line #357: tbl.CoerceTo('array').Slice(12, -2).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(12, -2).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #357")
	}

	{
		// transformation.yaml line #361
		/* 10 */
		var expected_ int = 10
		/* tbl.coerce_to('array').slice(-12, -2).count() */

		suite.T().Log("About to run line #361: tbl.CoerceTo('array').Slice(-12, -2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(-12, -2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #361")
	}

	{
		// transformation.yaml line #364
		/* 11 */
		var expected_ int = 11
		/* tbl.coerce_to('array').slice(-12, -2, right_bound='closed').count() */

		suite.T().Log("About to run line #364: tbl.CoerceTo('array').Slice(-12, -2).OptArgs(r.SliceOpts{RightBound: 'closed', }).Count()")

		runAndAssert(suite.Suite, expected_, tbl.CoerceTo("array").Slice(-12, -2).OptArgs(r.SliceOpts{RightBound: "closed"}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #364")
	}

	// transformation.yaml line #368
	// arr = r.expr([1,2,3,4,5])
	suite.T().Log("Possibly executing: var arr r.Term = r.Expr([]interface{}{1, 2, 3, 4, 5})")

	arr := r.Expr([]interface{}{1, 2, 3, 4, 5})
	_ = arr // Prevent any noused variable errors

	{
		// transformation.yaml line #372
		/* [2, 3] */
		var expected_ []interface{} = []interface{}{2, 3}
		/* arr[1:3] */

		suite.T().Log("About to run line #372: arr.Slice(1, 3)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, 3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #372")
	}

	{
		// transformation.yaml line #377
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* arr[1:-3] */

		suite.T().Log("About to run line #377: arr.Slice(1, -3)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, -3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #377")
	}

	{
		// transformation.yaml line #380
		/* [2,3,4,5] */
		var expected_ []interface{} = []interface{}{2, 3, 4, 5}
		/* arr[1:] */

		suite.T().Log("About to run line #380: arr.Slice(1, -1, r.SliceOpts{RightBound: 'closed'})")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, -1, r.SliceOpts{RightBound: "closed"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #380")
	}

	{
		// transformation.yaml line #383
		/* [2,3,4] */
		var expected_ []interface{} = []interface{}{2, 3, 4}
		/* arr[1:-1] */

		suite.T().Log("About to run line #383: arr.Slice(1, -1)")

		runAndAssert(suite.Suite, expected_, arr.Slice(1, -1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #383")
	}

	{
		// transformation.yaml line #387
		/* {'id':1,'a':1} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 1, "a": 1}
		/* tbl.order_by('id').nth(1) */

		suite.T().Log("About to run line #387: tbl.OrderBy('id').Nth(1)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").Nth(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #387")
	}

	{
		// transformation.yaml line #389
		/* {'id':99,'a':3} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 99, "a": 3}
		/* tbl.order_by('id').nth(-1) */

		suite.T().Log("About to run line #389: tbl.OrderBy('id').Nth(-1)")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").Nth(-1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #389")
	}

	{
		// transformation.yaml line #391
		/* err('ReqlQueryLogicError', 'Expected type NUMBER but found STRING.', [0]) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type NUMBER but found STRING.")
		/* tbl.order_by('id').nth('foo').count() */

		suite.T().Log("About to run line #391: tbl.OrderBy('id').Nth('foo').Count()")

		runAndAssert(suite.Suite, expected_, tbl.OrderBy("id").Nth("foo").Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #391")
	}

	{
		// transformation.yaml line #395
		/* false */
		var expected_ bool = false
		/* tbl.is_empty() */

		suite.T().Log("About to run line #395: tbl.IsEmpty()")

		runAndAssert(suite.Suite, expected_, tbl.IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #395")
	}

	{
		// transformation.yaml line #397
		/* true */
		var expected_ bool = true
		/* tbl.limit(0).is_empty() */

		suite.T().Log("About to run line #397: tbl.Limit(0).IsEmpty()")

		runAndAssert(suite.Suite, expected_, tbl.Limit(0).IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #397")
	}

	{
		// transformation.yaml line #399
		/* err('ReqlQueryLogicError', 'Cannot convert NUMBER to SEQUENCE', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot convert NUMBER to SEQUENCE")
		/* r.expr(1).is_empty() */

		suite.T().Log("About to run line #399: r.Expr(1).IsEmpty()")

		runAndAssert(suite.Suite, expected_, r.Expr(1).IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #399")
	}

	{
		// transformation.yaml line #401
		/* err('ReqlQueryLogicError', 'Cannot convert STRING to SEQUENCE', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot convert STRING to SEQUENCE")
		/* r.expr("").is_empty() */

		suite.T().Log("About to run line #401: r.Expr('').IsEmpty()")

		runAndAssert(suite.Suite, expected_, r.Expr("").IsEmpty(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #401")
	}

	{
		// transformation.yaml line #405
		/* {} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{}
		/* tbl3.pluck().nth(0) */

		suite.T().Log("About to run line #405: tbl3.Pluck().Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck().Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #405")
	}

	{
		// transformation.yaml line #408
		/* {} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{}
		/* tbl3.pluck({}).nth(0) */

		suite.T().Log("About to run line #408: tbl3.Pluck(map[interface{}]interface{}{}).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck(map[interface{}]interface{}{}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #408")
	}

	{
		// transformation.yaml line #411
		/* {} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{}
		/* tbl3.pluck([]).nth(0) */

		suite.T().Log("About to run line #411: tbl3.Pluck([]interface{}{}).Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck([]interface{}{}).Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #411")
	}

	{
		// transformation.yaml line #414
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck('id').order_by('id').nth(0) */

		suite.T().Log("About to run line #414: tbl3.Pluck('id').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck("id").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #414")
	}

	{
		// transformation.yaml line #417
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck(['id']).order_by('id').nth(0) */

		suite.T().Log("About to run line #417: tbl3.Pluck([]interface{}{'id'}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck([]interface{}{"id"}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #417")
	}

	{
		// transformation.yaml line #420
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck({'id':True}).order_by('id').nth(0) */

		suite.T().Log("About to run line #420: tbl3.Pluck(map[interface{}]interface{}{'id': true, }).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck(map[interface{}]interface{}{"id": true}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #420")
	}

	{
		// transformation.yaml line #425
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl3.pluck('id', 'a').order_by('id').nth(0) */

		suite.T().Log("About to run line #425: tbl3.Pluck('id', 'a').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck("id", "a").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #425")
	}

	{
		// transformation.yaml line #428
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl3.pluck(['id', 'a']).order_by('id').nth(0) */

		suite.T().Log("About to run line #428: tbl3.Pluck([]interface{}{'id', 'a'}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck([]interface{}{"id", "a"}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #428")
	}

	{
		// transformation.yaml line #431
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl3.pluck({'id':True, 'a':True}).order_by('id').nth(0) */

		suite.T().Log("About to run line #431: tbl3.Pluck(map[interface{}]interface{}{'id': true, 'a': true, }).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck(map[interface{}]interface{}{"id": true, "a": true}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #431")
	}

	{
		// transformation.yaml line #436
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck('id', 'missing').order_by('id').nth(0) */

		suite.T().Log("About to run line #436: tbl3.Pluck('id', 'missing').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck("id", "missing").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #436")
	}

	{
		// transformation.yaml line #439
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck(['id', 'missing']).order_by('id').nth(0) */

		suite.T().Log("About to run line #439: tbl3.Pluck([]interface{}{'id', 'missing'}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck([]interface{}{"id", "missing"}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #439")
	}

	{
		// transformation.yaml line #442
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.pluck({'id':True, 'missing':True}).order_by('id').nth(0) */

		suite.T().Log("About to run line #442: tbl3.Pluck(map[interface{}]interface{}{'id': true, 'missing': true, }).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck(map[interface{}]interface{}{"id": true, "missing": true}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #442")
	}

	{
		// transformation.yaml line #447
		/* {'id':0, 'b':{'c':0}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "b": map[interface{}]interface{}{"c": 0}}
		/* tbl3.pluck('id', {'b':'c'}).order_by('id').nth(0) */

		suite.T().Log("About to run line #447: tbl3.Pluck('id', map[interface{}]interface{}{'b': 'c', }).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck("id", map[interface{}]interface{}{"b": "c"}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #447")
	}

	{
		// transformation.yaml line #450
		/* {'id':0, 'b':{'c':0}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "b": map[interface{}]interface{}{"c": 0}}
		/* tbl3.pluck(['id', {'b':'c'}]).order_by('id').nth(0) */

		suite.T().Log("About to run line #450: tbl3.Pluck([]interface{}{'id', map[interface{}]interface{}{'b': 'c', }}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck([]interface{}{"id", map[interface{}]interface{}{"b": "c"}}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #450")
	}

	{
		// transformation.yaml line #453
		/* err('ReqlQueryLogicError', 'Invalid path argument `1`.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Invalid path argument `1`.")
		/* tbl3.pluck(1) */

		suite.T().Log("About to run line #453: tbl3.Pluck(1)")

		runAndAssert(suite.Suite, expected_, tbl3.Pluck(1), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #453")
	}

	{
		// transformation.yaml line #456
		/* err('ReqlQueryLogicError', 'Cannot perform pluck on a sequence of sequences.', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Cannot perform pluck on a sequence of sequences.")
		/* r.expr([[{"foo":1}]]).pluck("foo") */

		suite.T().Log("About to run line #456: r.Expr([]interface{}{[]interface{}{map[interface{}]interface{}{'foo': 1, }}}).Pluck('foo')")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{[]interface{}{map[interface{}]interface{}{"foo": 1}}}).Pluck("foo"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #456")
	}

	{
		// transformation.yaml line #461
		/* [{'a':1},{'b':2}] */
		var expected_ []interface{} = []interface{}{map[interface{}]interface{}{"a": 1}, map[interface{}]interface{}{"b": 2}}
		/* r.expr(['a','b']).map(lambda x:r.expr({'a':1,'b':2}).pluck(x)) */

		suite.T().Log("About to run line #461: r.Expr([]interface{}{'a', 'b'}).Map(func(x r.Term) interface{} { return r.Expr(map[interface{}]interface{}{'a': 1, 'b': 2, }).Pluck(x)})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{"a", "b"}).Map(func(x r.Term) interface{} { return r.Expr(map[interface{}]interface{}{"a": 1, "b": 2}).Pluck(x) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #461")
	}

	{
		// transformation.yaml line #466
		/* {"foo":{}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"foo": map[interface{}]interface{}{}}
		/* r.expr({"foo":{"bar":1}}).pluck({"foo":{"bar":"buzz"}}) */

		suite.T().Log("About to run line #466: r.Expr(map[interface{}]interface{}{'foo': map[interface{}]interface{}{'bar': 1, }, }).Pluck(map[interface{}]interface{}{'foo': map[interface{}]interface{}{'bar': 'buzz', }, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"foo": map[interface{}]interface{}{"bar": 1}}).Pluck(map[interface{}]interface{}{"foo": map[interface{}]interface{}{"bar": "buzz"}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #466")
	}

	{
		// transformation.yaml line #470
		/* {'id':0,'a':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "a": 0}
		/* tbl.without().order_by('id').nth(0) */

		suite.T().Log("About to run line #470: tbl.Without().OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.Without().OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #470")
	}

	{
		// transformation.yaml line #473
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl.without('a').order_by('id').nth(0) */

		suite.T().Log("About to run line #473: tbl.Without('a').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.Without("a").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #473")
	}

	{
		// transformation.yaml line #476
		/* {} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{}
		/* tbl.without('id', 'a').nth(0) */

		suite.T().Log("About to run line #476: tbl.Without('id', 'a').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.Without("id", "a").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #476")
	}

	{
		// transformation.yaml line #479
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl.without('a', 'missing').order_by('id').nth(0) */

		suite.T().Log("About to run line #479: tbl.Without('a', 'missing').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl.Without("a", "missing").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #479")
	}

	{
		// transformation.yaml line #482
		/* {'id':0, 'b':{}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "b": map[interface{}]interface{}{}}
		/* tbl3.without('a', {'b':'c'}).order_by('id').nth(0) */

		suite.T().Log("About to run line #482: tbl3.Without('a', map[interface{}]interface{}{'b': 'c', }).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Without("a", map[interface{}]interface{}{"b": "c"}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #482")
	}

	{
		// transformation.yaml line #485
		/* {'id':0, 'b':{}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "b": map[interface{}]interface{}{}}
		/* tbl3.without(['a', {'b':'c'}]).order_by('id').nth(0) */

		suite.T().Log("About to run line #485: tbl3.Without([]interface{}{'a', map[interface{}]interface{}{'b': 'c', }}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Without([]interface{}{"a", map[interface{}]interface{}{"b": "c"}}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #485")
	}

	{
		// transformation.yaml line #488
		/* {'id':0, 'b':{'c':0}} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0, "b": map[interface{}]interface{}{"c": 0}}
		/* tbl3.without(['a', {'b':'d'}]).order_by('id').nth(0) */

		suite.T().Log("About to run line #488: tbl3.Without([]interface{}{'a', map[interface{}]interface{}{'b': 'd', }}).OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Without([]interface{}{"a", map[interface{}]interface{}{"b": "d"}}).OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #488")
	}

	{
		// transformation.yaml line #492
		/* 200 */
		var expected_ int = 200
		/* tbl.union(tbl2).count() */

		suite.T().Log("About to run line #492: tbl.Union(tbl2).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Union(tbl2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #492")
	}

	{
		// transformation.yaml line #494
		/* 103 */
		var expected_ int = 103
		/* tbl.union([1,2,3]).count() */

		suite.T().Log("About to run line #494: tbl.Union([]interface{}{1, 2, 3}).Count()")

		runAndAssert(suite.Suite, expected_, tbl.Union([]interface{}{1, 2, 3}).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #494")
	}

	{
		// transformation.yaml line #496
		/* 103 */
		var expected_ int = 103
		/* r.expr([1,2,3]).union(tbl2).count() */

		suite.T().Log("About to run line #496: r.Expr([]interface{}{1, 2, 3}).Union(tbl2).Count()")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2, 3}).Union(tbl2).Count(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #496")
	}

	// transformation.yaml line #500
	// ord = tbl.order_by('id')
	suite.T().Log("Possibly executing: var ord r.Term = tbl.OrderBy('id')")

	ord := tbl.OrderBy("id")
	_ = ord // Prevent any noused variable errors

	{
		// transformation.yaml line #502
		/* [0,1] */
		var expected_ []interface{} = []interface{}{0, 1}
		/* ord.offsets_of(r.row['id'] < 2) */

		suite.T().Log("About to run line #502: ord.OffsetsOf(r.Row.AtIndex('id').Lt(2))")

		runAndAssert(suite.Suite, expected_, ord.OffsetsOf(r.Row.AtIndex("id").Lt(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #502")
	}

	{
		// transformation.yaml line #506
		/* [2] */
		var expected_ []interface{} = []interface{}{2}
		/* r.expr([1,2,3,4]).offsets_of(3) */

		suite.T().Log("About to run line #506: r.Expr([]interface{}{1, 2, 3, 4}).OffsetsOf(3)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2, 3, 4}).OffsetsOf(3), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #506")
	}

	{
		// transformation.yaml line #509
		/* err('ReqlQueryLogicError', 'Expected type DATUM but found TABLE:', []) */
		var expected_ Err = err("ReqlQueryLogicError", "Expected type DATUM but found TABLE:")
		/* r.expr([1]).offsets_of(tbl) */

		suite.T().Log("About to run line #509: r.Expr([]interface{}{1}).OffsetsOf(tbl)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1}).OffsetsOf(tbl), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #509")
	}

	{
		// transformation.yaml line #512
		/* [1] */
		var expected_ []interface{} = []interface{}{1}
		/* r.expr(1).do(lambda x: r.expr([2,1,0]).offsets_of(x)) */

		suite.T().Log("About to run line #512: r.Expr(1).Do(func(x r.Term) interface{} { return r.Expr([]interface{}{2, 1, 0}).OffsetsOf(x)})")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Do(func(x r.Term) interface{} { return r.Expr([]interface{}{2, 1, 0}).OffsetsOf(x) }), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #512")
	}

	{
		// transformation.yaml line #518
		/* true */
		var expected_ bool = true
		/* tbl.contains(tbl[0]) */

		suite.T().Log("About to run line #518: tbl.Contains(tbl.AtIndex(0))")

		runAndAssert(suite.Suite, expected_, tbl.Contains(tbl.AtIndex(0)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #518")
	}

	{
		// transformation.yaml line #521
		/* false */
		var expected_ bool = false
		/* tbl.contains(tbl[0].pluck('id')) */

		suite.T().Log("About to run line #521: tbl.Contains(tbl.AtIndex(0).Pluck('id'))")

		runAndAssert(suite.Suite, expected_, tbl.Contains(tbl.AtIndex(0).Pluck("id")), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #521")
	}

	{
		// transformation.yaml line #533
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.filter({'b':{'c':0}}).pluck('id').order_by('id').nth(0) */

		suite.T().Log("About to run line #533: tbl3.Filter(map[interface{}]interface{}{'b': map[interface{}]interface{}{'c': 0, }, }).Pluck('id').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Filter(map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 0}}).Pluck("id").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #533")
	}

	{
		// transformation.yaml line #536
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* tbl3.filter({'b':{'c':6}}) */

		suite.T().Log("About to run line #536: tbl3.Filter(map[interface{}]interface{}{'b': map[interface{}]interface{}{'c': 6, }, })")

		runAndAssert(suite.Suite, expected_, tbl3.Filter(map[interface{}]interface{}{"b": map[interface{}]interface{}{"c": 6}}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #536")
	}

	{
		// transformation.yaml line #539
		/* [] */
		var expected_ []interface{} = []interface{}{}
		/* tbl3.filter(r.literal({'id':0})) */

		suite.T().Log("About to run line #539: tbl3.Filter(r.Literal(map[interface{}]interface{}{'id': 0, }))")

		runAndAssert(suite.Suite, expected_, tbl3.Filter(r.Literal(map[interface{}]interface{}{"id": 0})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #539")
	}

	{
		// transformation.yaml line #542
		/* {'id':0} */
		var expected_ map[interface{}]interface{} = map[interface{}]interface{}{"id": 0}
		/* tbl3.filter({'b':r.literal({'c':0})}).pluck('id').order_by('id').nth(0) */

		suite.T().Log("About to run line #542: tbl3.Filter(map[interface{}]interface{}{'b': r.Literal(map[interface{}]interface{}{'c': 0, }), }).Pluck('id').OrderBy('id').Nth(0)")

		runAndAssert(suite.Suite, expected_, tbl3.Filter(map[interface{}]interface{}{"b": r.Literal(map[interface{}]interface{}{"c": 0})}).Pluck("id").OrderBy("id").Nth(0), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #542")
	}
}
