package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMix invokes the airec.ListMix API synchronously
// api document: https://help.aliyun.com/api/airec/listmix.html
func (client *Client) ListMix(request *ListMixRequest) (response *ListMixResponse, err error) {
	response = CreateListMixResponse()
	err = client.DoAction(request, response)
	return
}

// ListMixWithChan invokes the airec.ListMix API asynchronously
// api document: https://help.aliyun.com/api/airec/listmix.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMixWithChan(request *ListMixRequest) (<-chan *ListMixResponse, <-chan error) {
	responseChan := make(chan *ListMixResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMix(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMixWithCallback invokes the airec.ListMix API asynchronously
// api document: https://help.aliyun.com/api/airec/listmix.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListMixWithCallback(request *ListMixRequest, callback func(response *ListMixResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMixResponse
		var err error
		defer close(result)
		response, err = client.ListMix(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMixRequest is the request struct for api ListMix
type ListMixRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListMixResponse is the response struct for api ListMix
type ListMixResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Code      string       `json:"Code" xml:"Code"`
	Message   string       `json:"Message" xml:"Message"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListMixRequest creates a request to invoke ListMix API
func CreateListMixRequest() (request *ListMixRequest) {
	request = &ListMixRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "ListMix", "/openapi/instances/[InstanceId]/mixes", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListMixResponse creates a response to parse from ListMix response
func CreateListMixResponse() (response *ListMixResponse) {
	response = &ListMixResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
