package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBlockchainApply invokes the baas.CreateBlockchainApply API synchronously
// api document: https://help.aliyun.com/api/baas/createblockchainapply.html
func (client *Client) CreateBlockchainApply(request *CreateBlockchainApplyRequest) (response *CreateBlockchainApplyResponse, err error) {
	response = CreateCreateBlockchainApplyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBlockchainApplyWithChan invokes the baas.CreateBlockchainApply API asynchronously
// api document: https://help.aliyun.com/api/baas/createblockchainapply.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBlockchainApplyWithChan(request *CreateBlockchainApplyRequest) (<-chan *CreateBlockchainApplyResponse, <-chan error) {
	responseChan := make(chan *CreateBlockchainApplyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBlockchainApply(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBlockchainApplyWithCallback invokes the baas.CreateBlockchainApply API asynchronously
// api document: https://help.aliyun.com/api/baas/createblockchainapply.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBlockchainApplyWithCallback(request *CreateBlockchainApplyRequest, callback func(response *CreateBlockchainApplyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBlockchainApplyResponse
		var err error
		defer close(result)
		response, err = client.CreateBlockchainApply(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBlockchainApplyRequest is the request struct for api CreateBlockchainApply
type CreateBlockchainApplyRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Body" name:"Size"`
	MachineNum requests.Integer `position:"Body" name:"MachineNum"`
	LiveTime   requests.Integer `position:"Body" name:"LiveTime"`
	Bizid      string           `position:"Body" name:"Bizid"`
}

// CreateBlockchainApplyResponse is the response struct for api CreateBlockchainApply
type CreateBlockchainApplyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateCreateBlockchainApplyRequest creates a request to invoke CreateBlockchainApply API
func CreateCreateBlockchainApplyRequest() (request *CreateBlockchainApplyRequest) {
	request = &CreateBlockchainApplyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "CreateBlockchainApply", "", "")
	return
}

// CreateCreateBlockchainApplyResponse creates a response to parse from CreateBlockchainApply response
func CreateCreateBlockchainApplyResponse() (response *CreateBlockchainApplyResponse) {
	response = &CreateBlockchainApplyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
