package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveStreamsBlockList invokes the cdn.DescribeLiveStreamsBlockList API synchronously
// api document: https://help.aliyun.com/api/cdn/describelivestreamsblocklist.html
func (client *Client) DescribeLiveStreamsBlockList(request *DescribeLiveStreamsBlockListRequest) (response *DescribeLiveStreamsBlockListResponse, err error) {
	response = CreateDescribeLiveStreamsBlockListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveStreamsBlockListWithChan invokes the cdn.DescribeLiveStreamsBlockList API asynchronously
// api document: https://help.aliyun.com/api/cdn/describelivestreamsblocklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsBlockListWithChan(request *DescribeLiveStreamsBlockListRequest) (<-chan *DescribeLiveStreamsBlockListResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveStreamsBlockListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveStreamsBlockList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveStreamsBlockListWithCallback invokes the cdn.DescribeLiveStreamsBlockList API asynchronously
// api document: https://help.aliyun.com/api/cdn/describelivestreamsblocklist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLiveStreamsBlockListWithCallback(request *DescribeLiveStreamsBlockListRequest, callback func(response *DescribeLiveStreamsBlockListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveStreamsBlockListResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveStreamsBlockList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveStreamsBlockListRequest is the request struct for api DescribeLiveStreamsBlockList
type DescribeLiveStreamsBlockListRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveStreamsBlockListResponse is the response struct for api DescribeLiveStreamsBlockList
type DescribeLiveStreamsBlockListResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	DomainName string     `json:"DomainName" xml:"DomainName"`
	StreamUrls StreamUrls `json:"StreamUrls" xml:"StreamUrls"`
}

// CreateDescribeLiveStreamsBlockListRequest creates a request to invoke DescribeLiveStreamsBlockList API
func CreateDescribeLiveStreamsBlockListRequest() (request *DescribeLiveStreamsBlockListRequest) {
	request = &DescribeLiveStreamsBlockListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2014-11-11", "DescribeLiveStreamsBlockList", "", "")
	return
}

// CreateDescribeLiveStreamsBlockListResponse creates a response to parse from DescribeLiveStreamsBlockList response
func CreateDescribeLiveStreamsBlockListResponse() (response *DescribeLiveStreamsBlockListResponse) {
	response = &DescribeLiveStreamsBlockListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
