package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchInsertItems invokes the cloudesl.BatchInsertItems API synchronously
// api document: https://help.aliyun.com/api/cloudesl/batchinsertitems.html
func (client *Client) BatchInsertItems(request *BatchInsertItemsRequest) (response *BatchInsertItemsResponse, err error) {
	response = CreateBatchInsertItemsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchInsertItemsWithChan invokes the cloudesl.BatchInsertItems API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/batchinsertitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchInsertItemsWithChan(request *BatchInsertItemsRequest) (<-chan *BatchInsertItemsResponse, <-chan error) {
	responseChan := make(chan *BatchInsertItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchInsertItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchInsertItemsWithCallback invokes the cloudesl.BatchInsertItems API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/batchinsertitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchInsertItemsWithCallback(request *BatchInsertItemsRequest, callback func(response *BatchInsertItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchInsertItemsResponse
		var err error
		defer close(result)
		response, err = client.BatchInsertItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchInsertItemsRequest is the request struct for api BatchInsertItems
type BatchInsertItemsRequest struct {
	*requests.RpcRequest
	ItemInfo *[]BatchInsertItemsItemInfo `position:"Body" name:"ItemInfo"  type:"Repeated"`
	StoreId  string                      `position:"Query" name:"StoreId"`
}

// BatchInsertItemsItemInfo is a repeated param struct in BatchInsertItemsRequest
type BatchInsertItemsItemInfo struct {
	MemberPrice       string `name:"MemberPrice"`
	ActionPrice       string `name:"ActionPrice"`
	ProductionPlace   string `name:"ProductionPlace"`
	BeSourceCode      string `name:"BeSourceCode"`
	StoreId           string `name:"StoreId"`
	BrandName         string `name:"BrandName"`
	PromotionStart    string `name:"PromotionStart"`
	SourceCode        string `name:"SourceCode"`
	ItemId            string `name:"ItemId"`
	ExtraAttribute    string `name:"ExtraAttribute"`
	CompanyId         string `name:"CompanyId"`
	PriceUnit         string `name:"PriceUnit"`
	Rank              string `name:"Rank"`
	ItemBarCode       string `name:"ItemBarCode"`
	BePromotion       string `name:"BePromotion"`
	PromotionEnd      string `name:"PromotionEnd"`
	ItemTitle         string `name:"ItemTitle"`
	OriginalPrice     string `name:"OriginalPrice"`
	ItemShortTitle    string `name:"ItemShortTitle"`
	CustomizeFeatureC string `name:"CustomizeFeatureC"`
	ItemQrCode        string `name:"ItemQrCode"`
	CustomizeFeatureD string `name:"CustomizeFeatureD"`
	PromotionReason   string `name:"PromotionReason"`
	CustomizeFeatureE string `name:"CustomizeFeatureE"`
	CustomizeFeatureF string `name:"CustomizeFeatureF"`
	ForestSecondId    string `name:"ForestSecondId"`
	CustomizeFeatureG string `name:"CustomizeFeatureG"`
	CustomizeFeatureH string `name:"CustomizeFeatureH"`
	CustomizeFeatureI string `name:"CustomizeFeatureI"`
	CustomizeFeatureJ string `name:"CustomizeFeatureJ"`
	OptionGroups      string `name:"OptionGroups"`
	ModelNumber       string `name:"ModelNumber"`
	SaleSpec          string `name:"SaleSpec"`
	CustomizeFeatureA string `name:"CustomizeFeatureA"`
	CustomizeFeatureB string `name:"CustomizeFeatureB"`
	SuggestPrice      string `name:"SuggestPrice"`
	ForestFirstId     string `name:"ForestFirstId"`
	CategoryName      string `name:"CategoryName"`
	EnergyEfficiency  string `name:"EnergyEfficiency"`
	SkuId             string `name:"SkuId"`
	PromotionText     string `name:"PromotionText"`
}

// BatchInsertItemsResponse is the response struct for api BatchInsertItems
type BatchInsertItemsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	Message      string       `json:"Message" xml:"Message"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	BatchResults BatchResults `json:"BatchResults" xml:"BatchResults"`
}

// CreateBatchInsertItemsRequest creates a request to invoke BatchInsertItems API
func CreateBatchInsertItemsRequest() (request *BatchInsertItemsRequest) {
	request = &BatchInsertItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "BatchInsertItems", "", "")
	return
}

// CreateBatchInsertItemsResponse creates a response to parse from BatchInsertItems response
func CreateBatchInsertItemsResponse() (response *BatchInsertItemsResponse) {
	response = &BatchInsertItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
