package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AccessKeyGet invokes the cms.AccessKeyGet API synchronously
// api document: https://help.aliyun.com/api/cms/accesskeyget.html
func (client *Client) AccessKeyGet(request *AccessKeyGetRequest) (response *AccessKeyGetResponse, err error) {
	response = CreateAccessKeyGetResponse()
	err = client.DoAction(request, response)
	return
}

// AccessKeyGetWithChan invokes the cms.AccessKeyGet API asynchronously
// api document: https://help.aliyun.com/api/cms/accesskeyget.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AccessKeyGetWithChan(request *AccessKeyGetRequest) (<-chan *AccessKeyGetResponse, <-chan error) {
	responseChan := make(chan *AccessKeyGetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AccessKeyGet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AccessKeyGetWithCallback invokes the cms.AccessKeyGet API asynchronously
// api document: https://help.aliyun.com/api/cms/accesskeyget.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AccessKeyGetWithCallback(request *AccessKeyGetRequest, callback func(response *AccessKeyGetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AccessKeyGetResponse
		var err error
		defer close(result)
		response, err = client.AccessKeyGet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AccessKeyGetRequest is the request struct for api AccessKeyGet
type AccessKeyGetRequest struct {
	*requests.RpcRequest
	UserId requests.Integer `position:"Query" name:"UserId"`
}

// AccessKeyGetResponse is the response struct for api AccessKeyGet
type AccessKeyGetResponse struct {
	*responses.BaseResponse
	ErrorCode    int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	UserId       int    `json:"UserId" xml:"UserId"`
	AccessKey    string `json:"AccessKey" xml:"AccessKey"`
	SecretKey    string `json:"SecretKey" xml:"SecretKey"`
}

// CreateAccessKeyGetRequest creates a request to invoke AccessKeyGet API
func CreateAccessKeyGetRequest() (request *AccessKeyGetRequest) {
	request = &AccessKeyGetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "AccessKeyGet", "cms", "openAPI")
	return
}

// CreateAccessKeyGetResponse creates a response to parse from AccessKeyGet response
func CreateAccessKeyGetResponse() (response *AccessKeyGetResponse) {
	response = &AccessKeyGetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
