package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEventRule invokes the cms.DescribeEventRule API synchronously
// api document: https://help.aliyun.com/api/cms/describeeventrule.html
func (client *Client) DescribeEventRule(request *DescribeEventRuleRequest) (response *DescribeEventRuleResponse, err error) {
	response = CreateDescribeEventRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEventRuleWithChan invokes the cms.DescribeEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/describeeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventRuleWithChan(request *DescribeEventRuleRequest) (<-chan *DescribeEventRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeEventRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEventRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEventRuleWithCallback invokes the cms.DescribeEventRule API asynchronously
// api document: https://help.aliyun.com/api/cms/describeeventrule.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEventRuleWithCallback(request *DescribeEventRuleRequest, callback func(response *DescribeEventRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEventRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeEventRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEventRuleRequest is the request struct for api DescribeEventRule
type DescribeEventRuleRequest struct {
	*requests.RpcRequest
	RuleName string `position:"Query" name:"RuleName"`
}

// DescribeEventRuleResponse is the response struct for api DescribeEventRule
type DescribeEventRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeEventRuleRequest creates a request to invoke DescribeEventRule API
func CreateDescribeEventRuleRequest() (request *DescribeEventRuleRequest) {
	request = &DescribeEventRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "DescribeEventRule", "cms", "openAPI")
	return
}

// CreateDescribeEventRuleResponse creates a response to parse from DescribeEventRule response
func CreateDescribeEventRuleResponse() (response *DescribeEventRuleResponse) {
	response = &DescribeEventRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
