package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMetricTop invokes the cms.QueryMetricTop API synchronously
// api document: https://help.aliyun.com/api/cms/querymetrictop.html
func (client *Client) QueryMetricTop(request *QueryMetricTopRequest) (response *QueryMetricTopResponse, err error) {
	response = CreateQueryMetricTopResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMetricTopWithChan invokes the cms.QueryMetricTop API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetrictop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricTopWithChan(request *QueryMetricTopRequest) (<-chan *QueryMetricTopResponse, <-chan error) {
	responseChan := make(chan *QueryMetricTopResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMetricTop(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMetricTopWithCallback invokes the cms.QueryMetricTop API asynchronously
// api document: https://help.aliyun.com/api/cms/querymetrictop.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryMetricTopWithCallback(request *QueryMetricTopRequest, callback func(response *QueryMetricTopResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMetricTopResponse
		var err error
		defer close(result)
		response, err = client.QueryMetricTop(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMetricTopRequest is the request struct for api QueryMetricTop
type QueryMetricTopRequest struct {
	*requests.RpcRequest
	Period          string           `position:"Query" name:"Period"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Metric          string           `position:"Query" name:"Metric"`
	Length          string           `position:"Query" name:"Length"`
	Project         string           `position:"Query" name:"Project"`
	EndTime         string           `position:"Query" name:"EndTime"`
	Orderby         string           `position:"Query" name:"Orderby"`
	Express         string           `position:"Query" name:"Express"`
	StartTime       string           `position:"Query" name:"StartTime"`
	Dimensions      string           `position:"Query" name:"Dimensions"`
	OrderDesc       string           `position:"Query" name:"OrderDesc"`
}

// QueryMetricTopResponse is the response struct for api QueryMetricTop
type QueryMetricTopResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Datapoints string `json:"Datapoints" xml:"Datapoints"`
	Period     string `json:"Period" xml:"Period"`
}

// CreateQueryMetricTopRequest creates a request to invoke QueryMetricTop API
func CreateQueryMetricTopRequest() (request *QueryMetricTopRequest) {
	request = &QueryMetricTopRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QueryMetricTop", "cms", "openAPI")
	return
}

// CreateQueryMetricTopResponse creates a response to parse from QueryMetricTop response
func CreateQueryMetricTopResponse() (response *QueryMetricTopResponse) {
	response = &QueryMetricTopResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
