package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySystemEventHistogram invokes the cms.QuerySystemEventHistogram API synchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventhistogram.html
func (client *Client) QuerySystemEventHistogram(request *QuerySystemEventHistogramRequest) (response *QuerySystemEventHistogramResponse, err error) {
	response = CreateQuerySystemEventHistogramResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySystemEventHistogramWithChan invokes the cms.QuerySystemEventHistogram API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventhistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventHistogramWithChan(request *QuerySystemEventHistogramRequest) (<-chan *QuerySystemEventHistogramResponse, <-chan error) {
	responseChan := make(chan *QuerySystemEventHistogramResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySystemEventHistogram(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySystemEventHistogramWithCallback invokes the cms.QuerySystemEventHistogram API asynchronously
// api document: https://help.aliyun.com/api/cms/querysystemeventhistogram.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QuerySystemEventHistogramWithCallback(request *QuerySystemEventHistogramRequest, callback func(response *QuerySystemEventHistogramResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySystemEventHistogramResponse
		var err error
		defer close(result)
		response, err = client.QuerySystemEventHistogram(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySystemEventHistogramRequest is the request struct for api QuerySystemEventHistogram
type QuerySystemEventHistogramRequest struct {
	*requests.RpcRequest
	QueryJson string `position:"Query" name:"QueryJson"`
}

// QuerySystemEventHistogramResponse is the response struct for api QuerySystemEventHistogram
type QuerySystemEventHistogramResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateQuerySystemEventHistogramRequest creates a request to invoke QuerySystemEventHistogram API
func CreateQuerySystemEventHistogramRequest() (request *QuerySystemEventHistogramRequest) {
	request = &QuerySystemEventHistogramRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "QuerySystemEventHistogram", "cms", "openAPI")
	return
}

// CreateQuerySystemEventHistogramResponse creates a response to parse from QuerySystemEventHistogram response
func CreateQuerySystemEventHistogramResponse() (response *QuerySystemEventHistogramResponse) {
	response = &QuerySystemEventHistogramResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
