package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClusterServices invokes the cs.DescribeClusterServices API synchronously
// api document: https://help.aliyun.com/api/cs/describeclusterservices.html
func (client *Client) DescribeClusterServices(request *DescribeClusterServicesRequest) (response *DescribeClusterServicesResponse, err error) {
	response = CreateDescribeClusterServicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClusterServicesWithChan invokes the cs.DescribeClusterServices API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServicesWithChan(request *DescribeClusterServicesRequest) (<-chan *DescribeClusterServicesResponse, <-chan error) {
	responseChan := make(chan *DescribeClusterServicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClusterServices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClusterServicesWithCallback invokes the cs.DescribeClusterServices API asynchronously
// api document: https://help.aliyun.com/api/cs/describeclusterservices.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeClusterServicesWithCallback(request *DescribeClusterServicesRequest, callback func(response *DescribeClusterServicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClusterServicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeClusterServices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClusterServicesRequest is the request struct for api DescribeClusterServices
type DescribeClusterServicesRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// DescribeClusterServicesResponse is the response struct for api DescribeClusterServices
type DescribeClusterServicesResponse struct {
	*responses.BaseResponse
}

// CreateDescribeClusterServicesRequest creates a request to invoke DescribeClusterServices API
func CreateDescribeClusterServicesRequest() (request *DescribeClusterServicesRequest) {
	request = &DescribeClusterServicesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeClusterServices", "/clusters/[ClusterId]/services", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeClusterServicesResponse creates a response to parse from DescribeClusterServices response
func CreateDescribeClusterServicesResponse() (response *DescribeClusterServicesResponse) {
	response = &DescribeClusterServicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
